/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.transforms.queues.impl.MQLog;
import com.sas.etl.models.job.transforms.queues.impl.MQROOT;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MQCONN
extends MQROOT {
    public static final String MQCONN_Connect_Comment_notrans = "MQCONN: Connects base SAS to a MQSeries queue manager";
    public static final String MQCONN_Failure_Comment_notrans = "MQCONN failure conditions";
    public static final String MQCONN_ErrorConnecting_Error_txt = "MQCONN: Error connecting";

    public MQCONN(ICodeSegment cgReq, boolean bQueueWriter, HashMap hmUserInput) throws MdException, RemoteException {
        super(cgReq, bQueueWriter, hmUserInput);
    }

    public void generateLengthStatements() {
        this.addBlankLine();
        this.addRBComment("SASVAR_CONNECTION_HANDLE");
        this.addLengthStatement("etls_hconn", true, "8");
        this.addBlankLine();
        this.addRBComment("SASVAR_COMPLETION_CODE");
        this.addLengthStatement("etls_compcode", true, "8");
        this.addBlankLine();
        this.addRBComment("SASVAR_REASON_CODE");
        this.addLengthStatement("etls_qrc", true, "8");
    }

    public void generateAssignmentStatements() {
        this.addBlankLine();
        this.assignVariable("EMQ_QUEUEMANAGERNAME", "etls_queuemanagername", this.getQueueManagerName(), true);
        this.addBlankLine();
    }

    public void generateFunctionCall() {
        this.addBlankLine();
        this.m_cg.addCommentLine(MQCONN_Connect_Comment_notrans);
        this.buildFunctionCall(this.getFunctionParms());
        this.addFailConditions();
    }

    public List getFunctionParms() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("etls_queuemanagername");
        list.add("etls_hconn");
        list.add("etls_compcode");
        list.add("etls_qrc");
        return list;
    }

    private void addFailConditions() {
        this.m_cg.addCommentLine(MQCONN_Failure_Comment_notrans);
        this.addString("if ");
        this.addString("etls_compcode");
        this.addString(" ^= 0 then \ndo;\n");
        this.m_cg.indent();
        this.m_cg.genRCSetDSCall("8000", true);
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2002 then \ndo; \n");
        String msgString = MQLog.formatString("Reason Code 2002. Already connected to queue manager {0}.", this.getQueueManagerName());
        this.m_cg.indent();
        this.m_cg.genPutStatement(msgString, "ERROR%QUOTE(:)");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \n");
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2018 then \ndo;\n");
        this.m_cg.indent();
        msgString = MQLog.formatString("Reason Code 2018. Connection handle is invalid. A connection handle that is created by an MQCONN call must be used within the same DATA step where it was created.", this.getQueueManagerName());
        this.m_cg.genPutStatement(msgString, "ERROR%QUOTE(:)");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \n");
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2035 then \ndo;\n");
        this.m_cg.indent();
        msgString = MQLog.formatString("Reason Code 2035. User is not authorized to perform the attempted action. Verify that you are connecting to the correct queue and queue manager. Verify that you are authorized to connect to the queue manager. If error is reported to a client connecting to a queue manager, you might need to set the user ID under the MCA tab in the server connection channel definition properties to a user ID that has permission to access the queue manager on the server machine.", this.getQueueManagerName());
        this.m_cg.genPutStatement(msgString, "ERROR%QUOTE(:)");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \n");
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2058 then \ndo;\n");
        this.m_cg.indent();
        msgString = MQLog.formatString("Reason Code 2058. Error in Queue Manager Name {0}. Check spelling and case of the queue manager name that is used in the application and is defined in the queue manager.", this.getQueueManagerName());
        this.m_cg.genPutStatement(msgString, "ERROR%QUOTE(:)");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \n");
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2059 then \ndo;\n");
        this.m_cg.indent();
        msgString = MQLog.formatString("Reason Code 2059. Queue Manager {0} is not available. Restart the queue manager.", this.getQueueManagerName());
        this.m_cg.genPutStatement(msgString, "ERROR%QUOTE(:)");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \ndo;\n");
        this.m_cg.indent();
        msgString = "Please refer to Websphere MQ Application Programming Reference (http://www-306.ibm.com/software/integration/wmq/library/).";
        this.m_cg.genPutStatement(msgString, "ERROR%QUOTE(:)", "etls_qrc", false);
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addBlankLine();
        this.m_cg.addSourceCode("etls_qmessage");
        this.m_cg.addSourceCode(" = sysmsg();\n");
        this.m_cg.genPutStatement(MQCONN_ErrorConnecting_Error_txt, "ERROR%QUOTE(:)", "etls_qmessage", false);
        this.addExitLine();
        this.m_cg.unIndent();
        this.addString("end;\n");
    }
}

