/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.queues.impl.CommonQueueTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.IBMWSQWriterTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.MQCONN;
import com.sas.etl.models.job.transforms.queues.impl.MQINQ;
import com.sas.etl.models.job.transforms.queues.impl.MQLog;
import com.sas.etl.models.job.transforms.queues.impl.MQMAP;
import com.sas.etl.models.job.transforms.queues.impl.MQMD;
import com.sas.etl.models.job.transforms.queues.impl.MQOD;
import com.sas.etl.models.job.transforms.queues.impl.MQOPEN;
import com.sas.etl.models.job.transforms.queues.impl.MQPMO;
import com.sas.etl.models.job.transforms.queues.impl.MQPUT;
import com.sas.etl.models.job.transforms.queues.impl.MQROOT;
import com.sas.etl.models.job.transforms.queues.impl.MQSETPARMS;
import com.sas.etl.models.job.transforms.queues.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public class IBMWSQWriterCodegen {
    public static final String IBMWSQWriterCodegen_CheckMessageTrunc_Comment_notrans = "Check for message truncation";
    public static final String IBMWSQWriterCodegen_MsgLengthInput_put_notrans = "Message truncated.  Message length input by user is:";
    public static final String IBMWSQWriterCodegen_MsgLengthMinimum_put_notrans = "Minimum message length required is:";
    public static final String IBMWSQWriterCodegen_MsgWrittenToQueue_put_notrans = "Message written to queue is:";
    public static final String IBMWSQWriterCodegen_DefaultCorrelid_notrans = "46696C65212121008F00";
    public static final String IBMWSQWriterCodegen_EmbedLength_Comment_notrans = "Set length of this record embedded as first byte of message";
    public static final String IBMWSQWriterCodegen_GenerateMsgid_Comment_notrans = "Set correlation id and let MQ generate msgid for this message";
    public static final String IBMWSQWriterCodegen_AddSequenceNumber_Comment_notrans = "Add sequence number to correlation id";
    public static final String IBMWSQWriterCodegen_MQFREE_Comment_notrans = "Free data";
    public static final String IBMWSQWriterCodegen_ResetMsgBuffer_Comment_notrans = "Reset message buffer entities";
    public static final String IBMWSQWriterCodegen_NoTargetQueue_msg_txt = "This transformation must have a Queue object as target.";
    public static final String IBMWSQWriterCodegen_NoFileSpecified_msg_txt = "A file to read from must be specified when a file is to be sent to queue";
    public static final String IBMWSQWriterCodegen_NoMessage_txt = "Message to be written to queue is blank";
    public static final String IBMWSQWriterCodegen_InsuffLength_fmt_txt = "Specified length of {0} is insufficient for sending message of length {1}.  Do you want to correct the length?";
    public static final String IBMWSQReader_TableWithNoColumns_exception_fmt_txt = "The table {0} has no columns.";

    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment, IBMWSQWriterTransformModel oIBMWSQWriterTransformModel) throws CodegenException, RemoteException, MdException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException {
        oIBMWSQWriterTransformModel.loadOptions();
        HashMap hmUserInput = oIBMWSQWriterTransformModel.getOptions();
        MQROOT.setMQGlobalVariables(codeSegment, hmUserInput);
        MQROOT.setDefaultMacroOptions(hmUserInput);
        if (oIBMWSQWriterTransformModel.isTextMessage()) {
            IBMWSQWriterCodegen.writeTextToQueue(codeSegment, oIBMWSQWriterTransformModel, hmUserInput);
        } else if (oIBMWSQWriterTransformModel.isTableMessage()) {
            IBMWSQWriterCodegen.writeTableToQueue(codeSegment, oIBMWSQWriterTransformModel, hmUserInput);
        } else if (oIBMWSQWriterTransformModel.isFileMessage()) {
            IBMWSQWriterCodegen.writeFileToQueueV51(codeSegment, oIBMWSQWriterTransformModel, hmUserInput);
        } else {
            oIBMWSQWriterTransformModel.loadOptions();
            hmUserInput = oIBMWSQWriterTransformModel.getOptions();
            IBMWSQWriterCodegen.writeTextToQueue(codeSegment, oIBMWSQWriterTransformModel, hmUserInput);
        }
        codeSegment.genRCSetCall("&syserr");
        codeSegment.genCodeConditionCheck(codeSegment, "DIS_CSUCCESSFUL", oIBMWSQWriterTransformModel, null);
        codeSegment.genCodeConditionCheck(codeSegment, "DIS_CWARNINGS", oIBMWSQWriterTransformModel, null);
        codeSegment.genCodeConditionCheck(codeSegment, "DIS_CERRORS", oIBMWSQWriterTransformModel, null);
        return codeSegment;
    }

    private static void writeTextToQueue(ICodeSegment codeSegment, CommonQueueTransformModel oCommonQModel, HashMap hmUserInput) throws MdException, RemoteException {
        CommonQueueTransformModel.textMessageToMacroVariable(oCommonQModel, codeSegment);
        codeSegment.addSourceCode("data _null_;\n");
        codeSegment.indent();
        MQROOT mqROOT = new MQROOT(codeSegment, true, hmUserInput);
        mqROOT.addLengthForParametersAndOptions();
        codeSegment.addSourceCode("etls_inplength = length(symget('");
        codeSegment.addSourceCode("etls_msg");
        codeSegment.addSourceCode("'));\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addCommentLine(IBMWSQWriterCodegen_CheckMessageTrunc_Comment_notrans);
        codeSegment.addSourceCode("if (etls_inplength >");
        codeSegment.addSourceCode((String)hmUserInput.get("etls_message_length"));
        codeSegment.addSourceCode(") then\ndo;\n");
        codeSegment.indent();
        codeSegment.genPutStatement(IBMWSQWriterCodegen_MsgLengthInput_put_notrans + (String)hmUserInput.get("etls_message_length"), "NOTE:");
        codeSegment.genPutStatement(IBMWSQWriterCodegen_MsgLengthMinimum_put_notrans, "NOTE:", "etls_inplength", false);
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        MQCONN mqconn = new MQCONN(codeSegment, true, hmUserInput);
        MQOD mqod = new MQOD(codeSegment, true, hmUserInput);
        MQOPEN mqopen = new MQOPEN(codeSegment, true, hmUserInput);
        mqopen.setOption(MQOPEN.OUTPUT);
        MQINQ mqinq = new MQINQ(codeSegment, false, hmUserInput);
        if (mqinq.isOn()) {
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQPMO mqpmo = new MQPMO(codeSegment, true, hmUserInput);
        MQMD mqmd = new MQMD(codeSegment, true, hmUserInput);
        mqmd.readFromTransformationInput();
        MQMAP mqmap = new MQMAP(codeSegment, true, hmUserInput);
        mqmap.setDescriptors();
        MQSETPARMS mqsetparms = new MQSETPARMS(codeSegment, true, hmUserInput);
        mqsetparms.addMessageDescriptor();
        MQPUT mqput = new MQPUT(codeSegment, true, hmUserInput);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqpmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqsetparms.generateLengthStatements();
        mqput.generateLengthStatements();
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqpmo.generateAssignmentStatements();
        mqpmo.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        mqsetparms.generateAssignmentStatements();
        mqsetparms.generateFunctionCall();
        mqput.generateAssignmentStatements();
        mqput.generateFunctionCall();
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        codeSegment.addSourceCode("etls_mqexit");
        codeSegment.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        if (mqROOT.isDebugModeOn()) {
            mqROOT.beginDebug();
            codeSegment.genPutStatement(MQLog.IBMWSQWriterCodegen_MsgWrittenToQueue, "NOTE:", "etls_read", false);
            mqROOT.endDebug();
        }
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    private static void writeTableToQueue(ICodeSegment codeSegment, CommonQueueTransformModel oCommonQModel, HashMap hmUserInput) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException {
        boolean bNeedQuotes = codeSegment.isQuoting();
        IPhysicalTable sourceTable = oCommonQModel.getSourceTable();
        String sourceTableName = sourceTable.getFullNameQuotedAsNeeded(codeSegment);
        IColumn[] sourceColumnList = oCommonQModel.getSourceTable().getColumns();
        if (sourceColumnList.length == 0) {
            String msgString = MQLog.formatString(IBMWSQReader_TableWithNoColumns_exception_fmt_txt, sourceTableName);
            throw new MdException(msgString);
        }
        List listMessageColumns = oCommonQModel.buildMessageColumnsList(sourceColumnList);
        codeSegment.addSourceCode("data _null_;\n").indent();
        codeSegment.addSourceCode("set ");
        codeSegment.addSourceCode(sourceTableName).addSourceCode(" ");
        codeSegment.addSourceCode(oCommonQModel.getTableOptionObject(sourceTable, true).getTableOptions(true, codeSegment.getCurrentServer()));
        codeSegment.addSourceCode(" end=etls_last;\n");
        MQROOT mqROOT = new MQROOT(codeSegment, true, hmUserInput);
        mqROOT.addLengthForParametersAndOptions();
        MQCONN mqconn = new MQCONN(codeSegment, true, hmUserInput);
        MQOD mqod = new MQOD(codeSegment, true, hmUserInput);
        MQOPEN mqopen = new MQOPEN(codeSegment, true, hmUserInput);
        mqopen.setOption("OUTPUT");
        MQINQ mqinq = new MQINQ(codeSegment, false, hmUserInput);
        if (mqinq.isOn()) {
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQPMO mqpmo = new MQPMO(codeSegment, true, hmUserInput);
        MQMAP mqmap = new MQMAP(codeSegment, true, hmUserInput);
        mqmap.setDescriptors(listMessageColumns);
        MQSETPARMS mqsetparms = new MQSETPARMS(codeSegment, true, hmUserInput);
        mqsetparms.addDescriptor(listMessageColumns);
        mqsetparms.setQuoteCols(bNeedQuotes);
        MQMD mqmd = new MQMD(codeSegment, true, hmUserInput);
        mqmd.readFromTransformationInput();
        MQPUT mqput = new MQPUT(codeSegment, true, hmUserInput);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqpmo.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqsetparms.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqput.generateLengthStatements();
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqROOT.generateRetainStatement();
        codeSegment.addSourceCode("if _N_=1 then \ndo;\n");
        codeSegment.indent();
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqpmo.generateAssignmentStatements();
        mqpmo.generateFunctionCall();
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        mqsetparms.generateAssignmentStatements();
        mqsetparms.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        mqput.generateAssignmentStatements();
        mqput.generateFunctionCall();
        mqROOT.freeDataHandles(hmUserInput);
        codeSegment.addSourceCode("etls_mqexit");
        codeSegment.addSourceCode(":\n");
        mqROOT.generateMQBACKCode();
        codeSegment.addSourceCode("if etls_last then \ndo;");
        codeSegment.indent();
        mqROOT.generateSyncPointCode();
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        mqROOT.freeHandles();
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("if etls_compcode>0 then STOP;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }

    private static void writeFileToQueueV51(ICodeSegment codeSegment, CommonQueueTransformModel oCommonQModel, HashMap hmUserInput) throws MdException, RemoteException {
        String sGroupMessages = (String)hmUserInput.get("GROUP_MESSAGES");
        boolean bGroupMessages = true;
        if (sGroupMessages != null && sGroupMessages.compareToIgnoreCase("NO") == 0) {
            bGroupMessages = false;
        }
        MQROOT mqROOT = new MQROOT(codeSegment, true, hmUserInput);
        if (bGroupMessages) {
            MQROOT.setV51SendMacroVars(codeSegment, hmUserInput);
        }
        codeSegment.addSourceCode("data _null_;\n").indent();
        codeSegment.addSourceCode("length etls_correlid $ 48;\n");
        codeSegment.addSourceCode("length etls_correlid2 $ 48;\n");
        codeSegment.addSourceCode("length etls_msgbuf $ ");
        codeSegment.addSourceCode((String)hmUserInput.get("etls_message_length"));
        codeSegment.addSourceCode(";\n");
        codeSegment.addSourceCode("length etls_ui_correlid $48;\n");
        if (hmUserInput.containsKey(MQMD.CORRELID)) {
            codeSegment.addSourceCode("etls_ui_correlid=upcase('");
            codeSegment.addSourceCode((String)hmUserInput.get(MQMD.CORRELID));
            codeSegment.addSourceCode("');\n");
        } else {
            codeSegment.addSourceCode("etls_ui_correlid=\"\";\n");
        }
        if (!bGroupMessages) {
            codeSegment.addSourceCode("length etls_lencorrid 3.;\n");
            codeSegment.addSourceCode("etls_lencorrid =length(etls_ui_correlid);\n");
        }
        mqROOT.addLengthForParametersAndOptions();
        String sFileName = (String)hmUserInput.get("etls_filename");
        codeSegment.addCommentLine("Write file to queue");
        codeSegment.addSourceCode("infile \"");
        codeSegment.addSourceCode(sFileName.trim());
        codeSegment.addSourceCode("\" recfm=f lrecl=1 end=eof;\n");
        mqROOT.assignMacroVariable("SASVAR_BUFFSIZE", "etls_buffsize", (String)hmUserInput.get("etls_message_length"), false);
        MQCONN mqconn = new MQCONN(codeSegment, true, hmUserInput);
        MQOD mqod = new MQOD(codeSegment, true, hmUserInput);
        MQOPEN mqopen = new MQOPEN(codeSegment, true, hmUserInput);
        mqopen.setOption("OUTPUT");
        MQINQ mqinq = new MQINQ(codeSegment, false, hmUserInput);
        if (mqinq.isOn()) {
            mqopen.setOption(MQOPEN.INQUIRE);
        }
        MQPMO mqpmo = new MQPMO(codeSegment, true, hmUserInput);
        if (bGroupMessages) {
            mqpmo.setOption(MQPMO.NEW_MSGID);
            mqpmo.setOption(MQPMO.LOGICAL_ORDER);
        }
        MQMD mqmd = new MQMD(codeSegment, true, hmUserInput);
        mqmd.readFromTransformationInput();
        if (bGroupMessages) {
            mqmd.setValue(MQMD.MSGFLAGS, "&group");
        }
        MQMAP mqmap = new MQMAP(codeSegment, true, hmUserInput);
        mqmap.setDescriptors();
        MQSETPARMS mqsetparms = new MQSETPARMS(codeSegment, true, hmUserInput);
        mqsetparms.addDescriptorForFileWrite();
        MQMD mqmd2 = new MQMD(codeSegment, false, hmUserInput);
        mqmd2.setMQMDVersion("2");
        mqmd2.setAction("SET");
        if (bGroupMessages) {
            mqmd2.setValue(MQMD.MSGFLAGS, "&group + &last_group");
        } else {
            mqmd2.setParameter(MQMD.MSGID);
            mqmd2.setParameter(MQMD.CORRELID);
            mqmd2.setValue(MQMD.MSGID, "");
            mqmd2.setValue(MQMD.CORRELID, (String)hmUserInput.get(MQMD.CORRELID));
            mqmd2.setCharacterQuoting(MQMD.CORRELID, true);
        }
        MQPUT mqput = new MQPUT(codeSegment, true, hmUserInput);
        mqconn.generateLengthStatements();
        mqod.generateLengthStatements();
        mqopen.generateLengthStatements();
        mqpmo.generateLengthStatements();
        mqmd.generateLengthStatements();
        mqmap.generateLengthStatements();
        mqsetparms.generateLengthStatements();
        mqput.generateLengthStatements();
        if (mqinq.isOn()) {
            mqinq.generateLengthStatements();
        }
        mqconn.generateAssignmentStatements();
        mqconn.generateFunctionCall();
        mqod.generateAssignmentStatements();
        mqod.generateFunctionCall();
        mqopen.generateAssignmentStatements();
        mqopen.generateFunctionCall();
        mqpmo.generateAssignmentStatements();
        mqpmo.generateFunctionCall();
        mqmd.generateAssignmentStatements();
        mqmd.generateFunctionCall();
        mqmap.generateAssignmentStatements();
        mqmap.generateFunctionCall();
        String sCorrelid = (String)hmUserInput.get(MQMD.CORRELID);
        if (sCorrelid == null) {
            sCorrelid = "";
        }
        if (sCorrelid.length() > 0) {
            codeSegment.addSourceCode("\n");
            codeSegment.addSourceCode("etls_correlid=etls_ui_correlid;\n");
        }
        codeSegment.addSourceCode("\n");
        if (!bGroupMessages) {
            codeSegment.addSourceCode("etls_seqno = 0;\n");
            codeSegment.addSourceCode("\n");
        }
        codeSegment.addSourceCode("i=0;\n");
        codeSegment.addSourceCode("do until(eof);\n").indent();
        codeSegment.addCommentLine("Read a byte at a time");
        codeSegment.addSourceCode("input x $char1.;\n");
        codeSegment.addSourceCode("i+1;\n");
        codeSegment.addSourceCode("substr(etls_msgbuf,i,1) = x;\n");
        codeSegment.addSourceCode("if( i = &etls_buffSize or eof ) then \ndo;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("if (eof) then \ndo;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("etls_desc=\"CHAR,,\" || put(i,6.);\n");
        codeSegment.addSourceCode("call mqmap(etls_hmap, etls_qrc, etls_desc);\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("\n");
        mqsetparms.generateAssignmentStatements();
        mqsetparms.generateFunctionCall();
        codeSegment.addSourceCode("\n");
        codeSegment.addCommentLine(RB.getStringResource("IBMWSQWriterCodegen.GenerateMsgid.Comment.notrans"));
        mqmd2.generateAssignmentStatements();
        if (bGroupMessages) {
            codeSegment.addSourceCode("if ( eof ) then \ndo;\n");
            codeSegment.indent();
        } else {
            codeSegment.addCommentLine(RB.getStringResource("IBMWSQWriterCodegen.AddSequenceNumber.Comment.notrans"));
            codeSegment.addSourceCode("etls_seqstr = put(etls_seqno, hex4.);\n");
            codeSegment.addSourceCode("substr(etls_correlid2,etls_lencorrid+1,4) = etls_seqstr;\n");
            codeSegment.addSourceCode("etls_seqno+1;\n");
        }
        mqmd2.generateFunctionCall();
        codeSegment.addSourceCode("\n");
        if (bGroupMessages) {
            codeSegment.unIndent();
            codeSegment.addSourceCode("end;\n");
        }
        mqput.generateAssignmentStatements();
        mqput.generateFunctionCall();
        if (mqinq.isOn()) {
            mqinq.generateAssignmentStatements();
            mqinq.generateFunctionCall();
        }
        codeSegment.addSourceCode("\n");
        codeSegment.addCommentLine(RB.getStringResource("IBMWSQWriterCodegen.MQFREE.Comment.notrans"));
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("call mqfree(");
        codeSegment.addSourceCode("etls_hdata");
        codeSegment.addSourceCode(");\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addCommentLine(RB.getStringResource("IBMWSQWriterCodegen.ResetMsgBuffer.Comment.notrans"));
        codeSegment.addSourceCode("i=0;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("end;\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("etls_mqexit");
        codeSegment.addSourceCode(":\n");
        mqROOT.generateSyncPointCode();
        mqROOT.freeHandles();
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n").unIndent();
        if (mqROOT.isDebugModeOn()) {
            mqROOT.addTags();
        }
    }
}

