/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.lookup;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IConditionActionsTemplateJobModel;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.impl.BaseTransformTableOptions;
import com.sas.etl.models.job.transforms.lookup.LookupMappingsContainer;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.etl.models.job.transforms.lookup.RB;
import com.sas.etl.models.other.ICondition;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ConditionActionSet;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class LookupMapping
extends BaseMapping
implements IConditionActionSetContainer {
    public static final String LOOKUP_TRANSFORM_NAME = "LOOKUP";
    public static final String LOOKUP_TRANSFORM_ROLE = "lookup";
    private static final String LOOKUP_TABLE_ASSOC_NAME = "LookupTable";
    private static final String DEFAULTS_KEY = "DefaultLookupConditions2";
    private LookupTransformModel m_lookup;
    private IPhysicalTable m_lookupTable;
    private LookupMappingsContainer m_keyMappings;
    private LookupMappingsContainer m_dataMappings;
    private ModelList m_lConditionActionSets;
    private ArrayList m_lDefinedConditionActionSetUniqueIds;
    private ArrayList m_lTemplateConditionActionSets;
    private ITransformTableOptions m_tableOption;

    public LookupMapping(String sID, IModel model) {
        super(sID, model);
        this.setName(LOOKUP_TRANSFORM_NAME);
        this.setType(LOOKUP_TRANSFORM_ROLE);
        this.m_keyMappings = new LookupMappingsContainer(model.createIDForNewObject(sID), model, this, "lookup key");
        this.m_dataMappings = new LookupMappingsContainer(model.createIDForNewObject(sID), model, this, "lookup data");
        this.m_lConditionActionSets = new ModelList(this, new String[]{"Object:ConditionActionSetAdded", "Object:ConditionActionSetRemoved"}, 3, IConditionActionSet.class);
        this.m_lDefinedConditionActionSetUniqueIds = new ArrayList();
        this.m_lTemplateConditionActionSets = new ArrayList();
        this.createConditionActionSetTemplates();
    }

    protected void createConditionActionSetTemplates() {
        List lDefaultSets = this.getDefinedConditionActionSetUniqueIds();
        lDefaultSets.add("DIS_SETLOOKUPMISS");
        lDefaultSets.add("DIS_SETLOOKUPNOREC");
        lDefaultSets.add("DIS_SETLOOKUPNOFOUND");
    }

    public static String getRole() {
        return LOOKUP_TRANSFORM_ROLE;
    }

    public void setLookupModel(LookupTransformModel lookup) {
        this.m_lookup = lookup;
    }

    public IPhysicalTable getSourceTable() {
        return this.m_lookup.getSourceTable();
    }

    public void setLookupTable(IPhysicalTable lookupTable) {
        if (this.m_lookupTable == lookupTable) {
            return;
        }
        this.m_lookupTable = lookupTable;
        if (lookupTable == null) {
            this.m_keyMappings.removeMappings();
            this.m_dataMappings.removeMappings();
        }
        this.setTransformTableOption(lookupTable != null ? this.createTransformTableOption(lookupTable) : null);
        this.setChanged(true);
    }

    public IPhysicalTable getLookupTable() {
        return this.m_lookupTable;
    }

    protected ITransformTableOptions createTransformTableOption(IPhysicalTable table) {
        BaseTransformTableOptions optionSet = new BaseTransformTableOptions(this.createIDForNewObject(), this.getModel());
        optionSet.setOptionTable(table);
        optionSet.setAccessTypeInput(true);
        optionSet.setOwner(this);
        optionSet.setDisplayName(this.getOptionDisplayName());
        return optionSet;
    }

    public void setTransformTableOption(ITransformTableOptions tableOptions) {
        if (tableOptions == this.m_tableOption) {
            return;
        }
        if (this.m_tableOption != null) {
            this.addToDeletedObjects(this.m_tableOption);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTransformTableOptionUndoable(this.m_tableOption, tableOptions));
        }
        this.m_tableOption = tableOptions;
        if (this.m_tableOption != null) {
            this.removeFromDeletedObjects(this.m_tableOption);
            this.m_tableOption.setOwner(this);
        }
        this.fireModelChangedEvent("DataTransform.TransformTableOptionAddded", this.m_tableOption);
    }

    public ITransformTableOptions getTransformTableOption() {
        return this.m_tableOption;
    }

    @Override
    public void dispose() {
        if (this.m_tableOption != null) {
            this.m_tableOption.dispose();
        }
        super.dispose();
    }

    public IPhysicalTable getTargetTable() {
        return this.m_lookup.getTargetTable();
    }

    public IMappingsContainer getKeyMappings() {
        return this.m_keyMappings;
    }

    public IMappingsContainer getDataMappings() {
        return this.m_dataMappings;
    }

    public boolean isTargetColumnMappedToSourceTable(IColumn column) {
        return this.m_lookup.getOrdinaryMappingsForTargetColumn(column) != null;
    }

    public boolean isTargetColumnMappedToLookupTable(IColumn column) {
        return this.m_dataMappings.getOrdinaryMappingsForTargetColumn(column) != null;
    }

    @Override
    public void replaceTargetColumn(IColumn oldColumn, IColumn newColumn) {
        for (int iSet = 0; iSet < this.m_lConditionActionSets.size(); ++iSet) {
            IConditionActionSet set = (IConditionActionSet)this.m_lConditionActionSets.get(iSet);
            IConditionAction[] aActions = set.getActions();
            if (aActions == null) continue;
            for (int iAction = 0; iAction < aActions.length; ++iAction) {
                IConditionAction action = aActions[iAction];
                IProperty[] aProperties = action.getActionProperties();
                if (aProperties == null) continue;
                for (int iProperty = 0; iProperty < aProperties.length; ++iProperty) {
                    IProperty property = aProperties[iProperty];
                    ITextOperand expression = property.getExpression();
                    if (expression == null) continue;
                    expression.replaceColumn(oldColumn, newColumn);
                }
            }
        }
    }

    @Override
    public List getConditionActionSetsList() {
        return this.m_lConditionActionSets;
    }

    @Override
    public IConditionActionSet[] getConditionActionSets() {
        return (IConditionActionSet[])this.m_lConditionActionSets.toArray(new IConditionActionSet[this.m_lConditionActionSets.size()]);
    }

    @Override
    public List getTemplateConditionActionSetsList() {
        return this.m_lTemplateConditionActionSets;
    }

    @Override
    public IConditionActionSet[] getTemplateConditionActionSets() {
        return this.m_lTemplateConditionActionSets.toArray(new IConditionActionSet[this.m_lTemplateConditionActionSets.size()]);
    }

    @Override
    public List getDefinedConditionActionSetUniqueIds() {
        return this.m_lDefinedConditionActionSetUniqueIds;
    }

    public void addConditions(List lConditions) {
        boolean SET_ID = false;
        boolean ACTION_ID = true;
        int OPTIONS_LIST = 2;
        for (int iSet = 0; iSet < lConditions.size(); ++iSet) {
            List lCASet = (List)lConditions.get(iSet);
            String sSetID = (String)lCASet.get(0);
            String sActionID = (String)lCASet.get(1);
            IConditionActionSet setTemplate = this.findConditionActionSetTemplate(sSetID);
            ICondition conditionTemplate = setTemplate.getCondition();
            IConditionAction actionTemplate = this.findConditionActionTemplate(sActionID, setTemplate);
            IObjectFactory factory = this.getModel().getObjectFactory();
            IConditionActionSet set = factory.createNewConditionActionSetInstance(this.getID(), sSetID, setTemplate);
            ICondition condition = factory.createNewConditionInstance(this.getID(), set, conditionTemplate);
            IConditionAction action = factory.createNewConditionActionInstance(this.getID(), set, actionTemplate);
            set.setCondition(condition);
            set.getActionList().add(action);
            if (lCASet.size() > 2) {
                List lOptions = (List)lCASet.get(2);
                IProperty[] aProperties = action.getActionProperties();
                for (int iOption = 0; iOption < lOptions.size() && iOption < aProperties.length; ++iOption) {
                    String sValue = (String)lOptions.get(iOption);
                    if ("DIS_SETTARGETCOL".equals(action.getUniqueIdentifier())) {
                        IPhysicalTable targetTable;
                        ITextOperand expression = aProperties[iOption].getExpression();
                        if (expression == null) {
                            expression = factory.createNewTextOperand(this.getID());
                            expression.setName("lookupvalue");
                            expression.setUseSQLSyntax(false);
                            aProperties[iOption].setExpression(expression);
                        }
                        expression.setText(sValue, (targetTable = this.getTargetTable()) == null ? null : targetTable.getColumns());
                        continue;
                    }
                    aProperties[iOption].setDefaultValue(sValue);
                }
            }
            this.getConditionActionSetsList().add(set);
        }
    }

    public static void saveDefaultConditions(List lDefaults) {
        ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(outputBytes);
        encoder.writeObject(lDefaults);
        encoder.close();
        StringBuffer sbDefaults = new StringBuffer();
        BufferedReader reader = new BufferedReader(new StringReader(outputBytes.toString()));
        try {
            String sLine = null;
            while ((sLine = reader.readLine()) != null) {
                sbDefaults.append(sLine.trim());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(DEFAULTS_KEY, sbDefaults.toString());
    }

    public static List loadDefaultConditions() {
        List lDefaults = null;
        String sDefaultsXML = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(DEFAULTS_KEY);
        if (sDefaultsXML != null && sDefaultsXML.length() > 0) {
            ByteArrayInputStream inputBytes = new ByteArrayInputStream(sDefaultsXML.getBytes());
            XMLDecoder decoder = new XMLDecoder(inputBytes);
            lDefaults = (List)decoder.readObject();
        }
        if (lDefaults == null) {
            lDefaults = LookupMapping.createDefaultConditions();
        }
        return lDefaults;
    }

    public static List createDefaultConditions() {
        ArrayList lDefaults = new ArrayList(5);
        ArrayList<Object> lDefaultCASet = new ArrayList<Object>(3);
        lDefaultCASet.add("DIS_SETLOOKUPMISS");
        lDefaultCASet.add("DIS_ABORT");
        ArrayList<String> lDefaultActions = new ArrayList<String>(1);
        lDefaultActions.add("3");
        lDefaultCASet.add(lDefaultActions);
        lDefaults.add(lDefaultCASet);
        lDefaultCASet = new ArrayList(3);
        lDefaultCASet.add("DIS_SETLOOKUPNOREC");
        lDefaultCASet.add("DIS_ABORT");
        lDefaultActions = new ArrayList(1);
        lDefaultActions.add("3");
        lDefaultCASet.add(lDefaultActions);
        lDefaults.add(lDefaultCASet);
        lDefaultCASet = new ArrayList(2);
        lDefaultCASet.add("DIS_SETLOOKUPNOFOUND");
        lDefaultCASet.add("DIS_WRITEERROR");
        lDefaults.add(lDefaultCASet);
        lDefaultCASet = new ArrayList(2);
        lDefaultCASet.add("DIS_SETLOOKUPNOFOUND");
        lDefaultCASet.add("DIS_WRITEEXCEPTION");
        lDefaults.add(lDefaultCASet);
        lDefaultCASet = new ArrayList(2);
        lDefaultCASet.add("DIS_SETLOOKUPNOFOUND");
        lDefaultCASet.add("DIS_SETTARGETMISS");
        lDefaults.add(lDefaultCASet);
        return lDefaults;
    }

    private IConditionActionSet findConditionActionSetTemplate(String sUniqueID) {
        IConditionActionSet[] aSets = this.getTemplateConditionActionSets();
        for (int iSet = 0; iSet < aSets.length; ++iSet) {
            if (!sUniqueID.equals(aSets[iSet].getUniqueIdentifier())) continue;
            return aSets[iSet];
        }
        return null;
    }

    private IConditionAction findConditionActionTemplate(String sUniqueID, IConditionActionSet owningSet) {
        IConditionAction[] aActions = owningSet.getActions();
        for (int iAction = 0; iAction < aActions.length; ++iAction) {
            if (!sUniqueID.equals(aActions[iAction].getUniqueIdentifier())) continue;
            return aActions[iAction];
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.m_lookupTable == null || this.m_keyMappings.getMappings().length > 0;
    }

    @Override
    public List getReasonsIncomplete() {
        ArrayList<String> lReasons = new ArrayList<String>();
        if (this.m_lookupTable != null && this.m_keyMappings.getMappings().length < 1) {
            lReasons.add(MessageFormat.format(RB.getStringResource("LookupMapping.ReasonIncomplete.NoKeyMappings.msg.txt"), this.m_lookupTable.getTableName()));
        }
        return lReasons;
    }

    @Override
    public void addToDeletedObjects(IPersistableObject obj) {
        super.addToDeletedObjects(obj);
    }

    @Override
    public void removeFromDeletedObjects(IPersistableObject obj) {
        super.removeFromDeletedObjects(obj);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("TransformationSources");
        lAssociations.add("TransformationTargets");
        return map;
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() instanceof LookupMappingsContainer && ev.getType() == 1) {
            this.fireNotifyEvent(1, null);
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_tableOption != null) {
            this.m_tableOption.updateIDs(mapIDs);
        }
    }

    @Override
    public void delete() {
        if (this.m_tableOption != null) {
            this.m_tableOption.delete();
        }
        super.delete();
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        return this.m_keyMappings.isChanged() || this.m_dataMappings.isChanged() || this.m_tableOption != null && this.m_tableOption.isChanged();
    }

    protected void saveTransformTableOptions(OMRAdapter omr) throws MdException, RemoteException {
        ITransformTableOptions opts = this.getTransformTableOption();
        if (opts != null) {
            opts.saveToOMR(omr);
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        FeatureMap mdLookupMap = (FeatureMap)omr.acquireOMRObject(this);
        if (this.m_lookupTable != null) {
            this.saveCustomListToOMR(omr, LOOKUP_TABLE_ASSOC_NAME, new IPhysicalTable[]{this.m_lookupTable});
        } else {
            this.saveCustomListToOMR(omr, LOOKUP_TABLE_ASSOC_NAME, new IPhysicalTable[0]);
        }
        AssociationList lTransformationSources = mdLookupMap.getTransformationSources(false);
        lTransformationSources.clear();
        IMapping[] aKeyMappings = this.m_keyMappings.getMappings();
        for (int i = 0; i < aKeyMappings.length; ++i) {
            IMapping keyMapping = aKeyMappings[i];
            keyMapping.saveToOMR(omr);
            Root mapping = omr.acquireOMRObject(keyMapping);
            lTransformationSources.add(mapping);
        }
        this.m_keyMappings.setChanged(false);
        AssociationList lTransformationTargets = mdLookupMap.getTransformationTargets(false);
        lTransformationTargets.clear();
        IMapping[] aDataMappings = this.m_dataMappings.getMappings();
        for (int i = 0; i < aDataMappings.length; ++i) {
            IMapping dataMapping = aDataMappings[i];
            dataMapping.saveToOMR(omr);
            Root mapping = omr.acquireOMRObject(dataMapping);
            lTransformationTargets.add(mapping);
        }
        this.m_dataMappings.setChanged(false);
        IConditionActionSet[] aSets = this.getConditionActionSets();
        for (int iSet = 0; iSet < aSets.length; ++iSet) {
            IConditionActionSet set = aSets[iSet];
            AbstractTransformation mdoTransform = (AbstractTransformation)omr.acquireOMRObject(this);
            set.saveToOMR(omr);
            ConditionActionSet mdoSet = (ConditionActionSet)omr.acquireOMRObject(set);
            mdoTransform.getConditionActionSets().add((Object)mdoSet);
        }
        this.saveTransformTableOptions(omr);
        this.setChanged(false);
    }

    private String getOptionDisplayName() {
        return RB.getStringResource("LookupMapping.OptionName.txt");
    }

    protected boolean loadTransformTableOptionsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Root mdAnchor = omr.acquireOMRObject(this);
        boolean changed = false;
        AssociationList propertySets = mdAnchor.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            PropertySet pSet = (PropertySet)propertySets.get(i);
            if (!"TransformTableOptions".equals(pSet.getSetRole())) continue;
            BaseTransformTableOptions transformOpts = new BaseTransformTableOptions(pSet.getFQID(), this.getModel());
            transformOpts.setOwner(this);
            if (this.getLookupTable() == transformOpts.loadAssociatedObject(omr, pSet.getFQID())) {
                transformOpts.loadFromOMR(omr);
                transformOpts.setDisplayName(this.getOptionDisplayName());
                this.setTransformTableOption(transformOpts);
                continue;
            }
            this.addToDeletedObjects(transformOpts);
            changed = true;
        }
        return changed;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        FeatureMap mdLookupMap = (FeatureMap)omr.acquireOMRObject(this);
        IPersistableObject[] aLookupTables = this.loadCustomListFromOMR(omr, LOOKUP_TABLE_ASSOC_NAME);
        if (aLookupTables.length > 0) {
            this.setLookupTable((IPhysicalTable)aLookupTables[0]);
        }
        AssociationList lTransformSources = mdLookupMap.getTransformationSources();
        for (int i = 0; i < lTransformSources.size(); ++i) {
            FeatureMap mdLookupKeyMap = (FeatureMap)lTransformSources.get(i);
            IMapping keyMapping = (IMapping)omr.acquireObject((Root)mdLookupKeyMap);
            this.m_keyMappings.addMapping(keyMapping);
        }
        this.m_keyMappings.setChanged(false);
        AssociationList lTransformTargets = mdLookupMap.getTransformationTargets();
        for (int i = 0; i < lTransformTargets.size(); ++i) {
            FeatureMap mdLookupDataMap = (FeatureMap)lTransformTargets.get(i);
            IMapping dataMapping = (IMapping)omr.acquireObject((Root)mdLookupDataMap);
            this.m_dataMappings.addMapping(dataMapping);
        }
        this.m_dataMappings.setChanged(false);
        this.loadConditionActionSetTemplatesFromOMR();
        AbstractTransformation mdoTransform = (AbstractTransformation)omr.acquireOMRObject(this);
        AssociationList lOMRSets = mdoTransform.getConditionActionSets();
        List lModelSets = this.getConditionActionSetsList();
        for (int iInstance = 0; iInstance < lOMRSets.size(); ++iInstance) {
            ConditionActionSet mdoSet = (ConditionActionSet)lOMRSets.get(iInstance);
            IConditionActionSet modelSet = (IConditionActionSet)omr.acquireObject((Root)mdoSet);
            if (modelSet == null || lModelSets.contains(modelSet)) continue;
            lModelSets.add(modelSet);
        }
        boolean changed = this.loadTransformTableOptionsFromOMR(omr);
        this.setChanged(changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadConditionActionSetTemplatesFromOMR() throws MdException, RemoteException {
        List lSets = this.getDefinedConditionActionSetUniqueIds();
        if (lSets.isEmpty()) {
            return;
        }
        OMRAdapter omr = new OMRAdapter(this.getModel(), Workspace.getMdFactory(), "loadConditionActionSetTemplatesFromOMR");
        try {
            String sUniqueId = null;
            IConditionActionsTemplateJobModel model = null;
            if (this.getModel() instanceof IConditionActionsTemplateJobModel) {
                model = (IConditionActionsTemplateJobModel)this.getModel();
            }
            this.getTemplateConditionActionSetsList().clear();
            for (int iTemplateSet = 0; iTemplateSet < lSets.size(); ++iTemplateSet) {
                IConditionActionSet set;
                sUniqueId = (String)lSets.get(iTemplateSet);
                if (model != null && (set = model.getTemplateConditionActionSet(sUniqueId)) != null) {
                    this.getTemplateConditionActionSetsList().add(set);
                    continue;
                }
                String sTemplate = "<XMLSELECT search=\"*[@PublicType='ConditionActionSet' and @UniqueIdentifier='" + sUniqueId + "']\"/><Templates><ConditionActionSet><AssociatedCondition/><Actions><Action><PropertySets><PropertySet><SetProperties/></PropertySet></PropertySets></Action></Actions></ConditionActionSet></Templates>";
                List objects = omr.getOMRFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)omr.getOMRStore(), Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "ConditionActionSet", 8588, sTemplate);
                if (objects.isEmpty()) continue;
                block4: for (int iSet = 0; iSet < objects.size(); ++iSet) {
                    ConditionActionSet mdoSet = (ConditionActionSet)objects.get(iSet);
                    for (int iTempSet = 0; iTempSet < lSets.size(); ++iTempSet) {
                        if (!mdoSet.getUniqueIdentifier().equals(lSets.get(iTempSet)) || mdoSet.getPublicType().indexOf("Embedded") != -1 || mdoSet.getPublicType().indexOf("EMBEDDED") != -1 || mdoSet.getPublicType() == null || mdoSet.getPublicType() == "") continue;
                        IConditionActionSet oSet = (IConditionActionSet)this.getModel().getObject(mdoSet.getId());
                        if (oSet == null) {
                            oSet = this.getModel().getObjectFactory().createConditionActionSetTemplate(mdoSet.getFQID(), mdoSet.getUniqueIdentifier());
                            omr.populateFor(oSet);
                            oSet.loadFromOMR(omr);
                        }
                        this.getTemplateConditionActionSetsList().add(oSet);
                        if (model == null) continue block4;
                        model.addTemplateConditionActionSet(oSet);
                        continue block4;
                    }
                }
            }
        }
        finally {
            omr.dispose();
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        IMapping[] keyMappings = this.getKeyMappings().getMappings();
        for (int i = 0; i < keyMappings.length; ++i) {
            keyMappings[i].deleteFromOMR(omr);
        }
        IMapping[] dataMappings = this.getDataMappings().getMappings();
        for (int i = 0; i < dataMappings.length; ++i) {
            dataMappings[i].deleteFromOMR(omr);
        }
        if (this.m_tableOption != null) {
            this.m_tableOption.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    private class SetTransformTableOptionUndoable
    extends AbstractUndoableEdit {
        private ITransformTableOptions m_oldObject;
        private ITransformTableOptions m_newObject;

        public SetTransformTableOptionUndoable(ITransformTableOptions oldObject, ITransformTableOptions newObject) {
            this.m_oldObject = oldObject;
            this.m_newObject = newObject;
        }

        @Override
        public void undo() {
            LookupMapping.this.setTransformTableOption(this.m_oldObject);
        }

        @Override
        public void redo() {
            LookupMapping.this.setTransformTableOption(this.m_newObject);
        }

        @Override
        public void die() {
            this.m_newObject = null;
            this.m_oldObject = null;
            super.die();
        }
    }
}

