/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.lookup;

import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.lookup.LookupMapping;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.etl.models.job.transforms.lookup.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ICondition;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class LookupCodegen {
    private static LookupTransformModel m_oLkpTModel;
    private static ArrayList m_alMissingFlags;
    private static ArrayList m_alMissingFlagNames;
    private static ArrayList m_alMissingRowsFlags;
    private static ArrayList m_alExpressionValues;
    private static ArrayList m_alActionOptionValues;
    private static ArrayList m_alHashNames;
    private static ArrayList m_alRCs;
    private static ArrayList m_alColumnsToIgnore;
    private static boolean m_bAllowColumnRenames;
    private static boolean m_bCreateView;
    private static boolean m_bNeedExceptionTable;
    private static boolean m_bExceptionColumnRename;
    private static boolean m_bNeedErrorTable;
    private static boolean m_bErrorColumnRename;
    private static boolean m_bEnvQuoting;
    private static boolean[] m_bLkpQuoting;
    private static boolean m_bSourceQuoting;
    private static boolean m_bTargetQuoting;
    private static boolean m_bNeedRenameSourceColumns;
    private static boolean m_bRcEqualsCheckMade;
    private static boolean m_bRcNot0CheckMade;
    private static boolean m_bRequestedWriteError;
    private static boolean m_bRequestedWriteTarget;
    private static boolean m_isUsingSetKeyTechnique;
    private static boolean m_isRenameSourceColumn;
    private static int m_LookupCount;
    private static List[][] m_alMasterList;
    private static List[] m_alSourceTargetList;
    private static IIndex m_indexToUse;
    private static final String LOOKUP_MISSING_TXT;
    private static final String LOOKUP_NORECS_TXT;
    private static final String LOOKUP_FAILED_TXT;
    private static final String WRITE_EXCEPTION_TXT;
    private static final String NONE = "NONE";
    private static final String LOOKUP_MISSING_RC = "99";
    private static final String LOOKUP_NORECS_RC = "98";
    static final int ACTION_OPTION_VALUES = 0;
    static final int CONDITION_ACTIONS = 1;
    static final int LKP_TABLES = 2;
    static final int LKP_TABLENAME = 3;
    static final int LKP_TABLENAME_NOQUOTE = 4;
    static final int LKP_KEYCOLS = 5;
    static final int LKP_KEYCOLS_NOQUOTE = 6;
    static final int LKP_KEYCOL_TYPES = 7;
    static final int LKP_KEYCOL_LENGTHS = 8;
    static final int LKP_KEYCOLS_NEED_RENAME = 9;
    static final int LKP_KEYCOLS_OLDNAME = 10;
    static final int LKP_KEYCOLS_OLDNAME_NOQUOTE = 11;
    static final int LKP_DATACOLS = 12;
    static final int LKP_DATACOLS_NOQUOTE = 13;
    static final int LKP_DATACOLS_OLDNAME = 14;
    static final int LKP_DATACOLS_OLDNAME_NOQUOTE = 15;
    static final int LKP_DATACOL_TYPES = 16;
    static final int LKP_DATACOL_LENGTHS = 17;
    static final int LKP_DATACOLS_NEED_RENAME = 18;
    static final int LKP_WHERE_CLAUSE = 19;
    static final int SRC_KEYCOLS = 20;
    static final int SRC_KEYCOLS_NOQUOTE = 21;
    static final int SRC_KEYCOLS_OLDNAME = 22;
    static final int SRC_KEYCOLS_OLDNAME_NOQUOTE = 23;
    static final int SRC_KEYCOL_TYPES = 24;
    static final int SRC_KEYCOL_LENGTHS = 25;
    static final int TRG_DATACOLS = 26;
    static final int TRG_DATACOL_TYPES = 27;
    static final int TRG_DATACOL_LENGTHS = 28;
    static final int TRG_DATACOLS_NOQUOTE = 29;
    static final int LKP_TABLENAME_NOQUOTE_ORIG = 30;
    static final int MASTER_COL_COUNT = 31;
    static final int SRC_COLS = 0;
    static final int SRC_COLS_NOQUOTE = 1;
    static final int TRG_COLS = 2;
    static final int TRG_COLS_NOQUOTE = 3;
    static final int SRC_TRG_ASG_NEEDED = 4;
    static final int SRCTRG_COL_COUNT = 5;
    static String m_TempErrorTableName;
    static String m_TempExceptionTableName;

    public LookupCodegen(LookupTransformModel model) {
        m_oLkpTModel = model;
    }

    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws BadLibraryDefinitionException, CodegenException, RemoteException, BadServerDefinitionException, ServerException, MdException {
        m_bAllowColumnRenames = true;
        m_bCreateView = false;
        m_bEnvQuoting = codeSegment.isQuoting();
        try {
            if (m_oLkpTModel.getLookupTechnique().equals("SET_KEY")) {
                // empty if block
            }
            m_isUsingSetKeyTechnique = false;
            this.setErrorAndExceptionInfo();
            List lLookupMappings = m_oLkpTModel.getLookupMappings();
            m_LookupCount = lLookupMappings.size();
            if (m_LookupCount <= 0) {
                throw new CodegenException(RB.getStringResource("LookupCodegen.NoLookups.comment.txt"), (IObject)m_oLkpTModel.getTargetTable());
            }
            if (m_isUsingSetKeyTechnique) {
                for (int i = 0; i < m_LookupCount; ++i) {
                    LookupMapping lookupMap = (LookupMapping)lLookupMappings.get(i);
                    if (lookupMap.getKeyMappings().getMappings().length <= 1) continue;
                    throw new CodegenException(RB.getStringResource("LookupCodegen.MultiColumnLookupByKey.NotSupportedYet.message.txt"), (IObject)m_oLkpTModel.getTargetTable());
                }
            }
            codeSegment.genDatetimeMacrovarAssignment("runTime", "");
            if (m_bNeedErrorTable) {
                codeSegment.genTableDelete(m_oLkpTModel.getErrorTable());
            }
            if (m_bNeedExceptionTable) {
                codeSegment.genTableDelete(m_oLkpTModel.getExceptionTable());
            }
            this.collectLookupMetadata(codeSegment);
            this.collectSourceTargetMappedColumns();
            this.genViewsOfLookupTables(codeSegment);
            boolean bMappingStepNeeded = m_oLkpTModel.isMappingNeeded(codeSegment.isQuoting(), m_oLkpTModel.getSourceTable(), m_oLkpTModel.getTargetTable(), m_alColumnsToIgnore, false);
            String fullTableNameForMainStep = "";
            if (bMappingStepNeeded && !m_isRenameSourceColumn) {
                String tName = codeSegment.getUniqueWorkTableName();
                fullTableNameForMainStep = "work." + (codeSegment.isQuoting() ? DBMSNamesUtil.getQuotedString(tName, false) : tName);
                codeSegment.genTableDelete(fullTableNameForMainStep);
            } else {
                fullTableNameForMainStep = m_oLkpTModel.getTargetTable().getFullNameQuotedAsNeeded(codeSegment);
                codeSegment.genTableDelete(m_oLkpTModel.getTargetTable());
            }
            this.setTempErrorAndExceptionInfo(codeSegment);
            this.genLookupDStep(codeSegment, fullTableNameForMainStep, bMappingStepNeeded);
            codeSegment.unIndent().addSourceCode("\n").addSourceCode("run; \n\n").genRCSetCall("&syserr");
            if (!m_isRenameSourceColumn) {
                this.getGeneratedMappingStep(codeSegment, fullTableNameForMainStep, bMappingStepNeeded);
            }
            if (m_bExceptionColumnRename) {
                this.getGeneratedExceptionMappingStep(codeSegment);
            }
            if (m_bErrorColumnRename) {
                this.getGeneratedErrorMappingStep(codeSegment);
            }
        }
        catch (Exception e) {
            throw new CodegenException(e, (IObject)m_oLkpTModel);
        }
        return codeSegment;
    }

    protected ICodeSegment getGeneratedMappingStep(ICodeSegment codeSegment, String fullTableNameFromMainStep, boolean bMappingStepNeeded) throws BadLibraryDefinitionException, CodegenException, RemoteException, BadServerDefinitionException, ServerException, MdException {
        IPhysicalTable sourceTable = m_oLkpTModel.getSourceTable();
        IPhysicalTable targetTable = m_oLkpTModel.getTargetTable();
        if (bMappingStepNeeded) {
            String targetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
            ITransformTableOptions oSourceOptions = m_oLkpTModel.getSourceTableOptions();
            String sSourceOptions = "";
            if (oSourceOptions != null) {
                sSourceOptions = oSourceOptions.getTableOptions(codeSegment.getCurrentServer());
            }
            ITransformTableOptions oTargetOptions = m_oLkpTModel.getTargetTableOptions();
            String sTargetOptions = "";
            if (oTargetOptions != null) {
                sTargetOptions = oTargetOptions.getTableOptions(codeSegment.getCurrentServer());
            }
            m_oLkpTModel.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, targetDSName, fullTableNameFromMainStep, sSourceOptions, sTargetOptions, m_bCreateView, true, true, m_alColumnsToIgnore.toArray(new IColumn[m_alColumnsToIgnore.size()]), null, false, null, null, null);
            if (!m_bCreateView) {
                codeSegment.genTableDelete(fullTableNameFromMainStep);
            }
        }
        return codeSegment;
    }

    protected ICodeSegment getGeneratedErrorMappingStep(ICodeSegment codeSegment) throws BadLibraryDefinitionException, CodegenException, RemoteException, BadServerDefinitionException, ServerException, MdException {
        IPhysicalTable targetTable = m_oLkpTModel.getErrorTable();
        IPhysicalTable sourceTable = m_oLkpTModel.getModel().getObjectFactory().createNewPhysicalTable(m_oLkpTModel.getID());
        if (targetTable == null) {
            return codeSegment;
        }
        targetTable.deepCopy(sourceTable);
        IColumn[] erSrcCols = sourceTable.getColumns();
        block0: for (int i = 0; i < erSrcCols.length; ++i) {
            String erSrcColName = erSrcCols[i].getName();
            for (int j = 0; j < m_alSourceTargetList[3].size(); ++j) {
                String sOldColumnName = (String)m_alSourceTargetList[1].get(j);
                String sNewColumnName = (String)m_alSourceTargetList[3].get(j);
                if (!erSrcColName.equalsIgnoreCase(sOldColumnName)) continue;
                if (erSrcColName.equalsIgnoreCase(sNewColumnName)) continue block0;
                erSrcCols[i].setName(sNewColumnName);
                continue block0;
            }
        }
        String errorTableName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
        ITransformTableOptions oSourceOptions = m_oLkpTModel.getSourceTableOptions();
        String sSourceOptions = "";
        if (oSourceOptions != null) {
            sSourceOptions = oSourceOptions.getTableOptions(codeSegment.getCurrentServer());
        }
        ITransformTableOptions oTargetOptions = m_oLkpTModel.getTargetTableOptions();
        String sTargetOptions = "";
        if (oTargetOptions != null) {
            sTargetOptions = oTargetOptions.getTableOptions(codeSegment.getCurrentServer());
        }
        this.getErrorExceptionMappingCode(codeSegment, sourceTable, targetTable, errorTableName, m_TempErrorTableName, sSourceOptions, sTargetOptions, m_bCreateView, true, true);
        if (!m_bCreateView) {
            codeSegment.genTableDelete(m_TempErrorTableName);
        }
        return codeSegment;
    }

    protected ICodeSegment getGeneratedExceptionMappingStep(ICodeSegment codeSegment) throws BadLibraryDefinitionException, CodegenException, RemoteException, BadServerDefinitionException, ServerException, MdException {
        IPhysicalTable targetTable = m_oLkpTModel.getExceptionTable();
        IPhysicalTable sourceTable = m_oLkpTModel.getModel().getObjectFactory().createNewPhysicalTable(m_oLkpTModel.getID());
        if (targetTable == null) {
            return codeSegment;
        }
        targetTable.deepCopy(sourceTable);
        IColumn[] exSrcCols = sourceTable.getColumns();
        block0: for (int i = 0; i < exSrcCols.length; ++i) {
            String exSrcColName = exSrcCols[i].getName();
            for (int j = 0; j < m_alSourceTargetList[3].size(); ++j) {
                String sOldColumnName = (String)m_alSourceTargetList[1].get(j);
                String sNewColumnName = (String)m_alSourceTargetList[3].get(j);
                if (!exSrcColName.equalsIgnoreCase(sOldColumnName)) continue;
                if (exSrcColName.equalsIgnoreCase(sNewColumnName)) continue block0;
                exSrcCols[i].setName(sNewColumnName);
                continue block0;
            }
        }
        String exceptionTableName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
        ITransformTableOptions oSourceOptions = m_oLkpTModel.getSourceTableOptions();
        String sSourceOptions = "";
        if (oSourceOptions != null) {
            sSourceOptions = oSourceOptions.getTableOptions(codeSegment.getCurrentServer());
        }
        ITransformTableOptions oTargetOptions = m_oLkpTModel.getTargetTableOptions();
        String sTargetOptions = "";
        if (oTargetOptions != null) {
            sTargetOptions = oTargetOptions.getTableOptions(codeSegment.getCurrentServer());
        }
        this.getErrorExceptionMappingCode(codeSegment, sourceTable, targetTable, exceptionTableName, m_TempExceptionTableName, sSourceOptions, sTargetOptions, m_bCreateView, true, true);
        if (!m_bCreateView) {
            codeSegment.genTableDelete(m_TempExceptionTableName);
        }
        return codeSegment;
    }

    private static void bldConditionActionPairs(ICodeSegment codeSegment, int n) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        LookupMapping specificLookup = (LookupMapping)m_oLkpTModel.getLookupMappings().get(n);
        int conditionActionSetsCount = specificLookup.getConditionActionSetsList().size();
        for (int j = 0; j < conditionActionSetsCount; ++j) {
            IConditionActionSet set = (IConditionActionSet)specificLookup.getConditionActionSetsList().get(j);
            ICondition condition = set.getCondition();
            IConditionAction action = (IConditionAction)set.getActionList().get(0);
            StringBuffer stbTemp = new StringBuffer();
            StringBuffer holdCondition = new StringBuffer();
            holdCondition.append(condition.getUniqueIdentifier());
            holdCondition.setLength(32);
            stbTemp.append(holdCondition);
            StringBuffer holdAction = new StringBuffer();
            holdAction.append(action.getUniqueIdentifier());
            holdAction.setLength(32);
            stbTemp.append(holdAction);
            m_alMasterList[n][1].add(stbTemp);
            String expText = "";
            StringBuffer stbCondValuePair = new StringBuffer();
            if (action.getUniqueIdentifier().equalsIgnoreCase("DIS_SETTARGETCOL") || action.getUniqueIdentifier().equalsIgnoreCase("DIS_ABORT")) {
                ITextOperand exp;
                IProperty value = (IProperty)action.getActionPropertiesList().get(0);
                stbCondValuePair.append(action.getUniqueIdentifier());
                stbCondValuePair.setLength(32);
                expText = action.getUniqueIdentifier().equalsIgnoreCase("DIS_SETTARGETCOL") ? ((exp = value.getExpression()) == null ? "* Note: no assignment was specified.;" : exp.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting())) : value.getDefaultValue();
            }
            stbCondValuePair.append(expText);
            m_alMasterList[n][0].add(stbCondValuePair);
        }
    }

    private void collectLookupMetadata(ICodeSegment codeSegment) throws BadLibraryDefinitionException, CodegenException, MdException, RemoteException, BadServerDefinitionException, ServerException {
        int i;
        m_alRCs = new ArrayList();
        m_alHashNames = new ArrayList();
        m_alColumnsToIgnore = new ArrayList();
        m_bLkpQuoting = new boolean[m_LookupCount];
        m_alMasterList = new ArrayList[m_LookupCount][31];
        for (i = 0; i < m_LookupCount; ++i) {
            for (int j = 0; j < 31; ++j) {
                LookupCodegen.m_alMasterList[i][j] = new ArrayList();
            }
        }
        m_alSourceTargetList = new ArrayList[5];
        for (i = 0; i < 5; ++i) {
            LookupCodegen.m_alSourceTargetList[i] = new ArrayList();
        }
        LookupCodegen.m_alMasterList[0][2] = m_oLkpTModel.getLookupTables();
        for (i = 0; i < m_LookupCount; ++i) {
            IPhysicalTable lookupTable = (IPhysicalTable)m_alMasterList[0][2].get(i);
            if (lookupTable == null) {
                throw new CodegenException(RB.getStringResource("LookupCodegen.NoLookupTable.message.txt"), (IObject)m_oLkpTModel);
            }
            String tableNameNoQuote = lookupTable.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), false, false, false, "");
            m_alMasterList[i][4].add(tableNameNoQuote);
            m_alMasterList[i][30].add(tableNameNoQuote);
            m_alMasterList[i][3].add(lookupTable.getFullNameQuotedAsNeeded(codeSegment));
            lookupTable.genAccessPath(codeSegment, true, -1, codeSegment.getRuntimeStatsConnectMacros(codeSegment), codeSegment.isRunStatisticsEnabled(), codeSegment.isRunTableStatisticsEnabled(), m_oLkpTModel.getTableOptionObject(lookupTable, true));
            LookupCodegen.m_bLkpQuoting[i] = lookupTable.isQuoted();
            if (m_bLkpQuoting[i]) {
                m_bEnvQuoting = true;
            }
            this.setColumnsUsedByLookupInfo(i);
            String nHash = new Integer(i).toString();
            m_alHashNames.add("h" + nHash);
            m_alRCs.add("rc" + nHash);
            LookupMapping mapping = (LookupMapping)m_oLkpTModel.getLookupMappings().get(i);
            String sLkpWhereClause = "";
            if (mapping.getExpression() != null) {
                sLkpWhereClause = mapping.getExpression().getText(codeSegment.getCurrentServer(), codeSegment.isQuoting());
            }
            m_alMasterList[i][19].add(sLkpWhereClause);
            m_alMasterList[i][18].add(new Boolean(false));
            m_alMasterList[i][9].add(new Boolean(false));
            LookupCodegen.bldConditionActionPairs(codeSegment, i);
        }
        if (m_bEnvQuoting && !codeSegment.isQuoting()) {
            codeSegment.genValidvarnameOptionAny(false);
        }
    }

    private void collectSourceTargetMappedColumns() throws CodegenException {
        IMapping[] aMappings = m_oLkpTModel.getOrdinaryMappings();
        m_isRenameSourceColumn = false;
        for (int k = 0; k < aMappings.length; ++k) {
            IMapping mapping = aMappings[k];
            if (mapping.getType() != "ONETOONE") continue;
            String sSourceColName = mapping.getSources()[0].getName();
            m_alSourceTargetList[1].add(sSourceColName);
            if (m_bEnvQuoting) {
                sSourceColName = DBMSNamesUtil.getQuotedString(sSourceColName, false);
            }
            m_alSourceTargetList[0].add(sSourceColName);
            String sTargetColName = mapping.getTargets()[0].getName();
            m_alSourceTargetList[3].add(sTargetColName);
            if (m_bEnvQuoting) {
                sTargetColName = DBMSNamesUtil.getQuotedString(sTargetColName, false);
            }
            m_alSourceTargetList[2].add(sTargetColName);
            m_alSourceTargetList[4].add(new Boolean(true));
            if (m_isRenameSourceColumn || sSourceColName.equals(sTargetColName)) continue;
            m_isRenameSourceColumn = true;
        }
    }

    private ICodeSegment genViewsOfLookupTables(ICodeSegment codeSegment) {
        if (m_bAllowColumnRenames) {
            this.renameLookupDataColumns(codeSegment);
            this.renameKeyColumns(codeSegment);
        }
        for (int i = 0; i < m_LookupCount; ++i) {
            String sLookupTable = (String)m_alMasterList[i][3].get(0);
            String sLkpWhereClause = (String)m_alMasterList[i][19].get(0);
            boolean bNeedRenameView = (Boolean)m_alMasterList[i][18].get(0);
            if (!bNeedRenameView) {
                bNeedRenameView = (Boolean)m_alMasterList[i][9].get(0);
            }
            if (bNeedRenameView) {
                codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.RenameColumnView.note.txt") + " " + sLookupTable);
            }
            if (sLkpWhereClause.length() <= 0 && !bNeedRenameView) continue;
            String temp = "etls_temp_lookupview" + new Integer(i);
            codeSegment.addSourceCode("proc datasets lib = work nolist nowarn memtype = (data view);\n").indent().addSourceCode("delete " + temp + ";\n").unIndent().addSourceCode("quit;\n\n");
            codeSegment.addSourceCode("proc sql; create");
            if (m_isUsingSetKeyTechnique) {
                codeSegment.addSourceCode(" table " + temp);
                codeSegment.addSourceCode("(index=(" + (String)m_alMasterList[i][5].get(0) + ")) ");
            } else {
                codeSegment.addSourceCode(" view " + temp + " as \n").indent();
            }
            if (!bNeedRenameView) {
                codeSegment.addSourceCode("select * from " + sLookupTable + "\n");
            } else {
                String sNewColumnName;
                String sOldColumnName;
                int j;
                codeSegment.addSourceCode("select \n").indent();
                for (j = 0; j < m_alMasterList[i][12].size(); ++j) {
                    sOldColumnName = (String)m_alMasterList[i][14].get(j);
                    sNewColumnName = (String)m_alMasterList[i][12].get(j);
                    if (j > 0) {
                        codeSegment.addSourceCode(",\n");
                    }
                    codeSegment.addSourceCode(sOldColumnName);
                    if (sOldColumnName.equals(sNewColumnName)) continue;
                    codeSegment.addSourceCode(" as " + sNewColumnName);
                }
                for (j = 0; j < m_alMasterList[i][5].size(); ++j) {
                    sOldColumnName = (String)m_alMasterList[i][10].get(j);
                    sNewColumnName = (String)m_alMasterList[i][5].get(j);
                    codeSegment.addSourceCode(",\n");
                    codeSegment.addSourceCode(sOldColumnName);
                    if (sOldColumnName.equals(sNewColumnName)) continue;
                    codeSegment.addSourceCode(" as " + sNewColumnName);
                }
                codeSegment.unIndent().addSourceCode("\nfrom " + sLookupTable + "\n");
            }
            if (sLkpWhereClause.length() > 0) {
                codeSegment.addSourceCode("where " + sLkpWhereClause);
            }
            codeSegment.addSourceCode(";\n");
            codeSegment.unIndent().addSourceCode("quit;\n");
            m_alMasterList[i][3].set(0, temp);
            m_alMasterList[i][4].set(0, temp);
        }
        return codeSegment;
    }

    private ICodeSegment genLookupDStep(ICodeSegment codeSegment, String fullTableNameForMainStep, boolean bMappingStepNeeded) throws BadLibraryDefinitionException, CodegenException {
        codeSegment.addSectionComment(RB.getStringResource("LookupCodegen.BeginLookups.comment.txt"));
        codeSegment.addSourceCode("DATA  ").addSourceCode(fullTableNameForMainStep);
        codeSegment.addSourceCode("\n").indent().indent().indent();
        this.bldMissingFlags();
        ITransformTableOptions oOptions = m_oLkpTModel.getTargetTableOptions();
        String sTableOptions = "";
        if (oOptions != null) {
            sTableOptions = oOptions.getTableOptions(codeSegment.getCurrentServer());
        }
        this.genDSOptionsWithKeepStatements(codeSegment, bMappingStepNeeded ? "" : sTableOptions);
        this.genDSview(codeSegment, bMappingStepNeeded, fullTableNameForMainStep);
        codeSegment.addSourceCode("; \n").unIndent();
        this.genAttribStatements(codeSegment);
        this.genRetainStatement(codeSegment);
        codeSegment.addSourceCode("etls_assign_target_value = 0; \n");
        if (m_bNeedExceptionTable || m_bNeedErrorTable) {
            codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.AssignErrorColumns.comment.txt"));
            codeSegment.addSourceCode("etls_source_row      = _n_;\n").addSourceCode("etls_write_to_error_table  = 0; \n\n");
        }
        this.genHashObjects(codeSegment);
        codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.ReadSourceRow.comment.txt"));
        if (m_bNeedRenameSourceColumns) {
            codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.RenameSourceColumns.note.txt"));
        }
        codeSegment.addSourceCode("set " + m_oLkpTModel.getSourceTable().getFullNameQuotedAsNeeded(codeSegment));
        ITransformTableOptions oSourceOptions = m_oLkpTModel.getSourceTableOptions();
        String dsOptions = "";
        if (oSourceOptions != null) {
            dsOptions = oSourceOptions.getTableOptions(codeSegment.getCurrentServer());
        }
        if (m_bNeedRenameSourceColumns || m_isRenameSourceColumn) {
            this.genRenameSourceColumns(codeSegment, dsOptions.length() > 0 ? dsOptions : "");
        } else {
            codeSegment.addSourceCode(dsOptions.length() > 0 ? "(" + dsOptions + ")" : "");
            codeSegment.addSourceCode(" end = eof;\n");
        }
        this.genFindCalls(codeSegment);
        codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.CheckRCs.comment.txt")).addSourceCode("if ( rc0=0 ");
        for (int i = 1; i < m_LookupCount; ++i) {
            String sRcName = (String)m_alRCs.get(i);
            codeSegment.addSourceCode("and ");
            if (i % 7 == 0) {
                codeSegment.addSourceCode("\n     ");
            }
            codeSegment.addSourceCode(sRcName + "=0 ");
        }
        codeSegment.addSourceCode(") then \n").addSourceCode("do; \n").indent().addCommentLine(RB.getStringResource("LookupCodegen.WriteTargetRow.comment.txt")).addSourceCode("output " + fullTableNameForMainStep + "; \n").unIndent().addSourceCode("end; \n");
        codeSegment.addSourceCode("else \n").addSourceCode("do; \n").indent().addSourceCode("error_total + 1; \n");
        this.genErrorLimitHandler(codeSegment);
        this.genExceptionHandling(codeSegment, fullTableNameForMainStep);
        codeSegment.unIndent().addSourceCode("\nend; /* ").addSourceCode(RB.getStringResource("LookupCodegen.LookupFailed.comment.txt")).addSourceCode(" */\n\n");
        this.genEOFprocessing(codeSegment);
        return codeSegment;
    }

    private void bldMissingFlags() {
        m_alMissingFlags = new ArrayList();
        m_alMissingRowsFlags = new ArrayList();
        m_alMissingFlagNames = new ArrayList();
        for (int i = 0; i < m_LookupCount; ++i) {
            String flagName = "missing" + new Integer(i);
            m_alMissingFlagNames.add(flagName);
            m_alMissingFlags.add(NONE);
            m_alMissingRowsFlags.add(NONE);
        }
    }

    private ICodeSegment genEOFprocessing(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("if (eof = 1) then \n").addSourceCode("do; \n").indent();
        codeSegment.addSourceCode("put \"").addSourceCode(RB.getStringResource("LookupCodegen.RecordsWithErrors.note.txt")).addSourceCode(" \" error_total ; \n");
        codeSegment.addSourceCode("put \"").addSourceCode(RB.getStringResource("LookupCodegen.TotalExceptions.note.txt")).addSourceCode(" \" exception_total ; \n");
        codeSegment.unIndent().addSourceCode("end; \n");
        return codeSegment;
    }

    private boolean getExpressionsForCondition(int k, String strConditionToFind) {
        boolean actionFound = false;
        m_alExpressionValues = new ArrayList();
        List lstConditionActions = m_alMasterList[k][1];
        for (int j = 0; j < lstConditionActions.size(); ++j) {
            String expAction;
            StringBuffer stbConditionAction = (StringBuffer)lstConditionActions.get(j);
            String expCondition = stbConditionAction.substring(0, 32).trim();
            if (expCondition.indexOf(strConditionToFind) <= -1 || !(expAction = stbConditionAction.substring(32).trim()).equalsIgnoreCase("DIS_SETTARGETCOL")) continue;
            m_alExpressionValues.add(this.checkSetTargetValue(k, j, "DIS_SETTARGETCOL"));
            actionFound = true;
        }
        return actionFound;
    }

    private String checkSetTargetValue(int lookup, int index, String strConditionToFind) {
        List lstConditionValues = m_alMasterList[lookup][0];
        StringBuffer stbCondValuePair = (StringBuffer)lstConditionValues.get(index);
        String expCondition = stbCondValuePair.substring(0, 32).trim();
        if (expCondition.indexOf(strConditionToFind) > -1) {
            String expressionText = stbCondValuePair.substring(32).trim();
            expressionText = expressionText + ";";
            return expressionText;
        }
        return "";
    }

    private boolean checkForAction(int k, String strConditionToFind, String strActionToFind) {
        List lstConditionActions = m_alMasterList[k][1];
        for (int j = 0; j < lstConditionActions.size(); ++j) {
            String expAction;
            StringBuffer stbConditionAction = (StringBuffer)lstConditionActions.get(j);
            String expCondition = stbConditionAction.substring(0, 32).trim();
            if (expCondition.indexOf(strConditionToFind) <= -1 || !(expAction = stbConditionAction.substring(32).trim()).equalsIgnoreCase(strActionToFind)) continue;
            return true;
        }
        return false;
    }

    private ICodeSegment genExceptionHandling(ICodeSegment codeSegment, String fullTableNameForMainStep) throws BadLibraryDefinitionException, CodegenException {
        m_bRequestedWriteTarget = false;
        m_bRequestedWriteError = false;
        for (int i = 0; i < m_LookupCount; ++i) {
            m_bRcNot0CheckMade = false;
            m_bRcEqualsCheckMade = false;
            String sRcName = (String)m_alRCs.get(i);
            this.genLookupTableMissingHandler(codeSegment, i, sRcName);
            this.genLookupRowsMissingHandler(codeSegment, i, sRcName);
            this.genFindFailureHandler(codeSegment, i, sRcName);
            if (!m_bRcNot0CheckMade) continue;
            codeSegment.unIndent().addSourceCode("end; \n");
        }
        if (m_bRequestedWriteError) {
            codeSegment.addSourceCode("\n").addCommentLine(RB.getStringResource("LookupCodegen.WriteErrorRowCheck.comment.txt")).addSourceCode("if (etls_write_to_error_table eq 1) then \n").indent();
            if (!m_bErrorColumnRename) {
                codeSegment.addSourceCode("output " + m_oLkpTModel.getErrorTable().getFullNameQuotedAsNeeded(codeSegment) + "; \n").unIndent();
            } else {
                codeSegment.addSourceCode("output " + m_TempErrorTableName).addSourceCode("; \n");
            }
        }
        if (m_bRequestedWriteTarget) {
            codeSegment.addSourceCode("\n").addCommentLine(RB.getStringResource("LookupCodegen.SetTargetValuesCheck.comment.txt")).addSourceCode("if (etls_assign_target_value eq 1");
            codeSegment.addSourceCode(") then \n").indent().addCommentLine(RB.getStringResource("LookupCodegen.WriteTargetRow.comment.txt")).addSourceCode("output " + fullTableNameForMainStep + "; \n").unIndent();
        }
        return codeSegment;
    }

    private ICodeSegment genLookupTableMissingHandler(ICodeSegment codeSegment, int k, String rcName) throws BadLibraryDefinitionException, CodegenException {
        if (((String)m_alMissingFlags.get(k)).equalsIgnoreCase("DIS_CLOOKUPMISSING")) {
            codeSegment.addSourceCode("\nif (" + rcName + " ^= 0) then \n").addSourceCode("do; \n");
            m_bRcNot0CheckMade = true;
            codeSegment.indent().addSourceCode("exception_total + 1; \n").addSourceCode("if (" + rcName + " = ").addSourceCode("99) then \n").addSourceCode("do; \n").indent().addCommentLine(RB.getStringResource("LookupCodegen.LookupMissingWriteExcp.comment.txt"));
            m_bRcEqualsCheckMade = true;
            if (m_bNeedErrorTable && this.checkForAction(k, "DIS_CLOOKUPMISSING", "DIS_WRITEERROR")) {
                codeSegment.addSourceCode("etls_write_to_error_table = 1; \n");
                m_bRequestedWriteError = true;
            }
            if (m_bNeedExceptionTable && this.checkForAction(k, "DIS_CLOOKUPMISSING", "DIS_WRITEEXCEPTION")) {
                this.genWriteExceptionRecord(codeSegment, k, LOOKUP_MISSING_TXT);
            }
            codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.LookupMissingSetTargetVals.comment.txt"));
            if (this.getExpressionsForCondition(k, "DIS_CLOOKUPMISSING")) {
                for (int n = 0; n < m_alExpressionValues.size(); ++n) {
                    codeSegment.addSourceCode(m_alExpressionValues.get(n) + "\n");
                }
                codeSegment.addSourceCode("etls_assign_target_value = 1; \n");
                m_bRequestedWriteTarget = true;
            } else if (this.checkForAction(k, "DIS_CLOOKUPMISSING", "DIS_SETTARGETMISS")) {
                codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.LookupMissingSetTargetMissing.comment.txt"));
                this.genSetTrgDataColsMissing(codeSegment, k);
                codeSegment.addSourceCode("etls_assign_target_value = 1; \n");
                m_bRequestedWriteTarget = true;
            }
            codeSegment.unIndent().addSourceCode("end; \n");
        }
        return codeSegment;
    }

    private ICodeSegment genLookupRowsMissingHandler(ICodeSegment codeSegment, int k, String rcName) throws BadLibraryDefinitionException, CodegenException {
        if (((String)m_alMissingRowsFlags.get(k)).equalsIgnoreCase("DIS_CNOLOOKUPROWS")) {
            if (!m_bRcNot0CheckMade) {
                codeSegment.addSourceCode("\nif (" + rcName + " ^= 0) then \n").addSourceCode("do; \n").indent().addSourceCode("exception_total + 1; \n");
                m_bRcNot0CheckMade = true;
                codeSegment.addSourceCode("if (" + rcName + " = " + LOOKUP_NORECS_RC + ") then \n").addSourceCode("do; \n").indent().addCommentLine(RB.getStringResource("LookupCodegen.LookupNoRowsWriteExcp.comment.txt"));
                m_bRcEqualsCheckMade = true;
            } else {
                codeSegment.addSourceCode("\nelse if (" + rcName + " = " + LOOKUP_NORECS_RC + ") then \n").addSourceCode("do; \n").indent().addCommentLine(RB.getStringResource("LookupCodegen.LookupNoRowsWriteExcp.comment.txt"));
            }
            if (m_bNeedErrorTable && this.checkForAction(k, "DIS_CNOLOOKUPROWS", "DIS_WRITEERROR")) {
                codeSegment.addSourceCode("etls_write_to_error_table = 1; \n");
                m_bRequestedWriteError = true;
            }
            if (m_bNeedExceptionTable && this.checkForAction(k, "DIS_CNOLOOKUPROWS", "DIS_WRITEEXCEPTION")) {
                this.genWriteExceptionRecord(codeSegment, k, LOOKUP_NORECS_TXT);
            }
            codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.LookupNoRowsSetTargetVals.comment.txt"));
            if (this.getExpressionsForCondition(k, "DIS_CNOLOOKUPROWS")) {
                for (int n = 0; n < m_alExpressionValues.size(); ++n) {
                    codeSegment.addSourceCode(m_alExpressionValues.get(n) + "\n");
                }
                codeSegment.addSourceCode("etls_assign_target_value = 1; \n");
                m_bRequestedWriteTarget = true;
            } else if (this.checkForAction(k, "DIS_CNOLOOKUPROWS", "DIS_SETTARGETMISS")) {
                codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.LookupNoRowsSetTargetMissing.comment.txt"));
                this.genSetTrgDataColsMissing(codeSegment, k);
                codeSegment.addSourceCode("etls_assign_target_value = 1; \n");
                m_bRequestedWriteTarget = true;
            }
            codeSegment.unIndent().addSourceCode("end; \n");
        }
        return codeSegment;
    }

    private ICodeSegment genFindFailureHandler(ICodeSegment codeSegment, int k, String rcName) throws BadLibraryDefinitionException, CodegenException {
        boolean elseAdded = false;
        if (m_bNeedErrorTable && this.checkForAction(k, "DIS_CLOOKUPFAILED", "DIS_WRITEERROR")) {
            if (!m_bRcNot0CheckMade) {
                codeSegment.addSourceCode("\nif (" + rcName + " ^= 0) then \n").addSourceCode("do; \n").indent().addSourceCode("exception_total + 1; \n");
                m_bRcNot0CheckMade = true;
            } else if (m_bRcEqualsCheckMade) {
                codeSegment.addSourceCode("\nelse \n").addSourceCode("do; \n").indent();
                elseAdded = true;
            }
            codeSegment.addSourceCode("etls_write_to_error_table = 1; \n");
            m_bRequestedWriteError = true;
        }
        if (m_bNeedExceptionTable && this.checkForAction(k, "DIS_CLOOKUPFAILED", "DIS_WRITEEXCEPTION")) {
            if (!m_bRcNot0CheckMade) {
                codeSegment.addSourceCode("\nif (" + rcName + " ^= 0) then \n").addSourceCode("do; \n").indent().addSourceCode("exception_total + 1; \n");
                m_bRcNot0CheckMade = true;
            } else if (m_bRcEqualsCheckMade && !elseAdded) {
                codeSegment.addSourceCode("\nelse \n").addSourceCode("do; \n").indent();
                elseAdded = true;
            }
            codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.LookupValNotFoundWriteExcp.comment.txt"));
            this.genWriteExceptionRecord(codeSegment, k, LOOKUP_FAILED_TXT);
        }
        if (this.getAbortOptionsForCondition(k, "DIS_CLOOKUPFAILED")) {
            if (!m_bRcNot0CheckMade) {
                codeSegment.addSourceCode("\nif (" + rcName + " ^= 0) then \n").addSourceCode("do; \n").indent().addSourceCode("exception_total + 1; \n");
                m_bRcNot0CheckMade = true;
            } else if (m_bRcEqualsCheckMade && !elseAdded) {
                codeSegment.addSourceCode("\nelse \n").addSourceCode("do; \n").indent();
                elseAdded = true;
            }
            if (m_bRequestedWriteError) {
                codeSegment.addSourceCode("\n").addCommentLine(RB.getStringResource("LookupCodegen.WriteErrorRowCheck.comment.txt")).addSourceCode("if (etls_write_to_error_table = 1) then \n").indent().addSourceCode("output " + m_oLkpTModel.getErrorTable().getFullNameQuotedAsNeeded(codeSegment) + "; \n").unIndent();
            }
            codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.LookupValNotFoundAbort.comment.txt")).addSourceCode("abort ").addSourceCode(m_alActionOptionValues.get(0) + "; \n");
        } else if (this.checkForAction(k, "DIS_CLOOKUPFAILED", "DIS_SKIPRECORD")) {
            if (!m_bRcNot0CheckMade) {
                codeSegment.addSourceCode("\nif (" + rcName + " ^= 0) then \n").addSourceCode("do; \n").indent().addSourceCode("exception_total + 1; \n");
                m_bRcNot0CheckMade = true;
            } else if (m_bRcEqualsCheckMade && !elseAdded) {
                codeSegment.addSourceCode("\nelse \n").addSourceCode("do; \n").indent();
                elseAdded = true;
            }
            if (m_bRequestedWriteError) {
                codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.WriteErrorRowCheck.comment.txt")).addSourceCode("if (etls_write_to_error_table eq 1) then \n").indent().addSourceCode("output " + m_oLkpTModel.getErrorTable().getFullNameQuotedAsNeeded(codeSegment) + "; \n").unIndent();
            }
            codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.LookupValNotFoundSkip.comment.txt")).addSourceCode("return; \n");
        } else {
            if (this.getExpressionsForCondition(k, "DIS_CLOOKUPFAILED")) {
                if (!m_bRcNot0CheckMade) {
                    codeSegment.addSourceCode("\nif (" + rcName + " ^= 0) then \n").addSourceCode("do; \n").indent().addSourceCode("exception_total + 1; \n");
                    m_bRcNot0CheckMade = true;
                } else if (m_bRcEqualsCheckMade && !elseAdded) {
                    codeSegment.addSourceCode("\nelse \n").addSourceCode("do; \n").indent();
                    elseAdded = true;
                }
                codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.LookupValNotFoundSetTargetVals.comment.txt"));
                for (int n = 0; n < m_alExpressionValues.size(); ++n) {
                    codeSegment.addSourceCode(m_alExpressionValues.get(n) + "\n");
                }
                codeSegment.addSourceCode("etls_assign_target_value = 1; \n");
                m_bRequestedWriteTarget = true;
            }
            if (this.checkForAction(k, "DIS_CLOOKUPFAILED", "DIS_SETTARGETMISS")) {
                if (!m_bRcNot0CheckMade) {
                    codeSegment.addSourceCode("\nif (" + rcName + " ^= 0) then \n").addSourceCode("do; \n").indent().addSourceCode("exception_total + 1; \n");
                    m_bRcNot0CheckMade = true;
                } else if (m_bRcEqualsCheckMade && !elseAdded) {
                    codeSegment.addSourceCode("\nelse \n").addSourceCode("do; \n").indent();
                    elseAdded = true;
                }
                codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.LookupValNotFoundSetTargetMissing.comment.txt"));
                this.genSetTrgDataColsMissing(codeSegment, k);
                codeSegment.addSourceCode("etls_assign_target_value = 1; \n");
                m_bRequestedWriteTarget = true;
            }
        }
        if (elseAdded) {
            codeSegment.unIndent().addSourceCode("end; \n");
        }
        return codeSegment;
    }

    private boolean getAbortOptionsForCondition(int k, String strConditionToFind) {
        boolean actionFound = false;
        m_alActionOptionValues = new ArrayList();
        List lstConditionActions = m_alMasterList[k][1];
        for (int j = 0; j < lstConditionActions.size(); ++j) {
            String expAction;
            StringBuffer stbConditionAction = (StringBuffer)lstConditionActions.get(j);
            String expCondition = stbConditionAction.substring(0, 32).trim();
            if (expCondition.indexOf(strConditionToFind) <= -1 || !(expAction = stbConditionAction.substring(32).trim()).equalsIgnoreCase("DIS_ABORT")) continue;
            m_alActionOptionValues.add(this.checkAbortOptions(k, j, "DIS_ABORT"));
            actionFound = true;
        }
        return actionFound;
    }

    private String checkAbortOptions(int lookup, int index, String strConditionToFind) {
        List lstConditionValues = m_alMasterList[lookup][0];
        StringBuffer stbCondValuePair = (StringBuffer)lstConditionValues.get(index);
        String expCondition = stbCondValuePair.substring(0, 32).trim();
        if (expCondition.indexOf(strConditionToFind) > -1) {
            String optionText = stbCondValuePair.substring(32).trim();
            return optionText;
        }
        return "";
    }

    private ICodeSegment genErrorLimitHandler(ICodeSegment codeSegment) throws CodegenException {
        if (m_oLkpTModel.getErrorLimit() > -1) {
            String action = m_oLkpTModel.getErrorLimitAction();
            String sErrorLimit = new Integer(m_oLkpTModel.getErrorLimit()).toString();
            codeSegment.addSourceCode("if (error_total > ").addSourceCode(sErrorLimit).addSourceCode(") then \n").addSourceCode("do; \n").indent();
            codeSegment.genPutStatement(RB.getStringResource("LookupCodegen.ErrorLimitExceeded.note.txt") + " " + sErrorLimit);
            if (action.equalsIgnoreCase("Abort_the_step")) {
                codeSegment.genPutStatement(RB.getStringResource("LookupCodegen.AbortDATAStep.note.txt"));
                codeSegment.addSourceCode("\nstop; \n");
            } else if (action.equalsIgnoreCase("Abort_the_job")) {
                codeSegment.genPutStatement(RB.getStringResource("LookupCodegen.AbortJob.note.txt"));
                codeSegment.addSourceCode("\nabort; \n");
            } else if (action.equalsIgnoreCase("Ignore_all_remaining_errors")) {
                codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.RecordsWithErrorsIgnored.note.txt")).addSourceCode("return; \n");
            }
            codeSegment.unIndent().addSourceCode("end; \n");
        }
        return codeSegment;
    }

    private ICodeSegment genSetTrgDataColsMissing(ICodeSegment codeSegment, int k) {
        StringBuffer callMissingStatement = new StringBuffer();
        ArrayList<String> lColumns = new ArrayList<String>();
        int targetDataColsCount = m_alMasterList[k][29].size();
        if (targetDataColsCount < 1) {
            return codeSegment;
        }
        callMissingStatement.append("call missing (");
        for (int j = 0; j < targetDataColsCount; ++j) {
            String nextColName = (String)m_alMasterList[k][29].get(j);
            if (lColumns.indexOf(nextColName) != -1) continue;
            lColumns.add(nextColName);
        }
        callMissingStatement.append(codeSegment.makeColumnList(lColumns, false, "              ", false, ",", " ", codeSegment.isQuoting(), "", false)).append("); \n");
        codeSegment.addSourceCode(callMissingStatement);
        return codeSegment;
    }

    private ICodeSegment genWriteExceptionRecord(ICodeSegment codeSegment, int k, String condition) throws BadLibraryDefinitionException, CodegenException {
        codeSegment.addSourceCode("etls_lookup_table = \"").addSourceCode(((String)m_alMasterList[k][30].get(0)).replaceAll("\"", "\"\"")).addSourceCode("\"; \n");
        codeSegment.addSourceCode("etls_exception_cond = \"" + condition + "\"; \n");
        codeSegment.addSourceCode("etls_exception_action = \"" + WRITE_EXCEPTION_TXT + "\"; \n");
        codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.WriteExceptionRow.comment.txt")).addSourceCode("output ");
        if (!m_bExceptionColumnRename) {
            codeSegment.addSourceCode(m_oLkpTModel.getExceptionTable().getFullNameQuotedAsNeeded(codeSegment)).addSourceCode("; \n");
        } else {
            codeSegment.addSourceCode(m_TempExceptionTableName).addSourceCode("; \n");
        }
        return codeSegment;
    }

    private void setColumnsUsedByLookupInfo(int i) throws CodegenException {
        Integer length;
        String type;
        String columnName;
        IColumn column;
        LookupMapping lkpMapping_i = (LookupMapping)m_oLkpTModel.getLookupMappings().get(i);
        List<IMapping> lLkpKeyMaps = Arrays.asList(lkpMapping_i.getKeyMappings().getMappings());
        if (lLkpKeyMaps.size() <= 0) {
            throw new CodegenException(RB.getStringResource("LookupCodegen.NoTransformationSources.message.txt") + m_alMasterList[i][4], null);
        }
        for (int j = 0; j < lLkpKeyMaps.size(); ++j) {
            List<IColumn> mapTargets;
            IMapping srcToLkpMapping_j = lLkpKeyMaps.get(j);
            List<IColumn> mapSources = Arrays.asList(srcToLkpMapping_j.getSources());
            if (mapSources.size() <= 0 || (mapTargets = Arrays.asList(srcToLkpMapping_j.getTargets())).isEmpty()) continue;
            column = mapSources.get(0);
            columnName = column.getName();
            m_alMasterList[i][21].add(columnName);
            m_alMasterList[i][23].add(columnName);
            if (m_bEnvQuoting || m_bLkpQuoting[i]) {
                columnName = DBMSNamesUtil.getQuotedString(columnName, false);
            }
            m_alMasterList[i][20].add(columnName);
            m_alMasterList[i][22].add(columnName);
            m_alMasterList[i][24].add(column.getType() == 0 ? "C" : "N");
            m_alMasterList[i][25].add(new Integer(column.getLength()));
            column = mapTargets.get(0);
            columnName = column.getName();
            m_alMasterList[i][6].add(columnName);
            m_alMasterList[i][11].add(columnName);
            if (m_bEnvQuoting || m_bLkpQuoting[i]) {
                columnName = DBMSNamesUtil.getQuotedString(columnName, false);
            }
            m_alMasterList[i][5].add(columnName);
            m_alMasterList[i][10].add(columnName);
            type = column.getType() == 0 ? "C" : "N";
            m_alMasterList[i][7].add(type);
            length = new Integer(column.getLength());
            m_alMasterList[i][8].add((type.equals("C") ? " $" : " ") + length.toString());
        }
        List<IMapping> lLkpDataMaps = Arrays.asList(lkpMapping_i.getDataMappings().getMappings());
        for (int j = 0; j < lLkpDataMaps.size(); ++j) {
            IMapping lkpToTarMapping_j = lLkpDataMaps.get(j);
            List<IColumn> mapSources = Arrays.asList(lkpToTarMapping_j.getSources());
            if (mapSources.size() == 0) {
                throw new CodegenException(RB.getStringResource("LookupCodegen.NoLookupSourceColumnInfo.message.txt"), (IObject)lkpToTarMapping_j);
            }
            column = mapSources.get(0);
            columnName = column.getName();
            m_alMasterList[i][13].add(columnName);
            m_alMasterList[i][15].add(columnName);
            if (m_bEnvQuoting || m_bLkpQuoting[i]) {
                columnName = DBMSNamesUtil.getQuotedString(columnName, false);
            }
            m_alMasterList[i][12].add(columnName);
            m_alMasterList[i][14].add(columnName);
            type = column.getType() == 0 ? "C" : "N";
            m_alMasterList[i][16].add(type);
            length = new Integer(column.getLength());
            m_alMasterList[i][17].add((type.equals("C") ? " $" : " ") + length.toString());
            List<IColumn> mapTargets = Arrays.asList(lkpToTarMapping_j.getTargets());
            if (mapTargets.size() == 0) {
                throw new CodegenException(RB.getStringResource("LookupCodegen.NoLookupTargetColumnInfo.message.txt"), (IObject)lkpToTarMapping_j);
            }
            column = mapTargets.get(0);
            columnName = column.getName();
            m_alMasterList[i][29].add(columnName);
            if (m_bEnvQuoting || m_bLkpQuoting[i]) {
                columnName = DBMSNamesUtil.getQuotedString(columnName, false);
            }
            m_alMasterList[i][26].add(columnName);
            m_alColumnsToIgnore.add(column);
            type = column.getType() == 0 ? "C" : "N";
            m_alMasterList[i][27].add(type);
            length = new Integer(column.getLength());
            m_alMasterList[i][28].add((type.equals("C") ? " $" : " ") + length.toString());
        }
    }

    public ICodeSegment genAttribStatements(ICodeSegment codeSegment) throws CodegenException {
        String columnName;
        codeSegment.addSourceCode("\n");
        StringBuffer sbAttrib = new StringBuffer();
        sbAttrib.append("attrib ");
        if (m_bNeedExceptionTable || m_bNeedErrorTable) {
            sbAttrib.append("etls_exception_cond etls_exception_action length=$32\netls_lookup_table length=$41\n");
        }
        List<IColumn> trgColumns = null;
        IPhysicalTable targetTable = m_oLkpTModel.getTargetTable();
        if (targetTable != null) {
            trgColumns = Arrays.asList(targetTable.getColumns());
        }
        if (trgColumns == null || trgColumns.size() < 1) {
            throw new CodegenException(RB.getStringResource("LookupCodegen.NoTargetColumns.message.txt"), (IObject)targetTable);
        }
        for (int j = 0; j < trgColumns.size(); ++j) {
            String columnDesc;
            IColumn column = trgColumns.get(j);
            columnName = DBMSNamesUtil.getQuotedColumnName(column, codeSegment.isQuoting(), false);
            if (sbAttrib.indexOf("\n" + columnName + " length=") >= 0) continue;
            sbAttrib.append(columnName).append(" length=");
            int columnType = column.getType();
            int columnLength = column.getLength();
            if (columnType == 0) {
                sbAttrib.append("$");
            }
            sbAttrib.append(columnLength);
            String columnFormat = column.getFormat();
            if (columnFormat != null && columnFormat.length() > 0) {
                sbAttrib.append(" format=" + columnFormat);
            }
            if ((columnDesc = column.getDescription()) != null && columnDesc.length() > 0) {
                if ((columnDesc = columnDesc.replaceAll("'", "''")).length() < 50) {
                    sbAttrib.append(" label=\"").append(columnDesc).append("\"");
                } else {
                    sbAttrib.append(" label=\n\"").append(columnDesc).append("\"");
                }
            }
            sbAttrib.append("\n");
        }
        HashMap hmDuplicateCols = m_oLkpTModel.createLookupColumnMapWithLengths();
        for (int i = 0; i < m_LookupCount; ++i) {
            int j;
            for (j = 0; j < m_alMasterList[i][13].size(); ++j) {
                String nextCol = (String)m_alMasterList[i][13].get(j);
                if (this.tableHasColumn(trgColumns, nextCol)) continue;
                columnName = (String)m_alMasterList[i][12].get(j);
                if (sbAttrib.indexOf("\n" + columnName + " length=") >= 0) continue;
                sbAttrib.append(columnName).append(" length=").append((String)m_alMasterList[i][17].get(j)).append("\n");
            }
            for (j = 0; j < m_alMasterList[i][6].size(); ++j) {
                String nextCol = (String)m_alMasterList[i][6].get(j);
                if (this.tableHasColumn(trgColumns, nextCol)) continue;
                columnName = (String)m_alMasterList[i][5].get(j);
                if (sbAttrib.indexOf("\n" + columnName + " length=") >= 0) continue;
                String colType = (String)m_alMasterList[i][7].get(j);
                sbAttrib.append(columnName).append(" length=");
                if (hmDuplicateCols.containsKey(nextCol)) {
                    sbAttrib.append(colType.equals("C") ? " $" : " ").append(((Integer)hmDuplicateCols.get(nextCol)).toString());
                } else {
                    sbAttrib.append((String)m_alMasterList[i][8].get(j));
                }
                sbAttrib.append("\n");
            }
        }
        String stmt = sbAttrib.toString().replaceAll("\n", "\n       ") + "; \n";
        codeSegment.addSourceCode(stmt);
        return codeSegment;
    }

    private ICodeSegment genDSOptionsWithKeepStatements(ICodeSegment codeSegment, String targetTableOptions) throws BadLibraryDefinitionException, CodegenException {
        String sNewColumnName;
        String sOldColumnName;
        int j;
        ArrayList<IColumn> targets = new ArrayList<IColumn>(Arrays.asList(m_oLkpTModel.getTargetTable().getColumns()));
        boolean bQuote = m_oLkpTModel.getTargetTable().isQuoted();
        IColumn[] mappedSources = m_oLkpTModel.getOrdinaryMappedSourceColumns(null);
        for (int iMappedSource = 0; iMappedSource < mappedSources.length; ++iMappedSource) {
            String sSource = mappedSources[iMappedSource].getName();
            boolean bMatch = false;
            for (int iTarget = 0; iTarget < targets.size() && !bMatch; ++iTarget) {
                IColumn column = (IColumn)targets.get(iTarget);
                bMatch = column.equalsName(sSource, bQuote);
            }
        }
        String trgKeepList = "keep = " + codeSegment.makeColumnList(targets, false, "        ", false, " ", "", codeSegment.isQuoting(), "", false);
        codeSegment.addSourceCode("(").addSourceCode(targetTableOptions).addSourceCode(targetTableOptions.length() > 0 ? "\n" : "").addSourceCode(trgKeepList + " )\n").unIndent();
        IPhysicalTable exceptionTable = m_oLkpTModel.getExceptionTable();
        IPhysicalTable errorTable = m_oLkpTModel.getErrorTable();
        if (m_bNeedExceptionTable) {
            IColumn[] exSrcCols = exceptionTable.getColumns();
            ArrayList<String> exTgtCols = new ArrayList<String>();
            boolean exSrcTgtFound = false;
            for (int i = 0; i < exSrcCols.length; ++i) {
                String exSrcColName = exSrcCols[i].getName();
                for (j = 0; j < m_alSourceTargetList[3].size(); ++j) {
                    sOldColumnName = (String)m_alSourceTargetList[1].get(j);
                    sNewColumnName = (String)m_alSourceTargetList[3].get(j);
                    if (exSrcColName.equalsIgnoreCase(sOldColumnName)) {
                        exTgtCols.add(sNewColumnName);
                        exSrcTgtFound = true;
                        break;
                    }
                    exSrcTgtFound = false;
                }
                if (exSrcTgtFound) continue;
                exTgtCols.add(exSrcColName);
            }
            String expKeepList = "keep = " + codeSegment.makeColumnList(exTgtCols, false, "   ", false, " ", "", codeSegment.isQuoting(), "", false).trim();
            String expOptions = m_oLkpTModel.getExceptionTableOptions().getTableOptions(false, codeSegment.getCurrentServer());
            if (!m_bExceptionColumnRename) {
                codeSegment.addSourceCode(exceptionTable.getFullNameQuotedAsNeeded(codeSegment) + " \n").indent();
            } else {
                codeSegment.addSourceCode(m_TempExceptionTableName + " \n").indent();
            }
            codeSegment.addSourceCode("(").addSourceCode(expOptions).addSourceCode(expOptions.length() > 0 ? "\n" : "").addSourceCode(expKeepList + ")\n").unIndent();
        }
        if (m_bNeedErrorTable) {
            IColumn[] erSrcCols = errorTable.getColumns();
            ArrayList<String> erTgtCols = new ArrayList<String>();
            boolean erSrcTgtFound = false;
            for (int i = 0; i < erSrcCols.length; ++i) {
                String erSrcColName = erSrcCols[i].getName();
                for (j = 0; j < m_alSourceTargetList[3].size(); ++j) {
                    sOldColumnName = (String)m_alSourceTargetList[1].get(j);
                    sNewColumnName = (String)m_alSourceTargetList[3].get(j);
                    if (erSrcColName.equalsIgnoreCase(sOldColumnName)) {
                        erTgtCols.add(sNewColumnName);
                        erSrcTgtFound = true;
                        break;
                    }
                    erSrcTgtFound = false;
                }
                if (erSrcTgtFound) continue;
                erTgtCols.add(erSrcColName);
            }
            String keepList = "keep = " + codeSegment.makeColumnList(erTgtCols, false, "   ", false, " ", "", codeSegment.isQuoting(), "", false).trim();
            String errOptions = m_oLkpTModel.getErrorTableOptions().getTableOptions(false, codeSegment.getCurrentServer());
            if (!m_bErrorColumnRename) {
                codeSegment.addSourceCode(errorTable.getFullNameQuotedAsNeeded(codeSegment) + " \n").indent();
            } else {
                codeSegment.addSourceCode(m_TempErrorTableName + " \n").indent();
            }
            codeSegment.indent().addSourceCode("(").addSourceCode(errOptions).addSourceCode(errOptions.length() > 0 ? "\n" : "").addSourceCode(keepList + ")").unIndent();
        }
        return codeSegment;
    }

    private ICodeSegment genDSview(ICodeSegment codeSegment, boolean bMappingStepNeeded, String fullTableNameForMainStep) throws BadLibraryDefinitionException, CodegenException {
        IPhysicalTable tarTable = m_oLkpTModel.getTargetTable();
        IPhysicalTable excTable = m_oLkpTModel.getExceptionTable();
        IPhysicalTable errTable = m_oLkpTModel.getErrorTable();
        if (tarTable.isView() && bMappingStepNeeded && !DBMSNamesUtil.getLibrefPart(fullTableNameForMainStep).equalsIgnoreCase("work")) {
            codeSegment.addSourceCode("\n/* NOTE: A permanent output view is not available with the existing mapping scenario. */\n").addSourceCode("/* Output will be created as a table. */\n");
        } else if (tarTable.isView() && errTable == null && excTable == null) {
            codeSegment.addSourceCode("/ view = ").addSourceCode(fullTableNameForMainStep);
            m_bCreateView = true;
        } else if (excTable != null && (tarTable.isView() || excTable.isView()) || errTable != null && (tarTable.isView() || errTable.isView())) {
            codeSegment.addSourceCode("\n/* NOTE: Output views are not supported when an Exception or Error table is specified. */\n").addSourceCode("/* Output will be created as tables. */\n");
        }
        return codeSegment;
    }

    private ICodeSegment genCallMissingStatement(ICodeSegment codeSegment) throws CodegenException {
        if (m_LookupCount < 1) {
            return codeSegment;
        }
        StringBuffer callMissingStatement = new StringBuffer();
        callMissingStatement.append("call missing (");
        ArrayList<String> lColumns = new ArrayList<String>();
        for (int i = 0; i < m_LookupCount; ++i) {
            String nextColName;
            int j;
            for (j = 0; j < m_alMasterList[i][6].size(); ++j) {
                nextColName = (String)m_alMasterList[i][6].get(j);
                if (lColumns.indexOf(nextColName) != -1) continue;
                lColumns.add(nextColName);
            }
            for (j = 0; j < m_alMasterList[i][13].size(); ++j) {
                nextColName = (String)m_alMasterList[i][13].get(j);
                if (lColumns.indexOf(nextColName) != -1) continue;
                lColumns.add(nextColName);
            }
        }
        callMissingStatement.append(codeSegment.makeColumnList(lColumns, false, "              ", false, ",", " ", codeSegment.isQuoting(), "", false)).append("); \n");
        codeSegment.addSourceCode(callMissingStatement);
        return codeSegment;
    }

    private ICodeSegment genRenameSourceColumns(ICodeSegment codeSegment, String tableOptions) {
        String sNewColumnName;
        String sOldColumnName;
        StringBuffer sbfSourceColList = new StringBuffer();
        codeSegment.indent().indent().addSourceCode("\n(");
        if (tableOptions.length() > 0) {
            codeSegment.addSourceCode(tableOptions);
        }
        codeSegment.addSourceCode(" rename=(\n").indent().indent().indent();
        for (int i = 0; i < m_LookupCount; ++i) {
            for (int j = 0; j < m_alMasterList[i][20].size(); ++j) {
                sOldColumnName = (String)m_alMasterList[i][22].get(j);
                sNewColumnName = (String)m_alMasterList[i][20].get(j);
                if (sbfSourceColList.indexOf(sOldColumnName) > -1 || sOldColumnName.equals(sNewColumnName)) continue;
                sbfSourceColList.append(sOldColumnName + "=" + sNewColumnName + "\n");
            }
        }
        for (int k = 0; k < m_alSourceTargetList[3].size(); ++k) {
            sOldColumnName = (String)m_alSourceTargetList[1].get(k);
            String sOldColumnNameQuote = (String)m_alSourceTargetList[0].get(k);
            sNewColumnName = (String)m_alSourceTargetList[3].get(k);
            String sNewColumnNameQuote = (String)m_alSourceTargetList[2].get(k);
            if (sbfSourceColList.indexOf(sOldColumnName) > -1 || sOldColumnName.equals(sNewColumnName)) continue;
            sbfSourceColList.append(sOldColumnNameQuote + "=" + sNewColumnNameQuote + "\n");
        }
        sbfSourceColList.append(")\n");
        codeSegment.addSourceCode(sbfSourceColList);
        codeSegment.unIndent().unIndent().unIndent().addSourceCode(")\n").addSourceCode("end = eof;\n").unIndent().unIndent();
        return codeSegment;
    }

    private ICodeSegment genRetainStatement(ICodeSegment codeSegment) {
        StringBuffer retainStatement = new StringBuffer();
        retainStatement.append("\nretain ");
        retainStatement.append(m_alMissingFlagNames.get(0) + "-" + m_alMissingFlagNames.get(m_LookupCount - 1) + " 0; \n\n");
        codeSegment.addSourceCode(retainStatement);
        return codeSegment;
    }

    private ICodeSegment genHashObjects(ICodeSegment codeSegment) throws CodegenException {
        if (!m_isUsingSetKeyTechnique) {
            codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.BuildHashObjects.comment.txt"));
        }
        codeSegment.addSourceCode("if (_n_ = 1) then \n").addSourceCode("do; \n").indent();
        for (int i = 0; i < m_LookupCount; ++i) {
            String sHashName = (String)m_alHashNames.get(i);
            if (!m_isUsingSetKeyTechnique) {
                codeSegment.addSourceCode("/* Build hash " + sHashName).addSourceCode(" from lookup table ").addSourceCode((String)m_alMasterList[i][4].get(0)).addSourceCode(" */ \n");
            }
            codeSegment.addSourceCode("nlobs = .; \n");
            ITransformTableOptions oLkpOptions = ((LookupMapping)m_oLkpTModel.getLookupMappings().get(i)).getTransformTableOption();
            String lkpDSOptions = "";
            if (oLkpOptions != null) {
                lkpDSOptions = oLkpOptions.getTableOptions(true, codeSegment.getCurrentServer());
            }
            codeSegment.addSourceCode("dsid = open(\"" + ((String)m_alMasterList[i][3].get(0)).replaceAll("\"", "\"\"")).addSourceCode(lkpDSOptions.length() > 0 ? lkpDSOptions.replaceAll("\"", "\"\"") : "").addSourceCode("\"); \n");
            codeSegment.addSourceCode("if (dsid > 0) then \n").addSourceCode("do; \n").indent().addSourceCode("if ( attrc(dsid, 'MTYPE') = 'DATA' ) then \n").indent().addSourceCode("nlobs = attrn(dsid, 'NLOBS'); \n").unIndent().addSourceCode("else \n").indent().addSourceCode("nlobs = -1; \n\n").unIndent().addSourceCode("dsid = close(dsid); \n").addSourceCode("if (nlobs ^= 0) then \n").addSourceCode("do; \n").indent();
            if (!m_isUsingSetKeyTechnique) {
                int j;
                codeSegment.addSourceCode("if (nlobs > 0) then \n").indent().addSourceCode("exponent = ceil(log2(nlobs)); \n").unIndent().addSourceCode("else \n").indent().addSourceCode("exponent = 8; \n").unIndent();
                codeSegment.addSourceCode("declare hash " + sHashName + "(dataset: \"").addSourceCode(((String)m_alMasterList[i][4].get(0)).replaceAll("\"", "\"\""));
                codeSegment.addSourceCode(lkpDSOptions.length() > 0 ? lkpDSOptions.replaceAll("\"", "\"\"") : "").addSourceCode("\", hashexp: exponent);\n");
                codeSegment.addSourceCode(sHashName + ".defineKey( \"" + m_alMasterList[i][6].get(0));
                for (j = 1; j < m_alMasterList[i][6].size(); ++j) {
                    codeSegment.addSourceCode("\",\n").indent().indent().indent().indent().indent().addSourceCode("\"" + m_alMasterList[i][6].get(j)).unIndent(5);
                }
                codeSegment.addSourceCode("\");\n");
                if (m_alMasterList[i][13].size() > 0) {
                    codeSegment.addSourceCode(sHashName + ".defineData(");
                    codeSegment.addSourceCode(" \"" + m_alMasterList[i][13].get(0));
                    for (j = 1; j < m_alMasterList[i][13].size(); ++j) {
                        codeSegment.addSourceCode("\",\n").indent().indent().indent().indent().indent().addSourceCode("\"" + m_alMasterList[i][13].get(j)).unIndent(5);
                    }
                    codeSegment.addSourceCode("\");\n");
                }
                codeSegment.addSourceCode(sHashName + ".defineDone();\n");
                codeSegment.addSourceCode("if (nlobs = -1) then \n").addSourceCode("do; \n").indent();
                codeSegment.addSourceCode("if (" + sHashName + ".Num_Items < 1) then\n").addSourceCode("do; \n").indent();
                this.genNoLookupRowsHandler(codeSegment, i);
                codeSegment.unIndent().addSourceCode("end; \n");
                codeSegment.unIndent().addSourceCode("end; \n");
            }
            codeSegment.unIndent().addSourceCode("end; \n");
            codeSegment.addSourceCode("else \n").addSourceCode("do; \n").indent();
            this.genNoLookupRowsHandler(codeSegment, i);
            codeSegment.unIndent().addSourceCode("end; \n");
            codeSegment.unIndent().addSourceCode("end; \n");
            codeSegment.addSourceCode("else \n").addSourceCode("do; \n").indent();
            codeSegment.genPutStatement(RB.getStringResource("LookupCodegen.NoTable.note.txt") + " " + m_alMasterList[i][4].get(0));
            codeSegment.addSourceCode("\n");
            if (this.getAbortOptionsForCondition(i, "DIS_CLOOKUPMISSING")) {
                codeSegment.genPutStatement(RB.getStringResource("LookupCodegen.AbortNoTable.note.txt") + " " + m_alMasterList[i][4].get(0));
                codeSegment.addSourceCode("\nabort ").addSourceCode(m_alActionOptionValues.get(0) + "; \n");
            } else {
                codeSegment.addSourceCode(m_alMissingFlagNames.get(i) + " = " + LOOKUP_MISSING_RC + "; \n");
                m_alMissingFlags.set(i, "DIS_CLOOKUPMISSING");
            }
            codeSegment.unIndent().addSourceCode("end; \n\n");
        }
        this.genCallMissingStatement(codeSegment);
        codeSegment.unIndent().addSourceCode("\nend;");
        if (!m_isUsingSetKeyTechnique) {
            codeSegment.addSourceCode(" /* " + RB.getStringResource("LookupCodegen.BuildHashComplete.comment.txt") + " */");
        }
        codeSegment.addSourceCode("\n\n");
        return codeSegment;
    }

    private ICodeSegment genNoLookupRowsHandler(ICodeSegment codeSegment, int i) {
        codeSegment.genPutStatement(RB.getStringResource("LookupCodegen.LookupNoRows.note.txt") + " " + m_alMasterList[i][4].get(0));
        if (this.getAbortOptionsForCondition(i, "DIS_CNOLOOKUPROWS")) {
            codeSegment.genPutStatement(RB.getStringResource("LookupCodegen.AbortLookupNoRows.note.txt") + " " + m_alMasterList[i][4].get(0));
            codeSegment.addSourceCode("\nabort ").addSourceCode(m_alActionOptionValues.get(0) + "; \n");
        } else {
            codeSegment.addSourceCode(m_alMissingFlagNames.get(i) + " = " + LOOKUP_NORECS_RC + "; \n");
            m_alMissingRowsFlags.set(i, "DIS_CNOLOOKUPROWS");
        }
        return codeSegment;
    }

    private ICodeSegment genFindCalls(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        codeSegment.addSourceCode("\n");
        for (int i = 0; i < m_LookupCount; ++i) {
            boolean needAssignment;
            int j;
            boolean checkMissing;
            String sHashName = (String)m_alHashNames.get(i);
            String sRcName = (String)m_alRCs.get(i);
            if (!m_isUsingSetKeyTechnique) {
                codeSegment.addCommentLine(RB.getStringResource("LookupCodegen.CurrentKeyInHash.comment.txt") + " " + sHashName + "?");
            }
            boolean bl = checkMissing = !((String)m_alMissingRowsFlags.get(i)).equalsIgnoreCase(NONE) || !((String)m_alMissingFlags.get(i)).equalsIgnoreCase(NONE);
            if (checkMissing) {
                codeSegment.addSourceCode("if (" + m_alMissingFlagNames.get(i) + " < 1) then \n").addSourceCode("do; \n").indent();
            }
            for (j = 0; j < m_alMasterList[i][20].size(); ++j) {
                int k;
                needAssignment = !m_bLkpQuoting[i] && !m_bSourceQuoting ? !((String)m_alMasterList[i][6].get(j)).equalsIgnoreCase((String)m_alMasterList[i][21].get(j)) : (k = ((String)m_alMasterList[i][6].get(j)).compareTo((String)m_alMasterList[i][21].get(j))) != 0;
            }
            if (!m_isUsingSetKeyTechnique) {
                String src_keyCol;
                int j2;
                StringBuilder sbFindString = new StringBuilder();
                if (!m_isRenameSourceColumn) {
                    for (j2 = 0; j2 < m_alMasterList[i][20].size(); ++j2) {
                        src_keyCol = (String)m_alMasterList[i][20].get(j2);
                        if (j2 > 0) {
                            sbFindString.append(", \n");
                        }
                        sbFindString.append("key: ").append(src_keyCol);
                    }
                } else {
                    for (j2 = 0; j2 < m_alMasterList[i][20].size(); ++j2) {
                        src_keyCol = (String)m_alMasterList[i][20].get(j2);
                        String srcKeyMaster = (String)m_alMasterList[i][21].get(j2);
                        for (int k = 0; k < m_alSourceTargetList[2].size(); ++k) {
                            String srcKeyMapping = (String)m_alSourceTargetList[1].get(k);
                            if (!srcKeyMaster.equals(srcKeyMapping)) continue;
                            src_keyCol = (String)m_alSourceTargetList[2].get(k);
                            break;
                        }
                        if (j2 > 0) {
                            sbFindString.append(", \n");
                        }
                        sbFindString.append("key: ").append(src_keyCol);
                    }
                }
                if (m_alMasterList[i][13].size() > 0) {
                    codeSegment.addSourceCode(sRcName + " = " + sHashName + ".find(" + sbFindString.toString() + ");\n");
                } else {
                    codeSegment.addSourceCode(sRcName + " = " + sHashName + ".check(" + sbFindString.toString() + ");\n");
                }
            } else {
                IPhysicalTable lookupTable = (IPhysicalTable)m_alMasterList[i][2].get(0);
                m_indexToUse = lookupTable.getIndexMatchingColumnsList(m_oLkpTModel.getLookupKeyColumns(i));
                String sLookupTable = (String)m_alMasterList[i][3].get(0);
                String sLookupKeyCol = (String)m_alMasterList[i][5].get(0);
                codeSegment.addSourceCode("set " + sLookupTable);
                StringBuffer sKeepStatement = new StringBuffer();
                sKeepStatement.append(" (keep=" + sLookupKeyCol);
                sKeepStatement.append(codeSegment.makeColumnList(m_alMasterList[i][12], "       ", false, " "));
                if (m_indexToUse != null) {
                    lookupTable.getDBMSType().genKeyedLookupStatement(codeSegment, lookupTable, m_indexToUse, false, lookupTable.getTableOptions(false, null, sKeepStatement.toString()));
                }
                codeSegment.addSourceCode(sRcName + " = _IORC_;\n");
                codeSegment.addSourceCode("_ERROR_ = 0;\n");
            }
            for (j = 0; j < m_alMasterList[i][12].size(); ++j) {
                if (!m_bLkpQuoting[i] && !m_bTargetQuoting) {
                    needAssignment = !((String)m_alMasterList[i][29].get(j)).equalsIgnoreCase((String)m_alMasterList[i][13].get(j));
                } else {
                    boolean bl2 = needAssignment = !((String)m_alMasterList[i][29].get(j)).equals((String)m_alMasterList[i][13].get(j));
                }
                if (!needAssignment) continue;
                codeSegment.addSourceCode((String)m_alMasterList[i][26].get(j)).addSourceCode(" = " + (String)m_alMasterList[i][12].get(j) + ";\n");
            }
            if (!checkMissing) continue;
            codeSegment.unIndent().addSourceCode("end; \n");
            codeSegment.addSourceCode("else \n").indent().addSourceCode(sRcName + " = " + m_alMissingFlagNames.get(i) + "; \n\n").unIndent();
        }
        return codeSegment;
    }

    private void setErrorAndExceptionInfo() throws CodegenException {
        m_bNeedErrorTable = false;
        IPhysicalTable errorTable = m_oLkpTModel.getErrorTable();
        if (errorTable != null && errorTable.getColumns().length != 0) {
            m_bNeedErrorTable = true;
        }
        m_bNeedExceptionTable = false;
        IPhysicalTable exceptionTable = m_oLkpTModel.getExceptionTable();
        if (exceptionTable != null && exceptionTable.getColumns().length != 0) {
            m_bNeedExceptionTable = true;
        }
    }

    private void setTempErrorAndExceptionInfo(ICodeSegment codeSegment) throws CodegenException {
        String sNewColumnName;
        String sOldColumnName;
        int j;
        int i;
        boolean isQuoting = codeSegment.isQuoting();
        if (m_bNeedErrorTable) {
            IPhysicalTable errorTable = m_oLkpTModel.getErrorTable();
            IColumn[] erSrcCols = errorTable.getColumns();
            m_bErrorColumnRename = false;
            block0: for (i = 0; i < erSrcCols.length; ++i) {
                String erSrcColName = erSrcCols[i].getName();
                for (j = 0; j < m_alSourceTargetList[3].size(); ++j) {
                    sOldColumnName = (String)m_alSourceTargetList[1].get(j);
                    sNewColumnName = (String)m_alSourceTargetList[3].get(j);
                    if (!erSrcColName.equalsIgnoreCase(sOldColumnName)) continue;
                    if (erSrcColName.equalsIgnoreCase(sNewColumnName) || m_bErrorColumnRename) continue block0;
                    m_bErrorColumnRename = true;
                    continue block0;
                }
            }
            if (m_bErrorColumnRename) {
                m_TempErrorTableName = isQuoting ? "work." + DBMSNamesUtil.getQuotedString(codeSegment.getUniqueWorkTableName(), false) : codeSegment.getUniqueWorkTableName(true, 0);
            }
        }
        if (m_bNeedExceptionTable) {
            IPhysicalTable exceptionTable = m_oLkpTModel.getExceptionTable();
            IColumn[] exSrcCols = exceptionTable.getColumns();
            m_bExceptionColumnRename = false;
            block2: for (i = 0; i < exSrcCols.length; ++i) {
                String exSrcColName = exSrcCols[i].getName();
                for (j = 0; j < m_alSourceTargetList[3].size(); ++j) {
                    sOldColumnName = (String)m_alSourceTargetList[1].get(j);
                    sNewColumnName = (String)m_alSourceTargetList[3].get(j);
                    if (!exSrcColName.equalsIgnoreCase(sOldColumnName)) continue;
                    if (exSrcColName.equalsIgnoreCase(sNewColumnName) || m_bExceptionColumnRename) continue block2;
                    m_bExceptionColumnRename = true;
                    continue block2;
                }
            }
            if (m_bExceptionColumnRename) {
                m_TempExceptionTableName = isQuoting ? "work." + DBMSNamesUtil.getQuotedString(codeSegment.getUniqueWorkTableName(), false) : codeSegment.getUniqueWorkTableName(true, 0);
            }
        }
    }

    private boolean tableHasColumn(List columns, String colName) {
        for (int n = 0; n < columns.size(); ++n) {
            if (!colName.equalsIgnoreCase(((IColumn)columns.get(n)).getName())) continue;
            return true;
        }
        return false;
    }

    private ICodeSegment renameLookupDataColumns(ICodeSegment codeSegment) {
        if (m_LookupCount < 2) {
            return codeSegment;
        }
        List lLkpMappings = m_oLkpTModel.getLookupMappings();
        for (int j = 0; j < m_LookupCount; ++j) {
            LookupMapping lkpMapping_j = (LookupMapping)lLkpMappings.get(j);
            if (!lkpMapping_j.getType().equals("lookup")) continue;
            IMapping[] aLkpDataMaps = lkpMapping_j.getDataMappings().getMappings();
            for (int n = 0; n < aLkpDataMaps.length; ++n) {
                IMapping lkpToTarMapping_n = aLkpDataMaps[n];
                IColumn[] lSources = lkpToTarMapping_n.getSources();
                IColumn[] lTargets = lkpToTarMapping_n.getTargets();
                if (lSources.length <= 0 || lTargets.length <= 0) continue;
                String sLkpDataColName = lSources[0].getName();
                String sDataTrgColName = lTargets[0].getName();
                for (int k = j + 1; k < m_LookupCount; ++k) {
                    LookupMapping lkpMappingNext = (LookupMapping)lLkpMappings.get(k);
                    if (!lkpMappingNext.getType().equals("lookup")) continue;
                    IMapping[] aLkpDataMapsNext = lkpMappingNext.getDataMappings().getMappings();
                    for (int m = 0; m < aLkpDataMapsNext.length; ++m) {
                        String sLkpDataColNameNext;
                        IMapping lkpToTarMappingNext = aLkpDataMapsNext[m];
                        IColumn[] lNextSources = lkpToTarMappingNext.getSources();
                        if (lNextSources.length <= 0 || !(sLkpDataColNameNext = lNextSources[0].getName()).equals(sLkpDataColName) && !sLkpDataColNameNext.equals(sDataTrgColName)) continue;
                        String sNewName = "ETLS_" + codeSegment.getUniqueWorkTableName();
                        m_alMasterList[k][13].set(m, sNewName);
                        m_alMasterList[k][12].set(m, sNewName);
                        m_alMasterList[k][18].set(0, new Boolean(true));
                    }
                }
            }
        }
        return codeSegment;
    }

    private ICodeSegment renameKeyColumns(ICodeSegment codeSegment) {
        for (int k = 0; k < m_alSourceTargetList[3].size(); ++k) {
            String sSourceColName = (String)m_alSourceTargetList[1].get(k);
            String sTargetColName = (String)m_alSourceTargetList[3].get(k);
            boolean bSrcMainMatchesTrgName = !m_bSourceQuoting && !m_bTargetQuoting ? sSourceColName.equalsIgnoreCase(sTargetColName) : sSourceColName.equals(sTargetColName);
            if (bSrcMainMatchesTrgName) {
                m_alSourceTargetList[4].set(k, new Boolean(false));
            }
            for (int j = 0; j < m_LookupCount; ++j) {
                String sNewName;
                for (int n = 0; n < m_alMasterList[j][6].size(); ++n) {
                    int iLocation;
                    String sCurrentSrcKeyColName;
                    String sCurrentLkpKeyColName = (String)m_alMasterList[j][6].get(n);
                    boolean bSrcTarMatchesLkpKeyName = !m_bTargetQuoting && !m_bLkpQuoting[j] ? sCurrentLkpKeyColName.equalsIgnoreCase(sTargetColName) : sCurrentLkpKeyColName.equals(sTargetColName);
                    if (bSrcTarMatchesLkpKeyName) {
                        sCurrentSrcKeyColName = (String)m_alMasterList[j][21].get(n);
                        boolean bSrcKeyMatchesLkpKeyName = !m_bSourceQuoting && !m_bLkpQuoting[j] ? sCurrentSrcKeyColName.equalsIgnoreCase(sCurrentLkpKeyColName) : sCurrentSrcKeyColName.equals(sCurrentLkpKeyColName);
                        if (sCurrentSrcKeyColName.equals(sSourceColName)) {
                            m_alSourceTargetList[4].set(k, new Boolean(false));
                            continue;
                        }
                        sNewName = "ETLS_" + codeSegment.getUniqueWorkTableName();
                        m_alMasterList[j][6].set(n, sNewName);
                        m_alMasterList[j][5].set(n, sNewName);
                        m_alMasterList[j][9].set(0, new Boolean(true));
                        if (!bSrcKeyMatchesLkpKeyName) continue;
                        sNewName = "ETLS_" + codeSegment.getUniqueWorkTableName();
                        m_alMasterList[j][21].set(n, sNewName);
                        m_alMasterList[j][20].set(n, sNewName);
                        m_bNeedRenameSourceColumns = true;
                        iLocation = m_alSourceTargetList[1].indexOf(sCurrentSrcKeyColName);
                        if (iLocation <= -1) continue;
                        m_alSourceTargetList[1].set(iLocation, sNewName);
                        m_alSourceTargetList[0].set(iLocation, sNewName);
                        continue;
                    }
                    if (bSrcMainMatchesTrgName) continue;
                    sCurrentSrcKeyColName = (String)m_alMasterList[j][21].get(n);
                    boolean bSrcKeyMatchesTrgName = !m_bTargetQuoting && !m_bLkpQuoting[j] ? sCurrentSrcKeyColName.equalsIgnoreCase(sTargetColName) : sCurrentSrcKeyColName.equals(sTargetColName);
                    if (!bSrcKeyMatchesTrgName) continue;
                    sNewName = "ETLS_" + codeSegment.getUniqueWorkTableName();
                    m_alMasterList[j][21].set(n, sNewName);
                    m_alMasterList[j][20].set(n, sNewName);
                    m_bNeedRenameSourceColumns = true;
                    iLocation = m_alSourceTargetList[1].indexOf(sCurrentSrcKeyColName);
                    if (iLocation <= -1) continue;
                    m_alSourceTargetList[1].set(iLocation, sNewName);
                    m_alSourceTargetList[0].set(iLocation, sNewName);
                }
                for (int n = 0; n < m_alMasterList[j][13].size(); ++n) {
                    String sCurrentLkpDataColName = (String)m_alMasterList[j][13].get(n);
                    boolean bSrcTarMatchesLkpDataName = !m_bLkpQuoting[j] && !m_bTargetQuoting ? sCurrentLkpDataColName.equalsIgnoreCase(sTargetColName) : sCurrentLkpDataColName.equals(sTargetColName);
                    if (!bSrcTarMatchesLkpDataName) continue;
                    sNewName = "ETLS_" + codeSegment.getUniqueWorkTableName();
                    m_alMasterList[j][13].set(n, sNewName);
                    m_alMasterList[j][12].set(n, sNewName);
                    m_alMasterList[j][18].set(0, new Boolean(true));
                }
            }
        }
        return codeSegment;
    }

    public ICodeSegment getErrorExceptionMappingCode(ICodeSegment codeSegment, ITable sourceTable, ITable targetTable, String targetTableName, String sourceTableName, String sourceTableOptions, String targetTableOptions, boolean createView, boolean genComments, boolean genLabelStatements) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        boolean bGenerateFormatsInformats = true;
        bGenerateFormatsInformats = m_oLkpTModel.isFormatGenerationEnabled();
        if (genComments) {
            codeSegment.addSectionComment("Map the columns");
        }
        IColumn[] targetColumns = targetTable.getColumns();
        IColumn[] sourceColumns = sourceTable.getColumns();
        codeSegment.addSourceCode("proc sql");
        codeSegment.addSourceCode(";\n").indent().addSourceCode("create");
        if (createView) {
            codeSegment.addSourceCode(" view ");
        } else {
            codeSegment.addSourceCode(" table ");
        }
        if (targetTableName == null || targetTableName.length() == 0) {
            targetTableName = "work.mapped";
        } else if (!(targetTableName.indexOf(46) != -1 || targetTable != null && targetTable.isWebStreamDataTarget())) {
            targetTableName = "work." + targetTableName;
        }
        codeSegment.addSourceCode(targetTableName);
        if (targetTableOptions != null && targetTableOptions.length() > 0) {
            codeSegment.addSourceCode("\n").indent().addSourceCode("(").addSourceCode(targetTableOptions).addSourceCode(")").unIndent().addSourceCode("\n");
        }
        codeSegment.addSourceCode(" as\n").indent().addSourceCode("select");
        codeSegment.addSourceCode("\n").indent();
        String commaNewLine = "";
        for (int i = 0; i < targetColumns.length; ++i) {
            IColumn targetColumn = targetColumns[i];
            IColumn sourceColumn = sourceColumns[i];
            codeSegment.addSourceCode(commaNewLine);
            if (!targetColumn.equalsName(sourceColumn, codeSegment.isQuoting())) {
                codeSegment.addSourceCode(sourceColumn.getColumnName(codeSegment.isQuoting()));
                codeSegment.addSourceCode(" as ");
            }
            codeSegment.addSourceCode(targetColumn.getColumnName(codeSegment.isQuoting()));
            if (targetColumn.getType() != sourceColumn.getType() || targetColumn.getLength() != sourceColumn.getLength()) {
                codeSegment.addSourceCode(" ").addSourceCode(targetColumn.getLengthStatement(false));
            }
            codeSegment.indent();
            if (bGenerateFormatsInformats) {
                if (!targetColumn.equalsFormat(sourceColumn) && !"".equals(targetColumn.getFormat())) {
                    codeSegment.addSourceCode("\n").addSourceCode(targetColumn.getFormatStatement());
                }
                if (!targetColumn.equalsInformat(sourceColumn) && !"".equals(targetColumn.getInformat())) {
                    codeSegment.addSourceCode("\n").addSourceCode(targetColumn.getInformatStatement());
                }
            }
            if (genLabelStatements && !"".equals(targetColumn.getDescription()) && !targetColumn.equalsLabel(sourceColumn)) {
                codeSegment.addSourceCode("\n").addSourceCode(targetColumn.getLabelStatement());
            }
            codeSegment.unIndent();
            commaNewLine = ",\n";
        }
        codeSegment.addSourceCode("\n");
        if (sourceTableName == null || sourceTableName.length() == 0) {
            sourceTableName = sourceTable.getFullNameQuotedAsNeeded(codeSegment);
        }
        codeSegment.unIndent().unIndent().addSourceCode("from ").addSourceCode(sourceTableName).addSourceCode("\n");
        if (sourceTableOptions != null && sourceTableOptions.length() > 0) {
            codeSegment.indent().addSourceCode("(").addSourceCode(sourceTableOptions).addSourceCode(")").unIndent().addSourceCode("\n");
        }
        codeSegment.addSourceCode(";\n").unIndent().addSourceCode("quit;\n\n");
        codeSegment.addSourceCode("%let SYSLAST = ").addSourceCode(targetTableName).addSourceCode(";\n\n");
        return codeSegment;
    }

    static {
        LOOKUP_MISSING_TXT = RB.getStringResource("LookupCodegen.TextForExceptionColumn.LookupMissing.txt");
        LOOKUP_NORECS_TXT = RB.getStringResource("LookupCodegen.TextForExceptionColumn.NoLookupRows.txt");
        LOOKUP_FAILED_TXT = RB.getStringResource("LookupCodegen.TextForExceptionColumn.LookupFailed.txt");
        WRITE_EXCEPTION_TXT = RB.getStringResource("LookupCodegen.TextForExceptionColumn.WriteException.txt");
        m_TempErrorTableName = "";
        m_TempExceptionTableName = "";
    }
}

