/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.hpf;

import com.sas.etl.models.IModel;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.impl.RB;
import java.util.List;

public class HPFMapping
extends BaseMapping {
    public HPFMapping(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public boolean isComplete() {
        if ("ONETOONE".equals(this.getType())) {
            return this.isSourceAndTargetComplete();
        }
        return this.getExpression() == null || this.getExpression().isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.getTargets().length == 0 && this.isOrdinary()) {
            lReasons.add(RB.getStringResource("HPFMapping.ReasonIncomplete.MissingTarget.txt"));
        }
        if ("ONETOONE".equals(this.getType())) {
            if (this.getTargets().length > 1) {
                lReasons.add(RB.getStringResource("HPFMapping.ReasonIncomplete.TooManyTargets.txt"));
            }
            if (this.getSources().length == 0) {
                lReasons.add(RB.getStringResource("HPFMapping.ReasonIncomplete.OneToOne.MissingSource.txt"));
            }
            if (this.getSources().length > 1) {
                lReasons.add(RB.getStringResource("HPFMapping.ReasonIncomplete.OneToOne.TooManySources.txt"));
            }
        } else if ("DERIVED".equals(this.getType()) && this.getExpression() != null) {
            lReasons.addAll(this.getExpression().getReasonsIncomplete());
        }
        return lReasons;
    }

    @Override
    public String getWarning() {
        return null;
    }
}

