/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.hpa;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.SASIOLAType;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.hpa.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ILASRServer;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class LASRLoaderTransformModel
extends AbstractDataTransform {
    public static final String UPDATE_TABLE_METADATA_CHANGED = "GeneratedTransformModel:UpdateTableMetadataChanged";
    private static final String TRANSFORMATION_CLASS = "LASRLoader";
    private static final String TRANSFORMATION_ROLE = "LASRLoader";
    private static final String ARM_DISPLAY_NAME = "SAS LASR Analytic Server Loader";
    private static final String DELETE_TARGETS = "DELETE_TARGETS";
    public static final String DELETE_TARGETS_CHANGED = "LASRLoaderTransformModel:DeleteTargetsChanged";
    public static final String USE_SASIOLA_CHANGED = "LASRLoaderTransformModel:UseSASIOLA";
    private boolean m_bDeleteTargets;
    private static final String ADDITIONAL_PROC_OPTIONS = "ADDITIONAL_PROC_OPTIONS";
    private static final String ADDITIONAL_PROC_OPTIONS_CHANGED = "LasrLoaderTransformModel:ADDITIONAL_PROC_OPTIONS_CHANGED";
    private String m_additionalProcOpts;
    private static final String SASIOLA_METHOD = "SASIOLA_METHOD";
    private boolean _useSASIOLAFor;
    private boolean m_bUpdateTableMetadata;
    static final String UPDATE_TABLE_METADATA_PROMPT_NAME = "UpdateTargetMetadata";

    public LASRLoaderTransformModel(String sID, IModel model) {
        super(sID, model);
        this.setDeleteTargets(true);
        this._useSASIOLAFor = true;
        this.m_bUpdateTableMetadata = true;
    }

    @Override
    public String getDefaultName() {
        return RB.getStringResource("LASRLoaderTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("LASRLoaderTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getTransformRole() {
        return "LASRLoader";
    }

    @Override
    protected String getTransformClass() {
        return "LASRLoader";
    }

    public static String getTransformTypeID() {
        return "LASRLoader";
    }

    @Override
    public boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    public boolean isSASIOLALoadMethod() {
        return this._useSASIOLAFor;
    }

    public void setSASIOLALoadMethod(boolean useSASIOLA) {
        if (useSASIOLA == this._useSASIOLAFor) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSASIOLAUndoable(this._useSASIOLAFor, useSASIOLA));
        }
        this._useSASIOLAFor = useSASIOLA;
        this.fireModelChangedEvent(USE_SASIOLA_CHANGED, useSASIOLA);
    }

    public boolean isDeleteTargets() {
        return this.m_bDeleteTargets;
    }

    public void setDeleteTargets(boolean deleteTargets) {
        if (deleteTargets == this.m_bDeleteTargets) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDeleteTargetsUndoable(this.m_bDeleteTargets, deleteTargets));
        }
        this.m_bDeleteTargets = deleteTargets;
        this.fireModelChangedEvent(DELETE_TARGETS_CHANGED, deleteTargets);
    }

    public String getAdditionalProcOptions() {
        return this.m_additionalProcOpts;
    }

    public void setAdditionalProcOptions(String opts) {
        if (ObjectComparator.isEqual(opts, this.m_additionalProcOpts)) {
            return;
        }
        String old = this.m_additionalProcOpts;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAdditionalProcOptionsUndoable(this.m_additionalProcOpts, opts));
        }
        this.m_additionalProcOpts = opts;
        this.fireModelChangedEvent(ADDITIONAL_PROC_OPTIONS_CHANGED, this.m_additionalProcOpts, old);
    }

    public boolean isUpdateTableMetadata() {
        return this.m_bUpdateTableMetadata;
    }

    public void setUpdateTableMetadata(boolean doUpdate) {
        if (doUpdate == this.m_bUpdateTableMetadata) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUpdateTableMetadataUndoable(this.m_bUpdateTableMetadata, doUpdate));
        }
        this.m_bUpdateTableMetadata = doUpdate;
        this.fireModelChangedEvent(UPDATE_TABLE_METADATA_CHANGED, null);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.saveStringOptionToOMR(omr, UPDATE_TABLE_METADATA_PROMPT_NAME, this.isUpdateTableMetadata() ? "YES" : "NO");
        this.saveBooleanOptionToOMR(omr, DELETE_TARGETS, this.isDeleteTargets());
        this.saveStringOptionToOMR(omr, ADDITIONAL_PROC_OPTIONS, this.getAdditionalProcOptions());
        this.saveBooleanOptionToOMR(omr, SASIOLA_METHOD, this.isSASIOLALoadMethod());
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setDeleteTargets(this.loadBooleanOptionFromOMR(omr, DELETE_TARGETS, true));
        this.setAdditionalProcOptions(this.loadStringOptionFromOMR(omr, ADDITIONAL_PROC_OPTIONS, null));
        if (null == this.findProperty(omr, omr.acquireOMRObject(this), "OPTIONS", SASIOLA_METHOD, 0)) {
            this.setSASIOLALoadMethod(false);
        } else {
            this.setSASIOLALoadMethod(this.loadBooleanOptionFromOMR(omr, SASIOLA_METHOD, true));
        }
        if (null == this.findProperty(omr, omr.acquireOMRObject(this), "OPTIONS", UPDATE_TABLE_METADATA_PROMPT_NAME, 0)) {
            this.setUpdateTableMetadata(false);
        } else {
            this.setUpdateTableMetadata("YES".equals(this.loadStringOptionFromOMR(omr, UPDATE_TABLE_METADATA_PROMPT_NAME, "YES")));
        }
        this.setChanged(false);
    }

    public ILASRServer getLASRServer() {
        IServer server;
        IPhysicalTable table;
        if (this.getDataTargetsCount() > 0 && (table = (IPhysicalTable)this.getDataTargets()[0]).getDBMSType() instanceof SASIOLAType && (server = table.getDatabaseServer()) instanceof ILASRServer) {
            return (ILASRServer)server;
        }
        return null;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        if (this.isDeleteTargets()) {
            target.genTableDelete(codeSegment);
        }
        if (this.isSASIOLALoadMethod()) {
            ITransformTableOptions sourceOptions = this.getTableOptionObject(source, true);
            ITransformTableOptions targetOptions = this.getTableOptionObject(target, false);
            codeSegment.addSourceCode("data ").addSourceCode(target.getFullNameQuotedAsNeeded(codeSegment));
            String targetTableOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
            if (targetTableOptions != null && targetTableOptions.length() > 0) {
                codeSegment.indent().addSourceCode("(" + targetTableOptions + ") \n").unIndent();
            }
            codeSegment.addSourceCode(";").newLine();
            codeSegment.addSourceCode("set ").addSourceCode(source.getFullNameQuotedAsNeeded(codeSegment));
            String sourceTableOptions = sourceOptions.getTableOptions(codeSegment.getCurrentServer());
            if (sourceTableOptions != null && sourceTableOptions.length() > 0) {
                codeSegment.indent().addSourceCode("(" + sourceTableOptions + ") \n").unIndent();
            }
            codeSegment.addSourceCode(";").newLine();
            codeSegment.addSourceCode("run;").newLine();
        } else {
            String add;
            codeSegment.addSourceCode("proc lasr port = ").addSourceCode(Integer.toString(this.getLASRServer().getPort())).addSourceCode(" data = ").addSourceCode(source.getFullNameQuotedAsNeeded(codeSegment));
            ITransformTableOptions sourceOptions = this.getTableOptionObject(source, true);
            String sourceTableOptions = sourceOptions.getTableOptions(codeSegment.getCurrentServer());
            if (sourceTableOptions != null && sourceTableOptions.length() > 0) {
                codeSegment.indent().addSourceCode("(" + sourceTableOptions + ") \n").unIndent();
            }
            codeSegment.addSourceCode(" add");
            String signerURI = this.getLASRServer().getSignerURI();
            if (signerURI != null && signerURI.length() > 0) {
                codeSegment.addSourceCode(" SIGNER=").addSourceCode('\"' + signerURI + '\"');
            }
            if ((add = this.getAdditionalProcOptions()) != null && add.length() > 0) {
                codeSegment.addSourceCode(" ").addSourceCode(add);
            }
            codeSegment.addSourceCode(";");
            codeSegment.newLine();
            codeSegment.indent();
            StringBuffer formats = new StringBuffer();
            for (IColumn c : target.getColumns()) {
                String format = c.getValidFormat();
                if (format == null || format.length() <= 0) continue;
                formats.append(c.getColumnName(codeSegment)).append(" ").append(format).append("\n");
            }
            if (formats.length() > 0) {
                codeSegment.addSourceCode("format\n").indent().addSourceCode(formats).unIndent().addSourceCode(";\n");
            }
            codeSegment.addSourceCode("performance host = \"").addSourceCode(this.getLASRServer().getHost()).addSourceCode("\"\n").addSourceCode(";");
            codeSegment.newLine();
            codeSegment.unIndent();
            codeSegment.addSourceCode("run;\n");
        }
        codeSegment.newLine();
        if (this.isUpdateTableMetadata()) {
            codeSegment.addSourceCode(target.getUpdateTableMetadataCode()).addSourceCode("\n");
        }
        return codeSegment;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && ((IPhysicalTable)this.getDataTargets()[0]).getDBMSType() instanceof SASIOLAType && this.doSourceAndTargetNamesMatch();
    }

    private boolean doSourceAndTargetNamesMatch() {
        if (this.isSASIOLALoadMethod()) {
            return true;
        }
        if (this.getDataSourcesCount() > 0 && this.getDataTargetsCount() > 0) {
            IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
            IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
            if (!source.getTableName().equalsIgnoreCase(target.getTableName())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (this.getDataTargetsCount() > 0 && !(((IPhysicalTable)this.getDataTargets()[0]).getDBMSType() instanceof SASIOLAType)) {
            reasons.add(RB.getStringResource("LASRLoaderTransformModel.TargetTableError.txt"));
        }
        if (!this.doSourceAndTargetNamesMatch()) {
            reasons.add(RB.getStringResource("LASRLoaderTransformModel.SourceTargetNameMatchError.txt"));
        }
        return reasons;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new OptionModel();
    }

    private class SetSASIOLAUndoable
    extends AbstractUndoableEdit {
        private boolean m_old;
        private boolean m_new;

        public SetSASIOLAUndoable(boolean bOld, boolean bNew) {
            this.m_old = bOld;
            this.m_new = bNew;
        }

        @Override
        public void undo() {
            super.undo();
            LASRLoaderTransformModel.this.setSASIOLALoadMethod(this.m_old);
        }

        @Override
        public void redo() {
            super.redo();
            LASRLoaderTransformModel.this.setSASIOLALoadMethod(this.m_new);
        }
    }

    private class SetDeleteTargetsUndoable
    extends AbstractUndoableEdit {
        private boolean m_old;
        private boolean m_new;

        public SetDeleteTargetsUndoable(boolean bOld, boolean bNew) {
            this.m_old = bOld;
            this.m_new = bNew;
        }

        @Override
        public void undo() {
            super.undo();
            LASRLoaderTransformModel.this.setDeleteTargets(this.m_old);
        }

        @Override
        public void redo() {
            super.redo();
            LASRLoaderTransformModel.this.setDeleteTargets(this.m_new);
        }
    }

    private class SetAdditionalProcOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_old;
        private String m_new;

        public SetAdditionalProcOptionsUndoable(String sOld, String sNew) {
            this.m_old = sOld;
            this.m_new = sNew;
        }

        @Override
        public void undo() {
            super.undo();
            LASRLoaderTransformModel.this.setAdditionalProcOptions(this.m_old);
        }

        @Override
        public void redo() {
            super.redo();
            LASRLoaderTransformModel.this.setAdditionalProcOptions(this.m_new);
        }
    }

    private class SetUpdateTableMetadataUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldUpdateTableMetadata;
        private boolean m_newUpdateTableMetadata;

        public SetUpdateTableMetadataUndoable(boolean oldUpdateTableMetadata, boolean newUpdateTableMetadata) {
            this.m_oldUpdateTableMetadata = oldUpdateTableMetadata;
            this.m_newUpdateTableMetadata = newUpdateTableMetadata;
        }

        @Override
        public void undo() {
            super.undo();
            LASRLoaderTransformModel.this.setUpdateTableMetadata(this.m_oldUpdateTableMetadata);
        }

        @Override
        public void redo() {
            super.redo();
            LASRLoaderTransformModel.this.setUpdateTableMetadata(this.m_newUpdateTableMetadata);
        }
    }

    protected class OptionModel
    extends BaseDataTransformPromptModel
    implements IPromptModel {
        public OptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(LASRLoaderTransformModel.this.getModel(), LASRLoaderTransformModel.this);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(LASRLoaderTransformModel.class.getResource("res/Options_LASR_Loader_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            this.setOptionValue(LASRLoaderTransformModel.DELETE_TARGETS, (Object)(LASRLoaderTransformModel.this.isDeleteTargets() ? "YES" : "NO"));
            this.setOptionValue(LASRLoaderTransformModel.ADDITIONAL_PROC_OPTIONS, (Object)LASRLoaderTransformModel.this.getAdditionalProcOptions());
            this.setOptionValue(LASRLoaderTransformModel.SASIOLA_METHOD, (Object)(LASRLoaderTransformModel.this.isSASIOLALoadMethod() ? "YES" : "NO"));
            this.setOptionValue(LASRLoaderTransformModel.UPDATE_TABLE_METADATA_PROMPT_NAME, (Object)(LASRLoaderTransformModel.this.isUpdateTableMetadata() ? "YES" : "NO"));
        }

        @Override
        protected IModelListener createModelListener() {
            return new PromptModelListener();
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new PromptChangeListener();
        }

        private class PromptModelListener
        extends BaseDataTransformModelListener {
            public PromptModelListener() {
                super(LASRLoaderTransformModel.this, OptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(LASRLoaderTransformModel.DELETE_TARGETS_CHANGED)) {
                        OptionModel.this.setOptionValue(LASRLoaderTransformModel.DELETE_TARGETS, (Object)(LASRLoaderTransformModel.this.isDeleteTargets() ? "YES" : "NO"));
                    } else if (LASRLoaderTransformModel.ADDITIONAL_PROC_OPTIONS_CHANGED.equals(type)) {
                        OptionModel.this.setOptionValue(LASRLoaderTransformModel.ADDITIONAL_PROC_OPTIONS, ev.getData());
                    } else if (LASRLoaderTransformModel.USE_SASIOLA_CHANGED.equals(type)) {
                        OptionModel.this.setOptionValue(LASRLoaderTransformModel.SASIOLA_METHOD, (Object)(LASRLoaderTransformModel.this.isSASIOLALoadMethod() ? "YES" : "NO"));
                    } else if (LASRLoaderTransformModel.UPDATE_TABLE_METADATA_CHANGED.equals(type)) {
                        OptionModel.this.setOptionValue(LASRLoaderTransformModel.UPDATE_TABLE_METADATA_PROMPT_NAME, (Object)(LASRLoaderTransformModel.this.isUpdateTableMetadata() ? "YES" : "NO"));
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class PromptChangeListener
        extends BaseDataTransformValueChangedListener {
            public PromptChangeListener() {
                super(LASRLoaderTransformModel.this, (IPromptModel)OptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (optionName.equals(LASRLoaderTransformModel.DELETE_TARGETS)) {
                        LASRLoaderTransformModel.this.setDeleteTargets("YES".equals(value));
                    } else if (LASRLoaderTransformModel.ADDITIONAL_PROC_OPTIONS.equals(optionName)) {
                        LASRLoaderTransformModel.this.setAdditionalProcOptions(value != null ? value.toString() : null);
                    } else if (LASRLoaderTransformModel.SASIOLA_METHOD.equals(optionName)) {
                        LASRLoaderTransformModel.this.setSASIOLALoadMethod("YES".equals(value));
                    } else if (LASRLoaderTransformModel.UPDATE_TABLE_METADATA_PROMPT_NAME.equals(optionName)) {
                        LASRLoaderTransformModel.this.setUpdateTableMetadata("YES".equals(value));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }
}

