/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataloader;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.util.UriComponentsBuilder;

public class RestApplicationUtil {
    public static final String DATA_LOADER_SHARED_SVCS_CLASSIDENTIFIER = "dmddmid.sharedservices";
    public static final String SAS_DATALOADER_SOFTWARECOMPONENT_XMLSELECT = "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @ClassIdentifier = 'dmddmid.sharedservices']\"/>";
    public static final String SAS_LOGON_SOFTWARECOMPONENT_XMLSELECT = "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @Name = 'Logon Manager 9.4']\"/>";
    public static final String SOFTWARE_COMPONENT_TEMPLATE = "<Templates><SoftwareComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ProductName=\"\"><DeployedComponents/><Trees/><PropertySets/></SoftwareComponent><Tree Name=\"\" PublicType=\"\"><ParentTree/><SoftwareComponents/></Tree><DeployedComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ><SourceConnections/><Properties/></DeployedComponent><PropertySet><SetProperties/></PropertySet><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" Hostname=\"\" Port=\"\" Service=\"\"/><Property PropertyName=\"\" DefaultValue=\"\" SQLType=\"\"/></Templates>";
    public static final String REGISTERED_SAS_APPLICATION = "Registered SAS Application";
    public static final String CONNECTION_URI = "Connection URI";
    public static final String SAS_LOGON_REST = "LogonTicketService REST";
    public static final String PATH = "Path";
    Logger _logger = LogManager.getLogger(RestApplicationUtil.class);
    private RepositoryInterface _repos;

    public RestApplicationUtil(RepositoryInterface repos) {
        this._repos = repos;
    }

    public URI getSASLogonRESTURI(boolean kerberosEnabled) throws ServiceException, RemoteException {
        URIAttributes attrs;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataSASLogonSoftwareComponent();
        if (this.populateURIAttributesFromSASLogonSoftwareComponents(sc, attrs = new URIAttributes(), kerberosEnabled ? null : SAS_LOGON_REST)) {
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).path(attrs.serviceEndpoint + (kerberosEnabled ? "/login" : attrs.restEndpoint)).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).path(attrs.serviceEndpoint + (kerberosEnabled ? "/login" : attrs.restEndpoint)).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Logon 9.4 software component");
        }
        return returnValue;
    }

    private BrowseMetadataInterface getBrowseMetadataDataLoaderSoftwareComponent() throws RemoteException, ServiceException {
        List<BrowseMetadataInterface> browseObjects = null;
        browseObjects = this.searchForObject(this._repos.getServer().getFoundationRepository(), 0, "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @ClassIdentifier = 'dmddmid.sharedservices']\"/><Templates><SoftwareComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ProductName=\"\"><DeployedComponents/><Trees/><PropertySets/></SoftwareComponent><Tree Name=\"\" PublicType=\"\"><ParentTree/><SoftwareComponents/></Tree><DeployedComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ><SourceConnections/><Properties/></DeployedComponent><PropertySet><SetProperties/></PropertySet><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" Hostname=\"\" Port=\"\" Service=\"\"/><Property PropertyName=\"\" DefaultValue=\"\" SQLType=\"\"/></Templates>", "SoftwareComponent", null);
        if (null == browseObjects || browseObjects.size() == 0) {
            throw new ServiceException("No software components found for = dmddmid.sharedservices");
        }
        BrowseMetadataInterface sc = browseObjects.get(0);
        if (browseObjects.size() > 1) {
            this._logger.warn("Expected 1 software component, but found: " + browseObjects.size());
        }
        return sc;
    }

    public String getDataLoaderSetting(String propertyName) throws RemoteException, ServiceException {
        List propertySets;
        Object assnObject;
        BrowseMetadataInterface sc = this.getBrowseMetadataDataLoaderSoftwareComponent();
        if (null != sc && null != (assnObject = sc.get("PropertySets")) && assnObject instanceof List && (propertySets = (List)assnObject).size() > 0) {
            for (BrowseMetadataInterface propertySet : propertySets) {
                Object props;
                Object propertySetName = propertySet.get("PropertySetName");
                if (!"Application Configuration".equals(propertySetName) || null == (props = propertySet.get("SetProperties")) || !(props instanceof List)) continue;
                List properties = (List)props;
                for (BrowseMetadataInterface prop : properties) {
                    if (propertyName == null || !propertyName.equals(prop.get("PropertyName"))) continue;
                    return (String)prop.get("DefaultValue");
                }
            }
        }
        return null;
    }

    private BrowseMetadataInterface getBrowseMetadataSASLogonSoftwareComponent() throws RemoteException, ServiceException {
        List<BrowseMetadataInterface> browseObjects = null;
        browseObjects = this.searchForObject(this._repos.getServer().getFoundationRepository(), 0, "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @Name = 'Logon Manager 9.4']\"/><Templates><SoftwareComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ProductName=\"\"><DeployedComponents/><Trees/><PropertySets/></SoftwareComponent><Tree Name=\"\" PublicType=\"\"><ParentTree/><SoftwareComponents/></Tree><DeployedComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ><SourceConnections/><Properties/></DeployedComponent><PropertySet><SetProperties/></PropertySet><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" Hostname=\"\" Port=\"\" Service=\"\"/><Property PropertyName=\"\" DefaultValue=\"\" SQLType=\"\"/></Templates>", "SoftwareComponent", null);
        if (null == browseObjects || browseObjects.size() == 0) {
            throw new ServiceException("No software components found for = Logon Manager 9.4");
        }
        BrowseMetadataInterface sc = browseObjects.get(0);
        if (browseObjects.size() > 1) {
            this._logger.warn("Expected 1 software component, but found: " + browseObjects.size());
        }
        return sc;
    }

    protected List<BrowseMetadataInterface> searchForObject(RepositoryInterface server, int omrFlags, String template, String objectType, FilterComponent filterComponent) throws RemoteException, ServiceException {
        ArrayList<BrowseMetadataInterface> browseObjects = new ArrayList<BrowseMetadataInterface>();
        if (server == null) {
            throw new IllegalArgumentException("Server was null, unable to execute search.");
        }
        Filter filter = new Filter();
        filter.setOMRFlags(omrFlags | 4 | 0x80 | 0x100 | 0x2000);
        filter.setOMRTemplate(template);
        filter.setType(objectType);
        if (filterComponent != null) {
            filter.setFilterComponent(filterComponent);
        }
        this._logger.debug("Executing search with filter: " + filter);
        List objects = server.browseSearch((FilterInterface)filter);
        for (Object bi : objects) {
            if (!(bi instanceof BrowseMetadataInterface)) continue;
            browseObjects.add((BrowseMetadataInterface)bi);
        }
        return browseObjects;
    }

    private boolean populateURIAttributesFromSASLogonSoftwareComponents(BrowseMetadataInterface sc, URIAttributes attrs, String restSvcName) {
        return this.populateURIAttributesFromSoftwareComponents(sc, attrs, restSvcName);
    }

    private boolean populateURIAttributesFromSoftwareComponents(BrowseMetadataInterface sc, URIAttributes attrs, String appDeployedComponentClassId) {
        List deployedComponents;
        Object assnObject;
        boolean returnValue = false;
        if (null != sc && null != (assnObject = sc.get("DeployedComponents")) && assnObject instanceof List && (deployedComponents = (List)assnObject).size() > 0) {
            for (BrowseMetadataInterface dc : deployedComponents) {
                Object props;
                if (REGISTERED_SAS_APPLICATION.equals(dc.getName())) {
                    Object srcConns = dc.get("SourceConnections");
                    if (null == srcConns || !(srcConns instanceof List)) continue;
                    List srcConnections = (List)srcConns;
                    for (BrowseMetadataInterface srcConn : srcConnections) {
                        if (!CONNECTION_URI.equals(srcConn.getName())) continue;
                        returnValue = true;
                        attrs.protocol = (String)srcConn.get("CommunicationProtocol");
                        attrs.hostName = (String)srcConn.get("HostName");
                        attrs.setPort((String)srcConn.get("Port"));
                        attrs.serviceEndpoint = (String)srcConn.get("Service");
                    }
                    continue;
                }
                if (appDeployedComponentClassId == null || !appDeployedComponentClassId.equals(dc.get("ClassIdentifier")) || null == (props = dc.get("Properties")) || !(props instanceof List)) continue;
                List properties = (List)props;
                for (BrowseMetadataInterface prop : properties) {
                    if (!PATH.equals(prop.get("PropertyName"))) continue;
                    attrs.restEndpoint = (String)prop.get("DefaultValue");
                }
            }
        }
        return returnValue;
    }

    private class URIAttributes {
        private static final String PROTOCOL_HTTPS = "https";
        private static final String PROTOCOL_HTTP = "http";
        String hostName;
        int port;
        String serviceEndpoint;
        String protocol;
        String restEndpoint;

        private URIAttributes() {
        }

        public void setPort(String inPort) {
            int p = Integer.parseInt(inPort);
            this.port = null != this.protocol && this.protocol.length() > 0 ? (this.protocol.equalsIgnoreCase(PROTOCOL_HTTP) && p != 80 ? p : (this.protocol.equalsIgnoreCase(PROTOCOL_HTTPS) && p != 443 ? p : p)) : Integer.parseInt(inPort);
        }

        public String getRESTPath() {
            return "" + this.serviceEndpoint + this.restEndpoint;
        }
    }
}

