/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataloader;

import com.ibm.icu.text.MessageFormat;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IGeneratedTable;
import com.sas.etl.models.data.IGeneratedTableColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractMultiplePortTransformModel;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.common.ITransformTemplate;
import com.sas.etl.models.job.transforms.common.impl.BaseTransformPort;
import com.sas.etl.models.job.transforms.dataloader.DataLoaderLinkTablePort;
import com.sas.etl.models.job.transforms.dataloader.IDirective;
import com.sas.etl.models.job.transforms.dataloader.RB;
import com.sas.etl.models.job.transforms.dataloader.RestApplicationUtil;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseTransformValueChangedListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class DataLoaderDirectiveTransformModel
extends AbstractMultiplePortTransformModel {
    public static final String TRANSFORMATION_CLASS = "com.sas.etl.models.job.transforms.dataloader.DataLoaderTransformModel";
    public static final String TRANSFORMATION_ROLE = "com.sas.etl.models.job.transforms.dataloader.DataLoaderTransformModel";
    private static final String ARM_DISPLAY_NAME = "Directive";
    public static final String DIRECTIVE_CHANGED = "Directive_Changed";
    private static final String CM_NAME = "Directive";
    public static final String LINK_TABLE_PORT = "LinkTablePort";
    public IDirective directive;
    private static final String COMPLETE = "completed";
    private static final String RUNNING = "running";
    private static final String FAILED = "failed";
    private static final String UNKNOWN = "unknown";
    private static final String CANCELED = "canceled";
    private static final String DIRECTIVEWAIT_OPTION = "DIRECTIVEWAIT";
    private static final String DELAYMINUTES_OPTION = "DELAYMINUTES";
    private static final String MAXWAITMINUTES_OPTION = "MAXWAITMINUTES";
    private static final String DIRECTIVEWAIT_CHANGED = "DIRECTIVEWAIT_CHANGED";
    private static final String DELAYMINUTES_CHANGED = "DELAYMINUTES_CHANGED";
    private static final String MAXWAITMINUTES_CHANGED = "MAXWAITMINUTES_CHANGED";
    private boolean waitForDirective;
    private double statusDelay;
    private Double timeout;
    private boolean kerberosEnabled;
    private static final boolean DEFAULT_WAITFOR = true;
    private static final Double DEFAULT_TIMEOUT = null;
    private static final double DEFAULT_DELAY = 0.5;
    private static final boolean DEFAULT_KERBEROS_ENABLED = false;

    public DataLoaderDirectiveTransformModel(String sID, IModel model) {
        super(sID, model);
        this.setWaitForDirective(true);
        this.setTimeout(DEFAULT_TIMEOUT);
        this.setDelayMinutes(0.5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getKerberosEnabled() {
        Object child = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            RestApplicationUtil util = new RestApplicationUtil(server.getFoundationRepository());
            boolean bl = "true".equals(util.getDataLoaderSetting("sasdm.use.kerberos"));
            return bl;
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            try {
                if (child != null) {
                    child.destroy();
                }
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return false;
    }

    public boolean getWaitForDirective() {
        return this.waitForDirective;
    }

    public void setWaitForDirective(boolean wait) {
        if (this.waitForDirective == wait) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetWaitForDirectiveUndoable(wait));
        }
        this.waitForDirective = wait;
        this.fireModelChangedEvent(DIRECTIVEWAIT_CHANGED, wait);
    }

    public double getDelayMinutes() {
        return this.statusDelay;
    }

    public void setDelayMinutes(double delay) {
        if (this.statusDelay == delay) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDelayMinutesUndoable(this.statusDelay, delay));
        }
        this.statusDelay = delay;
        this.fireModelChangedEvent(DELAYMINUTES_CHANGED, this.statusDelay);
    }

    public Double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Double timeout) {
        if (this.timeout == timeout) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTimeoutMinutesUndoable(this.timeout, timeout));
        }
        this.timeout = timeout;
        this.fireModelChangedEvent(MAXWAITMINUTES_CHANGED, timeout);
    }

    @Override
    public ITransformTemplate createDefaultTemplate() {
        ITransformTemplate t = super.createDefaultTemplate();
        t.setSourceMaximum(Integer.MAX_VALUE);
        t.setTargetMaximum(Integer.MAX_VALUE);
        ITransformPort<? extends IDataObject> outputPort = this.createNewPort(this.getModel(), this.getID(), "LinkPort");
        outputPort.setMaximum(1);
        outputPort.setOptional(false);
        t.addTargetPort(outputPort);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPortGeneratedTable(ITransformPort<IPhysicalTable> port) {
        IGeneratedTable<IGeneratedTableColumn> table;
        if (port != null && (table = port.getGeneratedTable()) != null) {
            this.startCompoundUndoable();
            try {
                IPhysicalTable pt = table.createNewTable(this.getSourceTable(), this.getModel(), this.getID());
                if (pt != null) {
                    port.setObject(pt);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    @Override
    public ITransformPort<? extends IDataObject> createPort(IModel model, String id, String partnerName) {
        BaseTransformPort port = null;
        if ("LinkPort".equals(partnerName)) {
            port = new DataLoaderLinkTablePort(id, model);
            port.setMinimum(0);
            port.setMaximum(1);
            port.setOptional(true);
        }
        if (port == null) {
            port = new BaseTransformPort(id, this.getModel());
            port.setMinimum(0);
            port.setMaximum(Integer.MAX_VALUE);
            port.setOptional(true);
        }
        port.setPartnerName(partnerName);
        return port;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("DataLoaderDirectiveTransformModel.Name.txt");
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoTargetsMeanIncomplete() {
        return false;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("DataLoaderDirectiveTransformModel.Name.txt");
    }

    @Override
    public String getAbsoluteName() {
        return "Directive";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.etl.models.job.transforms.dataloader.DataLoaderTransformModel";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.etl.models.job.transforms.dataloader.DataLoaderTransformModel";
    }

    public static String getTransformTypeID() {
        return "com.sas.etl.models.job.transforms.dataloader.DataLoaderTransformModel";
    }

    @Override
    public boolean isComplete() {
        boolean complete = super.isComplete();
        return complete && this.getDirective() != null;
    }

    @Override
    public List getReasonsIncomplete() {
        List lst = super.getReasonsIncomplete();
        if (this.getDirective() == null) {
            lst.add(RB.getStringResource("DataLoaderDirectiveTransformModel.NoDirective.txt"));
        }
        return lst;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        DataLoaderDirectiveTransformPromptModel model = new DataLoaderDirectiveTransformPromptModel(this.getModel(), this);
        return model;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        mdoCM.setTransformRole("Directive");
        AssociationList lSourceSpecifications = mdoCM.getSourceSpecifications();
        lSourceSpecifications.clear();
        IDirective flow = this.getDirective();
        if (flow != null) {
            Transformation mdoFlow = (Transformation)omr.acquireOMRObject(flow);
            lSourceSpecifications.add(mdoFlow);
        }
        this.saveDoubleOptionToOMR(omr, DELAYMINUTES_OPTION, this.getDelayMinutes());
        this.saveDoubleOptionToOMR(omr, MAXWAITMINUTES_OPTION, this.getTimeout());
        this.saveBooleanOptionToOMR(omr, DIRECTIVEWAIT_OPTION, this.getWaitForDirective());
        this.setChanged(false);
    }

    public IDirective getDirective() {
        return this.directive;
    }

    public void setDirective(IDirective br) {
        if (this.directive == br) {
            return;
        }
        this.startCompoundUndoable();
        IDirective old = this.directive;
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetDirectiveUndoable(this.directive, br));
            }
            this.directive = br;
            this.fireModelChangedEvent(DIRECTIVE_CHANGED, this.directive, old);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        ClassifierMap mdoCM;
        super.clearListsBeforeLoad();
        boolean changed = false;
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList lTransformations = mdoStep.getTransformations();
        if (!lTransformations.isEmpty()) {
            mdoCM = (ClassifierMap)lTransformations.get(0);
            this.setClassifierMapId(mdoCM.getFQID());
        }
        mdoCM = this.getClassifierMapObject(omr);
        AssociationList lSourceSpecs = mdoCM.getSourceSpecifications();
        IDirective rule = null;
        for (int iSource = 0; iSource < lSourceSpecs.size(); ++iSource) {
            Object mdObject = lSourceSpecs.get(iSource);
            if (!(mdObject instanceof Transformation) || !"Directive.DL".equals(((Transformation)mdObject).getPublicType())) continue;
            try {
                rule = (IDirective)omr.acquireObject((Root)mdObject);
                if (null != rule.getFolder()) {
                    this.setDirective(rule);
                    continue;
                }
                this.addToDeletedObjects(rule);
                changed = true;
                continue;
            }
            catch (MdException e) {
                this.setDirective(null);
            }
        }
        super.loadFromOMR(omr);
        this.setWaitForDirective(this.loadBooleanOptionFromOMR(omr, DIRECTIVEWAIT_OPTION, true));
        this.setDelayMinutes(this.loadDoubleOptionFromOMR(omr, DELAYMINUTES_OPTION, 0.5));
        this.setTimeout(this.loadDoubleOptionFromOMR(omr, MAXWAITMINUTES_OPTION, DEFAULT_TIMEOUT));
        this.setChanged(changed);
    }

    @Override
    protected boolean areExpressionsAllowed() {
        return false;
    }

    @Override
    protected void templateChangedRequested(ITransformTemplate newTemplate) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSASLogonUri(boolean isKerberos) {
        Object child = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            RestApplicationUtil util = new RestApplicationUtil(server.getFoundationRepository());
            URI webpage = util.getSASLogonRESTURI(isKerberos);
            String string = webpage.toString();
            return string;
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            try {
                if (child != null) {
                    child.destroy();
                }
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return null;
    }

    private ICodeSegment addProcHttpErrorCheck(ICodeSegment codeSegment, String headerFile) {
        codeSegment.addSourceCode("%fetch_http_return_code(fileref1=").addSourceCode(headerFile).addSourceCode(");\n\n");
        codeSegment.addSourceCode("%if (\"&etl_dl_proc_http_status\"=\"HTTP_ERROR\") %then\n").addSourceCode("%do;\n").indent().addSourceCode("data _null_;\n").indent().addSourceCode("%let sysrc = 9999;\n").addSourceCode("%rcSet(sysrc);\n").genPercentPutStatement(RB.getStringResource("DataLoaderDirectiveTransformModel.ProcHttpError.txt"), "ERROR%QUOTE(:)").genPercentPutStatement(MessageFormat.format((String)RB.getStringResource("DataLoaderDirectiveTransformModel.ProcHttpError.Returned.txt"), (Object[])new Object[]{"&etl_dl_http_return_code: &etl_dl_http_return_text"}), "ERROR%QUOTE(-)").addSourceCode("stop;\n").addSourceCode("%return;\n").unIndent().addSourceCode("run;\n").unIndent().addSourceCode("%end;\n");
        return codeSegment;
    }

    @Override
    protected ICodeSegment getCodeForTransform(ICodeSegment codeSegment, boolean isValidate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        boolean isKerberos = this.getKerberosEnabled();
        String responseFile = codeSegment.getUniqueWorkTableName();
        String headerFile = codeSegment.getUniqueWorkTableName();
        codeSegment.addSourceCode("%global etl_dl_state_method etl_dl_state_url etl_dl_http_return_code etl_dl_http_return_text etl_dl_proc_http_status;\n");
        codeSegment.addSourceCode("\n");
        codeSegment.addSourceCode("%macro fetch_http_return_code(fileref1=);\n").indent().addSourceCode("data _null_;\n").indent().addSourceCode("infile ").addSourceCode(headerFile).addSourceCode(" termstr=CRLF length=c scanover truncover;").addSourceCode("\n").addSourceCode("input @'HTTP/1.1' code 4. message $255.").addSourceCode(";\n").addSourceCode("call symputx('etl_dl_http_return_code',code);").addSourceCode("\n").addSourceCode("call symput('etl_dl_http_return_text',trim(message));").addSourceCode("\n").addSourceCode("/* Anything in the 200s is a success */\n").addSourceCode("if (code >= 200 AND code < 300) then\n").addSourceCode("do;\n").indent().addSourceCode("call symput('etl_dl_proc_http_status','HTTP_SUCCESS');\n").unIndent().addSourceCode("end;\n").addSourceCode("else\n").addSourceCode("do;\n").indent().addSourceCode("call symput('etl_dl_proc_http_status','HTTP_ERROR');\n").unIndent().addSourceCode("end;\n").addSourceCode("\n").addSourceCode("/* uncomment this line to send header file to log */\n").addSourceCode("*put _infile_;\n").unIndent().addSourceCode("run ;\n").unIndent().addSourceCode("%mend fetch_http_return_code;\n").addSourceCode("\n").addSourceCode("%macro runDirective();\n").indent().addSourceCode("\n");
        codeSegment.addSourceCode("filename ").addSourceCode(responseFile).addSourceCode(" TEMP;\n");
        codeSegment.addSourceCode("filename ").addSourceCode(headerFile).addSourceCode(" TEMP;\n");
        codeSegment.addSourceCode("\n");
        if (isKerberos) {
            codeSegment.addSourceCode("proc http method=\"").addSourceCode(isKerberos ? "GET" : "POST").addSourceCode("\" \n").indent().addSourceCode("url=\"").addSourceCode(this.getSASLogonUri(isKerberos)).addSourceCode("\" \n").addSourceCode("out = ").addSourceCode(responseFile).addSourceCode("\n").addSourceCode("headerout = ").addSourceCode(headerFile).addSourceCode(" HEADEROUT_OVERWRITE\n");
            if (isKerberos) {
                codeSegment.addSourceCode("AUTH_NEGOTIATE").addSourceCode(";\n");
            } else {
                codeSegment.addSourceCode("HTTP_TOKENAUTH").addSourceCode(";\n");
            }
            codeSegment.unIndent().addSourceCode("run;").addSourceCode("\n\n");
            this.addProcHttpErrorCheck(codeSegment, headerFile);
            codeSegment.addSourceCode("%local etl_hcode;").addSourceCode("\n").addSourceCode("%local etl_hmessage;").addSourceCode("\n").addSourceCode("%global etl_logon_tgt;").addSourceCode("\n\n").addSourceCode("data _null_;").addSourceCode("\n").indent().addSourceCode("infile ").addSourceCode(headerFile).addSourceCode(" termstr=CRLF length=c scanover truncover;").addSourceCode("\n").addSourceCode("input @'HTTP/1.1' code 4. message $255.").addSourceCode("\n").addSourceCode("@'Set-Cookie: CASTGC=' loc $255.").addSourceCode(";\n").addSourceCode("call symputx('etl_hcode',code);").addSourceCode("\n").addSourceCode("call symput('etl_hmessage',trim(message));").addSourceCode("\n").addSourceCode("call symput('etl_logon_tgt',trim(scan(loc,1,';')));").addSourceCode("\n").unIndent().addSourceCode("run;").addSourceCode("\n\n");
            codeSegment.addSourceCode("proc http method=\"POST\"").addSourceCode("\n").indent();
            codeSegment.addSourceCode("url=\"");
            codeSegment.addSourceCode(this.getSASLogonUri(false)).addSourceCode("/&etl_logon_tgt\"").addSourceCode("\n");
            codeSegment.addSourceCode("in=\"service=").addSourceCode(this.directive.getRestExecutionUrl().toString()).addSourceCode("\"").addSourceCode("\n").addSourceCode("out = ").addSourceCode(responseFile).addSourceCode("\n").addSourceCode("headerout = ").addSourceCode(headerFile).addSourceCode(" HEADEROUT_OVERWRITE;\n").unIndent().addSourceCode("run;").addSourceCode("\n\n");
            this.addProcHttpErrorCheck(codeSegment, headerFile);
            codeSegment.addSourceCode("%global etl_service_ticket;").addSourceCode("\n").addSourceCode("data _null_;").addSourceCode("\n").indent().addSourceCode("infile ").addSourceCode(responseFile).addSourceCode(";").addSourceCode("\n").addSourceCode("input @;").addSourceCode("\n").addSourceCode("call symput('etl_service_ticket',trim(_infile_));").addSourceCode("\n").unIndent().addSourceCode("run;").addSourceCode("\n\n");
        }
        codeSegment.addSourceCode("proc http method=\"POST\"\n").indent();
        codeSegment.addSourceCode("url = \"").addSourceCode(this.directive.getRestExecutionUrl().toString());
        if (isKerberos) {
            codeSegment.addSourceCode("%str(&)ticket=&etl_service_ticket.");
        }
        codeSegment.addSourceCode("\"\n");
        codeSegment.addSourceCode("out = ").addSourceCode(responseFile).addSourceCode("\n").addSourceCode("headerout = ").addSourceCode(headerFile).addSourceCode(" HEADEROUT_OVERWRITE\n");
        if (isKerberos) {
            codeSegment.addSourceCode("AUTH_NEGOTIATE ");
        } else {
            codeSegment.addSourceCode("HTTP_TOKENAUTH ");
        }
        codeSegment.addSourceCode(";\n").unIndent().addSourceCode("run;\n\n");
        this.addProcHttpErrorCheck(codeSegment, headerFile);
        codeSegment.addSourceCode("%else\n").addSourceCode("%do;\n").indent();
        codeSegment.addSourceCode("libname ").addSourceCode(responseFile).addSourceCode(" json ;\n");
        ITransformPort<? extends IDataObject> linksport = this.findPortByPartnerName("LinkPort", this.getTargetPorts());
        if (linksport != null && linksport.getObject() instanceof IPhysicalTable) {
            IPhysicalTable table = (IPhysicalTable)linksport.getObject();
            ITransformTableOptions targetOptions = this.getTableOptionObject(table, false);
            String options = null;
            if (null != targetOptions) {
                options = targetOptions.getTableOptions(false, codeSegment.getCurrentServer());
            }
            codeSegment.addSourceCode("data ").addSourceCode(table.getFullNameQuotedAsNeeded(codeSegment, false));
            if (StringUtils.isNotEmpty((String)options)) {
                codeSegment.addSourceCode("(").addSourceCode(options).addSourceCode(")");
            }
            codeSegment.addSourceCode(";\n").indent();
            table.getDBMSType().genscols(codeSegment, table);
            codeSegment.addSourceCode("set ").addSourceCode(responseFile).addSourceCode(".links;\n");
            String targetKeepList = codeSegment.makeColumnList(table.getColumns(), "   ", codeSegment.isQuoting(), " ");
            if (targetKeepList.length() > 0) {
                codeSegment.addSourceCode("keep ").addSourceCode(targetKeepList.toString()).addSourceCode("; \n");
            }
            codeSegment.unIndent().addSourceCode("run;\n");
        }
        codeSegment.unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%mend runDirective;\n").addSourceCode("\n").addSourceCode("%runDirective();\n\n");
        if (this.getWaitForDirective()) {
            String sDelayMinutes = String.valueOf(this.getDelayMinutes());
            Double timeout = this.getTimeout();
            codeSegment.addSourceCode("data _null_;\n").indent().addSourceCode("set ").addSourceCode(responseFile).addSourceCode(".links(where=(rel='state'));\n").addSourceCode("call symput('etl_dl_state_url',trim(left(href)));\n").addSourceCode("call symput('etl_dl_state_method',trim(left(method)));\n").unIndent().addSourceCode("run;\n\n");
            codeSegment.addSourceCode("%let etl_dl_state=").addSourceCode(RUNNING).addSourceCode(";\n\n");
            codeSegment.addSourceCode("%macro etl_waitfor_directive_finish(minutes_wait=, total_wait_time= );\n").indent().addSourceCode("\n").addSourceCode("%if (\"&etl_dl_proc_http_status\"=\"HTTP_ERROR\") %then\n").addSourceCode("%do;\n").indent().addSourceCode("/* Previous proc http errored.  Simply return */\n").addSourceCode("%return;\n").unIndent().addSourceCode("%end;\n").addSourceCode("\n").addSourceCode("%let local_total_wait=0;\n").addSourceCode("%let _starttime=%sysfunc(datetime());\n").addSourceCode("%do %until (&etl_dl_state ne ").addSourceCode(RUNNING).addSourceCode(");\n").indent().addSourceCode("\n").addSourceCode(" /*  Wait here */\n").addSourceCode("data _null_;\n").indent().addSourceCode("call sleep(&minutes_wait,60);\n").addSourceCode("\n").addSourceCode("%let _currenttime=%sysfunc(datetime());\n").addSourceCode("%let _runtime=%sysfunc(putn(&_currenttime-&_starttime,12.4));\n").addSourceCode("%let local_total_wait = %sysevalf(&_runtime/60);\n").addSourceCode("\n").addSourceCode("/* Check only if total wait time is greater than 0.  Default=0 (no time limit) */\n").addSourceCode("%if ( &total_wait_time > 0 && (&local_total_wait > &total_wait_time)) %then\n%do;\n").indent().addSourceCode("%let sysrc = 9999;\n").addSourceCode("%rcSet(sysrc);\n").genPercentPutStatement(RB.getStringResource("DataLoaderDirectiveMaximumTimeReached.Error.txt"), "ERROR%QUOTE(:)").genPercentPutStatement(MessageFormat.format((String)RB.getStringResource("DataLoaderDirectiveMaximumTimeReached.Error.Time.txt"), (Object[])new Object[]{"&total_wait_time"}), "ERROR%QUOTE(-)").addSourceCode("stop;\n").addSourceCode("%return;\n").unIndent().addSourceCode("%end;\n").addSourceCode("\n").unIndent().addSourceCode("run;\n").addSourceCode("\n").addSourceCode("proc http\n").indent().addSourceCode("method=\"&etl_dl_state_method.\"\n");
            codeSegment.addSourceCode("url = \"&etl_dl_state_url.");
            if (isKerberos) {
                codeSegment.addSourceCode("?ticket=&etl_service_ticket.");
            }
            codeSegment.addSourceCode("\"\n");
            codeSegment.addSourceCode("out = ").addSourceCode(responseFile).addSourceCode("\n").addSourceCode("headerout = ").addSourceCode(headerFile).addSourceCode(" HEADEROUT_OVERWRITE\n");
            if (isKerberos) {
                codeSegment.addSourceCode("AUTH_NEGOTIATE");
            } else {
                codeSegment.addSourceCode("HTTP_TOKENAUTH");
            }
            codeSegment.addSourceCode(";\n").unIndent().addSourceCode("run;\n\n");
            this.addProcHttpErrorCheck(codeSegment, headerFile);
            codeSegment.addSourceCode("%else %do;\n").indent().addSourceCode("\n").addSourceCode("data _null_;\n").indent().addSourceCode("infile ").addSourceCode(responseFile).addSourceCode(";\n").addSourceCode("input;\n").addSourceCode("put _infile_;\n").addSourceCode("call symput('etl_dl_state',trim(left(_infile_)));\n").unIndent().addSourceCode("run;\n").unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%end;\n\n").addSourceCode("%if (&etl_dl_state ne ").addSourceCode(COMPLETE).addSourceCode(") %then\n").addSourceCode("%do;\n").indent().addSourceCode("%let sysrc = 9999;\n").genRCSetCall("sysrc").genPercentPutStatement(MessageFormat.format((String)RB.getStringResource("DataLoaderDirectiveTransformModel.DirectiveExecutionFailed.txt"), (Object[])new Object[]{this.directive.getName(), "&etl_dl_state"}), "ERROR%QUOTE(:)").unIndent().addSourceCode("%end;\n\n").unIndent().addSourceCode("%mend;\n\n");
            codeSegment.addSourceCode("%etl_waitfor_directive_finish(minutes_wait=").addSourceCode(sDelayMinutes).addSourceCode(", total_wait_time=").addSourceCode(timeout == null ? "0" : timeout.toString()).addSourceCode(");\n\n");
        }
        return codeSegment;
    }

    private class SetWaitForDirectiveUndoable
    extends AbstractUndoableEdit {
        private boolean newValue;

        public SetWaitForDirectiveUndoable(boolean newValue) {
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            DataLoaderDirectiveTransformModel.this.setWaitForDirective(!this.newValue);
        }

        @Override
        public void redo() {
            super.redo();
            DataLoaderDirectiveTransformModel.this.setWaitForDirective(this.newValue);
        }
    }

    private class SetDelayMinutesUndoable
    extends AbstractUndoableEdit {
        private double m_oldName;
        private double m_newName;

        public SetDelayMinutesUndoable(double oldName, double newName) {
            this.m_oldName = oldName;
            this.m_newName = newName;
        }

        @Override
        public void undo() {
            super.undo();
            DataLoaderDirectiveTransformModel.this.setDelayMinutes(this.m_oldName);
        }

        @Override
        public void redo() {
            super.redo();
            DataLoaderDirectiveTransformModel.this.setDelayMinutes(this.m_newName);
        }
    }

    private class SetTimeoutMinutesUndoable
    extends AbstractUndoableEdit {
        private Double m_oldName;
        private Double m_newName;

        public SetTimeoutMinutesUndoable(Double oldName, Double newName) {
            this.m_oldName = oldName;
            this.m_newName = newName;
        }

        @Override
        public void undo() {
            super.undo();
            DataLoaderDirectiveTransformModel.this.setTimeout(this.m_oldName);
        }

        @Override
        public void redo() {
            super.redo();
            DataLoaderDirectiveTransformModel.this.setTimeout(this.m_newName);
        }
    }

    public class DataLoaderDirectiveTransformPromptModel
    extends BaseTransformPromptModel
    implements IPromptModel {
        public DataLoaderDirectiveTransformPromptModel(IModel model, DataLoaderDirectiveTransformModel owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model, owner);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(DataLoaderDirectiveTransformPromptModel.class.getResource("res/Options_DataLoaderDirective_Template.xml"));
            PromptGroupInterface combined = this.combinePromptGroups(grp1, grp);
            this.setTransformPromptGroup(combined);
            return combined;
        }

        @Override
        protected IModelListener createModelListener() {
            return new DataLoaderDirectiveTransformModelListener((DataLoaderDirectiveTransformModel)this.getOwner(), this);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            this.setOptionValue(DataLoaderDirectiveTransformModel.DIRECTIVEWAIT_OPTION, (Object)(((DataLoaderDirectiveTransformModel)this.getOwner()).getWaitForDirective() ? "YES" : "NO"));
            this.setOptionValue(DataLoaderDirectiveTransformModel.DELAYMINUTES_OPTION, (Object)((DataLoaderDirectiveTransformModel)this.getOwner()).getDelayMinutes());
            this.setOptionValue(DataLoaderDirectiveTransformModel.MAXWAITMINUTES_OPTION, (Object)((DataLoaderDirectiveTransformModel)this.getOwner()).getTimeout());
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new DataLoaderDirectivePromptValueChangeListener((DataLoaderDirectiveTransformModel)this.getOwner(), this);
        }

        private class DataLoaderDirectiveTransformModelListener
        extends BaseDataTransformModelListener {
            public DataLoaderDirectiveTransformModelListener(DataLoaderDirectiveTransformModel transform, IPromptModel prompt) {
                super(transform, prompt);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                block17: {
                    if (ev.getModelObject() != this.getModelObject()) {
                        return;
                    }
                    super.modelChanged(ev);
                    String type = ev.getType();
                    try {
                        if (DataLoaderDirectiveTransformModel.DIRECTIVEWAIT_CHANGED.equals(type)) {
                            this.getPromptModel().setListeningForChanges(false);
                            try {
                                this.m_promptModel.setOptionValue(DataLoaderDirectiveTransformModel.DIRECTIVEWAIT_OPTION, (Object)(DataLoaderDirectiveTransformModel.this.getWaitForDirective() ? "YES" : "NO"));
                                break block17;
                            }
                            finally {
                                this.getPromptModel().setListeningForChanges(true);
                            }
                        }
                        if (DataLoaderDirectiveTransformModel.MAXWAITMINUTES_CHANGED.equals(type)) {
                            this.getPromptModel().setListeningForChanges(false);
                            try {
                                this.m_promptModel.setOptionValue(DataLoaderDirectiveTransformModel.MAXWAITMINUTES_OPTION, (Object)DataLoaderDirectiveTransformModel.this.getTimeout());
                                break block17;
                            }
                            finally {
                                this.getPromptModel().setListeningForChanges(true);
                            }
                        }
                        if (!DataLoaderDirectiveTransformModel.DELAYMINUTES_CHANGED.equals(type)) break block17;
                        this.getPromptModel().setListeningForChanges(false);
                        try {
                            this.m_promptModel.setOptionValue(DataLoaderDirectiveTransformModel.DELAYMINUTES_OPTION, (Object)DataLoaderDirectiveTransformModel.this.getDelayMinutes());
                        }
                        finally {
                            this.getPromptModel().setListeningForChanges(true);
                        }
                    }
                    catch (ServerConnectionException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                    }
                    catch (ServiceException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                    }
                    catch (RemoteException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                    }
                    catch (MdException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                    }
                }
            }
        }

        private class DataLoaderDirectivePromptValueChangeListener
        extends BaseTransformValueChangedListener {
            public DataLoaderDirectivePromptValueChangeListener(DataLoaderDirectiveTransformModel transform, IPromptModel promptModel) {
                super(transform, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    if (DataLoaderDirectiveTransformModel.DIRECTIVEWAIT_OPTION.equals(def.getPromptName())) {
                        DataLoaderDirectiveTransformModel.this.setWaitForDirective("YES".equals(event.getNewValue()));
                    } else if (DataLoaderDirectiveTransformModel.DELAYMINUTES_OPTION.equals(def.getPromptName())) {
                        Object value = event.getNewValue();
                        DataLoaderDirectiveTransformModel.this.setDelayMinutes(value == null ? 0.5 : Double.parseDouble(value.toString()));
                    } else if (DataLoaderDirectiveTransformModel.MAXWAITMINUTES_OPTION.equals(def.getPromptName())) {
                        Object value = event.getNewValue();
                        DataLoaderDirectiveTransformModel.this.setTimeout(value == null ? null : Double.valueOf(value.toString()));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class SetDirectiveUndoable
    extends AbstractUndoableEdit {
        private IDirective m_brOld;
        private IDirective m_brNew;

        public SetDirectiveUndoable(IDirective brOld, IDirective brNew) {
            this.m_brOld = brOld;
            this.m_brNew = brNew;
        }

        @Override
        public void undo() {
            super.undo();
            DataLoaderDirectiveTransformModel.this.setDirective(this.m_brOld);
        }

        @Override
        public void redo() {
            super.redo();
            DataLoaderDirectiveTransformModel.this.setDirective(this.m_brNew);
        }
    }
}

