/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataValidation;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.workspace.WsColumnMetadataUtil;
import javax.swing.Icon;

public class TempColumn {
    private String m_sDesc;
    private String m_sName;
    private int m_iSASType;
    private int m_iLength;
    private String m_format;
    private String m_informat;

    public TempColumn(String name, String desc, int length, int sasType) {
        this(name, desc, length, sasType, "", "");
    }

    public TempColumn(String name, String desc, int length, int sasType, String format, String informat) {
        this.m_sDesc = desc;
        this.m_sName = name;
        this.m_iSASType = sasType;
        this.m_iLength = length;
        this.m_format = format;
        this.m_informat = informat;
    }

    public String getLabelStatement() {
        return CodeSegment.getLabelStatement(this.m_sDesc).toString();
    }

    public String getFormatStatement() {
        StringBuffer formatStatement = new StringBuffer();
        String format = this.getFormat();
        if (format != null && !"".equals(format)) {
            formatStatement.append("format = ").append(this.getFormat());
        }
        return formatStatement.toString();
    }

    public String getInformatStatement() {
        StringBuffer informatStatement = new StringBuffer();
        String informat = this.getInFormat();
        if (informat != null && !"".equals(informat)) {
            informatStatement.append("informat = ").append(this.getInFormat());
        }
        return informatStatement.toString();
    }

    public String getLengthStatement() {
        StringBuffer lengthStatement = new StringBuffer();
        lengthStatement.append("length = ");
        if (this.m_iSASType == 0) {
            lengthStatement.append("$");
        }
        lengthStatement.append(this.getLength());
        return lengthStatement.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.m_sName;
    }

    public int getType() {
        return this.m_iSASType;
    }

    public String getFormat() {
        return this.m_format;
    }

    public String getInFormat() {
        return this.m_informat;
    }

    public int getLength() {
        return this.m_iLength;
    }

    public String getDisplayName() {
        return this.m_sDesc + " (" + this.getName() + ")";
    }

    public Icon getIcon() {
        return WsColumnMetadataUtil.getColumnTypeIcon((int)this.m_iSASType);
    }

    public String getToolTip() {
        return this.m_sDesc;
    }

    public void setColumnAttributes(IColumn column) {
        column.setName(this.m_sName);
        column.setDescription(this.m_sDesc);
        column.setType(this.m_iSASType);
        column.setLength(this.m_iLength);
        column.setFormat(this.m_format);
        column.setInformat(this.m_informat);
    }

    public boolean equals(IColumn column) {
        return this.m_sName.equals(column.getName()) && this.m_iSASType == column.getType() && this.m_iLength == column.getLength();
    }

    public int hashcode() {
        return super.hashCode();
    }
}

