/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataValidation;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.etl.models.job.transforms.dataValidation.RB;
import com.sas.etl.models.job.transforms.dataValidation.TempColumn;
import java.util.ArrayList;
import java.util.List;

public class ExceptionTable {
    private static ExceptionTable s_instance;
    public static final String ROW_NUMBER = "x_row";
    public static final int ROW_NUMBER_LENGTH_DEFAULT = 8;
    public static final String ROW_NUMBER_FORMAT_DEFAULT = "BEST32.";
    public static final String EXCEPTION_TYPE = "x_type";
    public static final int EXCEPTION_TYPE_LENGTH_DEFAULT = 100;
    public static final String EXCEPTION_TYPE_FORMAT_DEFAULT = "";
    public static final String COLUMN_NAME = "x_column";
    public static final int COLUMN_NAME_LENGTH_DEFAULT = 100;
    public static final String COLUMN_NAME_FORMAT_DEFAULT = "";
    public static final String COLUMN_VALUE = "x_note";
    public static final int COLUMN_VALUE_LENGTH_DEFAULT = 200;
    public static final String COLUMN_VALUE_FORMAT_DEFAULT = "";
    public static final String CUSTOM_NAME = "x_custom_name";
    public static final int CUSTOM_NAME_LENGTH_DEFAULT = 100;
    public static final String CUSTOM_NAME_FORMAT_DEFAULT = "";
    public static final String CUSTOM_VALUE = "x_custom_value";
    public static final int CUSTOM_VALUE_LENGTH_DEFAULT = 200;
    public static final String CUSTOM_VALUE_FORMAT_DEFAULT = "";
    public static final String CUSTOM_RULE = "x_custom_rule";
    public static final int CUSTOM_RULE_LENGTH_DEFAULT = 250;
    public static final String CUSTOM_RULE_FORMAT_DEFAULT = "";
    public static final String ACTION_TAKEN = "x_action";
    public static final int ACTION_TAKEN_LENGTH_DEFAULT = 50;
    public static final String ACTION_TAKEN_FORMAT_DEFAULT = "";
    public static final String RUNTIME = "x_datetime";
    public static final int RUNTIME_LENGTH_DEFAULT = 8;
    public static final String RUNTIME_FORMAT_DEFAULT = "nldatm.";
    private List<TempColumn> _columns = new ArrayList<TempColumn>();

    private ExceptionTable() {
        this._columns.add(new TempColumn(ROW_NUMBER, RB.getStringResource("ExceptionTable.RowNumberDesc.txt"), 8, 1, ROW_NUMBER_FORMAT_DEFAULT, ROW_NUMBER_FORMAT_DEFAULT));
        this._columns.add(new TempColumn(EXCEPTION_TYPE, RB.getStringResource("ExceptionTable.ExceptionTypeDesc.txt"), 100, 0, "", ""));
        this._columns.add(new TempColumn(COLUMN_NAME, RB.getStringResource("ExceptionTable.ColumnNameDesc.txt"), 100, 0, "", ""));
        this._columns.add(new TempColumn(COLUMN_VALUE, RB.getStringResource("ExceptionTable.ColumnValueDesc.txt"), 200, 0, "", ""));
        this._columns.add(new TempColumn(CUSTOM_NAME, RB.getStringResource("ExceptionTable.CustomNameDesc.txt"), 100, 0, "", ""));
        this._columns.add(new TempColumn(CUSTOM_VALUE, RB.getStringResource("ExceptionTable.CustomValueDesc.txt"), 200, 0, "", ""));
        this._columns.add(new TempColumn(CUSTOM_RULE, RB.getStringResource("ExceptionTable.CustomRuleDesc.txt"), 250, 0, "", ""));
        this._columns.add(new TempColumn(ACTION_TAKEN, RB.getStringResource("ExceptionTable.ActionTakenDesc.txt"), 50, 0, "", ""));
        this._columns.add(new TempColumn(RUNTIME, RB.getStringResource("ExceptionTable.RunTimeDesc.txt"), 8, 1, RUNTIME_FORMAT_DEFAULT, RUNTIME_FORMAT_DEFAULT));
    }

    public List<TempColumn> getColumns() {
        return this._columns;
    }

    public static ExceptionTable getInstance() {
        if (s_instance == null) {
            s_instance = new ExceptionTable();
        }
        return s_instance;
    }

    public TempColumn findColumn(String name) {
        if (name == null) {
            return null;
        }
        for (TempColumn column : this.getColumns()) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public IColumn[] getMatchingColumnNames(IColumn[] sources) {
        ArrayList<IColumn> lst = new ArrayList<IColumn>();
        for (IColumn c : sources) {
            if (this.findColumn(c.getName()) == null) continue;
            lst.add(c);
        }
        return lst.toArray(new IColumn[lst.size()]);
    }

    public String getAttribStatement(IPhysicalTable exceptionTable, DataValidationTransformModel dvMod) {
        StringBuffer attrib = new StringBuffer();
        for (TempColumn c : this.getColumns()) {
            IColumn column = exceptionTable.getColumnWithMatchingName(c.getName());
            if (column == null) {
                String labelStatement;
                String infmtStm;
                String fmtStm;
                attrib.append("attrib ");
                String columnName = c.getName();
                if (columnName == null || columnName.length() == 0) {
                    return "";
                }
                attrib.append(columnName);
                String lengthStm = c.getLengthStatement();
                if (lengthStm != null && lengthStm.length() > 0) {
                    attrib.append(" ");
                    attrib.append(lengthStm);
                }
                if ((fmtStm = c.getFormatStatement()) != null && fmtStm.length() > 0) {
                    attrib.append("\n").append(fmtStm);
                }
                if ((infmtStm = c.getInformatStatement()) != null && infmtStm.length() > 0) {
                    attrib.append("\n").append(infmtStm);
                }
                if ((labelStatement = c.getLabelStatement()) != null && labelStatement.length() > 0) {
                    attrib.append("\n").append(labelStatement);
                }
                attrib.append(";\n");
                continue;
            }
            String colName = c.getName();
            if (colName == ROW_NUMBER && !dvMod.isDuplicateValues()) {
                attrib.append(column.getAttribStatement(false, true, true, true, true));
                continue;
            }
            if (colName == ROW_NUMBER) continue;
            attrib.append(column.getAttribStatement(false, true, true, true, true));
        }
        return attrib.toString();
    }
}

