/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataValidation;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.CopyPasteDependentItem;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICopyPasteAdvanced;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.TableLoaderTransformModel;
import com.sas.etl.models.job.transforms.dataValidation.DVPortDescriptionModel;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationCodegen;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationCustomConditionRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.ErrorTable;
import com.sas.etl.models.job.transforms.dataValidation.ExceptionTable;
import com.sas.etl.models.job.transforms.dataValidation.RB;
import com.sas.etl.models.job.transforms.dataValidation.TempColumn;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DataValidationTransformModel
extends AbstractDataTransform
implements ICopyPasteAdvanced {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.DataValidation";
    private static final String TRANSFORMATION_ROLE = "DataValidation:HIDE";
    private static final String ARM_DISPLAY_NAME = "DataValidation";
    static final String PROPERTY_NAME_USE_DATA_STEP_HASH = "DataStepHash";
    static final String PROPERTY_NAME_DUP_COLUMN_NAMES_LENGTH = "DupColumnNamesLength";
    static final String PROPERTY_NAME_DATA_STEP_HASH_EXP_SIZE = "DataStepHashExpSize";
    public static final String ERROR_TABLE_NAME_CHANGED = "DataValidationTransformModel:ErrorTableNameChanged";
    public static final String EXCEPTION_TABLE_NAME_CHANGED = "DataValidationTransformModel:ExceptionTableNameChanged";
    public static final String KEEP_RENAMED_COLUMNS_OPTION_CHANGED = "DataValidationTransformModel:KeepRenamedColumnsOptionChanged";
    public static final String REPLACE_ERROR_TABLE_OPTION_CHANGED = "DataValidationTransformModel:ReplaceErrorTableOptionChanged";
    public static final String REPLACE_EXCEPTION_TABLE_OPTION_CHANGED = "DataValidationTransformModel:ReplaceExceptionTableOptionChanged";
    public static final String CUSTOM_DATAVALIDATIONRECORD_ADDED = "DVR:CustomTypeDataValidationRecordAdded";
    public static final String CUSTOM_DATAVALIDATIONRECORD_REMOVED = "DVR:CustomTypeDataValidationRecordRemoved";
    public static final String CUSTOM_DATAVALIDATIONRECORD_MOVED = "DVR:CustomTypeDataValidationRecordMoved";
    public static final String DUPLICATE_DATAVALIDATIONRECORD_ADDED = "DVR:DuplicateTypeDataValidationRecordAdded";
    public static final String DUPLICATE_DATAVALIDATIONRECORD_REMOVED = "DVR:DuplicateTypeDataValidationRecordRemoved";
    public static final String DUPLICATE_DATAVALIDATIONRECORD_MOVED = "DVR:DuplicateTypeDataValidationRecordMoved";
    public static final String INVALID_DATAVALIDATIONRECORD_ADDED = "DVR:InvalidTypeDataValidationRecordAdded";
    public static final String INVALID_DATAVALIDATIONRECORD_REMOVED = "DVR:InvalidTypeDataValidationRecordRemoved";
    public static final String INVALID_DATAVALIDATIONRECORD_MOVED = "DVR:InvalidTypeDataValidationRecordMoved";
    public static final String MISSING_DATAVALIDATIONRECORD_ADDED = "DVR:MissingTypeDataValidationRecordAdded";
    public static final String MISSING_DATAVALIDATIONRECORD_REMOVED = "DVR:MissingTypeDataValidationRecordRemoved";
    public static final String MISSING_DATAVALIDATIONRECORD_MOVED = "DVR:MissingTypeDataValidationRecordMoved";
    public static final String DATA_STEP_HASH_CHANGED = "DVR:DataStepHashChanged";
    public static final String DATA_STEP_HASH_EXP_SIZE_CHANGED = "DVR:DataStepHashExpSizeChanged";
    public static final String DUP_COLUMN_NAMES_LENGTH_CHANGED = "DVR:DupColumnNamesLengthChanged";
    public static final String ERROR_TABLE_REPLACE_CHANGED = "DVR:ErrorTableReplaceChanged";
    public static final String EXCEPTION_TABLE_REPLACE_CHANGED = "DVR:ExceptionTableReplaceChanged";
    private static final String TARGET_TABLE = "TargetTable";
    private static final String ERROR_TABLE = "ErrorTable";
    private static final String EXCEPTION_TABLE = "ExceptionTable";
    private static final int TARGET_PORT = 0;
    private static final int ERROR_PORT = 1;
    private static final int EXCEPTION_PORT = 2;
    private List<DVPortDescriptionModel> m_lOutputPortDescriptions;
    private IPhysicalTable m_targetTable;
    private IPhysicalTable m_errorTable;
    private IPhysicalTable m_exceptionTable;
    private ITransformTableOptions m_targetTransformTableOptions;
    private ITransformTableOptions m_errorTransformTableOptions;
    private ITransformTableOptions m_excTransformTableOptions;
    public static int MAXIMUM_TARGETS = 3;
    private boolean m_bIsErrorTableNameOptionUsed;
    private boolean m_bErrorTableReplace;
    private boolean m_bExceptionTableReplace;
    private boolean m_bUseDataStepHash;
    private int m_iDupColumnNamesLength;
    private int m_iDataStepHashExpSize;
    public static final int HASHEXP_SIZE_DEFAULT = 10;
    public static final String PROPERTY_NAME_KEEP_RENAMED_COLUMNS = "renCols";
    private static final String PROPERTY_NAME_ERROR_TABLE_NAME = "ErrorTable";
    public static final String PROPERTY_NAME_REPLACE_ERROR_TABLE = "replaceErrorTable";
    private static final String PROPERTY_SET_NAME_OPTIONS = "OptionsPropertySet";
    private static final String DEFAULT_REPLACE_ERROR_TABLE = "NO";
    public static final String PROPERTY_NAME_REPLACE_EXCEPTION_TABLE = "replaceExceptionTable";
    private static final String DEFAULT_REPLACE_EXCEPTION_TABLE = "NO";
    private String m_sErrorTableName;
    private String m_sExceptionTableName;
    private String m_sTargetTableName;
    private String m_sKeepRenamedColsOption;
    private String m_sReplaceErrorTableOption;
    private String m_sReplaceExceptionTableOption;
    private ModelList m_lDVRCustom;
    private ModelList m_lDVRDuplicate;
    private ModelList m_lDVRInvalid;
    private ModelList m_lDVRMissing;
    private ArrayList m_lDVRCustom_FromDeletedTarget;
    private ArrayList m_lDVRDuplicate_FromDeletedTarget;
    private ArrayList m_lDVRInvalid_FromDeletedTarget;
    private ArrayList m_lDVRMissing_FromDeletedTarget;
    public static final String MOVE = "MOVE";
    public static final String CHANGE = "CHANGE";
    public static final String ABORT = "ABORT";
    public static final String MOVEALL = "MOVEALL";
    public static final String NOTHING = "NOTHING";
    public static final String SOURCE = "SOURCE";
    public static final String TARGET = "TARGET";
    public static final String MISSING = "Missing";
    public static final String INVALID = "Invalid";
    public static final String DUPLICATE = "Duplicate";
    public static final String CUSTOM = "Custom";
    public static final String NO = "No";
    public static final String YES = "Yes";
    public static final String EXPRESSION = "Expression";
    public static final String TRANSLATION = "Translation";
    public static final String BLANKS = "Blanks";
    public static final String ACTIONS = "Actions";
    public static final String ACTION = "Action";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String LOOKUP = "Lookup";
    public static final String TABLE = "Table";
    public static final String TOKENIZEDCONDITION = "TokenizedCondition";
    public static final String TRANSLATE = "Translate";
    public static final String EXCEPTION = "Exception";
    public static final String CONDITION = "Condition";
    public static final String SETVALUETO = "SetValueTo";
    public static final String TRANSLATEEXCEPTION = "TranslateException";
    private static final String OPTIONS_TRUE = "YES";
    private static final String OPTIONS_FALSE = "NO";
    private boolean m_bDefaultUseDataStepHash = false;
    private int m_iDefaultDupColumnNamesLength = 100;
    private int m_iDefaultDataStepHashExpSize = 10;
    private boolean m_bDefaultErrorTableReplace = false;
    private boolean m_bDefaultExceptionTableReplace = false;

    public DataValidationTransformModel(String sID, IModel controller) {
        super(sID, controller);
        this.createConditionActionSetTemplates();
        this.m_lDVRCustom = new ModelList(this, new String[]{CUSTOM_DATAVALIDATIONRECORD_ADDED, CUSTOM_DATAVALIDATIONRECORD_REMOVED, CUSTOM_DATAVALIDATIONRECORD_MOVED}, 0, DataValidationRecord.class);
        this.m_lDVRDuplicate = new ModelList(this, new String[]{DUPLICATE_DATAVALIDATIONRECORD_ADDED, DUPLICATE_DATAVALIDATIONRECORD_REMOVED, DUPLICATE_DATAVALIDATIONRECORD_MOVED}, 0, DataValidationRecord.class);
        this.m_lDVRInvalid = new ModelList(this, new String[]{INVALID_DATAVALIDATIONRECORD_ADDED, INVALID_DATAVALIDATIONRECORD_REMOVED, INVALID_DATAVALIDATIONRECORD_MOVED}, 0, DataValidationRecord.class);
        this.m_lDVRMissing = new ModelList(this, new String[]{MISSING_DATAVALIDATIONRECORD_ADDED, MISSING_DATAVALIDATIONRECORD_REMOVED, MISSING_DATAVALIDATIONRECORD_MOVED}, 0, DataValidationRecord.class);
        this.m_lOutputPortDescriptions = new ArrayList<DVPortDescriptionModel>();
        this.addDefaultOutputPorts();
        this.m_bUseDataStepHash = this.m_bDefaultUseDataStepHash;
        this.m_iDupColumnNamesLength = this.m_iDefaultDupColumnNamesLength;
        this.m_iDataStepHashExpSize = this.m_iDefaultDataStepHashExpSize;
        this.m_bErrorTableReplace = this.m_bDefaultErrorTableReplace;
        this.m_bExceptionTableReplace = this.m_bDefaultExceptionTableReplace;
        if (this.isNew()) {
            this.m_bIsErrorTableNameOptionUsed = false;
        }
    }

    private void addDefaultOutputPorts() {
        DVPortDescriptionModel targetPortDesc = new DVPortDescriptionModel();
        targetPortDesc.setName(RB.getStringResource("DataValidationTransformModel.OutputPortName.txt"));
        targetPortDesc.setTooltipText(RB.getStringResource("DataValidationTransformModel.OutputPortText.txt"));
        this.m_lOutputPortDescriptions.add(targetPortDesc);
        DVPortDescriptionModel errorPortDesc = new DVPortDescriptionModel();
        errorPortDesc.setName(RB.getStringResource("DataValidationTransformModel.ErrorPortName.txt"));
        errorPortDesc.setTooltipText(RB.getStringResource("DataValidationTransformModel.ErrorPortText.txt"));
        this.m_lOutputPortDescriptions.add(errorPortDesc);
        DVPortDescriptionModel exceptionPortDesc = new DVPortDescriptionModel();
        exceptionPortDesc.setName(RB.getStringResource("DataValidationTransformModel.ExceptionPortName.txt"));
        exceptionPortDesc.setTooltipText(RB.getStringResource("DataValidationTransformModel.ExceptionPortText.txt"));
        this.m_lOutputPortDescriptions.add(exceptionPortDesc);
    }

    public DVPortDescriptionModel[] getOutputPortDescriptions() {
        return this.m_lOutputPortDescriptions.toArray(new DVPortDescriptionModel[this.m_lOutputPortDescriptions.size()]);
    }

    public List<DVPortDescriptionModel> getOutputPortDescriptionList() {
        return this.m_lOutputPortDescriptions;
    }

    @Override
    public int getMaximumDataTargetCount() {
        return MAXIMUM_TARGETS;
    }

    @Override
    public void addDataTarget(int iTarget, IDataObject target) {
    }

    private void addDataTarget(DVPortDescriptionModel portDesc, IDataObject target) {
        if (portDesc != null && portDesc.getObject() != target) {
            portDesc.setObject(target);
            this.addDataTargetImpl(target);
        }
    }

    private void addDataTargetImpl(IDataObject target) {
        if (!target.containsInProducerTransforms(this)) {
            target.addProducerTransform(this);
            target.addNotifyListener(this);
            if (target instanceof IWorkTable) {
                this.removeFromDeletedObjects(target);
                this.updateTargetLibrary((IWorkTable)target);
            }
        }
    }

    @Override
    public void removeDataTarget(IDataObject target) {
    }

    private void removeDataTarget(DVPortDescriptionModel portDesc, IDataObject target) {
        if (portDesc != null && portDesc.getObject() == target) {
            portDesc.setObject(null);
            this.removeDataTargetImpl(target);
        }
    }

    private void removeDataTargetImpl(IDataObject target) {
        if (target.containsInProducerTransforms(this) && !this.isTargetAttachedToMultipleOutputPorts(target)) {
            target.removeProducerTransform(this);
            target.removeNotifyListener(this);
            if (!this.getModel().isUndoing()) {
                this.removeTargetTableFromMappings((ITable)target);
            }
            if (target instanceof IWorkTable) {
                this.addToDeletedObjects(target);
            }
        }
    }

    @Override
    public IDataObject[] getDataTargets() {
        List lTargets = this.getDataTargetList();
        return lTargets.toArray(new IDataObject[lTargets.size()]);
    }

    @Override
    public List getDataTargetList() {
        LinkedHashSet<IPhysicalTable> targetSet = new LinkedHashSet<IPhysicalTable>(3);
        if (this.m_targetTable != null) {
            targetSet.add(this.m_targetTable);
        }
        if (this.m_errorTable != null) {
            targetSet.add(this.m_errorTable);
        }
        if (this.m_exceptionTable != null) {
            targetSet.add(this.m_exceptionTable);
        }
        return new ArrayList(targetSet);
    }

    @Override
    public boolean containsInDataTargets(IDataObject target) {
        return this.getDataTargetList().contains(target);
    }

    @Override
    public int getDataTargetsCount() {
        return this.getDataTargetList().size();
    }

    private boolean isTargetAttachedToMultipleOutputPorts(IDataObject target) {
        if (target == null) {
            return false;
        }
        int iCount = 0;
        if (this.m_targetTable == target) {
            ++iCount;
        }
        if (this.m_errorTable == target) {
            ++iCount;
        }
        if (this.m_exceptionTable == target) {
            ++iCount;
        }
        return iCount > 1;
    }

    public ITransformTableOptions getTargetTableOptions() {
        return this.m_targetTransformTableOptions;
    }

    public ITransformTableOptions getErrorTableOptions() {
        return this.m_errorTransformTableOptions;
    }

    public ITransformTableOptions getExceptionTableOptions() {
        return this.m_excTransformTableOptions;
    }

    public void setTargetTable(IPhysicalTable newTargetTable) {
        this.setTargetTable(newTargetTable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetTable(IPhysicalTable newTargetTable, boolean createOptions) {
        if (this.m_targetTable == null ? newTargetTable == null : this.m_targetTable.equals(newTargetTable)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IPhysicalTable oldTargetTable = this.m_targetTable;
            this.m_targetTable = newTargetTable;
            DVPortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(0);
            if (oldTargetTable != null) {
                this.removeDataTarget(portDesc, oldTargetTable);
                this.fireModelChangedEvent("DataTransform.DataTargetRemoved", oldTargetTable, new Integer(1));
                this.removeTransformTableOption(this.getTableOptionObject(oldTargetTable, false));
                this.m_targetTransformTableOptions = null;
            }
            if (newTargetTable != null) {
                this.addDataTarget(portDesc, (IDataObject)newTargetTable);
                this.fireModelChangedEvent("DataTransform.DataTargetAdded", newTargetTable, new Integer(1));
                if (createOptions) {
                    ITransformTableOptions target = this.createTransformTableOption(newTargetTable, false);
                    target.setDisplayName(RB.getStringResource("DataValidationTransformModel.OptionNameTarget.txt"));
                    this.addTransformTableOption(target);
                    this.m_targetTransformTableOptions = target;
                }
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetTargetTableUndoable(newTargetTable, oldTargetTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getTargetTable() {
        return this.m_targetTable;
    }

    @Override
    public ITable[] getTargetTables() {
        ArrayList<IPhysicalTable> lst = new ArrayList<IPhysicalTable>();
        if (this.m_targetTable != null) {
            lst.add(this.m_targetTable);
        }
        if (this.m_errorTable != null) {
            lst.add(this.m_errorTable);
        }
        if (this.m_exceptionTable != null) {
            lst.add(this.m_exceptionTable);
        }
        return lst.toArray(new ITable[lst.size()]);
    }

    @Override
    public IWorkTable[] getWorkTables() {
        ArrayList<IPhysicalTable> lWorkTables = new ArrayList<IPhysicalTable>();
        if (this.m_targetTable instanceof IWorkTable) {
            lWorkTables.add(this.m_targetTable);
        }
        if (this.m_errorTable instanceof IWorkTable) {
            lWorkTables.add(this.m_errorTable);
        }
        if (this.m_exceptionTable instanceof IWorkTable) {
            lWorkTables.add(this.m_exceptionTable);
        }
        return lWorkTables.toArray(new IWorkTable[lWorkTables.size()]);
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return this.m_targetTable == null;
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable workTable = this.getObjectFactory().createNewWorkTable(this.getID());
            workTable.setName(RB.getStringResource("DataValidationTransformModel.ValidTableName.txt"));
            this.setTargetTable(workTable);
            IWorkTable iWorkTable = workTable;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public void setErrorTable(IPhysicalTable newErrorTable) {
        this.setErrorTable(newErrorTable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorTable(IPhysicalTable newErrorTable, boolean createOptions) {
        if (this.m_errorTable == null ? newErrorTable == null : this.m_errorTable.equals(newErrorTable)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IPhysicalTable oldErrorTable = this.m_errorTable;
            this.m_errorTable = newErrorTable;
            DVPortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(1);
            if (oldErrorTable != null) {
                this.removeDataTarget(portDesc, oldErrorTable);
                this.fireModelChangedEvent("DataTransform.DataTargetRemoved", oldErrorTable, new Integer(2));
                this.removeTransformTableOption(this.getTableOptionObject(oldErrorTable, false));
                this.m_errorTransformTableOptions = null;
            }
            if (newErrorTable != null) {
                this.addDataTarget(portDesc, (IDataObject)newErrorTable);
                this.fireModelChangedEvent("DataTransform.DataTargetAdded", newErrorTable, new Integer(2));
                if (createOptions) {
                    ITransformTableOptions err = this.createTransformTableOption(newErrorTable, false);
                    err.setDisplayName(RB.getStringResource("DataValidationTransformModel.OptionNameError.txt"));
                    this.addTransformTableOption(err);
                    this.m_errorTransformTableOptions = err;
                }
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetErrorTableUndoable(newErrorTable, oldErrorTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getErrorTable() {
        return this.m_errorTable;
    }

    public void setExceptionTable(IPhysicalTable newExceptionTable) {
        this.setExceptionTable(newExceptionTable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionTable(IPhysicalTable newExceptionTable, boolean createOptions) {
        if (this.m_exceptionTable == null ? newExceptionTable == null : this.m_exceptionTable.equals(newExceptionTable)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IPhysicalTable oldExceptionTable = this.m_exceptionTable;
            this.m_exceptionTable = newExceptionTable;
            DVPortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(2);
            if (oldExceptionTable != null) {
                this.removeDataTarget(portDesc, oldExceptionTable);
                this.fireModelChangedEvent("DataTransform.DataTargetRemoved", oldExceptionTable, new Integer(3));
                this.removeTransformTableOption(this.getTableOptionObject(oldExceptionTable, false));
                this.m_excTransformTableOptions = null;
            }
            if (newExceptionTable != null) {
                this.addDataTarget(portDesc, (IDataObject)newExceptionTable);
                this.fireModelChangedEvent("DataTransform.DataTargetAdded", newExceptionTable, new Integer(3));
                if (createOptions) {
                    ITransformTableOptions exc = this.createTransformTableOption(newExceptionTable, false);
                    exc.setDisplayName(RB.getStringResource("DataValidationTransformModel.OptionNameException.txt"));
                    this.addTransformTableOption(exc);
                    this.m_excTransformTableOptions = exc;
                }
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetExceptionTableUndoable(newExceptionTable, oldExceptionTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getExceptionTable() {
        return this.m_exceptionTable;
    }

    @Override
    protected boolean isMappingRequiredForTargetTable(ITable table) {
        return table == this.m_targetTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            this.replaceValidationRecords(oldTable, newTable, this.m_lDVRCustom, columnsMap);
            this.replaceValidationRecords(oldTable, newTable, this.m_lDVRDuplicate, columnsMap);
            this.replaceValidationRecords(oldTable, newTable, this.m_lDVRInvalid, columnsMap);
            this.replaceValidationRecords(oldTable, newTable, this.m_lDVRMissing, columnsMap);
            super.replaceSourceTable(oldTable, newTable, columnsMap, portIndexes);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            if (oldTable == this.m_targetTable) {
                this.replaceValidationRecords(oldTable, newTable, this.m_lDVRCustom, columnsMap);
                this.replaceValidationRecords(oldTable, newTable, this.m_lDVRDuplicate, columnsMap);
                this.replaceValidationRecords(oldTable, newTable, this.m_lDVRInvalid, columnsMap);
                this.replaceValidationRecords(oldTable, newTable, this.m_lDVRMissing, columnsMap);
                this.replaceTargetMappings(oldTable, newTable, columnsMap);
                this.setTargetTable((IPhysicalTable)newTable);
            } else if (oldTable == this.m_errorTable) {
                this.replaceTargetMappings(oldTable, newTable, columnsMap);
                this.setErrorTable((IPhysicalTable)newTable);
            } else if (oldTable == this.m_exceptionTable) {
                this.replaceTargetMappings(oldTable, newTable, columnsMap);
                this.setExceptionTable((IPhysicalTable)newTable);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void replaceValidationRecords(ITable oldTable, ITable newTable, List records, Map columnsMap) {
        if (records == null) {
            return;
        }
        for (int i = 0; i < records.size(); ++i) {
            IColumn sColumn;
            DataValidationRecord record = (DataValidationRecord)records.get(i);
            ArrayList columns = record.getColumnList_FM1();
            ArrayList<IColumn> newColumns = new ArrayList<IColumn>();
            if (columns != null) {
                for (int j = 0; j < columns.size(); ++j) {
                    IColumn c = (IColumn)columns.get(j);
                    if (columnsMap != null && columnsMap.containsKey(c)) {
                        newColumns.add(j, (IColumn)columnsMap.get(c));
                        continue;
                    }
                    newColumns.add(j, c);
                }
                record.setColumnList_FM1(newColumns);
            }
            if ((sColumn = record.getColumn_FM1()) != null && columnsMap != null && columnsMap.containsKey(sColumn)) {
                record.setColumn_FM1((IColumn)columnsMap.get(sColumn), this);
            }
            this.replaceCustomRecords(oldTable, newTable, record.getCustomTrueTypeRecords(), columnsMap);
            this.replaceCustomRecords(oldTable, newTable, record.getCustomFalseTypeRecords(), columnsMap);
        }
    }

    private void replaceCustomRecords(ITable oldTable, ITable newTable, List records, Map columnsMap) {
        if (records == null) {
            return;
        }
        for (int i = 0; i < records.size(); ++i) {
            IColumn targetColumn;
            IColumn sourceColumn;
            DataValidationCustomConditionRecord record = (DataValidationCustomConditionRecord)records.get(i);
            IColumn setColumn = record.getSetColumn();
            if (columnsMap == null) continue;
            if (setColumn != null && columnsMap.containsKey(setColumn)) {
                record.setSetColumn((IColumn)columnsMap.get(setColumn));
            }
            if ((sourceColumn = record.getSourceColumn()) != null && columnsMap.containsKey(sourceColumn)) {
                record.setSourceColumn((IColumn)columnsMap.get(sourceColumn));
            }
            if ((targetColumn = record.getTargetColumn()) == null || !columnsMap.containsKey(targetColumn)) continue;
            record.setTargetColumn((IColumn)columnsMap.get(targetColumn));
        }
    }

    public int[] findInTargetPorts(IPhysicalTable table) {
        ArrayList<Integer> lPorts = new ArrayList<Integer>();
        for (int iPort = 0; iPort < this.m_lOutputPortDescriptions.size(); ++iPort) {
            DVPortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(iPort);
            IPhysicalTable targetTable = (IPhysicalTable)portDesc.getObject();
            if (targetTable == null || !targetTable.equals(table)) continue;
            lPorts.add(new Integer(iPort));
        }
        int[] iaPorts = new int[lPorts.size()];
        for (int i = 0; i < lPorts.size(); ++i) {
            iaPorts[i] = (Integer)lPorts.get(i);
        }
        return iaPorts;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("DataValidationTransformModel.DefaultName.txt");
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.addNewWorkTable();
        this.loadConditionActionSetTemplatesFromOMR();
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETDATAEXCEPTION");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("DataValidationTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    public String getErrorTableName() {
        return this.m_sErrorTableName;
    }

    public String getTargetTableName() {
        return this.m_sTargetTableName;
    }

    public String getKeepRenamedColumnsOption() {
        return this.m_sKeepRenamedColsOption;
    }

    public String getReplaceErrorTableOption() {
        return this.m_sReplaceErrorTableOption;
    }

    public IPhysicalTable getSourceTable() {
        if (this.getSourceTables().length > 0) {
            return (IPhysicalTable)this.getDataSources()[0];
        }
        return null;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new DataValidationPromptModel(this);
    }

    public void setErrorTableOptions(String sOptions) {
        if (sOptions == null) {
            throw new IllegalArgumentException("null is not allowed for Error Table name option");
        }
        if (this.m_sErrorTableName == null) {
            this.m_sErrorTableName = "";
        }
        if (this.m_sErrorTableName.equals(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetErrorTableNameUndoable(this.m_sErrorTableName, sOptions));
        }
        this.m_sErrorTableName = sOptions;
        this.fireModelChangedEvent(ERROR_TABLE_NAME_CHANGED, this.m_sErrorTableName);
    }

    public void setKeepRenamedColumnsOption(String sOptions) {
        if (sOptions == null) {
            throw new IllegalArgumentException("null is not allowed for keep renamed column option");
        }
        if (this.m_sKeepRenamedColsOption == null) {
            this.m_sKeepRenamedColsOption = "";
        }
        if (this.m_sKeepRenamedColsOption.equals(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRenamedColumnsUndoable(this.m_sKeepRenamedColsOption, sOptions));
        }
        this.m_sKeepRenamedColsOption = sOptions;
        this.fireModelChangedEvent(KEEP_RENAMED_COLUMNS_OPTION_CHANGED, this.m_sKeepRenamedColsOption);
    }

    public void setReplaceErrorTableOption(String sOptions) {
        if (sOptions == null) {
            throw new IllegalArgumentException("null is not allowed for replace error table option");
        }
        if (this.m_sReplaceErrorTableOption == null) {
            this.m_sReplaceErrorTableOption = "";
        }
        if (this.m_sReplaceErrorTableOption.equals(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRenamedColumnsUndoable(this.m_sReplaceErrorTableOption, sOptions));
        }
        this.m_sReplaceErrorTableOption = sOptions;
        this.fireModelChangedEvent(REPLACE_ERROR_TABLE_OPTION_CHANGED, this.m_sReplaceErrorTableOption);
    }

    @Override
    public boolean isChanged() {
        return super.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        int iDVR;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.savePropertyToOMR(omr, "OPTIONS", "ErrorTable", "ErrorTable", "OPTIONS", this.m_sErrorTableName, 12, 2);
        this.saveStringOptionToOMR(omr, PROPERTY_SET_NAME_OPTIONS, PROPERTY_NAME_REPLACE_ERROR_TABLE, this.m_sReplaceErrorTableOption);
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_REPLACE_ERROR_TABLE, this.isErrorTableReplace());
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_REPLACE_EXCEPTION_TABLE, this.isExceptionTableReplace());
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList lTransformations = mdoStep.getTransformations(false);
        ClassifierMap classifierMap = null;
        if (lTransformations.size() > 0) {
            classifierMap = (ClassifierMap)lTransformations.get(0);
        }
        if (classifierMap == null) {
            return;
        }
        classifierMap.getTriggeredEvents(false).clear();
        if (this.m_targetTable != null) {
            this.saveCustomListToOMR(omr, TARGET_TABLE, new IPhysicalTable[]{this.m_targetTable});
        } else {
            this.saveCustomListToOMR(omr, TARGET_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_errorTable != null) {
            this.saveCustomListToOMR(omr, "ErrorTable", new IPhysicalTable[]{this.m_errorTable});
        } else {
            this.saveCustomListToOMR(omr, "ErrorTable", new IPhysicalTable[0]);
        }
        if (this.m_exceptionTable != null) {
            this.saveCustomListToOMR(omr, EXCEPTION_TABLE, new IPhysicalTable[]{this.m_exceptionTable});
        } else {
            this.saveCustomListToOMR(omr, EXCEPTION_TABLE, new IPhysicalTable[0]);
        }
        IPhysicalTable oITable = this.getTargetTable();
        if (oITable == null) {
            return;
        }
        IColumn[] aColumns = oITable.getColumns();
        if (aColumns == null || aColumns.length == 0) {
            return;
        }
        for (iDVR = 0; iDVR < this.m_lDVRCustom.size(); ++iDVR) {
            ((DataValidationRecord)this.m_lDVRCustom.get(iDVR)).saveToOMR(omr, classifierMap, iDVR);
        }
        for (iDVR = 0; iDVR < this.m_lDVRDuplicate.size(); ++iDVR) {
            ((DataValidationRecord)this.m_lDVRDuplicate.get(iDVR)).saveToOMR(omr, classifierMap, iDVR);
        }
        for (iDVR = 0; iDVR < this.m_lDVRInvalid.size(); ++iDVR) {
            ((DataValidationRecord)this.m_lDVRInvalid.get(iDVR)).saveToOMR(omr, classifierMap, iDVR);
        }
        for (iDVR = 0; iDVR < this.m_lDVRMissing.size(); ++iDVR) {
            ((DataValidationRecord)this.m_lDVRMissing.get(iDVR)).saveToOMR(omr, classifierMap, iDVR);
        }
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_USE_DATA_STEP_HASH, this.m_bUseDataStepHash);
        this.saveIntOptionToOMR(omr, PROPERTY_NAME_DUP_COLUMN_NAMES_LENGTH, this.m_iDupColumnNamesLength);
        this.saveIntOptionToOMR(omr, PROPERTY_NAME_DATA_STEP_HASH_EXP_SIZE, this.m_iDataStepHashExpSize);
        this.setChanged(false);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.updateDataValidationRecordIds(mapIDs);
    }

    public void updateDataValidationRecordIds(Map mapIDs) {
        for (int k = 0; k < 4; ++k) {
            ModelList lModelList = null;
            if (k == 0) {
                lModelList = this.m_lDVRCustom;
            } else if (k == 1) {
                lModelList = this.m_lDVRDuplicate;
            } else if (k == 2) {
                lModelList = this.m_lDVRInvalid;
            } else if (k == 3) {
                lModelList = this.m_lDVRMissing;
            }
            for (int i = 0; i < lModelList.size(); ++i) {
                DataValidationRecord record = (DataValidationRecord)lModelList.get(i);
                record.updateIDs(mapIDs);
            }
        }
    }

    @Override
    public boolean isComplete() {
        int i;
        if (!super.isComplete()) {
            return false;
        }
        for (i = 0; i < this.m_lDVRCustom.size(); ++i) {
            DataValidationRecord record1 = (DataValidationRecord)this.m_lDVRCustom.get(i);
            if (record1.isComplete()) continue;
            return false;
        }
        for (i = 0; i < this.m_lDVRDuplicate.size(); ++i) {
            DataValidationRecord record2 = (DataValidationRecord)this.m_lDVRDuplicate.get(i);
            if (record2.isComplete()) continue;
            return false;
        }
        for (i = 0; i < this.m_lDVRInvalid.size(); ++i) {
            DataValidationRecord record3 = (DataValidationRecord)this.m_lDVRInvalid.get(i);
            if (record3.isComplete()) continue;
            return false;
        }
        for (i = 0; i < this.m_lDVRMissing.size(); ++i) {
            DataValidationRecord record4 = (DataValidationRecord)this.m_lDVRMissing.get(i);
            if (record4.isComplete()) continue;
            return false;
        }
        if (!this.isExceptionTableComplete()) {
            return false;
        }
        if (this.isErrorTableRequired() && this.getErrorTable() == null && !this.isErrorTableNameOptionUsed()) {
            return false;
        }
        return this.getErrorTable() == null || this.getErrorTable().getColumnCount() != 0;
    }

    @Override
    public List getReasonsIncomplete() {
        DataValidationRecord record;
        int i;
        List lReasons = super.getReasonsIncomplete();
        if (!this.isExceptionTableComplete()) {
            lReasons.add(RB.getStringResource("DataValidationTransform.ReasonIncomplete.NoXrowColumn.txt"));
        }
        if (this.isErrorTableRequired() && this.getErrorTable() == null && !this.isErrorTableNameOptionUsed()) {
            lReasons.add(RB.getStringResource("DataValidationTransform.ReasonIncomplete.ErrorTableRequired.txt"));
        }
        if (this.getErrorTable() != null && this.getErrorTable().getColumnCount() == 0) {
            lReasons.add(RB.getStringResource("DataValidationTransform.ReasonIncomplete.ErrorTableNoColumns.txt"));
        }
        for (i = 0; i < this.m_lDVRCustom.size(); ++i) {
            record = (DataValidationRecord)this.m_lDVRCustom.get(i);
            lReasons.addAll(record.getReasonsIncomplete(i));
        }
        for (i = 0; i < this.m_lDVRDuplicate.size(); ++i) {
            record = (DataValidationRecord)this.m_lDVRDuplicate.get(i);
            lReasons.addAll(record.getReasonsIncomplete(i));
        }
        for (i = 0; i < this.m_lDVRInvalid.size(); ++i) {
            record = (DataValidationRecord)this.m_lDVRInvalid.get(i);
            lReasons.addAll(record.getReasonsIncomplete(i));
        }
        for (i = 0; i < this.m_lDVRMissing.size(); ++i) {
            record = (DataValidationRecord)this.m_lDVRMissing.get(i);
            lReasons.addAll(record.getReasonsIncomplete(i));
        }
        return lReasons;
    }

    @Override
    public boolean hasWarnings() {
        return super.hasWarnings() || !this.getErrorTableColumnsNotInSource().isEmpty();
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        if (!this.getErrorTableColumnsNotInSource().isEmpty()) {
            StringBuffer columns = new StringBuffer();
            for (IColumn c : this.getErrorTableColumnsNotInSource()) {
                columns.append(c.getColumnName(false)).append(',');
            }
            columns.deleteCharAt(columns.length() - 1);
            warnings.add(MessageFormat.format(RB.getStringResource("DataValidationTransform.Warning.ErrorTableNotMatchingSourceColumn.txt"), columns));
        }
        return warnings;
    }

    public List<IColumn> getErrorTableColumnsNotInSource() {
        ArrayList<IColumn> lst = new ArrayList<IColumn>();
        IPhysicalTable error = this.getErrorTable();
        IPhysicalTable source = this.getSourceTable();
        if (error == null || source == null) {
            return lst;
        }
        for (IColumn column : error.getColumns()) {
            IColumn sourceC;
            TempColumn t = ErrorTable.getInstance().findColumn(column.getColumnName(false));
            if (t != null || (sourceC = source.getColumnWithMatchingName(column.getColumnName(false))) != null) continue;
            lst.add(column);
        }
        return lst;
    }

    public ExceptionTable getExceptionTableStructure() {
        return ExceptionTable.getInstance();
    }

    public ErrorTable getErrorTableStructure() {
        return ErrorTable.getInstance();
    }

    protected void loadPortDescriptions() {
        DVPortDescriptionModel targetPortDesc = this.m_lOutputPortDescriptions.get(0);
        if (this.m_targetTable != null) {
            targetPortDesc.setObject(this.m_targetTable);
        }
        DVPortDescriptionModel errorPortDesc = this.m_lOutputPortDescriptions.get(1);
        if (this.m_errorTable != null) {
            errorPortDesc.setObject(this.m_errorTable);
        }
        DVPortDescriptionModel exceptionPortDesc = this.m_lOutputPortDescriptions.get(2);
        if (this.m_exceptionTable != null) {
            exceptionPortDesc.setObject(this.m_exceptionTable);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] aExceptionTable;
        IPersistableObject[] aErrorTable;
        super.loadFromOMR(omr);
        boolean bJobChanged = false;
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList lTransformations = mdoStep.getTransformations();
        ClassifierMap classifierMap = null;
        if (lTransformations.size() > 0) {
            classifierMap = (ClassifierMap)lTransformations.get(0);
        }
        IPersistableObject[] aTargetTable = null;
        if (classifierMap != null && this.findCustomList(omr, omr.acquireOMRObject(this), TARGET_TABLE) == null) {
            int iTarget = 0;
            AssociationList lTargets = classifierMap.getClassifierTargets();
            if (iTarget < lTargets.size()) {
                Root mdoTarget = (Root)lTargets.get(iTarget);
                IDataObject target = (IDataObject)omr.acquireObject(mdoTarget);
                aTargetTable = new IPersistableObject[]{target};
            }
        } else {
            aTargetTable = this.loadCustomListFromOMR(omr, TARGET_TABLE);
        }
        if (aTargetTable != null && aTargetTable.length > 0) {
            ITransformTableOptions opts = this.findTransformTableOptionsFromOMR(omr, (IPhysicalTable)aTargetTable[0]);
            if (opts != null) {
                this.setTargetTable((IPhysicalTable)aTargetTable[0], false);
                this.addTransformTableOption(opts);
                this.m_targetTransformTableOptions = opts;
            } else {
                this.setTargetTable((IPhysicalTable)aTargetTable[0]);
            }
        }
        if ((aErrorTable = this.loadCustomListFromOMR(omr, "ErrorTable")).length > 0) {
            ITransformTableOptions opts = this.findTransformTableOptionsFromOMR(omr, (IPhysicalTable)aErrorTable[0]);
            if (opts != null) {
                this.setErrorTable((IPhysicalTable)aErrorTable[0], false);
                this.addTransformTableOption(opts);
                this.m_errorTransformTableOptions = opts;
            } else {
                this.setErrorTable((IPhysicalTable)aErrorTable[0]);
            }
        }
        if ((aExceptionTable = this.loadCustomListFromOMR(omr, EXCEPTION_TABLE)).length > 0) {
            ITransformTableOptions opts = this.findTransformTableOptionsFromOMR(omr, (IPhysicalTable)aExceptionTable[0]);
            if (opts != null) {
                this.setExceptionTable((IPhysicalTable)aExceptionTable[0], false);
                this.addTransformTableOption(opts);
                this.m_excTransformTableOptions = opts;
            } else {
                this.setExceptionTable((IPhysicalTable)aExceptionTable[0]);
            }
        }
        this.loadPortDescriptions();
        if (classifierMap != null) {
            AssociationList lEvents = classifierMap.getTriggeredEvents();
            for (int i = 0; i < lEvents.size(); ++i) {
                Event oEvent = (Event)omr.acquireOMRObject(((Event)lEvents.get(i)).getId(), "Event");
                String sCondition = oEvent.getCondition();
                DataValidationRecord oDVRecord = new DataValidationRecord(oEvent.getId(), this, sCondition);
                if (sCondition.equals(CUSTOM)) {
                    oDVRecord.loadFromOMR(omr, this, this.m_lDVRCustom.size());
                    this.m_lDVRCustom.add(oDVRecord);
                } else if (sCondition.equals(DUPLICATE)) {
                    oDVRecord.loadFromOMR(omr, this, this.m_lDVRDuplicate.size());
                    this.m_lDVRDuplicate.add(oDVRecord);
                } else if (sCondition.equals(MISSING)) {
                    oDVRecord.loadFromOMR(omr, this, this.m_lDVRMissing.size());
                    this.m_lDVRMissing.add(oDVRecord);
                } else if (sCondition.equals(INVALID)) {
                    oDVRecord.loadFromOMR(omr, this, this.m_lDVRInvalid.size());
                    this.m_lDVRInvalid.add(oDVRecord);
                }
                if (oDVRecord.isRemoveThisRecord()) {
                    if (sCondition.equals(CUSTOM)) {
                        this.m_lDVRCustom.remove(oDVRecord);
                    } else if (sCondition.equals(DUPLICATE)) {
                        this.m_lDVRDuplicate.remove(oDVRecord);
                    } else if (sCondition.equals(MISSING)) {
                        this.m_lDVRMissing.remove(oDVRecord);
                    } else if (sCondition.equals(INVALID)) {
                        this.m_lDVRInvalid.remove(oDVRecord);
                    }
                }
                if (bJobChanged) continue;
                bJobChanged = oDVRecord.isRecordChangedAtLoadTime();
            }
        }
        this.setErrorTableReplace(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_REPLACE_ERROR_TABLE, false));
        this.setExceptionTableReplace(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_REPLACE_EXCEPTION_TABLE, false));
        if (this.m_errorTable == null) {
            this.m_sErrorTableName = this.loadPropertyFromOMR(omr, "OPTIONS", "ErrorTable", "", 2);
            this.setIsErrorTableNameOptionUsed(this.m_sErrorTableName);
            if (this.isErrorTableNameOptionUsed()) {
                this.m_sReplaceErrorTableOption = this.loadStringOptionFromOMR(omr, PROPERTY_SET_NAME_OPTIONS, PROPERTY_NAME_REPLACE_ERROR_TABLE, "NO");
                if (this.m_sReplaceErrorTableOption.equals("")) {
                    this.m_sReplaceErrorTableOption = "NO";
                }
            }
        }
        this.setUseDataStepHash(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_USE_DATA_STEP_HASH, false));
        this.setDataStepHashExpSize(this.loadIntOptionFromOMR(omr, PROPERTY_NAME_DATA_STEP_HASH_EXP_SIZE, 10));
        this.setDupColumnNamesLength(this.loadIntOptionFromOMR(omr, PROPERTY_NAME_DUP_COLUMN_NAMES_LENGTH, 100));
        this.setChanged(bJobChanged);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get("TransformationStep");
        if (lAssociations == null) {
            System.err.println("No entry in load map for TransformationStep");
        }
        lAssociations.add("Transformations");
        lAssociations = new ArrayList<String>();
        lAssociations.add("TriggeredEvents");
        map.put(this.getClassifierMapType(), lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("PropertySets");
        lAssociations.add("SourceTransformations");
        map.put("Event", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("SourceCode");
        lAssociations.add("SubstitutionVariables");
        map.put("Transformation", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("TargetTransformations");
        lAssociations.add("Properties");
        lAssociations.add("SourceTransformations");
        map.put("Property", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("FeatureSources");
        lAssociations.add("FeatureTargets");
        lAssociations.add("Properties");
        lAssociations.add("TransformationSources");
        lAssociations.add("SourceCode");
        lAssociations.add("SubstitutionVariables");
        map.put("FeatureMap", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("AssociatedObject");
        map.put("Variable", lAssociations);
        return map;
    }

    public void setKeepRenamedColumns(String sKeepRenamedColumns) {
        if (sKeepRenamedColumns == null) {
            throw new IllegalArgumentException("null is not allowed for the keep renamed columns option");
        }
        if (this.m_sErrorTableName.equals(sKeepRenamedColumns)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRenamedColumnsUndoable(this.m_sKeepRenamedColsOption, sKeepRenamedColumns));
        }
        this.m_sKeepRenamedColsOption = sKeepRenamedColumns;
        this.fireModelChangedEvent(KEEP_RENAMED_COLUMNS_OPTION_CHANGED, sKeepRenamedColumns);
    }

    public void setReplaceErrorTable(String sReplaceErrorTable) {
        if (sReplaceErrorTable == null) {
            throw new IllegalArgumentException("null is not allowed for the replace error table option");
        }
        if (this.m_sErrorTableName.equals(sReplaceErrorTable)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetReplaceErrorTableUndoable(this.m_sReplaceErrorTableOption, sReplaceErrorTable));
        }
        this.m_sReplaceErrorTableOption = sReplaceErrorTable;
        this.fireModelChangedEvent(REPLACE_ERROR_TABLE_OPTION_CHANGED, sReplaceErrorTable);
    }

    public void setErrorTableName(String sErrorTableName) {
        if (sErrorTableName == null) {
            throw new IllegalArgumentException("null is not allowed for the error table name");
        }
        if (sErrorTableName.indexOf(46) == -1) {
            throw new IllegalArgumentException("the error table name must contain a period; format is libref.tablename");
        }
        if (this.m_sErrorTableName.equals(sErrorTableName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetErrorTableNameUndoable(this.m_sErrorTableName, sErrorTableName));
        }
        this.m_sErrorTableName = sErrorTableName;
        this.fireModelChangedEvent(ERROR_TABLE_NAME_CHANGED, this.m_sErrorTableName);
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        DataValidationCodegen cg = null;
        cg = new DataValidationCodegen(this);
        cg.getGeneratedCode(codeSegment);
        return codeSegment;
    }

    public List makeColumnList(ITable table) throws MdException {
        List<IColumn> columnList = null;
        if (table == null) {
            return columnList;
        }
        IColumn[] columnArray = table.getColumns();
        Arrays.sort(columnArray, new cComparator());
        columnList = Arrays.asList(columnArray);
        return columnList;
    }

    public String createNewDatavalidationCustomRecord() {
        return this.createIDForNewObject();
    }

    public String createNewDataValidationRecord() {
        return this.createIDForNewObject();
    }

    public void addDataValidationRecord(DataValidationRecord oDVR) {
        if (oDVR == null) {
            return;
        }
        if (oDVR.getValidationType().equals(CUSTOM)) {
            this.m_lDVRCustom.add(oDVR);
        } else if (oDVR.getValidationType().equals(DUPLICATE)) {
            this.m_lDVRDuplicate.add(oDVR);
        } else if (oDVR.getValidationType().equals(INVALID)) {
            this.m_lDVRInvalid.add(oDVR);
        } else if (oDVR.getValidationType().equals(MISSING)) {
            this.m_lDVRMissing.add(oDVR);
        } else {
            throw new UnsupportedOperationException("Invalid type on data validation record :" + oDVR.getValidationType());
        }
        this.setChanged(true);
        oDVR.setChanged(true);
    }

    public void moveDataValidationRecord(DataValidationRecord oDVR, int iTo, String sValidationType) {
        if (sValidationType.equals(CUSTOM)) {
            this.m_lDVRCustom.move(oDVR, iTo);
            oDVR.setChanged(true);
        } else if (sValidationType.equals(DUPLICATE)) {
            this.m_lDVRDuplicate.move(oDVR, iTo);
            oDVR.setChanged(true);
        } else if (sValidationType.equals(INVALID)) {
            this.m_lDVRInvalid.move(oDVR, iTo);
            oDVR.setChanged(true);
        } else if (sValidationType.equals(MISSING)) {
            this.m_lDVRMissing.move(oDVR, iTo);
            oDVR.setChanged(true);
        } else {
            throw new UnsupportedOperationException("Invalid type on data validation record :" + oDVR.getValidationType());
        }
        this.setChanged(true);
    }

    public void removeDataValidationRecord(DataValidationRecord oDVR, String sValidation) {
        if (sValidation.equals(CUSTOM)) {
            this.m_lDVRCustom.remove(oDVR.getID());
            this.setChanged(true);
        } else if (sValidation.equals(DUPLICATE)) {
            this.m_lDVRDuplicate.remove(oDVR.getID());
            this.setChanged(true);
        } else if (sValidation.equals(INVALID)) {
            this.m_lDVRInvalid.remove(oDVR.getID());
            this.setChanged(true);
        } else if (sValidation.equals(MISSING)) {
            this.m_lDVRMissing.remove(oDVR.getID());
            this.setChanged(true);
        } else {
            throw new UnsupportedOperationException("Invalid type on data validation record :" + oDVR.getValidationType());
        }
    }

    public void removeDataValidationRecord(DataValidationRecord oDVR) {
        if (oDVR == null) {
            return;
        }
        if (oDVR.getValidationType().equals(CUSTOM)) {
            this.m_lDVRCustom.remove(oDVR);
            this.setChanged(true);
        } else if (oDVR.getValidationType().equals(DUPLICATE)) {
            this.m_lDVRDuplicate.remove(oDVR);
            this.setChanged(true);
        } else if (oDVR.getValidationType().equals(INVALID)) {
            this.m_lDVRInvalid.remove(oDVR);
            this.setChanged(true);
        } else if (oDVR.getValidationType().equals(MISSING)) {
            this.m_lDVRMissing.remove(oDVR);
            this.setChanged(true);
        } else {
            throw new UnsupportedOperationException("Invalid type on data validation record :" + oDVR.getValidationType());
        }
    }

    public void removeAllDataValidationRecords() {
        if (this.m_lDVRCustom.size() > 0) {
            this.m_lDVRCustom.clear();
            this.setChanged(true);
        }
        if (this.m_lDVRDuplicate.size() > 0) {
            this.m_lDVRDuplicate.clear();
            this.setChanged(true);
        }
        if (this.m_lDVRInvalid.size() > 0) {
            this.m_lDVRInvalid.clear();
            this.setChanged(true);
        }
        if (this.m_lDVRMissing.size() > 0) {
            this.m_lDVRMissing.clear();
            this.setChanged(true);
        }
    }

    public List<DataValidationRecord> getModelList(String sValidationType) {
        ArrayList<DataValidationRecord> lDVR = new ArrayList<DataValidationRecord>();
        if (sValidationType.equals(CUSTOM)) {
            lDVR.addAll(this.m_lDVRCustom);
        } else if (sValidationType.equals(DUPLICATE)) {
            lDVR.addAll(this.m_lDVRDuplicate);
        } else if (sValidationType.equals(INVALID)) {
            lDVR.addAll(this.m_lDVRInvalid);
        } else if (sValidationType.equals(MISSING)) {
            lDVR.addAll(this.m_lDVRMissing);
        } else {
            throw new UnsupportedOperationException("Invalid type on data validation record :" + sValidationType);
        }
        return lDVR;
    }

    public List<DataValidationRecord> getAllValidations() {
        ArrayList<DataValidationRecord> lst = new ArrayList<DataValidationRecord>();
        lst.addAll(this.getModelList(CUSTOM));
        lst.addAll(this.getModelList(DUPLICATE));
        lst.addAll(this.getModelList(INVALID));
        lst.addAll(this.getModelList(MISSING));
        return lst;
    }

    public int indexOfDataValidationRecord(DataValidationRecord oDVR) {
        if (oDVR.getValidationType().equals(CUSTOM)) {
            return this.m_lDVRCustom.indexOf(oDVR);
        }
        if (oDVR.getValidationType().equals(DUPLICATE)) {
            return this.m_lDVRDuplicate.indexOf(oDVR);
        }
        if (oDVR.getValidationType().equals(INVALID)) {
            return this.m_lDVRInvalid.indexOf(oDVR);
        }
        if (oDVR.getValidationType().equals(MISSING)) {
            return this.m_lDVRMissing.indexOf(oDVR);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDataValidationRecord(DataValidationRecord oDVRBeforeEdit, DataValidationRecord oDVRAfterEdit) {
        String sValidationType = oDVRBeforeEdit.getValidationType();
        this.startCompoundUndoable();
        try {
            ModelList m_lDVR = null;
            if (sValidationType.equals(CUSTOM)) {
                m_lDVR = this.m_lDVRCustom;
            } else if (sValidationType.equals(DUPLICATE)) {
                m_lDVR = this.m_lDVRDuplicate;
            } else if (sValidationType.equals(INVALID)) {
                m_lDVR = this.m_lDVRInvalid;
            } else if (sValidationType.equals(MISSING)) {
                m_lDVR = this.m_lDVRMissing;
            }
            int iIndex = m_lDVR.indexOf(oDVRBeforeEdit);
            m_lDVR.remove(iIndex);
            m_lDVR.add(iIndex, oDVRAfterEdit);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public static String getColumnNames(List columnList) {
        return DataValidationTransformModel.getColumnNames(columnList, true);
    }

    public static String getColumnNames(List columnList, boolean commas) {
        StringBuffer colNames = new StringBuffer("");
        for (int i = 0; i < columnList.size(); ++i) {
            IColumn column = (IColumn)columnList.get(i);
            if (column == null) continue;
            if (colNames.length() > 1) {
                if (commas) {
                    colNames.append(",");
                }
                colNames.append(" ");
            }
            colNames.append(column.getName());
        }
        return colNames.toString();
    }

    protected IPhysicalTable getNextPhysicalTable(DataValidationTransformModel transform) throws CodegenException {
        IDataTransform nextTransform;
        IPhysicalTable lastTable = null;
        if (this.getDataTargetsCount() == 0) {
            return null;
        }
        IPhysicalTable table = (IPhysicalTable)this.getDataTargetList().get(0);
        if (table == null) {
            return lastTable;
        }
        IDataTransform[] transforms = table.getConsumerTransforms();
        for (int i = 0; i < transforms.length && (lastTable = this.getNextPhysicalTableRecursive(nextTransform = transforms[i])) == null; ++i) {
        }
        return lastTable;
    }

    private IPhysicalTable getNextPhysicalTableRecursive(IDataTransform transform) {
        if (transform instanceof TableLoaderTransformModel && transform.getDataTargetList().size() > 0) {
            return (IPhysicalTable)transform.getDataTargetList().get(0);
        }
        if (transform.getDataTargetsCount() == 0) {
            return null;
        }
        IPhysicalTable foundObject = null;
        IDataObject[] targetDataObjects = transform.getDataTargets();
        for (int t = 0; t < targetDataObjects.length; ++t) {
            IDataObject targetObject = targetDataObjects[t];
            IDataTransform[] consumers = targetObject.getConsumerTransforms();
            for (int z = 0; z < consumers.length && (foundObject = this.getNextPhysicalTableRecursive(consumers[z])) == null; ++z) {
            }
            if (foundObject != null) break;
        }
        return foundObject;
    }

    public List getDVRMissing() {
        return this.m_lDVRMissing;
    }

    public List getDVRInvalid() {
        return this.m_lDVRInvalid;
    }

    public List getDVRDuplicate() {
        return this.m_lDVRDuplicate;
    }

    public List getDVRCustom() {
        return this.m_lDVRCustom;
    }

    protected void addDataValidationRecordsToNewTarget(IPhysicalTable target) {
        DataValidationRecord newDataValidationRecord;
        DataValidationRecord dataValidationRecord;
        int iRecord;
        if (this.m_lDVRCustom_FromDeletedTarget != null && this.m_lDVRCustom_FromDeletedTarget.size() > 0) {
            for (iRecord = 0; iRecord < this.m_lDVRCustom_FromDeletedTarget.size(); ++iRecord) {
                dataValidationRecord = (DataValidationRecord)this.m_lDVRCustom_FromDeletedTarget.get(iRecord);
                newDataValidationRecord = this.getNewDataValidationRecord(target, dataValidationRecord, iRecord);
                if (newDataValidationRecord == null) continue;
                this.m_lDVRCustom.add(newDataValidationRecord);
            }
            this.setChanged(true);
        }
        if (this.m_lDVRDuplicate_FromDeletedTarget != null && this.m_lDVRDuplicate_FromDeletedTarget.size() > 0) {
            for (iRecord = 0; iRecord < this.m_lDVRDuplicate_FromDeletedTarget.size(); ++iRecord) {
                dataValidationRecord = (DataValidationRecord)this.m_lDVRDuplicate_FromDeletedTarget.get(iRecord);
                newDataValidationRecord = this.getNewDataValidationRecord(target, dataValidationRecord, iRecord);
                if (newDataValidationRecord == null) continue;
                this.m_lDVRDuplicate.add(newDataValidationRecord);
            }
            this.setChanged(true);
        }
        if (this.m_lDVRInvalid_FromDeletedTarget != null && this.m_lDVRInvalid_FromDeletedTarget.size() > 0) {
            for (iRecord = 0; iRecord < this.m_lDVRInvalid_FromDeletedTarget.size(); ++iRecord) {
                dataValidationRecord = (DataValidationRecord)this.m_lDVRInvalid_FromDeletedTarget.get(iRecord);
                newDataValidationRecord = this.getNewDataValidationRecord(target, dataValidationRecord, iRecord);
                if (newDataValidationRecord == null) continue;
                this.m_lDVRInvalid.add(newDataValidationRecord);
            }
            this.setChanged(true);
        }
        if (this.m_lDVRMissing_FromDeletedTarget != null && this.m_lDVRMissing_FromDeletedTarget.size() > 0) {
            for (iRecord = 0; iRecord < this.m_lDVRMissing_FromDeletedTarget.size(); ++iRecord) {
                dataValidationRecord = (DataValidationRecord)this.m_lDVRMissing_FromDeletedTarget.get(iRecord);
                newDataValidationRecord = this.getNewDataValidationRecord(target, dataValidationRecord, iRecord);
                if (newDataValidationRecord == null) continue;
                this.m_lDVRMissing.add(newDataValidationRecord);
            }
            this.setChanged(true);
        }
    }

    private boolean canAutoMapAndPropagate(ITable tblTarget) {
        return this.getExceptionTable() != tblTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IColumn[] propagateColumnsImpl(IColumn[] aSourceColumns, ITable tblTarget, List lExcludedColumns, boolean bForward) {
        if (!this.canAutoMapAndPropagate(tblTarget)) {
            return new IColumn[0];
        }
        this.startCompoundUndoable();
        try {
            IColumn[] aColumns = super.propagateColumnsImpl(aSourceColumns, tblTarget, lExcludedColumns, bForward);
            if (tblTarget instanceof IWorkTable && this.getDVRCustom().size() <= 0 && this.getDVRInvalid().size() <= 0 && this.getDVRMissing().size() <= 0 && this.getDVRDuplicate().size() <= 0) {
                this.addDataValidationRecordsToNewTarget((IWorkTable)tblTarget);
            }
            IColumn[] iColumnArray = aColumns;
            return iColumnArray;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private DataValidationRecord getNewDataValidationRecord(IDataObject oTargetTable, DataValidationRecord oDVR, int iMachineRow) {
        DataValidationRecord oCopyOfDVR = oDVR.createCopyOfDataValidationRecord();
        if (oCopyOfDVR.getValidationType().equals(CUSTOM)) {
            for (int iCustomType = 0; iCustomType < 2; ++iCustomType) {
                ModelList lCustomConditionRecords = null;
                boolean bCustomConditionType = false;
                if (iCustomType == 0) {
                    lCustomConditionRecords = oCopyOfDVR.getCustomTrueTypeRecords();
                    bCustomConditionType = true;
                } else {
                    lCustomConditionRecords = oCopyOfDVR.getCustomFalseTypeRecords();
                    bCustomConditionType = false;
                }
                if (lCustomConditionRecords != null) {
                    for (int i = 0; i < lCustomConditionRecords.size(); ++i) {
                        DataValidationCustomConditionRecord customRecord = (DataValidationCustomConditionRecord)lCustomConditionRecords.get(i);
                        IColumn oldColumn = customRecord.getSetColumn();
                        IColumn newColumn = this.getColumnFromTarget(oldColumn, oTargetTable);
                        customRecord.setSetColumn(newColumn);
                        if (newColumn != null) continue;
                        this.logColumnMissingFromTarget(oCopyOfDVR, oldColumn, iMachineRow * 1000 + i, bCustomConditionType);
                    }
                }
                if (iCustomType == 0) {
                    oCopyOfDVR.setCustomTrueTypeRecords(lCustomConditionRecords);
                    continue;
                }
                oCopyOfDVR.setCustomFalseTypeRecords(lCustomConditionRecords);
            }
        } else if (oCopyOfDVR.getValidationType().equals(DUPLICATE)) {
            ArrayList columnList = oCopyOfDVR.getColumnList_FM1();
            for (int i = 0; i < columnList.size(); ++i) {
                IColumn oldColumn = (IColumn)columnList.get(i);
                IColumn newColumn = this.getColumnFromTarget(oldColumn, oTargetTable);
                columnList.set(i, newColumn);
                if (newColumn != null) continue;
                this.logColumnMissingFromTarget(oCopyOfDVR, oldColumn, iMachineRow, false);
            }
            oCopyOfDVR.setColumnList_FM1(columnList);
        } else if (oCopyOfDVR.getValidationType().equals(INVALID) || oCopyOfDVR.getValidationType().equals(MISSING)) {
            IColumn oldColumn = oCopyOfDVR.getColumn_FM1();
            IColumn newColumn = this.getColumnFromTarget(oldColumn, oTargetTable);
            oCopyOfDVR.setColumn_FM1(newColumn, this);
            if (newColumn == null) {
                this.logColumnMissingFromTarget(oCopyOfDVR, oldColumn, iMachineRow, false);
            }
        }
        return oCopyOfDVR;
    }

    public void logColumnMissingFromTarget(DataValidationRecord oDVR, IColumn oldColumn, int iMachineRow, boolean bConditionTrue) {
        String sOldColumnName = "";
        if (oldColumn != null) {
            sOldColumnName = oldColumn.toString();
        }
        String sTab = DataValidationTransformModel.getDataValidationTabTitle(oDVR, bConditionTrue);
        String sRow = "";
        if (iMachineRow > 0) {
            Object[] saRowNumber = new String[]{Integer.toString(iMachineRow + 1)};
            if (oDVR.getValidationType().equals(CUSTOM)) {
                int iDVRRow = iMachineRow / 1000 + 1;
                int iTemp = iMachineRow / 1000;
                int iUserRow = iMachineRow - iTemp * 1000 + 1;
                saRowNumber = new String[]{Integer.toString(iDVRRow + 1) + "-" + Integer.toString(iUserRow)};
            }
            sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
        }
        Object[] saTabAndColumn = new String[]{sTab, sRow, sOldColumnName};
        ModelLogger.getDefaultLogger().warn((Object)MessageFormat.format(RB.getStringResource("DataValidationRecord.ColumnMissingFromTarget.txt"), saTabAndColumn));
    }

    public static String getDataValidationTabTitle(DataValidationRecord oDVR) {
        return DataValidationTransformModel.getDataValidationTabTitle(oDVR, false);
    }

    public static String getDataValidationTabTitle(DataValidationRecord oDVR, boolean bConditionTrue) {
        String sTab = "";
        if (oDVR.getValidationType().equals(INVALID)) {
            sTab = RB.getStringResource("DataValidationRecord.InvalidValues.Title.txt");
        } else if (oDVR.getValidationType().equals(MISSING)) {
            sTab = RB.getStringResource("DataValidationRecord.MissingValues.Title.txt");
        } else if (oDVR.getValidationType().equals(DUPLICATE)) {
            sTab = RB.getStringResource("DataValidationRecord.DuplicateValues.Title.txt");
        } else if (oDVR.getValidationType().equals(CUSTOM) && bConditionTrue) {
            sTab = RB.getStringResource("DataValidationRecord.CustomValuesTrue.Title.txt");
        } else if (oDVR.getValidationType().equals(CUSTOM) && !bConditionTrue) {
            sTab = RB.getStringResource("DataValidationRecord.CustomValuesFalse.Title.txt");
        } else {
            throw new UnsupportedOperationException("Invalid type on data validation record :" + oDVR.getValidationType());
        }
        return sTab;
    }

    private IColumn getColumnFromTarget(IColumn column, IDataObject target2) {
        IPhysicalTable oTable = null;
        if (!(target2 instanceof IPhysicalTable)) {
            return null;
        }
        oTable = (IPhysicalTable)target2;
        IColumn[] aColumns = oTable.getColumns();
        boolean bCaseSensitive = this.isQuotingNeeded();
        for (int i = 0; i < aColumns.length; ++i) {
            if (aColumns[i] == null || column == null || !aColumns[i].equalsName(column, bCaseSensitive)) continue;
            return aColumns[i];
        }
        return null;
    }

    @Override
    protected void postAddDataTarget(IDataObject target) {
        this.startCompoundUndoable();
        super.postAddDataTarget(target);
        try {
            if (!(target instanceof IWorkTable)) {
                this.addDataValidationRecordsToNewTarget((IPhysicalTable)target);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected void preRemoveDataTarget(IDataObject target) {
        this.startCompoundUndoable();
        super.preRemoveDataTarget(target);
        try {
            int iRecord;
            if (this.m_lDVRCustom.size() > 0 || this.m_lDVRDuplicate.size() > 0 || this.m_lDVRInvalid.size() > 0 || this.m_lDVRMissing.size() > 0) {
                if (this.m_lDVRCustom_FromDeletedTarget != null) {
                    this.m_lDVRCustom_FromDeletedTarget.clear();
                }
                if (this.m_lDVRDuplicate_FromDeletedTarget != null) {
                    this.m_lDVRDuplicate_FromDeletedTarget.clear();
                }
                if (this.m_lDVRInvalid_FromDeletedTarget != null) {
                    this.m_lDVRInvalid_FromDeletedTarget.clear();
                }
                if (this.m_lDVRMissing_FromDeletedTarget != null) {
                    this.m_lDVRMissing_FromDeletedTarget.clear();
                }
            } else {
                return;
            }
            this.m_lDVRCustom_FromDeletedTarget = new ArrayList();
            this.m_lDVRDuplicate_FromDeletedTarget = new ArrayList();
            this.m_lDVRInvalid_FromDeletedTarget = new ArrayList();
            this.m_lDVRMissing_FromDeletedTarget = new ArrayList();
            if (this.m_lDVRCustom.size() > 0) {
                for (iRecord = 0; iRecord < this.m_lDVRCustom.size(); ++iRecord) {
                    this.m_lDVRCustom_FromDeletedTarget.add(this.m_lDVRCustom.get(iRecord));
                }
                this.m_lDVRCustom.clear();
                this.setChanged(true);
            }
            if (this.m_lDVRDuplicate.size() > 0) {
                for (iRecord = 0; iRecord < this.m_lDVRDuplicate.size(); ++iRecord) {
                    this.m_lDVRDuplicate_FromDeletedTarget.add(this.m_lDVRDuplicate.get(iRecord));
                }
                this.m_lDVRDuplicate.clear();
                this.setChanged(true);
            }
            if (this.m_lDVRInvalid.size() > 0) {
                for (iRecord = 0; iRecord < this.m_lDVRInvalid.size(); ++iRecord) {
                    this.m_lDVRInvalid_FromDeletedTarget.add(this.m_lDVRInvalid.get(iRecord));
                }
                this.m_lDVRInvalid.clear();
                this.setChanged(true);
            }
            if (this.m_lDVRMissing.size() > 0) {
                for (iRecord = 0; iRecord < this.m_lDVRMissing.size(); ++iRecord) {
                    this.m_lDVRMissing_FromDeletedTarget.add(this.m_lDVRMissing.get(iRecord));
                }
                this.m_lDVRMissing.clear();
                this.setChanged(true);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void notify(NotifyEvent ev) {
        this.startCompoundUndoable();
        try {
            super.notify(ev);
            if (ev.getSource() instanceof IColumn && ev.getType() == 0) {
                this.dealWithRemovedColumn((IColumn)ev.getSource());
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public void addNotifyListener(IColumn column) {
        column.addNotifyListener(this);
    }

    public void removeNotifyListener(IColumn column) {
        column.removeNotifyListener(this);
    }

    public void logColumnDeleted(DataValidationRecord oDVR, IColumn oldColumn, int iMachineRow, boolean bConditionTrue) {
        String sOldColumnName = "";
        if (oldColumn != null) {
            sOldColumnName = oldColumn.toString();
        }
        String sTab = DataValidationTransformModel.getDataValidationTabTitle(oDVR, bConditionTrue);
        String sRow = "";
        if (iMachineRow > 0) {
            Object[] saRowNumber = new String[]{Integer.toString(iMachineRow + 1)};
            if (oDVR.getValidationType().equals(CUSTOM)) {
                int iDVRRow = iMachineRow / 1000 + 1;
                int iTemp = iMachineRow / 1000;
                int iUserRow = iMachineRow - iTemp * 1000 + 1;
                saRowNumber = new String[]{Integer.toString(iDVRRow + 1) + "-" + Integer.toString(iUserRow)};
            }
            sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
        }
        Object[] saTabAndColumn = new String[]{sTab, sRow, sOldColumnName};
        ModelLogger.getDefaultLogger().warn((Object)MessageFormat.format(RB.getStringResource("DataValidationRecord.ColumnDeleted.txt"), saTabAndColumn));
    }

    public void logDeletedColumnUsedInExpression(DataValidationRecord oDVR, IColumn oldColumn, int iMachineRow, boolean bConditionTrue) {
        String sOldColumnName = "";
        if (oldColumn != null) {
            sOldColumnName = oldColumn.toString();
        }
        String sTab = DataValidationTransformModel.getDataValidationTabTitle(oDVR, bConditionTrue);
        String sRow = "";
        if (iMachineRow > 0) {
            Object[] saRowNumber = new String[]{Integer.toString(iMachineRow + 1)};
            if (oDVR.getValidationType().equals(CUSTOM)) {
                int iDVRRow = iMachineRow / 1000 + 1;
                int iTemp = iMachineRow / 1000;
                int iUserRow = iMachineRow - iTemp * 1000 + 1;
                saRowNumber = new String[]{Integer.toString(iDVRRow + 1) + "-" + Integer.toString(iUserRow)};
            }
            sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
        }
        Object[] saTabAndColumn = new String[]{sTab, sRow, sOldColumnName};
        ModelLogger.getDefaultLogger().warn((Object)MessageFormat.format(RB.getStringResource("DataValidationRecord.DeletedColumnInExpression.txt"), saTabAndColumn));
    }

    private void dealWithRemovedColumn(IColumn oDeletedColumn) {
        DataValidationRecord oCopyOfDVR;
        DataValidationRecord oOldDVR;
        int iRecord;
        oDeletedColumn.removeNotifyListener(this);
        for (iRecord = 0; iRecord < this.m_lDVRCustom.size(); ++iRecord) {
            boolean bRecordChanged = false;
            oOldDVR = (DataValidationRecord)this.m_lDVRCustom.get(iRecord);
            oCopyOfDVR = oOldDVR.createCopyOfDataValidationRecord();
            if (oCopyOfDVR.getExpression().indexOf(oDeletedColumn.getName()) > 0) {
                this.logDeletedColumnUsedInExpression(oCopyOfDVR, oDeletedColumn, iRecord * 1000, false);
            }
            for (int iCustomType = 0; iCustomType < 2; ++iCustomType) {
                ModelList lCustomConditionRecords = null;
                boolean bCustomConditionType = false;
                if (iCustomType == 0) {
                    lCustomConditionRecords = oCopyOfDVR.getCustomTrueTypeRecords();
                    bCustomConditionType = true;
                } else {
                    lCustomConditionRecords = oCopyOfDVR.getCustomFalseTypeRecords();
                    bCustomConditionType = false;
                }
                if (lCustomConditionRecords == null) continue;
                for (int i = 0; i < lCustomConditionRecords.size(); ++i) {
                    DataValidationCustomConditionRecord customRecord = (DataValidationCustomConditionRecord)lCustomConditionRecords.get(i);
                    IColumn oISetColumn = customRecord.getSetColumn();
                    IColumn oISourceColumn = customRecord.getSourceColumn();
                    IColumn oITargetColumn = customRecord.getTargetColumn();
                    String sExpression = customRecord.getExpression();
                    if (oISetColumn != null && oISetColumn.getID() == oDeletedColumn.getID()) {
                        customRecord.setSetColumn(null);
                        this.logColumnDeleted(oCopyOfDVR, oDeletedColumn, iRecord * 1000 + i, bCustomConditionType);
                        bRecordChanged = true;
                    }
                    if (oISourceColumn != null && oISourceColumn.getID() == oDeletedColumn.getID()) {
                        customRecord.setSourceColumn(null);
                        this.logColumnDeleted(oCopyOfDVR, oDeletedColumn, iRecord * 1000 + i, bCustomConditionType);
                        bRecordChanged = true;
                    }
                    if (oITargetColumn != null && oITargetColumn.getID() == oDeletedColumn.getID()) {
                        customRecord.setTargetColumn(null);
                        this.logColumnDeleted(oCopyOfDVR, oDeletedColumn, iRecord * 1000 + i, bCustomConditionType);
                        bRecordChanged = true;
                    }
                    if (sExpression == null || oDeletedColumn == null || sExpression.indexOf(oDeletedColumn.getName()) <= 0) continue;
                    this.logDeletedColumnUsedInExpression(oCopyOfDVR, oDeletedColumn, iRecord * 1000 + i, bCustomConditionType);
                }
            }
            if (!bRecordChanged) continue;
            this.replaceDataValidationRecord(oOldDVR, oCopyOfDVR);
        }
        for (iRecord = 0; iRecord < this.m_lDVRDuplicate.size(); ++iRecord) {
            DataValidationRecord oOldDVR2 = (DataValidationRecord)this.m_lDVRDuplicate.get(iRecord);
            DataValidationRecord oCopyOfDVR2 = oOldDVR2.createCopyOfDataValidationRecord();
            ArrayList columnList = oCopyOfDVR2.getColumnList_FM1();
            boolean bRecordChanged = false;
            for (int i = 0; i < columnList.size(); ++i) {
                IColumn oIColumn = (IColumn)columnList.get(i);
                if (oIColumn == null || oIColumn.getID() != oDeletedColumn.getID()) continue;
                columnList.remove(i);
                this.logColumnDeleted(oCopyOfDVR2, oDeletedColumn, iRecord, false);
                --i;
                bRecordChanged = true;
            }
            if (!bRecordChanged) continue;
            this.replaceDataValidationRecord(oOldDVR2, oCopyOfDVR2);
        }
        for (iRecord = 0; iRecord < this.m_lDVRInvalid.size(); ++iRecord) {
            IColumn oLookupColumn;
            boolean bRecordChanged = false;
            oOldDVR = (DataValidationRecord)this.m_lDVRInvalid.get(iRecord);
            oCopyOfDVR = oOldDVR.createCopyOfDataValidationRecord();
            IColumn oIColumn = oCopyOfDVR.getColumn_FM1();
            if (oIColumn != null && oIColumn.getID() == oDeletedColumn.getID()) {
                oCopyOfDVR.setColumn_FM1(null, this);
                oDeletedColumn.removeNotifyListener(this);
                this.logColumnDeleted(oCopyOfDVR, oDeletedColumn, iRecord, false);
                bRecordChanged = true;
            }
            if ((oLookupColumn = oCopyOfDVR.getLookupColumn_FM2()) != null && oLookupColumn.getID() == oDeletedColumn.getID()) {
                oCopyOfDVR.setLookupColumn_FM2(null, this);
                oDeletedColumn.removeNotifyListener(this);
                this.logColumnDeleted(oCopyOfDVR, oDeletedColumn, iRecord, false);
                bRecordChanged = true;
            }
            if (!bRecordChanged) continue;
            this.replaceDataValidationRecord(oOldDVR, oCopyOfDVR);
        }
        for (iRecord = 0; iRecord < this.m_lDVRMissing.size(); ++iRecord) {
            boolean bRecordChanged = false;
            oOldDVR = (DataValidationRecord)this.m_lDVRMissing.get(iRecord);
            oCopyOfDVR = oOldDVR.createCopyOfDataValidationRecord();
            IColumn oIColumn = oCopyOfDVR.getColumn_FM1();
            if (oIColumn != null && oIColumn.getID() == oDeletedColumn.getID()) {
                oCopyOfDVR.setColumn_FM1(null, this);
                this.logColumnDeleted(oCopyOfDVR, oDeletedColumn, iRecord, false);
                bRecordChanged = true;
            }
            if (!bRecordChanged) continue;
            this.replaceDataValidationRecord(oOldDVR, oCopyOfDVR);
        }
    }

    public boolean isInvalidValues() {
        List invalidValues = this.getDVRInvalid();
        return invalidValues != null && invalidValues.size() > 0;
    }

    public boolean isMissingValues() {
        List missingValues = this.getDVRMissing();
        return missingValues != null && missingValues.size() > 0;
    }

    public boolean isDuplicateValues() {
        List duplicateValues = this.getDVRDuplicate();
        return duplicateValues != null && duplicateValues.size() > 0;
    }

    public boolean isCustomValues() {
        List customValues = this.getDVRCustom();
        return customValues != null && customValues.size() > 0;
    }

    public boolean isExceptionTableComplete() {
        if (this.getExceptionTable() != null) {
            boolean bXrowFound = false;
            for (IColumn exceptionColumn : this.getExceptionTable().getColumns()) {
                if (!exceptionColumn.getName().equalsIgnoreCase("x_row")) continue;
                bXrowFound = true;
            }
            return bXrowFound;
        }
        return true;
    }

    public boolean isErrorTableRequired() {
        String selectedAction;
        String selectedActionText;
        int i;
        boolean bIsErrorTableRequired = false;
        for (i = 0; i < this.m_lDVRCustom.size(); ++i) {
            DataValidationRecord record1 = (DataValidationRecord)this.m_lDVRCustom.get(i);
            selectedAction = record1.getMetaAction(selectedActionText = record1.getAction());
            if (!selectedAction.equals(MOVE) && !selectedAction.equals(MOVEALL)) continue;
            bIsErrorTableRequired = true;
            break;
        }
        for (i = 0; i < this.m_lDVRDuplicate.size(); ++i) {
            DataValidationRecord record2 = (DataValidationRecord)this.m_lDVRDuplicate.get(i);
            selectedAction = record2.getMetaAction(selectedActionText = record2.getAction());
            if (!selectedAction.equals(MOVE) && !selectedAction.equals(MOVEALL)) continue;
            bIsErrorTableRequired = true;
            break;
        }
        for (i = 0; i < this.m_lDVRInvalid.size(); ++i) {
            DataValidationRecord record3 = (DataValidationRecord)this.m_lDVRInvalid.get(i);
            selectedAction = record3.getMetaAction(selectedActionText = record3.getAction());
            if (!selectedAction.equals(MOVE) && !selectedAction.equals(MOVEALL)) continue;
            bIsErrorTableRequired = true;
            break;
        }
        for (i = 0; i < this.m_lDVRMissing.size(); ++i) {
            DataValidationRecord record4 = (DataValidationRecord)this.m_lDVRMissing.get(i);
            selectedAction = record4.getMetaAction(selectedActionText = record4.getAction());
            if (!selectedAction.equals(MOVE) && !selectedAction.equals(MOVEALL)) continue;
            bIsErrorTableRequired = true;
            break;
        }
        return bIsErrorTableRequired;
    }

    public boolean isGenerateDataStepHash() {
        return this.isDuplicateValues() && this.useDataStepHash();
    }

    public boolean useDataStepHash() {
        return this.m_bUseDataStepHash;
    }

    public void setUseDataStepHash(boolean bUseDataStepHash) {
        if (this.m_bUseDataStepHash == bUseDataStepHash) {
            return;
        }
        this.m_bUseDataStepHash = bUseDataStepHash;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseDataStepHashUndoable(this.m_bUseDataStepHash));
        }
        this.fireModelChangedEvent(DATA_STEP_HASH_CHANGED, null);
    }

    public int getDataStepHashExpSize() {
        return this.m_iDataStepHashExpSize;
    }

    public void setDataStepHashExpSize(int size) {
        if (this.m_iDataStepHashExpSize == size) {
            return;
        }
        if (size < 1 || size > 20) {
            throw new IllegalArgumentException("The hash exponent value is outside the required range 1-20");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDataStepHashExpSizeUndoable(this.m_iDataStepHashExpSize, size));
        }
        this.m_iDataStepHashExpSize = size;
        this.fireModelChangedEvent(DATA_STEP_HASH_EXP_SIZE_CHANGED, null);
    }

    public int getDupColumnNamesLength() {
        if (this.m_iDupColumnNamesLength == 0) {
            this.setDupColumnNamesLength(100);
        }
        return this.m_iDupColumnNamesLength;
    }

    public void setDupColumnNamesLength(int iLength) {
        if (this.m_iDupColumnNamesLength == iLength) {
            return;
        }
        if (iLength < 10 || iLength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("The column length to hold names of duplicate columns outside the required range 10-32767");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDupColumnNamesLengthUndoable(this.m_iDupColumnNamesLength, iLength));
        }
        this.m_iDupColumnNamesLength = iLength;
        this.fireModelChangedEvent(DUP_COLUMN_NAMES_LENGTH_CHANGED, null);
    }

    public void setErrorTableReplace(boolean bValue) {
        if (bValue == this.m_bErrorTableReplace) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetErrorTableReplaceUndoable(this.m_bErrorTableReplace, bValue));
        }
        this.m_bErrorTableReplace = bValue;
        this.fireModelChangedEvent(ERROR_TABLE_REPLACE_CHANGED, null);
    }

    public boolean isErrorTableReplace() {
        return this.m_bErrorTableReplace;
    }

    public void setExceptionTableReplace(boolean bValue) {
        if (bValue == this.m_bExceptionTableReplace) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExceptionTableReplaceUndoable(this.m_bExceptionTableReplace, bValue));
        }
        this.m_bExceptionTableReplace = bValue;
        this.fireModelChangedEvent(EXCEPTION_TABLE_REPLACE_CHANGED, null);
    }

    public boolean isExceptionTableReplace() {
        return this.m_bExceptionTableReplace;
    }

    public boolean isErrorTableNameOptionUsed() {
        return this.m_bIsErrorTableNameOptionUsed;
    }

    public void setIsErrorTableNameOptionUsed(String sErrorTableName) {
        this.m_bIsErrorTableNameOptionUsed = false;
        if (sErrorTableName != null && sErrorTableName.length() > 0) {
            this.m_bIsErrorTableNameOptionUsed = true;
        }
    }

    public void removeErrorTableName(boolean remove) {
        if (remove) {
            this.m_sErrorTableName = "";
        }
    }

    public void setExceptionTableName(String sExceptionTableName) {
        if (sExceptionTableName == null) {
            throw new IllegalArgumentException("null is not allowed for the exception table name");
        }
        if (sExceptionTableName.indexOf(46) == -1) {
            throw new IllegalArgumentException("the exception table name must contain a period; format is libref.tablename");
        }
        if (this.m_sExceptionTableName.equals(sExceptionTableName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExceptionTableNameUndoable(this.m_sExceptionTableName, sExceptionTableName));
        }
        this.m_sExceptionTableName = sExceptionTableName;
        this.fireModelChangedEvent(EXCEPTION_TABLE_NAME_CHANGED, this.m_sExceptionTableName);
    }

    public void setReplaceExceptionTable(String sReplaceExceptionTable) {
        if (sReplaceExceptionTable == null) {
            throw new IllegalArgumentException("null is not allowed for the replace exception table option");
        }
        if (this.m_sErrorTableName.equals(sReplaceExceptionTable)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetReplaceExceptionTableUndoable(this.m_sReplaceExceptionTableOption, sReplaceExceptionTable));
        }
        this.m_sReplaceErrorTableOption = sReplaceExceptionTable;
        this.fireModelChangedEvent(REPLACE_EXCEPTION_TABLE_OPTION_CHANGED, sReplaceExceptionTable);
    }

    @Override
    public List<CopyPasteDependentItem> getAdditionalCopyObjects() {
        ArrayList<CopyPasteDependentItem> lst = new ArrayList<CopyPasteDependentItem>();
        for (DataValidationRecord rc : this.getAllValidations()) {
            IColumn column = rc.getLookupColumn_FM2();
            if (column == null) continue;
            lst.add(new CopyPasteDependentItem(column.getTable(), false, false));
        }
        return lst;
    }

    @Override
    public List<IObject> getDependentObjects() {
        return null;
    }

    private class SetTargetTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newTargetTable;
        private IPhysicalTable m_oldTargetTable;

        public SetTargetTableUndoable(IPhysicalTable newTargetTable, IPhysicalTable oldTargetTable) {
            this.m_newTargetTable = newTargetTable;
            this.m_oldTargetTable = oldTargetTable;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setTargetTable(this.m_oldTargetTable);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setTargetTable(this.m_newTargetTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newTargetTable = null;
            this.m_oldTargetTable = null;
        }
    }

    private class SetErrorTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newErrorTable;
        private IPhysicalTable m_oldErrorTable;

        public SetErrorTableUndoable(IPhysicalTable newErrorTable, IPhysicalTable oldErrorTable) {
            this.m_newErrorTable = newErrorTable;
            this.m_oldErrorTable = oldErrorTable;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setErrorTable(this.m_oldErrorTable);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setErrorTable(this.m_newErrorTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newErrorTable = null;
            this.m_oldErrorTable = null;
        }
    }

    private class SetExceptionTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newExceptionTable;
        private IPhysicalTable m_oldExceptionTable;

        public SetExceptionTableUndoable(IPhysicalTable newExceptionTable, IPhysicalTable oldExceptionTable) {
            this.m_newExceptionTable = newExceptionTable;
            this.m_oldExceptionTable = oldExceptionTable;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setExceptionTable(this.m_oldExceptionTable);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setExceptionTable(this.m_newExceptionTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newExceptionTable = null;
            this.m_oldExceptionTable = null;
        }
    }

    private class DataValidationPromptModel
    extends BaseDataTransformPromptModel {
        public DataValidationPromptModel(DataValidationTransformModel model) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            IPromptDefinitionValue pdvReplaceErrorTable;
            super(model.getModel(), model);
            IPromptDefinitionValue pdvErrorTableName = this.getPromptDefinitionValue("ErrorTable");
            if (pdvErrorTableName != null) {
                pdvErrorTableName.setHidden(true);
            }
            if ((pdvReplaceErrorTable = this.getPromptDefinitionValue(DataValidationTransformModel.PROPERTY_NAME_REPLACE_ERROR_TABLE)) != null) {
                pdvReplaceErrorTable.setHidden(true);
            }
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(DataValidationPromptModel.class.getResource("res/Options_DataValidation_Template.xml"));
            PromptGroupInterface result = this.combinePromptGroups(grp1, grp);
            return result;
        }

        @Override
        protected IModelListener createModelListener() {
            return new DataValidationModelListener(this.getOwner(), this);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            this.setOptionValue("ErrorTable", (Object)((DataValidationTransformModel)this.getOwner()).getErrorTableName());
            this.setOptionValue(DataValidationTransformModel.PROPERTY_NAME_REPLACE_ERROR_TABLE, (Object)((DataValidationTransformModel)this.getOwner()).getReplaceErrorTableOption());
            this.setOptionValue(DataValidationTransformModel.PROPERTY_NAME_USE_DATA_STEP_HASH, (Object)(DataValidationTransformModel.this.useDataStepHash() ? DataValidationTransformModel.OPTIONS_TRUE : "NO"));
            this.setOptionValue(DataValidationTransformModel.PROPERTY_NAME_DATA_STEP_HASH_EXP_SIZE, (Object)DataValidationTransformModel.this.getDataStepHashExpSize());
            this.setOptionValue(DataValidationTransformModel.PROPERTY_NAME_DUP_COLUMN_NAMES_LENGTH, (Object)DataValidationTransformModel.this.getDupColumnNamesLength());
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new DataValidationValueChangeListener((DataValidationTransformModel)this.getOwner(), this);
        }

        private class DataValidationModelListener
        extends BaseDataTransformModelListener {
            public DataValidationModelListener(IObject object, IPromptModel promptModel) {
                super(object, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent event) {
                if (event.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(event);
                String type = event.getType();
                this.getPromptModel().setListeningForChanges(false);
                try {
                    if (DataValidationTransformModel.ERROR_TABLE_NAME_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue("ErrorTable", (Object)DataValidationTransformModel.this.getErrorTableName());
                    } else if (DataValidationTransformModel.KEEP_RENAMED_COLUMNS_OPTION_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(DataValidationTransformModel.PROPERTY_NAME_KEEP_RENAMED_COLUMNS, (Object)DataValidationTransformModel.this.getKeepRenamedColumnsOption());
                    } else if (DataValidationTransformModel.REPLACE_ERROR_TABLE_OPTION_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(DataValidationTransformModel.PROPERTY_NAME_REPLACE_ERROR_TABLE, (Object)DataValidationTransformModel.this.getReplaceErrorTableOption());
                    } else if (DataValidationTransformModel.DATA_STEP_HASH_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(DataValidationTransformModel.PROPERTY_NAME_USE_DATA_STEP_HASH, (Object)(DataValidationTransformModel.this.useDataStepHash() ? DataValidationTransformModel.OPTIONS_TRUE : "NO"));
                    } else if (DataValidationTransformModel.DATA_STEP_HASH_EXP_SIZE_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(DataValidationTransformModel.DATA_STEP_HASH_EXP_SIZE_CHANGED, (Object)DataValidationTransformModel.this.getDataStepHashExpSize());
                    } else if (DataValidationTransformModel.DUP_COLUMN_NAMES_LENGTH_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(DataValidationTransformModel.PROPERTY_NAME_DUP_COLUMN_NAMES_LENGTH, (Object)DataValidationTransformModel.this.getDupColumnNamesLength());
                    }
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class DataValidationValueChangeListener
        extends BaseDataTransformValueChangedListener {
            public DataValidationValueChangeListener(DataValidationTransformModel owner, IPromptModel promptModel) {
                super(owner, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    if ("ErrorTable".equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        DataValidationTransformModel.this.setErrorTableOptions(value.toString());
                    } else if (DataValidationTransformModel.PROPERTY_NAME_KEEP_RENAMED_COLUMNS.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        DataValidationTransformModel.this.setKeepRenamedColumnsOption(value.toString());
                    } else if (DataValidationTransformModel.PROPERTY_NAME_REPLACE_ERROR_TABLE.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        DataValidationTransformModel.this.setReplaceErrorTableOption(value.toString());
                    } else if (DataValidationTransformModel.PROPERTY_NAME_USE_DATA_STEP_HASH.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        DataValidationTransformModel.this.setUseDataStepHash(value.equals(DataValidationTransformModel.OPTIONS_TRUE));
                    } else if (DataValidationTransformModel.PROPERTY_NAME_DATA_STEP_HASH_EXP_SIZE.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        DataValidationTransformModel.this.setDataStepHashExpSize(Integer.parseInt(value.toString()));
                    } else if (DataValidationTransformModel.PROPERTY_NAME_DUP_COLUMN_NAMES_LENGTH.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "100";
                        }
                        DataValidationTransformModel.this.setDupColumnNamesLength(Integer.parseInt(value.toString()));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class SetErrorTableNameUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOptions;
        private String m_sNewOptions;

        public SetErrorTableNameUndoable(String oldOptions, String newOptions) {
            this.m_sOldOptions = oldOptions;
            this.m_sNewOptions = newOptions;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setErrorTableName(this.m_sOldOptions);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setErrorTableName(this.m_sNewOptions);
        }
    }

    private class SetRenamedColumnsUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOptions;
        private String m_sNewOptions;

        public SetRenamedColumnsUndoable(String oldOptions, String newOptions) {
            this.m_sOldOptions = oldOptions;
            this.m_sNewOptions = newOptions;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setKeepRenamedColumns(this.m_sOldOptions);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setKeepRenamedColumns(this.m_sNewOptions);
        }
    }

    private class SetReplaceErrorTableUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOptions;
        private String m_sNewOptions;

        public SetReplaceErrorTableUndoable(String oldOptions, String newOptions) {
            this.m_sOldOptions = oldOptions;
            this.m_sNewOptions = newOptions;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setReplaceErrorTable(this.m_sOldOptions);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setReplaceErrorTable(this.m_sNewOptions);
        }
    }

    private class cComparator
    implements Comparator {
        private cComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }

    private class SetUseDataStepHashUndoable
    extends AbstractUndoableEdit {
        private boolean m_bValue;

        public SetUseDataStepHashUndoable(boolean value) {
            this.m_bValue = value;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setUseDataStepHash(!this.m_bValue);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setUseDataStepHash(this.m_bValue);
        }
    }

    private class SetDataStepHashExpSizeUndoable
    extends AbstractUndoableEdit {
        private int m_oldSize;
        private int m_newSize;

        public SetDataStepHashExpSizeUndoable(int oldSize, int newSize) {
            this.m_oldSize = oldSize;
            this.m_newSize = newSize;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setDataStepHashExpSize(this.m_oldSize);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setDataStepHashExpSize(this.m_newSize);
        }
    }

    private class SetDupColumnNamesLengthUndoable
    extends AbstractUndoableEdit {
        private int m_oldLength;
        private int m_newLength;

        public SetDupColumnNamesLengthUndoable(int oldLength, int newLength) {
            this.m_oldLength = oldLength;
            this.m_newLength = newLength;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setDupColumnNamesLength(this.m_oldLength);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setDupColumnNamesLength(this.m_newLength);
        }
    }

    private class SetErrorTableReplaceUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetErrorTableReplaceUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setErrorTableReplace(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setErrorTableReplace(this.m_newValue);
        }
    }

    private class SetExceptionTableReplaceUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetExceptionTableReplaceUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setExceptionTableReplace(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setExceptionTableReplace(this.m_newValue);
        }
    }

    private class SetExceptionTableNameUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOptions;
        private String m_sNewOptions;

        public SetExceptionTableNameUndoable(String oldOptions, String newOptions) {
            this.m_sOldOptions = oldOptions;
            this.m_sNewOptions = newOptions;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setExceptionTableName(this.m_sOldOptions);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setExceptionTableName(this.m_sNewOptions);
        }
    }

    private class SetReplaceExceptionTableUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOptions;
        private String m_sNewOptions;

        public SetReplaceExceptionTableUndoable(String oldOptions, String newOptions) {
            this.m_sOldOptions = oldOptions;
            this.m_sNewOptions = newOptions;
        }

        @Override
        public void undo() {
            super.undo();
            DataValidationTransformModel.this.setReplaceExceptionTable(this.m_sOldOptions);
        }

        @Override
        public void redo() {
            super.redo();
            DataValidationTransformModel.this.setReplaceExceptionTable(this.m_sNewOptions);
        }
    }
}

