/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataValidation;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationCustomConditionRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.etl.models.job.transforms.dataValidation.RB;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.ExpressionParser;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataValidationRecord
extends AbstractPersistableObject {
    public static final String EXPRESSION = "Expression";
    public static final String TRANSLATION = "Translation";
    public static final String BLANKS = "Blanks";
    public static final String ACTIONS = "Actions";
    public static final String ACTION = "Action";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String LOOKUP = "Lookup";
    public static final String TABLE = "Table";
    public static final String TOKENIZEDCONDITION = "TokenizedCondition";
    public static final String TRANSLATE = "Translate";
    public static final String EXCEPTION = "Exception";
    public static final String CONDITION = "Condition";
    public static final String SETVALUETO = "SetValueTo";
    public static final String TRANSLATEEXCEPTION = "TranslateException";
    protected String m_validationType;
    private String m_Event_Condition;
    private String m_Event_Name;
    private String m_PropertySetTrue_ID;
    private String m_PropertySetTrue_Name;
    private String m_PropertySetTrue_Role;
    private String m_PropertySetFalse_ID;
    private String m_PropertySetFalse_Name;
    private String m_PropertySetFalse_Role;
    private String m_PropertyType_ID;
    private String m_PropertyTrue_PS1_ID;
    private String m_PropertyTrue_PS1_Name;
    private String m_PropertyTrue_PS1_DefVal;
    private String m_PropertyFalse_PS1_ID;
    private String m_PropertyFalse_PS1_Name;
    private String m_PropertyFalse_PS1_DefVal;
    private String m_PropertyException_ID;
    private String m_PropertyException_Name;
    private String m_PropertyException_DefVal;
    private String m_FeatureMap1_ID;
    private String m_FeatureMap1_Name;
    private String m_FeatureMap1_Role;
    private IColumn m_Column_FM1;
    private ArrayList m_ColumnList_FM1;
    private String m_PropertyTablesToCheck_ID;
    private String m_PropertyTablesToCheck_Name;
    private String m_PropertyTablesToCheck_Role;
    private String m_PropertyTablesToCheck_MetaValue;
    private String m_Property_FM1_ID;
    private String m_Property_FM1_Name;
    private String m_Property_FM1_DefVal;
    private String m_TextStore_FM1_ID;
    private String m_TextStore_FM1_Name;
    private String m_TextStore_FM1_StoredText;
    private String m_FeatureMap2_EV1_ID;
    private String m_FeatureMap2_EV1_TransformRole;
    private IColumn m_LookupColumn;
    private String m_sAction;
    private String m_sExpression;
    private String m_sCustomAction;
    private boolean m_bExceptionFlag;
    private String m_Transformation_EV1_ID;
    private String m_Transformation_EV1_Name;
    private String m_Transformation_EV1_TransformRole;
    private String m_Property_TrueExceptionChkBox_ID;
    private String m_Property_TrueExceptionChkBox_Name;
    private String m_Property_TrueExceptionChkBox_Role;
    private String m_Property_TrueExceptionChkBox_DefVal;
    private String m_Property_FalseExceptionChkBox_ID;
    private String m_Property_FalseExceptionChkBox_Name;
    private String m_Property_FalseExceptionChkBox_Role;
    private String m_Property_FalseExceptionChkBox_DefVal;
    private DataValidationTransformModel m_dvTransformModel;
    protected List m_metaActionList;
    private ModelList m_lCustomTrue;
    private ModelList m_lCustomFalse;
    private boolean bThisRecordChangedSincePreviousSave = false;
    public static final String CUSTOM_CONDITION_TRUE_ADDED = "DVR:CustomConditionTrueAdded";
    public static final String CUSTOM_CONDITION_TRUE_REMOVED = "DVR:CustomConditionTrueRemoved";
    public static final String CUSTOM_CONDITION_TRUE_MOVED = "DVR:CustomConditionTrueMoved";
    public static final String CUSTOM_CONDITION_FALSE_ADDED = "DVR:CustomConditionFalseAdded";
    public static final String CUSTOM_CONDITION_FALSE_REMOVED = "DVR:CustomConditionFalseRemoved";
    public static final String CUSTOM_CONDITION_FALSE_MOVED = "DVR:CustomConditionFalseMoved";
    protected static Map m_hTablesToCheck;
    protected List m_actionList;
    public static int EXPRESSION_INT;
    public static int TRANSLATION_INT;
    protected boolean m_bRecordChangedAtLoadTime = false;

    public DataValidationRecord(String sEventFQID, DataValidationTransformModel dvTransformModel, String sValidationType) {
        super(sEventFQID, dvTransformModel.getModel());
        this.m_dvTransformModel = dvTransformModel;
        this.setValidationType(sValidationType);
        this.m_metaActionList = DataValidationRecord.loadMetaActionList(sValidationType);
        DataValidationRecord.fillTablesToCheckMap(sValidationType);
        this.m_actionList = DataValidationRecord.makeActionList(this.m_metaActionList, sValidationType);
        this.setEvent_Condition(sValidationType);
        this.setEvent_Name(sValidationType);
        this.setPropertySetTrue_ID(this.createIDForNewObject());
        this.setPropertySetTrue_Name(ACTION);
        this.setPropertySetTrue_Role(TRUE);
        this.setPropertyTrue_PS1_ID(this.createIDForNewObject());
        this.setPropertyTrue_PS1_Name(ACTION);
        this.setFeatureMap1_ID(this.createIDForNewObject());
        this.setFeatureMap1_Name(ACTION);
        this.setFeatureMap1_Role(sValidationType);
        if (sValidationType.compareToIgnoreCase("Custom") == 0) {
            this.m_lCustomTrue = this.createCustomTrueList();
            this.m_lCustomFalse = this.createCustomFalseList();
        }
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("DataValidationRecord.DefaultName.txt");
    }

    @Override
    public boolean isChanged() {
        return super.isChanged();
    }

    @Override
    public boolean isComplete() {
        if (!super.isComplete()) {
            return false;
        }
        boolean bIsComplete = true;
        if ((this.m_validationType.equals("Missing") || this.m_validationType.equals("Invalid")) && this.getColumn_FM1() == null) {
            return false;
        }
        if (this.m_validationType.equals("Duplicate") && (this.getColumnList_FM1() == null || this.getColumnList_FM1().size() == 0)) {
            return false;
        }
        if (this.m_validationType.equals("Invalid") && this.getLookupColumn_FM2() == null) {
            return false;
        }
        if (this.m_validationType.equals("Custom")) {
            DataValidationCustomConditionRecord oCustomRecord_k;
            int k;
            ModelList lColumnsToAssign = null;
            lColumnsToAssign = this.getCustomTrueTypeRecords();
            for (k = 0; k < lColumnsToAssign.size(); ++k) {
                oCustomRecord_k = (DataValidationCustomConditionRecord)lColumnsToAssign.get(k);
                if (oCustomRecord_k.isComplete()) continue;
                return false;
            }
            lColumnsToAssign = this.getCustomFalseTypeRecords();
            for (k = 0; k < lColumnsToAssign.size(); ++k) {
                oCustomRecord_k = (DataValidationCustomConditionRecord)lColumnsToAssign.get(k);
                if (oCustomRecord_k.isComplete()) continue;
                return false;
            }
        }
        return bIsComplete;
    }

    public List getReasonsIncomplete(int iMachineRow) {
        Object[] saTabAndColumn;
        Object[] saRowNumber;
        String sRow;
        String sTab;
        super.getReasonsIncomplete();
        int iUserRow = iMachineRow + 1;
        ArrayList<String> lReasons = new ArrayList<String>();
        if ((this.m_validationType.equals("Missing") || this.m_validationType.equals("Invalid")) && this.getColumn_FM1() == null) {
            sTab = DataValidationTransformModel.getDataValidationTabTitle(this);
            sRow = "";
            if (iUserRow > 0) {
                saRowNumber = new String[]{Integer.toString(iUserRow)};
                sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
            }
            saTabAndColumn = new String[]{sTab, sRow};
            lReasons.add(MessageFormat.format(RB.getStringResource("DataValidationRecord.MissingColumn.txt"), saTabAndColumn));
        }
        if (this.m_validationType.equals("Invalid") && this.getLookupColumn_FM2() == null) {
            sTab = DataValidationTransformModel.getDataValidationTabTitle(this);
            sRow = "";
            if (iUserRow > 0) {
                saRowNumber = new String[]{Integer.toString(iUserRow)};
                sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
            }
            saTabAndColumn = new String[]{sTab, sRow};
            lReasons.add(MessageFormat.format(RB.getStringResource("DataValidationRecord.MissingLookupColumn.txt"), saTabAndColumn));
        }
        if (this.m_validationType.equals("Duplicate") && (this.getColumnList_FM1() == null || this.getColumnList_FM1().size() == 0)) {
            sTab = DataValidationTransformModel.getDataValidationTabTitle(this);
            sRow = "";
            if (iUserRow > 0) {
                saRowNumber = new String[]{Integer.toString(iUserRow)};
                sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
            }
            saTabAndColumn = new String[]{sTab, sRow};
            lReasons.add(MessageFormat.format(RB.getStringResource("DataValidationRecord.MissingColumn.txt"), saTabAndColumn));
        }
        if (this.m_validationType.equals("Custom")) {
            DataValidationCustomConditionRecord oCustomRecord_k;
            int k;
            ModelList lColumnsToAssign = null;
            lColumnsToAssign = this.getCustomTrueTypeRecords();
            for (k = 0; k < lColumnsToAssign.size(); ++k) {
                oCustomRecord_k = (DataValidationCustomConditionRecord)lColumnsToAssign.get(k);
                lReasons.addAll(oCustomRecord_k.getReasonsIncomplete(iMachineRow, k));
            }
            lColumnsToAssign = this.getCustomFalseTypeRecords();
            for (k = 0; k < lColumnsToAssign.size(); ++k) {
                oCustomRecord_k = (DataValidationCustomConditionRecord)lColumnsToAssign.get(k);
                lReasons.addAll(oCustomRecord_k.getReasonsIncomplete(iMachineRow, k));
            }
        }
        return lReasons;
    }

    public void saveToOMR(OMRAdapter omr, ClassifierMap classifierMap, int iMachineRow) throws MdException, RemoteException {
        block23: {
            Event event;
            PropertyType propType;
            block21: {
                Property prop;
                block25: {
                    String sValidationType;
                    block22: {
                        FeatureMap lookupFM;
                        block24: {
                            sValidationType = this.getValidationType();
                            if (this.getPropertyType_ID() == null) {
                                this.setPropertyType_ID(this.createIDForNewObject());
                            }
                            propType = (PropertyType)omr.acquireOMRObject(this.getPropertyType_ID(), "PropertyType");
                            propType.setSQLType(12);
                            propType.setName(sValidationType);
                            event = (Event)omr.acquireOMRObject(this.getID(), "Event");
                            event.setName(this.getEvent_Name());
                            event.setCondition(this.getValidationType());
                            classifierMap.getTriggeredEvents(false).add((Object)event);
                            if (!sValidationType.equals("Missing") && !sValidationType.equals("Invalid") && !sValidationType.equals("Duplicate")) break block21;
                            PropertySet actionPS = null;
                            actionPS = event.getPropertySets().size() == 0 ? this.makeActionPropertySet(TRUE, (Root)event, this.getPropertySetTrue_ID(), omr) : (PropertySet)event.getPropertySets().get(0);
                            prop = null;
                            if (actionPS.getProperties().size() == 0) {
                                prop = this.makeProperty(ACTION, propType, this.getPropertyTrue_PS1_ID(), omr);
                                prop.setPropertyRole(TRUE);
                            } else {
                                prop = (Property)actionPS.getProperties().get(0);
                            }
                            String metaAction = this.getMetaAction(this.getAction());
                            prop.setDefaultValue(metaAction);
                            AssociationList lProp = actionPS.getSetProperties();
                            lProp.clear();
                            lProp.add((Object)prop);
                            if (!sValidationType.equals("Missing") && !sValidationType.equals("Invalid")) break block22;
                            ArrayList<Column> columnList = new ArrayList<Column>(1);
                            if (this.getColumn_FM1() == null) {
                                String sTab = DataValidationTransformModel.getDataValidationTabTitle(this);
                                String sRow = "";
                                if (iMachineRow > 0) {
                                    Object[] saRowNumber = new String[]{Integer.toString(iMachineRow + 1)};
                                    sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
                                }
                                Object[] saTabAndColumn = new String[]{sTab, sRow};
                                ModelLogger.getDefaultLogger().warn((Object)MessageFormat.format(RB.getStringResource("DataValidationRecord.MissingColumn.txt"), saTabAndColumn));
                            } else {
                                Column column = (Column)omr.acquireOMRObject(this.getColumn_FM1().getID(), "Column");
                                if (column != null) {
                                    columnList.clear();
                                    columnList.add(column);
                                }
                            }
                            FeatureMap fm = this.makeActionFeatureMap((Root)prop, columnList, this.getFeatureMap1_ID(), omr);
                            fm.setTransformRole(this.getFeatureMap1_Role());
                            if (this.getDataValidationTransformModel().getTargetTable() != null) {
                                PhysicalTable m_targetTable = (PhysicalTable)omr.acquireOMRObject(this.getDataValidationTransformModel().getTargetTable().getID(), "Column");
                                AssociationList targetColumnsList = m_targetTable.getColumns();
                                String sExpression = this.getExpression();
                                this.makeExpression(sExpression, m_targetTable, targetColumnsList, (AbstractTransformation)fm, omr);
                            }
                            if (!sValidationType.equals("Invalid")) break block23;
                            Property blanksProp = this.makeProperty(BLANKS, propType, this.getProperty_FM1_ID(), omr);
                            blanksProp.setAssociatedObject((Root)fm);
                            String blanksValue = this.getProperty_FM1_DefVal();
                            if (blanksValue == null || blanksValue.equals("")) {
                                blanksValue = "No";
                            }
                            blanksProp.setDefaultValue(blanksValue);
                            blanksProp.setPropertyRole(BLANKS);
                            lookupFM = (FeatureMap)this.makeObject(LOOKUP, "FeatureMap", this.getFeatureMap2_EV1_ID(), omr);
                            lookupFM.setTransformRole(LOOKUP);
                            AssociationList sourceTrans = lookupFM.getSourceTransformations(false);
                            sourceTrans.clear();
                            sourceTrans.add((Object)lookupFM);
                            event.setSourceTransformations(sourceTrans);
                            if (this.getLookupColumn_FM2() != null) break block24;
                            String sTab = DataValidationTransformModel.getDataValidationTabTitle(this);
                            String sRow = "";
                            if (iMachineRow > 0) {
                                Object[] saRowNumber = new String[]{Integer.toString(iMachineRow + 1)};
                                sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
                            }
                            Object[] saTabAndColumn = new String[]{sTab, sRow};
                            ModelLogger.getDefaultLogger().warn((Object)MessageFormat.format(RB.getStringResource("DataValidationRecord.MissingLookupColumn.txt"), saTabAndColumn));
                            break block23;
                        }
                        Column lookupColumn = (Column)omr.acquireOMRObject(this.getLookupColumn_FM2().getID(), "Column");
                        if (lookupColumn == null) break block23;
                        AssociationList featureSource = lookupFM.getFeatureSources(false);
                        featureSource.clear();
                        featureSource.add((Object)lookupColumn);
                        lookupFM.setFeatureSources(featureSource);
                        break block23;
                    }
                    if (!sValidationType.equals("Duplicate")) break block23;
                    if (this.getColumnList_FM1() != null && this.getColumnList_FM1().size() != 0) break block25;
                    ModelLogger.getDefaultLogger().warn((Object)RB.getStringResource("DataValidationRecord.MissingDuplicateColumn.txt"));
                    break block23;
                }
                ArrayList oIColumnList = this.getColumnList_FM1();
                ArrayList<Column> columnList = new ArrayList<Column>();
                for (int i = 0; i < oIColumnList.size(); ++i) {
                    Column column;
                    if (oIColumnList.get(i) == null || (column = (Column)omr.acquireOMRObject(((IColumn)oIColumnList.get(i)).getID(), "Column")) == null) continue;
                    columnList.add(column);
                }
                if (columnList == null || columnList.size() <= 0) break block23;
                FeatureMap fm = this.makeActionFeatureMap((Root)prop, columnList, this.getFeatureMap1_ID(), omr);
                fm.setTransformRole("Duplicate");
                Property tableProp = this.makeProperty(TABLE, propType, this.getPropertyTablesToCheck_ID(), omr);
                tableProp.setAssociatedObject((Root)fm);
                tableProp.setPropertyRole(TABLE);
                tableProp.setDefaultValue(this.getPropertyTablesToCheck_MetaValue());
                break block23;
            }
            Transformation condition = (Transformation)this.makeObject(CONDITION, "Transformation", this.getTransformation_EV1_ID(), omr);
            condition.setTransformRole(TOKENIZEDCONDITION);
            AssociationList sourceTrans = event.getSourceTransformations(false);
            sourceTrans.clear();
            sourceTrans.add((Object)condition);
            PhysicalTable m_targetTable = (PhysicalTable)omr.acquireOMRObject(this.getDataValidationTransformModel().getTargetTable().getID(), "Column");
            AssociationList targetColumnsList = m_targetTable.getColumns();
            String text = this.getExpression();
            this.makeExpression(text, m_targetTable, targetColumnsList, (AbstractTransformation)condition, omr);
            for (int j = 0; j < 2; ++j) {
                DataValidationCustomConditionRecord oCustomValidationRecord;
                int k;
                String metaAction;
                Property actProp;
                PropertySet ps;
                AssociationList list;
                String type;
                PropertySet actPS = null;
                if (j == 1) {
                    type = TRUE;
                    if (event.getPropertySets().size() <= 1) {
                        actPS = this.makeActionPropertySet(type, (Root)event, this.getPropertySetTrue_ID(), omr);
                    } else {
                        list = event.getPropertySets();
                        for (int i = 0; i < list.size(); ++i) {
                            ps = (PropertySet)list.get(i);
                            if (!ps.getSetRole().equalsIgnoreCase(TRUE)) continue;
                            actPS = ps;
                        }
                    }
                    actProp = null;
                    actProp = actPS.getSetProperties().size() > 0 ? (Property)actPS.getSetProperties().get(0) : this.makeProperty(ACTION, propType, this.getPropertyTrue_PS1_ID(), omr);
                    actProp.setAssociatedPropertySet(actPS);
                    metaAction = this.getMetaAction(this.getPropertyTrue_PS1_DefVal());
                    actProp.setDefaultValue(metaAction);
                    actProp.setName(this.getPropertyTrue_PS1_Name());
                    actProp.setPropertyRole(TRUE);
                    Property oPropertyException_TRUE = null;
                    oPropertyException_TRUE = actProp.getProperties().size() > 0 ? (Property)actProp.getProperties().get(0) : this.makeProperty(EXCEPTION, propType, this.get_Property_TrueExceptionChkBox_ID(), omr);
                    oPropertyException_TRUE.setAssociatedObject((Root)actProp);
                    oPropertyException_TRUE.setPropertyRole(EXCEPTION);
                    oPropertyException_TRUE.setDefaultValue(this.get_Property_TrueExceptionChkBox_DefVal());
                    actProp.getTargetTransformations().clear();
                    for (k = 0; k < this.m_lCustomTrue.size(); ++k) {
                        oCustomValidationRecord = (DataValidationCustomConditionRecord)this.m_lCustomTrue.get(k);
                        oCustomValidationRecord.setTargetTable(m_targetTable);
                        oCustomValidationRecord.setActionProperty(actProp);
                        oCustomValidationRecord.saveToOMR(omr);
                    }
                    continue;
                }
                type = FALSE;
                if (event.getPropertySets().size() <= 1) {
                    actPS = this.makeActionPropertySet(type, (Root)event, this.getPropertySetFalse_ID(), omr);
                } else {
                    list = event.getPropertySets();
                    for (int i = 0; i < list.size(); ++i) {
                        ps = (PropertySet)list.get(i);
                        if (!ps.getSetRole().equalsIgnoreCase(FALSE)) continue;
                        actPS = ps;
                    }
                }
                actProp = null;
                actProp = actPS.getSetProperties().size() > 0 ? (Property)actPS.getSetProperties().get(0) : this.makeProperty(ACTION, propType, this.getPropertyFalse_PS1_ID(), omr);
                actProp.setAssociatedPropertySet(actPS);
                metaAction = this.getMetaAction(this.getPropertyFalse_PS1_DefVal());
                actProp.setDefaultValue(metaAction);
                actProp.setName(this.getPropertyFalse_PS1_Name());
                actProp.setPropertyRole(FALSE);
                Property oPropertyException_FALSE = null;
                oPropertyException_FALSE = actProp.getProperties().size() > 0 ? (Property)actProp.getProperties().get(0) : this.makeProperty(EXCEPTION, propType, this.get_Property_FalseExceptionChkBox_ID(), omr);
                oPropertyException_FALSE.setAssociatedObject((Root)actProp);
                oPropertyException_FALSE.setPropertyRole(EXCEPTION);
                oPropertyException_FALSE.setDefaultValue(this.get_Property_FalseExceptionChkBox_DefVal());
                actProp.getTargetTransformations(false).clear();
                for (k = 0; k < this.m_lCustomFalse.size(); ++k) {
                    oCustomValidationRecord = (DataValidationCustomConditionRecord)this.m_lCustomFalse.get(k);
                    oCustomValidationRecord.setTargetTable(m_targetTable);
                    oCustomValidationRecord.setActionProperty(actProp);
                    oCustomValidationRecord.saveToOMR(omr);
                }
            }
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        ModelList lFalseTypeRecords;
        ModelList lTrueTypeRecords;
        super.updateIDs(mapIDs);
        if (mapIDs.containsKey(this.get_Property_FalseExceptionChkBox_ID())) {
            this.set_Property_FalseExceptionChkBox_ID((String)mapIDs.get(this.get_Property_FalseExceptionChkBox_ID()));
        }
        if (mapIDs.containsKey(this.get_Property_TrueExceptionChkBox_ID())) {
            this.set_Property_TrueExceptionChkBox_ID((String)mapIDs.get(this.get_Property_TrueExceptionChkBox_ID()));
        }
        if (mapIDs.containsKey(this.get_PropertyExceptionTrue_ID())) {
            this.set_PropertyExceptionTrue_ID((String)mapIDs.get(this.get_PropertyExceptionTrue_ID()));
        }
        if (mapIDs.containsKey(this.getFeatureMap1_ID())) {
            this.setFeatureMap1_ID((String)mapIDs.get(this.getFeatureMap1_ID()));
        }
        if (mapIDs.containsKey(this.getFeatureMap2_EV1_ID())) {
            this.setFeatureMap2_EV1_ID((String)mapIDs.get(this.getFeatureMap2_EV1_ID()));
        }
        if (mapIDs.containsKey(this.getProperty_FM1_ID())) {
            this.setProperty_FM1_ID((String)mapIDs.get(this.getProperty_FM1_ID()));
        }
        if (mapIDs.containsKey(this.getPropertyException_ID())) {
            this.setPropertyException_ID((String)mapIDs.get(this.getPropertyException_ID()));
        }
        if (mapIDs.containsKey(this.getPropertyFalse_PS1_ID())) {
            this.setPropertyFalse_PS1_ID((String)mapIDs.get(this.getPropertyFalse_PS1_ID()));
        }
        if (mapIDs.containsKey(this.get_Property_TrueExceptionChkBox_ID())) {
            this.set_Property_TrueExceptionChkBox_ID((String)mapIDs.get(this.get_Property_TrueExceptionChkBox_ID()));
        }
        if (mapIDs.containsKey(this.get_Property_FalseExceptionChkBox_ID())) {
            this.set_Property_FalseExceptionChkBox_ID((String)mapIDs.get(this.get_Property_FalseExceptionChkBox_ID()));
        }
        if (mapIDs.containsKey(this.get_PropertyExceptionTrue_ID())) {
            this.set_PropertyExceptionTrue_ID((String)mapIDs.get(this.get_PropertyExceptionTrue_ID()));
        }
        if (mapIDs.containsKey(this.getPropertyTablesToCheck_ID())) {
            this.setPropertyTablesToCheck_ID((String)mapIDs.get(this.getPropertyTablesToCheck_ID()));
        }
        if (mapIDs.containsKey(this.getPropertyTrue_PS1_ID())) {
            this.setPropertyTrue_PS1_ID((String)mapIDs.get(this.getPropertyTrue_PS1_ID()));
        }
        if (mapIDs.containsKey(this.getPropertyType_ID())) {
            this.setPropertyType_ID((String)mapIDs.get(this.getPropertyType_ID()));
        }
        if (mapIDs.containsKey(this.getTextStore_FM1_ID())) {
            this.setTextStore_FM1_ID((String)mapIDs.get(this.getTextStore_FM1_ID()));
        }
        if (mapIDs.containsKey(this.getTransformation_EV1_ID())) {
            this.setTransformation_EV1_ID((String)mapIDs.get(this.getTransformation_EV1_ID()));
        }
        if ((lTrueTypeRecords = this.getCustomTrueTypeRecords()) != null) {
            for (int i = 0; i < lTrueTypeRecords.size(); ++i) {
                ((DataValidationCustomConditionRecord)lTrueTypeRecords.get(i)).updateIDs(mapIDs);
            }
        }
        if ((lFalseTypeRecords = this.getCustomFalseTypeRecords()) != null) {
            for (int i = 0; i < lFalseTypeRecords.size(); ++i) {
                ((DataValidationCustomConditionRecord)lFalseTypeRecords.get(i)).updateIDs(mapIDs);
            }
        }
    }

    public void loadFromOMR(OMRAdapter omr, DataValidationTransformModel dvTransformModel, int iMachineRow) throws MdException, RemoteException {
        block33: {
            Event event;
            IPhysicalTable oTargetTable;
            block31: {
                FeatureMap fm;
                block32: {
                    AssociationList colList;
                    TextStore text;
                    oTargetTable = dvTransformModel.getTargetTable();
                    event = (Event)omr.acquireOMRObject(this.getID(), "Event");
                    this.setEvent_Name(event.getName());
                    this.setEvent_Condition(event.getCondition());
                    if (oTargetTable == null) {
                        // empty if block
                    }
                    if (!event.getCondition().equals("Missing") && !event.getCondition().equals("Invalid") && !event.getCondition().equals("Duplicate")) break block31;
                    PropertySet actionPS = this.getPropertySet(event, TRUE);
                    this.setPropertySetTrue_ID(actionPS.getId());
                    this.setPropertySetTrue_Name(actionPS.getName());
                    this.setPropertySetTrue_Role(actionPS.getSetRole());
                    Property actionProp = this.getProperty(actionPS);
                    if (actionProp == null) {
                        ModelLogger.getDefaultLogger().warn((Object)RB.getStringResource("DataValidationRecord.MissingAction.txt"));
                    }
                    String defValue = actionProp.getDefaultValue();
                    this.setPropertyTrue_PS1_ID(actionProp.getId());
                    this.setPropertyTrue_PS1_Name(actionProp.getName());
                    this.setPropertyTrue_PS1_DefVal(defValue);
                    String sAction = this.getAction(defValue);
                    this.setAction(sAction);
                    fm = this.getFeatureMap(actionProp);
                    if (fm == null) {
                        this.setRemoveThisRecord(true);
                        return;
                    }
                    this.setFeatureMap1_ID(fm.getId());
                    this.setFeatureMap1_Name(fm.getName());
                    this.setFeatureMap1_Role(fm.getTransformRole());
                    if (!this.m_validationType.equals("Missing") && !this.m_validationType.equals("Invalid")) break block32;
                    Column oColumn = DataValidationRecord.getColumn(fm);
                    if (oColumn == null) {
                        this.logMissingColumn(oColumn, iMachineRow);
                    }
                    IColumn oIColumn = null;
                    if (oColumn != null) {
                        oIColumn = (IColumn)omr.acquireObject((Root)oColumn);
                        this.setColumn_FM1(oIColumn, dvTransformModel);
                    }
                    if ((text = DataValidationRecord.getTextStore((AbstractTransformation)fm)) != null) {
                        this.setTextStore_FM1_ID(text.getId());
                        this.setTextStore_FM1_StoredText(text.getStoredText());
                    }
                    String sExpression = DataValidationRecord.getExpression((AbstractTransformation)fm, oTargetTable);
                    this.setExpression(sExpression);
                    if (!this.m_validationType.equals("Invalid")) break block33;
                    AssociationList transList = event.getSourceTransformations();
                    FeatureMap fmLookup = null;
                    for (int i = 0; i < transList.size(); ++i) {
                        CMetadata trans = (CMetadata)transList.get(i);
                        if (trans == null || !(trans instanceof FeatureMap) || !((FeatureMap)trans).getTransformRole().equalsIgnoreCase(LOOKUP)) continue;
                        fmLookup = (FeatureMap)trans;
                        break;
                    }
                    if (fmLookup != null && (colList = fmLookup.getFeatureSources()).size() > 0) {
                        Column lookupColumn = (Column)colList.get(0);
                        IColumn oLookupIColumn = null;
                        ITable oLookupITable = null;
                        oLookupIColumn = (IColumn)omr.acquireObject((Root)lookupColumn);
                        if (lookupColumn == null) {
                            String sTab = DataValidationTransformModel.getDataValidationTabTitle(this);
                            String sRow = "";
                            if (iMachineRow > 0) {
                                Object[] saRowNumber = new String[]{Integer.toString(iMachineRow + 1)};
                                sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
                            }
                            Object[] saTabAndColumn = new String[]{sTab, sRow};
                            ModelLogger.getDefaultLogger().warn((Object)MessageFormat.format(RB.getStringResource("DataValidationRecord.MissingLookupColumn.txt"), saTabAndColumn));
                        }
                        this.setLookupColumn_FM2(oLookupIColumn, dvTransformModel);
                        if (lookupColumn != null && lookupColumn.getTable() != null) {
                            oLookupITable = (ITable)omr.acquireObject((Root)lookupColumn.getTable());
                            oLookupITable.loadFromOMR(omr);
                        }
                        oLookupIColumn.setTable(oLookupITable);
                    }
                    AssociationList propList = fm.getProperties();
                    Property blanksProperty = null;
                    for (int i = 0; i < propList.size(); ++i) {
                        Property prop = (Property)propList.get(i);
                        if (!prop.getPropertyRole().equalsIgnoreCase(BLANKS)) continue;
                        blanksProperty = prop;
                        break;
                    }
                    if (blanksProperty == null) break block33;
                    this.setProperty_FM1_ID(blanksProperty.getId());
                    this.setProperty_FM1_Name(blanksProperty.getName());
                    this.setProperty_FM1_DefVal(blanksProperty.getDefaultValue());
                    break block33;
                }
                if (!this.m_validationType.equals("Duplicate")) break block33;
                List columnList = this.getColumnList(fm);
                ArrayList<IColumn> oIColumnList = new ArrayList<IColumn>();
                for (int i = 0; i < columnList.size(); ++i) {
                    Column oColumn = (Column)columnList.get(i);
                    if (oColumn == null) {
                        this.logMissingColumn(oColumn, iMachineRow);
                        continue;
                    }
                    IColumn oIColumn = (IColumn)omr.acquireObject((Root)oColumn);
                    oIColumnList.add(i, oIColumn);
                }
                String colNames = DataValidationTransformModel.getColumnNames(oIColumnList);
                this.setFeatureMap1_Name(colNames);
                this.setColumnList_FM1(oIColumnList);
                String table = this.getTablesProperty(fm);
                this.createPropertyTablesToCheck_ID();
                this.setPropertyTablesToCheck_Name(TABLE);
                this.setPropertyTablesToCheck_Role(TABLE);
                this.setPropertyTablesToCheck_MetaValue(table);
                break block33;
            }
            if (this.m_validationType.equals("Custom")) {
                String condition = this.getCondition(event, oTargetTable);
                this.setExpression(condition);
                for (int j = 0; j < 2; ++j) {
                    Property prop;
                    int i;
                    AssociationList propList;
                    boolean bExceptionNotSet;
                    String sAction;
                    String defValue;
                    Property actionProp;
                    PropertySet actionPS;
                    if (j == 1) {
                        actionPS = this.getPropertySet(event, TRUE);
                        this.setPropertySetTrue_ID(actionPS.getId());
                        this.setPropertySetTrue_Name(actionPS.getName());
                        this.setPropertySetTrue_Role(actionPS.getSetRole());
                        actionProp = this.getProperty(actionPS);
                        defValue = actionProp.getDefaultValue();
                        sAction = this.getAction(defValue);
                        this.setAction(sAction);
                        this.setPropertyTrue_PS1_ID(actionProp.getId());
                        this.setPropertyTrue_PS1_Name(actionProp.getName());
                        this.setPropertyTrue_PS1_DefVal(sAction);
                        bExceptionNotSet = true;
                        propList = actionProp.getProperties();
                        for (i = 0; i < propList.size(); ++i) {
                            prop = (Property)propList.get(i);
                            if (!prop.getPropertyRole().equalsIgnoreCase(EXCEPTION)) continue;
                            this.set_Property_TrueExceptionChkBox_ID(prop.getId());
                            this.set_Property_TrueExceptionChkBox_Name(prop.getName());
                            this.set_Property_TrueExceptionChkBox_DefVal(prop.getDefaultValue());
                            bExceptionNotSet = false;
                        }
                        if (bExceptionNotSet) {
                            this.createProperty_TrueExceptionChkBox_ID();
                            this.set_Property_TrueExceptionChkBox_Name(EXCEPTION);
                            this.set_Property_TrueExceptionChkBox_DefVal("No");
                        }
                    } else {
                        actionPS = this.getPropertySet(event, FALSE);
                        actionProp = this.getProperty(actionPS);
                        this.setPropertySetFalse_ID(actionPS.getId());
                        this.setPropertySetFalse_Name(actionPS.getName());
                        this.setPropertySetFalse_Role(actionPS.getSetRole());
                        defValue = actionProp.getDefaultValue();
                        sAction = this.getAction(defValue);
                        this.setAction(sAction);
                        this.setPropertyFalse_PS1_ID(actionProp.getId());
                        this.setPropertyFalse_PS1_Name(actionProp.getName());
                        this.setPropertyFalse_PS1_DefVal(sAction);
                        bExceptionNotSet = true;
                        propList = actionProp.getProperties();
                        for (i = 0; i < propList.size(); ++i) {
                            prop = (Property)propList.get(i);
                            if (!prop.getPropertyRole().equalsIgnoreCase(EXCEPTION)) continue;
                            this.set_Property_FalseExceptionChkBox_ID(prop.getId());
                            this.set_Property_FalseExceptionChkBox_Name(prop.getName());
                            this.set_Property_FalseExceptionChkBox_DefVal(prop.getDefaultValue());
                            bExceptionNotSet = false;
                        }
                        if (bExceptionNotSet) {
                            this.createProperty_FalseExceptionChkBox_ID();
                            this.set_Property_FalseExceptionChkBox_Name(EXCEPTION);
                            this.set_Property_FalseExceptionChkBox_DefVal("No");
                        }
                    }
                    List fmList = this.getFeatureMapList(actionProp);
                    for (int k = 0; k < fmList.size(); ++k) {
                        FeatureMap fm = (FeatureMap)fmList.get(k);
                        DataValidationCustomConditionRecord oCustomConditionRecord = null;
                        if (j == 0) {
                            oCustomConditionRecord = new DataValidationCustomConditionRecord(this, fm.getId(), this.getModel(), FALSE);
                        } else if (j == 1) {
                            oCustomConditionRecord = new DataValidationCustomConditionRecord(this, fm.getId(), this.getModel(), TRUE);
                        }
                        if (j == 1) {
                            if (this.getCustomTrueTypeRecords() == null) {
                                this.setCustomTrueTypeRecords(this.createModelList(true));
                            }
                            this.getCustomTrueTypeRecords().add(oCustomConditionRecord);
                        } else if (j == 0) {
                            if (this.getCustomFalseTypeRecords() == null) {
                                this.setCustomFalseTypeRecords(this.createModelList(false));
                            }
                            this.getCustomFalseTypeRecords().add(oCustomConditionRecord);
                        }
                        oCustomConditionRecord.setFM1_Custom_ID(fm.getId());
                        oCustomConditionRecord.setFM1_Custom_Name(fm.getName());
                        oCustomConditionRecord.setFM1_Custom_Role(fm.getTransformRole());
                        oCustomConditionRecord.loadFromOMR(omr, fm, oTargetTable, this, k);
                    }
                }
            }
        }
        this.setChanged(this.m_bRecordChangedAtLoadTime);
    }

    public void logMissingColumn(Column column, int iMachineRow) {
        String sTab = DataValidationTransformModel.getDataValidationTabTitle(this);
        String sRow = "";
        if (iMachineRow > 0) {
            Object[] saRowNumber = new String[]{Integer.toString(iMachineRow + 1)};
            sRow = MessageFormat.format(RB.getStringResource("DataValidationRecord.Row.txt"), saRowNumber);
        }
        Object[] saTabAndColumn = new String[]{sTab, sRow};
        ModelLogger.getDefaultLogger().warn((Object)MessageFormat.format(RB.getStringResource("DataValidationRecord.MissingColumn.txt"), saTabAndColumn));
    }

    private ModelList createModelList(boolean bTrueType) {
        if (bTrueType) {
            return new ModelList(this, new String[]{CUSTOM_CONDITION_TRUE_ADDED, CUSTOM_CONDITION_TRUE_REMOVED, CUSTOM_CONDITION_TRUE_MOVED}, 0, DataValidationCustomConditionRecord.class);
        }
        return new ModelList(this, new String[]{CUSTOM_CONDITION_FALSE_ADDED, CUSTOM_CONDITION_FALSE_REMOVED, CUSTOM_CONDITION_FALSE_MOVED}, 0, DataValidationCustomConditionRecord.class);
    }

    @Override
    public void dump(PrintStream oStream) {
        if (this.getValidationType().equals("Missing")) {
            oStream.println("Missing type data validation record.\n");
            oStream.println("Event:" + this.getEvent_ID() + " " + this.getEvent_Name() + " " + this.getEvent_Condition() + "\n");
            oStream.println("PropertySet:" + this.getPropertySetTrue_ID() + " " + this.getPropertySetTrue_Name() + " " + this.getPropertySetTrue_Role() + "\n");
            oStream.println("Property:" + this.getPropertyTrue_PS1_ID() + " " + this.getPropertyTrue_PS1_Name() + " " + this.getProperty_PS1_DefVal() + "\n");
            oStream.println("FeatureMap:" + this.getFeatureMap1_ID() + " " + this.getFeatureMap1_Name() + " " + this.getFeatureMap1_Role() + "\n");
            oStream.println("Column:" + this.getColumn_FM1().getID() + " " + this.getColumn_FM1().getName() + " " + this.getColumn_FM1().getTable() + "\n");
            oStream.println("TextStore:" + this.getTextStore_FM1_ID() + " " + this.getTextStore_FM1_StoredText() + "\n");
            oStream.println("Expression:" + this.getExpression() + "\n");
            oStream.println(" \n");
        }
    }

    public void dump(boolean bAppend, String sHeader) {
    }

    public String getPropertyType_ID() {
        return this.m_PropertyType_ID;
    }

    private void setPropertyType_ID(String propertyType_ID) {
        this.m_PropertyType_ID = propertyType_ID;
    }

    public String getValidationType() {
        return this.m_validationType;
    }

    public void setValidationType(String type) {
        this.m_validationType = type;
    }

    public String getAction() {
        return this.m_sAction;
    }

    public void setAction(String sAction) {
        this.m_sAction = sAction;
    }

    public String getExpression() {
        return this.m_sExpression;
    }

    public void setExpression(String sExpression) {
        this.m_sExpression = sExpression;
    }

    public String getTransformation_EV1_ID() {
        if (this.m_Transformation_EV1_ID == null) {
            this.m_Transformation_EV1_ID = this.createIDForNewObject();
        }
        return this.m_Transformation_EV1_ID;
    }

    private void setTransformation_EV1_ID(String transformation_EV1_ID) {
        this.m_Transformation_EV1_ID = transformation_EV1_ID;
    }

    public String getTransformation_EV1_Name() {
        return this.m_Transformation_EV1_Name;
    }

    public void setTransformation_EV1_Name(String transformation_EV1_Name) {
        this.m_Transformation_EV1_Name = transformation_EV1_Name;
    }

    public String getTransformation_EV1_TransformRole() {
        return this.m_Transformation_EV1_TransformRole;
    }

    public void setTransformation_EV1_TransformRole(String transformation_EV1_TransformRole) {
        this.m_Transformation_EV1_TransformRole = transformation_EV1_TransformRole;
    }

    public String getCustomAction() {
        return this.m_sCustomAction;
    }

    public void setCustomAction(String customAction) {
        this.m_sCustomAction = customAction;
    }

    public IColumn getColumn_FM1() {
        return this.m_Column_FM1;
    }

    public void setColumn_FM1(IColumn column, DataValidationTransformModel dvTransformModel) {
        if (this.m_Column_FM1 == column) {
            return;
        }
        if (this.m_Column_FM1 != null) {
            dvTransformModel.removeNotifyListener(this.m_Column_FM1);
        }
        this.m_Column_FM1 = column;
        if (this.m_Column_FM1 != null) {
            dvTransformModel.addNotifyListener(column);
        }
    }

    public String getColumn_FM1_Name() {
        if (this.getColumn_FM1() == null) {
            return null;
        }
        return this.getColumn_FM1().getName();
    }

    public IColumn getLookupColumn_FM2() {
        return this.m_LookupColumn;
    }

    public void setLookupColumn_FM2(IColumn oLookupColumn, DataValidationTransformModel transformModel) {
        this.m_LookupColumn = oLookupColumn;
        if (oLookupColumn != null) {
            oLookupColumn.addNotifyListener(transformModel);
        }
    }

    public String getEvent_Condition() {
        return this.m_Event_Condition;
    }

    public void setEvent_Condition(String event_Condition) {
        this.m_Event_Condition = event_Condition;
    }

    public String getEvent_ID() {
        return this.getID();
    }

    public String getFeatureMap1_ID() {
        if (this.m_FeatureMap1_ID == null || this.m_FeatureMap1_ID.length() == 0) {
            this.setFeatureMap1_ID(this.createIDForNewObject());
        }
        return this.m_FeatureMap1_ID;
    }

    private void setFeatureMap1_ID(String featureMap1_ID) {
        this.m_FeatureMap1_ID = featureMap1_ID;
    }

    public String getFeatureMap1_Name() {
        return this.m_FeatureMap1_Name;
    }

    public void setFeatureMap1_Name(String featureMap1_Name) {
        this.m_FeatureMap1_Name = featureMap1_Name;
    }

    public String getFeatureMap1_Role() {
        return this.m_FeatureMap1_Role;
    }

    public void setFeatureMap1_Role(String featuremap1_Role) {
        this.m_FeatureMap1_Role = featuremap1_Role;
    }

    public String getFeatureMap2_EV1_ID() {
        if (this.m_FeatureMap2_EV1_ID == null || this.m_FeatureMap2_EV1_ID.length() == 0) {
            this.setFeatureMap2_EV1_ID(this.createIDForNewObject());
        }
        return this.m_FeatureMap2_EV1_ID;
    }

    private void setFeatureMap2_EV1_ID(String featureMap2_EV1_ID) {
        this.m_FeatureMap2_EV1_ID = featureMap2_EV1_ID;
    }

    public String getFeatureMap2_EV1_TransformRole() {
        return this.m_FeatureMap2_EV1_TransformRole;
    }

    public void setFeatureMap2_EV1_TransformRole(String featureMap2_EV1_TransformRole) {
        this.m_FeatureMap2_EV1_TransformRole = featureMap2_EV1_TransformRole;
    }

    public String getProperty_FM1_DefVal() {
        return this.m_Property_FM1_DefVal;
    }

    public void setProperty_FM1_DefVal(String property_FM1_DefVal) {
        this.m_Property_FM1_DefVal = property_FM1_DefVal;
    }

    public void createProperty_FM1_ID() {
        if (this.getProperty_FM1_ID() == null || this.getProperty_FM1_ID().length() == 0) {
            this.setProperty_FM1_ID(this.createIDForNewObject());
        }
    }

    public String getProperty_FM1_ID() {
        return this.m_Property_FM1_ID;
    }

    private void setProperty_FM1_ID(String property_FM1_ID) {
        this.m_Property_FM1_ID = property_FM1_ID;
    }

    public String getProperty_FM1_Name() {
        return this.m_Property_FM1_Name;
    }

    public void setProperty_FM1_Name(String property_FM1_Name) {
        this.m_Property_FM1_Name = property_FM1_Name;
    }

    public String getProperty_PS1_DefVal() {
        return this.m_PropertyTrue_PS1_DefVal;
    }

    public String getPropertyTrue_PS1_ID() {
        if (this.m_PropertyTrue_PS1_ID == null || this.m_PropertyTrue_PS1_ID.length() == 0) {
            this.setPropertyTrue_PS1_ID(this.createIDForNewObject());
        }
        return this.m_PropertyTrue_PS1_ID;
    }

    private void setPropertyTrue_PS1_ID(String property_PS1_ID) {
        this.m_PropertyTrue_PS1_ID = property_PS1_ID;
    }

    public void createPropertyTrue_PS1_ID() {
        if (this.getPropertyTrue_PS1_ID() == null || this.getPropertyTrue_PS1_ID().length() == 0) {
            this.setPropertyTrue_PS1_ID(this.createIDForNewObject());
        }
    }

    public String getPropertyTrue_PS1_Name() {
        return this.m_PropertyTrue_PS1_Name;
    }

    public void setPropertyTrue_PS1_Name(String property_PS1_Name) {
        this.m_PropertyTrue_PS1_Name = property_PS1_Name;
    }

    public String getPropertySetFalse_ID() {
        if (this.m_PropertySetFalse_ID == null || this.m_PropertySetFalse_ID.length() == 0) {
            this.setPropertySetFalse_ID(this.createIDForNewObject());
        }
        return this.m_PropertySetFalse_ID;
    }

    private void setPropertySetFalse_ID(String propertySetFalse_ID) {
        this.m_PropertySetFalse_ID = propertySetFalse_ID;
    }

    public void createPropertyFalse_ID() {
        if (this.getPropertySetFalse_ID() == null || this.getPropertySetFalse_ID().length() == 0) {
            this.setPropertySetFalse_ID(this.createIDForNewObject());
        }
    }

    public String getPropertySetFalse_Name() {
        return this.m_PropertySetFalse_Name;
    }

    public void setPropertySetFalse_Name(String propertySetFalse_Name) {
        this.m_PropertySetFalse_Name = propertySetFalse_Name;
    }

    public String getPropertySetFalse_Role() {
        return this.m_PropertySetFalse_Role;
    }

    public void setPropertySetFalse_Role(String propertySetFalse_Role) {
        this.m_PropertySetFalse_Role = propertySetFalse_Role;
    }

    public String getPropertySetTrue_ID() {
        return this.m_PropertySetTrue_ID;
    }

    private void setPropertySetTrue_ID(String propertySetTrue_ID) {
        this.m_PropertySetTrue_ID = propertySetTrue_ID;
    }

    public String getPropertySetTrue_Name() {
        return this.m_PropertySetTrue_Name;
    }

    public void setPropertySetTrue_Name(String propertySetTrue_Name) {
        this.m_PropertySetTrue_Name = propertySetTrue_Name;
    }

    public String getPropertySetTrue_Role() {
        return this.m_PropertySetTrue_Role;
    }

    public void setPropertySetTrue_Role(String propertySetTrue_Role) {
        this.m_PropertySetTrue_Role = propertySetTrue_Role;
    }

    public String getTextStore_FM1_ID() {
        return this.m_TextStore_FM1_ID;
    }

    private void setTextStore_FM1_ID(String textStore_FM1_ID) {
        this.m_TextStore_FM1_ID = textStore_FM1_ID;
    }

    public String getTextStore_FM1_Name() {
        return this.m_TextStore_FM1_Name;
    }

    public void setTextStore_FM1_Name(String textStore_FM1_Name) {
        this.m_TextStore_FM1_Name = textStore_FM1_Name;
    }

    public String getTextStore_FM1_StoredText() {
        return this.m_TextStore_FM1_StoredText;
    }

    public void setTextStore_FM1_StoredText(String textStore_FM1_StoredText) {
        this.m_TextStore_FM1_StoredText = textStore_FM1_StoredText;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return super.getOMRLoadTemplateMap();
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return super.getOMRLoadTemplateMap();
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "Event";
    }

    public PropertySet makeActionPropertySet(String setRole, Root owner, String sFQID, OMRAdapter omr) throws RemoteException {
        PropertySet actionPS = (PropertySet)this.makeObject(ACTIONS, "PropertySet", sFQID, omr);
        actionPS.setSetRole(setRole);
        actionPS.setOwningObject(owner);
        return actionPS;
    }

    public Root makeObject(String strName, String objectType, String sFQID, OMRAdapter omr) throws RemoteException {
        Root object = null;
        if (objectType.equals("PropertySet")) {
            object = omr.acquireOMRObject(sFQID, objectType);
        } else if (objectType.equals("Property")) {
            object = omr.acquireOMRObject(sFQID, objectType);
        } else if (objectType.equals("FeatureMap")) {
            object = omr.acquireOMRObject(sFQID, objectType);
        } else if (objectType.equals("TextStore")) {
            object = omr.acquireOMRObject(sFQID, objectType);
        } else if (objectType.equals("Transformation")) {
            object = omr.acquireOMRObject(sFQID, objectType);
        }
        object.setName(strName);
        return object;
    }

    public Property makeProperty(String name, PropertyType propertyType, String sFQID, OMRAdapter omr) throws RemoteException {
        if (sFQID == null || sFQID.length() == 0) {
            return null;
        }
        Property prop = (Property)this.makeObject(name, "Property", sFQID, omr);
        prop.setOwningType(propertyType);
        return prop;
    }

    public FeatureMap makeActionFeatureMap(Root owner, List columnList, String sFQID, OMRAdapter omr) throws MdException, RemoteException {
        FeatureMap featureMap = (FeatureMap)this.makeObject(this.getValidationType(), "FeatureMap", sFQID, omr);
        AssociationList colAssocList = new AssociationList("FeatureTargets");
        for (int j = 0; j < columnList.size(); ++j) {
            Column col = (Column)columnList.get(j);
            colAssocList.add((Object)col);
        }
        featureMap.setFeatureTargets(colAssocList);
        owner.getTargetTransformations().add((Object)featureMap);
        return featureMap;
    }

    public FeatureMap makeFeatureMap(String sTransformRole, Root owner, String sFQID, OMRAdapter omr) throws MdException, RemoteException {
        FeatureMap fm = (FeatureMap)this.makeObject(this.m_validationType, "FeatureMap", sFQID, omr);
        fm.setTransformRole(sTransformRole);
        if (owner.getTargetTransformations().size() > 0) {
            owner.getTargetTransformations().add((Object)fm);
        } else {
            AssociationList targetTrans = new AssociationList("TargetTransformations");
            targetTrans.add((Object)fm);
            owner.setTargetTransformations(targetTrans);
        }
        return fm;
    }

    public void makeExpression(String text, PhysicalTable m_targetTable, AssociationList colList, AbstractTransformation owner, OMRAdapter omr) throws MdException, RemoteException {
        if (text != null && text.length() > 0) {
            boolean useQuotes = DBMSNamesPropertyHandler.needQuotes((DataTable)m_targetTable);
            String expression = ExpressionParser.tokenizeString((String)text, (List)colList, (AbstractTransformation)owner, (boolean)useQuotes, (boolean)useQuotes);
            if (this.getTextStore_FM1_ID() == null) {
                this.setTextStore_FM1_ID(this.createIDForNewObject());
            }
            TextStore ts = (TextStore)this.makeObject(this.m_validationType, "TextStore", this.getTextStore_FM1_ID(), omr);
            ts.setStoredText(expression);
            owner.setSourceCode((Text)ts);
        }
    }

    public boolean isExceptionFlag() {
        return this.m_bExceptionFlag;
    }

    public void setExceptionFlag(boolean exceptionFlag) {
        this.m_bExceptionFlag = exceptionFlag;
    }

    public String getPropertyFalse_PS1_DefVal() {
        return this.m_PropertyFalse_PS1_DefVal;
    }

    public void setPropertyFalse_PS1_DefVal(String propertyFalse_PS1_DefVal) {
        this.m_PropertyFalse_PS1_DefVal = propertyFalse_PS1_DefVal;
    }

    public String getPropertyFalse_PS1_ID() {
        if (this.m_PropertyFalse_PS1_ID == null) {
            this.setPropertyFalse_PS1_ID(this.createIDForNewObject());
        }
        return this.m_PropertyFalse_PS1_ID;
    }

    public void setPropertyFalse_PS1_ID(String propertyFalse_PS1_ID) {
        this.m_PropertyFalse_PS1_ID = propertyFalse_PS1_ID;
    }

    public String getPropertyFalse_PS1_Name() {
        return this.m_PropertyFalse_PS1_Name;
    }

    public void setPropertyFalse_PS1_Name(String propertyFalse_PS1_Name) {
        this.m_PropertyFalse_PS1_Name = propertyFalse_PS1_Name;
    }

    public String getPropertyTablesToCheck_ID() {
        return this.m_PropertyTablesToCheck_ID;
    }

    public void setPropertyTablesToCheck_ID(String propertyTablesToCheck_ID) {
        this.m_PropertyTablesToCheck_ID = propertyTablesToCheck_ID;
    }

    public void createPropertyTablesToCheck_ID() {
        if (this.getPropertyTablesToCheck_ID() == null || this.getPropertyTablesToCheck_ID().length() == 0) {
            this.setPropertyTablesToCheck_ID(this.createIDForNewObject());
        }
    }

    public String getPropertyTablesToCheck_Name() {
        return this.m_PropertyTablesToCheck_Name;
    }

    public void setPropertyTablesToCheck_Name(String propertyTablesToCheck_Name) {
        this.m_PropertyTablesToCheck_Name = propertyTablesToCheck_Name;
    }

    public String getPropertyTablesToCheck_Role() {
        return this.m_PropertyTablesToCheck_Role;
    }

    public void setPropertyTablesToCheck_Role(String propertyTablesToCheck_Role) {
        this.m_PropertyTablesToCheck_Role = propertyTablesToCheck_Role;
    }

    public String getPropertyTablesToCheck_MetaValue() {
        return this.m_PropertyTablesToCheck_MetaValue;
    }

    public String getPropertyTablesToCheck_DisplayValue() {
        if (this.getPropertyTablesToCheck_MetaValue() != null) {
            return RB.getStringResource("DataValidationTransformModel.Duplicate.TableList." + this.getPropertyTablesToCheck_MetaValue() + ".txt");
        }
        return "";
    }

    public void setPropertyTablesToCheck_MetaValue(String propertyTablesToCheck_MetaValue) {
        this.m_PropertyTablesToCheck_MetaValue = propertyTablesToCheck_MetaValue;
    }

    public void setPropertyTablesToCheck_DisplayValue(String tablesToCheckText) {
        if (m_hTablesToCheck.size() == 0) {
            DataValidationRecord.fillTablesToCheckMap("Duplicate");
        }
        this.setPropertyTablesToCheck_MetaValue((String)m_hTablesToCheck.get(tablesToCheckText));
    }

    public String getPropertyTrue_PS1_DefVal() {
        return this.m_PropertyTrue_PS1_DefVal;
    }

    public void setPropertyTrue_PS1_DefVal(String propertyTrue_PS1_DefVal) {
        this.m_PropertyTrue_PS1_DefVal = propertyTrue_PS1_DefVal;
    }

    public String getPropertyException_ID() {
        if (this.m_PropertyException_ID == null) {
            this.setPropertyException_ID(this.createIDForNewObject());
        }
        return this.m_PropertyException_ID;
    }

    public void setPropertyException_ID(String propertyException_ID) {
        this.m_PropertyException_ID = propertyException_ID;
    }

    public ArrayList getColumnList_FM1() {
        if (this.m_ColumnList_FM1 == null) {
            this.m_ColumnList_FM1 = new ArrayList();
        }
        return this.m_ColumnList_FM1;
    }

    public void setColumnList_FM1(List columnList_FM1) {
        IColumn column;
        int i;
        if (this.m_ColumnList_FM1 != null) {
            for (i = 0; i < this.m_ColumnList_FM1.size(); ++i) {
                column = (IColumn)this.m_ColumnList_FM1.get(i);
                if (column == null) continue;
                this.getDataValidationTransformModel().removeNotifyListener(column);
            }
        }
        this.m_ColumnList_FM1 = (ArrayList)columnList_FM1;
        if (this.m_ColumnList_FM1 != null) {
            for (i = 0; i < columnList_FM1.size(); ++i) {
                column = (IColumn)columnList_FM1.get(i);
                if (column == null) continue;
                this.getDataValidationTransformModel().addNotifyListener(column);
            }
        }
    }

    public PropertySet getPropertySet(Event event, String role) throws MdException, RemoteException {
        if (event == null) {
            return null;
        }
        AssociationList psList = event.getPropertySets();
        for (int i = 0; i < psList.size(); ++i) {
            PropertySet ps = (PropertySet)psList.get(i);
            if (!ps.getName().equalsIgnoreCase(ACTIONS) || !ps.getSetRole().equalsIgnoreCase(role)) continue;
            return ps;
        }
        return null;
    }

    public Property getProperty(PropertySet propSet) throws MdException, RemoteException {
        if (propSet == null) {
            return null;
        }
        AssociationList propList = propSet.getSetProperties();
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getName().equalsIgnoreCase(ACTION)) continue;
            return prop;
        }
        return null;
    }

    public FeatureMap getFeatureMap(Property prop) throws MdException, RemoteException {
        if (prop == null) {
            return null;
        }
        AssociationList fmList = prop.getTargetTransformations();
        for (int i = 0; i < fmList.size(); ++i) {
            FeatureMap fm;
            CMetadata cm = (CMetadata)fmList.get(i);
            if (!(cm instanceof FeatureMap) || !(fm = (FeatureMap)cm).getTransformRole().equalsIgnoreCase(this.m_validationType)) continue;
            return fm;
        }
        return null;
    }

    public List getFeatureMapList(Property prop) throws MdException, RemoteException {
        ArrayList<FeatureMap> fmList = new ArrayList<FeatureMap>();
        if (prop == null) {
            return fmList;
        }
        AssociationList targetList = prop.getTargetTransformations();
        for (int i = 0; i < targetList.size(); ++i) {
            FeatureMap fm;
            CMetadata cm = (CMetadata)targetList.get(i);
            if (!(cm instanceof FeatureMap) || !(fm = (FeatureMap)cm).getTransformRole().equalsIgnoreCase(this.m_validationType)) continue;
            fmList.add(fm);
        }
        return fmList;
    }

    public List getVariableList(AbstractTransformation trans) throws MdException, RemoteException {
        if (trans == null) {
            return null;
        }
        return trans.getSubstitutionVariables();
    }

    public static TextStore getTextStore(AbstractTransformation trans) throws MdException, RemoteException {
        if (trans == null) {
            return null;
        }
        Text text = trans.getSourceCode();
        if (text instanceof TextStore) {
            return (TextStore)text;
        }
        return null;
    }

    public String getColumnName(FeatureMap fm) throws MdException, RemoteException {
        Column column;
        AssociationList colList = fm.getFeatureTargets();
        String colName = "";
        if (colList.size() == 1 && (column = (Column)colList.get(0)) != null) {
            colName = column.getSASColumnName();
        }
        return colName;
    }

    public static Column getColumn(FeatureMap fm) throws MdException, RemoteException {
        AssociationList colList = fm.getFeatureTargets();
        Column column = null;
        if (colList.size() == 1) {
            column = (Column)colList.get(0);
        }
        return column;
    }

    public List getColumnList(FeatureMap fm) throws MdException, RemoteException {
        return fm.getFeatureTargets();
    }

    public static String getExpression(AbstractTransformation trans, ITable m_targetTable) throws MdException, RemoteException {
        TextStore text = DataValidationRecord.getTextStore(trans);
        if (text == null) {
            return "";
        }
        String expression = "";
        boolean useQuotes = m_targetTable.isQuoted();
        expression = ExpressionParser.detokenizeString((String)text.getStoredText(), (AbstractTransformation)trans, (boolean)useQuotes);
        return expression;
    }

    public String getTablesProperty(FeatureMap fm) throws MdException, RemoteException {
        AssociationList propList = fm.getProperties();
        if (propList.size() <= 0) {
            return "";
        }
        Property tablesProperty = null;
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getPropertyRole().equalsIgnoreCase(TABLE)) continue;
            tablesProperty = prop;
            break;
        }
        if (tablesProperty == null) {
            return "";
        }
        String metaTablesToCheck = tablesProperty.getDefaultValue();
        if (!metaTablesToCheck.equals("")) {
            return metaTablesToCheck;
        }
        return "";
    }

    public String getBlanksProperty(FeatureMap fm) throws MdException, RemoteException {
        AssociationList propList = fm.getProperties();
        if (propList.size() <= 0) {
            return "";
        }
        Property blanksProperty = null;
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getPropertyRole().equalsIgnoreCase(BLANKS)) continue;
            blanksProperty = prop;
            break;
        }
        if (blanksProperty == null) {
            return "";
        }
        return blanksProperty.getDefaultValue();
    }

    public String getCondition(Event event, ITable oTargetTable) throws MdException, RemoteException {
        AssociationList transList = event.getSourceTransformations();
        if (transList.size() <= 0) {
            return null;
        }
        Transformation transform = null;
        for (int i = 0; i < transList.size(); ++i) {
            CMetadata trans = (CMetadata)transList.get(i);
            if (!(trans instanceof Transformation) || !((Transformation)trans).getTransformRole().equalsIgnoreCase(TOKENIZEDCONDITION)) continue;
            transform = (Transformation)trans;
            break;
        }
        String condition = DataValidationRecord.getExpression(transform, oTargetTable);
        return condition;
    }

    public static FeatureMap getTranslationFM(FeatureMap fm) throws MdException, RemoteException {
        if (fm == null) {
            return null;
        }
        AssociationList transList = fm.getTransformationSources();
        if (transList.size() <= 0) {
            return null;
        }
        for (int i = 0; i < transList.size(); ++i) {
            AbstractTransformation trans = (AbstractTransformation)transList.get(i);
            if (!trans.getTransformRole().equalsIgnoreCase(TRANSLATE) || !(trans instanceof FeatureMap)) continue;
            return (FeatureMap)trans;
        }
        return null;
    }

    public static Column getTranslationFromColumn(FeatureMap fm) throws MdException, RemoteException {
        if (fm == null) {
            return null;
        }
        AssociationList sourceList = fm.getFeatureSources();
        if (sourceList.size() > 0) {
            return (Column)sourceList.get(0);
        }
        return null;
    }

    public static Column getTranslationToColumn(FeatureMap fm) throws MdException, RemoteException {
        if (fm == null) {
            return null;
        }
        AssociationList targetList = fm.getFeatureTargets();
        if (targetList.size() > 0) {
            return (Column)targetList.get(0);
        }
        return null;
    }

    public boolean getExceptionProperty(Property actionProp) throws MdException, RemoteException {
        AssociationList propList = actionProp.getProperties();
        if (propList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getPropertyRole().equalsIgnoreCase(EXCEPTION)) continue;
            return prop.getDefaultValue().equalsIgnoreCase("Yes");
        }
        return false;
    }

    public static Property getTransSetValueToProperty(FeatureMap fm) throws MdException, RemoteException {
        AssociationList propList = fm.getProperties();
        if (propList.size() <= 0) {
            return null;
        }
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getPropertyRole().equalsIgnoreCase(SETVALUETO)) continue;
            return prop;
        }
        return null;
    }

    public String getAction(String metaAction) {
        for (int i = 0; i < this.m_metaActionList.size(); ++i) {
            String listAction = (String)this.m_metaActionList.get(i);
            if (!listAction.equalsIgnoreCase(metaAction)) continue;
            return (String)this.m_actionList.get(i);
        }
        return "";
    }

    public static List loadMetaActionList(String validationType) {
        ArrayList<String> m_metaActionList = new ArrayList<String>(3);
        if (validationType.equals("Missing")) {
            m_metaActionList.add("MOVE");
            m_metaActionList.add("CHANGE");
            m_metaActionList.add("ABORT");
        } else if (validationType.equals("Invalid")) {
            m_metaActionList.add("MOVE");
            m_metaActionList.add("CHANGE");
            m_metaActionList.add("ABORT");
        } else if (validationType.equals("Duplicate")) {
            m_metaActionList.add("MOVEALL");
            m_metaActionList.add("MOVE");
            m_metaActionList.add("ABORT");
        } else if (validationType.equals("Custom")) {
            m_metaActionList.add("NOTHING");
            m_metaActionList.add("MOVE");
            m_metaActionList.add("ABORT");
        }
        return m_metaActionList;
    }

    public static void fillTablesToCheckMap(String validationType) {
        m_hTablesToCheck = new HashMap();
        if (validationType.equals("Duplicate")) {
            m_hTablesToCheck = new HashMap();
            m_hTablesToCheck.put(RB.getStringResource("DataValidationTransformModel.Duplicate.TableList.SOURCE.txt"), "SOURCE");
            m_hTablesToCheck.put(RB.getStringResource("DataValidationTransformModel.Duplicate.TableList.TARGET.txt"), "TARGET");
        }
    }

    public static List makeActionList(List metaActionList, String sValidationType) {
        if (metaActionList == null) {
            return null;
        }
        ArrayList<String> actionList = new ArrayList<String>(metaActionList.size());
        for (int i = 0; i < metaActionList.size(); ++i) {
            actionList.add(RB.getStringResource("DataValidationRecord." + sValidationType + ".ActionList." + (String)metaActionList.get(i) + ".txt"));
        }
        return actionList;
    }

    public static int getChangeAction(List m_metaActionList) {
        for (int i = 0; i < m_metaActionList.size(); ++i) {
            String listAction = (String)m_metaActionList.get(i);
            if (!listAction.equalsIgnoreCase("CHANGE")) continue;
            return i;
        }
        return -1;
    }

    public String getEvent_Name() {
        return this.m_Event_Name;
    }

    public void setEvent_Name(String event_Name) {
        this.m_Event_Name = event_Name;
    }

    public String getMetaAction(String action) {
        for (int i = 0; i < this.m_actionList.size(); ++i) {
            String listAction = (String)this.m_actionList.get(i);
            if (!listAction.equalsIgnoreCase(action)) continue;
            return (String)this.m_metaActionList.get(i);
        }
        return "";
    }

    public static String makeAssignString(ITable table, IColumn fromColumn, IColumn toColumn) {
        String sTableName = RB.getStringResource("DataValidationRecord.MissingValue.txt");
        String sFromColumnName = RB.getStringResource("DataValidationRecord.MissingValue.txt");
        String sToColumnName = RB.getStringResource("DataValidationRecord.MissingValue.txt");
        if (table != null) {
            sTableName = table.getName();
        }
        if (fromColumn != null) {
            sFromColumnName = fromColumn.getName();
        }
        if (toColumn != null) {
            sToColumnName = toColumn.getName();
        }
        return sTableName + ": " + sFromColumnName + "->" + sToColumnName;
    }

    public String get_Property_FalseExceptionChkBox_DefVal() {
        return this.m_Property_FalseExceptionChkBox_DefVal;
    }

    public void set_Property_FalseExceptionChkBox_DefVal(String property_FalseExceptionChkBox_DefVal) {
        this.m_Property_FalseExceptionChkBox_DefVal = property_FalseExceptionChkBox_DefVal;
    }

    public String get_Property_FalseExceptionChkBox_ID() {
        return this.m_Property_FalseExceptionChkBox_ID;
    }

    public void set_Property_FalseExceptionChkBox_ID(String property_FalseExceptionChkBox_ID) {
        this.m_Property_FalseExceptionChkBox_ID = property_FalseExceptionChkBox_ID;
    }

    public void createProperty_FalseExceptionChkBox_ID() {
        if (this.get_Property_FalseExceptionChkBox_ID() == null || this.get_Property_FalseExceptionChkBox_ID().length() == 0) {
            this.set_Property_FalseExceptionChkBox_ID(this.createIDForNewObject());
        }
    }

    public String get_Property_FalseExceptionChkBox_Name() {
        return this.m_Property_FalseExceptionChkBox_Name;
    }

    public void set_Property_FalseExceptionChkBox_Name(String property_FalseExceptionChkBox_Name) {
        this.m_Property_FalseExceptionChkBox_Name = property_FalseExceptionChkBox_Name;
    }

    public String get_Property_FalseExceptionChkBox_Role() {
        return this.m_Property_FalseExceptionChkBox_Role;
    }

    public void set_Property_FalseExceptionChkBox_Role(String property_FalseExceptionChkBox_Role) {
        this.m_Property_FalseExceptionChkBox_Role = property_FalseExceptionChkBox_Role;
    }

    public String get_Property_TrueExceptionChkBox_DefVal() {
        return this.m_Property_TrueExceptionChkBox_DefVal;
    }

    public void set_Property_TrueExceptionChkBox_DefVal(String property_TrueExceptionChkBox_DefVal) {
        this.m_Property_TrueExceptionChkBox_DefVal = property_TrueExceptionChkBox_DefVal;
    }

    public String get_Property_TrueExceptionChkBox_ID() {
        return this.m_Property_TrueExceptionChkBox_ID;
    }

    public void set_Property_TrueExceptionChkBox_ID(String property_TrueExceptionChkBox_ID) {
        this.m_Property_TrueExceptionChkBox_ID = property_TrueExceptionChkBox_ID;
    }

    public void createProperty_TrueExceptionChkBox_ID() {
        if (this.get_Property_TrueExceptionChkBox_ID() == null || this.get_Property_TrueExceptionChkBox_ID().length() == 0) {
            this.set_Property_TrueExceptionChkBox_ID(this.createIDForNewObject());
        }
    }

    public String get_Property_TrueExceptionChkBox_Name() {
        return this.m_Property_TrueExceptionChkBox_Name;
    }

    public void set_Property_TrueExceptionChkBox_Name(String property_TrueExceptionChkBox_Name) {
        this.m_Property_TrueExceptionChkBox_Name = property_TrueExceptionChkBox_Name;
    }

    public String get_Property_TrueExceptionChkBox_Role() {
        return this.m_Property_TrueExceptionChkBox_Role;
    }

    public void set_Property_TrueExceptionChkBox_Role(String property_TrueExceptionChkBox_Role) {
        this.m_Property_TrueExceptionChkBox_Role = property_TrueExceptionChkBox_Role;
    }

    public ModelList getCustomFalseTypeRecords() {
        return this.m_lCustomFalse;
    }

    public void setCustomFalseTypeRecords(ModelList customFalseTypeRecords) {
        this.m_lCustomFalse = customFalseTypeRecords;
    }

    public ModelList getCustomTrueTypeRecords() {
        return this.m_lCustomTrue;
    }

    public void setCustomTrueTypeRecords(ModelList customTrueTypeRecords) {
        this.m_lCustomTrue = customTrueTypeRecords;
    }

    public String get_PropertyExceptionTrue_DefVal() {
        return this.m_PropertyException_DefVal;
    }

    public void set_PropertyExceptionTrue_DefVal(String propertyExceptionTrue_DefVal) {
        this.m_PropertyException_DefVal = propertyExceptionTrue_DefVal;
    }

    public String get_PropertyExceptionTrue_ID() {
        return this.m_PropertyException_ID;
    }

    public void set_PropertyExceptionTrue_ID(String propertyExceptionTrue_ID) {
        this.m_PropertyException_ID = propertyExceptionTrue_ID;
    }

    public String get_PropertyExceptionTrue_Name() {
        return this.m_PropertyException_Name;
    }

    public void set_PropertyExceptionTrue_Name(String propertyExceptionTrue_Name) {
        this.m_PropertyException_Name = propertyExceptionTrue_Name;
    }

    public static Object[] getTablesToCheckDisplayList() {
        if (m_hTablesToCheck.size() == 0) {
            DataValidationRecord.fillTablesToCheckMap("Duplicate");
        }
        return m_hTablesToCheck.keySet().toArray();
    }

    public static String getTablesToCheckDisplayDefault() {
        return RB.getStringResource("DataValidationTransformModel.Duplicate.TableList.SOURCE.txt");
    }

    public void addDataValidationCustomConditionRecord(DataValidationCustomConditionRecord oCustomConditionRecord) {
        if (oCustomConditionRecord == null) {
            return;
        }
        oCustomConditionRecord.setParentRecord(this);
        if (oCustomConditionRecord.getConditionType().equals(TRUE)) {
            this.m_lCustomTrue.add(oCustomConditionRecord);
        } else {
            this.m_lCustomFalse.add(oCustomConditionRecord);
        }
        this.setChanged(true);
        oCustomConditionRecord.setChanged(true);
    }

    public void moveDataValidationCustomConditionRecord(DataValidationCustomConditionRecord customConditionRecord, int iTo) {
        String sValidationType = customConditionRecord.getConditionType();
        if (sValidationType.equals(TRUE)) {
            this.m_lCustomTrue.move(customConditionRecord, iTo);
            customConditionRecord.setChanged(true);
        } else if (sValidationType.equals(FALSE)) {
            this.m_lCustomFalse.move(customConditionRecord, iTo);
            customConditionRecord.setChanged(true);
        }
        this.setChanged(true);
    }

    public void removeDataValidationCustomConditionRecord(DataValidationCustomConditionRecord oCustomConditionRecord) {
        if (oCustomConditionRecord == null) {
            return;
        }
        if (oCustomConditionRecord.getConditionType().equals(TRUE)) {
            this.m_lCustomTrue.remove(oCustomConditionRecord);
        } else if (oCustomConditionRecord.getConditionType().equals(FALSE)) {
            this.m_lCustomFalse.remove(oCustomConditionRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDataValidationCustomConditionRecord(DataValidationCustomConditionRecord oCustomConditionRecordBeforeEdit, DataValidationCustomConditionRecord oCustomConditionRecordAfterEdit) {
        String sConditionType = oCustomConditionRecordBeforeEdit.getConditionType();
        this.startCompoundUndoable();
        try {
            ModelList m_lCustomConditionRecords = null;
            if (sConditionType.equals(TRUE)) {
                m_lCustomConditionRecords = this.m_lCustomTrue;
            } else if (sConditionType.equals(FALSE)) {
                m_lCustomConditionRecords = this.m_lCustomFalse;
            }
            int iIndex = m_lCustomConditionRecords.indexOf(oCustomConditionRecordBeforeEdit);
            m_lCustomConditionRecords.remove(iIndex);
            m_lCustomConditionRecords.add(iIndex, oCustomConditionRecordAfterEdit);
        }
        finally {
            this.endCompoundUndoable();
        }
        this.setChanged(true);
        oCustomConditionRecordAfterEdit.setChanged(true);
    }

    public ModelList createCustomTrueList() {
        return new ModelList(this, new String[]{CUSTOM_CONDITION_TRUE_ADDED, CUSTOM_CONDITION_TRUE_REMOVED, CUSTOM_CONDITION_TRUE_MOVED}, 0, DataValidationCustomConditionRecord.class);
    }

    public ModelList createCustomFalseList() {
        return new ModelList(this, new String[]{CUSTOM_CONDITION_FALSE_ADDED, CUSTOM_CONDITION_FALSE_REMOVED, CUSTOM_CONDITION_FALSE_MOVED}, 0, DataValidationCustomConditionRecord.class);
    }

    public int indexOfDataValidationCustomConditionRecord(DataValidationCustomConditionRecord oCustomCondition) {
        int index = -1;
        if (oCustomCondition.getConditionType().equals(TRUE)) {
            index = this.m_lCustomTrue.indexOf(oCustomCondition);
            if (index == -1 || index > this.m_lCustomTrue.size()) {
                index = this.m_lCustomTrue.size();
            }
        } else if (oCustomCondition.getConditionType().equals(FALSE) && ((index = this.m_lCustomFalse.indexOf(oCustomCondition)) == -1 || index > this.m_lCustomFalse.size())) {
            index = this.m_lCustomFalse.size();
        }
        return index;
    }

    public DataValidationTransformModel getDataValidationTransformModel() {
        return this.m_dvTransformModel;
    }

    public void setDataValidationTransformModel(DataValidationTransformModel transformModel) {
        this.m_dvTransformModel = transformModel;
    }

    public boolean isRemoveThisRecord() {
        return this.bThisRecordChangedSincePreviousSave;
    }

    public void setRemoveThisRecord(boolean removeThisRecord) {
        if (removeThisRecord) {
            this.setRecordChangedAtLoadTime(true);
        }
        this.bThisRecordChangedSincePreviousSave = removeThisRecord;
    }

    public boolean isRecordChangedAtLoadTime() {
        return this.m_bRecordChangedAtLoadTime;
    }

    public void setRecordChangedAtLoadTime(boolean recordChangedAtLoadTime) {
        this.m_bRecordChangedAtLoadTime = recordChangedAtLoadTime;
    }

    public DataValidationRecord createCopyOfDataValidationRecord() {
        DataValidationRecord copyOfDVR = null;
        copyOfDVR = new DataValidationRecord(this.getID(), this.getDataValidationTransformModel(), this.getValidationType());
        copyOfDVR.setPropertySetTrue_ID(this.getPropertySetTrue_ID());
        copyOfDVR.setPropertySetTrue_Name(this.getPropertySetTrue_Name());
        copyOfDVR.setPropertySetTrue_Role(this.getPropertySetTrue_Role());
        copyOfDVR.setPropertySetFalse_ID(this.getPropertySetFalse_ID());
        copyOfDVR.setPropertySetFalse_Name(this.getPropertySetFalse_Name());
        copyOfDVR.setPropertySetFalse_Role(this.getPropertySetFalse_Role());
        copyOfDVR.setPropertyType_ID(this.getPropertyType_ID());
        copyOfDVR.setPropertyTrue_PS1_ID(this.getPropertyTrue_PS1_ID());
        copyOfDVR.setPropertyTrue_PS1_Name(this.getPropertyTrue_PS1_Name());
        copyOfDVR.setPropertyTrue_PS1_DefVal(this.getPropertyTrue_PS1_DefVal());
        copyOfDVR.setPropertyFalse_PS1_ID(this.getPropertyFalse_PS1_ID());
        copyOfDVR.setPropertyFalse_PS1_Name(this.getPropertyFalse_PS1_Name());
        copyOfDVR.setPropertyFalse_PS1_DefVal(this.getPropertyFalse_PS1_DefVal());
        copyOfDVR.setPropertyException_ID(this.getPropertyException_ID());
        copyOfDVR.set_PropertyExceptionTrue_Name(this.get_PropertyExceptionTrue_Name());
        copyOfDVR.set_PropertyExceptionTrue_DefVal(this.get_PropertyExceptionTrue_DefVal());
        copyOfDVR.setFeatureMap1_ID(this.getFeatureMap1_ID());
        copyOfDVR.setFeatureMap1_Name(this.getFeatureMap1_Name());
        copyOfDVR.setFeatureMap1_Role(this.getFeatureMap1_Role());
        copyOfDVR.setColumn_FM1(this.getColumn_FM1(), this.getDataValidationTransformModel());
        copyOfDVR.setColumnList_FM1(this.getColumnList_FM1());
        copyOfDVR.setPropertyTablesToCheck_ID(this.getPropertyTablesToCheck_ID());
        copyOfDVR.setPropertyTablesToCheck_Name(this.getPropertyTablesToCheck_Name());
        copyOfDVR.setPropertyTablesToCheck_Role(this.getPropertyTablesToCheck_Role());
        copyOfDVR.setPropertyTablesToCheck_MetaValue(this.getPropertyTablesToCheck_MetaValue());
        copyOfDVR.setProperty_FM1_ID(this.getProperty_FM1_ID());
        copyOfDVR.setProperty_FM1_Name(this.getProperty_FM1_Name());
        copyOfDVR.setProperty_FM1_DefVal(this.getProperty_FM1_DefVal());
        copyOfDVR.setTextStore_FM1_ID(this.getTextStore_FM1_ID());
        copyOfDVR.setTextStore_FM1_Name(this.getTextStore_FM1_Name());
        copyOfDVR.setTextStore_FM1_StoredText(this.getTextStore_FM1_StoredText());
        copyOfDVR.setFeatureMap2_EV1_ID(this.getFeatureMap2_EV1_ID());
        copyOfDVR.setFeatureMap2_EV1_TransformRole(this.getFeatureMap2_EV1_TransformRole());
        copyOfDVR.setLookupColumn_FM2(this.getLookupColumn_FM2(), this.getDataValidationTransformModel());
        copyOfDVR.setAction(this.getAction());
        copyOfDVR.setExpression(this.getExpression());
        copyOfDVR.setCustomAction(this.getCustomAction());
        copyOfDVR.setExceptionFlag(this.isExceptionFlag());
        copyOfDVR.setTransformation_EV1_ID(this.getTransformation_EV1_ID());
        copyOfDVR.setTransformation_EV1_Name(this.getTransformation_EV1_Name());
        copyOfDVR.setTransformation_EV1_TransformRole(this.getTransformation_EV1_TransformRole());
        copyOfDVR.set_Property_TrueExceptionChkBox_ID(this.get_Property_TrueExceptionChkBox_ID());
        copyOfDVR.set_Property_TrueExceptionChkBox_Name(this.get_Property_TrueExceptionChkBox_Name());
        copyOfDVR.set_Property_TrueExceptionChkBox_Role(this.get_Property_TrueExceptionChkBox_Role());
        copyOfDVR.set_Property_TrueExceptionChkBox_DefVal(this.get_Property_TrueExceptionChkBox_DefVal());
        copyOfDVR.set_Property_FalseExceptionChkBox_ID(this.get_Property_FalseExceptionChkBox_ID());
        copyOfDVR.set_Property_FalseExceptionChkBox_Name(this.get_Property_FalseExceptionChkBox_Name());
        copyOfDVR.set_Property_FalseExceptionChkBox_Role(this.get_Property_FalseExceptionChkBox_Role());
        copyOfDVR.set_Property_FalseExceptionChkBox_DefVal(this.get_Property_FalseExceptionChkBox_DefVal());
        copyOfDVR.setEvent_Name(this.getEvent_Name());
        if (this.getValidationType().equals("Invalid")) {
            copyOfDVR.setPropertyTrue_PS1_DefVal(this.getPropertyTrue_PS1_DefVal());
            copyOfDVR.setColumn_FM1(this.getColumn_FM1(), this.getDataValidationTransformModel());
            copyOfDVR.setLookupColumn_FM2(this.getLookupColumn_FM2(), this.getDataValidationTransformModel());
            copyOfDVR.createProperty_FM1_ID();
            copyOfDVR.setProperty_FM1_Name(BLANKS);
            copyOfDVR.setProperty_FM1_DefVal(this.getProperty_FM1_DefVal());
            copyOfDVR.setAction(this.getAction());
            copyOfDVR.setExpression(this.getExpression());
            copyOfDVR.setAction(this.getAction());
        } else if (this.getValidationType().equals("Missing")) {
            copyOfDVR.setColumn_FM1(this.getColumn_FM1(), this.getDataValidationTransformModel());
            copyOfDVR.setAction(this.getAction());
            copyOfDVR.setExpression(this.getExpression());
        } else if (this.getValidationType().equals("Duplicate")) {
            ArrayList list = this.getColumnList_FM1();
            ArrayList copyOfList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                copyOfList.add(list.get(i));
            }
            copyOfDVR.setColumnList_FM1(copyOfList);
            copyOfDVR.setPropertyTablesToCheck_DisplayValue(this.getPropertyTablesToCheck_DisplayValue());
            copyOfDVR.setAction(this.getAction());
        } else if (this.getValidationType().equals("Custom")) {
            copyOfDVR.setExpression(this.getExpression());
            copyOfDVR.set_Property_FalseExceptionChkBox_DefVal(this.get_Property_FalseExceptionChkBox_DefVal());
            copyOfDVR.set_Property_TrueExceptionChkBox_DefVal(this.get_Property_TrueExceptionChkBox_DefVal());
            copyOfDVR.setPropertyFalse_PS1_DefVal(this.getPropertyFalse_PS1_DefVal());
            copyOfDVR.setPropertyTrue_PS1_DefVal(this.getPropertyTrue_PS1_DefVal());
            copyOfDVR.createCustomTrueList();
            ModelList lCustomTrue = this.getCustomTrueTypeRecords();
            for (int i = 0; i < lCustomTrue.size(); ++i) {
                copyOfDVR.addDataValidationCustomConditionRecord(((DataValidationCustomConditionRecord)lCustomTrue.get(i)).createCopyOfDataValidationCustomConditionRecord(copyOfDVR));
            }
            copyOfDVR.createCustomFalseList();
            ModelList lCustomFalse = this.getCustomFalseTypeRecords();
            for (int i = 0; i < lCustomFalse.size(); ++i) {
                copyOfDVR.addDataValidationCustomConditionRecord(((DataValidationCustomConditionRecord)lCustomFalse.get(i)).createCopyOfDataValidationCustomConditionRecord(copyOfDVR));
            }
        } else {
            throw new UnsupportedOperationException("Invalid type on data validation record :" + this.getValidationType());
        }
        return copyOfDVR;
    }

    static {
        EXPRESSION_INT = 0;
        TRANSLATION_INT = 1;
    }
}

