/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.cas;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.CASType;
import com.sas.etl.models.job.transforms.DataTransferTransformModel;
import com.sas.etl.models.job.transforms.cas.RB;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CASTransferTransformModel
extends DataTransferTransformModel {
    public static final String TRANSFORMATION_CLASS = "com.sas.etl.models.job.transforms.cas.CASTransferTransformModel";
    public static final String TRANSFORMATION_ROLE = "com.sas.etl.models.job.transforms.cas.CASTransferTransformModel";
    private static final String ARM_DISPLAY_NAME = "CASTransferTransformModel";

    public CASTransferTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("CASTransferTransformModel.Name.txt");
    }

    @Override
    public boolean isComplete() {
        boolean complete = super.isComplete();
        if (complete) {
            complete = this.getAreAnySourcesCASTables() || this.getAreAnyTargetsCASTables();
        }
        return complete;
    }

    public boolean getAreAnySourcesCASTables() {
        ITable[] tables;
        for (ITable table : tables = this.getSourceTables()) {
            if (table instanceof IPhysicalTable) {
                if (!(((IPhysicalTable)table).getDBMSType() instanceof CASType)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public List getReasonsIncomplete() {
        List lst = super.getReasonsIncomplete();
        if (!this.getAreAnySourcesCASTables() && !this.getAreAnyTargetsCASTables()) {
            lst.add(RB.getStringResource("CASTransferTransformModel.NoCASTables.txt"));
        }
        return lst;
    }

    public boolean getAreAnyTargetsCASTables() {
        ITable[] tables;
        for (ITable table : tables = this.getTargetTables()) {
            if (table instanceof IPhysicalTable) {
                if (!(((IPhysicalTable)table).getDBMSType() instanceof CASType)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("CASTransferTransformModel.Name.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.etl.models.job.transforms.cas.CASTransferTransformModel";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.etl.models.job.transforms.cas.CASTransferTransformModel";
    }

    public static String getTransformTypeID() {
        return "com.sas.etl.models.job.transforms.cas.CASTransferTransformModel";
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new CASTransformPromptModel(this);
    }

    protected class CASTransformPromptModel
    extends DataTransferTransformModel.DataTransferPromptModel {
        public CASTransformPromptModel(CASTransferTransformModel model) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model);
        }

        @Override
        protected String getTemplateName() {
            return "res/Options_CASTransfer_Template.xml";
        }
    }
}

