/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class XMLWriterTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.xmlwriter.XMLWriter";
    private static final String TRANSFORMATION_ROLE = "XMLWriter:HIDE";
    private static final String ARM_DISPLAY_NAME = "XMLWriter";
    public static final String ADDITIONAL_XML_OPTIONS_CHANGED = "XMLWriterTransformModel:AdditionalXMLOptionsChanged";
    public static final String PROPERTY_NAME_ADDITIONAL_XML_OPTIONS = "AdditionalOptions";
    private String m_sAdditionalXMLOptions;

    public XMLWriterTransformModel(String sID, IModel model) {
        super(sID, model);
        this.createConditionActionSetTemplates();
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        super.loadFromOMR(omr);
        String sOption = this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_ADDITIONAL_XML_OPTIONS, "", 2);
        if (sOption == null) {
            this.setAdditionalXMLOptions("");
        } else {
            this.setAdditionalXMLOptions(sOption);
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_ADDITIONAL_XML_OPTIONS, PROPERTY_NAME_ADDITIONAL_XML_OPTIONS, "OPTIONS", this.getAdditionalXMLOptions(), 12, 2);
        this.setChanged(false);
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("XMLWriterTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("XMLWriterTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.loadConditionActionSetTemplatesFromOMR();
    }

    public String getAdditionalXMLOptions() {
        if (this.m_sAdditionalXMLOptions == null) {
            this.m_sAdditionalXMLOptions = "";
        }
        return this.m_sAdditionalXMLOptions;
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
    }

    public void setAdditionalXMLOptions(String sOptions) {
        if (sOptions == null) {
            throw new IllegalArgumentException("null is not allowed for additional file options");
        }
        if (this.m_sAdditionalXMLOptions.equals(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAdditionalXMLOptionsUndoable(this.m_sAdditionalXMLOptions, sOptions));
        }
        this.m_sAdditionalXMLOptions = sOptions;
        this.fireModelChangedEvent(ADDITIONAL_XML_OPTIONS_CHANGED, this.m_sAdditionalXMLOptions);
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public IWorkTable addNewWorkTable() {
        throw new UnsupportedOperationException("XML writer does not support work tables");
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        codeSegment.addSourceCode("%global etls_lastTable;\n").addSourceCode("%let etls_lastTable = &SYSLAST; \n\n");
        codeSegment.addSectionComment(RB.getStringResource("SPDSTableLoaderTransformModel.DefineMacro.msg.notrans")).addSourceCode("\n");
        codeSegment.addSourceCode("%macro etls_xmlwriter;\n\n").indent();
        ITransformTableOptions sourceTableOptions = this.getTableOptionObject(source, true);
        String sourceOptionsString = sourceTableOptions.getTableOptions(codeSegment.getCurrentServer());
        if (sourceOptionsString.length() > 0) {
            codeSegment.addSourceCode("%let etls_tableOptions = %nrquote(").addSourceCode(sourceOptionsString).addSourceCode(");\n\n");
        } else {
            codeSegment.addSourceCode("%let etls_tableOptions = ;\n\n");
        }
        IDataObject[] sources = this.getDataSources();
        int numSources = sources.length;
        if (numSources > 1) {
            throw new CodegenException(RB.getStringResource("DBMSSTORE.MultipleInputs.msg.txt"), (IObject)this);
        }
        boolean isMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, target);
        String mappingStepOutputName = "";
        if (isMappingNeeded) {
            mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
            this.getOrdinaryMappingCode(codeSegment, source, target, mappingStepOutputName, "&etls_lastTable", "&etls_tableOptions", null, true, true, false);
            codeSegment.addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            codeSegment.addSourceCode("%let etls_tableOptions = ; \n\n");
        }
        ITransformTableOptions targetTableOptionsObject = this.getTableOptionObject(target, false);
        StringBuffer targetTableOptionsStringBuffer = new StringBuffer(targetTableOptionsObject.getTableOptions(codeSegment.getCurrentServer()));
        targetTableOptionsStringBuffer.append(" ");
        targetTableOptionsStringBuffer.append(this.getAdditionalXMLOptions());
        String tableName = target.getFullNameQuotedAsNeeded(codeSegment);
        codeSegment.addSourceCode("data ").addSourceCode(tableName).addSourceCode("( ").addSourceCode(targetTableOptionsStringBuffer.toString()).addSourceCode(" ) ");
        codeSegment.addSourceCode(";\n");
        codeSegment.indent().addSourceCode("set ").addSourceCode("&etls_lastTable.(&etls_tableOptions)").addSourceCode(";\n");
        codeSegment.unIndent().addSourceCode("run; \n\n");
        if (isMappingNeeded && !target.isView()) {
            codeSegment.genTableDelete(mappingStepOutputName);
        }
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.genJobStatusUpdateAfter(target);
        }
        codeSegment.unIndent().addSourceCode("%mend etls_xmlwriter;\n").addSourceCode("%etls_xmlwriter;\n\n");
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CSUCCESSFUL", this, target);
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CWARNINGS", this, target);
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CERRORS", this, target);
        return codeSegment;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cXMLWriterOptionModel();
    }

    private class SetAdditionalXMLOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOptions;
        private String m_sNewOptions;

        public SetAdditionalXMLOptionsUndoable(String oldOptions, String newOptions) {
            this.m_sOldOptions = oldOptions;
            this.m_sNewOptions = newOptions;
        }

        @Override
        public void undo() {
            super.undo();
            XMLWriterTransformModel.this.setAdditionalXMLOptions(this.m_sOldOptions);
        }

        @Override
        public void redo() {
            super.redo();
            XMLWriterTransformModel.this.setAdditionalXMLOptions(this.m_sNewOptions);
        }
    }

    protected class cXMLWriterOptionModel
    extends BaseDataTransformPromptModel
    implements IPromptModel {
        public cXMLWriterOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(XMLWriterTransformModel.this.getModel(), XMLWriterTransformModel.this);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cXMLWriterOptionModel.class.getResource("res/Options_XMLWriter_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            XMLWriterTransformModel transform = (XMLWriterTransformModel)this.getOwner();
            this.setOptionValue(XMLWriterTransformModel.PROPERTY_NAME_ADDITIONAL_XML_OPTIONS, (Object)transform.getAdditionalXMLOptions());
        }

        @Override
        protected IModelListener createModelListener() {
            return new cXMLWriterModelChangeListener();
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new XMLWriterTransformValueChangedListener((XMLWriterTransformModel)this.getOwner(), this);
        }

        private class cXMLWriterModelChangeListener
        extends BaseDataTransformModelListener {
            public cXMLWriterModelChangeListener() {
                super(cXMLWriterOptionModel.this.getOwner(), cXMLWriterOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(XMLWriterTransformModel.ADDITIONAL_XML_OPTIONS_CHANGED)) {
                        cXMLWriterOptionModel.this.setOptionValue(XMLWriterTransformModel.PROPERTY_NAME_ADDITIONAL_XML_OPTIONS, (Object)XMLWriterTransformModel.this.getAdditionalXMLOptions());
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class XMLWriterTransformValueChangedListener
        extends BaseDataTransformValueChangedListener {
            public XMLWriterTransformValueChangedListener(XMLWriterTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals(XMLWriterTransformModel.PROPERTY_NAME_ADDITIONAL_XML_OPTIONS)) {
                        XMLWriterTransformModel.this.setAdditionalXMLOptions(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }
}

