/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ILoaderTransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractLoaderTransform;
import com.sas.etl.models.job.impl.BaseLoaderModelListener;
import com.sas.etl.models.job.impl.BaseLoaderPromptModel;
import com.sas.etl.models.job.impl.BaseLoaderTransformValueChangedListener;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.UsageVersion;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TableLoaderTransformModel
extends AbstractLoaderTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.loader.TableLoader";
    private static final String TRANSFORMATION_ROLE = "Loader:HIDE";
    private static final String ARM_DISPLAY_NAME = "Loader";
    private boolean m_bInTableLoaderAdd = false;
    private boolean m_bInTableLoaderRemove = false;
    protected String m_sSaveDBMSType = "";
    private static final UsageVersion LOADER_MODEL_VERSION = new UsageVersion(2, 1);
    public static final String CONSTRAINT_AFTER_CHANGED = "TableLoaderTransformModel:ConstraintAfterChanged";
    public static final String CONSTRAINT_BEFORE_CHANGED = "TableLoaderTransformModel:ConstraintBeforeChanged";
    public static final String INDEX_AFTER_CHANGED = "TableLoaderTransformModel:IndexAfterChanged";
    public static final String INDEX_BEFORE_CHANGED = "TableLoaderTransformModel:IndexBeforeChanged";
    public static final String LOAD_STYLE_CHANGED = "TableLoaderTransformModel:LoadStyleChanged";
    public static final String REPLACETYPE_CHANGED = "TableLoaderTransformModel:ReplaceTypeChanged";
    public static final String MATCHINGROWS_CHANGED = "TableLoaderTransformModel:MatchingRowsChanged";
    public static final String NEWROWS_CHANGED = "TableLoaderTransformModel:NewRowsChanged";
    public static final String NOMISSINGCHECK_CHANGED = "TableLoaderTransformModel:NoMissingCheckChanged";
    public static final String UNMAPPEDEQMISSINGINUPDATE_CHANGED = "TableLoaderTransformModel:UnmappedMissingEQInUpdateChanged";
    public static final String MODIFYUPDATEFAILACTION_CHANGED = "TableLoaderTransformModel:ModifyUpdateFailAction";
    public static final String MATCHCOLUMNS_CHANGED = "TableLoaderTransformModel:MatchColumnsChanged";
    public static final String MATCH_COLUMN_ADDED = "TableLoaderTransformModel:MatchColumnAdded";
    public static final String MATCH_COLUMN_REMOVED = "TableLoaderTransformModel:MatchColumnRemoved";
    public static final String MATCH_COLUMN_MOVED = "TableLoaderTransformModel:MatchColumnMoved";
    public static final String DATA_TABLE_OPTIONS_CHANGED = "TableLoaderTransformModel:DataTableOptionsChanged";
    public static final String MODIFYUSINGINDEX_CHANGED = "TableLoaderTransformModel:ModifyUsingIndexChanged";
    public static final String INDEXUNIQUEVALUE_CHANGED = "TableLoaderTransformModel:IndexUniqueValueChanged";
    public static final String LOADSTYLE_UPDATE = "Update";
    public static final String LOADSTYLE_APPEND_EXISTING = "AppendToExisting";
    public static final String LOADSTYLE_REPLACE = "Replace";
    public static final String MODIFYBYCOLUMN = "ModifyByColumn";
    public static final String MODIFYUSINGINDEX = "ModifyUsingIndex";
    private static final String MODIFY_UPDATE_CONDITION = "_iorc_ eq %sysrc(_SOK)";
    private static final String MODIFY_UPDATE_FAIL_CONDITION = "_iorc_ ne %sysrc(_SOK)";
    private static final String MODIFY_NEW_CONDITION = "_iorc_ in( %sysrc(_DSENMR),%sysrc(_DSENOM),%sysrc(_DSEMTR))";
    protected static final String MATCHING_ROWS_UPSERT = "Upsert";
    public static final String SKIP = "Skip";
    public static final String MATCHING_ROWS_SQLSET = "SQLSet";
    public static final String NEW_ROWS_INSERT_SQL = "InsertSQL";
    public static final String NEW_ROWS_APPEND_PROC = "AppendProc";
    public static final String NEW_ROWS_UPSERT = "Upsert";
    protected static final String NEWROWSTABLE = "etls_newrecords";
    public static final String CI_ACTION_ASIS = "ASIS";
    public static final String CI_ACTION_ON = "ON";
    public static final String CI_ACTION_OFF = "OFF";
    public static final String CI_ACTION_INITIAL_LOAD = "INIT";
    public static final String CI_ACTION_RECREATE_ASIS = "RECREATEASIS";
    public static final String CI_ACTION_NEEDED_NONE = "NONE";
    public static final String CI_ACTION_NEEDED_DROP = "DROP";
    public static final String CI_ACTION_NEEDED_CREATE = "CREATE";
    private static final String MODIFY_UPDATE_FAIL_ACTION_NONE = "NONE";
    private static final String MODIFY_UPDATE_FAIL_ACTION_WARNING = "WARNING";
    private static final String MODIFY_UPDATE_FAIL_ACTION_ERROR = "ERROR";
    private static final String MODIFY_UPDATE_FAIL_ACTION_CUSTOM = "CUSTOM";
    private static final String MODIFY_UPDATE_FAIL_ACTION_DEFAULT = "NONE";
    private static final String MODIFY_UPDATE_FAIL_WARNING_RC = "4";
    private static final String STOP_ON_IORC_MACROVAR = "etls_StopOnIORC";
    private static final String GLOBAL = "GLOBAL";
    private static final String PROPERTY_SET_NAME_ADDITIONAL_ACTION = "AdditionalActions";
    private static final String PROPERTY_NAME_INDEX_BEFORE = "IndexActionBefore";
    private static final String PROPERTY_NAME_INDEX_AFTER = "IndexActionAfter";
    private static final String PROPERTY_NAME_CONSTRAINT_BEFORE = "ConstraintActionBefore";
    private static final String PROPERTY_NAME_CONSTRAINT_AFTER = "ConstraintActionAfter";
    protected static final String PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE = "UnmappedEqMissingInUpdate";
    private static final String PROPERTY_SET_NAME_ROW_ACTIONS = "RowActions";
    private static final String PROPERTY_NAME_MATCHING_ROWS = "MatchingRows";
    private static final String PROPERTY_NAME_NEW_ROWS = "NewRows";
    private static final String PROPERTY_NAME_NOMISSINGCHECK = "nomissingcheck";
    private static final String PROPERTY_NAME_MATCH_COLUMNS = "MatchColumns";
    private static final String PROPERTY_NAME_UNIQUE = "unique";
    private static final String PROPERTY_NAME_MODIFY_INDEX = "ModifyIndex";
    private static final String DATATABLE_OPTIONS = "DataTableOptions";
    private static final String PROPERTY_SET_NAME_LOAD_STYLE = "LoadStyle";
    private static final String PROPERTY_NAME_STYLE = "Style";
    private static final String PROPERTY_NAME_REPLACE_TYPE = "ReplaceType";
    protected static final String MODIFY = "Modify";
    private String m_sDefaultConstraintBefore = "INIT";
    private String m_sDefaultConstraintAfter = "ASIS";
    protected String m_sDefaultIndexBefore = "INIT";
    private String m_sDefaultIndexAfter = "ASIS";
    private String m_sDefaultLoadStyle = "Replace";
    private String m_sDefaultMatchingRows = "SQLSet";
    private String m_sDefaultNewRows = "AppendProc";
    private boolean m_bDefaultNoMissingCheck = true;
    private boolean m_bDefaultIndexUnique = false;
    private String m_sDefaultReplaceType = "EntireTable";
    private boolean m_bDefaultUnmappedEQMissingInUpdate = false;
    private String m_sDefaultModifyUpdateFailAction = "NONE";
    private String m_sDataTableOptions;
    private String m_sConstraintBefore;
    private String m_sConstraintAfter;
    private String m_sIndexBefore;
    private String m_sIndexAfter;
    private String m_sLoadStyle;
    private String m_sMatchingRows;
    private String m_sNewRows;
    private boolean m_bNoMissingCheck;
    private String m_sReplaceType;
    private boolean m_bUnmappedEqMissingInUpdate;
    private String m_sModifyUpdateFailAction;
    private List m_lMatchColumns;
    private IIndex m_IIndexModifyIndex;
    private boolean m_bIndexUnique;

    public TableLoaderTransformModel(String sID, IModel model) {
        super(sID, model);
        super.setCollectSourceTableRowCounts(false);
        super.setCollectTargetTableRowCounts(true);
        ModelLogger.getDefaultLogger().debug((Object)"here is the loader");
        this.createConditionActionSetTemplates();
        this.m_sLoadStyle = this.m_sDefaultLoadStyle;
        this.m_sReplaceType = this.m_sDefaultReplaceType;
        this.m_sMatchingRows = this.m_sDefaultMatchingRows;
        this.m_sNewRows = this.m_sDefaultNewRows;
        this.m_sConstraintAfter = CI_ACTION_ASIS;
        this.m_sConstraintBefore = CI_ACTION_ASIS;
        this.m_sIndexAfter = CI_ACTION_ASIS;
        this.m_sIndexBefore = CI_ACTION_ASIS;
        this.m_bNoMissingCheck = this.m_bDefaultNoMissingCheck;
        this.m_bUnmappedEqMissingInUpdate = this.m_bDefaultUnmappedEQMissingInUpdate;
        this.m_sModifyUpdateFailAction = this.m_sDefaultModifyUpdateFailAction;
        this.m_lMatchColumns = new ModelList(this, new String[]{MATCH_COLUMN_ADDED, MATCH_COLUMN_REMOVED, MATCH_COLUMN_MOVED}, 0, IColumn.class);
        this.m_IIndexModifyIndex = null;
        this.m_bIndexUnique = this.m_bDefaultIndexUnique;
        this.m_sDataTableOptions = "";
    }

    @Override
    public UsageVersion getModelVersion() {
        return LOADER_MODEL_VERSION;
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.loadConditionActionSetTemplatesFromOMR();
    }

    @Override
    public void notify(NotifyEvent ev) {
        IPhysicalTable target = null;
        if (this.getDataTargetsCount() == 1) {
            target = (IPhysicalTable)this.getDataTargets()[0];
        }
        if (target != null) {
            if (ev.getType() == 0 && ev.getSource() == this.m_IIndexModifyIndex) {
                this.setModifyIndex(null);
            }
            if (ev.getType() == 1) {
                ModelEvent mdEv = ev.getModelEvent();
                if (mdEv != null && mdEv.getModelObject() == target) {
                    IColumn column;
                    String sType = mdEv.getType();
                    if (sType.equalsIgnoreCase("PhysicalTable:IndexAdded")) {
                        if (target.getIndexesList().size() == 1) {
                            this.resetIndexBeforeToDefault();
                        }
                    } else if (sType.equalsIgnoreCase("PhysicalTable:KeyAdded") || sType.equalsIgnoreCase("PhysicalTable:ForeignKeyAdded")) {
                        if (target.getDBMSType().hasSingleConstraint(target)) {
                            this.resetConstraintBeforeToDefault();
                        }
                    } else if (sType.equalsIgnoreCase("PhysicalTable:IndexRemoved")) {
                        if (!target.hasIndexes()) {
                            if (!this.getValidValuesMatchingRows().contains(this.m_sMatchingRows)) {
                                this.setMatchingRows(this.m_sDefaultMatchingRows);
                            }
                            this.resetIndexBeforeToDefault();
                        }
                    } else if (sType.equalsIgnoreCase("PhysicalTable:KeyRemoved") || sType.equalsIgnoreCase("PhysicalTable:ForeignKeyRemoved")) {
                        if (!target.hasConstraints()) {
                            this.resetConstraintBeforeToDefault();
                        }
                    } else if (sType.equalsIgnoreCase("PhysicalTable:LibraryChanged")) {
                        if (this.isDBMSTypeChanged()) {
                            this.resetModelDefaults();
                        }
                    } else if (sType.equalsIgnoreCase("Table:ColumnRemoved") && this.m_lMatchColumns.contains(column = (IColumn)mdEv.getData())) {
                        this.m_lMatchColumns.remove(column);
                    }
                } else if (mdEv != null && mdEv.getModelObject() instanceof IColumn && Arrays.asList(target.getColumns()).contains(mdEv.getModelObject()) && mdEv.getType().equalsIgnoreCase("Column:NullableChanged") && (target.getDBMSType().hasSingleConstraint(target) || !target.hasConstraints())) {
                    this.resetConstraintBeforeToDefault();
                }
            }
        }
        super.notify(ev);
    }

    protected boolean isDBMSTypeChanged() {
        IPhysicalTable target;
        String sDBMSType = "";
        if (this.getDataTargetsCount() > 0 && (target = (IPhysicalTable)this.getDataTargets()[0]) != null) {
            sDBMSType = target.getDBMSType().getClass().getName();
        }
        return !sDBMSType.equals(this.m_sSaveDBMSType);
    }

    protected void saveDBMSTypeForChangeCheck() {
        IPhysicalTable target;
        String sDBMSType = "";
        if (this.getDataTargetsCount() > 0 && (target = (IPhysicalTable)this.getDataTargets()[0]) != null) {
            sDBMSType = target.getDBMSType().getClass().getName();
        }
        this.m_sSaveDBMSType = sDBMSType;
    }

    protected IIndex getDefaultIndex() {
        IPhysicalTable dataTarget = this.getTargetTable();
        return dataTarget != null ? (dataTarget.getIndexes().length > 0 ? dataTarget.getIndexes()[0] : null) : null;
    }

    public void resetModelDefaults() {
        this.startCompoundUndoable();
        try {
            IPhysicalTable dataTarget = this.getTargetTable();
            this.setDefaultReplaceType(dataTarget != null ? dataTarget.getDBMSType().getPreferredReplaceType() : "EntireTable");
            this.setModifyIndex(this.getDefaultIndex());
            this.setLoadStyleImpl(this.getDefaultLoadStyle());
            this.resetReplaceTypeToDefault();
            this.setMatchingRowsImpl(this.getDefaultMatchingRows());
            this.resetNewRowsToDefault();
            this.resetConstraintBeforeToDefault();
            this.resetIndexBeforeToDefault();
            this.setNoMissingCheck(this.getDefaultNoMissingCheck());
            this.setUnmappedEqMissingInUpdate(this.getDefaultUnmappedEqMissingInUpdate());
        }
        finally {
            this.endCompoundUndoable();
        }
        this.saveDBMSTypeForChangeCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            String sConstraintAfter = "";
            String sConstraintBefore = "";
            String sIndexAfter = "";
            String sIndexBefore = "";
            String sLoadStyle = "";
            String sMatchingRows = "";
            String sNewRows = "";
            String sReplaceType = "";
            String sDataTableOptions = "";
            boolean bNoMissingCheck = false;
            boolean bUnmappedEqMissingInUpdate = false;
            String sModifyUpdateFailAction = "NONE";
            boolean bIndexUnique = false;
            ArrayList lMatchColumns = new ArrayList();
            ArrayList lIndexColumns = new ArrayList();
            boolean bOldConstraintEnabled = false;
            boolean bOldIndexEnabled = false;
            IDBMSType oldType = ((IPhysicalTable)oldTable).getDBMSType();
            IDBMSType newType = ((IPhysicalTable)newTable).getDBMSType();
            if (oldType == newType) {
                sConstraintAfter = this.m_sConstraintAfter;
                sConstraintBefore = this.m_sConstraintBefore;
                sIndexAfter = this.m_sIndexAfter;
                sIndexBefore = this.m_sIndexBefore;
                sLoadStyle = this.m_sLoadStyle;
                sMatchingRows = this.m_sMatchingRows;
                sNewRows = this.m_sNewRows;
                sReplaceType = this.m_sReplaceType;
                sDataTableOptions = this.m_sDataTableOptions;
                bNoMissingCheck = this.m_bNoMissingCheck;
                bUnmappedEqMissingInUpdate = this.m_bUnmappedEqMissingInUpdate;
                sModifyUpdateFailAction = this.m_sModifyUpdateFailAction;
                bIndexUnique = this.m_bIndexUnique;
                lMatchColumns.addAll(this.m_lMatchColumns);
                if (this.m_IIndexModifyIndex != null) {
                    lIndexColumns.addAll(this.m_IIndexModifyIndex.getColumnsList());
                }
                bOldConstraintEnabled = this.isConstraintEnabled();
                bOldIndexEnabled = this.isIndexEnabled();
            } else {
                ModelLogger.getDefaultLogger().info((Object)"The table being replaced has a different DBMS type than the old table, all attributes will reset back to the default.");
            }
            super.replaceTargetTable(oldTable, newTable, columnsMap, portIndexes);
            if (oldType == newType) {
                this.setLoadStyleImpl(sLoadStyle);
                this.setReplaceTypeImpl(sReplaceType);
                this.setMatchingRowsImpl(sMatchingRows);
                this.setNewRowsImpl(sNewRows);
                this.setConstraintBeforeValueImpl(sConstraintBefore);
                this.setConstraintAfterValueImpl(sConstraintAfter);
                this.setIndexBeforeValueImpl(sIndexBefore);
                this.setIndexAfterValueImpl(sIndexAfter);
                this.setNoMissingCheck(bNoMissingCheck);
                this.setUnmappedEqMissingInUpdate(bUnmappedEqMissingInUpdate);
                this.setIndexUniqueValue(bIndexUnique);
                this.setDataTableOptions(sDataTableOptions);
                if (bOldConstraintEnabled != this.isConstraintEnabled()) {
                    this.resetConstraintBeforeToDefault();
                }
                if (bOldIndexEnabled && !this.isIndexEnabled()) {
                    if (sMatchingRows.equals(MODIFYUSINGINDEX)) {
                        this.setMatchingRowsImpl(this.m_sDefaultMatchingRows);
                    }
                    if (sNewRows.equals(MODIFYUSINGINDEX)) {
                        this.resetNewRowsToDefault();
                    }
                }
                if (bOldIndexEnabled != this.isIndexEnabled()) {
                    this.resetIndexBeforeToDefault();
                }
                this.m_lMatchColumns.clear();
                boolean bCaseSenistive = this.isQuotingNeeded() || newTable.isQuoted();
                for (int iMatch = 0; iMatch < lMatchColumns.size(); ++iMatch) {
                    IColumn oldMatchCol = (IColumn)lMatchColumns.get(iMatch);
                    IColumn[] aCols = newTable.getColumns();
                    for (int iCol = 0; iCol < aCols.length; ++iCol) {
                        if (!aCols[iCol].equalsName(oldMatchCol, bCaseSenistive) || aCols[iCol].getType() != oldMatchCol.getType()) continue;
                        this.m_lMatchColumns.add(aCols[iCol]);
                    }
                }
                IIndex[] aIndexes = ((IPhysicalTable)newTable).getIndexes();
                boolean foundIndex = false;
                for (int iIndex = 0; iIndex < aIndexes.length; ++iIndex) {
                    IColumn[] aCols = aIndexes[iIndex].getColumns();
                    if (aCols.length != lIndexColumns.size()) continue;
                    boolean matchFound = true;
                    for (int iCol = 0; iCol < aCols.length; ++iCol) {
                        IColumn oldColumn = (IColumn)lIndexColumns.get(iCol);
                        if (oldColumn.equalsName(aCols[iCol], bCaseSenistive) && oldColumn.getType() == aCols[iCol].getType()) continue;
                        matchFound = false;
                    }
                    if (!matchFound) continue;
                    this.setModifyIndex(aIndexes[iIndex]);
                    foundIndex = true;
                    break;
                }
                if (!foundIndex) {
                    this.setModifyIndex(null);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] iPersistableObjectArray;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        ClassifierMap map = (ClassifierMap)mdoStep.getTransformations().get(0);
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_LOAD_STYLE, PROPERTY_NAME_STYLE, PROPERTY_NAME_STYLE, PROPERTY_NAME_STYLE, this.getLoadStyle(), 2000, 0);
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_LOAD_STYLE, PROPERTY_NAME_REPLACE_TYPE, PROPERTY_NAME_REPLACE_TYPE, PROPERTY_NAME_REPLACE_TYPE, this.getReplaceType(), 2000, 0);
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_MATCHING_ROWS, PROPERTY_NAME_MATCHING_ROWS, PROPERTY_NAME_MATCHING_ROWS, this.getMatchingRows(), 2000, 0);
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_NEW_ROWS, PROPERTY_NAME_NEW_ROWS, PROPERTY_NAME_NEW_ROWS, this.getNewRows(), 2000, 0);
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_UNIQUE, PROPERTY_NAME_UNIQUE, PROPERTY_NAME_UNIQUE, Boolean.toString(this.isIndexUniqueValue()), 2000, 0);
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_NOMISSINGCHECK, PROPERTY_NAME_NOMISSINGCHECK, PROPERTY_NAME_NOMISSINGCHECK, Boolean.toString(this.isNoMissingCheck()), 2000, 0);
        IPersistableObject[] matchingColumns = this.getMatchingColumns();
        this.saveObjectListPropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_MATCH_COLUMNS, PROPERTY_NAME_MATCH_COLUMNS, "", matchingColumns, 2000, 0);
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE, Boolean.toString(this.isUnmappedEqMissingInUpdate()));
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ADDITIONAL_ACTION, PROPERTY_NAME_CONSTRAINT_AFTER, PROPERTY_NAME_CONSTRAINT_AFTER, PROPERTY_NAME_CONSTRAINT_AFTER, this.getConstraintAfterValue(), 2000, 0);
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ADDITIONAL_ACTION, PROPERTY_NAME_CONSTRAINT_BEFORE, PROPERTY_NAME_CONSTRAINT_BEFORE, PROPERTY_NAME_CONSTRAINT_BEFORE, this.getConstraintBeforeValue(), 2000, 0);
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ADDITIONAL_ACTION, PROPERTY_NAME_INDEX_AFTER, PROPERTY_NAME_INDEX_AFTER, PROPERTY_NAME_INDEX_AFTER, this.getIndexAfterValue(), 2000, 0);
        this.savePropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ADDITIONAL_ACTION, PROPERTY_NAME_INDEX_BEFORE, PROPERTY_NAME_INDEX_BEFORE, PROPERTY_NAME_INDEX_BEFORE, this.getIndexBeforeValue(), 2000, 0);
        this.savePropertyToOMR(omr, "OPTIONS", DATATABLE_OPTIONS, DATATABLE_OPTIONS, DATATABLE_OPTIONS, this.getDataTableOptions(), 12, 2);
        IIndex modifyIndex = this.getModifyIndex();
        if (modifyIndex != null) {
            IPersistableObject[] iPersistableObjectArray2 = new IPersistableObject[1];
            iPersistableObjectArray = iPersistableObjectArray2;
            iPersistableObjectArray2[0] = modifyIndex;
        } else {
            iPersistableObjectArray = new IPersistableObject[]{};
        }
        IPersistableObject[] modifyIndexArr = iPersistableObjectArray;
        this.saveObjectListPropertyToOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_MODIFY_INDEX, PROPERTY_NAME_MODIFY_INDEX, "", modifyIndexArr, 2000, 0);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IIndex index;
        int i;
        super.loadFromOMR(omr);
        ClassifierMap map = this.getClassifierMapObject(omr);
        String loadStyle = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_LOAD_STYLE, PROPERTY_NAME_STYLE, this.getDefaultLoadStyle(), 0);
        if (!this.isLoadStyleValid(loadStyle)) {
            loadStyle = this.getDefaultLoadStyle();
        }
        this.setLoadStyle(loadStyle);
        String replaceType = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_LOAD_STYLE, PROPERTY_NAME_REPLACE_TYPE, this.getDefaultReplaceType(), 0);
        if (!this.isReplaceTypeValid(replaceType)) {
            replaceType = this.getDefaultReplaceType();
        }
        this.setReplaceType(replaceType);
        String matchingRows = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_MATCHING_ROWS, this.getDefaultMatchingRows(), 0);
        if (!this.isMatchingRowsValid(matchingRows)) {
            matchingRows = this.getDefaultMatchingRows();
        }
        this.setMatchingRows(matchingRows);
        String newRows = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_NEW_ROWS, this.getDefaultNewRows(), 0);
        if (!this.isNewRowsValid(newRows)) {
            newRows = this.getDefaultNewRows();
        }
        this.setNewRows(newRows);
        String indexUnique = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_UNIQUE, "false", 0);
        this.setIndexUniqueValue("YES".equals(indexUnique) || "true".equals(indexUnique));
        String missingCheck = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_NOMISSINGCHECK, "true", 0);
        this.setNoMissingCheck(PROPERTY_NAME_NOMISSINGCHECK.equals(missingCheck) || "true".equals(missingCheck));
        String constraintBefore = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ADDITIONAL_ACTION, PROPERTY_NAME_CONSTRAINT_BEFORE, this.getDefaultConstraintBefore(), 0);
        if (!this.isConstraintBeforeValid(constraintBefore)) {
            constraintBefore = this.getDefaultConstraintBefore();
        }
        this.setConstraintBeforeValue(constraintBefore);
        String constraintAfter = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ADDITIONAL_ACTION, PROPERTY_NAME_CONSTRAINT_AFTER, this.getDefaultConstraintAfter(), 0);
        if (!this.isConstraintAfterValid(constraintAfter)) {
            constraintAfter = this.getDefaultConstraintAfter();
        }
        this.setConstraintAfterValue(constraintAfter);
        String indexBefore = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ADDITIONAL_ACTION, PROPERTY_NAME_INDEX_BEFORE, this.getDefaultIndexBefore(), 0);
        if (!this.isIndexBeforeValid(indexBefore)) {
            indexBefore = this.getDefaultIndexBefore();
        }
        this.setIndexBeforeValue(indexBefore);
        String indexAfter = this.loadPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ADDITIONAL_ACTION, PROPERTY_NAME_INDEX_AFTER, this.getDefaultConstraintAfter(), 0);
        if (!this.isIndexAfterValid(indexAfter)) {
            indexAfter = this.getDefaultIndexAfter();
        }
        this.setIndexAfterValue(indexAfter);
        this.clearMatchingColumns();
        IPersistableObject[] aMatchCols = this.loadObjectListPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_MATCH_COLUMNS, 0);
        boolean changed = false;
        ArrayList<IColumn> matchColumns = new ArrayList<IColumn>();
        for (i = 0; i < aMatchCols.length; ++i) {
            IColumn column = (IColumn)aMatchCols[i];
            if (!this.isMatchingColumnValid(column)) {
                IColumn matchColumn;
                changed = true;
                IPhysicalTable target = this.getTargetTable();
                IColumn iColumn = matchColumn = target != null ? target.getColumnWithMatchingName(column.getName()) : null;
                if (matchColumn == null) continue;
                matchColumns.add(matchColumn);
                continue;
            }
            matchColumns.add(column);
        }
        aMatchCols = matchColumns.toArray(new IColumn[matchColumns.size()]);
        for (i = 0; i < aMatchCols.length; ++i) {
            this.addMatchingColumn((IColumn)aMatchCols[i]);
        }
        IPersistableObject[] oList = this.loadObjectListPropertyFromOMR(omr, (Root)map, PROPERTY_SET_NAME_ROW_ACTIONS, PROPERTY_NAME_MODIFY_INDEX, 0);
        IIndex iIndex = index = oList.length > 0 ? (IIndex)oList[0] : this.getDefaultIndex();
        if (!this.isModifyIndexValid(index)) {
            changed = true;
            boolean found = false;
            IPhysicalTable target = this.getTargetTable();
            if (target != null) {
                IIndex[] indList = target.getIndexes();
                for (int i2 = 0; i2 < indList.length; ++i2) {
                    if (!indList[i2].getName().equals(index.getName())) continue;
                    index = indList[i2];
                    found = true;
                    break;
                }
            }
            if (!found) {
                index = this.getDefaultIndex();
            }
        }
        this.setModifyIndex(index);
        this.setDataTableOptions(this.loadPropertyFromOMR(omr, "OPTIONS", DATATABLE_OPTIONS, "", 2));
        this.setUnmappedEqMissingInUpdate(Boolean.valueOf(this.loadStringOptionFromOMR(omr, PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE, "false")));
        this.saveDBMSTypeForChangeCheck();
        this.setChanged(changed);
    }

    @Override
    protected void saveWorkTablesToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cLoaderOptionModel(this.getModel(), this);
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETDATAMODIFIED");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLECREATED");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLEDROPPED");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETTABLETRUNCATED");
    }

    @Override
    public void addDataTarget(IDataObject target) {
        if (this.m_bInTableLoaderAdd) {
            return;
        }
        this.startCompoundUndoable();
        try {
            super.addDataTarget(target);
            this.resetModelDefaults();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("TableLoaderTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("TableLoaderTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getDefaultDBIDirectExecValue() {
        return "DBIDIRECTEXEC";
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public IWorkTable addNewWorkTable() {
        throw new UnsupportedOperationException("Loader doesnt support work tables");
    }

    @Override
    public void removeDataTarget(IDataObject target) {
        if (this.m_bInTableLoaderRemove) {
            return;
        }
        this.startCompoundUndoable();
        try {
            super.removeDataTarget(target);
            this.resetModelDefaults();
            this.setModifyIndex(null);
            this.clearMatchingColumns();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void deleteWorkTablesFromOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public IWorkTable[] getWorkTables() {
        return new IWorkTable[0];
    }

    @Override
    public IPhysicalTable getTargetTable() {
        return this.getTargetTables().length > 0 ? (IPhysicalTable)this.getTargetTables()[0] : null;
    }

    public boolean isReplacingEntireTable() {
        if (this.getDataTargetsCount() > 0) {
            return this.getLoadStyle().equalsIgnoreCase(LOADSTYLE_REPLACE) && this.getReplaceType().equalsIgnoreCase("EntireTable");
        }
        return false;
    }

    protected boolean isSimulatingTruncate() {
        if (this.getDataTargetsCount() > 0) {
            return this.getLoadStyle().equalsIgnoreCase(LOADSTYLE_REPLACE) && this.getReplaceType().equalsIgnoreCase("SimulateTruncate");
        }
        return false;
    }

    public boolean isSyncCIPreLoadNeeded() {
        boolean isNeeded = false;
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            if (this.isReplacingEntireTable()) {
                isNeeded = false;
            } else if (this.isIndexEnabled(dataTarget) && this.getIndexBeforeValue().equals(CI_ACTION_ON)) {
                isNeeded = true;
            } else if (this.isConstraintEnabled(dataTarget) && this.getConstraintBeforeValue().equals(CI_ACTION_ON)) {
                isNeeded = true;
            }
        }
        return isNeeded;
    }

    public boolean isSyncCIPostLoadNeeded() {
        return this.isSyncCPostLoadNeeded() || this.isSyncIPostLoadNeeded();
    }

    public boolean isSyncIPostLoadNeeded() {
        return !this.isReplacingEntireTable() && this.getIndexBeforeValue().equals(CI_ACTION_ASIS) && this.getIndexAfterValue().equals(CI_ACTION_ON);
    }

    public boolean isSyncCPostLoadNeeded() {
        return !this.isReplacingEntireTable() && this.getConstraintBeforeValue().equals(CI_ACTION_ASIS) && this.getConstraintAfterValue().equals(CI_ACTION_ON);
    }

    public boolean isCIPostLoadNeeded() {
        return !this.getPostLoadCActionNeeded().equals("NONE") || !this.getPostLoadIActionNeeded().equals("NONE");
    }

    public String getPostLoadCActionNeeded() {
        String afterActionNeeded = "NONE";
        if (this.getDataTargetsCount() == 0) {
            return afterActionNeeded;
        }
        IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
        if (!this.isConstraintEnabled(dataTarget)) {
            return afterActionNeeded;
        }
        if (this.getConstraintBeforeValue().equals(CI_ACTION_ASIS) && this.getConstraintAfterValue().equals(CI_ACTION_OFF)) {
            afterActionNeeded = CI_ACTION_NEEDED_DROP;
        } else if (this.getConstraintBeforeValue().equals(CI_ACTION_ASIS) || this.getConstraintBeforeValue().equals(CI_ACTION_OFF)) {
            if (this.getConstraintAfterValue().equals(CI_ACTION_ON) || this.getConstraintAfterValue().equals(CI_ACTION_INITIAL_LOAD)) {
                afterActionNeeded = CI_ACTION_NEEDED_CREATE;
            }
        } else if (this.getConstraintAfterValue().equals(CI_ACTION_OFF)) {
            afterActionNeeded = CI_ACTION_NEEDED_DROP;
        }
        return afterActionNeeded;
    }

    public String getPostLoadIActionNeeded() {
        String afterActionNeeded = "NONE";
        if (this.getDataTargetsCount() == 0) {
            return afterActionNeeded;
        }
        IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
        if (!this.isIndexEnabled(dataTarget)) {
            return afterActionNeeded;
        }
        if (this.getIndexBeforeValue().equals(CI_ACTION_ASIS) && this.getIndexAfterValue().equals(CI_ACTION_OFF)) {
            afterActionNeeded = CI_ACTION_NEEDED_DROP;
        } else if (this.getIndexBeforeValue().equals(CI_ACTION_ASIS) || this.getIndexBeforeValue().equals(CI_ACTION_OFF)) {
            if (this.getIndexAfterValue().equals(CI_ACTION_ON) || this.getIndexAfterValue().equals(CI_ACTION_INITIAL_LOAD)) {
                afterActionNeeded = CI_ACTION_NEEDED_CREATE;
            }
        } else if (this.getIndexAfterValue().equals(CI_ACTION_OFF)) {
            afterActionNeeded = CI_ACTION_NEEDED_DROP;
        }
        return afterActionNeeded;
    }

    protected void resetReplaceTypeToDefault() {
        this.startCompoundUndoable();
        try {
            if (this.getDataTargetsCount() > 0) {
                this.setReplaceTypeImpl(((IPhysicalTable)this.getDataTargets()[0]).getDBMSType().getPreferredReplaceType());
            } else {
                this.setReplaceTypeImpl(this.getDefaultReplaceType());
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void resetNewRowsToDefault() {
        this.startCompoundUndoable();
        try {
            this.getValidValuesNewRows();
            this.setNewRowsImpl(this.getDefaultNewRows());
            if (this.getDefaultNewRows().equals("Upsert")) {
                this.resetIndexBeforeToDefault();
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected boolean isConstraintBeforeValid(String value) {
        return this.getValidValuesConstraintBefore().contains(value);
    }

    protected void resetConstraintBeforeToDefault() {
        this.startCompoundUndoable();
        try {
            this.getValidValuesConstraintBefore();
            this.setConstraintBeforeValueImpl(this.getDefaultConstraintBefore());
            this.resetConstraintAfterToDefault();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected boolean isConstraintAfterValid(String value) {
        return this.getValidValuesConstraintAfter().contains(value);
    }

    protected void resetConstraintAfterToDefault() {
        this.startCompoundUndoable();
        try {
            this.getValidValuesConstraintAfter();
            this.setConstraintAfterValueImpl(this.getDefaultConstraintAfter());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected boolean isIndexBeforeValid(String value) {
        return this.getValidValuesIndexBefore().contains(value);
    }

    protected void resetIndexBeforeToDefault() {
        this.startCompoundUndoable();
        try {
            this.getValidValuesIndexBefore();
            this.setIndexBeforeValueImpl(this.getDefaultIndexBefore());
            this.resetIndexAfterToDefault();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public boolean isIndexAfterValid(String value) {
        return this.getValidValuesIndexAfter().contains(value);
    }

    protected void resetIndexAfterToDefault() {
        this.startCompoundUndoable();
        try {
            this.getValidValuesIndexAfter();
            this.setIndexAfterValueImpl(this.getDefaultIndexAfter());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public String getModifyType() {
        String sType = "";
        if (this.getLoadStyle().equals(LOADSTYLE_UPDATE) && !this.getMatchingRows().equals(MODIFYUSINGINDEX) && !this.getNewRows().equals(MODIFYUSINGINDEX)) {
            sType = MODIFYBYCOLUMN;
        } else if (this.getLoadStyle().equals(LOADSTYLE_UPDATE) && this.getMatchingRows().equals(MODIFYUSINGINDEX) || this.getNewRows().equals(MODIFYUSINGINDEX)) {
            sType = MODIFYUSINGINDEX;
        }
        return sType;
    }

    public String getDataTableOptions() {
        return this.m_sDataTableOptions;
    }

    public void setDataTableOptions(String newDataTableOptions) {
        if (this.getDataTableOptions().equals(newDataTableOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDataTableOptionsUndoable(this.m_sDataTableOptions, newDataTableOptions));
        }
        this.m_sDataTableOptions = newDataTableOptions;
        this.fireModelChangedEvent(DATA_TABLE_OPTIONS_CHANGED, null);
    }

    public String getDefaultLoadStyle() {
        return this.m_sDefaultLoadStyle;
    }

    public void setDefaultLoadStyle(String defaultLoadStyle) {
        this.m_sDefaultLoadStyle = defaultLoadStyle;
    }

    public String getLoadStyle() {
        return this.m_sLoadStyle;
    }

    public List getLoadTechniques() {
        ArrayList<String> loadTechs = new ArrayList<String>();
        loadTechs.add(LOADSTYLE_UPDATE);
        loadTechs.add(LOADSTYLE_APPEND_EXISTING);
        loadTechs.add(LOADSTYLE_REPLACE);
        return loadTechs;
    }

    public boolean isLoadStyleValid(String value) {
        return this.getLoadTechniques().contains(value);
    }

    public void setLoadStyle(String sValue) {
        if (sValue.equalsIgnoreCase(this.getLoadStyle())) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.setLoadStyleImpl(sValue);
            this.resetNewRowsToDefault();
            this.resetConstraintBeforeToDefault();
            this.resetIndexBeforeToDefault();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setLoadStyleImpl(String sValue) {
        if (!this.isLoadStyleValid(sValue)) {
            throw new IllegalArgumentException("LoadStyle value passed in not one of the allowed types");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLoadStyleUndoable(this.m_sLoadStyle, sValue));
        }
        this.m_sLoadStyle = sValue;
        this.fireModelChangedEvent(LOAD_STYLE_CHANGED, null);
    }

    public String getReplaceType() {
        return this.m_sReplaceType;
    }

    public boolean isReplaceTypeValid(String value) {
        return this.getValidValuesReplaceType().contains(value);
    }

    protected String getDefaultReplaceType() {
        return this.m_sDefaultReplaceType;
    }

    protected void setDefaultReplaceType(String replaceType) {
        this.m_sDefaultReplaceType = replaceType;
    }

    public void setReplaceType(String sValue) {
        if (this.getReplaceType().equals(sValue)) {
            return;
        }
        if (!this.isReplaceTypeValid(sValue)) {
            throw new IllegalArgumentException("ReplaceType value passed in not one of the allowed types");
        }
        this.startCompoundUndoable();
        try {
            this.setReplaceTypeImpl(sValue);
            this.resetIndexBeforeToDefault();
            this.resetConstraintBeforeToDefault();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setReplaceTypeImpl(String sValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetReplaceTypeUndoable(this.m_sReplaceType, sValue));
        }
        this.m_sReplaceType = sValue;
        this.fireModelChangedEvent(REPLACETYPE_CHANGED, null);
    }

    protected String getDefaultMatchingRows() {
        return this.m_sDefaultMatchingRows;
    }

    public String getMatchingRows() {
        return this.m_sMatchingRows;
    }

    public void setMatchingRows(String sValue) {
        if (this.getMatchingRows().equals(sValue)) {
            return;
        }
        if (!this.isMatchingRowsValid(sValue)) {
            throw new IllegalArgumentException("Matching rows type passed in not allowed for this table type");
        }
        this.startCompoundUndoable();
        try {
            this.setMatchingRowsImpl(sValue);
            this.resetNewRowsToDefault();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setMatchingRowsImpl(String sValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMatchingRowsUndoable(this.m_sMatchingRows, sValue));
        }
        this.m_sMatchingRows = sValue;
        this.fireModelChangedEvent(MATCHINGROWS_CHANGED, null);
    }

    protected String getDefaultNewRows() {
        return this.m_sDefaultNewRows;
    }

    public boolean isNewRowsValid(String value) {
        return this.getValidValuesNewRows().contains(value);
    }

    public String getNewRows() {
        return this.m_sNewRows;
    }

    public void setNewRows(String sValue) {
        if (sValue.equalsIgnoreCase(this.getNewRows())) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (!this.isNewRowsValid(sValue)) {
                throw new IllegalArgumentException("New rows type passed in not allowed for this table type");
            }
            this.setNewRowsImpl(sValue);
            if (this.getNewRows().equals("Upsert")) {
                this.resetIndexBeforeToDefault();
                this.fireModelChangedEvent(INDEX_BEFORE_CHANGED, null);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setNewRowsImpl(String sValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNewRowsUndoable(this.m_sNewRows, sValue));
        }
        this.m_sNewRows = sValue;
        this.fireModelChangedEvent(NEWROWS_CHANGED, null);
    }

    public String getConstraintBeforeValue() {
        return this.m_sConstraintBefore;
    }

    public void setConstraintBeforeValue(String sValue) {
        if (sValue.equalsIgnoreCase(this.m_sConstraintBefore)) {
            return;
        }
        if (!this.isConstraintBeforeValid(sValue)) {
            throw new IllegalArgumentException("Before constraint value passed in not one of the allowed types");
        }
        List validValues = this.getValidValuesConstraintBefore();
        if (!validValues.contains(sValue)) {
            throw new IllegalArgumentException("ConstraintBefore value passed in not allowed for this scenario");
        }
        this.startCompoundUndoable();
        try {
            this.setConstraintBeforeValueImpl(sValue);
            this.resetConstraintAfterToDefault();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setConstraintBeforeValueImpl(String sValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetConstraintBeforeUndoable(this.m_sConstraintBefore, sValue));
        }
        this.m_sConstraintBefore = sValue;
        this.fireModelChangedEvent(CONSTRAINT_BEFORE_CHANGED, null);
    }

    public String getConstraintAfterValue() {
        return this.m_sConstraintAfter;
    }

    public void setConstraintAfterValue(String sValue) {
        if (sValue.equalsIgnoreCase(this.m_sConstraintAfter)) {
            return;
        }
        if (!this.isConstraintAfterValid(sValue)) {
            throw new IllegalArgumentException("After constraint value passed in not one of the allowed types");
        }
        List validValues = this.getValidValuesConstraintAfter();
        if (!validValues.contains(sValue)) {
            throw new IllegalArgumentException("ConstraintAfter value passed in not allowed for this scenario");
        }
        this.setConstraintAfterValueImpl(sValue);
    }

    protected void setConstraintAfterValueImpl(String sValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetConstraintAfterUndoable(this.m_sConstraintAfter, sValue));
        }
        this.m_sConstraintAfter = sValue;
        this.fireModelChangedEvent(CONSTRAINT_AFTER_CHANGED, null);
    }

    public void setIndexBeforeValue(String sValue) {
        if (sValue.equalsIgnoreCase(this.m_sIndexBefore)) {
            return;
        }
        if (!this.isIndexBeforeValid(sValue)) {
            throw new IllegalArgumentException("Before Index value passed in not one of the allowed types");
        }
        this.startCompoundUndoable();
        try {
            this.setIndexBeforeValueImpl(sValue);
            this.resetIndexAfterToDefault();
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setIndexBeforeValueImpl(String sValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIndexBeforeUndoable(this.m_sIndexBefore, sValue));
        }
        this.m_sIndexBefore = sValue;
        this.fireModelChangedEvent(INDEX_BEFORE_CHANGED, null);
    }

    public String getIndexBeforeValue() {
        return this.m_sIndexBefore;
    }

    public void setIndexAfterValue(String sValue) {
        if (sValue.equalsIgnoreCase(this.m_sIndexAfter)) {
            return;
        }
        if (!this.isIndexAfterValid(sValue)) {
            throw new IllegalArgumentException("After Index value passed in not one of the allowed types");
        }
        this.setIndexAfterValueImpl(sValue);
    }

    protected void setIndexAfterValueImpl(String sValue) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIndexAfterUndoable(this.m_sIndexAfter, sValue));
        }
        this.m_sIndexAfter = sValue;
        this.fireModelChangedEvent(INDEX_AFTER_CHANGED, null);
    }

    public String getIndexAfterValue() {
        return this.m_sIndexAfter;
    }

    public List getAvailableIndexes() {
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            return dataTarget.getIndexesList();
        }
        return new ArrayList();
    }

    public List getAvailableMatchColumns() {
        ArrayList<IColumn> availColumns = new ArrayList<IColumn>();
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            availColumns.addAll(Arrays.asList(dataTarget.getColumns()));
            availColumns.removeAll(this.m_lMatchColumns);
        }
        return availColumns;
    }

    public IIndex getModifyIndex() {
        return this.m_IIndexModifyIndex;
    }

    public void setModifyIndex(IIndex index) {
        if (this.m_IIndexModifyIndex == index) {
            return;
        }
        if (index != null && !this.isModifyIndexValid(index)) {
            throw new IllegalArgumentException("Index must be from target table.");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetModifyIndexUndoable(this.m_IIndexModifyIndex, index));
        }
        if (this.m_IIndexModifyIndex != null) {
            this.m_IIndexModifyIndex.removeNotifyListener(this);
        }
        this.m_IIndexModifyIndex = index;
        if (this.m_IIndexModifyIndex != null) {
            this.m_IIndexModifyIndex.addNotifyListener(this);
        }
        this.fireModelChangedEvent(MODIFYUSINGINDEX_CHANGED, index);
    }

    public boolean isModifyIndexValid(IIndex index) {
        IPhysicalTable table = this.getTargetTable();
        return table != null && table.getIndexesList().contains(index);
    }

    public void setNoMissingCheck(boolean bValue) {
        if (bValue == this.m_bNoMissingCheck) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNoMissingCheckUndoable(this.m_bNoMissingCheck, bValue));
        }
        this.m_bNoMissingCheck = bValue;
        this.fireModelChangedEvent(NOMISSINGCHECK_CHANGED, null);
    }

    public boolean isNoMissingCheck() {
        return this.m_bNoMissingCheck;
    }

    public boolean getDefaultNoMissingCheck() {
        return this.m_bDefaultNoMissingCheck;
    }

    public String getDefaultConstraintBefore() {
        return this.m_sDefaultConstraintBefore;
    }

    public String getDefaultConstraintAfter() {
        return this.m_sDefaultConstraintAfter;
    }

    public String getDefaultIndexAfter() {
        return this.m_sDefaultIndexAfter;
    }

    public String getDefaultIndexBefore() {
        return this.m_sDefaultIndexBefore;
    }

    public boolean isIndexUniqueValue() {
        return this.m_bIndexUnique;
    }

    public void setIndexUniqueValue(boolean bValue) {
        if (bValue == this.m_bIndexUnique) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIndexUniqueValueUndoable(this.m_bIndexUnique, bValue));
        }
        this.m_bIndexUnique = bValue;
        this.fireModelChangedEvent(INDEXUNIQUEVALUE_CHANGED, null);
    }

    public List getMatchingColumnsList() {
        return this.m_lMatchColumns;
    }

    public void clearMatchingColumns() {
        this.m_lMatchColumns.clear();
    }

    public void addMatchingColumn(IColumn column) {
        this.addMatchingColumn(this.m_lMatchColumns.size(), column);
    }

    public void addMatchingColumn(int index, IColumn column) {
        if (!this.isMatchingColumnValid(column)) {
            throw new IllegalArgumentException("Matching column must be from columns of target table.");
        }
        this.m_lMatchColumns.add(index, column);
    }

    public boolean isMatchingColumnValid(IColumn column) {
        IPhysicalTable table = this.getTargetTable();
        return table != null && table.containsColumn(column);
    }

    public IColumn[] getMatchingColumns() {
        return this.m_lMatchColumns.toArray(new IColumn[this.m_lMatchColumns.size()]);
    }

    public void removeMatchingColumn(IColumn column) {
        this.m_lMatchColumns.remove(column);
    }

    public boolean isUnmappedEqMissingInUpdate() {
        return this.m_bUnmappedEqMissingInUpdate;
    }

    @Override
    public boolean isValidateAvailable() {
        return this.isSourceAndTargetSameDatabaseServer();
    }

    public void setUnmappedEqMissingInUpdate(boolean bValue) {
        if (bValue == this.m_bUnmappedEqMissingInUpdate) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUnmappedEqMissingInUpdateUndoable(this.m_bUnmappedEqMissingInUpdate, bValue));
        }
        this.m_bUnmappedEqMissingInUpdate = bValue;
        this.fireModelChangedEvent(UNMAPPEDEQMISSINGINUPDATE_CHANGED, null);
    }

    protected boolean getDefaultUnmappedEqMissingInUpdate() {
        return this.m_bDefaultUnmappedEQMissingInUpdate;
    }

    protected boolean isConstraintEnabled() {
        boolean constraint = false;
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            return this.isConstraintEnabled(dataTarget);
        }
        return constraint;
    }

    public boolean isConstraintEnabled(IPhysicalTable dataTarget) {
        boolean bEnabled = false;
        if (dataTarget != null) {
            bEnabled = dataTarget.getDBMSType().isConstraintSupported() && dataTarget.hasConstraints();
        }
        return bEnabled;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.getDataTargetsCount() > 0 && this.getLoadStyle().equalsIgnoreCase(LOADSTYLE_UPDATE)) {
            if (this.getNewRows().equalsIgnoreCase(MODIFYUSINGINDEX) || this.getMatchingRows().equalsIgnoreCase(MODIFYUSINGINDEX)) {
                if (this.m_IIndexModifyIndex == null) {
                    lReasons.add(RB.getStringResource("TableLoaderTransformModel.ReasonIncomplete.NoIndex.txt"));
                }
            } else if (this.getMatchingColumnsList().isEmpty()) {
                lReasons.add(RB.getStringResource("TableLoaderTransformModel.ReasonIncomplete.NoByColumns.txt"));
            }
        }
        return lReasons;
    }

    @Override
    public boolean isComplete() {
        if (!super.isComplete()) {
            return false;
        }
        boolean noByColumn = this.getMatchingColumnsList().isEmpty();
        if (this.getDataTargetsCount() > 0 && this.getLoadStyle().equalsIgnoreCase(LOADSTYLE_UPDATE)) {
            if ((this.getNewRows().equalsIgnoreCase(MODIFYUSINGINDEX) || this.getMatchingRows().equalsIgnoreCase(MODIFYUSINGINDEX)) && this.m_IIndexModifyIndex == null) {
                return false;
            }
            if (!this.m_sNewRows.equalsIgnoreCase(MODIFYUSINGINDEX) && !this.m_sMatchingRows.equalsIgnoreCase(MODIFYUSINGINDEX)) {
                if (noByColumn) {
                    return false;
                }
                if (this.m_sMatchingRows.equalsIgnoreCase(MATCHING_ROWS_SQLSET) && this.getMatchingColumnsList().isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean hasWarning() {
        IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
        return (this.isReplacingEntireTable() || this.isSimulatingTruncate()) && dataTarget != null && !dataTarget.getForeignKeysList().isEmpty();
    }

    protected boolean isIndexEnabled() {
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            return this.isIndexEnabled(dataTarget);
        }
        return false;
    }

    public boolean isIndexEnabled(IPhysicalTable dataTarget) {
        boolean bEnabled = false;
        if (dataTarget != null) {
            bEnabled = dataTarget.getDBMSType().isIndexSupported() && !dataTarget.getDBMSType().getIndexesToCreate(dataTarget).isEmpty();
        }
        return bEnabled;
    }

    public boolean isMatchingRowsEnabled(IPhysicalTable dataTarget) {
        boolean match = false;
        if (dataTarget != null && this.m_sLoadStyle.equalsIgnoreCase(LOADSTYLE_UPDATE)) {
            match = true;
        }
        return match;
    }

    public boolean isNewRowsEnabled() {
        boolean value = false;
        if (this.getDataTargetsCount() > 0) {
            value = true;
        }
        return value;
    }

    public boolean isNoMissingCheckEnabled() {
        boolean match = false;
        if (this.getDataTargetsCount() > 0 && this.m_sLoadStyle.equalsIgnoreCase(LOADSTYLE_UPDATE) && (this.m_sMatchingRows.equalsIgnoreCase(MATCHING_ROWS_SQLSET) || this.m_sMatchingRows.equalsIgnoreCase(MODIFYBYCOLUMN) || this.m_sMatchingRows.equalsIgnoreCase(MODIFYUSINGINDEX))) {
            match = true;
        }
        return match;
    }

    protected boolean isRefreshConstraintsAvailable(IPhysicalTable dataTable) {
        boolean supported = false;
        if (dataTable != null) {
            supported = !dataTable.getDBMSType().getConstraintTypesDroppable().equals("");
        }
        return supported;
    }

    public boolean isReplaceTypeEnabled(IPhysicalTable dataTable) {
        boolean enabled = false;
        if (dataTable != null && this.getLoadStyle().equalsIgnoreCase(LOADSTYLE_REPLACE)) {
            enabled = true;
        }
        return enabled;
    }

    public List getValidValuesReplaceType() {
        ArrayList<String> lValidValues = new ArrayList<String>();
        lValidValues.add("EntireTable");
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            if (dataTarget.getDBMSType().isTruncateSupported()) {
                lValidValues.add("Truncate");
            }
            if (dataTarget.getDBMSType().isDeleteAllRowsSupported()) {
                lValidValues.add("Delete");
            }
            if (dataTarget.getDBMSType().isSimulateTruncateSupported()) {
                lValidValues.add("SimulateTruncate");
            }
        }
        return lValidValues;
    }

    public boolean isMatchingRowsValid(String value) {
        return this.getValidValuesMatchingRows().contains(value);
    }

    public List getValidValuesMatchingRows() {
        ArrayList<String> lValidValues = new ArrayList<String>();
        boolean bAddUsingIndex = false;
        boolean bAddModBy = false;
        boolean bAddUpsert = false;
        lValidValues.add(MATCHING_ROWS_SQLSET);
        lValidValues.add(SKIP);
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            if (dataTarget.getDBMSType().isIndexSupported() && dataTarget.getIndexes().length > 0) {
                bAddUsingIndex = true;
            }
            bAddModBy = dataTarget.getDBMSType().isRandomAccessSupported();
            bAddUpsert = dataTarget.getDBMSType().isUpsertSupported();
        }
        if (bAddModBy) {
            lValidValues.add(MODIFYBYCOLUMN);
        }
        if (bAddUsingIndex) {
            lValidValues.add(MODIFYUSINGINDEX);
        }
        if (bAddUpsert) {
            lValidValues.add("Upsert");
        }
        return lValidValues;
    }

    public List getValidValuesNewRows() {
        ArrayList<String> lValidValues = new ArrayList<String>();
        if (this.m_sLoadStyle.equals(LOADSTYLE_UPDATE)) {
            if (this.m_sMatchingRows.equals("Upsert")) {
                this.m_sDefaultNewRows = "Upsert";
                lValidValues.add("Upsert");
            } else if (this.m_sMatchingRows.equals(MATCHING_ROWS_SQLSET)) {
                this.m_sDefaultNewRows = NEW_ROWS_APPEND_PROC;
                lValidValues.add(NEW_ROWS_APPEND_PROC);
                lValidValues.add(NEW_ROWS_INSERT_SQL);
                lValidValues.add(SKIP);
            } else if (this.m_sMatchingRows.equals(MODIFYBYCOLUMN)) {
                this.m_sDefaultNewRows = MODIFYBYCOLUMN;
                lValidValues.add(MODIFYBYCOLUMN);
                lValidValues.add(SKIP);
            } else if (this.m_sMatchingRows.equals(MODIFYUSINGINDEX)) {
                this.m_sDefaultNewRows = MODIFYUSINGINDEX;
                lValidValues.add(MODIFYUSINGINDEX);
                lValidValues.add(SKIP);
            } else if (this.m_sMatchingRows.equals(SKIP)) {
                this.m_sDefaultNewRows = NEW_ROWS_APPEND_PROC;
                lValidValues.add(NEW_ROWS_APPEND_PROC);
                lValidValues.add(NEW_ROWS_INSERT_SQL);
                boolean bAddUsingIndex = false;
                boolean bAddModBy = false;
                if (this.getDataTargetsCount() > 0) {
                    IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
                    if (dataTarget.getDBMSType().isIndexSupported() && dataTarget.getIndexes().length > 0) {
                        bAddUsingIndex = true;
                    }
                    bAddModBy = dataTarget.getDBMSType().isRandomAccessSupported();
                }
                if (bAddUsingIndex) {
                    lValidValues.add(MODIFYUSINGINDEX);
                }
                if (bAddModBy) {
                    lValidValues.add(MODIFYBYCOLUMN);
                }
            }
        }
        if (lValidValues.size() == 0) {
            this.m_sDefaultNewRows = NEW_ROWS_APPEND_PROC;
            lValidValues.add(NEW_ROWS_APPEND_PROC);
            lValidValues.add(NEW_ROWS_INSERT_SQL);
        }
        return lValidValues;
    }

    public List getValidValuesConstraintBefore() {
        ArrayList<String> lValidValues = new ArrayList<String>();
        boolean bCanRefresh = false;
        boolean bReplacingTable = false;
        boolean bEnabled = false;
        boolean bSimmingTruncate = false;
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            bCanRefresh = this.isRefreshConstraintsAvailable(dataTarget);
            bReplacingTable = this.isReplacingEntireTable();
            bEnabled = this.isConstraintEnabled(dataTarget);
            boolean bl = bSimmingTruncate = dataTarget.getDBMSType().isSimulateTruncateSupported() && this.isSimulatingTruncate();
        }
        if (bSimmingTruncate) {
            this.m_sDefaultConstraintBefore = CI_ACTION_RECREATE_ASIS;
            lValidValues.add(CI_ACTION_RECREATE_ASIS);
            return lValidValues;
        }
        lValidValues.add(CI_ACTION_ASIS);
        if (bEnabled) {
            this.m_sDefaultConstraintBefore = CI_ACTION_INITIAL_LOAD;
            lValidValues.add(CI_ACTION_INITIAL_LOAD);
        } else {
            this.m_sDefaultConstraintBefore = CI_ACTION_ASIS;
        }
        if (bCanRefresh && !bReplacingTable) {
            lValidValues.add(CI_ACTION_OFF);
            lValidValues.add(CI_ACTION_ON);
        }
        return lValidValues;
    }

    public List getValidValuesConstraintAfter() {
        IPhysicalTable dataTarget;
        ArrayList<String> lValidValues = new ArrayList<String>();
        boolean bCanRefresh = false;
        boolean bReplacingTable = false;
        if (this.getDataTargetsCount() > 0 && (dataTarget = (IPhysicalTable)this.getDataTargets()[0]) != null) {
            bCanRefresh = this.isRefreshConstraintsAvailable(dataTarget);
            bReplacingTable = this.isReplacingEntireTable();
        }
        if (this.m_sConstraintBefore.equals(CI_ACTION_RECREATE_ASIS)) {
            this.m_sDefaultConstraintAfter = CI_ACTION_ASIS;
            lValidValues.add(CI_ACTION_ASIS);
        } else if (this.m_sConstraintBefore.equals(CI_ACTION_INITIAL_LOAD)) {
            this.m_sDefaultConstraintAfter = CI_ACTION_ASIS;
            lValidValues.add(CI_ACTION_ASIS);
            if (bCanRefresh) {
                lValidValues.add(CI_ACTION_OFF);
            }
        } else if (this.m_sConstraintBefore.equals(CI_ACTION_OFF)) {
            this.m_sDefaultConstraintAfter = CI_ACTION_ASIS;
            lValidValues.add(CI_ACTION_ASIS);
            lValidValues.add(CI_ACTION_ON);
        } else if (this.m_sConstraintBefore.equals(CI_ACTION_ON)) {
            this.m_sDefaultConstraintAfter = CI_ACTION_ASIS;
            lValidValues.add(CI_ACTION_ASIS);
            lValidValues.add(CI_ACTION_OFF);
        } else if (this.m_sConstraintBefore.equals(CI_ACTION_ASIS)) {
            this.m_sDefaultConstraintAfter = CI_ACTION_ASIS;
            lValidValues.add(CI_ACTION_INITIAL_LOAD);
            lValidValues.add(CI_ACTION_ASIS);
            if (bCanRefresh && !bReplacingTable) {
                lValidValues.add(CI_ACTION_OFF);
                lValidValues.add(CI_ACTION_ON);
            }
        }
        return lValidValues;
    }

    public List getValidValuesIndexBefore() {
        ArrayList<String> lValidValues = new ArrayList<String>();
        boolean bCanRefresh = false;
        boolean bReplacingTable = false;
        boolean bEnabled = false;
        boolean bSimmingTruncate = false;
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            bReplacingTable = this.isReplacingEntireTable();
            bCanRefresh = this.isIndexEnabled(dataTarget);
            bEnabled = this.isIndexEnabled(dataTarget);
            boolean bl = bSimmingTruncate = dataTarget.getDBMSType().isSimulateTruncateSupported() && this.isSimulatingTruncate();
        }
        if (bEnabled && bSimmingTruncate) {
            this.m_sDefaultIndexBefore = CI_ACTION_OFF;
        } else {
            lValidValues.add(CI_ACTION_ASIS);
            if (bEnabled) {
                this.m_sDefaultIndexBefore = CI_ACTION_INITIAL_LOAD;
                lValidValues.add(CI_ACTION_INITIAL_LOAD);
            } else {
                this.m_sDefaultIndexBefore = CI_ACTION_ASIS;
            }
        }
        if (bCanRefresh && !bReplacingTable) {
            lValidValues.add(CI_ACTION_OFF);
            lValidValues.add(CI_ACTION_ON);
            if (this.m_sLoadStyle.equalsIgnoreCase(LOADSTYLE_UPDATE) && this.m_sMatchingRows.equalsIgnoreCase("Upsert")) {
                this.m_sDefaultIndexBefore = CI_ACTION_OFF;
            }
        }
        return lValidValues;
    }

    public List getValidValuesIndexAfter() {
        ArrayList<String> lValidValues = new ArrayList<String>();
        boolean bCanRefresh = false;
        boolean bReplacingTable = false;
        if (this.getDataTargetsCount() > 0) {
            IPhysicalTable dataTarget = (IPhysicalTable)this.getDataTargets()[0];
            bReplacingTable = this.isReplacingEntireTable();
            bCanRefresh = this.isIndexEnabled(dataTarget);
        }
        if (this.m_sIndexBefore.equalsIgnoreCase(CI_ACTION_INITIAL_LOAD)) {
            this.m_sDefaultIndexAfter = CI_ACTION_ASIS;
            lValidValues.add(CI_ACTION_ASIS);
            if (bCanRefresh) {
                lValidValues.add(CI_ACTION_OFF);
            }
        } else if (this.m_sIndexBefore.equalsIgnoreCase(CI_ACTION_OFF)) {
            this.m_sDefaultIndexAfter = CI_ACTION_ON;
            lValidValues.add(CI_ACTION_ASIS);
            lValidValues.add(CI_ACTION_ON);
        } else if (this.m_sIndexBefore.equalsIgnoreCase(CI_ACTION_ON)) {
            this.m_sDefaultIndexAfter = CI_ACTION_ASIS;
            lValidValues.add(CI_ACTION_ASIS);
            lValidValues.add(CI_ACTION_OFF);
        } else if (this.m_sIndexBefore.equalsIgnoreCase(CI_ACTION_ASIS)) {
            this.m_sDefaultIndexAfter = bCanRefresh ? CI_ACTION_INITIAL_LOAD : CI_ACTION_ASIS;
            lValidValues.add(CI_ACTION_INITIAL_LOAD);
            lValidValues.add(CI_ACTION_ASIS);
            if (bCanRefresh && !bReplacingTable) {
                lValidValues.add(CI_ACTION_OFF);
                lValidValues.add(CI_ACTION_ON);
            }
        }
        return lValidValues;
    }

    private String getCIActionsString(String delim, boolean useQuotes) {
        String quote = "";
        if (useQuotes) {
            quote = "'";
        }
        StringBuffer code = new StringBuffer();
        code.append(quote + (this.isConstraintEnabled() ? this.getConstraintBeforeValue() : CI_ACTION_ASIS));
        code.append(quote + delim + quote + (this.isConstraintEnabled() ? this.getConstraintAfterValue() : CI_ACTION_ASIS));
        code.append(quote + delim + quote + (this.isIndexEnabled() ? this.getIndexBeforeValue() : CI_ACTION_ASIS));
        code.append(quote + delim + quote + (this.isIndexEnabled() ? this.getIndexAfterValue() : CI_ACTION_ASIS) + quote);
        return code.toString();
    }

    protected void genParmsInSASLog(ICodeSegment codeSegment) {
        String loadType = this.getLoadStyle();
        codeSegment.addSourceCode("/* --------------------------------------------------------------\n").indent().addSourceCode("Load Technique Selection: " + loadType);
        if (loadType.equalsIgnoreCase(LOADSTYLE_UPDATE)) {
            codeSegment.addSourceCode(" - Matching=" + this.getMatchingRows()).addSourceCode(", New=" + this.getNewRows() + "\n").addSourceCode("Blanks may replace non-blanks: " + this.isNoMissingCheck());
        } else if (loadType.equalsIgnoreCase(LOADSTYLE_REPLACE)) {
            codeSegment.addSourceCode(" - " + this.getReplaceType());
        } else {
            codeSegment.addSourceCode(" - " + this.getNewRows());
        }
        codeSegment.addSourceCode("\n").addSourceCode("Constraint and index action selections: " + this.getCIActionsString(",", true) + "\n");
        codeSegment.addSourceCode("Additional options selections... \n").addSourceCode("   Set unmapped to missing on updates: " + this.isUnmappedEqMissingInUpdate() + " \n").unIndent().addSourceCode("   -------------------------------------------------------------- */\n");
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment, validate);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        this.genBeginningMacros(codeSegment);
        String dsOptions = this.getSourceTableOptions(codeSegment, source);
        IColumn loadTimeColumn = this.getAndGenerateSetOfLoadTimeColumn(codeSegment, dsOptions);
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.genJobStatusUpdateBefore(target);
        }
        String sMappingStepOutputName = this.genMappingStepCode(codeSegment, dsOptions, loadTimeColumn);
        codeSegment.addCommentLine(RB.getStringResource("TableLoaderTransformModel.Exist.msg.notrans"));
        codeSegment.genTableExist(target.getFullNameQuotedAsNeeded(codeSegment), "etls_tableExist");
        this.genLoadStyleCode(codeSegment, validate);
        boolean isMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, target);
        if (isMappingNeeded && !target.isView()) {
            codeSegment.genTableDelete(sMappingStepOutputName);
        }
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.genJobStatusUpdateAfter(target);
        }
        this.genMacroEnd(codeSegment);
        if (!validate) {
            this.genCodeConditionChecks(codeSegment);
        }
        return codeSegment;
    }

    protected void genCodeConditionChecks(ICodeSegment codeSegment) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IPhysicalTable target = this.getTargetTable();
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CSUCCESSFUL", this, target);
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CWARNINGS", this, target);
        target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CERRORS", this, target);
    }

    protected ICodeSegment genBeginningMacros(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("%global etls_tableExist;\n").addSourceCode("%global etls_numIndex;\n").addSourceCode("%global etls_lastTable;\n").addSourceCode("%let etls_tableExist = -1; \n").addSourceCode("%let etls_numIndex = -1; \n").addSourceCode("%let etls_lastTable = &SYSLAST; \n\n");
        codeSegment.addSectionComment(RB.getStringResource("TableLoaderTransformModel.DefineMacro.msg.notrans")).addSourceCode("\n");
        this.genParmsInSASLog(codeSegment);
        codeSegment.addSourceCode("%macro etls_loader;\n\n").indent();
        return codeSegment;
    }

    protected void genMacroEnd(ICodeSegment codeSegment) {
        codeSegment.unIndent().addSourceCode("%mend etls_loader;\n").addSourceCode("%etls_loader;\n\n");
    }

    protected String getSourceTableOptions(ICodeSegment codeSegment, IPhysicalTable source) {
        ITransformTableOptions sourceOptions = this.getTableOptionObject(source, true);
        String sourceTableOptions = sourceOptions.getTableOptions(codeSegment.getCurrentServer());
        if (sourceTableOptions != null && sourceTableOptions.length() > 0) {
            codeSegment.addSourceCode("%let etls_tableOptions = %nrquote(").addSourceCode(sourceTableOptions).addSourceCode(");\n\n");
        } else {
            codeSegment.addSourceCode("%let etls_tableOptions = ;\n\n");
        }
        return sourceTableOptions;
    }

    protected void genLoadStyleCode(ICodeSegment codeSegment, boolean bValidate) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IPhysicalTable target = this.getTargetTable();
        boolean createConstraints = this.isConstraintEnabled(target) && !this.getConstraintBeforeValue().equalsIgnoreCase(CI_ACTION_OFF) && !this.getConstraintBeforeValue().equalsIgnoreCase(CI_ACTION_ASIS);
        boolean createIndexes = this.isIndexEnabled(target) && !(this.getIndexBeforeValue().equalsIgnoreCase(CI_ACTION_OFF) | this.getIndexBeforeValue().equalsIgnoreCase(CI_ACTION_ASIS));
        boolean needNewRowsTable = false;
        IIndex modifyingIndex = null;
        if (this.m_sLoadStyle.equalsIgnoreCase(LOADSTYLE_UPDATE)) {
            codeSegment.addSourceCode("%let etls_hasUpdateIndex=0; \n\n");
        }
        IDBMSType tableDBMSType = target.getDBMSType();
        if (!this.isReplacingEntireTable() && !this.isSimulatingTruncate()) {
            tableDBMSType.create(codeSegment, target, true, createConstraints, createIndexes, true, this.getDataTableOptions(), this);
        }
        if (this.m_sLoadStyle.equalsIgnoreCase(LOADSTYLE_UPDATE)) {
            modifyingIndex = !this.getNewRows().equalsIgnoreCase(MODIFYUSINGINDEX) ? this.getIndexMatchingMatchColumns(target) : this.getModifyIndex();
            if (this.getMatchingRows().indexOf(MODIFY) >= 0 || this.getNewRows().indexOf(MODIFY) >= 0) {
                this.updateCIPreLoad(codeSegment, target, true, modifyingIndex);
                this.loadWithMod(codeSegment, target);
            } else if (this.getMatchingRows().equals("Upsert") || this.getNewRows().equals("Upsert")) {
                this.updateCIPreLoad(codeSegment, target, true, modifyingIndex);
                this.loadWithUpsert(codeSegment, target, this.getMatchingColumnsList(), this.isUnmappedEqMissingInUpdate(), Arrays.asList(this.getOrdinaryUnmappedTargetColumns(null)));
            } else {
                this.updateCIPreLoad(codeSegment, target, true, modifyingIndex);
                boolean skippingNewRows = this.getNewRows().equalsIgnoreCase(SKIP);
                boolean needSet = this.getMatchingRows().equalsIgnoreCase(MATCHING_ROWS_SQLSET);
                if (!skippingNewRows) {
                    needNewRowsTable = true;
                }
                ITransformTableOptions targetOptions = this.getTableOptionObject(target, false);
                String targetDataOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
                codeSegment.genGetNumRows(target.getFullNameQuotedAsNeeded(codeSegment), targetDataOptions, "etls_targetHasRows", true, "1").addSourceCode("\n%if (&etls_targetHasRows) %then \n").addSourceCode("%do;  /* if has rows */ \n").indent();
                this.loadWithSQLMatching(codeSegment, target, needSet, needNewRowsTable);
                codeSegment.unIndent().addSourceCode("%end; /* if has rows */ \n\n");
                if (skippingNewRows) {
                    codeSegment.addSourceCode("%else \n").addSourceCode("%do; /* else no rows */ \n").indent();
                    this.loadWithAppend(codeSegment, target);
                    codeSegment.addSourceCode("%put NOTE: Empty base table was found.  Skip-New was ignored and an initial load was done for this run.; \n").addSourceCode("%put NOTE: In subsequent runs, unmatched rows will be excluded with the Skip-New option.; \n");
                    codeSegment.unIndent().addSourceCode("%end;  /* else no rows */ \n\n");
                }
            }
        } else if (this.getLoadStyle().equalsIgnoreCase(LOADSTYLE_REPLACE)) {
            String replaceType = this.getReplaceType();
            if ((replaceType.equalsIgnoreCase("Delete") || replaceType.equalsIgnoreCase("Truncate")) && tableDBMSType.isDeleteAllRowsSupported()) {
                boolean droppingCorI;
                boolean bl = droppingCorI = this.isConstraintEnabled() && this.getConstraintBeforeValue().equals(CI_ACTION_OFF) || this.isIndexEnabled() && this.getIndexBeforeValue().equals(CI_ACTION_OFF);
                if (droppingCorI) {
                    this.updateCIPreLoad(codeSegment, target, true, null);
                    codeSegment.addSourceCode("%if (&etls_tableExist eq 1) %then \n");
                } else {
                    codeSegment.addSourceCode("%else \n");
                }
                codeSegment.addSourceCode("%do;  /* table exists */ \n").indent();
                if (!bValidate) {
                    tableDBMSType.deleteAllRows(codeSegment, target, replaceType.equals("Truncate"));
                    target.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CTABLETRUNCATED", this, target);
                }
                codeSegment.unIndent().addSourceCode("%end; /* table exists */ \n\n");
                if (!droppingCorI && !bValidate) {
                    this.updateCIPreLoad(codeSegment, target, false, null);
                }
            } else {
                boolean simTruncate = replaceType.equalsIgnoreCase("SimulateTruncate");
                if (!bValidate) {
                    tableDBMSType.genReplaceEntireTable(codeSegment, target, this.isConstraintEnabled(), createConstraints, createIndexes, this.getDataTableOptions(), simTruncate, this);
                }
            }
        } else if (!bValidate) {
            this.updateCIPreLoad(codeSegment, target, true, null);
        }
        if (this.getNewRows().equalsIgnoreCase(NEW_ROWS_INSERT_SQL)) {
            this.loadWithSQLInsert(codeSegment, target, bValidate);
        } else if (this.getNewRows().equalsIgnoreCase(NEW_ROWS_APPEND_PROC)) {
            this.loadWithAppend(codeSegment, target);
        }
        this.updateCIPostLoad(codeSegment, target, modifyingIndex);
        if (needNewRowsTable) {
            codeSegment.genTableDelete("work.etls_newrecords");
        }
    }

    protected String genMappingStepCode(ICodeSegment codeSegment, String sourceDataOptions, IColumn loadTimeColumn) throws RemoteException, CodegenException, BadLibraryDefinitionException, MdException, BadServerDefinitionException, ServerException {
        ArrayList<IColumn> columnsToExcludeFromMapping = new ArrayList<IColumn>();
        if (loadTimeColumn != null) {
            columnsToExcludeFromMapping.add(loadTimeColumn);
        }
        boolean assignUnmappedEqMissing = !this.getLoadStyle().equalsIgnoreCase(LOADSTYLE_UPDATE) || this.getMatchingRows().indexOf(MODIFY) < 0 || this.isUnmappedEqMissingInUpdate();
        IColumn[] unmappedColumns = null;
        if (!assignUnmappedEqMissing) {
            unmappedColumns = this.getOrdinaryUnmappedTargetColumns(columnsToExcludeFromMapping);
        }
        IPhysicalTable source = this.getSourceTable();
        IPhysicalTable target = this.getTargetTable();
        boolean isMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, target);
        String mappingStepOutputName = "";
        if (isMappingNeeded) {
            mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
            this.getOrdinaryMappingCode(codeSegment, source, target, mappingStepOutputName, "&etls_lastTable", sourceDataOptions.length() > 0 ? "&etls_tableOptions" : "", null, true, true, false, columnsToExcludeFromMapping.toArray(new IColumn[columnsToExcludeFromMapping.size()]), unmappedColumns, false, null, null, null);
            codeSegment.addSourceCode("%let etls_lastTable = &SYSLAST; \n");
        }
        return mappingStepOutputName;
    }

    protected IColumn getAndGenerateSetOfLoadTimeColumn(ICodeSegment codeSegment, String sourceDataOptions) {
        IColumn loadTimeColumn = null;
        try {
            loadTimeColumn = (IColumn)this.getOptionModel().getOptionValue("LoadTime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loadTimeColumn != null) {
            codeSegment.addSectionComment(RB.getStringResource("TableLoaderTransformModel.SetLoadTime.msg.notrans"));
            String dsname = codeSegment.getUniqueWorkTableName();
            String dtFormat = this.getJob().isUsingNLSDateFormat() ? "nldatm." : "datetime.";
            String loadColName = loadTimeColumn.getColumnName(codeSegment.isQuoting());
            codeSegment.addSourceCode("%let etls_jobLoadTime = &SYSDATE9.:&SYSTIME;\n").addSourceCode("%let etls_loadTime = &etls_jobLoadTime; \n").addSourceCode("data _null_;\n").indent().addSourceCode("_loadtime = input(\"&etls_LoadTime\",DATETIME20.);\n").genPutStatement(RB.getStringResource("TableLoaderTransformModel.LoadtimeNote.msg.notrans"), "NOTE:", "_loadtime " + dtFormat, false).unIndent().addSourceCode("run;\n\n");
            codeSegment.genTableDelete(dsname).addSourceCode("data work.").addSourceCode(dsname).addSourceCode(" / view=work.").addSourceCode(dsname).addSourceCode(";\n").indent().addSourceCode("set ").addSourceCode("&SYSLAST (&etls_tableOptions)").addSourceCode(";\n").addSourceCode(loadColName).addSourceCode(" = \"&etls_LoadTime\"dt;\n").unIndent().addSourceCode("run;\n\n");
            codeSegment.genRCSetCall("&syserr").addSourceCode("%let SYSLAST = work.").addSourceCode(dsname).addSourceCode(";\n").addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            if (sourceDataOptions.length() > 0) {
                codeSegment.addSourceCode("%let etls_tableOptions = ;\n\n");
            } else {
                codeSegment.addSourceCode("\n");
            }
        }
        return loadTimeColumn;
    }

    protected ICodeSegment loadWithMod(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        boolean allowNew;
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        StringBuffer gen_opts = new StringBuffer();
        ITransformTableOptions targetOptions = this.getTableOptionObject(table, false);
        String targetDataOptions = targetOptions.getTableOptions(false, null, this.getDataTableOptions(), codeSegment.getCurrentServer());
        gen_opts.append(targetDataOptions);
        List<IColumn> columnList = Arrays.asList(table.getColumns());
        boolean allowUpdates = !this.getMatchingRows().equals(SKIP);
        boolean bl = allowNew = !this.getNewRows().equals(SKIP);
        if (!this.m_sModifyUpdateFailAction.equals("NONE")) {
            this.genCheckModifyRCMacro(codeSegment);
        }
        if (this.m_sModifyUpdateFailAction.equals(MODIFY_UPDATE_FAIL_ACTION_CUSTOM)) {
            codeSegment.addSourceCode("filename _macsrc catalog 'WORK.SASMACR.UW_CHECKMODIFYRC.MACRO';\n").addSourceCode("data _null_;\n").indent().addSourceCode("if not fexist('_macsrc') then\n").indent().genPutStatement(RB.getStringResource("TableLoaderTransformModel.ModifyFailed.CustomMacroRequired.msg.notrans"), "NOTE:", false).unIndent().unIndent().addSourceCode("run;\n").addSourceCode("filename _macsrc clear;\n\n");
        }
        if (this.getMatchingRows().equals(MODIFYBYCOLUMN) || this.getNewRows().equals(MODIFYBYCOLUMN)) {
            List keyList;
            boolean noMiss = this.isNoMissingCheck();
            String option = "";
            if (noMiss) {
                option = "updatemode = nomissingcheck \n";
            }
            if ((keyList = this.getMatchingColumnsList()).size() <= 0) {
                throw new CodegenException(RB.getStringResource("TableLoaderTransformModel.ReasonIncomplete.NoByColumns.txt"), (IObject)this);
            }
            String byList = codeSegment.makeColumnList(keyList, false, "   ", false, " ", "", codeSegment.isQuoting(), "", false);
            if (allowUpdates) {
                table.getDBMSType().genMatchingRowsPrelim(codeSegment);
            }
            boolean resetLibname = table.getDBMSType().genRereadExposure(codeSegment, table);
            if (gen_opts.length() > 0) {
                gen_opts.insert(0, "(").append(")");
            }
            codeSegment.addSectionComment("Begin Modify Step").addCommentLine("Allow user to specify IORC values to trigger step to stop. Initialize if not assigned.").addSourceCode("%if NOT %symexist(etls_StopOnIORC) %then %let etls_StopOnIORC=;\n");
            if (targetDataOptions.toUpperCase().contains("DBCOMMIT")) {
                codeSegment.addSourceCode("%if &etls_StopOnIORC EQ %then %let etls_StopOnIORC = 5780048;\n").addSourceCode("%else %let etls_StopOnIORC = 5780048, &etls_StopOnIORC;\n\n");
            } else {
                codeSegment.addSourceCode(" \n");
            }
            codeSegment.addSourceCode("data " + tableName + "; \n").indent().addSourceCode("length etls_msg $200; \ndrop etls_msg; \n").addSourceCode("modify " + tableName + gen_opts.toString() + " \n").addSourceCode("       &etls_lastTable");
            if (option.length() > 0) {
                codeSegment.addSourceCode("\n       " + option);
            }
            codeSegment.addSourceCode("; \n\n").addSourceCode("by " + byList + ";\n\n");
            if (allowNew) {
                codeSegment.addCommentLine(RB.getStringResource("TableLoaderTransformModel.RecordDoesNotExist.msg.notrans")).addSourceCode("if %sysrc(_DSENMR) eq _iorc_ then \n");
                this.genModifyOutputOrReplace(codeSegment, "output", allowUpdates);
            }
            if (allowUpdates) {
                codeSegment.addCommentLine(RB.getStringResource("TableLoaderTransformModel.RecordExists.msg.notrans"));
                if (allowNew) {
                    codeSegment.addSourceCode("else ");
                }
                codeSegment.addSourceCode("if %sysrc(_SOK) eq _iorc_ then \n");
                this.genModifyOutputOrReplace(codeSegment, "replace", allowUpdates);
            }
            codeSegment.addSourceCode("%if &etls_StopOnIORC ne %then\n").addSourceCode("%do;\n").indent().addSourceCode("if _iorc_ in (&etls_StopOnIORC) then\n").addSourceCode("do;\n").indent();
            if (targetDataOptions.toUpperCase().contains("DBCOMMIT")) {
                codeSegment.genPutStatement("DBCOMMIT may not be used with the Modify By load technique.  Reset the DBCOMMIT output table option on the Loader.", "ERROR%QUOTE(:)");
            }
            codeSegment.addSourceCode("etls_msg = iorcmsg();\nput etls_msg; \n%rcSetDS(5)\n");
            codeSegment.addSourceCode("stop;\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("%end;\n");
            codeSegment.addSourceCode("_iorc_ = 0; \n").addSourceCode("_error_ = 0; \n\n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr").addSourceCode("%let etls_StopOnIORC=; /* reset to blank */ \n\n");
            table.getDBMSType().genLibname(codeSegment, table, resetLibname);
        } else if (this.getMatchingRows().equals(MODIFYUSINGINDEX) || this.getNewRows().equals(MODIFYUSINGINDEX)) {
            String indexName = "";
            IIndex modifyIndex = this.getModifyIndex();
            if (modifyIndex != null) {
                indexName = modifyIndex.getName();
            }
            List indexList = table.getIndexesList();
            if (indexName == null || indexName.length() == 0 || indexList.size() <= 0) {
                throw new CodegenException(RB.getStringResource("TableLoaderTransformModel.ReasonIncomplete.NoIndex.txt"), (IObject)this);
            }
            ArrayList<String> ixColumns = new ArrayList<String>();
            List columnsList = modifyIndex.getColumnsList();
            int size = columnsList.size();
            for (int j = 0; j < size; ++j) {
                String colName = ((IColumn)columnsList.get(j)).getColumnName(codeSegment.isQuoting());
                ixColumns.add(colName);
            }
            StringBuffer rename = new StringBuffer("(rename=(");
            StringBuffer assign = new StringBuffer("");
            StringBuffer unAssign = new StringBuffer("");
            int counter = 0;
            for (int i = 0; i < columnList.size(); ++i) {
                IColumn col = columnList.get(i);
                String sasColumnName = col.getColumnName(codeSegment.isQuoting());
                if (ixColumns.indexOf(sasColumnName) >= 0) continue;
                String columnName = DBMSNamesUtil.getQuotedColumnName(col, codeSegment.isQuoting(), false);
                if (this.getMatchingRows().indexOf(MODIFY) >= 0 && !this.isUnmappedEqMissingInUpdate() && this.getOrdinaryMappingsForTargetColumn(col) == null && this.getLoadTimeColumn() != col && !this.isNoMissingCheck()) {
                    unAssign.append(columnName + " = " + (col.getType() == 0 ? "\"\"" : ".") + ";\n");
                }
                if (this.getMatchingRows().indexOf(MODIFY) >= 0 && !this.isUnmappedEqMissingInUpdate() && this.getOrdinaryMappingsForTargetColumn(col) == null && this.getLoadTimeColumn() != col) continue;
                String tempColumnName = "etls_temp" + String.valueOf(counter);
                if (counter > 0) {
                    rename.append("\n          ");
                }
                rename.append(columnName + " = " + tempColumnName);
                if (!this.isNoMissingCheck() && allowUpdates) {
                    assign.append("if " + tempColumnName + " ne " + (col.getType() == 0 ? "\"\"" : ".") + " then ");
                }
                assign.append(columnName + " = " + tempColumnName + ";\n");
                if (!this.isNoMissingCheck()) {
                    unAssign.append(columnName + " = " + (col.getType() == 0 ? "\"\"" : ".") + ";\n");
                }
                ++counter;
            }
            rename.append("))");
            boolean resetLibname = table.getDBMSType().genRereadExposure(codeSegment, table);
            codeSegment.addSourceCode("data " + tableName + "; \n\n").indent().addSourceCode("set &etls_lastTable \n").indent().indent().addSourceCode(" " + rename.toString() + "\n").unIndent().unIndent().addSourceCode("; \n\n");
            codeSegment.addSourceCode("modify ").addSourceCode(tableName).addSourceCode("\n").indent();
            table.getDBMSType().genKeyedLookupStatement(codeSegment, table, modifyIndex, this.isIndexUniqueValue(), gen_opts.toString());
            codeSegment.unIndent().addSourceCode("if ").addSourceCode(allowNew ? MODIFY_NEW_CONDITION : MODIFY_UPDATE_CONDITION).addSourceCode(allowNew && allowUpdates ? " or \n   _iorc_ eq %sysrc(_SOK)" : "").addSourceCode(" then  \n").addSourceCode("do; \n").indent().addSourceCode(assign);
            if (allowNew && allowUpdates) {
                codeSegment.addSourceCode("\n").addCommentLine(RB.getStringResource("TableLoaderTransformModel.RecordExists.msg.notrans")).addSourceCode("if _iorc_ eq %sysrc(_SOK) then \n");
            }
            if (allowUpdates) {
                this.genModifyOutputOrReplace(codeSegment, "replace", allowUpdates);
                if (allowNew) {
                    codeSegment.addSourceCode("\n").addCommentLine(RB.getStringResource("TableLoaderTransformModel.RecordDoesNotExist.msg.notrans")).addSourceCode("else \n");
                }
            }
            if (allowNew) {
                this.genModifyOutputOrReplace(codeSegment, "output", allowUpdates);
            }
            if (unAssign.length() != 0) {
                codeSegment.addSourceCode(unAssign);
            }
            codeSegment.unIndent().addSourceCode("end; \n\n").addSourceCode("_iorc_ = 0; \n").addSourceCode("_error_ = 0; \n\n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
            table.getDBMSType().genLibname(codeSegment, table, resetLibname);
        }
        table.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, table);
        return codeSegment;
    }

    private ICodeSegment genModifyOutputOrReplace(ICodeSegment codeSegment, String outputOrReplaceAction, boolean allowUpdates) {
        if (!this.m_sModifyUpdateFailAction.equals("NONE")) {
            codeSegment.addSourceCode("do; \n").indent();
            codeSegment.addSourceCode(outputOrReplaceAction + "; \n");
            if (this.m_sModifyUpdateFailAction.equals(MODIFY_UPDATE_FAIL_ACTION_ERROR) || this.m_sModifyUpdateFailAction.equals(MODIFY_UPDATE_FAIL_ACTION_WARNING)) {
                String extraIndent = "                    ";
                codeSegment.addSourceCode("%etls_checkModifyRC(").addSourceCode("condition=_iorc_ ne %sysrc(_SOK),\n").addSourceCode(extraIndent + "stopOnFailure=" + (this.m_sModifyUpdateFailAction.equals(MODIFY_UPDATE_FAIL_ACTION_ERROR) ? "1" : "0") + "); \n");
            } else if (this.m_sModifyUpdateFailAction.equals(MODIFY_UPDATE_FAIL_ACTION_CUSTOM)) {
                codeSegment.addSourceCode("%uw_checkModifyRC;\n");
            }
            codeSegment.unIndent().addSourceCode("end; \n");
        } else {
            codeSegment.indent().addSourceCode(outputOrReplaceAction + "; \n");
            if (allowUpdates) {
                codeSegment.unIndent();
            }
        }
        return codeSegment;
    }

    private ICodeSegment genCheckModifyRCMacro(ICodeSegment codeSegment) {
        if (this.m_sModifyUpdateFailAction.equals(MODIFY_UPDATE_FAIL_ACTION_CUSTOM)) {
            CodeSegment codeSegment2 = (CodeSegment)codeSegment;
            Objects.requireNonNull(codeSegment2);
            CodeSegment.SASMacro macro = codeSegment2.new CodeSegment.SASMacro("etls_checkModifyRC");
            macro.addParameter("condition").addParameter("stopOnFailure");
            codeSegment.addSourceCode(macro.getCommentHeader());
        } else {
            codeSegment.addSectionComment("Create etls_checkModifyRC macro");
        }
        codeSegment.addSourceCode("%macro etls_checkModifyRC(condition=_iorc_ ne %sysrc(_SOK), stopOnFailure=1); \n");
        codeSegment.indent().addSourceCode("length _iorcmsg $200;\n").addSourceCode("_iorcmsg=iorcmsg();\n").addSourceCode("drop _failCnt _iorcmsg;\n").addSourceCode("if (&condition) then \n").addSourceCode("do; \n").indent().addSourceCode("_failCnt+1;\n").addSourceCode("if _failCnt eq &stopOnFailure then\n").addSourceCode("do;\n").indent().addSourceCode("if _iorcmsg=:'ERROR' then _iorcmsg=\"WARNING%QUOTE(:) \" || substr(_iorcmsg,8); put _iorcmsg;\n").genPutStatement(RB.getStringResource("TableLoaderTransformModel.ModifyFailed.StatusSetToError.msg.notrans"), "ERROR%QUOTE(:)", "_n_= ", false).addSourceCode("%rcSetDS(5);\n").addSourceCode("call execute('" + RB.getStringResource("TableLoaderTransformModel.ModifyFailed.InvalidStatement.msg.notrans") + ";');\n").addSourceCode("stop;\n").unIndent().addSourceCode("end;\n").addSourceCode("else\n").addSourceCode("do;\n").indent().addSourceCode("if _failCnt le %sysfunc(getOption(ERROR)) then\n").addSourceCode("do;\n").indent().addSourceCode("if _iorcmsg=:'ERROR' then _iorcmsg=\"WARNING%QUOTE(:) \" || substr(_iorcmsg,8); put _iorcmsg '  ' _n_=;\n").addSourceCode("if _failCnt=1 then\n").addSourceCode("do;\n").indent().addSourceCode("%rcSetDS(4);\n").unIndent().addSourceCode("end;\n").addSourceCode("if _failCnt eq %sysfunc(getOption(ERROR)) then\n").indent().genPutStatement(RB.getStringResource("TableLoaderTransformModel.ModifyFailed.LimitSetByErrorsReached.msg.notrans"), "WARNING%QUOTE(:)", false).unIndent().unIndent().addSourceCode("end;\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("end;\n").unIndent().addSourceCode("%mend etls_checkModifyRC; \n\n");
        return codeSegment;
    }

    protected StringBuffer getSQLInsertUpdateTargetOptions(ICodeSegment codeSegment) {
        StringBuffer opts = new StringBuffer();
        ITransformTableOptions targetOptions = this.getTableOptionObject(this.getTargetTable(), false);
        PhysicalTablePromptModelCollection c = targetOptions.getOptionModel();
        if (c != null) {
            IPromptDefinitionValue v = c.findDefinition("DBCREATE_TABLE_OPTS");
            ArrayList<IPromptDefinitionValue> lSources = new ArrayList<IPromptDefinitionValue>(Arrays.asList(c.getDefinitions()));
            if (v != null) {
                lSources.remove(v);
                IPromptDefinitionValue[] defsList = lSources.toArray(new IPromptDefinitionValue[lSources.size()]);
                opts.append(targetOptions.getTableOptions(false, null, this.getDataTableOptions(), codeSegment.getCurrentServer(), defsList));
                return opts;
            }
        }
        opts.append(targetOptions.getTableOptions(false, null, this.getDataTableOptions(), codeSegment.getCurrentServer()));
        return opts;
    }

    protected ICodeSegment loadWithSQLInsert(ICodeSegment codeSegment, IPhysicalTable table, boolean bValidate) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        List<IColumn> columnList = Arrays.asList(table.getColumns());
        String colList = codeSegment.makeColumnList(columnList, false, "    ", false, ",", "", codeSegment.isQuoting(), "", false);
        String inputTable = "&etls_lastTable";
        String gen_opts = this.getSQLInsertUpdateTargetOptions(codeSegment).toString().trim();
        codeSegment.addSourceCode("proc sql ");
        if (bValidate) {
            codeSegment.addSourceCode("noexec ");
        }
        codeSegment.addSourceCode(table.getDBMSType().getSQLInsertOptions()).addSourceCode("; \n\n").indent().addCommentLine(RB.getStringResource("TableLoaderTransformModel.InsertRecords.msg.notrans"));
        codeSegment.addSourceCode("insert into ").addSourceCode(tableName).addSourceCode(" \n").indent().addSourceCode("(");
        if (gen_opts.length() > 0) {
            codeSegment.addSourceCode(gen_opts.toString() + ", \n  ");
        }
        codeSegment.addSourceCode(colList).addSourceCode(")\n").addSourceCode("select \n").addSourceCode(codeSegment.getIndentString()).addSourceCode(" ").addSourceCode(colList).addSourceCode("\n").indent().addSourceCode("from " + inputTable + " (&etls_tableOptions) \n").unIndent().unIndent().addSourceCode("; \n\n");
        codeSegment.unIndent().addSourceCode("quit;\n\n").genPushDownMacroCode().genRCSetCall("&sqlrc");
        table.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, table);
        return codeSegment;
    }

    protected ICodeSegment loadWithSQLUpdateInsert(ICodeSegment codeSegment, IPhysicalTable targetTable, boolean bValidate) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        String columnName;
        int i;
        boolean allowUpdates = true;
        String tableName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
        List<IColumn> columnList = Arrays.asList(targetTable.getColumns());
        String colList = codeSegment.makeColumnList(columnList, false, "    ", false, ",", "", codeSegment.isQuoting(), "", false);
        String inputTable = "&etls_lastTable";
        String whereMTTab1 = "                    ";
        String whereMTTab2 = whereMTTab1 + "     ";
        StringBuffer whereMT = new StringBuffer(whereMTTab1 + "where");
        StringBuffer whereMT2 = new StringBuffer(whereMT);
        StringBuffer setStatement = new StringBuffer("set");
        List keyModelList = this.getMatchingColumnsList();
        if (keyModelList.size() <= 0) {
            throw new CodegenException(RB.getStringResource("TableLoaderTransformModel.ReasonIncomplete.NoByColumns.txt"), (IObject)this);
        }
        ArrayList<String> keyColumnsXList = new ArrayList<String>();
        ArrayList<String> keyColNamesCGList = new ArrayList<String>();
        ArrayList<String> nonKeyColNamesCGList = new ArrayList<String>();
        ArrayList<Integer> nonKeyColTypesList = new ArrayList<Integer>();
        ArrayList<IColumn> nonKeyColsList = new ArrayList<IColumn>();
        List<IColumn> unmappedColumnList = Arrays.asList(this.getOrdinaryUnmappedTargetColumns(null));
        boolean skipUnmapped = !this.isUnmappedEqMissingInUpdate();
        for (int j = 0; j < keyModelList.size(); ++j) {
            String colName = ((IColumn)keyModelList.get(j)).getColumnName(codeSegment.isQuoting());
            keyColumnsXList.add(colName);
        }
        for (i = 0; i < columnList.size(); ++i) {
            IColumn col = columnList.get(i);
            columnName = DBMSNamesUtil.getQuotedColumnName(col, codeSegment.isQuoting(), false);
            int index = keyColumnsXList.indexOf(col.getColumnName(codeSegment.isQuoting()));
            if (index < 0) {
                nonKeyColsList.add(col);
                nonKeyColNamesCGList.add(columnName);
                nonKeyColTypesList.add(new Integer(col.getType()));
                continue;
            }
            keyColNamesCGList.add(columnName);
        }
        if (keyColNamesCGList.size() <= 0) {
            throw new CodegenException(RB.getStringResource("TableLoaderTransformModel.ReasonIncomplete.NoByColumns.txt"), (IObject)this);
        }
        for (i = 0; i < keyColNamesCGList.size(); ++i) {
            String key = (String)keyColNamesCGList.get(i);
            if (i > 0) {
                whereMT.append(" and \n" + whereMTTab2);
                whereMT2.append(" and \n" + whereMTTab2);
            }
            whereMT.append(" m." + key + "=t." + key);
            whereMT2.append(" m." + key + "=t2." + key);
        }
        ILibrary targetLibrary = targetTable.getLibrary();
        this.addGlobalToLibname(codeSegment, targetLibrary, targetTable);
        if (allowUpdates) {
            targetTable.getDBMSType().genMatchingRowsPrelim(codeSegment);
        }
        codeSegment.addSourceCode("proc sql ");
        if (bValidate) {
            codeSegment.addSourceCode("noexec ");
        }
        codeSegment.addSourceCode(targetTable.getDBMSType().getSQLInsertOptions()).addSourceCode("; \n").indent();
        if (allowUpdates) {
            for (int i2 = 0; i2 < nonKeyColNamesCGList.size(); ++i2) {
                columnName = (String)nonKeyColNamesCGList.get(i2);
                IColumn col = (IColumn)nonKeyColsList.get(i2);
                if (skipUnmapped && unmappedColumnList.contains(col)) continue;
                String columnExpression = columnName;
                if (!setStatement.toString().equals("set")) {
                    setStatement.append(",\n      ");
                }
                if (!this.isNoMissingCheck()) {
                    columnExpression = "case when t." + columnName + "=" + ((Integer)nonKeyColTypesList.get(i2) == 0 ? "\"\"" : ".") + " then m." + columnName + " else t." + columnName + " end";
                }
                setStatement.append(" " + columnName + " = (select distinct " + columnExpression + " from &etls_lastTable as t \n" + whereMT + ")");
            }
            codeSegment.addCommentLine(RB.getStringResource("TableLoaderTransformModel.UpdateRecords.msg.notrans")).addSourceCode("update ").addSourceCode(tableName).addSourceCode(" as m\n").indent().addSourceCode(setStatement.toString()).addSourceCode("\n").indent().unIndent().unIndent();
            codeSegment.addSourceCode("where exists").addSourceCode("\n").indent().indent().addSourceCode("(select 1 ").addSourceCode("from &etls_lastTable as t2").addSourceCode("\n").addSourceCode(whereMT2).addSourceCode(")").addSourceCode("\n").unIndent().unIndent().addSourceCode(";\n\n");
        }
        codeSegment.addCommentLine(RB.getStringResource("TableLoaderTransformModel.InsertRecords.msg.notrans"));
        codeSegment.addSourceCode("insert into ").addSourceCode(tableName).addSourceCode(" \n").indent().addSourceCode("(");
        codeSegment.addSourceCode(colList).addSourceCode(")\n").addSourceCode("select \n").addSourceCode(codeSegment.getIndentString()).addSourceCode(" ").addSourceCode(colList).addSourceCode("\n").indent().addSourceCode(" from &etls_lastTable as t \n").indent().addSourceCode("where not exists \n").addSourceCode("   (select 1 from ").addSourceCode(tableName).addSourceCode(" as m \n").addSourceCode(whereMT.toString()).addSourceCode(")\n").unIndent().unIndent().addSourceCode("; \n\n");
        codeSegment.unIndent().addSourceCode("quit;\n\n").genPushDownMacroCode().genRCSetCall("&sqlrc");
        targetTable.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, targetTable);
        return codeSegment;
    }

    public ICodeSegment addGlobalToLibname(ICodeSegment codeSegment, ILibrary library, IPhysicalTable table) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        codeSegment = library.genAccessPathTemporary(table, codeSegment, GLOBAL, true);
        return codeSegment;
    }

    protected ICodeSegment loadWithUpsert(ICodeSegment codeSegment, IPhysicalTable table, List matchColumnList, boolean unmappedEqMissingInUpdate, List unmappedColumnList) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        table.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, table);
        return table.getDBMSType().loadWithUpsert(codeSegment, table, matchColumnList, unmappedEqMissingInUpdate, unmappedColumnList, this.getDataTableOptions(), this);
    }

    protected ICodeSegment loadWithAppend(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        this.append(codeSegment, table, false, this.getDataTableOptions());
        table.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, table);
        return codeSegment;
    }

    protected ICodeSegment loadWithSQLMatching(ICodeSegment codeSegment, IPhysicalTable table, boolean allowUpdates, boolean needNewRowsTable) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        int i;
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        List<IColumn> columnList = Arrays.asList(table.getColumns());
        StringBuffer gen_opts = new StringBuffer();
        ITransformTableOptions targetOptions = this.getTableOptionObject(table, false);
        String targetDataOptions = targetOptions.getTableOptions(true, null, this.getDataTableOptions(), codeSegment.getCurrentServer());
        gen_opts.append(targetDataOptions);
        String whereMTTab1 = "                    ";
        String whereMTTab2 = whereMTTab1 + "     ";
        StringBuffer whereMT = new StringBuffer(whereMTTab1 + "where");
        StringBuffer whereT = new StringBuffer("where");
        StringBuffer setStatement = new StringBuffer("set");
        IColumn[] keyModelList = this.getMatchingColumns();
        if (keyModelList == null || keyModelList.length == 0) {
            throw new CodegenException(RB.getStringResource("TableLoaderTransformModel.ReasonIncomplete.NoByColumns.txt"), (IObject)this);
        }
        ArrayList<String> keyColumnsXList = new ArrayList<String>();
        ArrayList<String> nonKeyColNamesCGList = new ArrayList<String>();
        ArrayList<Integer> nonKeyColTypesList = new ArrayList<Integer>();
        ArrayList<IColumn> nonKeyColsList = new ArrayList<IColumn>();
        for (int j = 0; j < keyModelList.length; ++j) {
            String colName = keyModelList[j].getColumnName(codeSegment.isQuoting());
            keyColumnsXList.add(colName);
        }
        for (i = 0; i < columnList.size(); ++i) {
            IColumn col = columnList.get(i);
            String columnName = DBMSNamesUtil.getQuotedColumnName(col, codeSegment.isQuoting(), false);
            int index = keyColumnsXList.indexOf(col.getColumnName(codeSegment.isQuoting()));
            if (index >= 0) continue;
            nonKeyColsList.add(col);
            nonKeyColNamesCGList.add(columnName);
            nonKeyColTypesList.add(new Integer(col.getType()));
        }
        for (i = 0; i < keyModelList.length; ++i) {
            IColumn columnKey = keyModelList[i];
            String key = DBMSNamesUtil.getQuotedColumnName(columnKey, codeSegment.isQuoting(), false);
            if (i > 0) {
                whereMT.append(" and \n" + whereMTTab2);
            }
            whereMT.append(" m." + key + " = t." + key);
            if (i != 0) continue;
            whereT.append(" exists (select * from &etls_lastTable as t");
        }
        if (allowUpdates) {
            table.getDBMSType().genMatchingRowsPrelim(codeSegment);
        }
        codeSegment.addSourceCode("proc sql ").addSourceCode(table.getDBMSType().getSQLInsertOptions()).addSourceCode("; \n").indent();
        if (allowUpdates) {
            List<IColumn> unmappedColumnList = Arrays.asList(this.getOrdinaryUnmappedTargetColumns(null));
            boolean skipUnmapped = !this.isUnmappedEqMissingInUpdate();
            for (int i2 = 0; i2 < nonKeyColsList.size(); ++i2) {
                String columnName = (String)nonKeyColNamesCGList.get(i2);
                IColumn col = (IColumn)nonKeyColsList.get(i2);
                if (skipUnmapped && unmappedColumnList.contains(col)) continue;
                String columnExpression = columnName;
                if (!setStatement.toString().equals("set")) {
                    setStatement.append(",\n      ");
                }
                if (!this.isNoMissingCheck()) {
                    columnExpression = "case when t." + columnName + "=" + ((Integer)nonKeyColTypesList.get(i2) == 0 ? "\"\"" : ".") + " then m." + columnName + " else t." + columnName + " end";
                }
                setStatement.append(" " + columnName + " = (select " + columnExpression + " from &etls_lastTable as t \n" + whereMT + ")");
            }
            codeSegment.addCommentLine(RB.getStringResource("TableLoaderTransformModel.UpdateRecords.msg.notrans")).addSourceCode("update ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" as m\n").indent().addSourceCode(setStatement.toString()).addSourceCode("\n").indent().addSourceCode(whereT).addSourceCode("\n").addSourceCode(whereMT.toString() + ")").unIndent().unIndent().addSourceCode(";\n\n");
        }
        if (needNewRowsTable) {
            String sTargetReadOptions = "\n" + table.getReadTableOptions(true);
            codeSegment.addCommentLine(RB.getStringResource("TableLoaderTransformModel.CreateTempTable.msg.notrans")).addSourceCode("create table etls_newrecords as \n").indent().addSourceCode("select * \n").indent().addSourceCode("from &etls_lastTable as t \n").indent().addSourceCode("where not exists \n").addSourceCode("   (select * from ").addSourceCode(tableName).addSourceCode(sTargetReadOptions).addSourceCode(" as m \n").addSourceCode(whereMT.toString()).addSourceCode(")\n").unIndent().unIndent().unIndent().addSourceCode("; \n\n").unIndent().addSourceCode("quit;\n\n").addSourceCode("%let etls_lastTable = &SYSLAST;\n\n");
        } else {
            codeSegment.unIndent().addSourceCode("quit;\n\n");
        }
        codeSegment.genPushDownMacroCode();
        codeSegment.genRCSetCall("&sqlrc");
        table.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, table);
        return codeSegment;
    }

    protected IIndex getIndexMatchingMatchColumns(IPhysicalTable target) {
        IIndex indexMatchingMatchColumns = null;
        int indexSize = target.getIndexesList().size();
        for (int i = 0; i < indexSize; ++i) {
            IIndex index = target.getIndexes()[i];
            List colList = null;
            colList = index.getColumnsList();
            if (this.getMatchingColumnsList().size() != colList.size()) continue;
            int columnSize = colList.size();
            boolean matchFound = true;
            for (int j = 0; j < columnSize; ++j) {
                if (colList.get(j) == this.getMatchingColumnsList().get(j)) continue;
                matchFound = false;
                break;
            }
            if (!matchFound) continue;
            indexMatchingMatchColumns = index;
            break;
        }
        return indexMatchingMatchColumns;
    }

    protected ICodeSegment updateCIPreLoad(ICodeSegment codeSegment, IPhysicalTable table, boolean wrapInElseLogic, IIndex indexToKeep) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IDBMSType tableDBMSType = table.getDBMSType();
        if (this.isSyncCIPreLoadNeeded()) {
            boolean bSyncPostNeeded = this.isSyncCIPostLoadNeeded();
            if (bSyncPostNeeded) {
                tableDBMSType.syncCISetup(codeSegment, table, indexToKeep, this.getCIActionsString(",", true));
            }
            if (wrapInElseLogic && !bSyncPostNeeded) {
                codeSegment.addSourceCode("%else \n");
            } else {
                codeSegment.addSourceCode("%if (&etls_tableExist = 1) %then \n");
            }
            codeSegment.addSourceCode("%do;  /* table exists */ \n\n").indent();
            if (!bSyncPostNeeded) {
                tableDBMSType.syncCISetup(codeSegment, table, indexToKeep, this.getCIActionsString(",", true));
            }
            tableDBMSType.syncCIPreLoad(codeSegment, table, this.isConstraintEnabled() && this.getConstraintBeforeValue().equals(CI_ACTION_OFF), this.isConstraintEnabled() && this.getConstraintBeforeValue().equals(CI_ACTION_ON), this.isIndexEnabled() && this.getIndexBeforeValue().equals(CI_ACTION_OFF), this.isIndexEnabled() && this.getIndexBeforeValue().equals(CI_ACTION_ON));
            codeSegment.unIndent().addSourceCode("%end;  /* table exists */ \n\n");
        } else if (this.isConstraintEnabled() && this.getConstraintBeforeValue().equals(CI_ACTION_OFF) || this.isIndexEnabled() && this.getIndexBeforeValue().equals(CI_ACTION_OFF)) {
            if (wrapInElseLogic) {
                codeSegment.addSourceCode("%else \n");
            } else {
                codeSegment.addSourceCode("%if (&etls_tableExist = 1) %then \n");
            }
            codeSegment.addSourceCode("%do;  /* table exists */ \n\n").indent();
            tableDBMSType.dropCI(codeSegment, table, this.isConstraintEnabled() && this.getConstraintBeforeValue().equals(CI_ACTION_OFF), this.isIndexEnabled() && this.getIndexBeforeValue().equals(CI_ACTION_OFF), indexToKeep);
            codeSegment.unIndent().addSourceCode("%end;  /* table exists */ \n\n");
        }
        return codeSegment;
    }

    protected ICodeSegment updateCIPostLoad(ICodeSegment codeSegment, IPhysicalTable table, IIndex indexToKeep) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        boolean addPctIfLogic;
        if (!this.isCIPostLoadNeeded()) {
            return codeSegment;
        }
        String sProceedWithCIPostLoadMsg = "proceed with any post-load constraints and indexing";
        codeSegment.addSectionComment(sProceedWithCIPostLoadMsg);
        codeSegment.addSourceCode(codeSegment.getIfInSyntaxCheckMode(false, false)).addSourceCode(" %then \n");
        codeSegment.indent().genPercentPutStatement(RB.getStringResource("TableLoaderTransformModel.SkippedProcessingCI.note.sasmacro.notrans") + "\n\n").unIndent().addSourceCode("%else \n").addSourceCode("%do; \n").indent();
        IDBMSType tableDBMSType = table.getDBMSType();
        boolean bSyncCIPostLoadNeeded = this.isSyncCIPostLoadNeeded();
        String indexActionNeeded = this.getPostLoadIActionNeeded();
        String constraintActionNeeded = this.getPostLoadCActionNeeded();
        if (!bSyncCIPostLoadNeeded && !indexActionNeeded.equals("NONE") || this.getIndexAfterValue().equals(CI_ACTION_INITIAL_LOAD)) {
            boolean bl = addPctIfLogic = this.getIndexAfterValue().equals(CI_ACTION_INITIAL_LOAD) && !this.isReplacingEntireTable();
            if (addPctIfLogic) {
                codeSegment.addSourceCode("%if not &etls_tableExist %then \n").addSourceCode("%do; \n").indent();
            }
            if (indexActionNeeded.equals(CI_ACTION_NEEDED_DROP)) {
                tableDBMSType.dropIndexes(codeSegment, table, null);
            } else if (indexActionNeeded.equals(CI_ACTION_NEEDED_CREATE)) {
                List indexList = tableDBMSType.getIndexesToCreate(table);
                if (indexToKeep != null && this.getIndexBeforeValue().equals(CI_ACTION_OFF)) {
                    for (int i = indexList.size() - 1; i >= 0; --i) {
                        IIndex ind = (IIndex)indexList.get(i);
                        if (!ind.getName().equals(indexToKeep.getName())) continue;
                        indexList.remove(i);
                    }
                }
                tableDBMSType.createIndexes2(codeSegment, table, indexList, "");
            }
            if (addPctIfLogic) {
                codeSegment.unIndent().addSourceCode("%end; \n");
            }
        }
        if (bSyncCIPostLoadNeeded) {
            if (!this.isSyncCIPreLoadNeeded()) {
                tableDBMSType.syncCISetup(codeSegment, table, indexToKeep, this.getCIActionsString(",", true));
            }
            tableDBMSType.syncCIPostLoad(codeSegment, table, indexToKeep, this.isConstraintEnabled() && this.getConstraintBeforeValue().equals(CI_ACTION_OFF), this.isConstraintEnabled() && this.getConstraintAfterValue().equals(CI_ACTION_ON), this.isConstraintEnabled() && this.getConstraintAfterValue().equals(CI_ACTION_OFF), this.isIndexEnabled() && this.getIndexBeforeValue().equals(CI_ACTION_OFF), this.isIndexEnabled() && this.getIndexAfterValue().equals(CI_ACTION_ON), this.isIndexEnabled() && this.getIndexAfterValue().equals(CI_ACTION_OFF));
        }
        if (!bSyncCIPostLoadNeeded && !constraintActionNeeded.equals("NONE") || this.getConstraintAfterValue().equals(CI_ACTION_INITIAL_LOAD)) {
            boolean bl = addPctIfLogic = this.getConstraintAfterValue().equals(CI_ACTION_INITIAL_LOAD) && !this.isReplacingEntireTable();
            if (addPctIfLogic) {
                codeSegment.addSourceCode("%if not &etls_tableExist %then \n").addSourceCode("%do; /* table didn't exist */ \n").indent();
            }
            if (constraintActionNeeded.equals(CI_ACTION_NEEDED_DROP)) {
                tableDBMSType.dropConstraints(codeSegment, table);
            } else if (constraintActionNeeded.equals(CI_ACTION_NEEDED_CREATE)) {
                tableDBMSType.createConstraints(codeSegment, table);
            }
            if (addPctIfLogic) {
                codeSegment.unIndent().addSourceCode("%end; /* table didn't exist */ \n");
            }
        }
        codeSegment.unIndent().addSourceCode("%end; ").addCommentLine(sProceedWithCIPostLoadMsg).addSourceCode(" \n");
        return codeSegment;
    }

    protected String booleanToYesNo(boolean bool) {
        return bool ? "YES" : "NO";
    }

    protected boolean yesNoToBoolean(String YesNo) {
        return YesNo.equalsIgnoreCase("YES");
    }

    protected class cLoaderOptionModel
    extends BaseLoaderPromptModel
    implements IPromptModel {
        public cLoaderOptionModel(IModel model, ILoaderTransform owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            IPromptDefinitionValue frcDefinition;
            super(model, owner);
            IPromptDefinitionValue dbiDefinition = this.getPromptDefinitionValue("OPTION_DBI_DIRECT_EXEC");
            if (dbiDefinition != null) {
                dbiDefinition.setHidden(false);
                dbiDefinition.setDefaultValue(TableLoaderTransformModel.this.getDefaultDBIDirectExecValue());
            }
            if ((frcDefinition = this.getPromptDefinitionValue("APPENDFORCE")) != null) {
                frcDefinition.setHidden(false);
            }
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cLoaderOptionModel.class.getResource("res/Options_TableLoader_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected IModelListener createModelListener() {
            return new cLoaderModelListener((TableLoaderTransformModel)this.getOwner());
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            TableLoaderTransformModel tl = (TableLoaderTransformModel)this.getOwner();
            this.setOptionValue(TableLoaderTransformModel.DATATABLE_OPTIONS, (Object)tl.getDataTableOptions());
            this.setOptionValue(TableLoaderTransformModel.PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE, (Object)tl.booleanToYesNo(tl.isUnmappedEqMissingInUpdate()));
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new LoaderTransformValueChangedListener((TableLoaderTransformModel)this.getOwner(), this);
        }

        private class cLoaderModelListener
        extends BaseLoaderModelListener {
            public cLoaderModelListener(TableLoaderTransformModel transform) {
                super(transform, (IPromptModel)cLoaderOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(TableLoaderTransformModel.DATA_TABLE_OPTIONS_CHANGED)) {
                        cLoaderOptionModel.this.setOptionValue(TableLoaderTransformModel.DATATABLE_OPTIONS, (Object)TableLoaderTransformModel.this.getDataTableOptions());
                    } else if (type.equals(TableLoaderTransformModel.UNMAPPEDEQMISSINGINUPDATE_CHANGED)) {
                        cLoaderOptionModel.this.setOptionValue(TableLoaderTransformModel.PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE, (Object)TableLoaderTransformModel.this.booleanToYesNo(TableLoaderTransformModel.this.isUnmappedEqMissingInUpdate()));
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class LoaderTransformValueChangedListener
        extends BaseLoaderTransformValueChangedListener {
            public LoaderTransformValueChangedListener(TableLoaderTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals(TableLoaderTransformModel.DATATABLE_OPTIONS)) {
                        TableLoaderTransformModel.this.setDataTableOptions(value.toString());
                    } else if (optionName.equals(TableLoaderTransformModel.PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE)) {
                        TableLoaderTransformModel.this.setUnmappedEqMissingInUpdate(((TableLoaderTransformModel)this.getOwner()).yesNoToBoolean(value.toString()));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class SetDataTableOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetDataTableOptionsUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setDataTableOptions(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setDataTableOptions(this.m_newValue);
        }
    }

    private class SetLoadStyleUndoable
    extends AbstractUndoableEdit {
        private String m_oldsLoadStyle;
        private String m_newsLoadStyle;

        public SetLoadStyleUndoable(String oldsStyle, String newsStyle) {
            this.m_oldsLoadStyle = oldsStyle;
            this.m_newsLoadStyle = newsStyle;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setLoadStyle(this.m_oldsLoadStyle);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setLoadStyle(this.m_newsLoadStyle);
        }
    }

    private class SetReplaceTypeUndoable
    extends AbstractUndoableEdit {
        private String m_oldsReplaceType;
        private String m_newsReplaceType;

        public SetReplaceTypeUndoable(String oldStyle, String newStyle) {
            this.m_oldsReplaceType = oldStyle;
            this.m_newsReplaceType = newStyle;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setReplaceTypeImpl(this.m_oldsReplaceType);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setReplaceTypeImpl(this.m_newsReplaceType);
        }
    }

    private class SetMatchingRowsUndoable
    extends AbstractUndoableEdit {
        private String m_oldMatchingRows;
        private String m_newMatchingRows;

        public SetMatchingRowsUndoable(String oldMatchingRows, String newMatchingRows) {
            this.m_oldMatchingRows = oldMatchingRows;
            this.m_newMatchingRows = newMatchingRows;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setMatchingRowsImpl(this.m_oldMatchingRows);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setMatchingRowsImpl(this.m_newMatchingRows);
        }
    }

    private class SetNewRowsUndoable
    extends AbstractUndoableEdit {
        private String m_oldNewRows;
        private String m_newNewRows;

        public SetNewRowsUndoable(String oldNewRows, String newNewRows) {
            this.m_oldNewRows = oldNewRows;
            this.m_newNewRows = newNewRows;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setNewRowsImpl(this.m_oldNewRows);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setNewRowsImpl(this.m_newNewRows);
        }
    }

    private class SetConstraintBeforeUndoable
    extends AbstractUndoableEdit {
        private String m_oldsConstraintBefore;
        private String m_newsConstraintBefore;

        public SetConstraintBeforeUndoable(String oldsConstraint, String newsConstraint) {
            this.m_oldsConstraintBefore = oldsConstraint;
            this.m_newsConstraintBefore = newsConstraint;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setConstraintBeforeValue(this.m_oldsConstraintBefore);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setConstraintBeforeValue(this.m_newsConstraintBefore);
        }
    }

    private class SetConstraintAfterUndoable
    extends AbstractUndoableEdit {
        private String m_oldsConstraintAfter;
        private String m_newsConstraintAfter;

        public SetConstraintAfterUndoable(String oldsConstraint, String newsConstraint) {
            this.m_oldsConstraintAfter = oldsConstraint;
            this.m_newsConstraintAfter = newsConstraint;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setConstraintAfterValueImpl(this.m_oldsConstraintAfter);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setConstraintAfterValueImpl(this.m_newsConstraintAfter);
        }
    }

    private class SetIndexBeforeUndoable
    extends AbstractUndoableEdit {
        private String m_oldsIndexBefore;
        private String m_newsIndexBefore;

        public SetIndexBeforeUndoable(String oldsIndex, String newsIndex) {
            this.m_oldsIndexBefore = oldsIndex;
            this.m_newsIndexBefore = newsIndex;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setIndexBeforeValue(this.m_oldsIndexBefore);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setIndexBeforeValue(this.m_newsIndexBefore);
        }
    }

    private class SetIndexAfterUndoable
    extends AbstractUndoableEdit {
        private String m_oldsIndexAfter;
        private String m_newsIndexAfter;

        public SetIndexAfterUndoable(String oldsIndex, String newsIndex) {
            this.m_oldsIndexAfter = oldsIndex;
            this.m_newsIndexAfter = newsIndex;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setIndexAfterValueImpl(this.m_oldsIndexAfter);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setIndexAfterValueImpl(this.m_newsIndexAfter);
        }
    }

    private class SetModifyIndexUndoable
    extends AbstractUndoableEdit {
        private IIndex m_oldModifyIndex;
        private IIndex m_newModifyIndex;

        public SetModifyIndexUndoable(IIndex oldModifyIndex, IIndex newModifyIndex) {
            this.m_oldModifyIndex = oldModifyIndex;
            this.m_newModifyIndex = newModifyIndex;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setModifyIndex(this.m_oldModifyIndex);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setModifyIndex(this.m_newModifyIndex);
        }

        @Override
        public void die() {
            super.die();
            this.m_newModifyIndex = null;
            this.m_oldModifyIndex = null;
        }
    }

    private class SetNoMissingCheckUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldbNoMissingCheck;
        private boolean m_newbNoMissingCheck;

        public SetNoMissingCheckUndoable(boolean oldbNoMissingCheck, boolean newbNoMissingCheck) {
            this.m_oldbNoMissingCheck = oldbNoMissingCheck;
            this.m_newbNoMissingCheck = newbNoMissingCheck;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setNoMissingCheck(this.m_oldbNoMissingCheck);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setNoMissingCheck(this.m_newbNoMissingCheck);
        }
    }

    private class SetIndexUniqueValueUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldbIndexUniqueValue;
        private boolean m_newbIndexUniqueValue;

        public SetIndexUniqueValueUndoable(boolean oldbIndexUniqueValue, boolean newbIndexUniqueValue) {
            this.m_oldbIndexUniqueValue = oldbIndexUniqueValue;
            this.m_newbIndexUniqueValue = newbIndexUniqueValue;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setIndexUniqueValue(this.m_oldbIndexUniqueValue);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setIndexUniqueValue(this.m_newbIndexUniqueValue);
        }
    }

    private class SetUnmappedEqMissingInUpdateUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldbUnmappedEqMissing;
        private boolean m_newbUnmappedEqMissing;

        public SetUnmappedEqMissingInUpdateUndoable(boolean oldbUnmappedEqMissing, boolean newbUnmappedEqMissing) {
            this.m_oldbUnmappedEqMissing = oldbUnmappedEqMissing;
            this.m_newbUnmappedEqMissing = newbUnmappedEqMissing;
        }

        @Override
        public void undo() {
            super.undo();
            TableLoaderTransformModel.this.setUnmappedEqMissingInUpdate(this.m_oldbUnmappedEqMissing);
        }

        @Override
        public void redo() {
            super.redo();
            TableLoaderTransformModel.this.setUnmappedEqMissingInUpdate(this.m_newbUnmappedEqMissing);
        }
    }
}

