/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ISortingTransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.ISorting;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.etl.models.prompts.impl.PromptDataProvider;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SortTransformModel
extends AbstractDataTransform
implements ISortingTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.SASSort";
    private static final String TRANSFORMATION_ROLE = "com.sas.wadmin.visuals.SASSort";
    private static final String ARM_DISPLAY_NAME = "Sort";
    public static final int ALLOW_DUPLICATES = 0;
    public static final int NO_DUPLICATE_KEYS = 1;
    public static final int NO_DUPLICATE_RECORDS = 2;
    private static final String SORT_OPTIONS = "SORT";
    private static final String STABLE_OPTION = "Equals";
    private static final String STABLE_TRUE = "Default (EQUALS)";
    private static final String STABLE_FALSE = "NOEQUALS";
    private static final String REPLACE_DATASET_OPTION = "Force";
    private static final String REPLACE_DATASET_TRUE = "FORCE";
    private static final String REPLACE_DATASET_FALSE = "Default (no FORCE)";
    private static final String SORT_TAGS_OPTION = "Tagsort";
    private static final String SORT_TAGS_TRUE = "TAGSORT";
    private static final String SORT_TAGS_FALSE = "Default (no TAGSORT)";
    private static final String OVERWRITE_OPTION = "Overwrite";
    private static final String OVERWRITE_TRUE = "OVERWRITE";
    private static final String OVERWRITE_FALSE = "Default (no overwrite)";
    private static final String DUPLICATES_OPTION = "Duplicates";
    private static final String DUPLICATES_NO_DUPLICATE_KEYS = "NODUPKEY";
    private static final String DUPLICATES_NO_DUPLICATE_RECORDS = "NODUPRECS";
    private static final String DUPLICATES_ALLOW_DUPLICATES = "";
    private static final String SORT_SEQUENCE_OPTION = "sortseq";
    private static final String SORT_SIZE_OPTION = "sortsize";
    private static final String PROC_SORT_OPTIONS = "ProcSortOptions";
    public static final String STABLE_CHANGED = "SortTransform:StableChanged";
    public static final String SORT_TAGS_CHANGED = "SortTransform:SortTagsChanged";
    public static final String REPLACE_DATASET_CHANGED = "SortTransform:ReplaceDataSetChanged";
    public static final String MEMORY_SIZE_CHANGED = "SortTransform:MemorySizeChanged";
    public static final String COLLATING_SEQUENCE_CHANGED = "SortTransform:CollatingSequenceChanged";
    public static final String DUPLICATE_RECORD_HANDLING_CHANGED = "SortTransform:DuplicateRecordHandlingChanged";
    public static final String PROC_SORT_OPTIONS_CHANGED = "SortTransform:ProcSortOptionsChanged";
    public static final String OVERWRITE_OPTIONS_CHANGED = "SortTransform:OverwriteChanged";
    public static final String SORT_COLUMNS_CHANGED = "SortTransform:ColumnsChanged";
    public static final String SORT_ORDER_CHANGED = "SortTransform:SortOrderChanged";
    private boolean m_bStable = true;
    private boolean m_bSortTags = false;
    private boolean m_bReplaceDataSet = false;
    private String m_sCollatingSequenceName = "";
    private String m_sMemorySize = "";
    private String m_sProcSortOptions = "";
    private int m_eDuplicateRecordHandling = 0;
    private ISorting m_order = this.getModel().getObjectFactory().createNewSorting(this.getID());
    private boolean m_bOverwrite = false;

    public SortTransformModel(String sID, IModel model) {
        super(sID, model);
        this.m_order.addNotifyListener(this);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssoc = (ArrayList<String>)map.get(this.getClassifierMapType());
        if (lAssoc == null) {
            lAssoc = new ArrayList<String>();
        }
        lAssoc.add("OrderByForSelect");
        map.put(this.getClassifierMapType(), lAssoc);
        return map;
    }

    public static String getTransformTypeID() {
        return "com.sas.wadmin.visuals.SASSort";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.wadmin.visuals.SASSort";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.wadmin.visuals.SASSort";
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("SortTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("SortTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public void addDefaultSettings() {
        this.addNewWorkTable();
    }

    @Override
    protected void preRemoveDataTarget(IDataObject target) {
        super.preRemoveDataTarget(target);
        ISortColumn[] aSortCols = this.m_order.getSortColumns();
        for (int i = 0; i < aSortCols.length; ++i) {
            ITable table = aSortCols[i].getColumn().getTable();
            if (table != target) continue;
            this.m_order.removeSortColumn(aSortCols[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            IColumn[] aNewColumns = newTable.getColumns();
            this.m_order.replaceSortColumns(aNewColumns, newTable.getTableName());
            super.replaceTargetTable(oldTable, newTable, columnsMap);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected boolean areExpressionsAllowed() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_order.isChanged();
    }

    @Override
    public void delete() {
        super.delete();
        this.getSortOrder().delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.deleteFromOMR(omr);
        this.getSortOrder().deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.getSortOrder().updateIDs(mapIDs);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && (this.isUsingUserWrittenCode() || this.m_order.isComplete());
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.isUsingUserWrittenCode() && this.m_order.size() == 0) {
            lReasons.add(RB.getStringResource("SortTransformModel.ReasonIncomplete.NoByColumn.txt"));
        }
        return lReasons;
    }

    @Override
    protected String getClassifierMapType() {
        return "Select";
    }

    public void setStable(boolean bStable) {
        if (this.m_bStable == bStable) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetStableUndoable(this.m_bStable, bStable));
        }
        this.m_bStable = bStable;
        this.fireModelChangedEvent(STABLE_CHANGED, null);
    }

    public boolean isStable() {
        return this.m_bStable;
    }

    public void setOverwrite(boolean bOverwrite) {
        if (this.m_bOverwrite == bOverwrite) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOverwriteUndoable(this.m_bOverwrite, bOverwrite));
        }
        this.m_bOverwrite = bOverwrite;
        this.fireModelChangedEvent(OVERWRITE_OPTIONS_CHANGED, null);
    }

    public boolean isOverwrite() {
        return this.m_bOverwrite;
    }

    public void setReplaceDataSet(boolean bReplace) {
        if (this.m_bReplaceDataSet == bReplace) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetReplaceDataSetUndoable(this.m_bReplaceDataSet, bReplace));
        }
        this.m_bReplaceDataSet = bReplace;
        this.fireModelChangedEvent(REPLACE_DATASET_CHANGED, null);
    }

    public boolean isReplaceDataSet() {
        return this.m_bReplaceDataSet;
    }

    public void setSortTags(boolean bSortTags) {
        if (this.m_bSortTags == bSortTags) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSortTagsUndoable(this.m_bSortTags, bSortTags));
        }
        this.m_bSortTags = bSortTags;
        this.fireModelChangedEvent(SORT_TAGS_CHANGED, null);
    }

    public boolean isSortTags() {
        return this.m_bSortTags;
    }

    public void setMemorySize(String sSize) {
        if (this.m_sMemorySize.equals(sSize)) {
            return;
        }
        if (sSize == null) {
            throw new NullPointerException("size must not be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMemorySizeUndoable(this.m_sMemorySize, sSize));
        }
        this.m_sMemorySize = sSize;
        this.fireModelChangedEvent(MEMORY_SIZE_CHANGED, null);
    }

    public String getMemorySize() {
        return this.m_sMemorySize;
    }

    public void setCollatingSequence(String sSequenceName) {
        if (this.m_sCollatingSequenceName.equals(sSequenceName)) {
            return;
        }
        if (sSequenceName == null) {
            throw new NullPointerException("collating sequence must not be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCollatingSequenceUndoable(this.m_sCollatingSequenceName, sSequenceName));
        }
        this.m_sCollatingSequenceName = sSequenceName;
        this.fireModelChangedEvent(COLLATING_SEQUENCE_CHANGED, null);
    }

    public String getCollatingSequence() {
        return this.m_sCollatingSequenceName;
    }

    public void setDuplicateRecordHandling(int eDuplicateRecordHandling) {
        if (this.m_eDuplicateRecordHandling == eDuplicateRecordHandling) {
            return;
        }
        if (eDuplicateRecordHandling != 0 && eDuplicateRecordHandling != 1 && eDuplicateRecordHandling != 2) {
            throw new IllegalArgumentException("Invalid duplicate record handling value: " + eDuplicateRecordHandling);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDuplicateRecordHandlingUndoable(this.m_eDuplicateRecordHandling, eDuplicateRecordHandling));
        }
        this.m_eDuplicateRecordHandling = eDuplicateRecordHandling;
        this.fireModelChangedEvent(DUPLICATE_RECORD_HANDLING_CHANGED, null);
    }

    public int getDuplicateRecordHandling() {
        return this.m_eDuplicateRecordHandling;
    }

    public void setProcSortOptions(String sOptions) {
        if (this.m_sProcSortOptions.equals(sOptions)) {
            return;
        }
        if (sOptions == null) {
            throw new NullPointerException("sort options must not be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetProcSortOptionsUndoable(this.m_sProcSortOptions, sOptions));
        }
        this.m_sProcSortOptions = sOptions;
        this.fireModelChangedEvent(PROC_SORT_OPTIONS_CHANGED, null);
    }

    public String getProcSortOptions() {
        return this.m_sProcSortOptions;
    }

    @Override
    public ISorting getSortOrder() {
        return this.m_order;
    }

    public void setSortOrder(ISorting sort) {
        if (sort == null) {
            throw new IllegalArgumentException("sort order cannot be null");
        }
        if (this.m_order == sort) {
            return;
        }
        if (this.m_order != null) {
            this.m_order.removeNotifyListener(this);
            this.addToDeletedObjects(this.m_order);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSortOrderChangedUndoable(this.m_order, sort));
        }
        this.m_order = sort;
        if (this.m_order != null) {
            this.m_order.addNotifyListener(this);
            this.removeFromDeletedObjects(this.m_order);
        }
        this.fireModelChangedEvent(SORT_ORDER_CHANGED, this.m_order);
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cSortOptionModel();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        String sSortTags;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        String sStable = this.m_bStable ? STABLE_TRUE : STABLE_FALSE;
        String sReplace = this.m_bReplaceDataSet ? REPLACE_DATASET_TRUE : REPLACE_DATASET_FALSE;
        String string = sSortTags = this.m_bSortTags ? SORT_TAGS_TRUE : SORT_TAGS_FALSE;
        String sDuplicates = this.m_eDuplicateRecordHandling == 1 ? DUPLICATES_NO_DUPLICATE_KEYS : (this.m_eDuplicateRecordHandling == 2 ? DUPLICATES_NO_DUPLICATE_RECORDS : DUPLICATES_ALLOW_DUPLICATES);
        String sOverwrite = this.m_bOverwrite ? OVERWRITE_TRUE : OVERWRITE_FALSE;
        this.savePropertyToOMR(omr, "OPTIONS", STABLE_OPTION, STABLE_OPTION, SORT_OPTIONS, sStable, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", REPLACE_DATASET_OPTION, REPLACE_DATASET_OPTION, SORT_OPTIONS, sReplace, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", SORT_TAGS_OPTION, SORT_TAGS_OPTION, SORT_OPTIONS, sSortTags, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", DUPLICATES_OPTION, DUPLICATES_OPTION, SORT_OPTIONS, sDuplicates, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", "Sortseq", SORT_SEQUENCE_OPTION, SORT_OPTIONS, this.m_sCollatingSequenceName, 12, 18);
        this.savePropertyToOMR(omr, "OPTIONS", "Sortsize", SORT_SIZE_OPTION, SORT_OPTIONS, this.m_sMemorySize, 12, 18);
        this.savePropertyToOMR(omr, "OPTIONS", "PROC SORT Options", PROC_SORT_OPTIONS, SORT_OPTIONS, this.m_sProcSortOptions, 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", OVERWRITE_OPTION, OVERWRITE_OPTION, SORT_OPTIONS, sOverwrite, 12, 2);
        ISorting sortOrder = this.getSortOrder();
        sortOrder.saveToOMR(omr);
        OrderByClause mdoOrder = (OrderByClause)omr.acquireOMRObject(sortOrder);
        Select mdoSelect = (Select)this.getClassifierMapObject(omr);
        mdoSelect.setOrderByForSelect(mdoOrder);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        String sStable = this.loadPropertyFromOMR(omr, "OPTIONS", STABLE_OPTION, STABLE_TRUE, 2);
        String sReplace = this.loadPropertyFromOMR(omr, "OPTIONS", REPLACE_DATASET_OPTION, REPLACE_DATASET_FALSE, 2);
        String sSortTags = this.loadPropertyFromOMR(omr, "OPTIONS", SORT_TAGS_OPTION, SORT_TAGS_FALSE, 2);
        String sDuplicates = this.loadPropertyFromOMR(omr, "OPTIONS", DUPLICATES_OPTION, DUPLICATES_ALLOW_DUPLICATES, 2);
        String sOverwrite = this.loadPropertyFromOMR(omr, "OPTIONS", OVERWRITE_OPTION, OVERWRITE_FALSE, 2);
        this.setStable(!sStable.equals(STABLE_FALSE));
        this.setReplaceDataSet(sReplace.equals(REPLACE_DATASET_TRUE));
        this.setSortTags(sSortTags.equals(SORT_TAGS_TRUE));
        this.setOverwrite(sOverwrite.equals(OVERWRITE_TRUE));
        this.setDuplicateRecordHandling(sDuplicates.equals(DUPLICATES_NO_DUPLICATE_KEYS) ? 1 : (sDuplicates.equals(DUPLICATES_NO_DUPLICATE_RECORDS) ? 2 : 0));
        this.setCollatingSequence(this.loadPropertyFromOMR(omr, "OPTIONS", SORT_SEQUENCE_OPTION, DUPLICATES_ALLOW_DUPLICATES, 2));
        this.setMemorySize(this.loadPropertyFromOMR(omr, "OPTIONS", SORT_SIZE_OPTION, DUPLICATES_ALLOW_DUPLICATES, 2));
        this.setProcSortOptions(this.loadPropertyFromOMR(omr, "OPTIONS", PROC_SORT_OPTIONS, DUPLICATES_ALLOW_DUPLICATES, 2));
        Select mdoSelect = (Select)this.getClassifierMapObject(omr);
        OrderByClause mdoOrder = mdoSelect.getOrderByForSelect();
        if (mdoOrder != null) {
            this.setSortOrder((ISorting)omr.acquireObject((Root)mdoOrder));
        }
        this.setChanged(false);
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() == this.m_order && ev.getType() == 1) {
            this.fireModelChangedEvent(SORT_COLUMNS_CHANGED, null);
        }
        super.notify(ev);
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        StringBuffer sortOptions = null;
        IPromptModel sortOptionModel = null;
        try {
            sortOptionModel = this.getOptionModel();
            sortOptions = sortOptionModel.getOptionsString(codeSegment, SORT_OPTIONS);
            this.genTableDelete(codeSegment, target);
            ITransformTableOptions sourceOptions = this.getTableOptionObject(source, true);
            String sourceTableOptions = sourceOptions.getTableOptions(codeSegment.getCurrentServer());
            boolean mappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, target);
            String mappingStepOutputName = DUPLICATES_ALLOW_DUPLICATES;
            if (mappingNeeded) {
                mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
                this.getOrdinaryMappingCode(codeSegment, source, target, mappingStepOutputName, "&SYSLAST", sourceTableOptions, null, true, true, true, null, null, false, null, null, null);
            }
            codeSegment.addSourceCode("proc sort data = &SYSLAST \n");
            codeSegment.indent();
            if (!mappingNeeded && sourceTableOptions.length() > 0) {
                codeSegment.indent().addSourceCode("(" + sourceTableOptions + ") \n").unIndent();
            }
            codeSegment.addSourceCode("out = " + target.getFullNameQuotedAsNeeded(codeSegment));
            ITransformTableOptions targetOptionObj = this.getTableOptionObject(target, false);
            String targetOptions = targetOptionObj.getTableOptions(true, codeSegment.getCurrentServer());
            if (targetOptions.length() > 0) {
                codeSegment.addSourceCode("\n").indent().addSourceCode(targetOptions.trim()).unIndent();
            }
            if (sortOptions != null && sortOptions.length() > 0) {
                codeSegment.addSourceCode("\n").indent().addSourceCode(sortOptions).unIndent();
            }
            codeSegment.addSourceCode("; \n");
            this.m_order.getGeneratedCode(codeSegment, false);
            codeSegment.unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
            if (mappingNeeded && !target.isView()) {
                codeSegment.genTableDelete(mappingStepOutputName);
            }
        }
        catch (Exception e) {
            throw new CodegenException(e, (IObject)this);
        }
        return codeSegment;
    }

    private class SetStableUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldStable;
        private boolean m_newStable;

        public SetStableUndoable(boolean oldStable, boolean newStable) {
            this.m_oldStable = oldStable;
            this.m_newStable = newStable;
        }

        @Override
        public void undo() {
            super.undo();
            SortTransformModel.this.setStable(this.m_oldStable);
        }

        @Override
        public void redo() {
            super.redo();
            SortTransformModel.this.setStable(this.m_newStable);
        }
    }

    private class SetOverwriteUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldOverwrite;
        private boolean m_newOverwrite;

        public SetOverwriteUndoable(boolean oldOverwrite, boolean newOverwrite) {
            this.m_oldOverwrite = oldOverwrite;
            this.m_newOverwrite = newOverwrite;
        }

        @Override
        public void undo() {
            super.undo();
            SortTransformModel.this.setOverwrite(this.m_oldOverwrite);
        }

        @Override
        public void redo() {
            super.redo();
            SortTransformModel.this.setOverwrite(this.m_newOverwrite);
        }
    }

    private class SetReplaceDataSetUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldReplaceDataSet;
        private boolean m_newReplaceDataSet;

        public SetReplaceDataSetUndoable(boolean oldReplaceDataSet, boolean newReplaceDataSet) {
            this.m_oldReplaceDataSet = oldReplaceDataSet;
            this.m_newReplaceDataSet = newReplaceDataSet;
        }

        @Override
        public void undo() {
            super.undo();
            SortTransformModel.this.setReplaceDataSet(this.m_oldReplaceDataSet);
        }

        @Override
        public void redo() {
            super.redo();
            SortTransformModel.this.setReplaceDataSet(this.m_newReplaceDataSet);
        }
    }

    private class SetSortTagsUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldSortTags;
        private boolean m_newSortTags;

        public SetSortTagsUndoable(boolean oldSortTags, boolean newSortTags) {
            this.m_oldSortTags = oldSortTags;
            this.m_newSortTags = newSortTags;
        }

        @Override
        public void undo() {
            super.undo();
            SortTransformModel.this.setSortTags(this.m_oldSortTags);
        }

        @Override
        public void redo() {
            super.redo();
            SortTransformModel.this.setSortTags(this.m_newSortTags);
        }
    }

    private class SetMemorySizeUndoable
    extends AbstractUndoableEdit {
        private String m_oldMemorySize;
        private String m_newMemorySize;

        public SetMemorySizeUndoable(String oldMemorySize, String newMemorySize) {
            this.m_oldMemorySize = oldMemorySize;
            this.m_newMemorySize = newMemorySize;
        }

        @Override
        public void undo() {
            super.undo();
            SortTransformModel.this.setMemorySize(this.m_oldMemorySize);
        }

        @Override
        public void redo() {
            super.redo();
            SortTransformModel.this.setMemorySize(this.m_newMemorySize);
        }
    }

    private class SetCollatingSequenceUndoable
    extends AbstractUndoableEdit {
        private String m_oldCollatingSequence;
        private String m_newCollatingSequence;

        public SetCollatingSequenceUndoable(String oldCollatingSequence, String newCollatingSequence) {
            this.m_oldCollatingSequence = oldCollatingSequence;
            this.m_newCollatingSequence = newCollatingSequence;
        }

        @Override
        public void undo() {
            super.undo();
            SortTransformModel.this.setCollatingSequence(this.m_oldCollatingSequence);
        }

        @Override
        public void redo() {
            super.redo();
            SortTransformModel.this.setCollatingSequence(this.m_newCollatingSequence);
        }
    }

    private class SetDuplicateRecordHandlingUndoable
    extends AbstractUndoableEdit {
        private int m_oldDuplicateRecordHandling;
        private int m_newDuplicateRecordHandling;

        public SetDuplicateRecordHandlingUndoable(int oldDuplicateRecordHandling, int newDuplicateRecordHandling) {
            this.m_oldDuplicateRecordHandling = oldDuplicateRecordHandling;
            this.m_newDuplicateRecordHandling = newDuplicateRecordHandling;
        }

        @Override
        public void undo() {
            super.undo();
            SortTransformModel.this.setDuplicateRecordHandling(this.m_oldDuplicateRecordHandling);
        }

        @Override
        public void redo() {
            super.redo();
            SortTransformModel.this.setDuplicateRecordHandling(this.m_newDuplicateRecordHandling);
        }
    }

    private class SetProcSortOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldProcSortOptions;
        private String m_newProcSortOptions;

        public SetProcSortOptionsUndoable(String oldProcSortOptions, String newProcSortOptions) {
            this.m_oldProcSortOptions = oldProcSortOptions;
            this.m_newProcSortOptions = newProcSortOptions;
        }

        @Override
        public void undo() {
            super.undo();
            SortTransformModel.this.setProcSortOptions(this.m_oldProcSortOptions);
        }

        @Override
        public void redo() {
            super.redo();
            SortTransformModel.this.setProcSortOptions(this.m_newProcSortOptions);
        }
    }

    private class SetSortOrderChangedUndoable
    extends AbstractUndoableEdit {
        private ISorting m_oldSortOrder;
        private ISorting m_newSortOrder;

        public SetSortOrderChangedUndoable(ISorting oldSortOrder, ISorting newSortOrder) {
            this.m_oldSortOrder = oldSortOrder;
            this.m_newSortOrder = newSortOrder;
        }

        @Override
        public void undo() {
            super.undo();
            SortTransformModel.this.setSortOrder(this.m_oldSortOrder);
        }

        @Override
        public void redo() {
            super.redo();
            SortTransformModel.this.setSortOrder(this.m_newSortOrder);
        }
    }

    protected class cSortOptionModel
    extends BaseDataTransformPromptModel
    implements IPromptModel {
        public cSortOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(SortTransformModel.this.getModel(), SortTransformModel.this);
        }

        @Override
        public PromptDataProvider createDataProvider() throws ServiceException, RemoteException, MdException, ServerConnectionException {
            return null;
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cSortOptionModel.class.getResource("res/Options_SASSort_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            SortTransformModel transform = (SortTransformModel)this.getOwner();
            this.setOptionValue(SortTransformModel.OVERWRITE_OPTION, (Object)(transform.isOverwrite() ? SortTransformModel.OVERWRITE_TRUE : SortTransformModel.OVERWRITE_FALSE));
            this.setOptionValue(SortTransformModel.REPLACE_DATASET_OPTION, (Object)(transform.isReplaceDataSet() ? SortTransformModel.REPLACE_DATASET_TRUE : SortTransformModel.REPLACE_DATASET_FALSE));
            this.setDuplicateOptionValue(transform.getDuplicateRecordHandling());
            this.setOptionValue(SortTransformModel.STABLE_OPTION, (Object)(transform.isStable() ? SortTransformModel.STABLE_TRUE : SortTransformModel.STABLE_FALSE));
            this.setOptionValue(SortTransformModel.SORT_TAGS_OPTION, (Object)(transform.isSortTags() ? SortTransformModel.SORT_TAGS_TRUE : SortTransformModel.SORT_TAGS_FALSE));
            this.setOptionValue(SortTransformModel.SORT_SEQUENCE_OPTION, (Object)transform.getCollatingSequence());
            this.setOptionValue(SortTransformModel.SORT_SIZE_OPTION, (Object)transform.getMemorySize());
            this.setOptionValue(SortTransformModel.PROC_SORT_OPTIONS, (Object)transform.getProcSortOptions());
        }

        private void setDuplicateOptionValue(int duplicateHandling) throws RemoteException, MdException, ServiceException, ServerConnectionException {
            String duplicates = SortTransformModel.DUPLICATES_ALLOW_DUPLICATES;
            if (duplicateHandling == 1) {
                duplicates = SortTransformModel.DUPLICATES_NO_DUPLICATE_KEYS;
            } else if (duplicateHandling == 2) {
                duplicates = SortTransformModel.DUPLICATES_NO_DUPLICATE_RECORDS;
            }
            this.setOptionValue(SortTransformModel.DUPLICATES_OPTION, (Object)duplicates);
        }

        @Override
        protected IModelListener createModelListener() {
            return new cSortModelChangeListener();
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new SortTransformValueChangedListener((SortTransformModel)this.getOwner(), this);
        }

        private class cSortModelChangeListener
        extends BaseDataTransformModelListener {
            public cSortModelChangeListener() {
                super(cSortOptionModel.this.getOwner(), cSortOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(SortTransformModel.OVERWRITE_OPTIONS_CHANGED)) {
                        cSortOptionModel.this.setOptionValue(SortTransformModel.OVERWRITE_OPTION, (Object)(SortTransformModel.this.isOverwrite() ? SortTransformModel.OVERWRITE_TRUE : SortTransformModel.OVERWRITE_FALSE));
                    } else if (type.equals(SortTransformModel.REPLACE_DATASET_CHANGED)) {
                        cSortOptionModel.this.setOptionValue(SortTransformModel.REPLACE_DATASET_OPTION, (Object)(SortTransformModel.this.isReplaceDataSet() ? SortTransformModel.REPLACE_DATASET_TRUE : SortTransformModel.REPLACE_DATASET_FALSE));
                    } else if (type.equals(SortTransformModel.DUPLICATE_RECORD_HANDLING_CHANGED)) {
                        cSortOptionModel.this.setDuplicateOptionValue(SortTransformModel.this.getDuplicateRecordHandling());
                    } else if (type.equals(SortTransformModel.STABLE_CHANGED)) {
                        cSortOptionModel.this.setOptionValue(SortTransformModel.STABLE_OPTION, (Object)(SortTransformModel.this.isStable() ? SortTransformModel.STABLE_TRUE : SortTransformModel.STABLE_FALSE));
                    } else if (type.equals(SortTransformModel.SORT_TAGS_CHANGED)) {
                        cSortOptionModel.this.setOptionValue(SortTransformModel.SORT_TAGS_OPTION, (Object)(SortTransformModel.this.isSortTags() ? SortTransformModel.SORT_TAGS_TRUE : SortTransformModel.SORT_TAGS_FALSE));
                    } else if (type.equals(SortTransformModel.COLLATING_SEQUENCE_CHANGED)) {
                        cSortOptionModel.this.setOptionValue(SortTransformModel.SORT_SEQUENCE_OPTION, (Object)SortTransformModel.this.getCollatingSequence());
                    } else if (type.equals(SortTransformModel.MEMORY_SIZE_CHANGED)) {
                        cSortOptionModel.this.setOptionValue(SortTransformModel.SORT_SIZE_OPTION, (Object)SortTransformModel.this.getMemorySize());
                    } else if (type.equals(SortTransformModel.PROC_SORT_OPTIONS_CHANGED)) {
                        cSortOptionModel.this.setOptionValue(SortTransformModel.PROC_SORT_OPTIONS, (Object)SortTransformModel.this.getProcSortOptions());
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class SortTransformValueChangedListener
        extends BaseDataTransformValueChangedListener {
            public SortTransformValueChangedListener(SortTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = SortTransformModel.DUPLICATES_ALLOW_DUPLICATES;
                    }
                    if (optionName.equals(SortTransformModel.STABLE_OPTION)) {
                        SortTransformModel.this.setStable(value.equals(SortTransformModel.STABLE_TRUE));
                    } else if (optionName.equals(SortTransformModel.REPLACE_DATASET_OPTION)) {
                        SortTransformModel.this.setReplaceDataSet(value.equals(SortTransformModel.REPLACE_DATASET_TRUE));
                    } else if (optionName.equals(SortTransformModel.OVERWRITE_OPTION)) {
                        SortTransformModel.this.setOverwrite(value.equals(SortTransformModel.OVERWRITE_TRUE));
                    } else if (optionName.equals(SortTransformModel.SORT_TAGS_OPTION)) {
                        SortTransformModel.this.setSortTags(value.equals(SortTransformModel.SORT_TAGS_TRUE));
                    } else if (optionName.equals(SortTransformModel.SORT_SIZE_OPTION)) {
                        SortTransformModel.this.setMemorySize(value.toString());
                    } else if (optionName.equals(SortTransformModel.SORT_SEQUENCE_OPTION)) {
                        SortTransformModel.this.setCollatingSequence(value.toString());
                    } else if (optionName.equals(SortTransformModel.DUPLICATES_OPTION)) {
                        String sDuplicates = value.toString();
                        SortTransformModel.this.setDuplicateRecordHandling(sDuplicates.equals(SortTransformModel.DUPLICATES_NO_DUPLICATE_KEYS) ? 1 : (sDuplicates.equals(SortTransformModel.DUPLICATES_NO_DUPLICATE_RECORDS) ? 2 : 0));
                    } else if (optionName.equals(SortTransformModel.PROC_SORT_OPTIONS)) {
                        SortTransformModel.this.setProcSortOptions(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }
}

