/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BaseTransformPromptModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ReturnCodeCheckerTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.SASReturnCodeCheck";
    private static final String TRANSFORMATION_ROLE = "SASReturnCodeCheck";
    private static final String ARM_DISPLAY_NAME = "ReturnCodeCheck";

    public ReturnCodeCheckerTransformModel(String id, IModel model) {
        super(id, model);
        this.setChanged(this.isNew());
        this.createConditionActionSetTemplates();
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.loadConditionActionSetTemplatesFromOMR();
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("ReturnCodeCheckerTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("ReturnCodeCheckerTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public boolean isResetTransformationReturnCodeWhenGeneratingCode() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        return new ArrayList();
    }

    @Override
    protected void saveWorkTablesToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public IWorkTable addNewWorkTable() {
        throw new UnsupportedOperationException("RCCheck doesnt support work tables");
    }

    protected void deleteWorkTablesFromOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public IWorkTable[] getWorkTables() {
        return null;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        List lConditionActionSets = this.getConditionActionSetsList();
        if (lConditionActionSets.size() <= 0) {
            return codeSegment;
        }
        codeSegment.addSourceCode("%macro etls_rcCheck; \n\n").indent();
        for (int iSet = 0; iSet < lConditionActionSets.size(); ++iSet) {
            IConditionActionSet caSet = (IConditionActionSet)lConditionActionSets.get(iSet);
            if (caSet == null || caSet.getCondition() == null) continue;
            codeSegment.addSourceCode(caSet.getCondition().getConditionMacroCall("trans_rc").trim());
            codeSegment.addSourceCode("\n").addSourceCode("%do; \n").indent();
            codeSegment.genActionCodeConditionCheck(this.getJob().isUsingNLSDateFormat(), codeSegment, caSet, null, null);
            codeSegment.unIndent().addSourceCode("%end; \n");
        }
        codeSegment.addSourceCode("\n").unIndent().addSourceCode("%mend etls_rcCheck; \n").addSourceCode("%etls_rcCheck; \n\n");
        return codeSegment;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new BaseTransformPromptModel(this.getModel(), this);
    }
}

