/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;

public class JobTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.SASJob";
    private static final String TRANSFORMATION_ROLE = "com.sas.wadmin.visuals.SASJob";
    private static final String ARM_DISPLAY_NAME = "Job";
    private IJob m_jobInnerHack;
    private InnerJobProxy m_innerJobProxy;

    public JobTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    public static String getTransformTypeID() {
        return "com.sas.wadmin.visuals.SASJob";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.wadmin.visuals.SASJob";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.wadmin.visuals.SASJob";
    }

    @Override
    protected String getDefaultName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.m_innerJobProxy != null ? this.m_innerJobProxy.getName() : (this.m_jobInnerHack != null ? this.m_jobInnerHack.getName() : MessageFormat.format(RB.getStringResource("JobTransformModel.JobNotFound.msg.txt"), this.getTransformClass()));
    }

    public IServer getServerForInnerJob() {
        IServer server = this.getExecutionServer();
        if (server != null) {
            return server;
        }
        IJob job = this.getJob();
        if (job != null) {
            return job.getExecutionServer();
        }
        return null;
    }

    @Override
    public String getDisplayType() {
        return this.getName();
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.loadConditionActionSetTemplatesFromOMR();
    }

    @Override
    public String getPrivateNote() {
        return this.m_innerJobProxy.getPrivateNote();
    }

    @Override
    public boolean isComplete() {
        return this.m_innerJobProxy.isCompleteAndSubcomponents();
    }

    @Override
    public List getReasonsIncomplete() {
        return this.m_innerJobProxy.getReasonsIncompleteAndSubcomponents();
    }

    @Override
    protected String getClassifierMapType() {
        return null;
    }

    public SimpleObject getInnerJob() {
        return this.m_innerJobProxy;
    }

    public void setInnerJob(IJob innerJob) {
        if (innerJob == this.m_jobInnerHack) {
            return;
        }
        if (this.m_innerJobProxy != null) {
            throw new IllegalStateException("setInnerJob called when JobTransformModel already has an inner job proxy");
        }
        this.m_jobInnerHack = innerJob;
        this.setChanged(true);
    }

    public void attachInnerJob(SimpleObject innerJob, OMRAdapter omr) throws RemoteException, MdException {
        this.acquireInnerJobProxy(innerJob.getID(), omr);
        super.setName(innerJob.getName());
    }

    private void acquireInnerJobProxy(String sID, OMRAdapter omr) throws RemoteException, MdException {
        IObject object = this.getModel().getObject(sID);
        if (object == null) {
            this.m_innerJobProxy = new InnerJobProxy(sID, this.getModel());
            this.m_innerJobProxy.loadFromOMR(omr);
        } else if (object instanceof InnerJobProxy) {
            this.m_innerJobProxy = (InnerJobProxy)object;
        }
        if (this.m_innerJobProxy == null) {
            throw new IllegalStateException("There is a job object in the model that is not the main job nor an inner job proxy");
        }
        this.m_innerJobProxy.setExecutionServer(this.getServerForInnerJob());
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.setName(this.m_innerJobProxy != null ? this.m_innerJobProxy.getName() : this.m_jobInnerHack.getName());
        super.saveToOMR(omr);
        this.setChanged(false);
    }

    @Override
    protected AbstractTransformation getUserWrittenCodeAnchor(OMRAdapter omr) throws MdException, RemoteException {
        return null;
    }

    @Override
    protected void saveClassifierMapToOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        SimpleObject job = this.m_innerJobProxy != null ? this.m_innerJobProxy : this.m_jobInnerHack;
        Job mdoJob = (Job)omr.acquireOMRObject((IOMRPersistable)job);
        AssociationList lTransformations = mdoStep.getTransformations(false);
        lTransformations.clear();
        lTransformations.add(mdoJob);
    }

    @Override
    protected void deleteClassifierMapFromOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected void loadDataSourcesTargetsFromOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList transforms = mdoStep.getTransformations();
        if (transforms.isEmpty()) {
            this.setCleanUpRequired(true);
            return;
        }
        Job mdoJob = (Job)transforms.get(0);
        this.acquireInnerJobProxy(mdoJob.getFQID(), omr);
        this.setChanged(false);
        super.setName(this.m_innerJobProxy.getName());
    }

    @Override
    public void dispose() {
        this.m_innerJobProxy = null;
        super.dispose();
    }

    @Override
    public void setUseUserWrittenCode(boolean bUseUserWrittenCode) {
        throw new UnsupportedOperationException("Can not set use user written on a job transformation");
    }

    @Override
    public boolean isUsingUserWrittenCode() {
        return this.m_innerJobProxy != null ? this.m_innerJobProxy.isUsingUserWrittenCode() : false;
    }

    @Override
    public void setUserWrittenCode(ICodeSource code) {
        throw new UnsupportedOperationException("Can not set user written on a job transformation");
    }

    @Override
    public IUserWrittenCodeContainer getUserWrittenCode() {
        return this.m_innerJobProxy.getUserWrittenCode();
    }

    @Override
    public void setUsePreProcessCode(boolean bUsePreProcessCode) {
        throw new UnsupportedOperationException("Can not set use pre process code on a job transformation");
    }

    @Override
    public boolean isUsingPreProcessCode() {
        return this.m_innerJobProxy.isUsingPreProcessCode();
    }

    @Override
    public void setUsePostProcessCode(boolean bUsePostProcessCode) {
        throw new UnsupportedOperationException("Can not set use post process code on a job transformation");
    }

    @Override
    public boolean isUsingPostProcessCode() {
        return this.m_innerJobProxy.isUsingPostProcessCode();
    }

    @Override
    public void addDataSource(int iSource, IDataObject source) {
        throw new UnsupportedOperationException("job transform does not support sources");
    }

    @Override
    public void addDataTarget(int iTarget, IDataObject target) {
        throw new UnsupportedOperationException("job transform does not support targets");
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public IMapping addMapping(IColumn[] aSourceColumns, IColumn[] aTargetColumns, String sType, IExpression oExpression) {
        throw new UnsupportedOperationException("job transform does not support mappings");
    }

    @Override
    public void addMapping(IMapping mapping) {
        throw new UnsupportedOperationException("job transform does not support mappings");
    }

    @Override
    public IWorkTable addNewWorkTable() {
        throw new UnsupportedOperationException("job transform does not support work tables");
    }

    @Override
    public PromptGroupInterface getPromptGroup() {
        if (this.m_innerJobProxy != null) {
            return this.m_innerJobProxy.getPromptGroup();
        }
        return super.getPromptGroup();
    }

    @Override
    public IPromptDefinitionValue[] getParameters() {
        return this.m_innerJobProxy.getParameters();
    }

    @Override
    public IPromptDefinitionValue[] getParameters(boolean includeSubComponents) {
        return this.getParameters();
    }

    @Override
    public boolean hasParameters() {
        return this.m_innerJobProxy != null ? this.m_innerJobProxy.hasParameters() : false;
    }

    @Override
    public ICodeSegment getCompleteCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (!this.isCodeGenerationEnabled()) {
            return codeSegment;
        }
        this.m_innerJobProxy.getCompleteCode(codeSegment);
        codeSegment.addSourceCode("\n\n/**  Job end ").addSourceCode(this.getName()).addSourceCode(" **/").addSourceCode("\n\n/* Reset jobid and name */\n");
        this.getJob().getJobIdMacrovarCode(codeSegment, false).addSourceCode("\n");
        return codeSegment;
    }

    @Override
    public final ICodeSegment getBodyCode(ICodeGenerationEnvironment environment) throws RemoteException, CodegenException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.m_innerJobProxy.getBodyCode(environment);
    }

    @Override
    public void notify(NotifyEvent ev) {
        IObject obj;
        ModelEvent modelEv = ev.getModelEvent();
        if (modelEv != null && (obj = modelEv.getModelObject()) == this.getJob() && "IJob:ExecutionServerChanged".equals(modelEv.getType()) && this.m_innerJobProxy != null) {
            this.m_innerJobProxy.setExecutionServer((IServer)modelEv.getData());
        }
        super.notify(ev);
    }

    @Override
    public void setJob(IJob job) {
        IJob oldJob = this.getJob();
        if (oldJob != null) {
            oldJob.removeNotifyListener(this);
        }
        super.setJob(job);
        if (this.m_innerJobProxy != null) {
            this.m_innerJobProxy.setExecutionServer(this.getServerForInnerJob());
        }
        if (job != null) {
            job.addNotifyListener(this);
        }
    }

    private static class InnerJobProxy
    extends AbstractPersistableObject
    implements SimpleObject {
        private IModel m_mdlInner;
        private IJob m_jobInner;
        private IServer _innerServer;

        public InnerJobProxy(String sID, IModel model) {
            super(sID, model);
        }

        @Override
        public String getName() {
            return this.m_jobInner.getName();
        }

        public String getPrivateNote() {
            return this.m_jobInner.getPrivateNote();
        }

        public boolean isCompleteAndSubcomponents() {
            return this.m_jobInner.isCompleteAndSubcomponents();
        }

        public List getReasonsIncompleteAndSubcomponents() {
            return this.m_jobInner.getReasonsIncompleteAndSubcomponents();
        }

        public void setUseUserWrittenCode(boolean bUseUserWrittenCode) {
            throw new UnsupportedOperationException("Can not set use user written on a job transformation");
        }

        public boolean isUsingUserWrittenCode() {
            return this.m_jobInner.isUsingUserWrittenCode();
        }

        public void setUserWrittenCode(ICodeSource code) {
            throw new UnsupportedOperationException("Can not set user written on a job transformation");
        }

        public IUserWrittenCodeContainer getUserWrittenCode() {
            return this.m_jobInner.getUserWrittenCode();
        }

        public boolean isUsingPreProcessCode() {
            return this.m_jobInner.isUsingPreProcessCode();
        }

        public IUserWrittenCodeContainer getPreProcessCode() {
            return this.m_jobInner.getPreProcessCode();
        }

        public boolean isPreProcessEnabled() {
            return this.m_jobInner.isPreProcessEnabled();
        }

        public boolean isUsingPostProcessCode() {
            return this.m_jobInner.isUsingPostProcessCode();
        }

        public IUserWrittenCodeContainer getPostProcessCode() {
            return this.m_jobInner.getPostProcessCode();
        }

        public boolean isPostProcessEnabled() {
            return this.m_jobInner.isPostProcessEnabled();
        }

        public PromptGroupInterface getPromptGroup() {
            return this.m_jobInner.getPromptGroup();
        }

        public IPromptDefinitionValue[] getParameters() {
            return this.m_jobInner.getParameters();
        }

        public boolean hasParameters() {
            return this.m_jobInner.hasParameters();
        }

        public void setExecutionServer(IServer server) {
            this._innerServer = server;
            this.setupServer(this._innerServer);
        }

        public IServer getExecutionServer() {
            return this._innerServer;
        }

        public void setupServer(IServer server) {
            if (this.m_jobInner != null) {
                this.m_jobInner.setExecutionServer(server);
            }
        }

        public ICodeSegment getCompleteCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
            return this.m_jobInner.getCompleteCode(codeSegment);
        }

        public final ICodeSegment getBodyCode(ICodeGenerationEnvironment environment) throws RemoteException, CodegenException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
            return this.m_jobInner.getBodyCode(environment);
        }

        @Override
        public String getOMRType() {
            return this.getMetadataType();
        }

        @Override
        public void dispose() {
            this.disposeInnerModel();
            super.dispose();
        }

        private void disposeInnerModel() {
            if (this.m_mdlInner != null) {
                this.m_mdlInner.dispose();
                this.m_mdlInner = null;
                this.m_jobInner = null;
            }
        }

        @Override
        public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
            this.disposeInnerModel();
            this.m_mdlInner = DesignTimeJobModel.createModelForExistingJob(this.getID());
            this.m_mdlInner.setModelEventsEnabled(false);
            this.m_mdlInner.setUndoSupported(false);
            this.m_jobInner = (IJob)this.m_mdlInner.getObject(this.getID());
            this.m_mdlInner.loadFromOMR(this.m_jobInner, omr.getOMRFactory());
            this.setupServer(this.getExecutionServer());
        }

        @Override
        public void saveToOMR(OMRAdapter omr) {
            throw new UnsupportedOperationException("saveToOMR is not supported for inner jobs");
        }

        public String getMetadataType() {
            return JobTransformModel.ARM_DISPLAY_NAME;
        }

        public String getPublicType() {
            return JobTransformModel.ARM_DISPLAY_NAME;
        }

        public boolean isPublicObject() {
            return true;
        }
    }
}

