/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IGeneratedTransformDefinition;
import com.sas.etl.models.job.IGeneratedTransformPort;
import com.sas.etl.models.job.IGeneratedTransformTemplate;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class GeneratedTransformModel
extends AbstractDataTransform {
    private static final String ARM_DISPLAY_NAME = "GeneratedTransform";
    public static final String UPDATE_TABLE_METADATA_CHANGED = "GeneratedTransformModel:UpdateTableMetadataChanged";
    public static final String TEMPLATE_CHANGED = "GeneratedTransformModel:TemplateChanged";
    private static final String MACRO_ROLE = "ESMACRO";
    private static final String PROPERTY_NAME_VERSION = "TRANSFORMVERSION";
    private static final String PROPERTY_ROLE_VERSION = "VERSION";
    private IGeneratedTransformDefinition m_transformDefinition;
    private String m_strTransformClass = "";
    private int m_intTransformVersion = 1;
    private boolean m_bUpdateTableMetadata = false;
    private IGeneratedTransformTemplate m_template;
    private IPromptModel m_optionModel;
    private static final String REST_TRANSFORM_ID = "e609a0bf-0a0c-0c55-01a1-3338b766af91";

    public GeneratedTransformModel(String sID, IModel model) {
        super(sID, model);
        this.setTemplate(model.getObjectFactory().createNewGeneratedTransformTemplate(sID));
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.deleteFromOMR(omr);
        IGeneratedTransformTemplate template = this.getTemplate();
        if (template != null) {
            template.deleteFromOMR(omr);
        }
        try {
            IPromptModel optionModel = this.getOptionModel();
            if (optionModel != null) {
                optionModel.deleteFromOMR(omr);
            }
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_optionModel != null) {
            this.m_optionModel.dispose();
        }
    }

    public String getHelpProduct() {
        return this.m_transformDefinition.getHelpProduct();
    }

    public String getHelpId() {
        return this.m_transformDefinition.getHelpId();
    }

    public String getHelpClass() {
        return this.m_transformDefinition.getHelpClass();
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get("TransformationStep");
        if (lAssociations == null) {
            System.err.println("No entry in load map for TransformationStep");
        }
        lAssociations.add("UsingPrototype");
        lAssociations = new ArrayList<String>();
        lAssociations.add("PrototypeProperties");
        map.put("Prototype", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("UsingPrototype");
        map.put("AssociationProperty", lAssociations);
        return map;
    }

    @Override
    public List getRefreshObjects() {
        if (!this.isUpdateTableMetadata()) {
            return null;
        }
        ArrayList<IDataObject> lObjects = new ArrayList<IDataObject>();
        IDataObject[] aTargets = this.getDataTargets();
        for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
            lObjects.add(aTargets[iTarget]);
            List lSubObjects = aTargets[iTarget].getRefreshObjects();
            if (lSubObjects == null) continue;
            lObjects.addAll(lSubObjects);
        }
        return lObjects;
    }

    public boolean isUpToDate() {
        if (this.m_transformDefinition != null) {
            return this.m_transformDefinition.getTransformVersion() == this.getTransformVersion();
        }
        return false;
    }

    @Override
    public void addDefaultSettings() {
        for (int i = 0; i < this.getMinimumDataTargetCount(); ++i) {
            this.addNewWorkTable();
        }
    }

    @Override
    public void delete() {
        this.m_template.delete();
        super.delete();
    }

    @Override
    public void notify(NotifyEvent ev) {
        String type;
        Object source = ev.getSource();
        ModelEvent modelEvent = ev.getModelEvent();
        if (source == this.getTemplate() && modelEvent != null) {
            IGeneratedTransformPort port;
            String type2 = modelEvent.getType();
            if ("IGeneratedTransformTemplate:SourcePortRemoved".equals(type2)) {
                IPhysicalTable table;
                IGeneratedTransformPort port2 = (IGeneratedTransformPort)modelEvent.getData();
                if (port2 != null && (table = port2.getTable()) != null) {
                    this.removeDataSource(port2, table);
                }
                this.fireModelChangedEvent("DataTransform.InputRemoved", port2);
            } else if ("IGeneratedTransformTemplate:SourcePortAdded".equals(type2)) {
                IGeneratedTransformPort port3 = (IGeneratedTransformPort)modelEvent.getData();
                if (port3 != null) {
                    this.fireModelChangedEvent("DataTransform.InputAdded", port3);
                    IPhysicalTable table = port3.getTable();
                    if (table != null) {
                        this.addSourceTable(this.m_template.getPortIndex(port3), table);
                    }
                }
            } else if ("IGeneratedTransformTemplate:TargetPortRemoved".equals(type2)) {
                IGeneratedTransformPort port4 = (IGeneratedTransformPort)modelEvent.getData();
                if (port4 != null && port4.getTable() != null) {
                    this.removeDataTarget(port4, port4.getTable());
                }
                this.fireModelChangedEvent("DataTransform.OutputRemoved", port4);
            } else if ("IGeneratedTransformTemplate:TargetPortAdded".equals(type2) && (port = (IGeneratedTransformPort)modelEvent.getData()) != null) {
                this.fireModelChangedEvent("DataTransform.OutputAdded", port);
                IPhysicalTable table = port.getTable();
                if (table != null) {
                    this.addTargetTable(this.m_template.getPortIndex(port), table);
                }
            }
        } else if (source instanceof IGeneratedTransformPort && modelEvent != null && "IGeneratedTransformPort:TableChanged".equals(type = modelEvent.getType())) {
            IGeneratedTransformPort port = (IGeneratedTransformPort)source;
            IPhysicalTable table = (IPhysicalTable)modelEvent.getAdditionalData();
            int portIndex = this.m_template.getPortIndex(port);
            if (port.isInputTemplate()) {
                if (port.getTable() != null) {
                    this.addSourceTable(portIndex, port.getTable());
                } else {
                    this.removeSourceTable(port, table);
                }
            } else if (port.getTable() != null) {
                this.addTargetTable(portIndex, port.getTable());
            } else {
                this.removeTargetTable(port, table);
            }
        }
        super.notify(ev);
    }

    @Override
    public ITransformTableOptions[] getTableOptionObjects() {
        ArrayList<ITransformTableOptions> opts = new ArrayList<ITransformTableOptions>();
        if (this.getTemplate() != null) {
            IGeneratedTransformPort[] ports = this.getTemplate().getPorts();
            for (int i = 0; i < ports.length; ++i) {
                if (ports[i].getTransformTableOption() == null) continue;
                opts.add(ports[i].getTransformTableOption());
            }
        }
        return opts.toArray(new ITransformTableOptions[opts.size()]);
    }

    private boolean hasUpdateMetadataAndNewTable() {
        if (!this.isUpdateTableMetadata()) {
            return false;
        }
        List targetTables = this.getDataTargetList();
        for (int iTarget = 0; iTarget < targetTables.size(); ++iTarget) {
            ITable table;
            Object target = targetTables.get(iTarget);
            if (!(target instanceof ITable) || !(table = (ITable)target).isNew()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        return this.hasUpdateMetadataAndNewTable();
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        if (this.hasUpdateMetadataAndNewTable()) {
            warnings.add(RB.getStringResource("GeneratedTransformModel.UpdateMetadataNewTablesWarning.txt"));
        }
        return warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkTable addNewWorkTable() {
        if (this.isAddWorkTableAvailable()) {
            this.startCompoundUndoable();
            try {
                IGeneratedTransformPort port = this.getTemplate().getNextAvailablePort(false);
                if (port == null && this.isAddOutputAvailable()) {
                    this.addOutput();
                    port = this.getTemplate().getNextAvailablePort(false);
                }
                if (port != null) {
                    IWorkTable table = this.getObjectFactory().createNewWorkTable(this.getID());
                    table.setName(this.getName() + port.getMacro());
                    this.addDataTarget(port, table);
                    IWorkTable iWorkTable = table;
                    return iWorkTable;
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
        return null;
    }

    @Override
    public ITable[] getSourceTables() {
        List tables = this.getDataSourceList();
        return tables.toArray(new ITable[tables.size()]);
    }

    @Override
    public IDataObject[] getDataSources() {
        List tables = this.getDataSourceList();
        return tables.toArray(new IDataObject[tables.size()]);
    }

    @Override
    public List getDataSourceList() {
        ArrayList<IPhysicalTable> tables = new ArrayList<IPhysicalTable>();
        IGeneratedTransformPort[] sourcePorts = this.m_template.getSourcePorts();
        for (int i = 0; i < sourcePorts.length; ++i) {
            IPhysicalTable table = sourcePorts[i].getTable();
            if (table == null || tables.contains(table)) continue;
            tables.add(table);
        }
        return tables;
    }

    @Override
    public List getDataTargetList() {
        ArrayList<IPhysicalTable> tables = new ArrayList<IPhysicalTable>();
        IGeneratedTransformPort[] targetPorts = this.m_template.getTargetPorts();
        for (int i = 0; i < targetPorts.length; ++i) {
            IPhysicalTable table = targetPorts[i].getTable();
            if (table == null || tables.contains(table)) continue;
            tables.add(table);
        }
        return tables;
    }

    @Override
    public int getDataSourcesCount() {
        int cnt = 0;
        IGeneratedTransformPort[] ports = this.getTemplate().getSourcePorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i].getTable() == null) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public IDataObject[] getDataTargets() {
        List tables = this.getDataTargetList();
        return tables.toArray(new IDataObject[tables.size()]);
    }

    @Override
    public ITable[] getTargetTables() {
        IDataObject[] targets = this.getDataTargets();
        return Arrays.asList(targets).toArray(new ITable[targets.length]);
    }

    @Override
    public int getDataTargetsCount() {
        int cnt = 0;
        IGeneratedTransformPort[] ports = this.getTemplate().getTargetPorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i].getTable() == null) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public void addDataSource(int iSource, IDataObject source) {
    }

    public void addDataSource(IGeneratedTransformPort port, IPhysicalTable source) {
        this.startCompoundUndoable();
        try {
            if (port != null && port.getTable() != source) {
                port.setTable(source);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void addSourceTable(int portIndex, IPhysicalTable table) {
        if (!table.containsInConsumerTransforms(this)) {
            table.addConsumerTransform(this);
            table.addNotifyListener(this);
        }
        this.fireModelChangedEvent("DataTransform.DataSourceAdded", table, new Integer(portIndex + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSource(IDataObject source) {
        this.startCompoundUndoable();
        try {
            IGeneratedTransformPort[] srcs = this.m_template.getSourcePorts();
            for (int i = 0; i < srcs.length; ++i) {
                if (srcs[i].getTable() != source) continue;
                this.removeDataSource(srcs[i], (IPhysicalTable)source);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public void removeDataSource(IGeneratedTransformPort port, IPhysicalTable source) {
        this.startCompoundUndoable();
        try {
            if (port.getTable() == source) {
                port.setTable(null);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void removeSourceTable(IGeneratedTransformPort port, IPhysicalTable table) {
        if (table.containsInConsumerTransforms(this) && this.m_template.getNumberTimesTableUsedInSources(table) == 0) {
            table.removeConsumerTransform(this);
            table.removeNotifyListener(this);
            if (!port.isInUndoOrRedo()) {
                this.removeSourceTableFromMappings(table);
            }
        }
        this.fireModelChangedEvent("DataTransform.DataSourceRemoved", table, new Integer(this.m_template.getPortIndex(port) + 1));
    }

    @Override
    public boolean containsInDataSources(IDataObject source) {
        return this.getDataSourceList().contains(source);
    }

    @Override
    public boolean containsInDataTargets(IDataObject target) {
        return this.getDataTargetList().contains(target);
    }

    @Override
    public void addDataTarget(int iTarget, IDataObject target) {
    }

    public void addDataTarget(IGeneratedTransformPort port, IPhysicalTable target) {
        this.startCompoundUndoable();
        try {
            if (port != null && port.getTable() != target) {
                port.setTable(target);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void addTargetTable(int portIndex, IPhysicalTable table) {
        if (table instanceof IWorkTable) {
            this.removeFromDeletedObjects(table);
            this.updateTargetLibrary((IWorkTable)table);
        }
        if (!table.containsInProducerTransforms(this)) {
            table.addProducerTransform(this);
            table.addNotifyListener(this);
        }
        this.fireModelChangedEvent("DataTransform.DataTargetAdded", table, new Integer(portIndex + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataTarget(IDataObject target) {
        this.startCompoundUndoable();
        try {
            IGeneratedTransformPort[] targets = this.m_template.getTargetPorts();
            for (int i = 0; i < targets.length; ++i) {
                if (targets[i].getTable() != target) continue;
                this.removeDataTarget(targets[i], (IPhysicalTable)target);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataTarget(IGeneratedTransformPort port, IPhysicalTable target) {
        this.startCompoundUndoable();
        try {
            if (port.getTable() == target) {
                if (target instanceof IWorkTable) {
                    IDataTransform[] consumers = target.getConsumerTransforms();
                    for (int i = 0; i < consumers.length; ++i) {
                        consumers[i].removeDataSource(target);
                    }
                }
                port.setTable(null);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void removeTargetTable(IGeneratedTransformPort port, IPhysicalTable table) {
        if (table.containsInProducerTransforms(this) && this.m_template.getNumberTimesTableUsedInTargets(table) == 0) {
            table.removeProducerTransform(this);
            table.removeNotifyListener(this);
            if (!port.isInUndoOrRedo()) {
                this.removeTargetTableFromMappings(table);
            }
        }
        if (table instanceof IWorkTable) {
            this.addToDeletedObjects(table);
        }
        this.fireModelChangedEvent("DataTransform.DataTargetRemoved", table, new Integer(this.m_template.getPortIndex(port) + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            this.replaceSourceMappings(oldTable, newTable, columnsMap);
            this.replaceSourceTableOptions(oldTable, newTable, columnsMap);
            for (int i = 0; i < portIndexes.length; ++i) {
                IGeneratedTransformPort port = this.m_template.getSourcePorts()[portIndexes[i] - 1];
                this.removeDataSource(port, (IPhysicalTable)oldTable);
                this.addDataSource(port, (IPhysicalTable)newTable);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            this.replaceTargetMappings(oldTable, newTable, columnsMap);
            this.replaceTargetTableOptions(oldTable, newTable, columnsMap);
            for (int i = 0; i < portIndexes.length; ++i) {
                IGeneratedTransformPort port = this.m_template.getTargetPorts()[portIndexes[i] - 1];
                this.removeDataTarget(port, (IPhysicalTable)oldTable);
                this.addDataTarget(port, (IPhysicalTable)newTable);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        try {
            this.getOptionModel().updateIDs(mapIDs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTransformDefinition(IGeneratedTransformDefinition definition) {
        this.setTransformDefinition(definition, true);
    }

    protected void setTransformDefinition(IGeneratedTransformDefinition definition, boolean isNewTransform) {
        if (this.m_transformDefinition == definition) {
            return;
        }
        this.m_transformDefinition = definition;
        try {
            if (this.m_optionModel != null) {
                this.m_optionModel.dispose();
            }
            this.m_optionModel = this.getOptionModel();
        }
        catch (Exception e) {
            ModelLogger.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
        }
        if (isNewTransform) {
            int t;
            this.setName(definition.getName());
            this.setDescription(definition.getDescription());
            this.setPrivateNote(definition.getPrivateNote());
            for (t = 0; t < definition.getDocumentsList().size(); ++t) {
                this.getDocumentsList().add(definition.getDocumentsList().get(t));
            }
            for (t = 0; t < definition.getNotesList().size(); ++t) {
                this.getNotesList().add(definition.getNotesList().get(t));
            }
            this.setTransformClass(this.m_transformDefinition.getTransformClass());
            this.setTransformVersion(this.m_transformDefinition.getTransformVersion());
            IGeneratedTransformTemplate template = this.m_transformDefinition.getTemplate();
            this.setTemplate(template.copy(this.getID()).cleanPorts().updateDisplayedPorts());
        }
    }

    public IGeneratedTransformDefinition getTransformDefinition() {
        return this.m_transformDefinition;
    }

    @Override
    public String getType() {
        return "TransformationStep2";
    }

    public static String getTransformTypeID() {
        return "TransformationStep2";
    }

    @Override
    protected String getTransformRole() {
        return "TransformationStep2";
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        IPromptDefinitionValue pdv;
        if (this.m_transformDefinition != null && this.m_optionModel == null) {
            this.m_optionModel = this.m_transformDefinition.getOptionModel(this);
        }
        if (this.m_optionModel != null && (pdv = this.m_optionModel.getPromptDefinitionValue("COLMACROVARS")) != null) {
            pdv.setHidden(false);
        }
        return this.m_optionModel;
    }

    public boolean isUpdateTableMetadata() {
        return this.m_bUpdateTableMetadata;
    }

    public void setUpdateTableMetadata(boolean doUpdate) {
        if (doUpdate == this.m_bUpdateTableMetadata) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUpdateTableMetadataUndoable(this.m_bUpdateTableMetadata, doUpdate));
        }
        this.m_bUpdateTableMetadata = doUpdate;
        this.fireModelChangedEvent(UPDATE_TABLE_METADATA_CHANGED, null);
    }

    public void setTemplate(IGeneratedTransformTemplate template) {
        if (this.m_template == template) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetTemplateUndoable(this.m_template, template));
            }
            if (this.m_template != null) {
                this.m_template.removeNotifyListener(this);
            }
            this.m_template = template;
            if (this.m_template != null) {
                this.m_template.addNotifyListener(this);
            }
            this.fireModelChangedEvent(TEMPLATE_CHANGED, this.m_template);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IGeneratedTransformTemplate getTemplate() {
        return this.m_template;
    }

    @Override
    public String getTransformClass() {
        return this.m_strTransformClass;
    }

    public void setTransformClass(String transformClass) {
        this.m_strTransformClass = transformClass;
    }

    public int getTransformVersion() {
        return this.m_intTransformVersion;
    }

    public void setTransformVersion(int version) {
        this.m_intTransformVersion = version;
    }

    @Override
    protected String getDefaultName() {
        if (this.m_transformDefinition != null) {
            return this.m_transformDefinition.getName();
        }
        return MessageFormat.format(RB.getStringResource("GeneratedTransformModel.TransformationNotFound.msg.txt"), this.getTransformClass());
    }

    @Override
    public String getDisplayType() {
        if (this.m_transformDefinition != null) {
            return this.m_transformDefinition.getName();
        }
        return MessageFormat.format(RB.getStringResource("GeneratedTransformModel.TransformationNotFound.msg.txt"), this.getTransformClass());
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    protected int getMinimumDataSourceCount() {
        if (this.m_transformDefinition != null) {
            return this.m_transformDefinition.getMinimumDataSourceCount();
        }
        return 0;
    }

    public int getMaximumSourceTableCount() {
        return this.getMaximumDataSourceCount();
    }

    @Override
    protected int getMaximumDataSourceCount() {
        if (this.m_transformDefinition != null) {
            return this.m_transformDefinition.getMaximumDataSourceCount();
        }
        return 0;
    }

    protected int getMinimumDataTargetCount() {
        if (this.m_transformDefinition != null) {
            return this.m_transformDefinition.getMinimumDataTargetCount();
        }
        return 0;
    }

    public int getMaximumTargetTableCount() {
        return this.getMaximumDataTargetCount();
    }

    @Override
    protected int getMaximumDataTargetCount() {
        if (this.m_transformDefinition != null) {
            return this.m_transformDefinition.getMaximumDataTargetCount();
        }
        return 0;
    }

    @Override
    public boolean isAddInputAvailable() {
        return this.getTemplate().canPortBeAdded(true);
    }

    @Override
    public boolean isAddOutputAvailable() {
        return this.getTemplate().canPortBeAdded(false);
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return this.getDataTargetsCount() < this.getMaximumDataTargetCount();
    }

    @Override
    public boolean isDeleteInputAvailable() {
        return this.getTemplate().canPortBeRemoved(true);
    }

    @Override
    public boolean isDeleteOutputAvailable() {
        return this.getTemplate().canPortBeRemoved(false);
    }

    @Override
    public void addInput() {
        if (!this.isAddInputAvailable()) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IGeneratedTransformPort port = this.getTemplate().getPortToBeAdded(this.m_transformDefinition.getTemplate(), true);
            this.addPort(true, port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addOutput() {
        if (!this.isAddOutputAvailable()) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IGeneratedTransformPort port = this.getTemplate().getPortToBeAdded(this.m_transformDefinition.getTemplate(), false);
            this.addPort(false, port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPort(boolean isInput, IGeneratedTransformPort port) {
        if (port != null) {
            this.startCompoundUndoable();
            try {
                if (this.isUndoSupported()) {
                    AbstractUndoableEdit undo = null;
                    undo = isInput ? new AddInputPortUndoable(port) : new AddOutputPortUndoable(port);
                    this.undoableEditHappened(undo);
                }
                if (isInput) {
                    this.getTemplate().addSourcePort(port);
                } else {
                    this.getTemplate().addTargetPort(port);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePort(boolean isInput, IGeneratedTransformPort port) {
        if (port != null) {
            this.startCompoundUndoable();
            try {
                if (this.isUndoSupported()) {
                    AbstractUndoableEdit undo = null;
                    undo = isInput ? new RemoveInputPortUndoable(port) : new RemoveOutputPortUndoable(port);
                    this.undoableEditHappened(undo);
                }
                if (isInput) {
                    this.getTemplate().removeSourcePort(port);
                } else {
                    this.getTemplate().removeTargetPort(port);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    @Override
    public void deleteInput() {
        if (!this.isDeleteInputAvailable()) {
            return;
        }
        IGeneratedTransformPort port = this.getTemplate().getPortToRemove(true);
        this.removePort(true, port);
    }

    @Override
    public void deleteOutput() {
        if (!this.isDeleteOutputAvailable()) {
            return;
        }
        IGeneratedTransformPort port = this.getTemplate().getPortToRemove(false);
        this.removePort(false, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTransformDefinitionPrototype(OMRAdapter omr) throws RemoteException, MdException {
        String protoSelect;
        String sOptions = protoSelect = "<XMLSELECT Search=\"Prototype[@MetadataType='TransformationStep2'][Properties/Property[@PropertyName='Class' and @DefaultValue='" + this.getTransformClass() + "']]\"/>";
        MdObjectStore store = omr.getOMRFactory().createObjectStore(null, "GeneratedTransformModel: LoadDefinition");
        try {
            List objects = omr.getOMRFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, Workspace.getWorkspace().getDefaultRepository().getFQID(), "Prototype", 8584, sOptions);
            if (!objects.isEmpty()) {
                Prototype proto;
                if (objects.size() == 1) {
                    proto = (Prototype)objects.get(0);
                } else {
                    Prototype[] protos = new Prototype[2];
                    for (int i = 0; i < objects.size(); ++i) {
                        proto = (Prototype)objects.get(i);
                        if (WsMetadataUtil.isProjectObject((CMetadata)proto)) {
                            protos[0] = proto;
                            continue;
                        }
                        protos[1] = proto;
                    }
                    TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
                    proto = WsMetadataUtil.isProjectObject((CMetadata)mdoStep) ? protos[0] : protos[1];
                }
                IGeneratedTransformDefinition transformDefinition = (IGeneratedTransformDefinition)omr.acquireObjectUsingTemplate((Root)proto);
                this.setTransformDefinition(transformDefinition, false);
            }
        }
        finally {
            store.dispose();
        }
    }

    @Override
    protected boolean areMappingsComplete() {
        return true;
    }

    @Override
    protected List getReasonsMappingsIncomplete() {
        ArrayList lReasons = new ArrayList();
        return lReasons;
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return this.getMinimumDataSourceCount() > 0;
    }

    @Override
    protected boolean doesNoTargetsMeanIncomplete() {
        return this.getMinimumDataTargetCount() > 0;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.getDataSourcesCount() >= this.getMinimumDataSourceCount() && this.getDataTargetsCount() >= this.getMinimumDataTargetCount();
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        int minSource = this.getMinimumDataSourceCount();
        if (this.getDataSourcesCount() < minSource) {
            String tableString = minSource == 1 ? RB.getStringResource("GeneratedTransformModel.Table.error.txt") : RB.getStringResource("GeneratedTransformModel.Tables.error.txt");
            reasons.add(MessageFormat.format(RB.getStringResource("GeneratedTransformModel.MinSourceTables.error.txt"), new Integer(minSource), tableString));
        }
        int minTarget = this.getMinimumDataTargetCount();
        if (this.getDataTargetsCount() < minTarget) {
            String tableString = minTarget == 1 ? RB.getStringResource("GeneratedTransformModel.Table.error.txt") : RB.getStringResource("GeneratedTransformModel.Tables.error.txt");
            reasons.add(MessageFormat.format(RB.getStringResource("GeneratedTransformModel.MinTargetTables.error.txt"), new Integer(minTarget), tableString));
        }
        return reasons;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.getTemplate().isChanged() || this.m_optionModel != null && this.m_optionModel.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.savePropertyToOMR(omr, "MACROOPTIONS", "ADMIN.UPDATEMETADATA", "ADMIN.UPDATEMETADATA", "", this.isUpdateTableMetadata() ? "YES" : "NO", 12, 2);
        this.m_optionModel.saveToOMR(omr);
        this.savePropertyToOMR(omr, "", PROPERTY_ROLE_VERSION, PROPERTY_NAME_VERSION, PROPERTY_ROLE_VERSION, Integer.toString(this.getTransformVersion()), 4, 1);
        IGeneratedTransformTemplate template = this.getTemplate();
        if (template != null) {
            template.saveToOMR(omr);
            Root mdoTemplate = omr.acquireOMRObject(template);
            mdoStep.setUsingPrototype(mdoTemplate);
        }
        this.setChanged(false);
    }

    @Override
    protected void saveTransformTableOptions(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected void saveTransformClassToOMR(OMRAdapter omr) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, null, "Class", "Class", MACRO_ROLE, this.getTransformClass(), 12, 1);
    }

    @Override
    protected boolean loadTransformTableOptionsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        return false;
    }

    @Override
    protected void loadDataSourcesTargetsFromOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        AssociationList lTransformations = mdoStep.getTransformations();
        if (!lTransformations.isEmpty()) {
            ClassifierMap mdoCM = (ClassifierMap)lTransformations.get(0);
            this.setClassifierMapId(mdoCM.getFQID());
            this.loadMappingsFromOMR(omr, mdoCM);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        String version;
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.setName(mdoStep.getName());
        this.setTransformClass(this.loadPropertyFromOMR(omr, "", "Class", "", 1));
        if (this.m_transformDefinition == null) {
            this.loadTransformDefinitionPrototype(omr);
            if (this.m_transformDefinition == null) {
                this.setCleanUpRequired(true);
                return;
            }
        }
        IGeneratedTransformTemplate template = null;
        if (!mdoStep.getUsingPrototypes().isEmpty()) {
            Prototype prototype = (Prototype)mdoStep.getUsingPrototype();
            template = this.getModel().getObjectFactory().createGeneratedTransformTemplate(prototype.getFQID());
            this.setTemplate(template);
            template.loadFromOMR(omr);
        }
        AssociationList lTransformations = mdoStep.getTransformations();
        IDataObject[] sources = null;
        IDataObject[] targets = null;
        if (!lTransformations.isEmpty()) {
            ClassifierMap mdoCM = (ClassifierMap)lTransformations.get(0);
            AssociationList cmSrc = mdoCM.getClassifierSources();
            sources = new IDataObject[cmSrc.size()];
            for (int i = 0; i < cmSrc.size(); ++i) {
                sources[i] = (IDataObject)omr.acquireObject((Root)cmSrc.get(i));
            }
            AssociationList cmTrg = mdoCM.getClassifierTargets();
            targets = new IDataObject[cmTrg.size()];
            for (int i = 0; i < cmTrg.size(); ++i) {
                targets[i] = (IDataObject)omr.acquireObject((Root)cmTrg.get(i));
            }
        }
        super.loadFromOMR(omr);
        boolean changed = false;
        if (template != null) {
            IGeneratedTransformPort newport;
            if (sources != null) {
                for (int i = 0; i < sources.length; ++i) {
                    int portNum = template.findInSourcePorts((IPhysicalTable)sources[i]);
                    if (portNum >= 0) continue;
                    IGeneratedTransformPort port = template.getNextAvailablePort(true);
                    if (port != null) {
                        port.setTable((IPhysicalTable)sources[i]);
                    } else if (template.canPortBeAdded(true)) {
                        newport = template.getPortToBeAdded(this.m_transformDefinition.getTemplate(), true);
                        this.addPort(true, newport);
                        newport.setTable((IPhysicalTable)sources[i]);
                    }
                    changed = true;
                }
                template.setChanged(changed);
            }
            if (targets != null) {
                for (int i = 0; i < targets.length; ++i) {
                    int portNum = template.findInTargetPorts((IPhysicalTable)targets[i]);
                    if (portNum >= 0) continue;
                    IGeneratedTransformPort port = template.getNextAvailablePort(false);
                    if (port != null) {
                        port.setTable((IPhysicalTable)targets[i]);
                    } else if (template.canPortBeAdded(false)) {
                        newport = template.getPortToBeAdded(this.m_transformDefinition.getTemplate(), false);
                        this.addPort(false, newport);
                        newport.setTable((IPhysicalTable)targets[i]);
                    }
                    changed = true;
                }
                template.setChanged(changed);
            }
        }
        this.setTransformVersion((version = this.loadPropertyFromOMR(omr, "", PROPERTY_NAME_VERSION, "1", 1)) != null && version.length() > 0 ? Integer.parseInt(version) : 1);
        if (!this.isUpToDate()) {
            IGeneratedTransformTemplate transformTemplate = this.m_transformDefinition.getTemplate();
            IGeneratedTransformTemplate usedTemplate = this.getTemplate();
            usedTemplate.updateTemplate(transformTemplate);
            this.setTransformVersion(this.m_transformDefinition.getTransformVersion());
        }
        this.setUpdateTableMetadata("YES".equalsIgnoreCase(this.loadPropertyFromOMR(omr, "MACROOPTIONS", "ADMIN.UPDATEMETADATA", "NO", 2)));
        try {
            this.m_optionModel = this.getOptionModel();
            this.m_optionModel.loadFromOMR(omr);
        }
        catch (FileNotFoundException e) {
            throw new MdException((Throwable)e);
        }
        catch (ServerConnectionException e) {
            throw new MdException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MdException((Throwable)e);
        }
        catch (IOException e) {
            throw new MdException((Throwable)e);
        }
        this.setChanged(changed);
    }

    protected void savePortConnections(OMRAdapter omr) throws RemoteException, MdException {
        IGeneratedTransformTemplate template = this.getTemplate();
        if (template != null) {
            template.saveToOMR(omr);
        }
    }

    @Override
    public IWorkTable[] getWorkTables() {
        ArrayList<IPhysicalTable> workTables = new ArrayList<IPhysicalTable>();
        IGeneratedTransformPort[] targetPorts = this.m_template.getTargetPorts();
        for (int i = 0; i < targetPorts.length; ++i) {
            IPhysicalTable table = targetPorts[i].getTable();
            if (!(table instanceof IWorkTable)) continue;
            workTables.add(table);
        }
        return workTables.toArray(new IWorkTable[workTables.size()]);
    }

    protected ICodeSegment generateTableMacros(ICodeSegment codeSegment, boolean isSources) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IGeneratedTransformTemplate template = this.getTemplate();
        if (template != null) {
            IGeneratedTransformPort[] ports = isSources ? template.getSourcePorts() : template.getTargetPorts();
            String defaultPrefix = isSources ? "_INPUT" : "_OUTPUT";
            codeSegment.addSourceCode("%let ").addSourceCode(defaultPrefix).addSourceCode("_count = ");
            codeSegment.addSourceCode(Integer.toString(ports.length));
            codeSegment.addSourceCode("; \n");
            for (int i = 0; i < ports.length; ++i) {
                IGeneratedTransformPort port = ports[i];
                IPhysicalTable table = port.getTable();
                String prefix = port.getMacro();
                try {
                    if (i == 0) {
                        codeSegment.addSourceCode(PromptUtils.getTablePercentLetStatements(codeSegment, defaultPrefix, table, !isSources, port.getTransformTableOption(), isSources ? null : (table != null ? this.getOrdinaryMappingsForTargetTable(table) : null), this.getTransformDefinition().getGenerateMappingMacros(), this.isColMacroVarsEnabled())).addSourceCode("\n");
                    }
                    if (prefix == null || prefix.length() == 0) {
                        prefix = defaultPrefix + i;
                    }
                    if (prefix == null || prefix.length() <= 0 || prefix.equals(defaultPrefix)) continue;
                    codeSegment.addSourceCode(PromptUtils.getTablePercentLetStatements(codeSegment, prefix, table, !isSources, port.getTransformTableOption(), isSources ? null : (table != null ? this.getOrdinaryMappingsForTargetTable(table) : null), this.getTransformDefinition().getGenerateMappingMacros(), this.isColMacroVarsEnabled())).addSourceCode("\n");
                    continue;
                }
                catch (RemoteException e) {
                    throw new CodegenException(e, (IObject)table);
                }
                catch (MdException e) {
                    throw new CodegenException((Exception)((Object)e), (IObject)table);
                }
                catch (BadLibraryDefinitionException e) {
                    throw new CodegenException(e, (IObject)table);
                }
            }
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getGeneratedLibnameCodeForTargets(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        if (!REST_TRANSFORM_ID.equals(this.getTransformClass())) {
            return super.getGeneratedLibnameCodeForTargets(codeSegment);
        }
        return codeSegment;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        if (this.m_transformDefinition == null) {
            throw new CodegenException(MessageFormat.format(RB.getStringResource("GeneratedTransformModel.TransformationNotFound.msg.txt"), this.getTransformClass()), (IObject)this);
        }
        IPhysicalTable[] targets = Arrays.asList(this.getDataTargets()).toArray(new IPhysicalTable[this.getDataTargets().length]);
        if (this.m_transformDefinition != null) {
            this.generateTableMacros(codeSegment, true);
            if (!REST_TRANSFORM_ID.equals(this.getTransformClass())) {
                this.generateTableMacros(codeSegment, false);
            }
            codeSegment.addSourceCode("\n");
            if (this.m_transformDefinition.isDeletingOutputs()) {
                this.genTableDelete(codeSegment, Arrays.asList(targets));
            }
            try {
                IPromptModel model = this.getOptionModel();
                if (model != null) {
                    IPromptDefinitionValue definition;
                    if (REST_TRANSFORM_ID.equals(this.getTransformClass()) && null != (definition = model.getPromptDefinitionValue("jsonLibrary"))) {
                        definition.setGenerateLibnames(false);
                    }
                    codeSegment.addSourceCode(model.getOptionsString(codeSegment, true, true)).addSourceCode("\n");
                }
            }
            catch (BadServerDefinitionException e) {
                throw new CodegenException(e, (IObject)this);
            }
            catch (BadLibraryDefinitionException e) {
                throw new CodegenException(e, (IObject)this);
            }
            catch (FileNotFoundException e) {
                throw new CodegenException(e, (IObject)this);
            }
            catch (ServerConnectionException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)this);
            }
            catch (ServiceException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)this);
            }
            catch (ParserConfigurationException e) {
                throw new CodegenException(e, (IObject)this);
            }
            catch (SAXException e) {
                throw new CodegenException(e, (IObject)this);
            }
            catch (MdException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)this);
            }
            catch (IOException e) {
                throw new CodegenException(e, (IObject)this);
            }
            if (targets.length > 0) {
                ArrayList<IColumn> lColumns = new ArrayList<IColumn>();
                for (int i = 0; i < targets.length; ++i) {
                    lColumns.addAll(Arrays.asList(targets[i].getColumns()));
                }
                codeSegment.addSourceCode(PromptUtils.getTableKeepLetStatement(codeSegment, "", "_keep", lColumns.toArray(new IColumn[lColumns.size()])));
                codeSegment.addSourceCode(PromptUtils.getTableKeepLetStatement(codeSegment, "", "keep", lColumns.toArray(new IColumn[lColumns.size()])));
            }
            codeSegment.addSourceCode(this.m_transformDefinition.getSourceCode()).addSourceCode("\n\n");
            if (this.isUpdateTableMetadata()) {
                for (int i = 0; i < targets.length; ++i) {
                    codeSegment.addSourceCode(targets[i].getUpdateTableMetadataCode()).addSourceCode("\n");
                }
            }
            codeSegment.genRCSetCall("&syserr", false);
            codeSegment.genRCSetCall("&sysrc", false);
            codeSegment.genRCSetCall("&sqlrc");
        }
        return codeSegment;
    }

    private class SetUpdateTableMetadataUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldUpdateTableMetadata;
        private boolean m_newUpdateTableMetadata;

        public SetUpdateTableMetadataUndoable(boolean oldUpdateTableMetadata, boolean newUpdateTableMetadata) {
            this.m_oldUpdateTableMetadata = oldUpdateTableMetadata;
            this.m_newUpdateTableMetadata = newUpdateTableMetadata;
        }

        @Override
        public void undo() {
            super.undo();
            GeneratedTransformModel.this.setUpdateTableMetadata(this.m_oldUpdateTableMetadata);
        }

        @Override
        public void redo() {
            super.redo();
            GeneratedTransformModel.this.setUpdateTableMetadata(this.m_newUpdateTableMetadata);
        }
    }

    private class SetTemplateUndoable
    extends AbstractUndoableEdit {
        private IGeneratedTransformTemplate m_oldTemplate;
        private IGeneratedTransformTemplate m_newTemplate;

        public SetTemplateUndoable(IGeneratedTransformTemplate oldTemplate, IGeneratedTransformTemplate newTemplate) {
            this.m_oldTemplate = oldTemplate;
            this.m_newTemplate = newTemplate;
        }

        @Override
        public void undo() {
            super.undo();
            GeneratedTransformModel.this.setTemplate(this.m_oldTemplate);
        }

        @Override
        public void redo() {
            super.redo();
            GeneratedTransformModel.this.setTemplate(this.m_newTemplate);
        }
    }

    private class AddInputPortUndoable
    extends AbstractUndoableEdit {
        private IGeneratedTransformPort m_port;

        public AddInputPortUndoable(IGeneratedTransformPort port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            GeneratedTransformModel.this.removePort(true, this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            GeneratedTransformModel.this.addPort(true, this.m_port);
        }
    }

    private class AddOutputPortUndoable
    extends AbstractUndoableEdit {
        private IGeneratedTransformPort m_port;

        public AddOutputPortUndoable(IGeneratedTransformPort port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            GeneratedTransformModel.this.removePort(false, this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            GeneratedTransformModel.this.addPort(false, this.m_port);
        }
    }

    private class RemoveInputPortUndoable
    extends AbstractUndoableEdit {
        private IGeneratedTransformPort m_port;

        public RemoveInputPortUndoable(IGeneratedTransformPort port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            GeneratedTransformModel.this.addPort(true, this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            GeneratedTransformModel.this.removePort(true, this.m_port);
        }
    }

    private class RemoveOutputPortUndoable
    extends AbstractUndoableEdit {
        private IGeneratedTransformPort m_port;

        public RemoveOutputPortUndoable(IGeneratedTransformPort port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            GeneratedTransformModel.this.addPort(false, this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            GeneratedTransformModel.this.removePort(false, this.m_port);
        }
    }
}

