/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FileReaderTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.FileReader";
    private static final String TRANSFORMATION_ROLE = "FileReader";
    private static final String ARM_DISPLAY_NAME = "FileReader";

    public FileReaderTransformModel(String id, IModel model) {
        super(id, model);
    }

    @Override
    protected String getTransformRole() {
        return "FileReader";
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("FileReaderTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return "FileReader";
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("FileReaderTransformModel.Name.txt");
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable table = super.addNewWorkTable();
            table.setView(true);
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addDefaultSettings() {
        this.addNewWorkTable();
    }

    @Override
    public IServer getServerForStep(IServer defaultServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        if (this.getDataSources().length == 0) {
            return null;
        }
        IExternalTable sourceTable = (IExternalTable)this.getDataSources()[0];
        IServer server = sourceTable.getServer();
        if (server == null) {
            server = defaultServer;
        }
        return server;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IExternalTable sourceTable = (IExternalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        String targetName = target.getFullNameQuotedAsNeeded(codeSegment);
        String datastepTargetName = "";
        boolean mappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), sourceTable, target, null, true);
        datastepTargetName = mappingNeeded ? (targetName.length() > 27 ? DBMSNamesUtil.getLibrefPart(targetName) + ".etls_" + codeSegment.getUniqueWorkTableName() : target.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), false, true, "etls_")) : targetName;
        codeSegment.genTableDelete(datastepTargetName);
        ITransformTableOptions targetOptionObj = this.getTableOptionObject(target, false);
        codeSegment.addSourceCode(sourceTable.getDataStepCodeToCreateTable(codeSegment.getCodeGenerationEnvironment(), datastepTargetName, target.isView(), mappingNeeded ? "" : targetOptionObj.getTableOptions(false, codeSegment.getCurrentServer()), mappingNeeded));
        codeSegment.genRCSetCall("&syserr");
        if (mappingNeeded) {
            this.getOrdinaryMappingCode(codeSegment, sourceTable, target, targetName, datastepTargetName, "", targetOptionObj.getTableOptions(codeSegment.getCurrentServer()), target.isView(), true, true, null, null, false, null, null, null);
            if (!target.isView()) {
                codeSegment.genTableDelete(datastepTargetName);
            }
        }
        return codeSegment;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        IPromptModel pm = super.createOptionModel();
        IPromptDefinitionValue dbiDefinition = pm.getPromptDefinitionValue("FILEMACROVARS");
        if (dbiDefinition != null) {
            dbiDefinition.setHidden(false);
        }
        return pm;
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        if (this.getDataSourcesCount() > 0) {
            IExternalTable sourceTable = (IExternalTable)this.getDataSources()[0];
            return !sourceTable.isUsingUserWrittenCode();
        }
        return !this.isUsingUserWrittenCode();
    }
}

