/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DB2UNXPCType;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.impl.SQLSortingColumn;
import com.sas.etl.models.job.transforms.splitter.IRowSelector;
import com.sas.etl.models.job.transforms.splitter.IRowSelectorTransform;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.etl.models.prompts.impl.PromptDataProvider;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.GroupByClause;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.Select;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ExtractTransformModel
extends AbstractDataTransform
implements IRowSelectorTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.SASExtract";
    private static final String TRANSFORMATION_ROLE = "SASExtract";
    private static final String ARM_DISPLAY_NAME = "Extract";
    private static final String ORDER_BY_CHANGED = "SASExtract:OrderByChanged";
    private static final String GROUP_BY_CHANGED = "SASExtract:GroupByChanged";
    private static final String ROW_SELECTOR_CHANGED = "SASExtract:RowSelectorChanged";
    public static final String DISTINCT_OPTION_CHANGED = "SASExtract:DistinctChanged";
    private static final String DISTINCT_OPTION = "DISTINCT";
    private ModelList m_lRowSels = new cRowSelectorList(this, new String[]{"RowSelector:RowSelectorAdded", "RowSelector:RowSelectorRemoved"}, 3, IRowSelector.class);
    private IGroupBy m_groupBy;
    private IOrderBy m_orderBy;
    private boolean m_isDistinctOptionSet = false;
    private cExtractOptionModel m_extractOptionModel;

    public ExtractTransformModel(String sID, IModel model) {
        super(sID, model);
        if (this.isNew()) {
            IRowSelector rowSel = this.getModel().getObjectFactory().createNewRowSelector(this.getID());
            this.m_lRowSels.add(rowSel);
            this.m_groupBy = this.getModel().getObjectFactory().createNewSQLGroupBy(this.getID());
            this.m_orderBy = this.getModel().getObjectFactory().createNewSQLOrderBy(this.getID());
        }
    }

    @Override
    protected String getDefaultDBIDirectExecValue() {
        return "DBIDIRECTEXEC";
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("ExtractTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("ExtractTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public void delete() {
        this.m_lRowSels.delete();
        if (this.m_groupBy != null) {
            this.m_groupBy.delete();
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.delete();
        }
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        super.deleteFromOMR(omr);
        if (this.m_groupBy != null) {
            this.m_groupBy.deleteFromOMR(omr);
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.deleteFromOMR(omr);
        }
        this.m_lRowSels.deleteFromOMR(omr);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.m_lRowSels.isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        lReasons.addAll(this.m_lRowSels.getReasonsIncomplete());
        return lReasons;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Select mdoCM = (Select)this.getClassifierMapObject(omr);
        this.savePropertyToOMR(omr, "OPTIONS", DISTINCT_OPTION, DISTINCT_OPTION, DISTINCT_OPTION, this.isDistinctOptionSet() ? "YES" : "NO", 12, 2);
        this.getRowSelector().setClassifierMapID(this.getClassifierMapId());
        this.m_lRowSels.saveToOMR(omr, (List)mdoCM.getAssociatedRowSelectors(false));
        IGroupBy groupBy = this.getGroupBy();
        groupBy.saveToOMR(omr);
        mdoCM.setGroupByForSelect((GroupByClause)omr.acquireOMRObject(groupBy));
        IOrderBy orderBy = this.getOrderBy();
        orderBy.saveToOMR(omr);
        mdoCM.setOrderByForSelect((OrderByClause)omr.acquireOMRObject(orderBy));
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setDistinctOption("YES".equals(this.loadPropertyFromOMR(omr, "OPTIONS", DISTINCT_OPTION, "NO", 2)));
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        AssociationList rows = mdoCM.getAssociatedRowSelectors();
        if (!rows.isEmpty()) {
            this.m_lRowSels.loadFromOMR(omr, (List)rows);
        } else if (this.m_lRowSels.size() == 0) {
            IRowSelector rowSel = this.getModel().getObjectFactory().createNewRowSelector(this.getID());
            this.m_lRowSels.add(rowSel);
        }
        IObjectFactory factory = this.getModel().getObjectFactory();
        GroupByClause gbc = ((Select)mdoCM).getGroupByForSelect();
        IGroupBy groupBy = null;
        if (gbc != null) {
            groupBy = factory.createSQLGroupBy(gbc.getFQID());
            groupBy.loadFromOMR(omr);
        } else {
            groupBy = this.getModel().getObjectFactory().createNewSQLGroupBy(this.getID());
        }
        this.setGroupBy(groupBy);
        OrderByClause obc = ((Select)mdoCM).getOrderByForSelect();
        IOrderBy orderBy = null;
        if (obc != null) {
            orderBy = factory.createSQLOrderBy(obc.getFQID());
            orderBy.loadFromOMR(omr);
        } else {
            orderBy = this.getModel().getObjectFactory().createNewSQLOrderBy(this.getID());
        }
        this.setOrderBy(orderBy);
        this.setChanged(false);
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        this.m_extractOptionModel = new cExtractOptionModel();
        return this.m_extractOptionModel;
    }

    @Override
    public boolean isChanged() {
        boolean orderByChanged = false;
        boolean groupByChanged = false;
        if (this.m_orderBy != null) {
            orderByChanged = this.m_orderBy.isChanged();
        }
        if (this.m_groupBy != null) {
            groupByChanged = this.m_groupBy.isChanged();
        }
        return super.isChanged() || this.m_lRowSels.isChanged() || orderByChanged || groupByChanged || this.isUsingUserWrittenCode();
    }

    public boolean isGroupByColumns() {
        if (this.m_groupBy == null) {
            return false;
        }
        return this.m_groupBy.getSortColumnList().size() > 0;
    }

    public boolean isOrderByColumns() {
        if (this.m_orderBy == null) {
            return false;
        }
        return this.m_orderBy.getSortColumnList().size() > 0;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        IRowSelector rowSel = this.getRowSelector();
        if (rowSel != null) {
            rowSel.updateIDs(mapIDs);
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.updateIDs(mapIDs);
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.updateIDs(mapIDs);
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getClassifierMapType());
        lAssociations.add("GroupByForSelect");
        lAssociations.add("OrderByForSelect");
        lAssociations.add("AssociatedRowSelector");
        return map;
    }

    @Override
    protected String getClassifierMapType() {
        return "Select";
    }

    @Override
    public void addDefaultSettings() {
        this.addNewWorkTable();
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable table = super.addNewWorkTable();
            table.setView(true);
            IWorkTable iWorkTable = table;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IRowSelector getRowSelector() {
        if (!this.m_lRowSels.isEmpty()) {
            return (IRowSelector)this.m_lRowSels.get(0);
        }
        return null;
    }

    @Override
    public boolean isValidateAvailable() {
        return true;
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validateCode) throws ServerException, CodegenException, RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException {
        ILibrary library;
        ITextExpression textExpression;
        super.getGeneratedCode(codeSegment, validateCode);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        String whereClause = null;
        IRowSelector rowSelector = this.getRowSelector();
        if (rowSelector != null && (textExpression = rowSelector.getExpression()) != null) {
            textExpression.setUseSQLSyntax(false);
            String expression = textExpression.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting());
            whereClause = expression.length() > 0 ? "where " + expression : "";
        }
        if ((library = target.getLibraryForUseInJob()) != null) {
            boolean isDBMSTemp = target.getLibraryForUseInJob().isDBMSTemp(library);
            if (target.getDBMSType() instanceof DB2UNXPCType && isDBMSTemp) {
                codeSegment.genSQLTableDelete(target.getFullNameQuotedAsNeeded(codeSegment), "", false);
            }
        }
        ITransformTableOptions sourceOpts = this.getTableOptionObject(source, true);
        ITransformTableOptions targetOpts = this.getTableOptionObject(target, false);
        boolean useDistinctKeyword = this.isDistinctOptionSet();
        ArrayList columnsToExcludeFromMapping = new ArrayList();
        this.getOrdinaryMappingCode(codeSegment, source, target, !validateCode ? target.getFullNameQuotedAsNeeded(codeSegment) : target.getLibref(codeSegment.getCurrentServer()) + "." + codeSegment.getUniqueWorkTableName(), "&SYSLAST", sourceOpts.getTableOptions(false, codeSegment.getCurrentServer()), targetOpts.getTableOptions(false, codeSegment.getCurrentServer()), target.isView(), true, true, columnsToExcludeFromMapping.toArray(new IColumn[columnsToExcludeFromMapping.size()]), columnsToExcludeFromMapping.toArray(new IColumn[columnsToExcludeFromMapping.size()]), useDistinctKeyword, whereClause, this.getGroupBy(), this.getOrderBy(), true, true, validateCode);
        codeSegment.genPushDownMacroCode();
        codeSegment.genRCSetCall("&sqlrc");
        return codeSegment;
    }

    public void setRowSelector(IRowSelector newRowSelector) {
        if (newRowSelector == null) {
            throw new IllegalArgumentException("row selector cannot be null");
        }
        IRowSelector rowSel = this.getRowSelector();
        if (rowSel == newRowSelector) {
            return;
        }
        this.m_lRowSels.clear();
        this.m_lRowSels.add(newRowSelector);
    }

    public IGroupBy getGroupBy() {
        return this.m_groupBy;
    }

    public void setGroupBy(IGroupBy newGroupBy) {
        if (newGroupBy == null) {
            throw new IllegalArgumentException("group by object cannot be null");
        }
        if (this.m_groupBy == newGroupBy) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGroupByUndoable(this.m_groupBy, newGroupBy));
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.removeNotifyListener(this);
        }
        this.m_groupBy = newGroupBy;
        if (this.m_groupBy != null) {
            this.m_groupBy.addNotifyListener(this);
        }
        this.fireModelChangedEvent(GROUP_BY_CHANGED, null);
    }

    public IOrderBy getOrderBy() {
        return this.m_orderBy;
    }

    public void setOrderBy(IOrderBy newOrderBy) {
        if (newOrderBy == null) {
            throw new IllegalArgumentException("order by cannot be null");
        }
        if (this.m_orderBy == newOrderBy) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOrderByUndoable(this.m_orderBy, newOrderBy));
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.removeNotifyListener(this);
        }
        this.m_orderBy = newOrderBy;
        if (this.m_orderBy != null) {
            this.m_orderBy.addNotifyListener(this);
        }
        this.fireModelChangedEvent(ORDER_BY_CHANGED, null);
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() == this.getRowSelector() && ev.getType() == 1) {
            this.fireModelChangedEvent(ROW_SELECTOR_CHANGED, null);
        }
        if (ev.getSource() == this.m_groupBy && ev.getType() == 1) {
            this.fireModelChangedEvent(GROUP_BY_CHANGED, null);
        }
        if (ev.getSource() == this.m_orderBy && ev.getType() == 1) {
            this.fireModelChangedEvent(ORDER_BY_CHANGED, null);
        }
        super.notify(ev);
    }

    @Override
    public boolean isCleanUpRequired() {
        return false;
    }

    public void setDistinctOption(boolean newDistinctOptionSet) {
        this.startCompoundUndoable();
        try {
            if (this.m_isDistinctOptionSet == newDistinctOptionSet) {
                return;
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetDistinctOptionUndoable(this.m_isDistinctOptionSet, newDistinctOptionSet));
            }
            this.m_isDistinctOptionSet = newDistinctOptionSet;
            this.fireModelChangedEvent(DISTINCT_OPTION_CHANGED, null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addDataSource(IDataObject source) {
        super.addDataSource(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            ITextExpression exp = this.getRowSelector().getExpression();
            if (exp != null) {
                exp.replaceTableColumns(oldTable, newTable);
            }
            this.getRowSelector().setClassifierMapID(this.getClassifierMapId());
            this.getRowSelector().setTable(newTable);
            super.replaceSourceTable(oldTable, newTable, columnsMap, portIndexes);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected void preRemoveDataSource(IDataObject source) {
        super.preRemoveDataSource(source);
        IRowSelector rowSelector = this.getRowSelector();
        if (rowSelector != null) {
            rowSelector.setTable(null);
            IColumn[] aCols = ((ITable)source).getColumns();
            for (int index = 0; index < aCols.length; ++index) {
                ITextExpression expr = rowSelector.getExpression();
                if (expr == null) continue;
                expr.replaceColumn(aCols[index], null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postAddDataSource(IDataObject source) {
        this.startCompoundUndoable();
        try {
            super.postAddDataSource(source);
            IRowSelector rowSelector = this.getRowSelector();
            if (rowSelector != null) {
                rowSelector.setTable((ITable)source);
                IColumn[] aCols = ((ITable)source).getColumns();
                for (int index = 0; index < aCols.length; ++index) {
                    ITextExpression expr = rowSelector.getExpression();
                    if (expr == null) continue;
                    expr.replaceColumn(null, aCols[index]);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            IColumn[] aNewColumns = newTable.getColumns();
            this.getGroupBy().replaceSortColumns(aNewColumns, newTable.getTableName());
            this.getOrderBy().replaceSortColumns(aNewColumns, newTable.getTableName());
            super.replaceTargetTable(oldTable, newTable, columnsMap);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataTarget(IDataObject target) {
        this.startCompoundUndoable();
        try {
            List orderByList;
            List groupList;
            SQLSortingColumn col;
            super.removeDataTarget(target);
            if (this.getGroupBy().getSortColumnList().size() > 0 && (col = (SQLSortingColumn)(groupList = this.getGroupBy().getSortColumnList()).get(0)).getColumn().getTable().equals(target)) {
                for (int i = 0; i < groupList.size(); ++i) {
                    this.getGroupBy().removeSortColumn((ISortColumn)groupList.get(i));
                }
            }
            if (this.getOrderBy().getSortColumnList().size() > 0 && (col = (SQLSortingColumn)(orderByList = this.getOrderBy().getSortColumnList()).get(0)).getColumn().getTable().equals(target)) {
                for (int j = 0; j < orderByList.size(); ++j) {
                    this.getOrderBy().removeSortColumn((ISortColumn)orderByList.get(j));
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public boolean isDistinctOptionSet() {
        return this.m_isDistinctOptionSet;
    }

    @Override
    public List getRowSelectorList() {
        return this.m_lRowSels;
    }

    @Override
    public IRowSelector[] getRowSelectorObjects() {
        return (IRowSelector[])this.m_lRowSels.toArray(new IRowSelector[this.m_lRowSels.size()]);
    }

    private class cRowSelectorList
    extends ModelList {
        public cRowSelectorList(AbstractPersistableObject owner, String[] aEventIDs, int ePersistenceType, Class clsAllowedType) {
            super(owner, aEventIDs, ePersistenceType, clsAllowedType);
        }

        @Override
        protected void addImpl(int iObj, Object obj) {
            super.addImpl(iObj, obj);
            IRowSelector rowSel = (IRowSelector)obj;
            rowSel.setClassifierMapID(ExtractTransformModel.this.getClassifierMapId());
            rowSel.addNotifyListener(ExtractTransformModel.this);
            if (ExtractTransformModel.this.getSourceTables().length > 0) {
                rowSel.setTable(ExtractTransformModel.this.getSourceTables()[0]);
            }
        }

        @Override
        protected Object removeImpl(int iObject) {
            IRowSelector rowSel = (IRowSelector)super.removeImpl(iObject);
            rowSel.removeNotifyListener(ExtractTransformModel.this);
            return rowSel;
        }
    }

    protected class cExtractOptionModel
    extends BaseDataTransformPromptModel
    implements IPromptModel {
        public cExtractOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(ExtractTransformModel.this.getModel(), ExtractTransformModel.this);
            IPromptDefinitionValue dbiDefinition = this.getPromptDefinitionValue("OPTION_DBI_DIRECT_EXEC");
            if (dbiDefinition != null) {
                dbiDefinition.setHidden(false);
                dbiDefinition.setDefaultValue(ExtractTransformModel.this.getDefaultDBIDirectExecValue());
            }
        }

        @Override
        public PromptDataProvider createDataProvider() throws ServiceException, RemoteException, MdException, ServerConnectionException {
            return null;
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cExtractOptionModel.class.getResource("res/Options_SQLExtract_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            ExtractTransformModel transform = (ExtractTransformModel)this.getOwner();
            String yesno = "NO";
            if (transform.isDistinctOptionSet()) {
                yesno = "YES";
            }
            this.setOptionValue(ExtractTransformModel.DISTINCT_OPTION, (Object)yesno);
        }

        @Override
        protected IModelListener createModelListener() {
            return new cExtractModelChangeListener();
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new ExtractTransformValueChangedListener((ExtractTransformModel)this.getOwner(), this);
        }

        private class cExtractModelChangeListener
        extends BaseDataTransformModelListener {
            public cExtractModelChangeListener() {
                super(cExtractOptionModel.this.getOwner(), cExtractOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(ExtractTransformModel.DISTINCT_OPTION_CHANGED)) {
                        cExtractOptionModel.this.setOptionValue(ExtractTransformModel.DISTINCT_OPTION, (Object)(ExtractTransformModel.this.isDistinctOptionSet() ? "YES" : "NO"));
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class ExtractTransformValueChangedListener
        extends BaseDataTransformValueChangedListener {
            public ExtractTransformValueChangedListener(ExtractTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals(ExtractTransformModel.DISTINCT_OPTION)) {
                        ExtractTransformModel.this.setDistinctOption(value.toString().equals("YES"));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                    ExtractTransformModel.this.getPromptModel().setListeningForChanges(true);
                    cExtractOptionModel.this.setChanged(true);
                }
            }
        }
    }

    private class SetGroupByUndoable
    extends AbstractUndoableEdit {
        private IGroupBy m_oldGroupBySetting;
        private IGroupBy m_newGroupBySetting;

        public SetGroupByUndoable(IGroupBy oldGroupBySetting, IGroupBy newGroupBySetting) {
            this.m_oldGroupBySetting = oldGroupBySetting;
            this.m_newGroupBySetting = newGroupBySetting;
        }

        @Override
        public void undo() {
            super.undo();
            ExtractTransformModel.this.setGroupBy(this.m_oldGroupBySetting);
        }

        @Override
        public void redo() {
            super.redo();
            ExtractTransformModel.this.setGroupBy(this.m_newGroupBySetting);
        }
    }

    private class SetOrderByUndoable
    extends AbstractUndoableEdit {
        private IOrderBy m_oldOrderBySetting;
        private IOrderBy m_newOrderBySetting;

        public SetOrderByUndoable(IOrderBy oldSetting, IOrderBy newSetting) {
            this.m_oldOrderBySetting = oldSetting;
            this.m_newOrderBySetting = newSetting;
        }

        @Override
        public void undo() {
            super.undo();
            ExtractTransformModel.this.setOrderBy(this.m_oldOrderBySetting);
        }

        @Override
        public void redo() {
            super.redo();
            ExtractTransformModel.this.setOrderBy(this.m_newOrderBySetting);
        }
    }

    private class SetDistinctOptionUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldDistinctOptionSetting;
        private boolean m_newDistinctOptionSetting;

        public SetDistinctOptionUndoable(boolean oldSetting, boolean newSetting) {
            this.m_oldDistinctOptionSetting = oldSetting;
            this.m_newDistinctOptionSetting = newSetting;
        }

        @Override
        public void undo() {
            super.undo();
            ExtractTransformModel.this.setDistinctOption(this.m_oldDistinctOptionSetting);
        }

        @Override
        public void redo() {
            super.redo();
            ExtractTransformModel.this.setDistinctOption(this.m_newDistinctOptionSetting);
        }
    }
}

