/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.INotifyListener;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.IFile;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeFragment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class UserWrittenCodeContainer
implements IUserWrittenCodeContainer,
INotifyListener {
    private ICodeSource m_userWrittenCode;
    private IPersistableObject m_owner;
    private IModel m_model;
    private boolean m_bIsChanged;
    private String m_containerOMRType;
    private String m_containerId;
    private List m_lDeletedObjects;
    private String m_name;
    private String m_containerRole;
    private boolean m_bIsActive;
    private int m_activeFlag;
    private String m_activeEventName;
    private String m_codeChangeEventName;
    private String m_description;
    private String m_tempId;
    private String m_sTextRole;
    private String m_sTextType;
    private boolean m_bSourceAttributes;

    public UserWrittenCodeContainer(IPersistableObject owner) {
        this.setOwner(owner);
        this.m_model = owner.getModel();
        this.m_bIsChanged = false;
        this.m_lDeletedObjects = new ArrayList();
        this.m_containerRole = "UserWrittenSourceCode";
        this.m_name = "";
        this.m_bIsActive = false;
        this.m_activeFlag = 1;
        this.m_activeEventName = "IUserWrittenCode:activeChanged";
        this.m_codeChangeEventName = "IUserWrittenCode:codeChanged";
        this.m_containerOMRType = "TransformationStep";
        this.m_description = "SAS Code";
        this.m_sTextRole = "SAS code";
        this.m_sTextType = "SAS";
    }

    @Override
    public Map getOMRLoadTemplateMap(Map map) {
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getContainerOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
        }
        lAssociations.add("SourceCode");
        map.put(this.getContainerOMRType(), lAssociations);
        return map;
    }

    @Override
    public void setSourceAttributes(boolean setAttrs) {
        this.m_bSourceAttributes = setAttrs;
    }

    @Override
    public void setTextRole(String textRole) {
        this.m_sTextRole = textRole;
    }

    @Override
    public void setTextType(String textType) {
        this.m_sTextType = textType;
    }

    @Override
    public String getTextRole() {
        return this.m_sTextRole;
    }

    @Override
    public String getTextType() {
        return this.m_sTextType;
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() == this.getUserWrittenSourceCode()) {
            ModelEvent mdEv = ev.getModelEvent();
            if (0 == ev.getType() || mdEv != null && "CodeSource:CodeChanged".equals(mdEv.getType())) {
                this.m_model.fireModelEvent(new ModelEvent(this.m_model, this.m_owner, this.m_codeChangeEventName, this.m_userWrittenCode));
            }
        }
    }

    @Override
    public void addNotifyListener(INotifyListener lsnr) {
    }

    @Override
    public void removeNotifyListener(INotifyListener lsnr) {
    }

    @Override
    public void dispose() {
        if (this.m_userWrittenCode != null) {
            this.m_userWrittenCode.dispose();
        }
    }

    @Override
    public void dump(PrintStream strm) {
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getID() {
        if (this.m_containerId != null) {
            return this.m_containerId;
        }
        if (this.m_tempId == null) {
            this.m_tempId = this.getModel().createIDForNewObject(this.getOwner().getID());
        }
        return this.m_tempId;
    }

    @Override
    public boolean isNew() {
        return this.m_model.isNewObjectID(this.m_containerId);
    }

    @Override
    public String getUserProperty(String sName) {
        return null;
    }

    @Override
    public boolean isComplete() {
        if (this.isActive() && this.getUserWrittenSourceCode() == null) {
            return false;
        }
        return !this.isActive() || this.getUserWrittenSourceCode() == null || this.getUserWrittenSourceCode().isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        ArrayList<String> lReasons = new ArrayList<String>();
        if (this.isActive() && this.getUserWrittenSourceCode() == null) {
            lReasons.add(RB.getStringResource("UserWrittenCodeContainer.NoSourceCode.msg.txt"));
        } else if (this.isActive() && this.getUserWrittenSourceCode() != null) {
            List uwReasons = this.getUserWrittenSourceCode().getReasonsIncomplete();
            for (int i = 0; i < uwReasons.size(); ++i) {
                lReasons.add(this.getName() + ": " + uwReasons.get(i));
            }
        }
        return lReasons;
    }

    @Override
    public boolean hasWarnings() {
        return false;
    }

    @Override
    public List getWarnings() {
        return new ArrayList();
    }

    @Override
    public void removeUserProperty(String sName) {
    }

    @Override
    public void setDescription(String sDescription) {
        this.m_description = sDescription;
    }

    @Override
    public void setUserProperty(String sName, String sValue) {
    }

    @Override
    public void setActiveEventName(String eventName) {
        this.m_activeEventName = eventName;
    }

    @Override
    public void setCodeChangeEventName(String eventName) {
        this.m_codeChangeEventName = eventName;
    }

    @Override
    public int getActiveFlagLocation() {
        return this.m_activeFlag;
    }

    @Override
    public void setActiveFlagLocation(int activeFlagLocation) {
        if (activeFlagLocation != 0 && activeFlagLocation != 1 && activeFlagLocation != 2) {
            throw new IllegalArgumentException("Wrong active flag location");
        }
        this.m_activeFlag = activeFlagLocation;
    }

    @Override
    public boolean isActive() {
        return this.m_bIsActive;
    }

    @Override
    public void setIsActive(boolean active) {
        if (this.m_bIsActive == active) {
            return;
        }
        if (this.m_model.isUndoSupported()) {
            this.m_model.undoableEditHappened(new SetUserWrittenActiveUndoable(this.m_bIsActive, active));
        }
        this.m_bIsActive = active;
        this.setChanged(true);
        this.m_model.fireModelEvent(new ModelEvent(this.m_model, this.m_owner, this.m_activeEventName, null));
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setContainerRole(String containerRole) {
        this.m_containerRole = containerRole;
    }

    @Override
    public String getContainerRole() {
        return this.m_containerRole;
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        ICodeSource codeSource;
        this.deleteDeletedObjectsFromOMR(omr);
        String containerId = this.getContainerId();
        if (containerId != null && !this.m_model.isNewObjectID(containerId)) {
            omr.deleteOMRObject(containerId, this.getContainerOMRType());
        }
        if ((codeSource = this.getUserWrittenSourceCode()) != null) {
            codeSource.deleteFromOMR(omr);
        }
    }

    protected void addToDeletedObjects(IPersistableObject obj) {
        if (this.m_lDeletedObjects == null) {
            this.m_lDeletedObjects = new ArrayList();
        }
        this.m_lDeletedObjects.add(obj);
        this.getModel().removeObject(obj);
        obj.delete();
    }

    protected void removeFromDeletedObjects(IPersistableObject obj) {
        if (obj == null) {
            return;
        }
        if (this.m_lDeletedObjects == null) {
            return;
        }
        this.m_lDeletedObjects.remove(obj);
        this.getModel().putObject(obj);
    }

    private void deleteDeletedObjectsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.m_lDeletedObjects == null) {
            return;
        }
        for (int iObject = 0; iObject < this.m_lDeletedObjects.size(); ++iObject) {
            ((IPersistableObject)this.m_lDeletedObjects.get(iObject)).deleteFromOMR(omr);
        }
        this.m_lDeletedObjects.clear();
    }

    @Override
    public IFile createUserWrittenSourceCodeFile(IServer server) {
        return this.createUserWrittenSourceCodeFile(this.getName(), server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFile createUserWrittenSourceCodeFile(String sName, IServer server) {
        IFile srcCode = this.m_model.getObjectFactory().createNewFile(this.m_owner.getID());
        this.m_model.startCompoundUndoable();
        try {
            srcCode.setName(sName);
            srcCode.setServer(server);
        }
        finally {
            this.m_model.endCompoundUndoable();
        }
        return srcCode;
    }

    @Override
    public ICodeFragment createUserWrittenSourceCodeText() {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            name = "UserWrittenSourceCode";
        }
        return this.createUserWrittenSourceCodeText(name);
    }

    @Override
    public ICodeFragment createUserWrittenSourceCodeText(String sName) {
        ICodeFragment srcCode = this.m_model.getObjectFactory().createNewCodeFragment(this.m_owner.getID());
        this.m_model.startCompoundUndoable();
        try {
            srcCode.setName(sName);
            this.setUserWrittenSourceCode(srcCode);
        }
        finally {
            this.m_model.endCompoundUndoable();
        }
        return srcCode;
    }

    @Override
    public boolean isFile() {
        return this.m_userWrittenCode instanceof IFile;
    }

    @Override
    public IModel getModel() {
        return this.m_model;
    }

    @Override
    public IPersistableObject getOwner() {
        return this.m_owner;
    }

    @Override
    public void setOwner(IPersistableObject owner) {
        this.m_owner = owner;
    }

    @Override
    public void setContainerOMRType(String containerOMRType) {
        this.m_containerOMRType = containerOMRType;
    }

    @Override
    public String getContainerOMRType() {
        return this.m_containerOMRType;
    }

    @Override
    public void setContainerId(String containerId) {
        this.m_containerId = containerId;
    }

    @Override
    public String getContainerId() {
        return this.m_containerId;
    }

    @Override
    public String getCode() throws ServerException {
        String code = "";
        if (this.m_userWrittenCode != null) {
            code = this.m_userWrittenCode.getCode();
        }
        return code;
    }

    @Override
    public ICodeSource getUserWrittenSourceCode() {
        return this.m_userWrittenCode;
    }

    @Override
    public void setUserWrittenSourceCode(ICodeSource userWritten) {
        if (userWritten == this.m_userWrittenCode) {
            return;
        }
        if (this.m_userWrittenCode != null) {
            this.addToDeletedObjects(this.m_userWrittenCode);
            this.m_userWrittenCode.removeNotifyListener(this);
        }
        this.removeFromDeletedObjects(userWritten);
        if (this.m_model.isUndoSupported()) {
            this.m_model.undoableEditHappened(new SetUserWrittenCodeUndoable(this.m_userWrittenCode, userWritten));
        }
        this.m_userWrittenCode = userWritten;
        if (this.m_userWrittenCode != null) {
            this.m_userWrittenCode.addNotifyListener(this);
        }
        this.setChanged(true);
        this.m_model.fireModelEvent(new ModelEvent(this.m_model, this.m_owner, this.m_codeChangeEventName, this.m_userWrittenCode));
    }

    @Override
    public boolean isChanged() {
        return this.m_bIsChanged || this.m_userWrittenCode != null && this.m_userWrittenCode.isChanged();
    }

    @Override
    public void setChanged(boolean changed) {
        this.m_bIsChanged = changed;
    }

    @Override
    public void updateIds(Map mapIDs) {
        this.m_containerId = this.updateSubordinateID(this.m_containerId, mapIDs);
        ICodeSource code = this.getUserWrittenSourceCode();
        if (code != null) {
            code.updateIDs(mapIDs);
        }
    }

    protected final String updateSubordinateID(String sSubordinateID, Map mapIDs) {
        if (sSubordinateID != null && this.m_model.isNewObjectID(sSubordinateID)) {
            return (String)mapIDs.get(sSubordinateID);
        }
        return sSubordinateID;
    }

    @Override
    public AbstractTransformation getOMRContainer(OMRAdapter omr) throws RemoteException, MdException {
        return this.getOMRContainer(omr, false);
    }

    private AbstractTransformation getOMRContainer(OMRAdapter omr, boolean createContainer) throws RemoteException, MdException {
        String containerId = this.getContainerId();
        if (containerId == null && createContainer) {
            containerId = this.m_model.createIDForNewObject(this.m_owner.getID());
            this.setContainerId(containerId);
        }
        AbstractTransformation container = null;
        if (containerId != null) {
            container = (AbstractTransformation)omr.acquireOMRObject(containerId, this.getContainerOMRType());
            if (!"".equals(container.getTransformRole()) || !"".equals(this.getContainerRole())) {
                container.setTransformRole(this.getContainerRole());
            }
            if ("".equals(container.getName()) && !"".equals(this.getName())) {
                container.setName(this.getName());
            }
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserWrittenCode(String userCode) {
        this.m_model.startCompoundUndoable();
        try {
            ICodeSource newCode = null;
            newCode = this.isFile() || this.m_userWrittenCode == null ? this.createUserWrittenSourceCodeText() : this.m_userWrittenCode;
            try {
                newCode.setCode(userCode);
            }
            catch (ServerException serverException) {
                // empty catch block
            }
            this.setUserWrittenSourceCode(newCode);
        }
        finally {
            this.m_model.endCompoundUndoable();
        }
    }

    @Override
    public void setContainer(AbstractTransformation container) throws RemoteException, MdException {
        if (container != null) {
            this.setContainerOMRType(container.getCMetadataType());
            this.setContainerId(container.getFQID());
            this.setName(container.getName());
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        Text sourceCode;
        AbstractTransformation rt = this.getOMRContainer(omr);
        if (rt == null) {
            return;
        }
        if (!"".equals(rt.getName())) {
            this.setName(rt.getName());
        }
        if ((sourceCode = rt.getSourceCode()) != null) {
            sourceCode.setTextRole(this.getTextRole());
            if ("".equals(sourceCode.getName())) {
                sourceCode.setName("UserWrittenSourceCode");
            }
            this.setUserWrittenSourceCode((ICodeSource)omr.acquireObject((Root)sourceCode));
        } else {
            this.setUserWrittenSourceCode(null);
        }
        int activeFlag = this.getActiveFlagLocation();
        if (activeFlag == 1) {
            this.setIsActive(rt.getIsActive() == 1);
        } else if (activeFlag == 2) {
            this.setIsActive(rt.getIsUserDefined() == 1);
        } else if (activeFlag == 0) {
            this.setIsActive(true);
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws RemoteException, MdException {
        int active;
        if (!this.isChanged()) {
            return;
        }
        AbstractTransformation rt = this.getOMRContainer(omr, true);
        if ("".equals(rt.getName())) {
            rt.setName(this.getName());
        }
        if (!"".equals(this.getContainerRole())) {
            rt.setTransformRole(this.getContainerRole());
        }
        Text omrSourceCode = null;
        ICodeSource codeSource = this.getUserWrittenSourceCode();
        if (codeSource != null) {
            if (codeSource instanceof ICodeFragment) {
                ICodeFragment f = (ICodeFragment)codeSource;
                f.setTextRole(this.getTextRole());
                f.setTextType(this.getTextType());
            }
            codeSource.saveToOMR(omr);
            omrSourceCode = (Text)omr.acquireOMRObject(codeSource);
        }
        rt.setSourceCode(omrSourceCode);
        int activeFlag = this.getActiveFlagLocation();
        int n = active = this.isActive() ? 1 : 0;
        if (activeFlag == 1) {
            rt.setIsActive(active);
        } else if (activeFlag == 2) {
            rt.setIsUserDefined(active);
        }
        this.deleteDeletedObjectsFromOMR(omr);
        this.setChanged(false);
    }

    private class SetUserWrittenActiveUndoable
    extends AbstractUndoableEdit {
        private boolean m_ActiveOld;
        private boolean m_ActiveNew;

        public SetUserWrittenActiveUndoable(boolean ActiveOld, boolean ActiveNew) {
            this.m_ActiveOld = ActiveOld;
            this.m_ActiveNew = ActiveNew;
        }

        @Override
        public void undo() {
            super.undo();
            UserWrittenCodeContainer.this.setIsActive(this.m_ActiveOld);
        }

        @Override
        public void redo() {
            super.redo();
            UserWrittenCodeContainer.this.setIsActive(this.m_ActiveNew);
        }
    }

    private class SetUserWrittenCodeUndoable
    extends AbstractUndoableEdit {
        private ICodeSource m_codeOld;
        private ICodeSource m_codeNew;

        public SetUserWrittenCodeUndoable(ICodeSource codeOld, ICodeSource codeNew) {
            this.m_codeOld = codeOld;
            this.m_codeNew = codeNew;
        }

        @Override
        public void undo() {
            super.undo();
            UserWrittenCodeContainer.this.setUserWrittenSourceCode(this.m_codeOld);
        }

        @Override
        public void redo() {
            super.redo();
            UserWrittenCodeContainer.this.setUserWrittenSourceCode(this.m_codeNew);
        }
    }
}

