/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.job.IMappingRule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileMappingRule
implements IMappingRule {
    private static String sConjunctions = "AND|OR|NOT|NOT_AND|NOT_OR";
    private static Pattern patternConjunctions = Pattern.compile(sConjunctions);
    private static Pattern patternSource = Pattern.compile("SOURCE\\.(NAME|LENGTH|TYPE|FORMAT|INFORMAT|DESCRIPTION|SORTORDER)((=(NOCASE|CASE)\\(.*?\\))*)");
    private static Pattern patternTarget = Pattern.compile("TARGET\\.(NAME|LENGTH|TYPE|FORMAT|INFORMAT|DESCRIPTION|SORTORDER)((=(NOCASE|CASE)\\(.*?\\))*)");
    private static Pattern patternCompares = Pattern.compile("CONTAINS_LIKE|CONTAINS_EQ|NOTLIKE|LIKE|LE|GE|EQ|LT|GT|NE");
    private static String sSpecificVariables = new String("^.*CASE\\((.*)\\)");
    private static Pattern patternSpecificVariables = Pattern.compile(sSpecificVariables);
    private static Pattern patternConstantCase = Pattern.compile("CONSTANT=CASE.*?\\)");
    private static Pattern patternConstantNoCase = Pattern.compile("CONSTANT=NOCASE.*?\\)", 66);
    private static String sConstantValueDelimiters = new String("(\\(|\\))");
    public static final int RULETYPE_SIMPLE = 0;
    public static final int RULETYPE_REGEX = 1;
    private String m_sExpression = null;
    private String m_sRule = null;
    private int m_iRuleType = 0;

    public FileMappingRule(String sRule, int iRuleType) {
        this.m_sRule = sRule;
        this.m_iRuleType = iRuleType;
    }

    @Override
    public boolean canMap(IColumn source, IColumn target) {
        boolean bCanMapTotal = false;
        String[] segments = this.m_sRule.split("\\[|(\\].*?,.*?\\[)|(\\].*?,.*?#)|(\\])");
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].length() == 0 || segments[i].indexOf("RULE") > -1) continue;
            if (i == 2) {
                String[] clauses = segments[i].split(sConjunctions);
                boolean[] bCanMapArray = new boolean[clauses.length];
                this.handleClauses(bCanMapArray, clauses, source, target);
                bCanMapTotal = this.handleConjunctions(bCanMapArray, segments[i]);
                continue;
            }
            if (i != 3 || !bCanMapTotal || segments[i].length() <= 0) continue;
            this.m_sExpression = this.handleExpression(segments[i], source, target);
        }
        return bCanMapTotal;
    }

    private String handleExpression(String expression, IColumn source, IColumn target) {
        expression = expression.replaceAll("SOURCE.NAME", source.getName());
        expression = expression.replaceAll("TARGET.NAME", target.getName());
        expression = expression.replaceAll("SOURCE.LENGTH", Integer.toString(source.getLength()));
        expression = expression.replaceAll("TARGET.LENGTH", Integer.toString(target.getLength()));
        expression = expression.replaceAll("SOURCE.FORMAT", source.getFormatStatement());
        expression = expression.replaceAll("TARGET.FORMAT", target.getFormatStatement());
        expression = expression.replaceAll("SOURCE.INFORMAT", source.getInformatStatement());
        expression = expression.replaceAll("TARGET.INFORMAT", target.getInformatStatement());
        return expression;
    }

    private void handleClauses(boolean[] bCanMapArray, String[] clauses, IColumn source, IColumn target) {
        for (int i = 0; i < clauses.length; ++i) {
            String targetAttr;
            String sourceAttr;
            String clause = clauses[i];
            String sourceSpecific = null;
            String targetSpecific = null;
            Object sourceAttribute = null;
            Object targetAttribute = null;
            String constantVariable = null;
            Object compareAttribute1 = null;
            Object compareAttribute2 = null;
            String sourceVariable = null;
            boolean bIsSourceNoCase = false;
            String targetVariable = null;
            boolean bIsTargetNoCase = false;
            Matcher matcher = patternSource.matcher(clause);
            if (matcher.find()) {
                compareAttribute1 = sourceAttribute = this.getColumnAttribute(source, matcher.group());
                if ((matcher = patternSpecificVariables.matcher(matcher.group())).find()) {
                    sourceSpecific = matcher.group();
                    bIsSourceNoCase = sourceSpecific.indexOf("NOCASE") > -1;
                    matcher = patternSpecificVariables.matcher(sourceSpecific);
                    if (matcher.find()) {
                        sourceVariable = matcher.group(1);
                    }
                }
            }
            if ((matcher = patternTarget.matcher(clause)).find()) {
                compareAttribute2 = targetAttribute = this.getColumnAttribute(target, matcher.group());
                if ((matcher = patternSpecificVariables.matcher(matcher.group())).find()) {
                    targetSpecific = matcher.group();
                    bIsTargetNoCase = targetSpecific.indexOf("NOCASE") > -1;
                    matcher = patternSpecificVariables.matcher(targetSpecific);
                    if (matcher.find()) {
                        targetVariable = matcher.group(1);
                    }
                }
            }
            Matcher matcherCase = patternConstantCase.matcher(clause);
            Matcher matcherNoCase = patternConstantNoCase.matcher(clause);
            if (matcherCase.find() || matcherNoCase.find()) {
                String caseExpression;
                String[] constantVariableSegments;
                Matcher matcherToUse = matcherNoCase;
                if (matcherCase.find()) {
                    matcherToUse = matcherCase;
                }
                if ((constantVariableSegments = (caseExpression = matcherToUse.group()).split(sConstantValueDelimiters)) != null && constantVariableSegments.length >= 1) {
                    constantVariable = constantVariableSegments[1];
                    if (compareAttribute1 == null) {
                        compareAttribute1 = constantVariable;
                    } else {
                        compareAttribute2 = constantVariable;
                    }
                }
            }
            if (compareAttribute1 == null || compareAttribute2 == null) continue;
            matcher = patternCompares.matcher(clause);
            if (matcher.find() && matcher.group().equalsIgnoreCase("LIKE")) {
                Matcher matcherVariable;
                if (this.m_iRuleType == 0) {
                    bCanMapArray[i] = ((String)compareAttribute1).equalsIgnoreCase((String)compareAttribute2);
                    continue;
                }
                if (this.m_iRuleType != 1) continue;
                boolean bSourceMatches = false;
                boolean bTargetMatches = false;
                if (sourceVariable != null && sourceVariable.length() > 0) {
                    Pattern patternSourceVariableToCompare = bIsSourceNoCase ? Pattern.compile(sourceVariable, 66) : Pattern.compile(sourceVariable);
                    matcherVariable = patternSourceVariableToCompare.matcher((String)sourceAttribute);
                    bSourceMatches = matcherVariable.find();
                }
                if (targetVariable != null && targetVariable.length() > 0) {
                    Pattern patternTargetVariableToCompare = bIsTargetNoCase ? Pattern.compile(targetVariable, 66) : Pattern.compile(targetVariable);
                    matcherVariable = patternTargetVariableToCompare.matcher((String)targetAttribute);
                    bTargetMatches = matcherVariable.find();
                }
                if (sourceVariable != null && sourceVariable.length() > 0 && targetVariable != null && targetVariable.length() > 0) {
                    bCanMapArray[i] = bSourceMatches & bTargetMatches;
                    continue;
                }
                if (sourceVariable != null && sourceVariable.length() > 0) {
                    bCanMapArray[i] = bSourceMatches;
                    continue;
                }
                bCanMapArray[i] = bTargetMatches;
                continue;
            }
            if (matcher.group().equalsIgnoreCase("CONTAINS_LIKE")) {
                sourceAttr = (String)compareAttribute1;
                targetAttr = (String)compareAttribute2;
                bCanMapArray[i] = sourceAttr.toUpperCase().indexOf(targetAttr.toUpperCase()) > -1;
                continue;
            }
            if (matcher.group().equalsIgnoreCase("CONTAINS_EQ")) {
                sourceAttr = (String)compareAttribute1;
                targetAttr = (String)compareAttribute2;
                bCanMapArray[i] = sourceAttr.indexOf(targetAttr) > -1;
                continue;
            }
            if (matcher.group().equalsIgnoreCase("NOTLIKE")) {
                bCanMapArray[i] = !((String)compareAttribute1).equalsIgnoreCase((String)compareAttribute2);
                continue;
            }
            if (matcher.group().equalsIgnoreCase("NE")) {
                if (sourceAttribute != null && sourceAttribute instanceof String || targetAttribute != null && targetAttribute instanceof String) {
                    bCanMapArray[i] = !((String)compareAttribute1).equals((String)compareAttribute2);
                    continue;
                }
                bCanMapArray[i] = ((Integer)compareAttribute1).intValue() != ((Integer)compareAttribute2).intValue();
                continue;
            }
            if (matcher.group().equalsIgnoreCase("EQ")) {
                if (sourceAttribute != null && sourceAttribute instanceof String || targetAttribute != null && targetAttribute instanceof String) {
                    bCanMapArray[i] = ((String)compareAttribute1).equals((String)compareAttribute2);
                    continue;
                }
                bCanMapArray[i] = ((Integer)compareAttribute1).intValue() == ((Integer)compareAttribute2).intValue();
                continue;
            }
            if (matcher.group().equalsIgnoreCase("LE")) {
                if ((sourceAttribute == null || !(sourceAttribute instanceof Integer)) && (targetAttribute == null || !(targetAttribute instanceof Integer))) continue;
                bCanMapArray[i] = (Integer)compareAttribute1 <= (Integer)compareAttribute2;
                continue;
            }
            if (matcher.group().equalsIgnoreCase("LT")) {
                if ((sourceAttribute == null || !(sourceAttribute instanceof Integer)) && (targetAttribute == null || !(targetAttribute instanceof Integer))) continue;
                bCanMapArray[i] = (Integer)compareAttribute1 < (Integer)compareAttribute2;
                continue;
            }
            if (matcher.group().equalsIgnoreCase("GT")) {
                if ((sourceAttribute == null || !(sourceAttribute instanceof Integer)) && (targetAttribute == null || !(targetAttribute instanceof Integer))) continue;
                bCanMapArray[i] = (Integer)compareAttribute1 > (Integer)compareAttribute2;
                continue;
            }
            if (!matcher.group().equalsIgnoreCase("GE") || (sourceAttribute == null || !(sourceAttribute instanceof Integer)) && (targetAttribute == null || !(targetAttribute instanceof Integer))) continue;
            bCanMapArray[i] = (Integer)compareAttribute1 >= (Integer)compareAttribute2;
        }
    }

    private boolean handleConjunctions(boolean[] bCanMapArray, String rule) {
        Matcher matcher = patternConjunctions.matcher(rule);
        int iClause = 0;
        boolean bCanMapTotal = true;
        while (matcher.find() && bCanMapTotal) {
            if (matcher.group().equalsIgnoreCase("AND")) {
                bCanMapTotal = bCanMapArray[iClause] && bCanMapArray[iClause + 1];
            } else if (matcher.group().equalsIgnoreCase("OR")) {
                bCanMapTotal = bCanMapArray[iClause] || bCanMapArray[iClause + 1];
            } else if (matcher.group().equalsIgnoreCase("NOT")) {
                bCanMapTotal = !bCanMapArray[iClause];
            } else if (matcher.group().equalsIgnoreCase("NOT_AND")) {
                bCanMapTotal = !bCanMapArray[iClause] || !bCanMapArray[iClause + 1];
            } else if (matcher.group().equalsIgnoreCase("NOT_OR")) {
                bCanMapTotal = !bCanMapArray[iClause] && !bCanMapArray[iClause + 1];
            }
            ++iClause;
        }
        return bCanMapTotal;
    }

    private Object getColumnAttribute(IColumn col, String attribute) {
        if (attribute.indexOf("NAME") > -1) {
            return col.getName();
        }
        if (attribute.indexOf("LENGTH") > -1) {
            return new Integer(col.getLength());
        }
        if (attribute.indexOf("TYPE") > -1) {
            if (col.getType() == 0) {
                return new String("C");
            }
            return new String("N");
        }
        if (attribute.indexOf("DESCRIPTION") > -1) {
            return col.getDescription();
        }
        if (attribute.indexOf("FORMAT") > -1) {
            return col.getFormat();
        }
        if (attribute.indexOf("INFORMAT") > -1) {
            return col.getInformat();
        }
        if (attribute.indexOf("SORTORDER") > -1) {
            return col.getSortOrder();
        }
        return null;
    }

    @Override
    public String getExpressionText() {
        return this.m_sExpression;
    }
}

