/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.impl.BaseValidationOperation;
import javax.swing.undo.AbstractUndoableEdit;

public class CustomValidationOperation
extends BaseValidationOperation {
    public static final String TRANSLATION_COLUMNS_CHANGED = "ValidationEvent:TranslationColumnsChanged";
    public static final String TRANSLATION_MISSING_FLAG_CHANGED = "ValidationEvent:TranslationMissingFlagChanged";
    public static final String EXCEPTION_REPORT_FLAG_CHANGED = "ValidationEvent:ExceptionReportFlagChanged";
    private IColumn m_colTranslationFrom;
    private IColumn m_colTranslationTo;
    private boolean m_bUseNewValueIfTranslationMissing;
    private boolean m_bExceptionReport;

    public CustomValidationOperation(String sID, IModel model) {
        super(sID, model);
    }

    public static String getValidationType() {
        return "ValidationOperation:Custom";
    }

    @Override
    public boolean isColumnsFromSourceAllowed() {
        return false;
    }

    @Override
    public boolean isColumnsFromTargetAllowed() {
        return true;
    }

    @Override
    public boolean isValidationActionSupported(String action) {
        return "ValidationAction:TranslationLookup".equals(action) || "ValidationAction:ChangeValueTo".equals(action);
    }

    public boolean isUseNewValueIfTranslationMissing() {
        return this.m_bUseNewValueIfTranslationMissing;
    }

    public void setUseNewValueIfTranslationMissing(boolean b) {
        if (b == this.m_bUseNewValueIfTranslationMissing) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseNewValueIfTranslationMissingUndoable(this.m_bUseNewValueIfTranslationMissing, b));
        }
        this.m_bUseNewValueIfTranslationMissing = b;
        this.fireModelChangedEvent(TRANSLATION_MISSING_FLAG_CHANGED, this.m_bUseNewValueIfTranslationMissing);
    }

    public boolean isUseExceptionReport() {
        return this.m_bExceptionReport;
    }

    public void setUseExceptionReport(boolean useExceptionReport) {
        if (useExceptionReport == this.m_bExceptionReport) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseExceptionReportUndoable(this.m_bExceptionReport, useExceptionReport));
        }
        this.m_bExceptionReport = useExceptionReport;
        this.fireModelChangedEvent(EXCEPTION_REPORT_FLAG_CHANGED, this.m_bExceptionReport);
    }

    public IColumn getTranslationFromColumn() {
        return this.m_colTranslationFrom;
    }

    public IColumn getTranslationToColumn() {
        return this.m_colTranslationTo;
    }

    public void setTranslationColumns(IColumn fromColumn, IColumn toColumn) {
        if (fromColumn == null) {
            throw new IllegalArgumentException("the \"from\" translation column cannot be null");
        }
        if (toColumn == null) {
            throw new IllegalArgumentException("the \"to\" translation column cannot be null");
        }
        ITable fromTable = fromColumn.getTable();
        ITable toTable = toColumn.getTable();
        if (fromTable == null) {
            throw new IllegalArgumentException("the \"from\" translation column cannot have a null table");
        }
        if (toTable == null) {
            throw new IllegalArgumentException("the \"to\" translation column cannot have a null table");
        }
        if (!fromTable.equals(toTable)) {
            throw new IllegalArgumentException("the \"from\" and \"to\" translation columns cannot be from different tables");
        }
        if (fromColumn.equals(this.m_colTranslationFrom) && toColumn.equals(this.m_colTranslationTo)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTranslationColumnsUndoable(this.m_colTranslationFrom, this.m_colTranslationTo, fromColumn, toColumn));
        }
        this.m_colTranslationFrom = fromColumn;
        this.m_colTranslationTo = toColumn;
        this.fireModelChangedEvent(TRANSLATION_COLUMNS_CHANGED, null);
    }

    private class SetUseNewValueIfTranslationMissingUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOld;
        private boolean m_bNew;

        public SetUseNewValueIfTranslationMissingUndoable(boolean oldValue, boolean newValue) {
            this.m_bOld = oldValue;
            this.m_bNew = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CustomValidationOperation.this.setUseNewValueIfTranslationMissing(this.m_bOld);
        }

        @Override
        public void redo() {
            super.redo();
            CustomValidationOperation.this.setUseNewValueIfTranslationMissing(this.m_bNew);
        }
    }

    private class SetUseExceptionReportUndoable
    extends AbstractUndoableEdit {
        private boolean m_bOld;
        private boolean m_bNew;

        public SetUseExceptionReportUndoable(boolean oldValue, boolean newValue) {
            this.m_bOld = oldValue;
            this.m_bNew = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CustomValidationOperation.this.setUseExceptionReport(this.m_bOld);
        }

        @Override
        public void redo() {
            super.redo();
            CustomValidationOperation.this.setUseExceptionReport(this.m_bNew);
        }
    }

    private class SetTranslationColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn m_colOldFrom;
        private IColumn m_colOldTo;
        private IColumn m_colNewFrom;
        private IColumn m_colNewTo;

        public SetTranslationColumnsUndoable(IColumn oldFrom, IColumn oldTo, IColumn newFrom, IColumn newTo) {
            this.m_colOldFrom = oldFrom;
            this.m_colOldTo = oldTo;
            this.m_colNewFrom = newFrom;
            this.m_colNewTo = newTo;
        }

        @Override
        public void undo() {
            super.undo();
            CustomValidationOperation.this.setTranslationColumns(this.m_colOldFrom, this.m_colOldTo);
        }

        @Override
        public void redo() {
            super.redo();
            CustomValidationOperation.this.setTranslationColumns(this.m_colNewFrom, this.m_colNewTo);
        }
    }
}

