/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.AbstractExpression;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RowSelector;
import com.sas.metadata.remote.Text;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseTextOperand
extends AbstractExpression
implements ITextOperand {
    ITextExpression m_expression;

    public BaseTextOperand(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getExpressionType() {
        return "TextOperand";
    }

    @Override
    protected String getDefaultName() {
        return "TextOperand";
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_expression != null && this.m_expression.isChanged();
    }

    @Override
    public boolean isComplete() {
        if (this.m_expression != null) {
            return this.m_expression.isComplete();
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (this.m_expression != null) {
            reasons.addAll(this.m_expression.getReasonsIncomplete());
        }
        return reasons;
    }

    @Override
    public boolean contentEquals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ITextOperand)) {
            return false;
        }
        ITextOperand operand = (ITextOperand)obj;
        ITextExpression exp1 = this.getTextExpression();
        ITextExpression exp2 = operand.getTextExpression();
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 != null && exp1.contentEquals(exp2)) {
            return true;
        }
        return exp2 != null && exp2.contentEquals(exp1);
    }

    public String getOperandType() {
        return "TextOperand";
    }

    public static String getRole() {
        return "TextOperand";
    }

    @Override
    public void setTextExpression(ITextExpression expression) {
        if (this.m_expression == null ? expression == null : this.m_expression.equals(expression)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExpressionUndoable(this.m_expression, expression));
        }
        if (this.m_expression != null) {
            this.addToDeletedObjects(this.m_expression);
            this.m_expression.removeNotifyListener(this);
        }
        if (expression != null) {
            this.removeFromDeletedObjects(expression);
        }
        this.m_expression = expression;
        if (this.m_expression != null) {
            this.m_expression.setUseSQLSyntax(this.isUseSQLSyntax());
            this.m_expression.addNotifyListener(this);
        }
        this.fireModelChangedEvent("BaseTextOperand:ExpressionChanged", expression);
    }

    @Override
    public void replaceTableColumns(ITable oldTable, ITable newTable) {
        this.m_expression.replaceTableColumns(oldTable, newTable);
    }

    @Override
    public void notify(NotifyEvent ev) {
        String sType;
        ModelEvent mdev;
        if (ev.getSource() == this.m_expression && ev.getType() == 1 && (mdev = ev.getModelEvent()) != null && "TextExpression:TextChanged".equals(sType = mdev.getType())) {
            this.fireModelChangedEvent("TextExpression:TextChanged", this);
        }
        super.notify(ev);
    }

    @Override
    public void setUseSQLSyntax(boolean useSQLSyntax) {
        if (this.isUseSQLSyntax() == useSQLSyntax) {
            return;
        }
        super.setUseSQLSyntax(useSQLSyntax);
        if (this.m_expression != null) {
            this.m_expression.setUseSQLSyntax(this.isUseSQLSyntax());
        }
    }

    @Override
    public ITextExpression getTextExpression() {
        return this.m_expression;
    }

    @Override
    public boolean containsColumn(IColumn column) {
        return this.m_expression.containsColumn(column);
    }

    @Override
    public boolean containsTable(ITable table) {
        return this.m_expression.containsTable(table);
    }

    @Override
    public void replaceColumn(IColumn oldColumn, IColumn newColumn) {
        this.m_expression.replaceColumn(oldColumn, newColumn);
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        return this.m_expression.containsRememberedColumn(column);
    }

    @Override
    public String getTextStoreRole() {
        if (this.m_expression != null) {
            return this.m_expression.getTextStoreRole();
        }
        return "";
    }

    @Override
    public String getTokenizedText() {
        if (this.m_expression != null) {
            return this.m_expression.getTokenizedText();
        }
        return "";
    }

    @Override
    public Map getTokenObjects() {
        if (this.m_expression != null) {
            return this.m_expression.getTokenObjects();
        }
        return new HashMap();
    }

    @Override
    public void setExpressionAnchor(AbstractTransformation mdo) throws MdException, RemoteException {
        if (this.m_expression != null) {
            this.m_expression.setExpressionAnchor(mdo);
        }
    }

    @Override
    public void setExpressionAnchorID(String sID, String sType) {
        if (this.m_expression != null) {
            this.m_expression.setExpressionAnchorID(sID, sType);
        }
    }

    @Override
    public void setSourceCodeAnchor(RowSelector mdo) throws MdException, RemoteException {
        if (this.m_expression != null) {
            this.m_expression.setSourceCodeAnchor(mdo);
        }
    }

    @Override
    public void setSourceCodeAnchorID(String sID) {
        if (this.m_expression != null) {
            this.m_expression.setSourceCodeAnchorID(sID);
        }
    }

    @Override
    public void setSubstituteVariablesAnchor(AbstractTransformation mdo) throws MdException, RemoteException {
        if (this.m_expression != null) {
            this.m_expression.setSubstituteVariablesAnchor(mdo);
        }
    }

    @Override
    public void setSubstituteVariablesAnchorID(String sID, String sType) {
        if (this.m_expression != null) {
            this.m_expression.setSubstituteVariablesAnchorID(sID, sType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String text, IObject[] objects) {
        this.startCompoundUndoable();
        try {
            if (this.m_expression == null) {
                ITextExpression expression = this.createNewTextExpression();
                this.setTextExpression(expression);
            }
            this.m_expression.setText(text, objects);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected ITextExpression createNewTextExpression() {
        return this.getModel().getObjectFactory().createNewTextExpression(this.getID());
    }

    @Override
    public void setTextStoreRole(String sRole) {
        if (this.m_expression != null) {
            this.m_expression.setTextStoreRole(sRole);
        }
    }

    @Override
    public void setVariablesValueType(String sValueType) {
        if (this.m_expression != null) {
            this.m_expression.setVariablesValueType(sValueType);
        }
    }

    @Override
    public void tokenizeText() {
        if (this.m_expression != null) {
            this.m_expression.tokenizeText();
        }
    }

    @Override
    public IObject[] getSources() {
        if (this.m_expression != null) {
            return this.m_expression.getSources();
        }
        return new IObject[0];
    }

    @Override
    public String getText(IServer currentServer, boolean quotes) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getText(currentServer, quotes, false);
    }

    @Override
    public String getText(IServer currentServer, boolean quotes, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.m_expression != null) {
            return this.m_expression.getText(currentServer, quotes, passthru);
        }
        return "";
    }

    @Override
    public List getWarnings() {
        ArrayList<String> reasons = new ArrayList<String>();
        try {
            String text = this.getText(null, true);
            int lineBreakIndex = text.indexOf("\n");
            if (text.length() > 150 && lineBreakIndex == -1) {
                reasons.add(MessageFormat.format(RB.getStringResource("Expression.ReasonsIncomplete.NoLineBreaks.txt"), new Integer(255)));
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().debug((Object)"RemoteExcpetion", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().debug((Object)"CodegenException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().debug((Object)"MdException", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().debug((Object)"BadServerDefinitionException", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().debug((Object)"BadLibraryDefinitionException", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().debug((Object)"ServerException", (Throwable)e);
        }
        return reasons;
    }

    @Override
    public String getOMRType() {
        return "FeatureMap";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        mdoFM.setTransformRole("TextOperand");
        if (this.m_expression != null) {
            this.m_expression.setExpressionAnchor((AbstractTransformation)mdoFM);
            this.m_expression.saveToOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        Text mdoExpression = mdoFM.getSourceCode();
        if (mdoExpression != null) {
            ITextExpression exp = this.createTextExpression(mdoExpression.getFQID());
            exp.addNotifyListener(this);
            exp.setExpressionAnchor((AbstractTransformation)mdoFM);
            exp.loadFromOMR(omr);
            this.setTextExpression(exp);
        }
        this.setChanged(false);
    }

    public ITextExpression createTextExpression(String sFQID) {
        return this.getObjectFactory().createTextExpression(sFQID);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_expression != null) {
            this.m_expression.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_expression != null) {
            this.m_expression.updateIDs(mapIDs);
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        if (!map.containsKey(this.getOMRType())) {
            ArrayList<String> lAssociations = new ArrayList<String>();
            lAssociations.add("SourceCode");
            lAssociations.add("SubstitutionVariables");
            map.put(this.getOMRType(), lAssociations);
        }
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.m_expression != null) {
            this.m_expression.getGeneratedCode(codeSegment, passthru);
        }
        return codeSegment;
    }

    private class SetExpressionUndoable
    extends AbstractUndoableEdit {
        private ITextExpression m_oldExpression;
        private ITextExpression m_newExpression;

        public SetExpressionUndoable(ITextExpression oldExpression, ITextExpression newExpression) {
            this.m_oldExpression = oldExpression;
            this.m_newExpression = newExpression;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTextOperand.this.setTextExpression(this.m_oldExpression);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTextOperand.this.setTextExpression(this.m_newExpression);
        }
    }
}

