/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.AbstractExpression;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.RowSelector;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Variable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.undo.AbstractUndoableEdit;
import org.apache.commons.lang.StringUtils;

public class BaseTextExpression
extends AbstractExpression
implements ITextExpression,
ICodeSource {
    private String m_sText = "";
    private String m_sTokenizedText;
    protected IObject[] m_lObjects;
    protected HashMap m_hmTokenizedVarObjects;
    protected HashMap m_hmTokenToRememberedObjects;
    protected String m_sVariableValueType;
    private String m_sTextStoreRole;
    private String m_sSourceCodeAnchorID;
    private String m_sVariablesAnchorID;
    private String m_sVariablesAnchorType;
    protected List m_lSubstituteVariablesIDs = new ArrayList();
    protected boolean m_bChangedDuringLoad = false;
    private ISQLTransform m_transformModel;
    private static String MISSING_COLUMN_MSG = RB.getStringResource("BaseTextExpression.MissingColumnMsg.txt");

    public BaseTextExpression(String sID, IModel model) {
        super(sID, model);
        this.m_hmTokenizedVarObjects = new HashMap();
        this.m_hmTokenToRememberedObjects = new HashMap();
    }

    @Override
    protected String getDefaultName() {
        return "Expression";
    }

    @Override
    public void notify(NotifyEvent ev) {
        IObject object = (IObject)ev.getSource();
        int iType = ev.getType();
        if (object == null) {
            return;
        }
        if (iType == 0) {
            if (object instanceof IColumn) {
                this.replaceColumn((IColumn)object, null);
            } else {
                for (String marker : this.m_hmTokenizedVarObjects.keySet()) {
                    IObject var = (IObject)this.m_hmTokenizedVarObjects.get(marker);
                    if (var == null || !var.equals(object)) continue;
                    this.m_hmTokenizedVarObjects.put(marker, null);
                }
                this.m_sText = this.detokenizeText(null, false, false);
                this.fireModelChangedEvent("TextExpression:TextChanged", this);
            }
        }
        super.notify(ev);
    }

    @Override
    public String getExpressionType() {
        return "DERIVED";
    }

    @Override
    public void setUseSQLSyntax(boolean useSQLSyntax) {
        if (this.isUseSQLSyntax() == useSQLSyntax) {
            return;
        }
        super.setUseSQLSyntax(useSQLSyntax);
    }

    @Override
    public boolean contentEquals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IExpression)) {
            return false;
        }
        IExpression expression = (IExpression)obj;
        try {
            if (this.getText(null, false).equals(expression.getText(null, false))) {
                return true;
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        return false;
    }

    @Override
    public void setText(String text, IObject[] objects) {
        if (this.m_sText.equals(text)) {
            return;
        }
        if (this.m_lObjects != null && this.m_lObjects.length > 0) {
            for (int index = 0; index < this.m_lObjects.length; ++index) {
                this.m_lObjects[index].removeNotifyListener(this);
            }
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTextUndoable(this.m_sText, this.m_lObjects, text, objects));
        }
        this.m_sText = text;
        this.m_lObjects = objects;
        this.tokenizeText();
        this.fireModelChangedEvent("TextExpression:TextChanged", this);
    }

    @Override
    public String getText(IServer currentServer, boolean quotes) {
        return this.getText(currentServer, quotes, false);
    }

    @Override
    public String getText(IServer currentServer, boolean quotes, boolean passthru) {
        return this.detokenizeText(currentServer, quotes, passthru);
    }

    @Override
    public String getTokenizedText() {
        return this.m_sTokenizedText;
    }

    @Override
    public IObject[] getSources() {
        ArrayList lObjects = new ArrayList();
        Map tokenObjects = this.getTokenObjects();
        for (String marker : tokenObjects.keySet()) {
            lObjects.add(tokenObjects.get(marker));
        }
        return lObjects.toArray(new IObject[lObjects.size()]);
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IObject obj;
        ICodeSegment rootCodeSegment = this.getRootCodeSegment(codeSegment);
        if (rootCodeSegment != null && (obj = rootCodeSegment.getModelObject()) instanceof ISQLTransform) {
            this.m_transformModel = (ISQLTransform)obj;
        }
        codeSegment.addSourceCode(this.detokenizeText(codeSegment.getCurrentServer(), codeSegment.isQuoting(), passthru));
        this.m_transformModel = null;
        return codeSegment;
    }

    private ICodeSegment getRootCodeSegment(ICodeSegment codeSegment) {
        ICodeSegment currentSegment;
        for (currentSegment = codeSegment; currentSegment != null && currentSegment.getParentSegment() != null; currentSegment = currentSegment.getParentSegment()) {
        }
        return currentSegment;
    }

    @Override
    public boolean containsColumn(IColumn column) {
        Map tokenObjects = this.getTokenObjects();
        return tokenObjects.containsValue(column);
    }

    @Override
    public boolean containsTable(ITable table) {
        Map tokenObjects = this.getTokenObjects();
        IObject[] objects = this.getSources();
        for (int i = 0; i < objects.length; ++i) {
            IColumn col;
            ITable table2;
            IObject object = objects[i];
            if (object instanceof ITable && object.equals(table)) {
                return true;
            }
            if (!(object instanceof IColumn) || !(table2 = (col = (IColumn)object).getTable()).equals(table)) continue;
            return true;
        }
        return tokenObjects.containsValue(table);
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        String sName = this.getRememberedName(column);
        return this.m_hmTokenToRememberedObjects.containsValue(sName);
    }

    private String getRememberedName(IColumn column) {
        return column.getName() + " " + column.getType();
    }

    @Override
    public void replaceTableColumns(ITable oldTable, ITable newTable) {
        if (oldTable == null) {
            return;
        }
        IColumn[] oldColumns = oldTable.getColumns();
        IColumn[] newColumns = null;
        if (newTable != null) {
            newColumns = newTable.getColumns();
        }
        for (int i = 0; i < oldColumns.length; ++i) {
            boolean isFound = false;
            IColumn oldColumn = oldColumns[i];
            IColumn newColumn = null;
            if (newColumns == null) {
                this.replaceColumn(oldColumn, newColumn);
                continue;
            }
            for (int j = 0; j < newColumns.length; ++j) {
                newColumn = newColumns[j];
                if (!newColumn.getColumnName(true).equals(oldColumn.getColumnName(true))) continue;
                isFound = true;
                this.replaceColumn(oldColumn, newColumn);
                break;
            }
            if (isFound) continue;
            this.replaceColumn(oldColumn, null);
        }
    }

    @Override
    public void replaceColumn(IColumn oldColumn, IColumn newColumn) {
        if (oldColumn != null && this.containsColumn(oldColumn)) {
            oldColumn.removeNotifyListener(this);
        }
        boolean hasChanged = false;
        if (oldColumn == null && newColumn != null && this.containsRememberedColumn(newColumn)) {
            String sName = this.getRememberedName(newColumn);
            for (String marker : this.m_hmTokenToRememberedObjects.keySet()) {
                String sOldName = (String)this.m_hmTokenToRememberedObjects.get(marker);
                if (!sName.equalsIgnoreCase(sOldName)) continue;
                this.m_hmTokenizedVarObjects.put(marker, newColumn);
                hasChanged = true;
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new ReplaceColumnUndoable(oldColumn, newColumn, marker));
                }
                this.m_hmTokenToRememberedObjects.remove(marker);
                break;
            }
        }
        if (!hasChanged) {
            for (String marker : this.m_hmTokenizedVarObjects.keySet()) {
                IObject object = (IObject)this.m_hmTokenizedVarObjects.get(marker);
                if (object != null && object.equals(oldColumn)) {
                    this.m_hmTokenizedVarObjects.put(marker, newColumn);
                    hasChanged = true;
                    if (this.isUndoSupported()) {
                        this.undoableEditHappened(new ReplaceColumnUndoable(oldColumn, newColumn, marker));
                    }
                    if (newColumn != null) continue;
                    String sName = this.getRememberedName(oldColumn);
                    this.m_hmTokenToRememberedObjects.put(marker, sName);
                    continue;
                }
                if (object != null || oldColumn != null) continue;
                this.m_hmTokenizedVarObjects.put(marker, newColumn);
                hasChanged = true;
                if (!this.isUndoSupported()) break;
                this.undoableEditHappened(new ReplaceColumnUndoable(oldColumn, newColumn, marker));
                break;
            }
        }
        if (hasChanged) {
            this.m_sText = this.detokenizeText(null, false, false);
            this.fireModelChangedEvent("TextExpression:TextChanged", this);
            if (newColumn != null) {
                newColumn.addNotifyListener(this);
            }
        }
    }

    @Override
    public void setExpressionAnchor(AbstractTransformation mdo) throws MdException, RemoteException {
        this.m_sVariablesAnchorID = mdo.getFQID();
        this.m_sVariablesAnchorType = mdo.getCMetadataType();
        this.m_sSourceCodeAnchorID = "";
    }

    @Override
    public void setExpressionAnchorID(String sID, String sType) {
        this.m_sVariablesAnchorID = sID;
        this.m_sVariablesAnchorType = sType;
        this.m_sSourceCodeAnchorID = "";
    }

    @Override
    public void setSourceCodeAnchor(RowSelector mdo) throws MdException, RemoteException {
        this.m_sSourceCodeAnchorID = mdo.getFQID();
    }

    @Override
    public void setSourceCodeAnchorID(String sID) {
        this.m_sSourceCodeAnchorID = sID;
    }

    @Override
    public void setSubstituteVariablesAnchor(AbstractTransformation mdo) throws MdException, RemoteException {
        this.m_sVariablesAnchorID = mdo.getFQID();
        this.m_sVariablesAnchorType = mdo.getCMetadataType();
    }

    @Override
    public void setSubstituteVariablesAnchorID(String sID, String sType) {
        this.m_sVariablesAnchorID = sID;
        this.m_sVariablesAnchorType = sType;
    }

    @Override
    public void setVariablesValueType(String sValueType) {
        this.m_sVariableValueType = sValueType;
    }

    @Override
    public void setTextStoreRole(String sRole) {
        this.m_sTextStoreRole = sRole;
    }

    @Override
    public String getTextStoreRole() {
        if (this.m_sTextStoreRole == null || this.m_sTextStoreRole.length() == 0) {
            return "FeatureMapExpression";
        }
        return this.m_sTextStoreRole;
    }

    @Override
    public List getWarnings() {
        ArrayList<String> reasons = new ArrayList<String>();
        String text = this.getText(null, true);
        int lineBreakIndex = text.indexOf("\n");
        if (text.length() > 150 && lineBreakIndex == -1) {
            reasons.add(MessageFormat.format(RB.getStringResource("Expression.ReasonsIncomplete.NoLineBreaks.txt"), new Integer(255)));
        }
        return reasons;
    }

    @Override
    public boolean isComplete() {
        int missingIndex = this.getText(null, false).indexOf(MISSING_COLUMN_MSG);
        return missingIndex <= -1;
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        int missingIndex = this.getText(null, false).indexOf(MISSING_COLUMN_MSG);
        if (missingIndex > -1) {
            reasons.add(RB.getStringResource("BaseTextExpression.ReasonsIncomplete.MissingTokens.txt"));
        }
        return reasons;
    }

    @Override
    public void saveXMLToStream(OutputStream strm) throws IOException {
    }

    @Override
    public void loadXMLFromStream(InputStream strm) throws IOException {
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        TextStore mdoTS = (TextStore)omr.acquireOMRObject(this);
        if (this.m_sTokenizedText == null) {
            mdoTS.setStoredText("");
        } else {
            mdoTS.setStoredText(this.m_sTokenizedText);
        }
        if (this.m_sTextStoreRole == null || this.m_sTextStoreRole.length() == 0) {
            this.m_sTextStoreRole = "FeatureMapExpression";
        }
        mdoTS.setTextRole(this.m_sTextStoreRole);
        if (this.m_sVariablesAnchorID == null || this.m_sVariablesAnchorID.length() == 0) {
            throw new IllegalStateException("Save Error: Missing expression or variables anchor id.");
        }
        AbstractTransformation mdoVariablesAnchor = (AbstractTransformation)omr.acquireOMRObject(this.m_sVariablesAnchorID, this.m_sVariablesAnchorType);
        this.saveSubstituteVariablesToOMR(omr, mdoVariablesAnchor);
        if (this.m_sSourceCodeAnchorID != null && this.m_sSourceCodeAnchorID.length() > 0) {
            RowSelector mdoSourceCodeAnchor = (RowSelector)omr.acquireOMRObject(this.m_sSourceCodeAnchorID, "RowSelector");
            if (mdoSourceCodeAnchor != null) {
                mdoSourceCodeAnchor.setSourceCode((Text)mdoTS);
            }
        } else {
            mdoVariablesAnchor.setSourceCode((Text)mdoTS);
        }
        this.setChanged(false);
    }

    protected void saveSubstituteVariablesToOMR(OMRAdapter omr, AbstractTransformation mdoAnchor) throws MdException, RemoteException {
        List lOldSubstituteVariablesIDs = this.m_lSubstituteVariablesIDs;
        this.m_lSubstituteVariablesIDs = new ArrayList(1);
        AssociationList lSubVars = mdoAnchor.getSubstitutionVariables(false);
        lSubVars.clear();
        Map tokenObjects = this.getTokenObjects();
        for (String marker : tokenObjects.keySet()) {
            IOMRPersistable object = (IOMRPersistable)tokenObjects.get(marker);
            Root mdoObject = null;
            if (object != null) {
                mdoObject = omr.acquireOMRObject(object);
            }
            String sVariableID = lOldSubstituteVariablesIDs.isEmpty() ? this.createIDForNewObject() : (String)lOldSubstituteVariablesIDs.remove(0);
            this.m_lSubstituteVariablesIDs.add(sVariableID);
            Variable mdoVar = (Variable)omr.acquireOMRObject(sVariableID, "Variable");
            if (object != null) {
                mdoVar.setName(marker + " - " + ((IObject)((Object)object)).getName());
            } else {
                mdoVar.setName(marker + " - Missing");
            }
            mdoVar.setMarker(marker);
            if (this.m_sVariableValueType == null || this.m_sVariableValueType.length() == 0) {
                this.m_sVariableValueType = this.isUseSQLSyntax() ? "long name" : "short name";
            }
            mdoVar.setValueType(this.m_sVariableValueType);
            if (mdoObject != null) {
                mdoVar.setAssociatedObject(mdoObject);
            } else {
                mdoVar.getAssociatedObjects(false).clear();
            }
            lSubVars.add(mdoVar);
        }
        while (!lOldSubstituteVariablesIDs.isEmpty()) {
            omr.deleteOMRObject((String)lOldSubstituteVariablesIDs.remove(0), "Variable");
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.m_bChangedDuringLoad = false;
        TextStore mdoTS = (TextStore)omr.acquireOMRObject(this);
        this.m_sTextStoreRole = mdoTS.getTextRole();
        this.m_sTokenizedText = mdoTS.getStoredText().trim();
        if (!(this.getModel().isCopyPaste() || this.m_sVariablesAnchorID != null && this.m_sVariablesAnchorID.length() != 0)) {
            throw new IllegalStateException("Load Error: Missing expression or variables anchor id.");
        }
        if (!StringUtils.isEmpty((String)this.m_sVariablesAnchorID)) {
            AbstractTransformation mdoVariablesAnchor = (AbstractTransformation)omr.acquireOMRObject(this.m_sVariablesAnchorID, this.m_sVariablesAnchorType);
            this.loadSubstituteVariablesFromOMR(omr, mdoVariablesAnchor);
        }
        this.m_sText = this.detokenizeText(null, false, false);
        this.setChanged(this.m_bChangedDuringLoad);
    }

    protected void loadSubstituteVariablesFromOMR(OMRAdapter omr, AbstractTransformation mdoAnchor) throws MdException, RemoteException {
        this.m_lSubstituteVariablesIDs.clear();
        this.m_hmTokenizedVarObjects.clear();
        ArrayList<IOMRPersistable> lObjects = new ArrayList<IOMRPersistable>();
        AssociationList lVariables = mdoAnchor.getSubstitutionVariables();
        for (int i = 0; i < lVariables.size(); ++i) {
            Variable mdoVariable = (Variable)lVariables.get(i);
            this.m_lSubstituteVariablesIDs.add(mdoVariable.getFQID());
            this.m_sVariableValueType = mdoVariable.getValueType();
            String marker = mdoVariable.getMarker();
            Root assocObject = mdoVariable.getAssociatedObject();
            if (assocObject == null) {
                this.m_hmTokenizedVarObjects.put(marker, null);
                continue;
            }
            IOMRPersistable modelObject = omr.acquireObject(assocObject);
            this.m_hmTokenizedVarObjects.put(marker, modelObject);
            lObjects.add(modelObject);
            ((IObject)((Object)modelObject)).addNotifyListener(this);
        }
        this.m_lObjects = lObjects.toArray(new IObject[lObjects.size()]);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        for (int i = 0; i < this.m_lSubstituteVariablesIDs.size(); ++i) {
            omr.deleteOMRObject((String)this.m_lSubstituteVariablesIDs.get(i), "Variable");
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public String getOMRType() {
        return "TextStore";
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_sVariablesAnchorID != null && this.m_sVariablesAnchorID.length() > 0) {
            this.m_sVariablesAnchorID = this.updateSubordinateID(this.m_sVariablesAnchorID, mapIDs);
        }
        if (this.m_sSourceCodeAnchorID != null && this.m_sSourceCodeAnchorID.length() > 0) {
            this.m_sSourceCodeAnchorID = this.updateSubordinateID(this.m_sSourceCodeAnchorID, mapIDs);
        }
        for (int i = 0; i < this.m_lSubstituteVariablesIDs.size(); ++i) {
            String sVariableID = (String)this.m_lSubstituteVariablesIDs.get(i);
            this.m_lSubstituteVariablesIDs.set(i, this.updateSubordinateID(sVariableID, mapIDs));
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.m_sVariablesAnchorType);
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("SubstitutionVariables");
            lAssociations.add("SourceCode");
            map.put(this.m_sVariablesAnchorType, lAssociations);
        } else {
            lAssociations.add("SubstitutionVariables");
            lAssociations.add("SourceCode");
        }
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public void dump(PrintStream strm) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getID()).append(":").append(this.m_sText).append(":").append(this.m_sTokenizedText);
        Map tokenObjects = this.getTokenObjects();
        for (String marker : tokenObjects.keySet()) {
            sb.append(marker);
            sb.append(":");
            sb.append(tokenObjects.get(marker));
        }
        strm.println(sb.toString());
    }

    private boolean hasMatchingName(cObjectName[] names, String name) {
        for (cObjectName objName : names) {
            if (!objName.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private cObjectName[] getNames() {
        IObject[] objs = this.getHierarchyObjectList();
        ArrayList<cObjectName> objectNames = new ArrayList<cObjectName>();
        for (int i = 0; i < objs.length; ++i) {
            IObject object = objs[i];
            objectNames.addAll(Arrays.asList(this.getObjectNames(object)));
        }
        return this.sortObjectNames(objectNames.toArray(new cObjectName[objectNames.size()]));
    }

    @Override
    public void tokenizeText() {
        this.m_hmTokenizedVarObjects.clear();
        ArrayList<String> lTokenText = new ArrayList<String>();
        ArrayList<Object> lTokenObjects = new ArrayList<Object>();
        if (this.m_lObjects == null) {
            this.m_sTokenizedText = this.m_sText;
            return;
        }
        cObjectName[] names = this.getNames();
        for (int j = 0; j < names.length; ++j) {
            lTokenText.add(names[j].getName());
            lTokenObjects.add(names[j].getObject());
        }
        this.tokenize(names);
        this.m_sText = this.detokenizeText(null, false, false);
    }

    private IObject[] getHierarchyObjectList() {
        ArrayList<IObject> lstTables = new ArrayList<IObject>();
        ArrayList<IObject> lstOthers = new ArrayList<IObject>();
        for (int i = 0; i < this.m_lObjects.length; ++i) {
            IColumn col;
            IObject object = this.m_lObjects[i];
            if (object instanceof ITable) {
                lstTables.add(object);
                continue;
            }
            lstOthers.add(object);
            if (!(object instanceof IColumn) || lstTables.contains((col = (IColumn)object).getTable())) continue;
            lstTables.add(col.getTable());
        }
        ArrayList<IObject> lstAll = new ArrayList<IObject>();
        lstAll.addAll(lstOthers);
        lstAll.addAll(lstTables);
        return lstAll.toArray(new IObject[lstAll.size()]);
    }

    private cObjectName[] sortObjectNames(cObjectName[] names) {
        ArrayList<cObjectName> shortNames = new ArrayList<cObjectName>();
        ArrayList<cObjectName> longNames = new ArrayList<cObjectName>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].isLongName()) {
                longNames.add(names[i]);
                continue;
            }
            shortNames.add(names[i]);
        }
        longNames.addAll(shortNames);
        return longNames.toArray(new cObjectName[names.length]);
    }

    protected cObjectName[] getObjectNames(Object object) {
        ArrayList<cObjectName> names = new ArrayList<cObjectName>();
        if (object instanceof ITable) {
            ITable table = (ITable)object;
            if (table instanceof IPhysicalTable) {
                try {
                    names.add(new cObjectName(object, table.getFullNameQuotedAsNeeded(null, false, false), true));
                }
                catch (BadLibraryDefinitionException e) {
                    ModelLogger.getDefaultLogger().error((Object)"BadLibraryDefinitionException", (Throwable)e);
                }
            }
            String unquoteName = table.getTableName(false, false);
            names.add(new cObjectName(object, table.getTableName(true, false), false));
            names.add(new cObjectName(object, unquoteName, false));
            names.add(new cObjectName(object, "'" + unquoteName + "'n", false));
            names.add(new cObjectName(object, "'" + unquoteName + "'N", false));
        } else if (object instanceof IColumn) {
            IColumn column = (IColumn)object;
            ITable table = column.getTable();
            String quotedColName = column.getColumnName(true, false);
            String unquotedColName = column.getColumnName(false, false);
            if (table != null) {
                String quotedTabName = table.getTableName(true, false);
                String unquotedTabName = table.getTableName(false, false);
                names.add(new cObjectName(object, unquotedTabName + "." + unquotedColName, true));
                names.add(new cObjectName(object, "'" + unquotedTabName + "'n.'" + unquotedColName + "'n", true));
                names.add(new cObjectName(object, "'" + unquotedTabName + "'n.'" + unquotedColName + "'N", true));
                names.add(new cObjectName(object, "'" + unquotedTabName + "'N.'" + unquotedColName + "'N", true));
                names.add(new cObjectName(object, "'" + unquotedTabName + "'N.'" + unquotedColName + "'n", true));
                names.add(new cObjectName(object, quotedTabName + "." + quotedColName, true));
            }
            names.add(new cObjectName(object, quotedColName, false));
            names.add(new cObjectName(object, "'" + unquotedColName + "'n", false));
            names.add(new cObjectName(object, "'" + unquotedColName + "'N", false));
            names.add(new cObjectName(object, unquotedColName, false));
        }
        return names.toArray(new cObjectName[names.size()]);
    }

    private List buildTokenList(cObjectName[] names) {
        boolean NONE = false;
        boolean TEXT = true;
        int QUOTE1 = 2;
        int QUOTE2 = 3;
        boolean insideSQuote = false;
        boolean insideDQuote = false;
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        int end = 0;
        int state = 0;
        block5: while (end < this.m_sText.length()) {
            char currchar = this.m_sText.charAt(end);
            ++end;
            switch (state) {
                case 1: {
                    String lookupName2;
                    String lookupName;
                    String text;
                    if (!(currchar != ' ' || insideSQuote && insideDQuote)) {
                        text = this.m_sText.substring(start, end - 1);
                        lookupName = text.trim();
                        int lastSpace = text.lastIndexOf(" ");
                        lastSpace = lastSpace < 0 ? 0 : ++lastSpace;
                        if (lastSpace >= 0 && lookupName.length() >= lastSpace) {
                            lookupName = lookupName.substring(lastSpace);
                        }
                        if (this.hasMatchingName(names, lookupName)) {
                            tokens.add(new Token(true, this.m_sText.substring(start, end)));
                            start = end;
                            break;
                        }
                        tokens.add(new Token(false, text));
                        start = end - 1;
                    }
                    if (currchar == '\'') {
                        String lookupName22;
                        insideSQuote = !insideSQuote;
                        text = this.m_sText.substring(start, end - 1);
                        lookupName = text.trim();
                        if (end >= 2 && this.m_sText.charAt(end - 2) == '.') {
                            lookupName = this.m_sText.substring(start, end - 2).trim();
                        }
                        if (this.hasMatchingName(names, lookupName22 = StringUtils.substringBefore((String)this.m_sText.substring(start), (String)" "))) continue block5;
                        if (!this.doesStringContainNonJavaIdentifier(lookupName) && !this.hasMatchingName(names, lookupName)) {
                            tokens.add(new Token(false, text));
                            start = end - 1;
                            state = 2;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    if (currchar != '\"') continue block5;
                    insideDQuote = !insideDQuote;
                    text = this.m_sText.substring(start, end - 1);
                    lookupName = text.trim();
                    if (end >= 2 && this.m_sText.charAt(end - 2) == '.') {
                        lookupName = this.m_sText.substring(start, end - 2).trim();
                    }
                    if (this.hasMatchingName(names, lookupName2 = StringUtils.substringBefore((String)this.m_sText.substring(start), (String)" "))) continue block5;
                    if (!this.doesStringContainNonJavaIdentifier(lookupName) && !this.hasMatchingName(names, lookupName)) {
                        tokens.add(new Token(false, text));
                        start = end - 1;
                        state = 3;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 2: {
                    if (currchar != '\'') continue block5;
                    String nextChars = null;
                    if (this.m_sText.length() > end + 2) {
                        nextChars = String.valueOf(this.m_sText.charAt(end) + String.valueOf(this.m_sText.charAt(end + 1)) + String.valueOf(this.m_sText.charAt(end + 2)));
                    } else if (this.m_sText.length() > end + 1) {
                        nextChars = String.valueOf(this.m_sText.charAt(end) + String.valueOf(this.m_sText.charAt(end + 1)));
                    } else if (this.m_sText.length() > end) {
                        nextChars = String.valueOf(this.m_sText.charAt(end));
                    }
                    if (nextChars != null) {
                        nextChars = nextChars.trim();
                    }
                    if ("N.'".equalsIgnoreCase(nextChars)) {
                        end += 3;
                        continue block5;
                    }
                    if (nextChars != null && nextChars.length() > 0 && "N".equalsIgnoreCase(nextChars.substring(0, 1))) {
                        tokens.add(new Token(true, this.m_sText.substring(start, ++end)));
                    } else if (nextChars != null && nextChars.length() > 0 && ("T".equalsIgnoreCase(nextChars.substring(0, 1)) || "D".equalsIgnoreCase(nextChars.substring(0, 1)) || "DT".equalsIgnoreCase(nextChars.substring(0, 1)))) {
                        ++end;
                        if ("DT".equalsIgnoreCase(nextChars)) {
                            ++end;
                        }
                        tokens.add(new Token(false, this.m_sText.substring(start, end)));
                    } else {
                        tokens.add(new Token(false, this.m_sText.substring(start, end)));
                    }
                    start = end;
                    state = 0;
                    break;
                }
                case 3: {
                    if (currchar != '\"') continue block5;
                    String nextChars = null;
                    if (this.m_sText.length() > end + 2) {
                        nextChars = String.valueOf(this.m_sText.charAt(end) + String.valueOf(this.m_sText.charAt(end + 1)) + String.valueOf(this.m_sText.charAt(end + 2)));
                    } else if (this.m_sText.length() > end + 1) {
                        nextChars = String.valueOf(this.m_sText.charAt(end) + String.valueOf(this.m_sText.charAt(end + 1)));
                    } else if (this.m_sText.length() > end) {
                        nextChars = String.valueOf(this.m_sText.charAt(end));
                    }
                    if (nextChars != null) {
                        nextChars = nextChars.trim();
                    }
                    if ("N.\"".equalsIgnoreCase(nextChars)) {
                        end += 3;
                        continue block5;
                    }
                    if (nextChars != null && nextChars.length() > 0 && "N".equalsIgnoreCase(nextChars.substring(0, 1))) {
                        tokens.add(new Token(true, this.m_sText.substring(start, ++end)));
                    } else if (nextChars != null && nextChars.length() > 0 && ("T".equalsIgnoreCase(nextChars.substring(0, 1)) || "D".equalsIgnoreCase(nextChars.substring(0, 1)) || "DT".equalsIgnoreCase(nextChars.substring(0, 1)))) {
                        ++end;
                        if ("DT".equalsIgnoreCase(nextChars)) {
                            ++end;
                        }
                        tokens.add(new Token(false, this.m_sText.substring(start, end)));
                    } else {
                        tokens.add(new Token(false, this.m_sText.substring(start, end)));
                    }
                    start = end;
                    state = 0;
                    break;
                }
                default: {
                    state = currchar == '\'' ? 2 : (currchar == '\"' ? 3 : 1);
                }
            }
        }
        if (state != 0) {
            tokens.add(new Token(true, this.m_sText.substring(start, end)));
        }
        return tokens;
    }

    private boolean doesStringContainNonJavaIdentifier(String value) {
        if (value != null) {
            for (char c : value.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return true;
            }
        }
        return false;
    }

    private void tokenize(cObjectName[] names) {
        int i;
        ArrayList tokens = new ArrayList();
        tokens.addAll(this.buildTokenList(names));
        for (i = 0; i < tokens.size() - 1; ++i) {
            Token tok1 = (Token)tokens.get(i);
            Token tok2 = (Token)tokens.get(i + 1);
            if (tok1.canSubstitute() && tok2.canSubstitute()) {
                tok1.addString(tok2.getText());
                tokens.remove(i + 1);
                --i;
                continue;
            }
            if (!tok1.canSubstitute() || !".".equals(tok2.getText()) || tokens.size() <= 2 || !((Token)tokens.get(i + 2)).canSubstitute()) continue;
            tok1.addString(tok2.getText());
            tokens.remove(i + 1);
            --i;
        }
        this.replaceTokens(tokens, names, true);
        this.resetTokens(tokens);
        this.replaceTokens(tokens, names, false);
        this.m_sTokenizedText = "";
        for (i = 0; i < tokens.size(); ++i) {
            this.m_sTokenizedText = this.m_sTokenizedText + ((Token)tokens.get(i)).getText();
        }
    }

    private void resetTokens(List tokens) {
        for (int i = 0; i < tokens.size(); ++i) {
            ((Token)tokens.get(i)).setCanSubstitute(true);
        }
    }

    protected void replaceTokens(List tokens, cObjectName[] names, boolean useCaseSensitivity) {
        for (int i = 0; i < tokens.size(); ++i) {
            String tokText;
            Token tok = (Token)tokens.get(i);
            if (!tok.canSubstitute()) continue;
            String lowName = "";
            String tokTextCompare = tokText = tok.getText();
            boolean matchFound = true;
            int count = names.length;
            while (matchFound) {
                matchFound = false;
                int lowIndex = tokText.length();
                tokTextCompare = !useCaseSensitivity ? tokText.toLowerCase() : tokText;
                int lowObject = 0;
                for (int k = 0; k < count; ++k) {
                    int nextChar;
                    Pattern p;
                    Matcher m;
                    int index;
                    String name = names[k].getName();
                    if (!useCaseSensitivity) {
                        name = name.toLowerCase();
                    }
                    if ((index = tokTextCompare.indexOf(name)) < 0 || name.length() <= 0 || (m = (p = Pattern.compile("(['\"]).*?" + name + ".*?\\1")).matcher(tokTextCompare)).find()) continue;
                    int prevChar = index - 1;
                    if (index > 0 && (Character.isJavaIdentifierPart(tokText.charAt(prevChar)) || tokText.charAt(prevChar) == '&' || tokText.charAt(prevChar) == '\"' || tokText.charAt(prevChar) == '\'')) {
                        index = lowIndex + 1;
                    }
                    if ((nextChar = index + name.length()) < tokText.length() && (Character.isJavaIdentifierPart(tokText.charAt(nextChar)) || this.getNextNonBlankChar(tokText, nextChar) == '(' || this.getNextNonBlankChar(tokText, nextChar) == '.')) {
                        index = lowIndex + 1;
                    }
                    if (index >= lowIndex && (index != lowIndex || name.length() <= lowName.length())) continue;
                    lowIndex = index;
                    lowName = name;
                    lowObject = k;
                    matchFound = true;
                    break;
                }
                if (!matchFound) continue;
                cObjectName objName = names[lowObject];
                if (objName.getObjectIndex() < 0) {
                    return;
                }
                StringBuffer varKey = new StringBuffer();
                varKey.append("[").append(objName.getObjectIndex()).append("]");
                IObject object = (IObject)objName.getObject();
                this.m_hmTokenizedVarObjects.put(varKey.toString(), object);
                object.addNotifyListener(this);
                tokText = tokText.substring(0, lowIndex) + varKey.toString() + tokText.substring(lowIndex + lowName.length());
            }
            tok.foundMatch(tokText);
        }
    }

    private char getNextNonBlankChar(String text, int start) {
        char nextChar = ' ';
        while (start < text.length() - 1) {
            char c = text.charAt(start);
            if (c != ' ') {
                return c;
            }
            ++start;
        }
        return nextChar;
    }

    public String detokenizeText(IServer currentServer, boolean useQuotes) {
        return this.detokenizeText(currentServer, useQuotes, false);
    }

    public String detokenizeText(IServer currentServer, boolean useQuotes, boolean usePassthru) {
        if (this.m_sTokenizedText == null || this.m_sTokenizedText.length() == 0) {
            return "";
        }
        String expression = this.m_sTokenizedText;
        Map tokenObjects = this.getTokenObjects();
        for (String marker : tokenObjects.keySet()) {
            String subText = "";
            Object object = tokenObjects.get(marker);
            subText = object != null ? this.getSubstitutionText(currentServer, object, useQuotes, usePassthru) : MISSING_COLUMN_MSG;
            int begloc = expression.indexOf(marker);
            while (begloc > -1) {
                String endString = "";
                String begString = "";
                int endloc = begloc + marker.length();
                if (begloc == 0) {
                    endString = expression.substring(endloc);
                    expression = subText + endString;
                } else {
                    begString = expression.substring(0, begloc);
                    endString = expression.substring(endloc);
                    expression = begString + subText + endString;
                }
                begloc = expression.indexOf(marker);
            }
        }
        return expression;
    }

    @Override
    public Map getTokenObjects() {
        this.removeUnusedTokenObjects();
        return new HashMap(this.m_hmTokenizedVarObjects);
    }

    protected void removeUnusedTokenObjects() {
        String expression = this.getTokenizedText();
        ArrayList<String> unusedTokens = new ArrayList<String>();
        for (String marker : this.m_hmTokenizedVarObjects.keySet()) {
            if (expression.indexOf(marker) != -1) continue;
            unusedTokens.add(marker);
        }
        int size = unusedTokens.size();
        for (int i = 0; i < size; ++i) {
            Object marker = unusedTokens.get(i);
            Object object = this.m_hmTokenizedVarObjects.get(marker);
            System.out.println("BaseExpression:Detokenization:Marker:NotFoundInText: " + marker + " Object: " + object.toString());
            this.m_hmTokenizedVarObjects.remove(marker);
        }
    }

    protected String getSubstitutionText(IServer currentServer, Object object, boolean useQuotes, boolean usePassthru) {
        String text = "";
        if (object != null) {
            if (object instanceof IColumn) {
                IColumn col = (IColumn)object;
                text = this.isUseSQLSyntax() && this.isAllowFullColumnName(col, usePassthru) ? col.getFullColumnName(useQuotes, usePassthru) : col.getColumnName(useQuotes, usePassthru);
            } else if (object instanceof ITable) {
                ITable table = (ITable)object;
                if (table instanceof IPhysicalTable) {
                    if (this.isUseSQLSyntax()) {
                        try {
                            text = table.getFullNameQuotedAsNeeded(currentServer, useQuotes, usePassthru);
                        }
                        catch (BadLibraryDefinitionException e) {
                            ModelLogger.getDefaultLogger().error((Object)"BadLibraryDefinitionException", (Throwable)e);
                        }
                    } else {
                        text = ((IPhysicalTable)table).getTableName(useQuotes, usePassthru);
                    }
                } else if (table instanceof IExternalTable) {
                    String extName = table.getName();
                    text = !useQuotes ? extName : "\"" + extName + "\"n";
                }
            }
        }
        return text;
    }

    private boolean isAllowFullColumnName(IColumn col, boolean usePassthru) {
        boolean isAllowed = true;
        String deleleTRANSFORMATION_CLASS = "com.sas.wadmin.transforms.sql.delete.SQLDelete";
        if (this.m_transformModel != null && deleleTRANSFORMATION_CLASS == this.m_transformModel.getType() && this.m_transformModel.getDataTargets() != null && this.m_transformModel.getDataTargets().length > 0) {
            IPhysicalTable targetTable = (IPhysicalTable)this.m_transformModel.getDataTargets()[0];
            if (usePassthru && targetTable == col.getTable() && targetTable.getLibrary() != null && targetTable.getLibrary().getDBMSType().getDBMSTypeID() == 1) {
                isAllowed = false;
            }
        }
        return isAllowed;
    }

    @Override
    public void setCode(String sCode) throws ServerException {
        this.setText(sCode, null);
    }

    @Override
    public String getCode() throws ServerException {
        return this.getText(null, false);
    }

    private class SetTextUndoable
    extends AbstractUndoableEdit {
        private String m_sOldText;
        private IObject[] m_lOldObjects;
        private String m_sNewText;
        private IObject[] m_lNewObjects;

        public SetTextUndoable(String sOldText, IObject[] oldObjects, String sNewText, IObject[] newObjects) {
            this.m_sOldText = sOldText;
            this.m_lOldObjects = oldObjects;
            this.m_sNewText = sNewText;
            this.m_lNewObjects = newObjects;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTextExpression.this.setText(this.m_sOldText, this.m_lOldObjects);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTextExpression.this.setText(this.m_sNewText, this.m_lNewObjects);
        }

        @Override
        public void die() {
            super.die();
            this.m_lOldObjects = null;
            this.m_lNewObjects = null;
        }
    }

    private class ReplaceColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;
        private String m_token;

        public ReplaceColumnUndoable(IColumn oldColumn, IColumn newColumn, String token) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
            this.m_token = token;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTextExpression.this.m_hmTokenizedVarObjects.put(this.m_token, this.m_oldColumn);
            if (this.m_newColumn != null) {
                this.m_newColumn.removeNotifyListener(BaseTextExpression.this);
            }
            if (this.m_oldColumn != null) {
                this.m_oldColumn.addNotifyListener(BaseTextExpression.this);
            }
            BaseTextExpression.this.fireModelChangedEvent("TextExpression:TextChanged", this);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTextExpression.this.m_hmTokenizedVarObjects.put(this.m_token, this.m_newColumn);
            if (this.m_oldColumn != null) {
                this.m_oldColumn.removeNotifyListener(BaseTextExpression.this);
            }
            if (this.m_newColumn != null) {
                this.m_newColumn.addNotifyListener(BaseTextExpression.this);
            }
            BaseTextExpression.this.fireModelChangedEvent("TextExpression:TextChanged", this);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldColumn = null;
            this.m_newColumn = null;
        }
    }

    private class cObjectName {
        private String m_name;
        private boolean m_bIsLongName;
        private Object m_object;

        public cObjectName(Object object, String name, boolean isLongName) {
            this.m_name = name;
            this.m_bIsLongName = isLongName;
            this.m_object = object;
        }

        public String getName() {
            return this.m_name;
        }

        public boolean isLongName() {
            return this.m_bIsLongName;
        }

        public String toString() {
            return this.m_name;
        }

        public Object getObject() {
            return this.m_object;
        }

        public int getObjectIndex() {
            int index = -1;
            if (BaseTextExpression.this.m_lObjects != null && this.m_object != null) {
                List<IObject> objs = Arrays.asList(BaseTextExpression.this.m_lObjects);
                index = objs.indexOf(this.m_object);
            }
            return index;
        }
    }

    private class Token {
        private boolean m_bCanSubstitute;
        private String m_sTokenText;

        protected Token(boolean substitute, String text) {
            this.m_bCanSubstitute = substitute;
            this.m_sTokenText = text;
        }

        public void foundMatch(String newtext) {
            if (this.m_bCanSubstitute) {
                this.m_bCanSubstitute = false;
                this.m_sTokenText = newtext;
            }
        }

        public void setCanSubstitute(boolean canSub) {
            this.m_bCanSubstitute = canSub;
        }

        public void addString(String moreText) {
            if (moreText != null) {
                this.m_sTokenText = this.m_sTokenText + moreText;
            }
        }

        public boolean canSubstitute() {
            return this.m_bCanSubstitute;
        }

        public String getText() {
            return this.m_sTokenText;
        }
    }
}

