/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IGeneratedTransformPort;
import com.sas.etl.models.job.IGeneratedTransformTemplate;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseGeneratedTransformTemplate
extends AbstractPersistableObject
implements IGeneratedTransformTemplate {
    private static final String SOURCE_MINIMUM = "SourceMinimum";
    private static final String SOURCE_MAXIMUM = "SourceMaximum";
    private static final String TARGET_MINIMUM = "TargetMinimum";
    private static final String TARGET_MAXIMUM = "TargetMaximum";
    private List m_lstSourcePorts = new ArrayList();
    private List m_lstTargetPorts = new ArrayList();
    private int m_sourceMinimum = 0;
    private int m_sourceMaximum = 0;
    private int m_targetMinimum = 0;
    private int m_targetMaximum = 0;
    private static final String DEFAULT_NAME = "PFDTEMPLATE";

    public BaseGeneratedTransformTemplate(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get("Prototype");
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
        }
        lAssociations.add("PrototypeProperties");
        map.put("Prototype", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("UsingPrototype");
        map.put("AssociationProperty", lAssociations);
        return map;
    }

    @Override
    public int getSourcePortCount() {
        return this.m_lstSourcePorts.size();
    }

    @Override
    public int getTargetPortCount() {
        return this.m_lstTargetPorts.size();
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "Prototype";
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        List ports = this.getAllPorts();
        int size = ports.size();
        for (int i = 0; i < size; ++i) {
            if (!((IGeneratedTransformPort)ports.get(i)).isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete() {
        List ports = this.getAllPorts();
        for (int i = 0; i < ports.size(); ++i) {
            ((IGeneratedTransformPort)ports.get(i)).delete();
        }
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.deleteFromOMR(omr);
        List ports = this.getAllPorts();
        int size = ports.size();
        for (int i = 0; i < size; ++i) {
            ((IGeneratedTransformPort)ports.get(i)).deleteFromOMR(omr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGeneratedTransformTemplate updateTemplate(IGeneratedTransformTemplate parentTemplate) {
        this.startCompoundUndoable();
        try {
            int i;
            int i2;
            this.setSourceMaximum(parentTemplate.getSourceMaximum());
            this.setSourceMinimum(parentTemplate.getSourceMinimum());
            this.setTargetMaximum(parentTemplate.getTargetMaximum());
            this.setTargetMinimum(parentTemplate.getTargetMinimum());
            IGeneratedTransformPort[] parentSrcPorts = parentTemplate.getSourcePorts();
            IGeneratedTransformPort[] srcPorts = this.getSourcePorts();
            int srcDisplayedPorts = srcPorts.length;
            ArrayList<IPhysicalTable> sourceTables = new ArrayList<IPhysicalTable>();
            for (i2 = 0; i2 < srcPorts.length; ++i2) {
                IPhysicalTable table = srcPorts[i2].getTable();
                sourceTables.add(table);
                srcPorts[i2].setOptional(true);
            }
            for (i2 = 0; i2 < parentSrcPorts.length; ++i2) {
                if (srcPorts.length <= i2) {
                    IGeneratedTransformPort newPort = parentSrcPorts[i2].copy(this.getID());
                    this.addSourcePort(newPort);
                    continue;
                }
                srcPorts[i2].copySimpleAttributes(parentSrcPorts[i2]);
            }
            while (this.getSourcePorts().length < srcDisplayedPorts && this.canPortBeAdded(true)) {
                IGeneratedTransformPort port = this.getPortToBeAdded(parentTemplate, true);
                port.setOptional(true);
                this.addSourcePort(port);
                int index = this.getPortIndex(port);
                if (index >= sourceTables.size() || sourceTables.get(index) == null) continue;
                port.setTable((IPhysicalTable)sourceTables.get(index));
            }
            while (this.getSourcePorts().length > srcDisplayedPorts && this.canPortBeRemoved(true)) {
                this.removeSourcePort(this.getPortToRemove(true));
            }
            while (this.getSourcePorts().length > this.getSourceMaximum()) {
                this.removeSourcePort(this.getPortToRemove(true));
            }
            IGeneratedTransformPort[] parentTarPorts = parentTemplate.getTargetPorts();
            IGeneratedTransformPort[] targetPorts = this.getTargetPorts();
            int tarDisplayedPorts = targetPorts.length;
            ArrayList<IPhysicalTable> targetTables = new ArrayList<IPhysicalTable>();
            for (i = 0; i < targetPorts.length; ++i) {
                IPhysicalTable table = targetPorts[i].getTable();
                targetTables.add(table);
                targetPorts[i].setOptional(true);
            }
            for (i = 0; i < parentTarPorts.length; ++i) {
                if (targetPorts.length <= i) {
                    IGeneratedTransformPort newPort = parentTarPorts[i].copy(this.getID());
                    this.addTargetPort(newPort);
                    continue;
                }
                targetPorts[i].copySimpleAttributes(parentTarPorts[i]);
            }
            while (this.getTargetPorts().length < tarDisplayedPorts && this.canPortBeAdded(false)) {
                IGeneratedTransformPort port = this.getPortToBeAdded(parentTemplate, false);
                port.setOptional(true);
                this.addTargetPort(port);
                int index = this.getPortIndex(port);
                if (index >= targetTables.size() || targetTables.get(index) == null) continue;
                port.setTable((IPhysicalTable)targetTables.get(index));
            }
            while (this.getTargetPorts().length > tarDisplayedPorts && this.canPortBeRemoved(false)) {
                this.removeTargetPort(this.getPortToRemove(false));
            }
            while (this.getTargetPorts().length > this.getTargetMaximum()) {
                this.removeTargetPort(this.getPortToRemove(false));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
        return this;
    }

    @Override
    public int findInSourcePorts(IPhysicalTable table) {
        IGeneratedTransformPort[] ports = this.getSourcePorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i].getTable() != table) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int findInTargetPorts(IPhysicalTable table) {
        IGeneratedTransformPort[] ports = this.getTargetPorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i].getTable() != table) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getNumberTimesTableUsedInTargets(IPhysicalTable table) {
        int cnt = 0;
        if (table != null) {
            IGeneratedTransformPort[] ports = this.getTargetPorts();
            for (int i = 0; i < ports.length; ++i) {
                if (ports[i].getTable() != table) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public int getNumberTimesTableUsedInSources(IPhysicalTable table) {
        int cnt = 0;
        if (table != null) {
            IGeneratedTransformPort[] ports = this.getSourcePorts();
            for (int i = 0; i < ports.length; ++i) {
                if (ports[i].getTable() != table) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public void addSourcePort(IGeneratedTransformPort port) {
        this.addSourcePort(this.m_lstSourcePorts.size(), port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourcePort(int index, IGeneratedTransformPort port) {
        if (this.m_lstSourcePorts.contains(port)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddSourcePortUndoable(port));
            }
            this.m_lstSourcePorts.add(index, port);
            int max = port.getMaximum();
            if (max == 0) {
                max = Integer.MAX_VALUE;
            }
            this.setSourceMaximum(max);
            this.setSourceMinimum(port.getMinimum());
            port.setOwningTemplate(this);
            this.removeFromDeletedObjects(port);
            port.addNotifyListener(this);
            this.fireModelChangedEvent("IGeneratedTransformTemplate:SourcePortAdded", port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void removeSourcePort(IGeneratedTransformPort port) {
        if (!this.m_lstSourcePorts.contains(port)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new RemoveSourcePortUndoable(port));
            }
            this.fireModelChangedEvent("IGeneratedTransformTemplate:SourcePortRemoved", port);
            this.m_lstSourcePorts.remove(port);
            this.addToDeletedObjects(port);
            port.removeNotifyListener(this);
            this.fireModelChangedEvent("IGeneratedTransformTemplate:SourcePortRemoved", port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IGeneratedTransformPort[] getSourcePorts() {
        return this.m_lstSourcePorts.toArray(new IGeneratedTransformPort[this.m_lstSourcePorts.size()]);
    }

    @Override
    public void addTargetPort(IGeneratedTransformPort port) {
        this.addTargetPort(this.m_lstTargetPorts.size(), port);
    }

    @Override
    public void addTargetPort(int index, IGeneratedTransformPort port) {
        if (this.m_lstTargetPorts.contains(port)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddTargetPortUndoable(port));
            }
            this.m_lstTargetPorts.add(index, port);
            port.setOwningTemplate(this);
            this.removeFromDeletedObjects(port);
            port.addNotifyListener(this);
            this.fireModelChangedEvent("IGeneratedTransformTemplate:TargetPortAdded", port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public int getPortIndex(IGeneratedTransformPort port) {
        if (port.isInputTemplate()) {
            return this.m_lstSourcePorts.indexOf(port);
        }
        return this.m_lstTargetPorts.indexOf(port);
    }

    @Override
    public void removeTargetPort(IGeneratedTransformPort port) {
        if (!this.m_lstTargetPorts.contains(port)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.fireModelChangedEvent("IGeneratedTransformTemplate:TargetPortRemoved", port);
            this.m_lstTargetPorts.remove(port);
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new RemoveTargetPortUndoable(port));
            }
            this.addToDeletedObjects(port);
            port.removeNotifyListener(this);
            this.fireModelChangedEvent("IGeneratedTransformTemplate:TargetPortRemoved", port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IGeneratedTransformPort[] getTargetPorts() {
        return this.m_lstTargetPorts.toArray(new IGeneratedTransformPort[this.m_lstTargetPorts.size()]);
    }

    @Override
    public void setSourceMinimum(int min) {
        if (this.m_sourceMinimum == min) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSourceMinimumUndoable(this.m_sourceMinimum, min));
        }
        this.m_sourceMinimum = min;
        this.fireModelChangedEvent("IGeneratedTransformTemplate:SourceMinimumChanged", null);
    }

    @Override
    public int getSourceMinimum() {
        return this.m_sourceMinimum;
    }

    @Override
    public void setSourceMaximum(int max) {
        if (this.m_sourceMaximum == max) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSourceMaximumUndoable(this.m_sourceMaximum, max));
        }
        this.m_sourceMaximum = max;
        this.fireModelChangedEvent("IGeneratedTransformTemplate:SourceMaximumChanged", null);
    }

    @Override
    public int getSourceMaximum() {
        return this.m_sourceMaximum;
    }

    @Override
    public void setTargetMinimum(int min) {
        if (this.m_targetMinimum == min) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetMinimumUndoable(this.m_targetMinimum, min));
        }
        this.m_targetMinimum = min;
        this.fireModelChangedEvent("IGeneratedTransformTemplate:TargetMinimumChanged", null);
    }

    @Override
    public int getTargetMinimum() {
        return this.m_targetMinimum;
    }

    @Override
    public void setTargetMaximum(int max) {
        if (this.m_targetMaximum == max) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetMaximumUndoable(this.m_targetMaximum, max));
        }
        this.m_targetMaximum = max;
        this.fireModelChangedEvent("IGeneratedTransformTemplate:TargetMaximumChanged", null);
    }

    @Override
    public int getTargetMaximum() {
        return this.m_targetMaximum;
    }

    private List getAllPorts() {
        ArrayList<IGeneratedTransformPort> templates = new ArrayList<IGeneratedTransformPort>();
        templates.addAll(Arrays.asList(this.getSourcePorts()));
        templates.addAll(Arrays.asList(this.getTargetPorts()));
        return templates;
    }

    @Override
    public IGeneratedTransformPort[] getPorts() {
        List ports = this.getAllPorts();
        return ports.toArray(new IGeneratedTransformPort[ports.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGeneratedTransformTemplate copy(String containerId) {
        this.startCompoundUndoable();
        try {
            IGeneratedTransformTemplate newTemplate = this.getModel().getObjectFactory().createNewGeneratedTransformTemplate(containerId);
            List templates = this.getAllPorts();
            int size = templates.size();
            for (int i = 0; i < size; ++i) {
                IGeneratedTransformPort port = (IGeneratedTransformPort)templates.get(i);
                if (port.isInputTemplate()) {
                    newTemplate.addSourcePort(port.copy(containerId));
                    continue;
                }
                newTemplate.addTargetPort(port.copy(containerId));
            }
            newTemplate.setSourceMaximum(this.getSourceMaximum());
            newTemplate.setSourceMinimum(this.getSourceMinimum());
            newTemplate.setTargetMaximum(this.getTargetMaximum());
            newTemplate.setTargetMinimum(this.getTargetMinimum());
            IGeneratedTransformTemplate iGeneratedTransformTemplate = newTemplate;
            return iGeneratedTransformTemplate;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public int getOptionalPortCount(boolean sourcePorts) {
        int cnt = 0;
        IGeneratedTransformPort[] ports = sourcePorts ? this.getSourcePorts() : this.getTargetPorts();
        for (int i = 0; i < ports.length; ++i) {
            if (!ports[i].isOptional()) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public boolean canPortBeRemoved(boolean sourcePorts) {
        return this.getPortToRemove(sourcePorts) != null;
    }

    @Override
    public IGeneratedTransformPort getPortToRemove(boolean sourcePorts) {
        IGeneratedTransformPort[] ports = sourcePorts ? this.getSourcePorts() : this.getTargetPorts();
        for (int i = ports.length - 1; i >= 0; --i) {
            IGeneratedTransformPort pt = ports[i];
            if (!pt.isOptional()) continue;
            return pt;
        }
        return null;
    }

    @Override
    public boolean canPortBeAdded(boolean sourcePorts) {
        IGeneratedTransformPort[] ports = sourcePorts ? this.getSourcePorts() : this.getTargetPorts();
        int max = sourcePorts ? this.getSourceMaximum() : this.getTargetMaximum();
        return ports.length < max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGeneratedTransformPort getPortToBeAdded(IGeneratedTransformTemplate parentTemplate, boolean sourcePorts) {
        if (!this.canPortBeAdded(sourcePorts)) {
            return null;
        }
        this.startCompoundUndoable();
        try {
            IGeneratedTransformPort[] parentPorts = sourcePorts ? parentTemplate.getSourcePorts() : parentTemplate.getTargetPorts();
            int portCount = sourcePorts ? this.getSourcePortCount() : this.getTargetPortCount();
            IGeneratedTransformPort port = null;
            if (portCount < parentPorts.length) {
                port = parentPorts[portCount].copy(this.getID());
                port.setOwningTemplate(this);
            } else {
                port = this.getModel().getObjectFactory().createNewGeneratedTransformPort(this.getID());
                port.setOwningTemplate(this);
                port.setOptional(true);
                port.setMinimum(sourcePorts ? this.getSourceMinimum() : this.getTargetMinimum());
                port.setMaximum(sourcePorts ? this.getSourceMaximum() : this.getTargetMaximum());
                port.setAsInputTemplate(sourcePorts);
            }
            IGeneratedTransformPort iGeneratedTransformPort = port;
            return iGeneratedTransformPort;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IGeneratedTransformTemplate updateDisplayedPorts() {
        return this.updateDisplayedPorts(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGeneratedTransformTemplate updateDisplayedPorts(boolean useTableCheck) {
        this.startCompoundUndoable();
        try {
            IGeneratedTransformPort[] sourcePorts = this.getSourcePorts();
            for (int i = 0; i < sourcePorts.length; ++i) {
                if (!sourcePorts[i].isOptional()) continue;
                if (useTableCheck && sourcePorts[i].getTable() == null) {
                    this.removeSourcePort(sourcePorts[i]);
                    continue;
                }
                if (useTableCheck) continue;
                this.removeSourcePort(sourcePorts[i]);
            }
            IGeneratedTransformPort[] targetPorts = this.getTargetPorts();
            for (int i = 0; i < targetPorts.length; ++i) {
                if (!targetPorts[i].isOptional()) continue;
                if (useTableCheck && targetPorts[i].getTable() == null) {
                    this.removeTargetPort(targetPorts[i]);
                    continue;
                }
                if (useTableCheck) continue;
                this.removeTargetPort(targetPorts[i]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGeneratedTransformTemplate cleanPorts() {
        this.startCompoundUndoable();
        try {
            int srcMax = this.getSourceMaximum();
            IGeneratedTransformPort[] sourcePorts = this.getSourcePorts();
            for (int i = sourcePorts.length; i > srcMax; --i) {
                this.removeSourcePort(sourcePorts[i - 1]);
            }
            int tarMax = this.getTargetMaximum();
            IGeneratedTransformPort[] targetPorts = this.getTargetPorts();
            for (int i = targetPorts.length; i > tarMax; --i) {
                this.removeTargetPort(targetPorts[i - 1]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
        return this;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Prototype proto = (Prototype)omr.acquireOMRObject(this);
        this.setSourceMinimum(Integer.parseInt(this.loadPropertyFromOMR(omr, "", SOURCE_MINIMUM, "0", 1)));
        this.setSourceMaximum(Integer.parseInt(this.loadPropertyFromOMR(omr, "", SOURCE_MAXIMUM, "0", 1)));
        this.setTargetMinimum(Integer.parseInt(this.loadPropertyFromOMR(omr, "", TARGET_MINIMUM, "0", 1)));
        this.setTargetMaximum(Integer.parseInt(this.loadPropertyFromOMR(omr, "", TARGET_MAXIMUM, "0", 1)));
        AssociationList props = proto.getPrototypeProperties();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            int max;
            Object t = props.get(i);
            if (!(t instanceof AssociationProperty)) continue;
            AssociationProperty associationProp = (AssociationProperty)props.get(i);
            IGeneratedTransformPort port = this.getModel().getObjectFactory().createGeneratedTransformPort(associationProp.getFQID());
            port.setOwningTemplate(this);
            port.loadFromOMR(omr);
            if (port.isInputTemplate()) {
                this.addSourcePort(port);
                max = port.getMaximum();
                if (max == 0) {
                    max = Integer.MAX_VALUE;
                }
                this.setSourceMaximum(max);
                this.setSourceMinimum(port.getMinimum());
                continue;
            }
            this.addTargetPort(port);
            max = port.getMaximum();
            if (max == 0) {
                max = Integer.MAX_VALUE;
            }
            this.setTargetMaximum(max);
            this.setTargetMinimum(port.getMinimum());
        }
        IGeneratedTransformPort[] srcports = this.getSourcePorts();
        for (int i = this.getSourceMinimum(); i < srcports.length; ++i) {
            srcports[i].setOptional(true);
            srcports[i].setChanged(false);
        }
        IGeneratedTransformPort[] tarports = this.getTargetPorts();
        for (int i = this.getTargetMinimum(); i < tarports.length; ++i) {
            tarports[i].setOptional(true);
            tarports[i].setChanged(false);
        }
        this.cleanPorts();
        this.setChanged(false);
    }

    @Override
    public IGeneratedTransformPort getNextAvailablePort(boolean isSource) {
        IGeneratedTransformPort[] ports = isSource ? this.getSourcePorts() : this.getTargetPorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i].getTable() != null) continue;
            return ports[i];
        }
        return null;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Prototype proto = (Prototype)omr.acquireOMRObject(this);
        this.savePropertyToOMR(omr, (Root)proto, "", SOURCE_MINIMUM, SOURCE_MINIMUM, SOURCE_MINIMUM, Integer.toString(this.getSourceMinimum()), 4, 1);
        this.savePropertyToOMR(omr, (Root)proto, "", SOURCE_MAXIMUM, SOURCE_MAXIMUM, SOURCE_MAXIMUM, Integer.toString(this.getSourceMaximum()), 4, 1);
        this.savePropertyToOMR(omr, (Root)proto, "", TARGET_MINIMUM, TARGET_MINIMUM, TARGET_MINIMUM, Integer.toString(this.getTargetMinimum()), 4, 1);
        this.savePropertyToOMR(omr, (Root)proto, "", TARGET_MAXIMUM, TARGET_MAXIMUM, TARGET_MAXIMUM, Integer.toString(this.getTargetMaximum()), 4, 1);
        AssociationList props = proto.getPrototypeProperties(false);
        props.clear();
        List templates = this.getAllPorts();
        int size = templates.size();
        for (int i = 0; i < size; ++i) {
            IGeneratedTransformPort port = (IGeneratedTransformPort)templates.get(i);
            port.saveToOMR(omr);
            props.add(omr.acquireOMRObject(port));
        }
        this.setChanged(false);
    }

    private class AddSourcePortUndoable
    extends AbstractUndoableEdit {
        private IGeneratedTransformPort m_port;

        public AddSourcePortUndoable(IGeneratedTransformPort port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformTemplate.this.removeSourcePort(this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformTemplate.this.addSourcePort(this.m_port);
        }
    }

    private class RemoveSourcePortUndoable
    extends AbstractUndoableEdit {
        private IGeneratedTransformPort m_port;

        public RemoveSourcePortUndoable(IGeneratedTransformPort port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformTemplate.this.addSourcePort(this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformTemplate.this.removeSourcePort(this.m_port);
        }
    }

    private class AddTargetPortUndoable
    extends AbstractUndoableEdit {
        private IGeneratedTransformPort m_port;

        public AddTargetPortUndoable(IGeneratedTransformPort port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformTemplate.this.removeTargetPort(this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformTemplate.this.addTargetPort(this.m_port);
        }
    }

    private class RemoveTargetPortUndoable
    extends AbstractUndoableEdit {
        private IGeneratedTransformPort m_port;

        public RemoveTargetPortUndoable(IGeneratedTransformPort port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformTemplate.this.addTargetPort(this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformTemplate.this.removeTargetPort(this.m_port);
        }
    }

    private class SetSourceMinimumUndoable
    extends AbstractUndoableEdit {
        private int m_oldSourceMinimum;
        private int m_newSourceMinimum;

        public SetSourceMinimumUndoable(int oldSourceMinimum, int newSourceMinimum) {
            this.m_oldSourceMinimum = oldSourceMinimum;
            this.m_newSourceMinimum = newSourceMinimum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformTemplate.this.setSourceMinimum(this.m_oldSourceMinimum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformTemplate.this.setSourceMinimum(this.m_newSourceMinimum);
        }
    }

    private class SetSourceMaximumUndoable
    extends AbstractUndoableEdit {
        private int m_oldSourceMaximum;
        private int m_newSourceMaximum;

        public SetSourceMaximumUndoable(int oldSourceMaximum, int newSourceMaximum) {
            this.m_oldSourceMaximum = oldSourceMaximum;
            this.m_newSourceMaximum = newSourceMaximum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformTemplate.this.setSourceMaximum(this.m_oldSourceMaximum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformTemplate.this.setSourceMaximum(this.m_newSourceMaximum);
        }
    }

    private class SetTargetMinimumUndoable
    extends AbstractUndoableEdit {
        private int m_oldTargetMinimum;
        private int m_newTargetMinimum;

        public SetTargetMinimumUndoable(int oldTargetMinimum, int newTargetMinimum) {
            this.m_oldTargetMinimum = oldTargetMinimum;
            this.m_newTargetMinimum = newTargetMinimum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformTemplate.this.setTargetMinimum(this.m_oldTargetMinimum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformTemplate.this.setTargetMinimum(this.m_newTargetMinimum);
        }
    }

    private class SetTargetMaximumUndoable
    extends AbstractUndoableEdit {
        private int m_oldTargetMaximum;
        private int m_newTargetMaximum;

        public SetTargetMaximumUndoable(int oldTargetMaximum, int newTargetMaximum) {
            this.m_oldTargetMaximum = oldTargetMaximum;
            this.m_newTargetMaximum = newTargetMaximum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseGeneratedTransformTemplate.this.setTargetMaximum(this.m_oldTargetMaximum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseGeneratedTransformTemplate.this.setTargetMaximum(this.m_newTargetMaximum);
        }
    }
}

