/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.INotifyListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ILoaderTransform;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.BaseLoaderPromptModel;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class AbstractLoaderTransform
extends AbstractDataTransform
implements ILoaderTransform,
INotifyListener {
    private IColumn m_loadTimeColumn = null;
    protected String[] m_defaultLoadTimeColumns = new String[]{"_LOADTM"};

    public AbstractLoaderTransform(String sID, IModel model) {
        super(sID, model);
    }

    protected void setDefaultLoadTimeColumnNames(String[] m_names) {
        this.m_defaultLoadTimeColumns = m_names;
    }

    protected String[] getDefaultLoadTimeColumnNames() {
        return this.m_defaultLoadTimeColumns;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new BaseLoaderPromptModel(this.getModel(), this);
    }

    @Override
    public ICodeSegment getGenerateTableIndexes(ICodeSegment codeSegment) {
        return codeSegment;
    }

    public IPhysicalTable getSourceTable() {
        return this.getSourceTables().length > 0 ? (IPhysicalTable)this.getSourceTables()[0] : null;
    }

    public IPhysicalTable getTargetTable() {
        return this.getTargetTables().length > 0 ? (IPhysicalTable)this.getTargetTables()[0] : null;
    }

    public boolean isSourceAndTargetSameDatabaseServer() {
        IPhysicalTable source = this.getSourceTable();
        IPhysicalTable target = this.getTargetTable();
        try {
            if (source != null && target != null && source.equalsDatabaseServer(this.getExecutionServer(), target) && target.getDBMSType() instanceof BaseDBMSType) {
                return true;
            }
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"BadLibraryDefinitionException", (Throwable)e);
        }
        return false;
    }

    @Override
    public IColumn getLoadTimeColumn() {
        return this.m_loadTimeColumn;
    }

    @Override
    public void setLoadTimeColumn(IColumn column) {
        IPhysicalTable target;
        if (this.m_loadTimeColumn == column) {
            return;
        }
        if (!(column == null || (target = this.getTargetTable()) == null || Arrays.asList(target.getColumns()).contains(column) && column.getType() == 1)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLoadTimeColumnUndoable(this.m_loadTimeColumn, column));
        }
        if (column != null) {
            column.addNotifyListener(this);
        }
        if (this.m_loadTimeColumn != null) {
            this.m_loadTimeColumn.removeNotifyListener(this);
        }
        this.m_loadTimeColumn = column;
        this.fireModelChangedEvent("AbstractLoaderTransform:LoadTimeColumnChanged", this.m_loadTimeColumn);
    }

    @Override
    protected void postRemoveDataTarget(IDataObject target) {
        block13: {
            this.startCompoundUndoable();
            super.postRemoveDataTarget(target);
            try {
                if (target != this.getTargetTable()) break block13;
                this.setLoadTimeColumn(null);
                try {
                    IPromptModel optionModel = this.getOptionModel();
                    if (optionModel != null) {
                        optionModel.clearOptionDefaultValue("LoadTime");
                    }
                }
                catch (FileNotFoundException e) {
                    ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
                }
                catch (ServiceException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
                }
                catch (ServerConnectionException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
                }
                catch (RemoteException e) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
                }
                catch (IOException e) {
                    ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
                }
                catch (SAXException e) {
                    ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
                }
                catch (MdException e) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postAddDataTarget(IDataObject target) {
        block14: {
            if (target instanceof ITable) {
                this.startCompoundUndoable();
                super.postAddDataTarget(target);
                try {
                    if (target != this.getTargetTable()) break block14;
                    ITable table = (ITable)target;
                    IColumn defaultLoadTime = this.findDefaultLoadTimeColumn(table);
                    this.setLoadTimeColumn(defaultLoadTime);
                    try {
                        IPromptModel optionModel = this.getOptionModel();
                        if (optionModel == null) break block14;
                        if (defaultLoadTime != null) {
                            optionModel.setOptionDefaultValue("LoadTime", (Object)defaultLoadTime);
                            break block14;
                        }
                        optionModel.clearOptionDefaultValue("LoadTime");
                    }
                    catch (FileNotFoundException e) {
                        ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
                    }
                    catch (ServiceException e) {
                        ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
                    }
                    catch (ServerConnectionException e) {
                        ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
                    }
                    catch (RemoteException e) {
                        ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
                    }
                    catch (IOException e) {
                        ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
                    }
                    catch (ParserConfigurationException e) {
                        ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
                    }
                    catch (SAXException e) {
                        ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
                    }
                    catch (MdException e) {
                        ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
                    }
                }
                finally {
                    this.endCompoundUndoable();
                }
            }
        }
    }

    protected IColumn findColumnByName(ITable table, String name) {
        IColumn[] cols = table.getColumns();
        for (int j = 0; j < cols.length; ++j) {
            IColumn column = cols[j];
            if (!column.getName().equalsIgnoreCase(name) || column.getType() != 1) continue;
            return column;
        }
        return null;
    }

    protected IColumn findDefaultLoadTimeColumn(ITable table) {
        String[] names = this.getDefaultLoadTimeColumnNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                IColumn loadTime = this.findColumnByName(table, names[i]);
                if (loadTime == null) continue;
                return loadTime;
            }
        }
        return null;
    }

    protected boolean isLoadTimeColumnValid() {
        return this.isColumnValidForLoadTimeValue(this.getLoadTimeColumn());
    }

    protected boolean isColumnValidForLoadTimeValue(IColumn column) {
        if (column != null && this.getTargetTable() != null) {
            return column.getType() == 1 && this.getTargetTable() == column.getTable();
        }
        return true;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public void notify(NotifyEvent ev) {
        ModelEvent modelEvent = ev.getModelEvent();
        if (modelEvent != null) {
            IColumn loadTime;
            IObject obj = modelEvent.getModelObject();
            if (obj == (loadTime = this.getLoadTimeColumn())) {
                if (!this.isLoadTimeColumnValid()) {
                    this.setLoadTimeColumn(null);
                }
            } else if (this.getTargetTable() != null && Arrays.asList(this.getDataTargets()).contains(obj)) {
                if (!this.isLoadTimeColumnValid()) {
                    this.setLoadTimeColumn(null);
                }
                IColumn column = this.findDefaultLoadTimeColumn(this.getTargetTable());
                try {
                    IPromptModel optionModel = this.getOptionModel();
                    if (optionModel != null) {
                        if (null != column) {
                            optionModel.setOptionDefaultValue("LoadTime", (Object)column);
                        } else {
                            optionModel.clearOptionDefaultValue("LoadTime");
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
                }
                catch (ServiceException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
                }
                catch (ServerConnectionException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
                }
                catch (RemoteException e) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
                }
                catch (IOException e) {
                    ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
                }
                catch (SAXException e) {
                    ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
                }
                catch (MdException e) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
                }
            }
        }
        super.notify(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            IColumn loadTimeColumn = this.getLoadTimeColumn();
            super.replaceTargetTable(oldTable, newTable, columnsMap);
            if (loadTimeColumn != null) {
                if (columnsMap != null && columnsMap.get(loadTimeColumn) != null) {
                    IColumn newLoadTime = (IColumn)columnsMap.get(loadTimeColumn);
                    if (this.isColumnValidForLoadTimeValue(newLoadTime)) {
                        this.setLoadTimeColumn(newLoadTime);
                    }
                } else {
                    IColumn[] targetColumns = newTable.getColumns();
                    for (int i = 0; i < targetColumns.length; ++i) {
                        IColumn column = targetColumns[i];
                        if (!loadTimeColumn.equalsName(column, this.isQuotingNeeded()) || !this.isColumnValidForLoadTimeValue(column)) continue;
                        this.setLoadTimeColumn(column);
                        return;
                    }
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        TransformationStep step = (TransformationStep)omr.acquireOMRObject(this);
        Property prop = this.findProperty(omr, (Root)step, "OPTIONS", "LoadTime", 2);
        if (prop != null) {
            if (prop.getSQLType() == 2000) {
                IPersistableObject[] cols = this.loadObjectListPropertyFromOMR(omr, "OPTIONS", "LoadTime", 2);
                if (cols != null && cols.length > 0) {
                    this.setLoadTimeColumn((IColumn)cols[0]);
                } else {
                    this.setLoadTimeColumn(null);
                }
            } else if (this.getTargetTable() != null) {
                IPhysicalTable target = this.getTargetTable();
                String columnName = prop.getDefaultValue();
                IColumn loadTime = this.findColumnByName(target, columnName);
                this.setLoadTimeColumn(loadTime);
            }
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] iPersistableObjectArray;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        IColumn loadTimeColumn = this.getLoadTimeColumn();
        if (loadTimeColumn != null) {
            IPersistableObject[] iPersistableObjectArray2 = new IPersistableObject[1];
            iPersistableObjectArray = iPersistableObjectArray2;
            iPersistableObjectArray2[0] = loadTimeColumn;
        } else {
            iPersistableObjectArray = new IPersistableObject[]{};
        }
        this.saveObjectListPropertyToOMR(omr, "OPTIONS", "LoadTime", "LoadTime", "", iPersistableObjectArray, 2000, 2);
        TransformationStep step = (TransformationStep)omr.acquireOMRObject(this);
        Property prop = this.findProperty(omr, (Root)step, "OPTIONS", "LoadTime", 2);
        if (prop != null) {
            prop.setSQLType(2000);
        }
        this.setChanged(false);
    }

    public ICodeSegment append(ICodeSegment codeSegment, IPhysicalTable targetTable, boolean genJobStatus, String tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        codeSegment.addSectionComment(RB.getStringResource("TableLoaderTransformModel.Append.msg.notrans")).genPercentPutStatement(RB.getStringResource("TableLoaderTransformModel.Append.note.sasmacro.notrans")).addSourceCode("\n");
        String tableName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
        StringBuffer gen_opts = new StringBuffer();
        gen_opts.append(this.getTableOptionObject(targetTable, false).getTableOptions(true, null, tableOptions, codeSegment.getCurrentServer()));
        if (genJobStatus) {
            codeSegment.genJobStatusUpdateBefore(targetTable);
        }
        codeSegment.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode(" \n").addSourceCode("   data = &etls_lastTable (&etls_tableOptions) ");
        if (this.isAppendForceEnabled()) {
            codeSegment.addSourceCode(" force ");
        }
        codeSegment.addSourceCode("; \n run; \n\n").genRCSetCall("&syserr");
        if (genJobStatus) {
            codeSegment.genJobStatusUpdateAfter(targetTable);
        }
        return codeSegment;
    }

    @Override
    public boolean isGenDefaultJobStatusUpdate() {
        return false;
    }

    private class SetLoadTimeColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldLoadTime;
        private IColumn m_newLoadTime;

        public SetLoadTimeColumnUndoable(IColumn oldLoadTime, IColumn newLoadTime) {
            this.m_oldLoadTime = oldLoadTime;
            this.m_newLoadTime = newLoadTime;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractLoaderTransform.this.setLoadTimeColumn(this.m_oldLoadTime);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractLoaderTransform.this.setLoadTimeColumn(this.m_newLoadTime);
        }
    }
}

