/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IBooleanExpression;
import com.sas.etl.models.job.IBooleanExpressionContainer;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractBooleanExpressionContainer
extends AbstractPersistableObject
implements IBooleanExpressionContainer {
    private ModelList m_lBooleanExpressions = new ModelList(this, new String[]{"Object:BooleanExpressionAdded", "Object:BooleanExpressionRemoved"}, 0, IBooleanExpression.class);
    private List m_lIncompleteBooleanExpressionPositions;
    private IUserWrittenCodeContainer m_userWrittenContainer;
    private boolean m_bUseSQLSyntax;
    private boolean m_bAnyLogicalOperatorFirst;

    public AbstractBooleanExpressionContainer(String sID, IModel model) {
        super(sID, model);
        this.m_userWrittenContainer = model.getObjectFactory().createUserWrittenHelper(this);
        this.m_userWrittenContainer.setContainerOMRType(this.getOMRType());
        this.m_userWrittenContainer.setContainerId(sID);
        this.m_userWrittenContainer.setActiveEventName("Object:UserWrittenIndicatorChanged");
        this.m_userWrittenContainer.setCodeChangeEventName("Object:UserWrittenCodeChanged");
        this.m_userWrittenContainer.setActiveFlagLocation(2);
        this.m_lIncompleteBooleanExpressionPositions = new ArrayList();
        this.m_bUseSQLSyntax = false;
        this.m_bAnyLogicalOperatorFirst = false;
    }

    @Override
    public List getBooleanExpressionsList() {
        return this.m_lBooleanExpressions;
    }

    @Override
    public IBooleanExpression[] getBooleanExpressions() {
        return (IBooleanExpression[])this.m_lBooleanExpressions.toArray(new IBooleanExpression[this.m_lBooleanExpressions.size()]);
    }

    @Override
    public ISubquery[] getSubqueries() {
        List lSubqueries = this.getSubqueryList();
        return lSubqueries.toArray(new ISubquery[lSubqueries.size()]);
    }

    @Override
    public List getSubqueryList() {
        ArrayList<IExpression> lSubqueries = new ArrayList<IExpression>();
        IBooleanExpression[] alExpression = this.getBooleanExpressions();
        for (int i = 0; i < this.size(); ++i) {
            IExpression rightOperand;
            IBooleanExpression expression = alExpression[i];
            IExpression leftOperand = expression.getLeftOperand();
            if (leftOperand != null && leftOperand.getExpressionType().equalsIgnoreCase("SubQueryOperand")) {
                lSubqueries.add(leftOperand);
            }
            if ((rightOperand = expression.getRightOperand()) == null || !rightOperand.getExpressionType().equalsIgnoreCase("SubQueryOperand")) continue;
            lSubqueries.add(rightOperand);
        }
        return lSubqueries;
    }

    @Override
    public List getSubquerySourceTables() {
        ISubquery[] subqueries;
        ArrayList tables = new ArrayList();
        for (ISubquery subquery : subqueries = this.getSubqueries()) {
            tables.addAll(subquery.getAllSourceTables());
        }
        return tables;
    }

    @Override
    public void removeTableFromSubqueries(ITable table) {
        ISubquery[] subqueries;
        for (ISubquery query : subqueries = this.getSubqueries()) {
            ISourceTable[] sources;
            for (ISourceTable source : sources = query.findInAllQuerySourceTables(table)) {
                query.removeQuerySourceTable(source);
            }
        }
    }

    @Override
    public void setTransformModel(ISQLTransform transformModel) {
        IBooleanExpression[] expressions = this.getBooleanExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            IBooleanExpression expression = expressions[i];
            if (expression.getLeftOperand() instanceof IQuery && ((IQuery)((Object)expression.getLeftOperand())).getTransformModel() == null) {
                ((IQuery)((Object)expression.getLeftOperand())).setTransformModel(transformModel);
            }
            if (!(expression.getRightOperand() instanceof IQuery) || ((IQuery)((Object)expression.getRightOperand())).getTransformModel() != null) continue;
            ((IQuery)((Object)expression.getRightOperand())).setTransformModel(transformModel);
        }
    }

    @Override
    public Integer[] getIncompleteExpressionPositions() {
        if (this.m_lIncompleteBooleanExpressionPositions == null) {
            return new Integer[0];
        }
        return this.m_lIncompleteBooleanExpressionPositions.toArray(new Integer[this.m_lIncompleteBooleanExpressionPositions.size()]);
    }

    @Override
    public boolean isUseSQLSyntax() {
        return this.m_bUseSQLSyntax;
    }

    @Override
    public void setUseSQLSyntax(boolean useSQLSyntax) {
        if (this.m_bUseSQLSyntax == useSQLSyntax) {
            return;
        }
        this.m_bUseSQLSyntax = useSQLSyntax;
        this.updateSQLSyntax();
    }

    private void updateSQLSyntax() {
        IBooleanExpression[] expressions = this.getBooleanExpressions();
        boolean useSQLSyntax = this.isUseSQLSyntax();
        for (int i = 0; i < expressions.length; ++i) {
            expressions[i].setUseSQLSyntax(useSQLSyntax);
        }
    }

    @Override
    public void setAnyLogicalOperatorFirst(boolean b) {
        this.m_bAnyLogicalOperatorFirst = b;
    }

    @Override
    public boolean isAnyLogicalOperatorFirst() {
        return this.m_bAnyLogicalOperatorFirst;
    }

    @Override
    public void notify(NotifyEvent ev) {
        IObject object = (IObject)ev.getSource();
        int iType = ev.getType();
        if (object instanceof IBooleanExpression && iType == 1) {
            this.fireModelChangedEvent("Object:BooleanExpressionChanged", ev.getSource());
        } else {
            super.notify(ev);
        }
    }

    @Override
    public IUserWrittenCodeContainer getUserWrittenCode() {
        return this.m_userWrittenContainer;
    }

    @Override
    public boolean isUsingUserWrittenCode() {
        return this.m_userWrittenContainer.isActive();
    }

    @Override
    public void setUserWrittenExpression(String expression) {
        this.m_userWrittenContainer.setUserWrittenCode(expression);
    }

    @Override
    public void setUserWrittenCode(ICodeSource code) {
        this.m_userWrittenContainer.setUserWrittenSourceCode(code);
    }

    @Override
    public void setUseUserWrittenCode(boolean bUseUserWrittenCode) {
        this.startCompoundUndoable();
        try {
            this.m_userWrittenContainer.setIsActive(bUseUserWrittenCode);
            if (bUseUserWrittenCode) {
                try {
                    this.m_userWrittenContainer.setUserWrittenCode(this.getText(null, false, false));
                }
                catch (RemoteException e) {
                    ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
                }
                catch (CodegenException e) {
                    ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
                }
                catch (MdException e) {
                    ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
                }
                catch (BadServerDefinitionException e) {
                    ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
                }
                catch (BadLibraryDefinitionException e) {
                    ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
                }
                catch (ServerException e) {
                    ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.hasBooleanExpressionChanged() || this.m_userWrittenContainer.isChanged();
    }

    private boolean hasBooleanExpressionChanged() {
        for (int index = 0; index < this.m_lBooleanExpressions.size(); ++index) {
            IBooleanExpression expression = (IBooleanExpression)this.m_lBooleanExpressions.get(index);
            if (!expression.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplete() {
        if (this.isUsingUserWrittenCode() && !this.m_userWrittenContainer.isComplete()) {
            return false;
        }
        if (!this.isUsingUserWrittenCode()) {
            if (this.m_lBooleanExpressions.size() == 0) {
                return false;
            }
            this.m_lIncompleteBooleanExpressionPositions = new ArrayList();
            for (int iObject = 0; iObject < this.m_lBooleanExpressions.size(); ++iObject) {
                IBooleanExpression expression = (IBooleanExpression)this.m_lBooleanExpressions.get(iObject);
                if (iObject == 0) {
                    String logicalOperator = expression.getLogicalOperator();
                    if (!logicalOperator.equalsIgnoreCase("")) {
                        if ((logicalOperator.equalsIgnoreCase("not") || this.m_bAnyLogicalOperatorFirst) && expression.isComplete()) continue;
                        this.m_lIncompleteBooleanExpressionPositions.add(new Integer(iObject));
                        continue;
                    }
                    if (expression.isComplete()) continue;
                    this.m_lIncompleteBooleanExpressionPositions.add(new Integer(iObject));
                    continue;
                }
                if (expression.isComplete()) continue;
                this.m_lIncompleteBooleanExpressionPositions.add(new Integer(iObject));
            }
            if (this.m_lIncompleteBooleanExpressionPositions.size() > 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (this.isUsingUserWrittenCode() && !this.m_userWrittenContainer.isComplete()) {
            reasons.addAll(this.m_userWrittenContainer.getReasonsIncomplete());
        } else if (!this.isUsingUserWrittenCode()) {
            if (this.m_lBooleanExpressions.size() == 0) {
                reasons.add(RB.getStringResource("AbstractBooleanExpressionContainer.ReasonsIncomplete.MissingExpr.txt"));
            }
            if (!this.m_lIncompleteBooleanExpressionPositions.isEmpty()) {
                reasons.add(RB.getStringResource("AbstractBooleanExpressionContainer.ReasonsIncomplete.InvalidExpr.txt"));
            }
            this.m_lIncompleteBooleanExpressionPositions = new ArrayList();
            for (int iObject = 0; iObject < this.m_lBooleanExpressions.size(); ++iObject) {
                IBooleanExpression expression = (IBooleanExpression)this.m_lBooleanExpressions.get(iObject);
                reasons.addAll(expression.getReasonsIncomplete());
            }
        }
        return reasons;
    }

    @Override
    public IBooleanExpression createNewBooleanExpression() {
        return this.getModel().getObjectFactory().createNewBooleanExpression(this.getID());
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        IBooleanExpression[] aExpressions = this.getBooleanExpressions();
        for (int index = 0; index < aExpressions.length; ++index) {
            boolean bContainsColumn = aExpressions[index].containsRememberedColumn(column);
            if (!bContainsColumn) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTableColumns(ITable oldTable, ITable newTable) {
        this.startCompoundUndoable();
        try {
            IColumn[] oldColumns = oldTable.getColumns();
            IColumn[] newColumns = null;
            if (newTable != null) {
                newColumns = newTable.getColumns();
            }
            for (int i = 0; i < oldColumns.length; ++i) {
                boolean isFound = false;
                IColumn oldColumn = oldColumns[i];
                IColumn newColumn = null;
                if (newColumns == null) {
                    this.replaceColumn(oldColumn, newColumn);
                    continue;
                }
                for (int j = 0; j < newColumns.length; ++j) {
                    newColumn = newColumns[j];
                    if (!newColumn.getColumnName(true).equals(oldColumn.getColumnName(true))) continue;
                    isFound = true;
                    this.replaceColumn(oldColumn, newColumn);
                    break;
                }
                if (isFound) continue;
                this.replaceColumn(oldColumn, null);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceColumn(IColumn oldColumn, IColumn newColumn) {
        this.startCompoundUndoable();
        try {
            IBooleanExpression[] aExpressions = this.getBooleanExpressions();
            for (int index = 0; index < aExpressions.length; ++index) {
                aExpressions[index].replaceColumn(oldColumn, newColumn);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public String getOMRType() {
        return "ClassifierMap";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdo = (ClassifierMap)omr.acquireOMRObject(this);
        this.m_userWrittenContainer.setContainer((AbstractTransformation)mdo);
        this.m_userWrittenContainer.setContainerRole(this.getRole());
        this.m_userWrittenContainer.saveToOMR(omr);
        AssociationList lFeatureMaps = mdo.getFeatureMaps(false);
        lFeatureMaps.clear();
        for (int i = 0; i < this.m_lBooleanExpressions.size(); ++i) {
            IBooleanExpression expr = (IBooleanExpression)this.m_lBooleanExpressions.get(i);
            expr.saveToOMR(omr);
            FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(expr);
            lFeatureMaps.add(mdoFM);
        }
        this.saveBooleanOptionToOMR(omr, "IS_ANY_LOGICAL_OPERATOR_FIRST", this.m_bAnyLogicalOperatorFirst);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.m_lBooleanExpressions.clear();
        ClassifierMap mdo = (ClassifierMap)omr.acquireOMRObject(this);
        this.m_userWrittenContainer.setContainer((AbstractTransformation)mdo);
        this.m_userWrittenContainer.setContainerRole(this.getRole());
        this.m_userWrittenContainer.loadFromOMR(omr);
        AssociationList lFeatureMaps = mdo.getFeatureMaps();
        for (int i = 0; i < lFeatureMaps.size(); ++i) {
            FeatureMap mdoFM = (FeatureMap)lFeatureMaps.get(i);
            IBooleanExpression expr = this.createBooleanExpression(omr, mdoFM);
            expr.addNotifyListener(this);
            this.m_lBooleanExpressions.add(expr);
        }
        this.updateSQLSyntax();
        this.setAnyLogicalOperatorFirst(this.loadBooleanOptionFromOMR(omr, "IS_ANY_LOGICAL_OPERATOR_FIRST", false));
        this.setChanged(false);
    }

    protected IBooleanExpression createBooleanExpression(OMRAdapter omr, FeatureMap mdo) throws MdException, RemoteException {
        String sID = mdo.getFQID();
        IBooleanExpression object = (IBooleanExpression)this.getModel().getObject(sID);
        if (object != null) {
            return object;
        }
        object = this.getModel().getObjectFactory().createBooleanExpression(sID);
        object.loadFromOMR(omr);
        return object;
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        IBooleanExpression[] alExpressions = this.getBooleanExpressions();
        for (int i = 0; i < alExpressions.length; ++i) {
            alExpressions[i].deleteFromOMR(omr);
        }
        this.m_userWrittenContainer.deleteFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        for (int index = 0; index < this.m_lBooleanExpressions.size(); ++index) {
            ((IBooleanExpression)this.m_lBooleanExpressions.get(index)).updateIDs(mapIDs);
        }
        this.m_userWrittenContainer.updateIds(mapIDs);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("FeatureMaps");
        lAssociations.add("SourceCode");
        map.put(this.getOMRType(), lAssociations);
        return map;
    }

    @Override
    public void addBooleanExpression(IBooleanExpression expression) {
        this.addBooleanExpression(this.m_lBooleanExpressions.size(), expression);
    }

    @Override
    public void addBooleanExpression(int index, IBooleanExpression expression) {
        expression.addNotifyListener(this);
        expression.setUseSQLSyntax(this.isUseSQLSyntax());
        this.m_lBooleanExpressions.add(index, expression);
    }

    @Override
    public void removeBooleanExpression(IBooleanExpression expression) {
        expression.removeNotifyListener(this);
        this.m_lBooleanExpressions.remove(expression);
    }

    @Override
    public int indexOfExpression(IBooleanExpression expression) {
        return this.m_lBooleanExpressions.indexOf(expression);
    }

    @Override
    public boolean containsExpression(IBooleanExpression expression) {
        return this.m_lBooleanExpressions.contains(expression);
    }

    @Override
    public int size() {
        return this.m_lBooleanExpressions.size();
    }

    @Override
    public void autoCorrectFirstExpressionsLogicalOperator() {
        if (!this.m_lBooleanExpressions.isEmpty()) {
            IBooleanExpression expr = (IBooleanExpression)this.m_lBooleanExpressions.get(0);
            String sLogicalOperator = expr.getLogicalOperator();
            if (sLogicalOperator.equalsIgnoreCase("and not") || sLogicalOperator.equalsIgnoreCase("or not")) {
                expr.setLogicalOperator("not");
            } else {
                expr.setLogicalOperator("");
            }
        }
    }
}

