/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.IReflectiveObject;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OMRAdapter {
    private IModel m_model;
    private MdFactory m_factory;
    private MdObjectStore m_store;
    private Map m_mapNewIDs;
    private boolean m_saveToServer;

    public OMRAdapter(IModel model, MdFactory factory, String sDebugName) throws RemoteException {
        this.m_model = model;
        this.setOMRFactory(factory);
        this.setOMRStore(this.m_factory.createObjectStore(null, "OMRAdapter:" + sDebugName));
        this.m_mapNewIDs = new HashMap();
        this.setSaveToServer(true);
    }

    protected void setSaveToServer(boolean saveToServer) {
        this.m_saveToServer = saveToServer;
    }

    protected boolean isSaveToServer() {
        return this.m_saveToServer;
    }

    public IModel getModel() {
        return this.m_model;
    }

    public void setOMRStore(MdObjectStore store) {
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        this.m_store = store;
    }

    public void setOMRFactory(MdFactory factory) {
        this.m_factory = factory;
    }

    public MdFactory getOMRFactory() {
        return this.m_factory;
    }

    public MdObjectStore getOMRStore() {
        return this.m_store;
    }

    public void populateFor(IOMRPersistable obj) throws MdException, RemoteException {
        Root mdo = (Root)this.m_factory.createComplexMetadataObject(this.m_store, "", obj.getOMRType(), obj.getID());
        String sTemplate = this.convertAssociationMapToTemplates(obj.getOMRLoadTemplateMap());
        int fFlags = 524620;
        this.m_factory.getOMIUtil().getMetadataAllDepths((CMetadata)mdo, null, null, sTemplate, fFlags);
    }

    void populateFor(Root mdo) throws MdException, RemoteException {
        String sTemplate = this.m_model.getObjectFactory().getLoadFromOMRTemplate();
        int fFlags = 524620;
        this.m_factory.getOMIUtil().getMetadataAllDepths((CMetadata)mdo, null, null, sTemplate, fFlags);
    }

    public IOMRPersistable getObject(Root mdo) throws MdException, RemoteException {
        return (IPersistableObject)this.m_model.getObject(mdo.getFQID());
    }

    public IOMRPersistable createObjectFromOMRObject(Root mdo) throws MdException, RemoteException {
        return (IOMRPersistable)((Object)this.m_model.getObjectFactory().createObjectFromOMRObject(mdo));
    }

    public IOMRPersistable acquireObject(Root mdo) throws MdException, RemoteException {
        IOMRPersistable obj = (IPersistableObject)this.m_model.getObject(mdo.getFQID());
        if (obj != null) {
            return obj;
        }
        obj = (IOMRPersistable)((Object)this.m_model.getObjectFactory().createObjectFromOMRObject(mdo));
        obj.loadFromOMR(this);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOMRPersistable acquireObjectUsingTemplate(Root mdo) throws MdException, RemoteException {
        IOMRPersistable obj = (IPersistableObject)this.m_model.getObject(mdo.getFQID());
        if (obj != null) {
            return obj;
        }
        if (mdo.getObjectStore() != this.m_store) {
            ModelLogger.getDefaultLogger().debug((Object)"Error in usage:metadata object passed in is not in adapter's store.");
            mdo = this.acquireOMRObject(mdo.getFQID(), mdo.getCMetadataType());
        }
        this.populateFor(mdo);
        obj = (IOMRPersistable)((Object)this.m_model.getObjectFactory().createObjectFromOMRObject(mdo));
        boolean bUndo = this.m_model.isUndoSupported();
        this.m_model.setUndoSupported(false);
        try {
            obj.loadFromOMR(this);
        }
        finally {
            this.m_model.setUndoSupported(bUndo);
        }
        return obj;
    }

    public Root acquireOMRObject(IOMRPersistable obj) throws RemoteException {
        Root mdo;
        if (obj instanceof IReflectiveObject) {
            obj = ((IReflectiveObject)obj).getOMRObject();
        }
        if ((mdo = (Root)this.m_store.getObject(obj.getID())) != null) {
            return mdo;
        }
        return this.acquireOMRObject(obj.getID(), obj.getOMRType());
    }

    public Root acquireOMRObject(String sFQID, String sType) throws RemoteException {
        return (Root)this.m_factory.createComplexMetadataObject(this.m_store, "", sType, sFQID);
    }

    public void deleteOMRObject(String sFQID, String sType) throws RemoteException {
        CMetadata mdo = this.m_factory.createComplexMetadataObject(this.m_store, "", sType, sFQID);
        this.m_store.deleteObject(mdo);
    }

    private String convertAssociationMapToTemplates(Map mapTemplate) {
        if (mapTemplate == null) {
            return "";
        }
        StringBuffer sbTemplates = new StringBuffer("<Templates>");
        for (String sType : mapTemplate.keySet()) {
            sbTemplates.append("<");
            sbTemplates.append(sType);
            sbTemplates.append(">");
            List lAssociations = (List)mapTemplate.get(sType);
            for (int iAssociation = 0; iAssociation < lAssociations.size(); ++iAssociation) {
                String sAssociation = (String)lAssociations.get(iAssociation);
                sbTemplates.append("<");
                sbTemplates.append(sAssociation);
                sbTemplates.append("/>");
            }
            sbTemplates.append("</");
            sbTemplates.append(sType);
            sbTemplates.append(">");
        }
        sbTemplates.append("</Templates>");
        return sbTemplates.toString();
    }

    public void dispose() {
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            this.m_store = null;
        }
        if (this.m_factory != null) {
            this.m_factory = null;
        }
    }

    public void save() throws MdException, RemoteException {
        Root mdo;
        int iNewObject;
        List lNewObjects = this.m_store.getNewObjects();
        String[] saNewObjectIDs = new String[lNewObjects.size()];
        for (iNewObject = 0; iNewObject < lNewObjects.size(); ++iNewObject) {
            mdo = (Root)lNewObjects.get(iNewObject);
            saNewObjectIDs[iNewObject] = mdo.getFQID();
        }
        if (this.isSaveToServer()) {
            this.m_store.updatedMetadataAll();
        }
        this.m_mapNewIDs.clear();
        for (iNewObject = 0; iNewObject < lNewObjects.size(); ++iNewObject) {
            mdo = (Root)lNewObjects.get(iNewObject);
            this.m_mapNewIDs.put(saNewObjectIDs[iNewObject], mdo.getFQID());
        }
        this.m_model.updateIDs(this.m_mapNewIDs);
    }

    public Map getNewObjectIDsMap() {
        return this.m_mapNewIDs;
    }
}

