/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.impl;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.undo.AbstractUndoableEdit;

public class ModelList
implements List {
    public static final int SAVE_BY_OWNER = 0;
    public static final int SAVE_REFERENCES_ONLY = 1;
    public static final int SAVE_CHANGED_OBJECTS = 2;
    public static final int SAVE_AS_OWNER_OF_OBJECTS = 3;
    private List m_lObjects;
    private AbstractPersistableObject m_owner;
    private boolean m_bDeleteRemovedObjects;
    private boolean m_bSaveChangedObjects;
    private boolean m_bEventsEnabled;
    private boolean m_bNotifyOwner;
    private Class[] m_aAllowedTypes;
    private String[] m_aEventIDs;
    private String m_sName;
    private IFilter m_filterDelete;
    private IFilter m_filterAdd;
    private IFilter m_filterAssociationItem;
    private boolean m_bInUndoOrRedo;
    private boolean m_bInLoadFromOMR;

    public ModelList(AbstractPersistableObject owner, String[] aEventIDs) {
        this(owner, aEventIDs, 0);
    }

    public ModelList(AbstractPersistableObject owner, String[] aEventIDs, int ePersistenceType) {
        if (aEventIDs.length < 2 && 3 < aEventIDs.length) {
            throw new IllegalArgumentException("event ids must have two or three ids");
        }
        this.m_owner = owner;
        this.m_bSaveChangedObjects = ePersistenceType >= 2;
        this.m_bDeleteRemovedObjects = ePersistenceType == 3;
        this.m_bEventsEnabled = true;
        this.m_aEventIDs = aEventIDs;
        this.m_lObjects = new ArrayList();
        this.m_filterAdd = new DefaultAddFilter();
        this.m_filterDelete = new DefaultDeleteFilter();
    }

    public ModelList(AbstractPersistableObject owner, String[] aEventIDs, int ePersistenceType, Class clsAllowedType) {
        this(owner, aEventIDs, ePersistenceType);
        this.setAllowedTypes(new Class[]{clsAllowedType});
    }

    public void setAllowedTypes(Class[] aAllowedTypes) {
        if (aAllowedTypes != null) {
            for (int iType = 0; iType < aAllowedTypes.length; ++iType) {
                if (IObject.class.isAssignableFrom(aAllowedTypes[iType])) continue;
                throw new IllegalArgumentException("class of contained objects must implement IObject: " + aAllowedTypes[iType].getName());
            }
        }
        this.m_aAllowedTypes = aAllowedTypes;
    }

    public Class[] getAllowedTypes() {
        return this.m_aAllowedTypes;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setDeleteFilter(IFilter filter) {
        if (filter == null) {
            throw new NullPointerException("DeleteFilter cannot be null!");
        }
        this.m_filterDelete = filter;
    }

    public IFilter getDeleteFilter() {
        return this.m_filterDelete;
    }

    public void setAddFilter(IFilter filter) {
        if (filter == null) {
            throw new NullPointerException("AddFilter cannot be null!");
        }
        this.m_filterAdd = filter;
    }

    public IFilter getAddFilter() {
        return this.m_filterAdd;
    }

    public void setAssociationItemFilter(IFilter filter) {
        this.m_filterAssociationItem = filter;
    }

    public IFilter getAssociationItemFilter() {
        return this.m_filterAssociationItem;
    }

    public void setEventsEnabled(boolean bEventsEnabled) {
        this.m_bEventsEnabled = bEventsEnabled;
    }

    public boolean areEventEnabled() {
        return this.m_bEventsEnabled;
    }

    public void setOwnerNotified(boolean bNotifyOwner) {
        this.m_bNotifyOwner = bNotifyOwner;
    }

    public boolean isOwnerNotified() {
        return this.m_bNotifyOwner;
    }

    public void move(Object obj, int iTo) {
        int iFrom = this.m_lObjects.indexOf(obj);
        if (iFrom == -1) {
            throw new IllegalArgumentException("Object not found in list");
        }
        if (iFrom == iTo) {
            return;
        }
        this.m_lObjects.remove(iFrom);
        this.m_lObjects.add(iTo, obj);
        if (this.m_bEventsEnabled) {
            if (this.m_aEventIDs.length >= 3) {
                this.m_owner.fireModelChangedEvent(this.m_aEventIDs[2], obj);
            } else {
                this.m_owner.fireModelChangedEvent(this.m_aEventIDs[1], obj);
                this.m_owner.fireModelChangedEvent(this.m_aEventIDs[0], obj);
            }
        }
        if (this.m_owner.isUndoSupported()) {
            this.m_owner.undoableEditHappened(new MoveUndoable(obj, iFrom, iTo));
        }
    }

    @Override
    public int size() {
        return this.m_lObjects.size();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator e1 = this.m_lObjects.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public int hashcode() {
        return super.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.m_lObjects.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.m_lObjects.contains(obj);
    }

    @Override
    public int indexOf(Object obj) {
        return this.m_lObjects.indexOf(obj);
    }

    @Override
    public Iterator iterator() {
        return this.m_lObjects.iterator();
    }

    public ListIterator listIterator() {
        return this.m_lObjects.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.m_lObjects.listIterator(index);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.m_lObjects.containsAll(collection);
    }

    protected AbstractPersistableObject getOwner() {
        return this.m_owner;
    }

    public Object get(int iObject) {
        return this.m_lObjects.get(iObject);
    }

    @Override
    public Object[] toArray() {
        return this.m_lObjects.toArray();
    }

    @Override
    public Object[] toArray(Object[] aObjects) {
        return this.m_lObjects.toArray(aObjects);
    }

    @Override
    public boolean add(Object obj) {
        this.add(this.m_lObjects.size(), obj);
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        int iObject = this.indexOf(obj);
        if (iObject == -1) {
            return false;
        }
        this.remove(iObject);
        return true;
    }

    public void add(int iObj, Object obj) {
        if (obj == null) {
            throw new NullPointerException("null can not be added to a model list");
        }
        if (!this.m_bInLoadFromOMR && this.m_lObjects.contains(obj)) {
            throw new IllegalArgumentException("object is already in model list: " + obj);
        }
        if (!this.m_filterAdd.pass(obj)) {
            throw new IllegalArgumentException("object does not pass the add filter");
        }
        this.addImpl(iObj, obj);
    }

    protected void addImpl(int iObj, Object obj) {
        this.m_owner.startCompoundUndoable();
        try {
            if (!this.m_bInUndoOrRedo) {
                this.preAdd(iObj, obj);
            }
            if (this.m_filterDelete.pass(obj)) {
                this.m_owner.removeFromDeletedObjects((IPersistableObject)obj);
            }
            this.m_lObjects.add(iObj, obj);
            if (this.m_bNotifyOwner && obj instanceof IPersistableObject) {
                ((IPersistableObject)obj).addNotifyListener(this.m_owner);
            }
            if (this.m_bEventsEnabled) {
                this.m_owner.fireModelChangedEvent(this.m_aEventIDs[0], obj);
            }
            if (this.m_owner.isUndoSupported()) {
                this.m_owner.undoableEditHappened(new AddUndoable(iObj, obj));
            }
            if (!this.m_bInUndoOrRedo) {
                this.postAdd(iObj, obj);
            }
        }
        finally {
            this.m_owner.endCompoundUndoable();
        }
    }

    protected void preAdd(Object obj) {
    }

    protected void preAdd(int iObj, Object obj) {
        this.preAdd(obj);
    }

    protected void preLoad(Object obj) {
    }

    protected void postLoad(OMRAdapter omr, Object obj) throws MdException, RemoteException {
    }

    protected void postAdd(Object obj) {
    }

    protected void postAdd(int iObj, Object obj) {
        this.postAdd(obj);
    }

    public Object remove(int iObject) {
        return this.removeImpl(iObject);
    }

    protected void preRemove(Object obj) {
    }

    protected void preRemove(int iObj, Object obj) {
        this.preRemove(obj);
    }

    protected void postRemove(Object obj) {
    }

    protected Object removeImpl(int iObject) {
        IObject object = (IObject)this.m_lObjects.get(iObject);
        this.m_owner.startCompoundUndoable();
        try {
            if (!this.m_bInUndoOrRedo) {
                this.preRemove(object);
            }
            if (this.m_bNotifyOwner && object instanceof IPersistableObject) {
                ((IPersistableObject)object).removeNotifyListener(this.m_owner);
            }
            this.m_lObjects.remove(iObject);
            if (this.m_filterDelete.pass(object) && object instanceof IPersistableObject) {
                this.m_owner.addToDeletedObjects((IPersistableObject)object);
            }
            if (this.m_bEventsEnabled) {
                this.m_owner.fireModelChangedEvent(this.m_aEventIDs[1], object);
            }
            if (this.m_owner.isUndoSupported()) {
                this.m_owner.undoableEditHappened(new RemoveUndoable(iObject, object));
            }
            if (!this.m_bInUndoOrRedo) {
                this.postRemove(object);
            }
        }
        finally {
            this.m_owner.endCompoundUndoable();
        }
        return object;
    }

    @Override
    public void clear() {
        this.m_owner.startCompoundUndoable();
        try {
            while (!this.m_lObjects.isEmpty()) {
                this.remove(0);
            }
        }
        finally {
            this.m_owner.endCompoundUndoable();
        }
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("addAll is not supported");
    }

    public boolean addAll(int iObject, Collection collection) {
        throw new UnsupportedOperationException("addAll is not supported");
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("removeAll is not supported");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("retainAll is not supported");
    }

    public Object set(int iObject, Object obj) {
        throw new UnsupportedOperationException("set is not supported");
    }

    @Override
    public int lastIndexOf(Object obj) {
        throw new UnsupportedOperationException("lastIndexOf is not supported");
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList is not supported");
    }

    public String toString() {
        return this.m_lObjects.toString();
    }

    public boolean isChanged() {
        if (this.m_bSaveChangedObjects) {
            for (int iObject = 0; iObject < this.m_lObjects.size(); ++iObject) {
                IPersistableObject object = (IPersistableObject)this.m_lObjects.get(iObject);
                if (!object.isChanged()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasWarnings() {
        for (int iObject = 0; iObject < this.m_lObjects.size(); ++iObject) {
            IPersistableObject object = (IPersistableObject)this.m_lObjects.get(iObject);
            if (!object.hasWarnings()) continue;
            return true;
        }
        return false;
    }

    public List getWarnings() {
        ArrayList warnings = new ArrayList();
        for (int iObject = 0; iObject < this.m_lObjects.size(); ++iObject) {
            IPersistableObject object = (IPersistableObject)this.m_lObjects.get(iObject);
            warnings.addAll(object.getWarnings());
        }
        return warnings;
    }

    public boolean isComplete() {
        for (int iObject = 0; iObject < this.m_lObjects.size(); ++iObject) {
            IPersistableObject object = (IPersistableObject)this.m_lObjects.get(iObject);
            if (object.isComplete()) continue;
            return false;
        }
        return true;
    }

    public List getReasonsIncomplete() {
        ArrayList reasons = new ArrayList();
        for (int iObject = 0; iObject < this.m_lObjects.size(); ++iObject) {
            IPersistableObject object = (IPersistableObject)this.m_lObjects.get(iObject);
            reasons.addAll(object.getReasonsIncomplete());
        }
        return reasons;
    }

    public void saveToOMR(OMRAdapter omr, List lAssociation) throws MdException, RemoteException {
        if (this.m_filterAssociationItem == null) {
            lAssociation.clear();
        } else {
            for (int i = lAssociation.size() - 1; i >= 0; --i) {
                if (!this.m_filterAssociationItem.pass(lAssociation.get(i))) continue;
                lAssociation.remove(i);
            }
        }
        for (int iObject = 0; iObject < this.m_lObjects.size(); ++iObject) {
            IPersistableObject object = (IPersistableObject)this.m_lObjects.get(iObject);
            if (this.m_bSaveChangedObjects) {
                object.saveToOMR(omr);
            }
            Root mdoObject = omr.acquireOMRObject(object);
            lAssociation.add(mdoObject);
        }
    }

    protected IPersistableObject createObjectFromOMRObject(OMRAdapter omr, Root mdoObject) throws MdException, RemoteException {
        return (IPersistableObject)omr.createObjectFromOMRObject(mdoObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromOMR(OMRAdapter omr, List lAssociation) throws MdException, RemoteException {
        this.m_bInLoadFromOMR = true;
        try {
            ArrayList associationObjects = new ArrayList(lAssociation);
            if (this.m_filterAssociationItem != null) {
                for (int i = associationObjects.size() - 1; i >= 0; --i) {
                    if (this.m_filterAssociationItem.pass(associationObjects.get(i))) continue;
                    associationObjects.remove(i);
                }
            }
            int nObjects = associationObjects.size();
            ((ArrayList)this.m_lObjects).ensureCapacity(nObjects);
            for (int iObject = 0; iObject < nObjects; ++iObject) {
                long end;
                Root mdoObject = (Root)associationObjects.get(iObject);
                long start = System.currentTimeMillis();
                IPersistableObject object = (IPersistableObject)omr.getObject(mdoObject);
                if (object == null) {
                    object = this.createObjectFromOMRObject(omr, mdoObject);
                    this.preLoad(object);
                    object.loadFromOMR(omr);
                    this.postLoad(omr, object);
                }
                if ((end = System.currentTimeMillis()) - start > 1000L) {
                    ModelLogger.getDefaultLogger().debug((Object)(object.getName() + " " + object.getOMRType() + " loading time " + String.valueOf(end - start)));
                }
                if (iObject < this.m_lObjects.size() && this.m_lObjects.get(iObject) == object) continue;
                int iCurrent = this.nextIndexOf(iObject + 1, object);
                if (iCurrent == -1) {
                    this.add(iObject, object);
                    continue;
                }
                this.move(object, iObject);
            }
            while (nObjects < this.m_lObjects.size()) {
                this.remove(nObjects);
            }
        }
        finally {
            this.m_bInLoadFromOMR = false;
        }
    }

    private int nextIndexOf(int iStart, Object obj) {
        for (int iObject = iStart; iObject < this.m_lObjects.size(); ++iObject) {
            if (this.m_lObjects.get(iObject) != obj) continue;
            return iObject;
        }
        return -1;
    }

    public void delete() {
        if (!this.m_bDeleteRemovedObjects) {
            throw new UnsupportedOperationException("Delete a model list that is not the owner of the contained objects");
        }
        for (int iObject = 0; iObject < this.m_lObjects.size(); ++iObject) {
            IPersistableObject object = (IPersistableObject)this.m_lObjects.get(iObject);
            object.delete();
        }
    }

    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.m_bDeleteRemovedObjects) {
            throw new UnsupportedOperationException("Delete from OMR of a model list that is not the owner of the contained objects");
        }
        for (int iObject = 0; iObject < this.m_lObjects.size(); ++iObject) {
            IPersistableObject object = (IPersistableObject)this.m_lObjects.get(iObject);
            object.deleteFromOMR(omr);
        }
    }

    private class DefaultAddFilter
    implements IFilter {
        private DefaultAddFilter() {
        }

        @Override
        public boolean pass(Object obj) {
            if (ModelList.this.m_aAllowedTypes != null) {
                for (int iAllowedType = 0; iAllowedType < ModelList.this.m_aAllowedTypes.length; ++iAllowedType) {
                    if (!ModelList.this.m_aAllowedTypes[iAllowedType].isInstance(obj)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    private class DefaultDeleteFilter
    implements IFilter {
        private DefaultDeleteFilter() {
        }

        @Override
        public boolean pass(Object obj) {
            return ModelList.this.m_bDeleteRemovedObjects;
        }
    }

    private class MoveUndoable
    extends AbstractUndoableEdit {
        private Object m_object;
        private int m_iTo;
        private int m_iFrom;

        public MoveUndoable(Object object, int iFrom, int iTo) {
            this.m_object = object;
            this.m_iTo = iTo;
            this.m_iFrom = iFrom;
        }

        @Override
        public void undo() {
            super.undo();
            ModelList.this.move(this.m_object, this.m_iFrom);
        }

        @Override
        public void redo() {
            super.redo();
            ModelList.this.move(this.m_object, this.m_iTo);
        }

        @Override
        public void die() {
            this.m_object = null;
        }
    }

    private class AddUndoable
    extends AbstractUndoableEdit {
        private int m_iObject;
        private Object m_object;

        public AddUndoable(int iObject, Object object) {
            this.m_iObject = iObject;
            this.m_object = object;
        }

        @Override
        public void undo() {
            super.undo();
            ModelList.this.m_bInUndoOrRedo = true;
            try {
                if (ModelList.this.size() <= this.m_iObject) {
                    return;
                }
                ModelList.this.remove(this.m_iObject);
            }
            finally {
                ModelList.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void redo() {
            super.redo();
            ModelList.this.m_bInUndoOrRedo = true;
            try {
                ModelList.this.add(this.m_iObject, this.m_object);
            }
            finally {
                ModelList.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void die() {
            this.m_object = null;
        }
    }

    private class RemoveUndoable
    extends AbstractUndoableEdit {
        private int m_iObject;
        private Object m_object;

        public RemoveUndoable(int iObject, Object object) {
            this.m_iObject = iObject;
            this.m_object = object;
        }

        @Override
        public void undo() {
            super.undo();
            ModelList.this.m_bInUndoOrRedo = true;
            try {
                ModelList.this.add(this.m_iObject, this.m_object);
            }
            finally {
                ModelList.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void redo() {
            super.redo();
            ModelList.this.m_bInUndoOrRedo = true;
            try {
                ModelList.this.remove(this.m_iObject);
            }
            finally {
                ModelList.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void die() {
            this.m_object = null;
        }
    }
}

