/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.impl;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IDocument;
import com.sas.etl.models.data.IFolder;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.RB;
import com.sas.etl.models.other.IExtendedAttribute;
import com.sas.etl.models.other.INote;
import com.sas.etl.models.other.IResponsibleParty;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidResourceSpec;
import com.sas.meta.SASOMI.ISecurityPackage.NotTrustedUser;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.metadata.PathUrl;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractVersionedObjectManager;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.StringHolder;

public abstract class AbstractComplexPersistableObject
extends AbstractPersistableObject
implements IComplexPersistableObject {
    private ModelList m_lNotes = new ModelList(this, new String[]{"Object:NoteAdded", "Object:NoteRemoved"}, 2, INote.class);
    private ModelList m_lDocuments = new ModelList(this, new String[]{"Object:DocumentAdded", "Object:DocumentRemoved"}, 2, IDocument.class);
    private ModelList m_lExtendedAttributes = new ModelList(this, new String[]{"Object:ExtendedAttributeAdded", "Object:ExtendedAttributeRemoved"}, 3, IExtendedAttribute.class);
    private ModelList m_lResponsibleParties = new ModelList(this, new String[]{"Objecty:ResponsiblePartyAdded", "Objecty:ResponsiblePartyRemoved"}, 2, IResponsibleParty.class);
    private String m_sPrivateNote;
    private String m_sPrivateNoteID = "";
    private IFolder m_folder;
    private String m_sPreviousFolderID;
    private boolean m_bEditable = true;
    private UsageVersion m_usageVersion = UsageVersion.decode((double)0.0);

    public AbstractComplexPersistableObject(String sID, IModel model) {
        super(sID, model);
    }

    protected void setArchitectureVersionNumber(UsageVersion version) {
    }

    @Override
    public abstract UsageVersion getArchitectureVersionNumber();

    @Override
    public final UsageVersion getUsageVersion() {
        return this.m_usageVersion;
    }

    protected void setUsageVersion(UsageVersion version) {
        if (version == null) {
            return;
        }
        if (version.equals((Object)this.m_usageVersion)) {
            return;
        }
        this.m_usageVersion = version;
        this.fireModelChangedEvent("IComplexPersistableObject:UsageVersionChanged", this.m_usageVersion);
    }

    public String getMetadataType() {
        return this.getOMRType();
    }

    protected String getExternalIdentityType() {
        return "ExternalIdentity";
    }

    @Override
    public INote[] getNotes() {
        return (INote[])this.m_lNotes.toArray(new INote[this.m_lNotes.size()]);
    }

    @Override
    public List getNotesList() {
        return this.m_lNotes;
    }

    @Override
    public String getPrivateNote() {
        return this.m_sPrivateNote;
    }

    @Override
    public void setPrivateNote(String sPrivateNote) {
        if (this.m_sPrivateNote == null ? sPrivateNote == null : this.m_sPrivateNote.equals(sPrivateNote)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPrivateNoteUndoable(this.m_sPrivateNote, sPrivateNote));
        }
        this.m_sPrivateNote = sPrivateNote;
        this.fireModelChangedEvent("NotesContainer:PrivateNoteChanged", this.m_sPrivateNote);
    }

    @Override
    public IDocument[] getDocuments() {
        return (IDocument[])this.m_lDocuments.toArray(new IDocument[this.m_lDocuments.size()]);
    }

    @Override
    public List getDocumentsList() {
        return this.m_lDocuments;
    }

    @Override
    public IExtendedAttribute[] getExtendedAttributes() {
        return (IExtendedAttribute[])this.m_lExtendedAttributes.toArray(new IExtendedAttribute[this.m_lExtendedAttributes.size()]);
    }

    @Override
    public List getExtendedAttributesList() {
        return this.m_lExtendedAttributes;
    }

    @Override
    public IResponsibleParty[] getResponsibleParties() {
        return (IResponsibleParty[])this.m_lResponsibleParties.toArray(new IResponsibleParty[this.m_lResponsibleParties.size()]);
    }

    @Override
    public List getResponsiblePartiesList() {
        return this.m_lResponsibleParties;
    }

    @Override
    public void dumpObjectToXML(PrintStream stream) {
        stream.println("<" + this.getPublicType() + " name=\"" + this.getName() + "\" description=\"" + this.getDescription() + "\" >");
        this.dumpXML(stream);
        stream.println("</" + this.getPublicType() + ">");
    }

    protected void dumpXML(PrintStream stream) {
        stream.println("name=\"" + this.getName() + "\"");
    }

    @Override
    public String getSBIPUrl() throws MdException {
        return this.getSBIPUrl(true);
    }

    @Override
    public String getSBIPUrl(boolean showType) throws MdException {
        String url = "";
        IFolder folder = this.getFolder();
        if (folder != null) {
            PathUrl folderUrl = folder.getPathUrl();
            if (folderUrl == null) {
                throw new MdException(MessageFormat.format(RB.getStringResource("AbstractComplexPersistableObject.FolderUrlNotFound.fmt"), this.getName(), this.getMetadataType()));
            }
            url = !showType ? folderUrl.getDisplayPath() + '/' + this.getName() : folderUrl.getDisplayPath() + '/' + this.getName() + '(' + this.getPublicType() + ')';
        }
        return url;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_lNotes.isChanged() || this.m_lDocuments.isChanged() || this.m_lExtendedAttributes.isChanged() || this.m_lResponsibleParties.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        PrimaryType mdo = (PrimaryType)omr.acquireOMRObject(this);
        mdo.setPublicType(this.isPublicObject() ? this.getPublicType() : "");
        mdo.setUsageVersion(this.getArchitectureVersionNumber().encode());
        this.saveNotesAndDocumentsToOMR(omr, (Root)mdo);
        this.m_lExtendedAttributes.saveToOMR(omr, (List)mdo.getExtensions(false));
        this.m_lResponsibleParties.saveToOMR(omr, (List)mdo.getResponsibleParties(false));
        AssociationList lTrees = mdo.getTrees(false);
        if (this.m_folder != null && !this.m_folder.getID().equals(this.m_sPreviousFolderID)) {
            lTrees.add(omr.acquireOMRObject(this.m_folder));
            if (this.m_sPreviousFolderID != null) {
                lTrees.remove(omr.acquireOMRObject(this.m_sPreviousFolderID, "Tree"));
            }
        } else if (this.m_folder == null && this.m_sPreviousFolderID != null) {
            lTrees.remove(omr.acquireOMRObject(this.m_sPreviousFolderID, "Tree"));
        }
        this.setChanged(false);
    }

    private void saveNotesAndDocumentsToOMR(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        AssociationList lDocs = mdo.getDocuments(false);
        AssociationList lNotes = mdo.getNotes(false);
        lDocs.clear();
        if (this.m_sPrivateNote != null && this.m_sPrivateNote.length() > 0) {
            String sID = this.m_sPrivateNoteID.length() == 0 ? this.createIDForNewObject() : this.m_sPrivateNoteID;
            TextStore mdoText = (TextStore)omr.acquireOMRObject(sID, "TextStore");
            mdoText.setName("PrivateNote");
            mdoText.setStoredText(this.getPrivateNote());
            mdoText.setTextRole("Note");
            if (mdoText.isNewObject()) {
                lNotes.add(mdoText);
            }
        } else if (this.m_sPrivateNoteID.length() > 0) {
            omr.deleteOMRObject(this.m_sPrivateNoteID, "TextStore");
        }
        for (int iNote = 0; iNote < this.m_lNotes.size(); ++iNote) {
            INote oNote = (INote)this.m_lNotes.get(iNote);
            oNote.saveToOMR(omr);
            lDocs.add(omr.acquireOMRObject(oNote));
        }
        for (int iDoc = 0; iDoc < this.m_lDocuments.size(); ++iDoc) {
            IDocument oDoc = (IDocument)this.m_lDocuments.get(iDoc);
            oDoc.saveToOMR(omr);
            lDocs.add(omr.acquireOMRObject(oDoc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.m_sPreviousFolderID = this.m_folder != null ? this.m_folder.getID() : null;
        IResponsibleParty[] aOldRPs = this.getResponsibleParties();
        boolean bChanged = this.isChanged();
        boolean bUndoSupported = this.isUndoSupported();
        this.getModel().setUndoSupported(false);
        try {
            this.m_lResponsibleParties.clear();
            for (int iOldRP = 0; iOldRP < aOldRPs.length; ++iOldRP) {
                IResponsibleParty party = (IResponsibleParty)this.getModel().getObject(aOldRPs[iOldRP].getID());
                if (this.m_lResponsibleParties.contains(party)) continue;
                this.m_lResponsibleParties.add(party);
            }
        }
        finally {
            this.getModel().setUndoSupported(bUndoSupported);
            this.setChanged(bChanged);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Root mdo = omr.acquireOMRObject(this);
        this.loadEditableFromOMR(omr, mdo);
        this.loadNotesAndDocumentsFromOMR(omr, mdo);
        this.m_lExtendedAttributes.loadFromOMR(omr, (List)mdo.getExtensions());
        this.m_lResponsibleParties.loadFromOMR(omr, (List)mdo.getResponsibleParties());
        this.setArchitectureVersionNumber(UsageVersion.decode((double)mdo.getUsageVersion()));
        this.m_sPreviousFolderID = null;
        AssociationList lTrees = mdo.getTrees();
        for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
            Tree mdoTree = (Tree)lTrees.get(iTree);
            if (!"Folder".equals(mdoTree.getPublicType())) continue;
            this.setFolder((IFolder)omr.acquireObject((Root)mdoTree));
            this.m_sPreviousFolderID = this.m_folder.getID();
        }
        this.setUsageVersion(UsageVersion.decode((double)mdo.getUsageVersion()));
        this.setChanged(false);
    }

    private void loadNotesAndDocumentsFromOMR(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        AssociationList lDocs = mdo.getDocuments();
        AssociationList lNotes = mdo.getNotes();
        if (!lNotes.isEmpty()) {
            for (int t = 0; t < lNotes.size(); ++t) {
                TextStore oOurPossiblePrivateNote = (TextStore)lNotes.get(t);
                if (!oOurPossiblePrivateNote.getTextRole().equalsIgnoreCase("Note")) continue;
                TextStore mdoPrivateNote = (TextStore)lNotes.get(t);
                this.m_sPrivateNoteID = mdoPrivateNote.getFQID();
                this.setPrivateNote(mdoPrivateNote.getStoredText());
                break;
            }
        }
        this.m_lNotes.clear();
        this.m_lDocuments.clear();
        for (int iDoc = 0; iDoc < lDocs.size(); ++iDoc) {
            Document mdoDoc = (Document)lDocs.get(iDoc);
            if (mdoDoc.getPublicType().equals("Note")) {
                INote oNote = (INote)omr.acquireObject((Root)mdoDoc);
                this.m_lNotes.add(oNote);
                continue;
            }
            IDocument oDoc = (IDocument)omr.acquireObject((Root)mdoDoc);
            this.m_lDocuments.add(oDoc);
        }
    }

    protected boolean shouldLoadEditable() {
        return this.isPublicObject() && !this.isNew();
    }

    private void loadEditableFromOMR(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        if (!this.shouldLoadEditable()) {
            return;
        }
        try {
            if (mdo.getChangeState().startsWith("Checked")) {
                this.m_bEditable = false;
                return;
            }
            MdOMRConnection connection = Workspace.getMdFactory().getConnection();
            ISecurity_1_1 security = connection.MakeISecurityConnection(connection.getCMRHandle());
            String resource = "OMSOBJ:" + this.getOMRType() + "/" + this.getID();
            String permission = "WriteMetadata";
            StringHolder permissionCondition = new StringHolder();
            BooleanHolder authorized = new BooleanHolder();
            security.IsAuthorized("", resource, permission, permissionCondition, authorized);
            this.m_bEditable = authorized.value;
        }
        catch (NotTrustedUser ex) {
            ModelLogger.getDefaultLogger().error((Object)"isObjectEditable exception", (Throwable)ex);
        }
        catch (InvalidCredHandle ex) {
            ModelLogger.getDefaultLogger().error((Object)"isObjectEditable exception", (Throwable)ex);
        }
        catch (InvalidResourceSpec ex) {
            ModelLogger.getDefaultLogger().error((Object)"isObjectEditable exception", (Throwable)ex);
        }
        catch (GenericError ex) {
            ModelLogger.getDefaultLogger().error((Object)"isObjectEditable exception", (Throwable)ex);
        }
    }

    @Override
    public boolean isEditable() {
        return this.m_bEditable;
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        this.m_lExtendedAttributes.deleteFromOMR(omr);
        if (this.m_sPrivateNoteID.length() > 0) {
            omr.deleteOMRObject(this.m_sPrivateNoteID, "TextStore");
            this.m_sPrivateNoteID = "";
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("Trees");
        lAssociations.add("Documents");
        lAssociations.add("Notes");
        lAssociations.add("Extensions");
        lAssociations.add("ResponsibleParties");
        return map;
    }

    public boolean isPublicObject() {
        return true;
    }

    @Override
    public void setFolder(IFolder folder) {
        if (this.m_folder == folder) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFolderUndoable(this.m_folder, folder));
        }
        this.m_folder = folder;
        this.fireModelChangedEvent("IComplexPersistableObject:FolderChanged", this.m_folder);
    }

    @Override
    public IFolder getFolder() {
        return this.m_folder;
    }

    private boolean isValidVersion(WsAbstractVersionedObjectManager objInst) {
        boolean returnValue = true;
        if (objInst != null && !objInst.isVersionSupported(this.getPublicType(), this.getUsageVersion())) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.isValidVersion(WsAbstractVersionedObjectManager.getInstance());
    }

    @Override
    public List getReasonsIncomplete() {
        List lst = super.getReasonsIncomplete();
        if (!this.isValidVersion(WsAbstractVersionedObjectManager.getInstance())) {
            lst.add(MessageFormat.format(RB.getStringResource("AbstractComplexPersistableObject.VersionNotSupported.Message.txt"), this.getUsageVersion().toString(), this.getName()));
        }
        return lst;
    }

    private class SetPrivateNoteUndoable
    extends AbstractUndoableEdit {
        private String m_sOldPrivateNote;
        private String m_sNewPrivateNote;

        public SetPrivateNoteUndoable(String sOldPrivateNote, String sNewPrivateNote) {
            this.m_sOldPrivateNote = sOldPrivateNote;
            this.m_sNewPrivateNote = sNewPrivateNote;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractComplexPersistableObject.this.setPrivateNote(this.m_sOldPrivateNote);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractComplexPersistableObject.this.setPrivateNote(this.m_sNewPrivateNote);
        }
    }

    private class SetFolderUndoable
    extends AbstractUndoableEdit {
        private IFolder m_bOldFolder;
        private IFolder m_bNewFolder;

        public SetFolderUndoable(IFolder bOldFolder, IFolder bNewFolder) {
            this.m_bOldFolder = bOldFolder;
            this.m_bNewFolder = bNewFolder;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractComplexPersistableObject.this.setFolder(this.m_bOldFolder);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractComplexPersistableObject.this.setFolder(this.m_bNewFolder);
        }
    }
}

