/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.waitforcompletion.impl;

import com.sas.etl.models.data.waitforcompletion.IWaitForCompletion;
import com.sas.etl.models.data.waitforcompletion.IWaitForCompletionTable;
import com.sas.etl.models.data.waitforcompletion.IWaitForCompletionVersion;
import com.sas.etl.models.data.waitforcompletion.impl.BaseWaitForCompletionColumn;
import com.sas.etl.models.data.waitforcompletion.impl.BaseWaitForCompletionTable;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.publicobjects.decisionlogic.DLTarget;
import com.sas.publicobjects.decisionlogic.DSVariable;
import com.sas.publicobjects.decisionlogic.DecisionLogicInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BaseWaitForCompletionVersion
implements IWaitForCompletionVersion {
    private IWaitForCompletion _flow;
    private UsageVersion _version;
    private String _wfcCode;
    private List<IWaitForCompletionTable> m_outputTables;
    private IWaitForCompletionTable _inputTable;
    public boolean m_isLoaded;

    public BaseWaitForCompletionVersion(IWaitForCompletion flow) throws ServiceException, RemoteException {
        this._flow = flow;
        this.m_isLoaded = false;
        this._version = new UsageVersion(0, 0);
        this.m_outputTables = new ArrayList<IWaitForCompletionTable>();
    }

    private boolean isLoaded() {
        return this.m_isLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromOMR() throws RemoteException, ServiceException {
        if (this.isLoaded()) {
            return;
        }
        ChildServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer().newChild(true);
        try {
            Collection stats;
            String key = this._flow.getID() + "/" + "Transformation";
            DecisionLogicInterface flow = (DecisionLogicInterface)server.fetch(key, false);
            this.setWFCCode(flow.getCode(DLTarget.DI));
            Collection inputs = flow.getInputVariables();
            if (inputs != null) {
                BaseWaitForCompletionTable tab1 = new BaseWaitForCompletionTable(this, "SOURCE_TABLE", "INPUTTABLE");
                for (Object invar : inputs) {
                    BaseWaitForCompletionColumn column = new BaseWaitForCompletionColumn(tab1, invar.name());
                    column.setDataType(invar.type());
                    column.setDescription(invar.description());
                    column.setName(invar.name());
                    tab1.addColumn(column);
                }
                this._inputTable = tab1;
            }
            this.m_outputTables.clear();
            Collection outputs = flow.getOutputVariables();
            if (outputs != null) {
                BaseWaitForCompletionTable tab2 = new BaseWaitForCompletionTable(this, "RESULTS_TABLE", "WFC Results");
                for (DSVariable outvar : outputs) {
                    BaseWaitForCompletionColumn column = new BaseWaitForCompletionColumn(tab2, outvar.name());
                    column.setDataType(outvar.type());
                    column.setDescription(outvar.description());
                    column.setName(outvar.name());
                    tab2.addColumn(column);
                }
                this.m_outputTables.add(tab2);
            }
            if ((stats = flow.getStatsVariables()) != null) {
                BaseWaitForCompletionTable tab3 = new BaseWaitForCompletionTable(this, "STATS_TABLE", "WFC Stats");
                for (DSVariable statvar : stats) {
                    BaseWaitForCompletionColumn column = new BaseWaitForCompletionColumn(tab3, statvar.name());
                    column.setDataType(statvar.type());
                    column.setDescription(statvar.description());
                    column.setName(statvar.name());
                    column.setDisplayName(statvar.displayName());
                    tab3.addColumn(column);
                }
                this.m_outputTables.add(tab3);
            }
            this.m_isLoaded = true;
        }
        finally {
            if (server != null) {
                server.destroy();
            }
        }
    }

    @Override
    public UsageVersion getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(UsageVersion version) {
        this._version = version;
    }

    private String getVersionAsString() {
        return this._version != null ? this._version.toString() : null;
    }

    @Override
    public String getWFCCode() {
        return this._wfcCode;
    }

    @Override
    public void setWFCCode(String wfcCode) {
        this._wfcCode = wfcCode;
    }

    @Override
    public IWaitForCompletion getFlow() {
        return this._flow;
    }

    @Override
    public int compareTo(IWaitForCompletionVersion o) {
        return this.getVersion().compareTo((Object)o.getVersion());
    }

    public String toString() {
        return this.getVersion().toString();
    }

    @Override
    public IWaitForCompletionTable findOutputTable(String id) {
        for (IWaitForCompletionTable output : this.getOutputs()) {
            if (!ObjectComparator.isEqual(output.getID(), id)) continue;
            return output;
        }
        return null;
    }

    public void clearOutputs() {
        this.m_outputTables.clear();
    }

    @Override
    public IWaitForCompletionTable[] getOutputs() {
        return this.m_outputTables.toArray(new IWaitForCompletionTable[this.m_outputTables.size()]);
    }

    @Override
    public IWaitForCompletionTable getInput() {
        return this._inputTable;
    }
}

