/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.IDocument;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.DBMSTypeFactory;
import com.sas.etl.models.data.dbmstypes.HADOOPType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.SASHDATType;
import com.sas.etl.models.data.dbmstypes.SASIOIMPType;
import com.sas.etl.models.data.dbmstypes.TERADATAType;
import com.sas.etl.models.data.dbmstypes.XMLType;
import com.sas.etl.models.data.impl.AbstractTable;
import com.sas.etl.models.data.impl.BaseWorkTable;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.data.impl.RB;
import com.sas.etl.models.data.impl.TableUtil;
import com.sas.etl.models.data.impl.TransformTablePromptModelCollection;
import com.sas.etl.models.impl.AbstractPrimaryModelList;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IExtendedAttribute;
import com.sas.etl.models.other.INote;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModelCollection;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.OMRPhysicalTable;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.UsageVersion;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class BasePhysicalTable
extends AbstractTable
implements IPhysicalTable {
    private static final String REMOTE_MACRO_NAME = "etls_remoteMacro";
    protected static final String PROPERTY_SET_LOCATION = "Location";
    protected static final String OPTION_LOCATION_TYPE = "LOCATION_TYPE";
    private static final String PROPERTY_SET_ACCESS_WRITE = "ACCESS_WRITE";
    private static final String OPTION_COMPRESS = "COMPRESS";
    private static final String OPTION_ENCRYPT = "ENCRYPT";
    private static final String NO = "N";
    private static final String VALUE_YES = "YES";
    private static final String WEB_STREAM_SOURCE_PREFIX = "&_SOURCE_";
    private static final String WEB_STREAM_TARGET_PREFIX = "&_TARGET_";
    private ModelList m_lIndexes = new IndexesList();
    private ModelList m_lKeys = new KeysList();
    private ModelList m_lForeignKeys = new ForeignKeysList();
    private ILibrary m_library;
    private IDatabaseSchema m_databaseSchema;
    private String m_sSasTableName = "";
    private boolean m_bIsDBMSView;
    private boolean m_bIsCompressed;
    private boolean m_bIsEncrypted;
    private PhysicalTablePromptModelCollection m_optionModel;
    private List m_lstDeletedModels = new ArrayList();
    protected boolean m_bInLoad;
    private String m_sLocationType = this.getDefaultLocationType();
    public static final Pattern READ_PASSWORD_PATTERN = Pattern.compile("(?i)\\b(password|pw|read)\\s*=\\s*(\\\"[^\\\"]*\\\"|[^\\s*]*)");

    public BasePhysicalTable(String sID, IModel model) {
        super(sID, model);
        try {
            this.m_optionModel = this.getOptionModelForTable();
        }
        catch (FileNotFoundException e) {
            ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
    }

    protected String getDefaultLocationType() {
        return "Physical";
    }

    @Override
    public IDBMSType getDBMSType() {
        return this.getLibraryDBMSType();
    }

    private IDBMSType getLibraryDBMSType() {
        IDBMSType type = this.getLibraryDBMSType(this.getLibraryForUseInJob());
        if (this.isWebStreamDataSource(type) || this.isWebStreamDataTarget(type)) {
            type = new XMLType();
        }
        return type;
    }

    private IDBMSType getLibraryDBMSType(ILibrary library) {
        IDBMSType type = null;
        type = library == null ? DBMSTypeFactory.getDefaultType() : library.getDBMSType();
        return type;
    }

    @Override
    public String getDBMSProductName() throws BadLibraryDefinitionException {
        ILibrary library = this.getLibraryForUseInJob();
        if (library == null) {
            return null;
        }
        return library.getDBMSProductName();
    }

    @Override
    public void notify(NotifyEvent ev) {
        Object source = ev.getSource();
        ModelEvent mEvent = ev.getModelEvent();
        if (source instanceof ILibrary || source instanceof IIndex || source instanceof IColumn || source instanceof IForeignKey || source instanceof IKey) {
            String type;
            if (source instanceof ILibrary && mEvent != null && ("ILibrary:PropertyAdded".equals(type = mEvent.getType()) || "ILibrary:PropertyRemoved".equals(type))) {
                try {
                    this.updateTableOptionDefaults();
                }
                catch (FileNotFoundException e) {
                    ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
                }
                catch (RemoteException e) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
                }
                catch (ServerConnectionException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
                }
                catch (ServiceException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
                }
                catch (IOException e) {
                    ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
                }
                catch (SAXException e) {
                    ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
                }
                catch (MdException e) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
                }
            }
            this.fireNotifyEvent(1, ev.getModelEvent());
        } else {
            super.notify(ev);
        }
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection() {
        return this.m_optionModel;
    }

    protected PhysicalTablePromptModelCollection getOptionModelForTable() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModelCollection model = null;
        ILibrary lib = this.getLibraryForUseInJob();
        if (lib != null) {
            model = lib.getTableOptionCollection(this);
            model.swapValuesToDefaultValues();
        } else {
            IDBMSType dbms = this.getDBMSType();
            if (dbms != null) {
                model = dbms.getTableOptionCollectionInstance(this.getModel(), this);
            }
        }
        if (model != null) {
            model.setOwner(this);
            model.setTable(this);
            model.setShowTableOptions();
        }
        return model;
    }

    protected void updateTableOptionDefaults() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        ILibrary library = this.getLibraryForUseInJob();
        PhysicalTablePromptModelCollection model = this.getTableOptionCollection();
        if (model != null) {
            model.revertDefaults();
        }
        if (library != null && model != null) {
            IProperty[] options = library.getOptions();
            for (int i = 0; i < options.length; ++i) {
                IPromptDefinitionValue definition = model.findDefinition(options[i].getPropertyName());
                if (definition == null) continue;
                model.setDefaultValue(options[i].getPropertyName(), options[i].getDefaultValue());
                this.fireNotifyEvent(new NotifyEvent(this, 1, new ModelEvent(this.getModel(), this, "PhysicalTable:OptionDefaultChanged", definition, options[i].getDefaultValue())));
            }
        }
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollectionForTableOnly() {
        PhysicalTablePromptModelCollection model = this.getTableOptionCollection();
        model.setShowTableOptions();
        return model;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollectionForTransformTableOnly(ITransformTableOptions owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerException {
        PhysicalTablePromptModelCollection tableOptions = this.getTableOptionCollection();
        TransformTablePromptModelCollection model = new TransformTablePromptModelCollection(owner, tableOptions);
        model.setTable(this);
        return model;
    }

    @Override
    public void setTableOptionCollection(PhysicalTablePromptModelCollection modelCollection) {
        if (this.m_optionModel == modelCollection) {
            return;
        }
        if (this.m_optionModel != null && !this.m_lstDeletedModels.contains(this.m_optionModel)) {
            this.m_lstDeletedModels.add(this.m_optionModel);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new OptionCollectionUndoable(this.m_optionModel, modelCollection));
        }
        this.m_optionModel = modelCollection;
        if (this.m_lstDeletedModels.contains(this.m_optionModel)) {
            this.m_lstDeletedModels.remove(this.m_optionModel);
        }
        if (this.m_optionModel != null) {
            this.m_optionModel.setOwner(this);
            this.m_optionModel.setTable(this);
        }
        this.fireModelChangedEvent("PhysicalTable:OptionModelChanged", this.m_optionModel);
    }

    @Override
    public String getTableOptions() {
        return this.getTableOptions(false, null);
    }

    @Override
    public String getTableOptions(boolean parenthesis) {
        return this.getTableOptions(parenthesis, null);
    }

    @Override
    public String getTableOptions(boolean parenthesis, String optionRole) {
        return this.getTableOptions(parenthesis, optionRole, "");
    }

    @Override
    public String getTableOptions(boolean parenthesis, String optionRole, String additionalTableOptions) {
        StringBuffer options = new StringBuffer();
        try {
            PhysicalTablePromptModelCollection optionModel = this.getTableOptionCollection();
            options.append(optionModel.getOptionsString(null, optionRole).toString().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (additionalTableOptions != null && additionalTableOptions.length() > 0) {
            options.append(" " + additionalTableOptions);
        }
        if (options.length() > 0 && parenthesis) {
            options.insert(0, "(").append(")");
        }
        return options.toString().trim();
    }

    @Override
    public String getReadTableOptions() throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.getReadTableOptions(false);
    }

    @Override
    public String getReadTableOptions(boolean parenthesis) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String opts = "";
        PhysicalTablePromptModelCollection model = this.getTableOptionCollection();
        if (model != null) {
            opts = model.getReadTableOptionsString(parenthesis).toString().trim();
        }
        return opts;
    }

    @Override
    public String getWriteTableOptions() throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.getWriteTableOptions(false, null);
    }

    @Override
    public String getWriteTableOptions(boolean parenthesis, String additionalTableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String opts = "";
        PhysicalTablePromptModelCollection model = this.getTableOptionCollection();
        if (model != null) {
            opts = model.getWriteTableOptionsString(parenthesis, additionalTableOptions).toString().trim();
        }
        return opts;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_optionModel != null) {
            this.m_optionModel.dispose();
            this.m_optionModel = null;
        }
        IPromptModelCollection[] models = this.m_lstDeletedModels.toArray(new IPromptModelCollection[this.m_lstDeletedModels.size()]);
        for (int i = 0; i < models.length; ++i) {
            models[i].dispose();
        }
    }

    @Override
    public ICodeSegment genTableExist(ICodeSegment codeSegment) throws CodegenException, BadLibraryDefinitionException {
        return this.genTableExist(codeSegment, "etls_tableExist");
    }

    @Override
    public ICodeSegment genTableExist(ICodeSegment codeSegment, String macroName) throws CodegenException, BadLibraryDefinitionException {
        codeSegment.addCommentLine(RB.getStringResource("BasePhysicalTable.TableExist.msg.notrans"));
        codeSegment.genTableExist(this.getFullNameQuotedAsNeeded(codeSegment), null, macroName, false);
        return codeSegment;
    }

    @Override
    public IColumn[] getNotNullCols() {
        return this.getDBMSType().getNotNullCols(this);
    }

    @Override
    public IServer getServer(IServer defaultServer) throws BadLibraryDefinitionException, BadServerDefinitionException {
        ILibrary lib = this.getClientLibrary(defaultServer);
        if (lib != null) {
            return lib.getBestServer(defaultServer);
        }
        return defaultServer;
    }

    @Override
    public boolean isTableOnSameServer(IPhysicalTable table, IServer defaultServer) throws BadLibraryDefinitionException, BadServerDefinitionException {
        return ObjectComparator.isEqual(defaultServer, table.getServer(defaultServer));
    }

    @Override
    public ILibrary getClientLibrary(ICodeSegment codeSegment) throws BadLibraryDefinitionException {
        return this.getClientLibrary(codeSegment.getCurrentServer());
    }

    @Override
    public ILibrary getLibraryForUseInJob() {
        IDBMSType type = this.getLibraryDBMSType(this.getLibrary());
        if (!this.isWebStreamDataSource(type) && !this.isWebStreamDataTarget(type)) {
            return this.getLibrary();
        }
        return null;
    }

    @Override
    public ILibrary getClientLibrary(IServer iDefaultServer) throws BadLibraryDefinitionException {
        ILibrary lib = this.getLibraryForUseInJob();
        if (lib != null) {
            return lib.getClientLibrary(iDefaultServer);
        }
        return null;
    }

    @Override
    public String getLocationType() {
        return this.m_sLocationType;
    }

    @Override
    public String[] getLocationTypes() {
        return new String[]{"None", "Physical"};
    }

    @Override
    public void setLocationType(String locationType) {
        List<String> locations = Arrays.asList(this.getLocationTypes());
        if (!locations.contains(locationType)) {
            throw new IllegalArgumentException("location type is not valid.");
        }
        if (this.m_sLocationType.equals(locationType)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetLocationTypeUndoable(this.m_sLocationType, locationType));
            }
            this.m_sLocationType = locationType;
            if ("None".equals(this.m_sLocationType) || "JobAlternate".equals(this.m_sLocationType) && !this.m_bInLoad) {
                this.setLibrary(null);
            }
            this.postSetLocationType();
        }
        finally {
            this.endCompoundUndoable();
        }
        this.fireModelChangedEvent("PhysicalTable:LocationTypeChanged", null);
    }

    protected void postSetLocationType() {
    }

    @Override
    public ILibrary getLibrary() {
        return this.m_library;
    }

    @Override
    public void setLibrary(ILibrary lib) {
        if (this.m_library == lib) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IDBMSType oldType = this.getDBMSType();
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetLibraryUndoable(this.m_library, lib));
            }
            if (this.m_library != null) {
                this.m_library.removeNotifyListener(this);
            }
            if (lib != null && lib.isClientLibrary()) {
                lib = lib.getServerLibrary();
            }
            if (this.m_library == null) {
                this.setLocationType("Physical");
            }
            this.m_library = lib;
            if (this.m_library != null) {
                this.m_library.addNotifyListener(this);
            }
            this.updateTableOptionModel(oldType, this.getDBMSType());
            if (oldType != this.getDBMSType()) {
                this.updateIndexesForDBMSType();
            }
            this.fireModelChangedEvent("PhysicalTable:LibraryChanged", this.m_library);
            this.setDatabaseSchema(this.m_library != null ? this.m_library.getDatabaseSchema() : null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void updateTableOptionModel(IDBMSType oldType, IDBMSType newType) {
        try {
            if (!oldType.getDBMSTypeName().equals(newType.getDBMSTypeName())) {
                this.setTableOptionCollection(this.getOptionModelForTable());
            }
            this.updateTableOptionDefaults();
        }
        catch (FileNotFoundException e) {
            ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
    }

    @Override
    public boolean hasIndexes() {
        return this.getDBMSType().hasIndexes(this);
    }

    @Override
    public boolean hasConstraints() {
        return this.getDBMSType().hasConstraints(this);
    }

    @Override
    public void removeColumn(IColumn column) {
        if (this.isColumnUsedInConstraint(column) && !this.m_bInLoad) {
            throw new UnsupportedOperationException("Column must be removed from all constraints before it can be removed from table: " + column);
        }
        super.removeColumn(column);
    }

    @Override
    public boolean isColumnUsedInConstraint(IColumn column) {
        IPersistableObject key;
        for (int iIndex = 0; iIndex < this.m_lIndexes.size(); ++iIndex) {
            IIndex index = (IIndex)this.m_lIndexes.get(iIndex);
            if (!index.getColumnsList().contains(column)) continue;
            return true;
        }
        for (int iKey = 0; iKey < this.m_lKeys.size(); ++iKey) {
            key = (IKey)this.m_lKeys.get(iKey);
            if (!key.getColumnsList().contains(column)) continue;
            return true;
        }
        for (int iForeignKey = 0; iForeignKey < this.m_lForeignKeys.size(); ++iForeignKey) {
            key = (IForeignKey)this.m_lForeignKeys.get(iForeignKey);
            if (!key.getColumnsList().contains(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIndex[] getIndexes() {
        return (IIndex[])this.m_lIndexes.toArray(new IIndex[this.m_lIndexes.size()]);
    }

    @Override
    public List getIndexesList() {
        return this.m_lIndexes;
    }

    @Override
    public List getIndexesNotInPrimaryKey() {
        ArrayList lIndexes = new ArrayList(this.getIndexesList());
        IKey key = this.getPrimaryKey();
        if (key == null) {
            return lIndexes;
        }
        for (int iIndex = lIndexes.size() - 1; iIndex >= 0; --iIndex) {
            IIndex index = (IIndex)lIndexes.get(iIndex);
            if (!Arrays.equals(key.getColumns(), index.getColumns())) continue;
            lIndexes.remove(iIndex);
        }
        return lIndexes;
    }

    @Override
    public List getIndexesNotInUniqKeys() {
        ArrayList indexList = new ArrayList(this.getIndexesList());
        List keyList = this.getKeysList();
        int keySize = keyList.size();
        block0: for (int i = indexList.size() - 1; i >= 0; --i) {
            IIndex index = (IIndex)indexList.get(i);
            for (int k = 0; k < keySize; ++k) {
                IKey tempKey = (IKey)keyList.get(k);
                if (!this.indexMatchesUniqueKey(index, tempKey)) continue;
                indexList.remove(i);
                continue block0;
            }
        }
        return indexList;
    }

    @Override
    public boolean indexMatchesUniqueKey(IIndex index, IKey uniqKey) {
        if (uniqKey.getColumnsList().size() == index.getColumnsList().size()) {
            for (int c = 0; c < uniqKey.getColumnsList().size(); ++c) {
                IColumn col = (IColumn)uniqKey.getColumnsList().get(c);
                if (col.getID() == ((IColumn)index.getColumnsList().get(c)).getID()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public IIndex getIndexMatchingColumnsList(List lColumnsToMatch) {
        List lIndexes = this.getIndexesList();
        for (int i = 0; i < lIndexes.size(); ++i) {
            IIndex thisIndex = (IIndex)lIndexes.get(i);
            List<IColumn> lIndexColumns = Arrays.asList(((IIndex)lIndexes.get(i)).getColumns());
            if (lIndexColumns.size() != lColumnsToMatch.size()) continue;
            int totalMatches = 0;
            for (int c = 0; c < lIndexColumns.size(); ++c) {
                for (int m = 0; m < lColumnsToMatch.size(); ++m) {
                    if (lIndexColumns.get(c).getID() == ((IColumn)lColumnsToMatch.get(m)).getID()) continue;
                    ++totalMatches;
                }
            }
            if (totalMatches != lColumnsToMatch.size()) continue;
            return thisIndex;
        }
        return null;
    }

    @Override
    public IKey[] getKeys() {
        return (IKey[])this.m_lKeys.toArray(new IKey[this.m_lKeys.size()]);
    }

    @Override
    public IKey getPrimaryKey() {
        for (int iKey = 0; iKey < this.m_lKeys.size(); ++iKey) {
            IKey key = (IKey)this.m_lKeys.get(iKey);
            if (!key.isPrimary()) continue;
            return key;
        }
        return null;
    }

    @Override
    public List getKeysList() {
        return this.m_lKeys;
    }

    @Override
    public IForeignKey[] getForeignKeys() {
        return (IForeignKey[])this.m_lForeignKeys.toArray(new IForeignKey[this.m_lForeignKeys.size()]);
    }

    @Override
    public List getForeignKeysList() {
        return this.m_lForeignKeys;
    }

    @Override
    public IDatabaseSchema getDatabaseSchema() {
        ILibrary lib = this.getLibraryForUseInJob();
        if (lib != null) {
            return lib.getDatabaseSchema();
        }
        return null;
    }

    public void setDatabaseSchema(IDatabaseSchema schema) {
        if (this.m_databaseSchema == schema) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetDataBaseSchemaUndoable(this.m_databaseSchema, schema));
            }
            this.m_databaseSchema = schema;
            this.fireModelChangedEvent("PhysicalTable:DatabaseSchemaChanged", this.m_databaseSchema);
            if (this.m_databaseSchema != null) {
                this.setLibrary(this.m_databaseSchema.getLibrary());
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isDBMSView() {
        return this.m_bIsDBMSView;
    }

    @Override
    public void setDBMSView(boolean isDbmsView) {
        if (this.m_bIsDBMSView == isDbmsView) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDBMSViewUndoable(this.m_bIsDBMSView, isDbmsView));
        }
        this.m_bIsDBMSView = isDbmsView;
        this.fireModelChangedEvent("PhysicalTable:DBMSViewChanged", null);
    }

    @Override
    public boolean isEncrypted() {
        return this.m_bIsEncrypted;
    }

    @Override
    public void setEncrypted(boolean isEncrypted) {
        if (this.m_bIsEncrypted == isEncrypted) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetEncryptedUndoable(this.m_bIsEncrypted, isEncrypted));
        }
        this.m_bIsEncrypted = isEncrypted;
        this.fireModelChangedEvent("PhysicalTable:EncryptedChanged", null);
    }

    @Override
    public boolean isCompressed() {
        return this.m_bIsCompressed;
    }

    @Override
    public void setCompressed(boolean isCompressed) {
        if (this.m_bIsCompressed == isCompressed) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCompressedUndoable(this.m_bIsCompressed, isCompressed));
        }
        this.m_bIsCompressed = isCompressed;
        this.fireModelChangedEvent("PhysicalTable:CompressedChanged", null);
    }

    @Override
    public boolean isWebStreamDataSource() {
        return this.isWebStreamDataSource(this.getLibraryDBMSType(this.getLibrary()));
    }

    private boolean isWebStreamDataSource(IDBMSType dbmsType) {
        return this.getModel().isUsingWebStreams() && !(dbmsType instanceof XMLType) && this.isWebStream() && this.getProducerTransforms().length == 0;
    }

    @Override
    public boolean isWebStreamDataTarget() {
        return this.isWebStreamDataTarget(this.getLibraryDBMSType(this.getLibrary()));
    }

    private boolean isWebStreamDataTarget(IDBMSType dbmsType) {
        return this.getModel().isUsingWebStreams() && !(dbmsType instanceof XMLType) && this.isWebStream() && this.getConsumerTransforms().length == 0;
    }

    @Override
    public String getSASTableName() {
        return this.getSASTableName(true);
    }

    @Override
    public String getSASTableName(boolean useWebStreamSetting) {
        if (useWebStreamSetting) {
            if (this.isWebStreamDataSource()) {
                return WEB_STREAM_SOURCE_PREFIX + this.m_sSasTableName;
            }
            if (this.isWebStreamDataTarget()) {
                return WEB_STREAM_TARGET_PREFIX + this.m_sSasTableName;
            }
            return this.m_sSasTableName;
        }
        return this.m_sSasTableName;
    }

    @Override
    public void setSASTableName(String sasName) {
        if (ObjectComparator.isEqual(this.m_sSasTableName, sasName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSASTableNameUndoable(this.m_sSasTableName, sasName));
        }
        this.m_sSasTableName = sasName;
        this.fireModelChangedEvent("PhysicalTable:SASTableNameChanged", null);
    }

    @Override
    public String getFullNameQuotedAsNeeded(ICodeSegment codeSegment) throws BadLibraryDefinitionException {
        return this.getFullNameQuotedAsNeeded(codeSegment, false);
    }

    @Override
    public String getFullNameQuotedAsNeeded(ICodeSegment codeSegment, boolean passthru) throws BadLibraryDefinitionException {
        return this.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), passthru);
    }

    @Override
    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean environmentQuoting, boolean passthru) throws BadLibraryDefinitionException {
        return this.getFullNameQuotedAsNeeded(currentServer, environmentQuoting, passthru, true, "");
    }

    @Override
    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean environmentQuoting, boolean passthru, boolean quotes, String prefix) throws BadLibraryDefinitionException {
        String tableName = this.getSASTableName();
        if (!this.isWebStreamDataSource() && !this.isWebStreamDataTarget()) {
            if ((this.getDBMSType() instanceof HADOOPType || this.getDBMSType() instanceof SASHDATType) && passthru) {
                String sPassSchema = this.getDBMSType().getSchemaName(currentServer, this, false);
                tableName = this.getDBMSTableName(passthru, sPassSchema);
            } else {
                tableName = this.getDBMSTableName(passthru, null);
            }
            if (prefix != null && prefix.length() > 0 && !prefix.equals(" ")) {
                tableName = prefix + tableName;
            }
            tableName = DBMSNamesUtil.getQuotedName(tableName, this, environmentQuoting && quotes, passthru);
            if (passthru && !this.isQuoted()) {
                String action = this.getUnquotedTableAction();
                if (action.equals("U")) {
                    tableName = tableName.toUpperCase();
                } else if (action.equals("L")) {
                    tableName = tableName.toLowerCase();
                }
            }
            if (passthru) {
                if (this.getDBMSType() instanceof HADOOPType || this.getDBMSType() instanceof SASHDATType || this.getDBMSType() instanceof SASIOIMPType) {
                    return tableName;
                }
                String schema = this.getDBMSType().getSchemaName(currentServer, this, quotes);
                if (schema != null && schema.trim().length() > 0) {
                    tableName = schema.trim() + "." + tableName;
                }
            } else {
                String libref = "work";
                ILibrary lib = this.getClientLibrary(currentServer);
                if (lib != null) {
                    libref = lib.getLibref();
                }
                tableName = libref.trim() + "." + tableName;
            }
        }
        return tableName;
    }

    protected String getUnquotedTableAction() {
        return this.getDBMSType().getUnquotedTableNameAction();
    }

    @Override
    public String getWorkTableName(IServer currentServer, boolean envQuoting) throws CodegenException, BadLibraryDefinitionException {
        String oldName = this.getFullNameQuotedAsNeeded(currentServer, envQuoting, false);
        String newName = null;
        newName = !oldName.toUpperCase().startsWith("work".toUpperCase() + '.') ? "work." + oldName.substring(oldName.indexOf(46) + 1) : oldName;
        return newName;
    }

    @Override
    public StringBuffer getDownloadCode(IServer currentServer, boolean envQuoting, ITransformTableOptions tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.getDownloadCode(currentServer, envQuoting, -1, tableOptions);
    }

    @Override
    public StringBuffer getDownloadCode(IServer currentServer, boolean envQuoting, int numberRowsToDownload, ITransformTableOptions tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String readTableOptions;
        StringBuffer code = new StringBuffer();
        if (this.isQuoted()) {
            code.append(CodeSegment.getValidvarnameOptionAny(true));
        }
        code.append("proc download data = ").append(this.getFullNameQuotedAsNeeded(currentServer, envQuoting, false));
        String string = readTableOptions = tableOptions != null ? tableOptions.getTableOptions(false, null) : this.getReadTableOptions(false);
        if (numberRowsToDownload > -1) {
            code.append("(");
            if (readTableOptions != null && readTableOptions.length() > 0) {
                code.append(readTableOptions).append(" ");
            }
            code.append("obs = ").append(numberRowsToDownload);
            code.append(")");
        } else if (readTableOptions != null && readTableOptions.length() > 0) {
            code.append("(").append(readTableOptions).append(")");
        }
        code.append("\n");
        code.append("   ").append("out = ").append(this.getWorkTableName(currentServer, envQuoting));
        code.append(";\n");
        code.append("run;\n\n");
        if (this.isQuoted()) {
            code.append(CodeSegment.getValidvarnameOptionReset());
        }
        return code;
    }

    @Override
    public ICodeSegment genDownloadCode(ICodeSegment codeSegment, ITransformTableOptions tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.genDownloadCode(codeSegment, -1, tableOptions);
    }

    @Override
    public ICodeSegment genDownloadCode(ICodeSegment codeSegment, int numberRowsToDownload, ITransformTableOptions tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return codeSegment.addSourceCode(this.getDownloadCode(codeSegment.getCurrentServer(), codeSegment.isQuoting(), numberRowsToDownload, tableOptions));
    }

    @Override
    public StringBuffer getUploadCode(IServer currentServer, boolean quotes, ITransformTableOptions tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.getUploadCode(currentServer, quotes, -1, tableOptions);
    }

    @Override
    public StringBuffer getUploadCode(IServer currentServer, boolean envQuoting, int numberRowsToUpload, ITransformTableOptions tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String readTableOptions;
        StringBuffer code = new StringBuffer();
        if (this.isQuoted()) {
            code.append(CodeSegment.getValidvarnameOptionAny(true));
        }
        code.append("proc upload data = ").append(this.getFullNameQuotedAsNeeded(currentServer, envQuoting, false));
        String string = readTableOptions = tableOptions != null ? tableOptions.getTableOptions(false, null) : this.getReadTableOptions(false);
        if (numberRowsToUpload > -1) {
            code.append("(");
            if (readTableOptions != null && readTableOptions.length() > 0) {
                code.append(readTableOptions).append(" ");
            }
            code.append("obs = ").append(numberRowsToUpload);
            code.append(")");
        } else if (readTableOptions != null && readTableOptions.length() > 0) {
            code.append("(").append(readTableOptions).append(")");
        }
        code.append("\n");
        code.append("   ").append("out = ").append(this.getWorkTableName(currentServer, envQuoting));
        code.append(";\n");
        code.append("run;\n\n");
        if (this.isQuoted()) {
            code.append(CodeSegment.getValidvarnameOptionReset());
        }
        return code;
    }

    @Override
    public ICodeSegment genUploadCode(ICodeSegment codeSegment, ITransformTableOptions tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.genUploadCode(codeSegment, -1, tableOptions);
    }

    @Override
    public ICodeSegment genUploadCode(ICodeSegment codeSegment, int numberRowsToUpload, ITransformTableOptions tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return codeSegment.addSourceCode(this.getUploadCode(codeSegment.getCurrentServer(), codeSegment.isQuoting(), tableOptions));
    }

    @Override
    public String getTableName() {
        return this.getTableName(this.isQuoted());
    }

    @Override
    public String getTableName(boolean quotes, boolean passthru) {
        String tableName = this.getSASTableName();
        if (passthru && !this.isQuoted()) {
            String action = this.getUnquotedTableAction();
            if ("U".equals(action)) {
                tableName = tableName.toUpperCase();
            } else if ("L".equals(action)) {
                tableName = tableName.toLowerCase();
            }
        }
        return DBMSNamesUtil.getQuotedName(tableName, this, quotes, passthru);
    }

    @Override
    public String getTableName(boolean quotes) {
        return this.getTableName(quotes, false);
    }

    @Override
    public String getDBMSTableName(boolean passthru) {
        return this.getDBMSTableName(passthru, null);
    }

    public String getDBMSTableName(boolean passthru, String schemaName) {
        ILibrary library = this.getLibraryForUseInJob();
        String tableName = this.getSASTableName();
        return this.getDBMSType().getDBMSTableName(library, tableName, passthru, schemaName);
    }

    public boolean doesNoLibraryMeanIncomplete() {
        IDBMSType type = this.getLibraryDBMSType(this.getLibrary());
        return !this.isWebStreamDataSource(type) && !this.isWebStreamDataTarget(type);
    }

    @Override
    public boolean hasWarnings() {
        boolean warn = super.hasWarnings();
        if (warn) {
            return warn;
        }
        return this.isView() && (this.getIndexes().length > 0 || this.getKeys().length > 0 || this.getForeignKeys().length > 0);
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        if (this.isView() && (this.getIndexes().length > 0 || this.getKeys().length > 0 || this.getForeignKeys().length > 0)) {
            warnings.add(MessageFormat.format(RB.getStringResource("BasePhysicalTable.ViewHasIndexesOrKeys.txt"), this.getName()));
        }
        return warnings;
    }

    @Override
    public boolean isComplete() {
        int i;
        ILibrary lib = this.getLibraryForUseInJob();
        if (lib != null && !lib.isComplete()) {
            return false;
        }
        if (this.doesNoLibraryMeanIncomplete() && lib == null) {
            return false;
        }
        IIndex[] indexes = this.getIndexes();
        IKey[] keys = this.getKeys();
        IForeignKey[] foreignKeys = this.getForeignKeys();
        for (i = 0; i < indexes.length; ++i) {
            if (indexes[i].isComplete()) continue;
            return false;
        }
        for (i = 0; i < keys.length; ++i) {
            if (keys[i].isComplete()) continue;
            return false;
        }
        for (i = 0; i < foreignKeys.length; ++i) {
            if (foreignKeys[i].isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        int i;
        ArrayList<String> reasons = new ArrayList<String>();
        ILibrary lib = this.getLibraryForUseInJob();
        if (lib != null) {
            reasons.addAll(lib.getReasonsIncomplete());
        }
        if (this.doesNoLibraryMeanIncomplete() && lib == null) {
            reasons.add(MessageFormat.format(RB.getStringResource("BasePhysicalTable.TableRequiresLibrary.txt"), this.getName()));
        }
        IIndex[] indexes = this.getIndexes();
        IKey[] keys = this.getKeys();
        IForeignKey[] foreignKeys = this.getForeignKeys();
        for (i = 0; i < indexes.length; ++i) {
            reasons.addAll(indexes[i].getReasonsIncomplete());
        }
        for (i = 0; i < keys.length; ++i) {
            reasons.addAll(keys[i].getReasonsIncomplete());
        }
        for (i = 0; i < foreignKeys.length; ++i) {
            reasons.addAll(foreignKeys[i].getReasonsIncomplete());
        }
        return reasons;
    }

    @Override
    public boolean isRemoteToServer(IServer currentServer) throws BadServerDefinitionException, BadLibraryDefinitionException {
        ILibrary clientLibrary = this.getCodeGenLibrary(currentServer);
        if (clientLibrary != null) {
            return clientLibrary.isRemoteToServer(currentServer);
        }
        return false;
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return this.genAccessPath(codeSegment, true, null);
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return this.genAccessPath(codeSegment, true, tableOptions);
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment, boolean generateStatusMacros, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return this.genAccessPath(codeSegment, generateStatusMacros, -1, tableOptions);
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment, boolean generateStatusMacros, int numberRowsDownload, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return this.genAccessPath(codeSegment, generateStatusMacros, numberRowsDownload, null, tableOptions);
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment, boolean generateStatusMacros, int numberRowsDownload, Map additionalMacros, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return this.genAccessPath(codeSegment, generateStatusMacros, numberRowsDownload, additionalMacros, false, false, tableOptions);
    }

    @Override
    public ICodeSegment genAccessPath(ICodeSegment codeSegment, boolean generateStatusMacros, int numberRowsDownload, Map additionalMacros, boolean generatePerformanceStatistics, boolean generateTablePerformanceStatistics, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return codeSegment.addSourceCode(this.getAccessPath(codeSegment.getCodeGenerationEnvironment(), generateStatusMacros, numberRowsDownload, additionalMacros, generatePerformanceStatistics, generateTablePerformanceStatistics, tableOptions));
    }

    @Override
    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return this.getAccessPath(environment, true, tableOptions);
    }

    @Override
    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment, boolean generateStatusMacros, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return this.getAccessPath(environment, generateStatusMacros, -1, tableOptions);
    }

    @Override
    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment, boolean generateStatusMacros, int numberRowsToDownload, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return this.getAccessPath(environment, generateStatusMacros, numberRowsToDownload, null, tableOptions);
    }

    @Override
    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment, boolean generateStatusMacros, int numberRowsToDownload, Map additionalRemoteMacros, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        return this.getAccessPath(environment, generateStatusMacros, numberRowsToDownload, additionalRemoteMacros, false, false, tableOptions);
    }

    @Override
    public StringBuffer getAccessPath(ICodeGenerationEnvironment environment, boolean generateStatusMacros, int numberRowsToDownload, Map additionalRemoteMacros, boolean generatePerformanceStatistics, boolean generateTablePerformanceStatistics, ITransformTableOptions tableOptions) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        ILibrary clientLibrary;
        CodeSegment codeSegment = new CodeSegment(environment, this);
        this.getGeneratedDefaultParameterCode(codeSegment);
        ILibrary lib = this.getLibraryForUseInJob();
        if (lib != null && !this.isWebStreamDataSource() && !this.isWebStreamDataTarget() && (clientLibrary = this.getCodeGenLibrary(environment.getCurrentServer())) != null) {
            if (clientLibrary.isRemoteToServer(environment.getCurrentServer()) && this.isQuoted()) {
                codeSegment.addSourceCode(CodeSegment.getValidvarnameOptionAny(false));
            }
            clientLibrary.genAccessPath(codeSegment, generateStatusMacros, additionalRemoteMacros, generatePerformanceStatistics, generateTablePerformanceStatistics, !this.isWebStream());
            if (clientLibrary.isRemoteToServer(environment.getCurrentServer())) {
                IServer libServer = clientLibrary.getBestServer(environment.getCurrentServer());
                ISASClientConnection conn = libServer.getConnectClient();
                if (conn == null) {
                    throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("Connect.MissingConnection.txt"), libServer.getName()));
                }
                if (conn != null) {
                    ITransform trans;
                    if (!environment.isOnSignonCache(libServer)) {
                        conn.genAccessCode(codeSegment);
                        environment.addToSignonCache(libServer);
                    }
                    if (generateStatusMacros) {
                        codeSegment.genReturnCodeRemoteSetup(conn, additionalRemoteMacros, false);
                    }
                    codeSegment.genRemoteMacroVariablesSetup(environment.getRemoteMacroVariables(), conn.getHostName(), true);
                    codeSegment.genTableDelete(this.getWorkTableName(environment.getCurrentServer(), codeSegment.isQuoting()));
                    conn.genStartSubmit("sysrputsync = yes", codeSegment, generateStatusMacros, generatePerformanceStatistics, generateTablePerformanceStatistics);
                    codeSegment.indent();
                    codeSegment.addSourceCode("%macro ").addSourceCode(REMOTE_MACRO_NAME).addSourceCode("; \n");
                    codeSegment.indent();
                    codeSegment.addSectionComment(RB.getStringResource("Transfer.ImplicitComment.msg.txt"));
                    this.genDownloadCode(codeSegment, numberRowsToDownload, tableOptions);
                    if (generateStatusMacros) {
                        codeSegment.genRCSetCall("&syserr");
                        codeSegment.genReturnCodeRemoteEnding(false);
                    }
                    if (!clientLibrary.isPreAssigned() && (trans = this.getTransform()) != null && trans.isClearLibrefEnabled()) {
                        codeSegment.addSourceCode("libname " + clientLibrary.getLibref() + " clear;\n");
                        if (generateStatusMacros) {
                            codeSegment.genRCSetCall("&syslibrc");
                        }
                    }
                    codeSegment.unIndent();
                    codeSegment.addSourceCode("%mend ").addSourceCode(REMOTE_MACRO_NAME).addSourceCode("; \n");
                    codeSegment.addSourceCode("%").addSourceCode(REMOTE_MACRO_NAME).addSourceCode(";\n");
                    codeSegment.unIndent();
                    conn.genEndSubmit(codeSegment);
                    codeSegment.addSourceCode("libname " + clientLibrary.getLibref() + " (" + "work" + ");\n");
                    if (generateStatusMacros) {
                        codeSegment.genRCSetCall("&syslibrc");
                    }
                }
            }
        }
        return codeSegment.getGeneratedCode();
    }

    @Override
    public StringBuffer getInteractiveAccessPath(ICodeGenerationEnvironment environment) throws CodegenException, RemoteException, MdException, BadServerDefinitionException, BadLibraryDefinitionException {
        StringBuffer code = new StringBuffer();
        ILibrary lib = this.getCodeGenLibrary(environment.getCurrentServer());
        if (lib != null) {
            code = lib.getInteractiveAccessPath(environment);
        }
        return code;
    }

    @Override
    public String getUpdateTableMetadataCode() throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (!Workspace.useProcMetalibChanges()) {
            return this.getUpdateTableMetadataCode94M5();
        }
        StringBuffer code = new StringBuffer();
        if (!this.isNew()) {
            CodeSegment cs;
            String readStr;
            ILibrary library = this.getLibraryForUseInJob();
            PasswordAuthentication pw = null;
            String libid = "";
            String repid = "";
            if (library != null) {
                String libfqid = library.getID();
                if (!LibraryUtil.isApplicationUsingAuthDomainForPasswords() && library.isCredentialPromptRequired()) {
                    pw = library.getPromptedCredentialsLibraryUserPass();
                }
                libid = libfqid.substring(libfqid.indexOf(".") + 1);
                repid = libfqid.substring(0, libfqid.indexOf("."));
            }
            String worklibid = "";
            String worklibrepid = "";
            boolean isWorkTable = false;
            if (this instanceof BaseWorkTable) {
                isWorkTable = true;
                ILibrary workLibrary = this.getLibraryForUseInJob();
                if (workLibrary != null) {
                    String workLibFQID = workLibrary.getID();
                    worklibid = workLibFQID.substring(workLibFQID.indexOf(".") + 1);
                    worklibrepid = workLibFQID.substring(0, workLibFQID.indexOf("."));
                    libid = worklibid;
                    repid = worklibrepid;
                }
            }
            boolean isProjectTable = WsMetadataUtil.isProjectObject((SimpleObject)this);
            boolean bUseMetalibEnhancements = Workspace.useProcMetalibChanges();
            code.append("\n");
            code.append("proc metalib;\n");
            code.append("   omr (libid=\"");
            code.append(libid);
            code.append("\"\n");
            code.append("      repid=\"");
            code.append(repid);
            code.append("\"");
            if (bUseMetalibEnhancements && (isProjectTable || isWorkTable)) {
                code.append(" / ");
                if (isProjectTable) {
                    String tablefqid = this.getID();
                    String projrepid = repid = tablefqid.substring(0, tablefqid.indexOf("."));
                    code.append(" project_reposid = \"").append(projrepid).append("\" ");
                }
                if (isWorkTable) {
                    code.append(" worktables=yes");
                }
            }
            code.append(");\n");
            code.append("   report(type = summary);\n");
            code.append("   update_rule = (noadd);\n");
            if (pw != null) {
                code.append("   dbauth(dbuser=\"").append(pw.getUserName()).append("\"\n").append("          dbpassword=\"").append(pw.getPassword()).append("\");\n");
            }
            code.append("   select (");
            code.append(this.getID());
            String opts = this.getReadTableOptions(false);
            if (opts != null && opts.length() > 0 && (readStr = (cs = new CodeSegment(null, this)).parsePasswordOption(opts, READ_PASSWORD_PATTERN)) != null && readStr.length() > 0) {
                code.append(" ").append(readStr);
            }
            code.append(");\n");
            code.append("run;\n");
        }
        return code.toString();
    }

    public String getUpdateTableMetadataCode94M5() throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        StringBuffer code = new StringBuffer();
        if (!this.isNew()) {
            CodeSegment cs;
            String readStr;
            StringBuffer buffer = null;
            String repid = this.getID();
            ILibrary library = this.getLibraryForUseInJob();
            PasswordAuthentication pw = null;
            String libid = "";
            if (library != null) {
                libid = library.getID();
                if (library.isCredentialPromptRequired()) {
                    pw = library.getPromptedCredentialsLibraryUserPass();
                }
            }
            libid = libid.substring(libid.indexOf(".") + 1);
            repid = repid.substring(0, repid.indexOf("."));
            if (buffer != null) {
                code.append(buffer);
            }
            code.append("\n");
            code.append("proc metalib;\n");
            code.append("   omr (libid=\"");
            code.append(libid);
            code.append("\"\n");
            code.append("      repid=\"");
            code.append(repid);
            code.append("\");\n");
            code.append("   report(type = summary);\n");
            code.append("   update_rule = (noadd);\n");
            if (pw != null) {
                code.append("   dbauth(dbuser=\"").append(pw.getUserName()).append("\"\n").append("          dbpassword=\"'").append(pw.getPassword()).append("'\");\n");
            }
            code.append("   select (");
            code.append(this.getID());
            String opts = this.getReadTableOptions(false);
            if (opts != null && opts.length() > 0 && (readStr = (cs = new CodeSegment(null, this)).parsePasswordOption(opts, READ_PASSWORD_PATTERN)) != null && readStr.length() > 0) {
                code.append(" ").append(readStr);
            }
            code.append(");\n");
            code.append("run;\n");
        }
        return code.toString();
    }

    @Override
    public ILibrary getCodeGenLibrary(IServer currentServer) throws BadLibraryDefinitionException {
        return this.getClientLibrary(currentServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIndex createNewIndex() {
        IIndex oIndex = null;
        this.startCompoundUndoable();
        try {
            String sName;
            int iNextIncrementValue = 1;
            do {
                sName = this.getDBMSType().getIndexNamePrefix(this) + new Integer(iNextIncrementValue);
                ++iNextIncrementValue;
            } while (!this.isIndexNameUnique(sName));
            oIndex = this.getObjectFactory().createNewIndex(this.getID());
            oIndex.setName(sName);
            this.getIndexesList().add(oIndex);
        }
        finally {
            this.endCompoundUndoable();
        }
        return oIndex;
    }

    @Override
    public boolean isIndexNameUnique(String sName) {
        List lIndexList = this.getIndexesList();
        for (int i = 0; i < lIndexList.size(); ++i) {
            IIndex iindex = (IIndex)lIndexList.get(i);
            if (!sName.equalsIgnoreCase(iindex.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getLibref(IServer currentServer) throws BadLibraryDefinitionException {
        ILibrary lib = this.getCodeGenLibrary(currentServer);
        if (lib != null) {
            return lib.getLibref();
        }
        return !this.isWebStreamDataTarget() ? "work" : "";
    }

    @Override
    public void copy(IPhysicalTable physicalTable) {
        this.startCompoundUndoable();
        try {
            physicalTable.setName(this.getName());
            physicalTable.setDescription(this.getDescription());
            physicalTable.setSASTableName(this.getSASTableName());
            if (this instanceof IWorkTable && physicalTable instanceof IWorkTable) {
                physicalTable.setView(this.isView());
            }
            physicalTable.setLibrary(this.getLibrary());
            physicalTable.setFolder(this.getFolder());
            physicalTable.setSpecialCharacters(this.isSpecialCharacters());
            physicalTable.setCaseSensitive(this.isCaseSensitive());
            physicalTable.setDBMSView(this.isDBMSView());
            physicalTable.setCompressed(this.isCompressed());
            physicalTable.setEncrypted(this.isEncrypted());
            if (!(physicalTable instanceof IWorkTable)) {
                physicalTable.setLocationType("Physical");
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map deepCopy(IPhysicalTable physicalTable) throws MdException {
        HashMap<IColumn, IColumn> columnsMap = new HashMap<IColumn, IColumn>();
        this.startCompoundUndoable();
        try {
            this.copy(physicalTable);
            IColumn[] aCopyColumns = physicalTable.getColumns();
            for (int iColumn = 0; iColumn < aCopyColumns.length; ++iColumn) {
                physicalTable.removeColumn(aCopyColumns[iColumn]);
            }
            IColumn[] aColumns = this.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                IColumn column = aColumns[iColumn];
                IColumn columnNew = physicalTable.getModel().getObjectFactory().createNewColumn(physicalTable.getID());
                column.deepCopy(columnNew);
                columnsMap.put(column, columnNew);
                physicalTable.addColumn(columnNew);
            }
            List lCopyKeys = physicalTable.getKeysList();
            while (!lCopyKeys.isEmpty()) {
                lCopyKeys.remove(0);
            }
            IKey[] aKeys = this.getKeys();
            for (int iKey = 0; iKey < aKeys.length; ++iKey) {
                IKey keyNew = physicalTable.getModel().getObjectFactory().createNewKey(physicalTable.getID());
                aKeys[iKey].copy(keyNew);
                List lKeyColumns = aKeys[iKey].getColumnsList();
                for (int iKeyColumn = 0; iKeyColumn < lKeyColumns.size(); ++iKeyColumn) {
                    IColumn keyColumn = (IColumn)lKeyColumns.get(iKeyColumn);
                    IColumn keyColumnNew = (IColumn)columnsMap.get(keyColumn);
                    keyNew.getColumnsList().add(keyColumnNew);
                }
                lCopyKeys.add(keyNew);
            }
            List lCopyIndexes = physicalTable.getIndexesList();
            while (!lCopyIndexes.isEmpty()) {
                lCopyIndexes.remove(0);
            }
            IIndex[] aIndexes = this.getIndexes();
            for (int iIndex = 0; iIndex < aIndexes.length; ++iIndex) {
                IIndex IndexNew = physicalTable.getModel().getObjectFactory().createNewIndex(physicalTable.getID());
                aIndexes[iIndex].copy(IndexNew);
                List lIndexColumns = aIndexes[iIndex].getColumnsList();
                for (int iIndexColumn = 0; iIndexColumn < lIndexColumns.size(); ++iIndexColumn) {
                    IColumn IndexColumn = (IColumn)lIndexColumns.get(iIndexColumn);
                    IColumn IndexColumnNew = (IColumn)columnsMap.get(IndexColumn);
                    IndexNew.getColumnsList().add(IndexColumnNew);
                }
                lCopyIndexes.add(IndexNew);
            }
            physicalTable.setPromptGroup(PromptUtils.copyPromptGroup(Workspace.getWorkspace().getUserContext(), this.getPromptGroup()));
            try {
                physicalTable.setTableOptionCollection((PhysicalTablePromptModelCollection)this.getTableOptionCollection().copy(physicalTable));
            }
            catch (FileNotFoundException e) {
                throw new MdException((Throwable)e);
            }
            catch (ServerConnectionException e) {
                throw new MdException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
            catch (IOException e) {
                throw new MdException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new MdException((Throwable)e);
            }
            catch (SAXException e) {
                throw new MdException((Throwable)e);
            }
            List lCopyExtAttrs = physicalTable.getExtendedAttributesList();
            while (!lCopyExtAttrs.isEmpty()) {
                lCopyExtAttrs.remove(0);
            }
            IExtendedAttribute[] aExtAttrs = this.getExtendedAttributes();
            for (int iExtAttr = 0; iExtAttr < aExtAttrs.length; ++iExtAttr) {
                IExtendedAttribute attr = this.getObjectFactory().createNewExtendedAttribute(physicalTable.getID());
                aExtAttrs[iExtAttr].copy(attr);
                lCopyExtAttrs.add(attr);
            }
            physicalTable.setPrivateNote(this.getPrivateNote());
            List lCopyNotes = physicalTable.getNotesList();
            while (!lCopyNotes.isEmpty()) {
                lCopyNotes.remove(0);
            }
            INote[] aNotes = this.getNotes();
            for (int iNote = 0; iNote < aNotes.length; ++iNote) {
                lCopyNotes.add(aNotes[iNote]);
            }
            List lCopyDocuments = physicalTable.getDocumentsList();
            while (!lCopyDocuments.isEmpty()) {
                lCopyDocuments.remove(0);
            }
            IDocument[] aDocuments = this.getDocuments();
            for (int iDocument = 0; iDocument < aDocuments.length; ++iDocument) {
                lCopyDocuments.add(aDocuments[iDocument]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
        return columnsMap;
    }

    @Override
    public void moveTableToLibrary(ICodeSegment codeSegment, ILibrary newLibrary, boolean useDelete, List options, boolean caseSensitive, boolean specialCharacters) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        this.moveTableToLibrary(codeSegment, newLibrary, useDelete, options, caseSensitive, specialCharacters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTableToLibrary(ICodeSegment codeSegment, ILibrary newLibrary, boolean useDelete, List options, boolean caseSensitive, boolean specialCharacters, String alternativeTargetSASTableName) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String origTableName = this.getFullNameQuotedAsNeeded(codeSegment);
        IModel model = this.getModel();
        boolean oldUndo = model.isUndoSupported();
        model.setUndoSupported(false);
        boolean oldChanged = this.isChanged();
        try {
            if (alternativeTargetSASTableName != null && alternativeTargetSASTableName.length() > 0) {
                this.setSASTableName(alternativeTargetSASTableName);
            }
            this.setLibrary(newLibrary);
            this.setSpecialCharacters(specialCharacters);
            this.setCaseSensitive(caseSensitive);
            IDBMSType dbmsType = this.getDBMSType();
            if (this.isQuoted() && !codeSegment.isQuoting()) {
                codeSegment.genValidvarnameOptionAny(false);
                codeSegment.setQuoting(true);
            }
            newLibrary.genAccessPath(codeSegment);
            codeSegment.addSourceCode("%macro etls_pushToDBMS();\n").indent();
            if (useDelete) {
                dbmsType.drop(codeSegment, this, false);
                dbmsType.create(codeSegment, this, false, false, false, false, "", null);
                if (this.hasConstraints() || this.hasIndexes()) {
                    codeSegment.addSourceCode("%let etls_tableExist = 0; \n\n");
                }
            } else {
                this.genTableExist(codeSegment);
                dbmsType.create(codeSegment, this, true, false, false, false, "", null);
                codeSegment.addSourceCode("%else; \n").addSourceCode("%do;\n").indent();
                dbmsType.deleteAllRows(codeSegment, this, true);
                codeSegment.unIndent().addSourceCode("%end;\n\n");
            }
            codeSegment.addSourceCode("proc append base = ").addSourceCode(this.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode("\n").indent();
            if (options != null && !options.isEmpty()) {
                codeSegment.addSourceCode("(\n").indent();
                int size = options.size();
                for (int i = 0; i < size; ++i) {
                    codeSegment.addSourceCode((String)options.get(i)).addSourceCode("\n");
                }
                codeSegment.unIndent().addSourceCode(")\n");
            }
            codeSegment.addSourceCode("data = ").addSourceCode(origTableName).addSourceCode(" force; \n").unIndent().addSourceCode("run;\n\n");
            dbmsType.createIndexAndConstraintsConditionally(codeSegment, this);
            codeSegment.genRCSetCall("&syserr");
            codeSegment.unIndent().addSourceCode("%mend etls_pushToDBMS;\n").addSourceCode("%etls_pushToDBMS;\n\n");
        }
        finally {
            this.setChanged(oldChanged);
            model.setUndoSupported(oldUndo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTableToLibrary(ICodeSegment codeSegment, ILibrary newLibrary, boolean useDelete, List options, boolean caseSensitive, boolean specialCharacters, String alternativeTargetSASTableName, boolean useTempLibrary, boolean usePassThru, String tempTableName) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String origTableName = this.getFullNameQuotedAsNeeded(codeSegment);
        IModel model = this.getModel();
        boolean oldUndo = model.isUndoSupported();
        model.setUndoSupported(false);
        boolean oldChanged = this.isChanged();
        try {
            if (alternativeTargetSASTableName != null && alternativeTargetSASTableName.length() > 0) {
                this.setSASTableName(alternativeTargetSASTableName);
            }
            this.setLibrary(newLibrary);
            this.setSpecialCharacters(specialCharacters);
            this.setCaseSensitive(caseSensitive);
            IDBMSType dbmsType = this.getDBMSType();
            boolean createTempIndexConstraintAfterLoad = dbmsType.isCreateTempIndexAndConstraintAfterLoad();
            if (this.isQuoted() && !codeSegment.isQuoting()) {
                codeSegment.genValidvarnameOptionAny(false);
                codeSegment.setQuoting(true);
            }
            newLibrary.genAccessPath(codeSegment);
            codeSegment.addSourceCode("%macro etls_pushToDBMS();\n").indent();
            if (useDelete) {
                dbmsType.drop(codeSegment, this, false);
                dbmsType.create(codeSegment, this, false, false, false, false, "", null);
                if (this.hasConstraints() || this.hasIndexes()) {
                    codeSegment.addSourceCode("%let etls_tableExist = 0; \n\n");
                }
            } else {
                this.genTableExist(codeSegment);
                dbmsType.create(codeSegment, this, true, false, false, false, "", null);
                codeSegment.addSourceCode("%else; \n").addSourceCode("%do;\n").indent();
                dbmsType.deleteAllRows(codeSegment, this, true);
                codeSegment.unIndent().addSourceCode("%end;\n\n");
            }
            boolean bIndexConstraintCreated = false;
            if (usePassThru && useTempLibrary && !createTempIndexConstraintAfterLoad) {
                this.setSASTableName(tempTableName);
                dbmsType.createIndexAndConstraintsConditionally(codeSegment, this);
                codeSegment.genRCSetCall("&syserr");
                bIndexConstraintCreated = true;
            }
            this.setSASTableName(alternativeTargetSASTableName);
            codeSegment.addSourceCode("proc append base = ").addSourceCode(this.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode("\n").indent();
            if (options != null && !options.isEmpty()) {
                codeSegment.addSourceCode("(\n").indent();
                int size = options.size();
                for (int i = 0; i < size; ++i) {
                    codeSegment.addSourceCode((String)options.get(i)).addSourceCode("\n");
                }
                codeSegment.unIndent().addSourceCode(")\n");
            }
            codeSegment.addSourceCode("data = ").addSourceCode(origTableName).addSourceCode(" force; \n").unIndent().addSourceCode("run;\n\n");
            if (!bIndexConstraintCreated) {
                this.setSASTableName(tempTableName);
                dbmsType.createIndexAndConstraintsConditionally(codeSegment, this);
                codeSegment.genRCSetCall("&syserr");
            }
            codeSegment.unIndent().addSourceCode("%mend etls_pushToDBMS;\n").addSourceCode("%etls_pushToDBMS;\n\n");
        }
        finally {
            this.setChanged(oldChanged);
            model.setUndoSupported(oldUndo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTableToLibrary(ICodeSegment codeSegment, ILibrary newLibrary, boolean useDelete, List options, boolean caseSensitive, boolean specialCharacters, String alternativeTargetSASTableName, boolean useTempLibrary, boolean usePassThru, String tempTableName, String tableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String origTableName = this.getFullNameQuotedAsNeeded(codeSegment);
        IModel model = this.getModel();
        boolean oldUndo = model.isUndoSupported();
        model.setUndoSupported(false);
        boolean oldChanged = this.isChanged();
        try {
            if (alternativeTargetSASTableName != null && alternativeTargetSASTableName.length() > 0) {
                this.setSASTableName(alternativeTargetSASTableName);
            }
            this.setLibrary(newLibrary);
            this.setSpecialCharacters(specialCharacters);
            this.setCaseSensitive(caseSensitive);
            IDBMSType dbmsType = this.getDBMSType();
            boolean createTempIndexConstraintAfterLoad = dbmsType.isCreateTempIndexAndConstraintAfterLoad();
            if (this.isQuoted() && !codeSegment.isQuoting()) {
                codeSegment.genValidvarnameOptionAny(false);
                codeSegment.setQuoting(true);
            }
            newLibrary.genAccessPath(codeSegment);
            codeSegment.addSourceCode("%macro etls_pushToDBMS();\n").indent();
            if (useDelete) {
                dbmsType.drop(codeSegment, this, false);
                dbmsType.create(codeSegment, this, false, false, false, false, tableOptions, null);
                if (this.hasConstraints() || this.hasIndexes()) {
                    codeSegment.addSourceCode("%let etls_tableExist = 0; \n\n");
                }
            } else {
                this.genTableExist(codeSegment);
                dbmsType.create(codeSegment, this, true, false, false, false, tableOptions, null);
                codeSegment.addSourceCode("%else; \n").addSourceCode("%do;\n").indent();
                dbmsType.deleteAllRows(codeSegment, this, true);
                codeSegment.unIndent().addSourceCode("%end;\n\n");
            }
            boolean bIndexConstraintCreated = false;
            if (usePassThru && useTempLibrary && !createTempIndexConstraintAfterLoad) {
                this.setSASTableName(tempTableName);
                dbmsType.createIndexAndConstraintsConditionally(codeSegment, this);
                codeSegment.genRCSetCall("&syserr");
                bIndexConstraintCreated = true;
            }
            this.setSASTableName(alternativeTargetSASTableName);
            codeSegment.addSourceCode("proc append base = ").addSourceCode(this.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode("\n").indent();
            if (options != null && !options.isEmpty()) {
                codeSegment.addSourceCode("(\n").indent();
                int size = options.size();
                for (int i = 0; i < size; ++i) {
                    codeSegment.addSourceCode((String)options.get(i)).addSourceCode("\n");
                }
                codeSegment.unIndent().addSourceCode(")\n");
            }
            codeSegment.addSourceCode("data = ").addSourceCode(origTableName).addSourceCode(" force; \n").unIndent().addSourceCode("run;\n\n");
            if (!bIndexConstraintCreated) {
                this.setSASTableName(tempTableName);
                dbmsType.createIndexAndConstraintsConditionally(codeSegment, this);
                codeSegment.genRCSetCall("&syserr");
            }
            codeSegment.unIndent().addSourceCode("%mend etls_pushToDBMS;\n").addSourceCode("%etls_pushToDBMS;\n\n");
        }
        finally {
            this.setChanged(oldChanged);
            model.setUndoSupported(oldUndo);
        }
    }

    @Override
    public ICodeSegment genTableDelete(ICodeSegment codeSegment) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        IDBMSType type = this.getDBMSType();
        if (type.isDeleteTableSupported()) {
            type.genTableDelete(codeSegment, this.isView(), this.getFullNameQuotedAsNeeded(codeSegment), codeSegment.parsePasswordOption(this.getReadTableOptions(false), ICodeSegment.ALTER_PASSWORD_PATTERN));
        }
        return codeSegment;
    }

    @Override
    public boolean equalsDatabaseServer(IServer defaultServer, IPhysicalTable compareTable) throws BadLibraryDefinitionException {
        boolean equals = false;
        ILibrary siLibrary = this.getClientLibrary(defaultServer);
        ILibrary tiLibrary = compareTable.getClientLibrary(defaultServer);
        if (siLibrary == null || tiLibrary == null) {
            return false;
        }
        IDatabaseSchema siSchema = siLibrary.getDatabaseSchema();
        IDatabaseSchema tiSchema = tiLibrary.getDatabaseSchema();
        if (siSchema == null || tiSchema == null) {
            return false;
        }
        IServer comp1 = siSchema.getServer();
        IServer comp2 = tiSchema.getServer();
        if (comp1 != null && comp2 != null && comp1 == comp2) {
            equals = true;
        }
        return equals;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_library != null && this.m_library.isChanged() || this.m_lKeys.isChanged() || this.m_lForeignKeys.isChanged() || this.m_lIndexes.isChanged() || this.m_optionModel != null && this.m_optionModel.isChanged();
    }

    @Override
    public String getOMRType() {
        return "PhysicalTable";
    }

    @Override
    public String getPublicType() {
        return "Table";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return OMRPhysicalTable.CURRENT_VERSION;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        PhysicalTable mdoTable = (PhysicalTable)omr.acquireOMRObject(this);
        mdoTable.setSASTableName(this.getSASTableName());
        mdoTable.setTableName(this.getSASTableName());
        mdoTable.setMemberType(this.isView() ? "VIEW" : "DATA");
        this.m_lIndexes.saveToOMR(omr, (List)mdoTable.getIndexes(false));
        this.m_lKeys.saveToOMR(omr, (List)mdoTable.getUniqueKeys(false));
        this.m_lForeignKeys.saveToOMR(omr, (List)mdoTable.getForeignKeys(false));
        AssociationList lTablePackages = mdoTable.getTablePackages(false);
        lTablePackages.clear();
        IDatabaseSchema schema = this.getDatabaseSchema();
        if (schema == null) {
            ILibrary library = this.getLibrary();
            if (library != null) {
                library.saveToOMR(omr);
                lTablePackages.add(omr.acquireOMRObject(library));
            }
        } else {
            schema.saveToOMR(omr);
            lTablePackages.add(omr.acquireOMRObject(schema));
        }
        IPromptModelCollection[] models = this.m_lstDeletedModels.toArray(new IPromptModelCollection[this.m_lstDeletedModels.size()]);
        for (int i = 0; i < models.length; ++i) {
            models[i].dispose();
            models[i].deleteFromOMR(omr);
        }
        this.m_lstDeletedModels.clear();
        PhysicalTablePromptModelCollection options = this.getTableOptionCollection();
        if (options != null) {
            options.saveToOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.getTableOptionCollection() != null) {
            this.getTableOptionCollection().updateIDs(mapIDs);
        }
    }

    @Override
    public List getRefreshObjects() {
        ArrayList lCandidates = new ArrayList();
        lCandidates.addAll(this.m_lColumns);
        lCandidates.addAll(this.m_lIndexes);
        lCandidates.addAll(this.m_lKeys);
        lCandidates.addAll(this.m_lForeignKeys);
        return lCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndexesForDBMSType() {
        IDBMSType type = this.getDBMSType();
        if (!(type instanceof TERADATAType)) {
            this.startCompoundUndoable();
            try {
                IIndex[] indexes = this.getIndexes();
                for (int i = 0; i < indexes.length; ++i) {
                    if (!indexes[i].isPrimary()) continue;
                    indexes[i].setPrimary(false);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    protected String createWorkTableName() {
        return this.createWorkTableName(0);
    }

    protected String createWorkTableName(int offset) {
        return TableUtil.createUniqueTableName(offset);
    }

    protected void loadSASTableName(OMRAdapter omr) throws MdException, RemoteException {
        PhysicalTable mdoTable = (PhysicalTable)omr.acquireOMRObject(this);
        String sTableName = mdoTable.getSASTableName();
        if (sTableName.length() == 0) {
            String name = this.getName();
            sTableName = name.length() > 0 && name.length() <= 32 ? name.replaceAll(" ", "_") : this.createWorkTableName();
        }
        this.setSASTableName(sTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        this.m_bInLoad = true;
        try {
            super.loadFromOMR(omr);
            PhysicalTable mdoTable = (PhysicalTable)omr.acquireOMRObject(this);
            this.loadSASTableName(omr);
            this.setView(mdoTable.getMemberType().equals("VIEW"));
            this.loadLibrary(omr);
            String sCompress = this.loadStringOptionFromOMR(omr, PROPERTY_SET_ACCESS_WRITE, OPTION_COMPRESS, NO);
            this.setCompressed(VALUE_YES.equalsIgnoreCase(sCompress));
            String sEncrypt = this.loadStringOptionFromOMR(omr, PROPERTY_SET_ACCESS_WRITE, OPTION_ENCRYPT, NO);
            this.setEncrypted(VALUE_YES.equalsIgnoreCase(sEncrypt));
            this.setDBMSView(mdoTable.getIsDBMSView() == 1);
            this.m_lIndexes.loadFromOMR(omr, (List)mdoTable.getIndexes());
            this.m_lKeys.loadFromOMR(omr, (List)mdoTable.getUniqueKeys());
            this.m_lForeignKeys.loadFromOMR(omr, (List)mdoTable.getForeignKeys());
            this.updateIndexesForDBMSType();
            String locationType = this.loadStringOptionFromOMR(omr, PROPERTY_SET_LOCATION, OPTION_LOCATION_TYPE, "");
            if ("".equals(locationType) && this.getLibrary() != null) {
                this.setLocationType("Physical");
            } else if (Arrays.asList(this.getLocationTypes()).contains(locationType)) {
                this.setLocationType(locationType);
            } else {
                this.setLocationType(this.getDefaultLocationType());
            }
            PhysicalTablePromptModelCollection model = this.getTableOptionCollection();
            if (model != null) {
                model.loadFromOMR(omr);
            }
        }
        finally {
            this.m_bInLoad = false;
        }
        this.setChanged(false);
    }

    private void loadLibrary(OMRAdapter omr) throws MdException, RemoteException {
        PhysicalTable mdoTable = (PhysicalTable)omr.acquireOMRObject(this);
        RelationalSchema mdoSchema = mdoTable.getTablePackage();
        ILibrary library = null;
        if (mdoSchema instanceof SASLibrary) {
            library = (ILibrary)omr.acquireObject((Root)mdoSchema);
        } else if (mdoSchema instanceof DatabaseSchema) {
            this.setDatabaseSchema((IDatabaseSchema)omr.acquireObject((Root)mdoSchema));
            AssociationList libList = mdoSchema.getUsedByPackages();
            for (int i = 0; i < libList.size(); ++i) {
                DeployedDataPackage iLib = (DeployedDataPackage)libList.get(i);
                if (!(iLib instanceof SASLibrary)) continue;
                library = (ILibrary)omr.acquireObject((Root)iLib);
                break;
            }
        }
        this.setLibrary(library);
    }

    @Override
    public IServer getDatabaseServer() {
        ILibrary library = this.getLibraryForUseInJob();
        if (library != null) {
            return library.getDatabaseServer();
        }
        return null;
    }

    @Override
    public void delete() {
        this.m_lIndexes.delete();
        this.m_lKeys.delete();
        this.m_lForeignKeys.delete();
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        this.m_lIndexes.deleteFromOMR(omr);
        this.m_lKeys.deleteFromOMR(omr);
        this.m_lForeignKeys.deleteFromOMR(omr);
        if (this.m_optionModel != null) {
            this.m_optionModel.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        lAssociations.add("Indexes");
        lAssociations.add("UniqueKeys");
        lAssociations.add("ForeignKeys");
        lAssociations.add("TablePackage");
        lAssociations = new ArrayList<String>();
        lAssociations.add("UsedByPackages");
        map.put("DatabaseSchema", lAssociations);
        return map;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    private class IndexesList
    extends AbstractPrimaryModelList {
        public IndexesList() {
            super(BasePhysicalTable.this, new String[]{"PhysicalTable:IndexAdded", "PhysicalTable:IndexRemoved"}, 3, IIndex.class);
        }

        @Override
        protected void addTo(Object secondary) {
            IIndex index = (IIndex)secondary;
            index.setTable(BasePhysicalTable.this);
            index.addNotifyListener(BasePhysicalTable.this);
        }

        @Override
        protected void removeFrom(Object secondary) {
            IIndex index = (IIndex)secondary;
            index.setTable(null);
            index.removeNotifyListener(BasePhysicalTable.this);
        }
    }

    private class KeysList
    extends AbstractPrimaryModelList {
        public KeysList() {
            super(BasePhysicalTable.this, new String[]{"PhysicalTable:KeyAdded", "PhysicalTable:KeyRemoved"}, 3, IKey.class);
        }

        @Override
        protected void addTo(Object secondary) {
            IKey key = (IKey)secondary;
            key.setTable(BasePhysicalTable.this);
            key.addNotifyListener(BasePhysicalTable.this);
        }

        @Override
        protected void removeFrom(Object secondary) {
            IKey key = (IKey)secondary;
            key.setTable(null);
            key.removeNotifyListener(BasePhysicalTable.this);
        }
    }

    private class ForeignKeysList
    extends AbstractPrimaryModelList {
        public ForeignKeysList() {
            super(BasePhysicalTable.this, new String[]{"PhysicalTable:ForeignKeyAdded", "PhysicalTable:ForeignKeyRemoved"}, 3, IForeignKey.class);
        }

        @Override
        protected void addTo(Object secondary) {
            IForeignKey foreignKey = (IForeignKey)secondary;
            foreignKey.setTable(BasePhysicalTable.this);
            foreignKey.addNotifyListener(BasePhysicalTable.this);
        }

        @Override
        protected void removeFrom(Object secondary) {
            IForeignKey foreignKey = (IForeignKey)secondary;
            foreignKey.setTable(null);
            foreignKey.addNotifyListener(BasePhysicalTable.this);
        }
    }

    private class OptionCollectionUndoable
    extends AbstractUndoableEdit {
        private PhysicalTablePromptModelCollection m_oldModel;
        private PhysicalTablePromptModelCollection m_newModel;

        public OptionCollectionUndoable(PhysicalTablePromptModelCollection oldModel, PhysicalTablePromptModelCollection newModel) {
            this.m_oldModel = oldModel;
            this.m_newModel = newModel;
        }

        @Override
        public void undo() {
            super.undo();
            BasePhysicalTable.this.setTableOptionCollection(this.m_oldModel);
        }

        @Override
        public void redo() {
            super.redo();
            BasePhysicalTable.this.setTableOptionCollection(this.m_newModel);
        }
    }

    private class SetLocationTypeUndoable
    extends AbstractUndoableEdit {
        private String m_oldLocationType;
        private String m_newLocationType;

        public SetLocationTypeUndoable(String oldLocationType, String newLocationType) {
            this.m_oldLocationType = oldLocationType;
            this.m_newLocationType = newLocationType;
        }

        @Override
        public void undo() {
            super.undo();
            BasePhysicalTable.this.setLocationType(this.m_oldLocationType);
        }

        @Override
        public void redo() {
            super.redo();
            BasePhysicalTable.this.setLocationType(this.m_newLocationType);
        }
    }

    private class SetLibraryUndoable
    extends AbstractUndoableEdit {
        private ILibrary m_oldLibrary;
        private ILibrary m_newLibrary;

        public SetLibraryUndoable(ILibrary oldLibrary, ILibrary newLibrary) {
            this.m_oldLibrary = oldLibrary;
            this.m_newLibrary = newLibrary;
        }

        @Override
        public void undo() {
            super.undo();
            BasePhysicalTable.this.setLibrary(this.m_oldLibrary);
        }

        @Override
        public void redo() {
            super.redo();
            BasePhysicalTable.this.setLibrary(this.m_newLibrary);
        }

        @Override
        public void die() {
            this.m_oldLibrary = null;
            this.m_newLibrary = null;
            super.die();
        }
    }

    private class SetDataBaseSchemaUndoable
    extends AbstractUndoableEdit {
        private IDatabaseSchema m_oldSchema;
        private IDatabaseSchema m_newSchema;

        public SetDataBaseSchemaUndoable(IDatabaseSchema oldSchema, IDatabaseSchema newSchema) {
            this.m_oldSchema = oldSchema;
            this.m_newSchema = newSchema;
        }

        @Override
        public void undo() {
            super.undo();
            BasePhysicalTable.this.setDatabaseSchema(this.m_oldSchema);
        }

        @Override
        public void redo() {
            super.redo();
            BasePhysicalTable.this.setDatabaseSchema(this.m_newSchema);
        }
    }

    private class SetDBMSViewUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldDBMSView;
        private boolean m_newDBMSView;

        public SetDBMSViewUndoable(boolean oldDBMSView, boolean newDBMSView) {
            this.m_oldDBMSView = oldDBMSView;
            this.m_newDBMSView = newDBMSView;
        }

        @Override
        public void undo() {
            super.undo();
            BasePhysicalTable.this.setDBMSView(this.m_oldDBMSView);
        }

        @Override
        public void redo() {
            super.redo();
            BasePhysicalTable.this.setDBMSView(this.m_newDBMSView);
        }
    }

    private class SetEncryptedUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldEncrypted;
        private boolean m_newEncrypted;

        public SetEncryptedUndoable(boolean oldEncrypted, boolean newEncrypted) {
            this.m_oldEncrypted = oldEncrypted;
            this.m_newEncrypted = newEncrypted;
        }

        @Override
        public void undo() {
            super.undo();
            BasePhysicalTable.this.setEncrypted(this.m_oldEncrypted);
        }

        @Override
        public void redo() {
            super.redo();
            BasePhysicalTable.this.setEncrypted(this.m_newEncrypted);
        }
    }

    private class SetCompressedUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldCompressed;
        private boolean m_newCompressed;

        public SetCompressedUndoable(boolean oldCompressed, boolean newCompressed) {
            this.m_oldCompressed = oldCompressed;
            this.m_newCompressed = newCompressed;
        }

        @Override
        public void undo() {
            super.undo();
            BasePhysicalTable.this.setCompressed(this.m_oldCompressed);
        }

        @Override
        public void redo() {
            super.redo();
            BasePhysicalTable.this.setCompressed(this.m_newCompressed);
        }
    }

    private class SetSASTableNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldSASTableName;
        private String m_newSASTableName;

        public SetSASTableNameUndoable(String oldSASTableName, String newSASTableName) {
            this.m_oldSASTableName = oldSASTableName;
            this.m_newSASTableName = newSASTableName;
        }

        @Override
        public void undo() {
            super.undo();
            BasePhysicalTable.this.setSASTableName(this.m_oldSASTableName);
        }

        @Override
        public void redo() {
            super.redo();
            BasePhysicalTable.this.setSASTableName(this.m_newSASTableName);
        }
    }
}

