/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IFolder;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseFolder
extends AbstractPersistableObject
implements IFolder {
    private PathUrl m_sbipURL;

    public BaseFolder(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getOMRType() {
        return "Tree";
    }

    public String getPublicType() {
        return "Folder";
    }

    public UsageVersion getArchitectureVersionNumber() {
        return Folder.CURRENT_VERSION;
    }

    private void setPathUrl(PathUrl pathUrl) {
        if (this.m_sbipURL == pathUrl) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSBIPUrlUndoable(this.m_sbipURL, pathUrl));
        }
        this.m_sbipURL = pathUrl;
        this.fireModelChangedEvent("IFolder:SBIPUrlChanged", null);
    }

    @Override
    public PathUrl getPathUrl() {
        return this.m_sbipURL;
    }

    @Override
    public String getURLtoFolder() {
        String url = "";
        PathUrl pathurl = this.getPathUrl();
        if (pathurl != null) {
            PathUrl upURL = (PathUrl)pathurl.clone();
            upURL.setType("");
            url = upURL.getAbsolutePath();
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Tree mdoTree = (Tree)omr.acquireOMRObject(this);
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            ChildServerInterface transaction = server.newChild(true);
            try {
                PathUrl url;
                MetadataInterface metadata = transaction.fetch(mdoTree.getFQID() + "/" + this.getOMRType(), true);
                if (metadata != null && (url = metadata.getPathUrl()) != null) {
                    this.setPathUrl(url);
                }
            }
            finally {
                transaction.destroy();
            }
        }
        catch (ServiceException exc) {
            throw new MdException((Throwable)exc);
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    private class SetSBIPUrlUndoable
    extends AbstractUndoableEdit {
        private PathUrl m_bOldURL;
        private PathUrl m_bNewURL;

        public SetSBIPUrlUndoable(PathUrl bOldURL, PathUrl bNewURL) {
            this.m_bOldURL = bOldURL;
            this.m_bNewURL = bNewURL;
        }

        @Override
        public void undo() {
            super.undo();
            BaseFolder.this.setPathUrl(this.m_bOldURL);
        }

        @Override
        public void redo() {
            super.redo();
            BaseFolder.this.setPathUrl(this.m_bNewURL);
        }
    }
}

