/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.IFile;
import com.sas.etl.models.data.impl.RB;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.UndoException;
import com.sas.etl.models.other.IServer;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseFile
extends AbstractPersistableObject
implements IFile {
    private String m_sFileName = "";
    private IServer m_server;
    private String m_sTextRole = "";
    private String m_sTextType = "";
    private String m_sFileExtension = "";
    private WsAppServer m_appServer;

    public BaseFile(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void setFileName(String sFileName) {
        if (this.m_sFileName.equals(sFileName)) {
            return;
        }
        if (sFileName == null) {
            throw new NullPointerException("file name can't be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFileNameUndoable(this.m_sFileName, sFileName));
        }
        this.m_sFileName = sFileName;
        this.fireModelChangedEvent("IFile:FileNameChanged", null);
    }

    @Override
    public String getFileName() {
        return this.m_sFileName;
    }

    @Override
    public String getPath() {
        String sPath = "";
        try {
            WsAppServer server = this.getAppServer();
            if (server != null) {
                String[] path = server.getSplitFileName(this.m_sFileName);
                sPath = path[0];
            }
        }
        catch (WsAppServerFailException wsAppServerFailException) {
        }
        catch (GenericError genericError) {
        }
        catch (ServerException serverException) {
            // empty catch block
        }
        return sPath;
    }

    @Override
    public String getShortFileName() {
        String sShortFileName = "";
        try {
            WsAppServer server = this.getAppServer();
            if (server != null) {
                String[] path = server.getSplitFileName(this.m_sFileName);
                sShortFileName = path[1];
            }
        }
        catch (WsAppServerFailException wsAppServerFailException) {
        }
        catch (GenericError genericError) {
        }
        catch (ServerException serverException) {
            // empty catch block
        }
        return sShortFileName;
    }

    @Override
    public IServer getServer() {
        return this.m_server;
    }

    @Override
    public void setServer(IServer server) {
        if (this.m_server == server) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetServerUndoable(this.m_server, server));
        }
        this.m_server = server;
        if (this.m_appServer != null) {
            this.m_appServer.dispose();
            this.m_appServer = null;
        }
        this.fireModelChangedEvent("IFile:ServerChanged", this.m_server);
    }

    private WsAppServer getAppServer() throws ServerException {
        if (this.m_appServer == null && this.m_server != null) {
            try {
                this.m_appServer = WsAppServer.createAppServer((String)this.m_server.getID());
                this.m_appServer.open();
            }
            catch (WsAppServerFailException ex) {
                this.m_appServer = null;
                throw new ServerException(ex);
            }
        }
        return this.m_appServer;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_appServer != null) {
            this.m_appServer.dispose();
            this.m_appServer = null;
        }
    }

    @Override
    public String getTextRole() {
        return this.m_sTextRole;
    }

    @Override
    public void setTextRole(String role) {
        if (this.m_sTextRole.equals(role)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTextRoleUndoable(this.m_sTextRole, role));
        }
        this.m_sTextRole = role;
        this.fireModelChangedEvent("IFile:RoleChanged", this.m_sTextRole);
    }

    @Override
    public String getTextType() {
        return this.m_sTextType;
    }

    @Override
    public void setTextType(String type) {
        if (this.m_sTextType.equals(type)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTextTypeUndoable(this.m_sTextType, type));
        }
        this.m_sTextType = type;
        this.fireModelChangedEvent("IFile:TypeChanged", this.m_sTextType);
    }

    @Override
    public void setFileExtension(String sFileExtension) {
        if (this.m_sFileExtension.equals(sFileExtension)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFileExtensionUndoable(this.m_sFileExtension, sFileExtension));
        }
        this.m_sFileExtension = sFileExtension;
        this.fireModelChangedEvent("IFile:FileExtensionChanged", null);
    }

    protected void loadServerFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        File mdoFile = (File)omr.acquireOMRObject(this);
        AssociationList comps = mdoFile.getDeployedComponents();
        if (!comps.isEmpty()) {
            DeployedComponent deployedComponent = (DeployedComponent)comps.get(0);
            IServer server = (IServer)omr.acquireObject((Root)deployedComponent);
            this.setServer(server);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.loadServerFromOMR(omr);
        File mdoFile = (File)omr.acquireOMRObject(this);
        this.setFileName(mdoFile.getFileName());
        this.setFileExtension(mdoFile.getFileExtension());
        this.setTextRole(mdoFile.getTextRole());
        this.setTextType(mdoFile.getTextType());
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        File mdoFile = (File)omr.acquireOMRObject(this);
        mdoFile.setFileExtension(this.m_sFileExtension);
        mdoFile.setFileName(this.m_sFileName);
        mdoFile.setTextRole(this.m_sTextRole);
        mdoFile.setTextType(this.m_sTextType);
        this.saveServerToOMR(omr);
        this.setChanged(false);
    }

    protected void saveServerToOMR(OMRAdapter omr) throws MdException, RemoteException {
        File mdoFile = (File)omr.acquireOMRObject(this);
        AssociationList depComponents = mdoFile.getDeployedComponents(false);
        depComponents.clear();
        IServer server = this.getServer();
        if (server != null) {
            depComponents.add(omr.acquireOMRObject(server));
        }
    }

    @Override
    public String getOMRType() {
        return "File";
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
        }
        lAssociations.add("FileRefs");
        lAssociations.add("DeployedComponents");
        map.put(this.getOMRType(), lAssociations);
        return map;
    }

    @Override
    public boolean isComplete() {
        if (!super.isComplete()) {
            return false;
        }
        String filename = this.getFileName();
        if (filename == null || filename.length() == 0) {
            return false;
        }
        return this.getServer() != null;
    }

    @Override
    public List getReasonsIncomplete() {
        String filename;
        List reasons = super.getReasonsIncomplete();
        if (this.getServer() == null) {
            reasons.add(MessageFormat.format(RB.getStringResource("BaseFile.NoServer.msg.txt"), this.getName()));
        }
        if ((filename = this.getFileName()) == null || filename.length() == 0) {
            reasons.add(MessageFormat.format(RB.getStringResource("BaseFile.NoFile.msg.txt"), this.getName()));
        }
        return reasons;
    }

    @Override
    public void setCode(String sCode) throws ServerException {
        String filename;
        if (sCode == null) {
            sCode = "";
        }
        boolean fileExist = this.doesFileExist();
        String oldCode = "";
        if (fileExist) {
            oldCode = this.getCode();
        }
        if (fileExist && sCode.equalsIgnoreCase(oldCode)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCodeUndoable(oldCode, sCode));
        }
        if ((filename = this.getFileName()) == null || filename.length() == 0) {
            throw new UnsupportedOperationException(MessageFormat.format(RB.getStringResource("BaseFile.NoFile.msg.txt"), this.getName()));
        }
        IServer server = this.getServer();
        if (server == null) {
            throw new UnsupportedOperationException(MessageFormat.format(RB.getStringResource("BaseFile.NoServer.msg.txt"), this.getFileName()));
        }
        try {
            this.getAppServer().writeFile(sCode, filename);
        }
        catch (GenericError ex) {
            throw new ServerException(ex);
        }
        catch (WsAppServerFailException ex) {
            throw new ServerException(ex);
        }
        this.fireModelChangedEvent("CodeSource:CodeChanged", null);
    }

    @Override
    public boolean doesFileExist() throws ServerException {
        boolean exist = false;
        IServer server = this.getServer();
        if (server == null) {
            throw new ServerException(MessageFormat.format(RB.getStringResource("BaseFile.NoServer.msg.txt"), this.getFileName()));
        }
        try {
            exist = this.getAppServer().doesFileExist(this.getFileName());
        }
        catch (GenericError ex) {
            throw new ServerException(ex);
        }
        catch (WsAppServerFailException ex) {
            throw new ServerException(ex);
        }
        return exist;
    }

    @Override
    public String getCode() throws ServerException {
        String filename = this.getFileName();
        IServer server = this.getServer();
        if (server == null) {
            throw new ServerException(MessageFormat.format(RB.getStringResource("BaseFile.NoServer.msg.txt"), this.getFileName()));
        }
        try {
            return this.getAppServer().readFile(filename);
        }
        catch (GenericError ex) {
            throw new ServerException(ex);
        }
        catch (WsAppServerFailException ex) {
            throw new ServerException(ex);
        }
    }

    private class SetFileNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldFileName;
        private String m_newFileName;

        public SetFileNameUndoable(String oldFileName, String newFileName) {
            this.m_oldFileName = oldFileName;
            this.m_newFileName = newFileName;
        }

        @Override
        public void undo() {
            super.undo();
            BaseFile.this.setFileName(this.m_oldFileName);
        }

        @Override
        public void redo() {
            super.redo();
            BaseFile.this.setFileName(this.m_newFileName);
        }
    }

    private class SetServerUndoable
    extends AbstractUndoableEdit {
        private IServer m_serverOld;
        private IServer m_serverNew;

        public SetServerUndoable(IServer serverOld, IServer serverNew) {
            this.m_serverOld = serverOld;
            this.m_serverNew = serverNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseFile.this.setServer(this.m_serverOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseFile.this.setServer(this.m_serverNew);
        }
    }

    private class SetTextRoleUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetTextRoleUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseFile.this.setTextRole(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseFile.this.setTextRole(this.m_newValue);
        }
    }

    private class SetTextTypeUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetTextTypeUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseFile.this.setTextType(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseFile.this.setTextType(this.m_newValue);
        }
    }

    private class SetFileExtensionUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetFileExtensionUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseFile.this.setFileExtension(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseFile.this.setFileExtension(this.m_newValue);
        }
    }

    private class SetCodeUndoable
    extends AbstractUndoableEdit {
        private String m_oldCode;
        private String m_newCode;

        public SetCodeUndoable(String oldCode, String newCode) {
            this.m_oldCode = oldCode;
            this.m_newCode = newCode;
        }

        @Override
        public void undo() {
            super.undo();
            try {
                BaseFile.this.setCode(this.m_oldCode);
            }
            catch (ServerException e) {
                throw new UndoException(e);
            }
        }

        @Override
        public void redo() {
            super.redo();
            try {
                BaseFile.this.setCode(this.m_newCode);
            }
            catch (ServerException e) {
                throw new UndoException(e);
            }
        }
    }
}

