/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.externalfile.IDelimitedExternalFile;
import com.sas.etl.models.data.externalfile.IFixedWidthExternalFile;
import com.sas.etl.models.data.externalfile.IFormatFileColumnImport;
import com.sas.etl.models.data.externalfile.IStructuredExternalFile;
import com.sas.etl.models.data.externalfile.impl.DelimitedExternalFile;
import com.sas.etl.models.data.impl.AbstractTable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IFTPServer;
import com.sas.etl.models.other.IFileAccessServer;
import com.sas.etl.models.other.IHTTPServer;
import com.sas.etl.models.other.IHadoopServer;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.services.information.metadata.OMRExternalFile;
import com.sas.util.UsageVersion;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import org.apache.commons.configuration.ConfigurationException;

public class BaseExternalTable
extends AbstractTable
implements IExternalTable {
    private static final String FORMATFILE = "FormatFile";
    private static final String MISSING_VALUE_VARIABLE = "missval";
    private IStructuredExternalFile m_file;
    private IFormatFileColumnImport m_formatFileColumnImport;
    private static final String USERWRITTENSOURCECODE = "UserWrittenSourceCode";
    private IUserWrittenCodeContainer m_userWrittenFile = this.getModel().getObjectFactory().createUserWrittenHelper(this);
    private boolean m_bUserWritten = false;
    private boolean m_headerLineOutputFile;
    private boolean m_bIsImporting;

    public BaseExternalTable(String id, IModel model) {
        super(id, model);
        this.m_userWrittenFile.setContainerOMRType("ClassifierMap");
        this.m_userWrittenFile.setContainerRole(USERWRITTENSOURCECODE);
        this.m_userWrittenFile.setName(USERWRITTENSOURCECODE);
        this.m_userWrittenFile.setActiveFlagLocation(0);
        this.m_file = new DelimitedExternalFile(this.createIDForNewObject(), model);
    }

    @Override
    public String getOMRType() {
        return "ExternalTable";
    }

    @Override
    public String getPublicType() {
        return "ExternalFile";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return OMRExternalFile.CURRENT_VERSION;
    }

    @Override
    public List getReasonsIncomplete() {
        return new ArrayList();
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("TransformationTargets");
            lAssociations.add("TransformationSources");
            lAssociations.add("OwningFile");
            lAssociations.add("TargetTransformations");
            map.put(this.getOMRType(), lAssociations);
        } else {
            lAssociations.add("TransformationTargets");
            lAssociations.add("TransformationSources");
            lAssociations.add("OwningFile");
            lAssociations.add("TargetTransformations");
        }
        return map;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public IStructuredExternalFile getFile() {
        return this.m_file;
    }

    @Override
    public void setFile(IStructuredExternalFile file) {
        if (this.m_file == file) {
            return;
        }
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        this.m_file = file;
    }

    @Override
    public IServer getServer() {
        IStructuredExternalFile file = this.getFile();
        if (file != null) {
            return file.getServer();
        }
        return null;
    }

    public void setServer(IServer server) {
        IStructuredExternalFile file = this.getFile();
        if (file != null) {
            file.setServer(server);
        }
    }

    @Override
    public void setFormatFileColumnImport(IFormatFileColumnImport formatFileImport) {
        if (this.m_formatFileColumnImport == formatFileImport) {
            return;
        }
        if (this.m_formatFileColumnImport != null) {
            this.addToDeletedObjects(this.m_formatFileColumnImport);
        }
        if (formatFileImport != null) {
            this.removeFromDeletedObjects(formatFileImport);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFormatFileColumnUndoable(this.m_formatFileColumnImport, formatFileImport));
        }
        this.m_formatFileColumnImport = formatFileImport;
        this.fireModelChangedEvent("IExternalTable:FormatFileColumnImportChanged", this.m_formatFileColumnImport);
    }

    @Override
    public IFormatFileColumnImport getFormatFileColumnImport() {
        return this.m_formatFileColumnImport;
    }

    @Override
    public boolean isStructuredExternalFile() {
        return this.m_file instanceof IStructuredExternalFile;
    }

    @Override
    public void setCaseSensitive(boolean bCaseChars) {
        if (this.m_file instanceof IStructuredExternalFile) {
            this.m_file.setCaseSensitive(bCaseChars);
        }
    }

    @Override
    public void setSpecialCharacters(boolean bSpecialChars) {
        if (this.m_file instanceof IStructuredExternalFile) {
            this.m_file.setSpecialCharacters(bSpecialChars);
        }
    }

    @Override
    public void setView(boolean bView) {
        if (this.m_file instanceof IStructuredExternalFile) {
            this.m_file.setView(bView);
        }
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged() || this.isUsingUserWrittenCode() && this.m_userWrittenFile.isChanged()) {
            return true;
        }
        return this.m_file.isChanged() || this.m_formatFileColumnImport != null && this.m_formatFileColumnImport.isChanged();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.m_file.isCaseSensitive();
    }

    @Override
    public boolean isSpecialCharacters() {
        return this.m_file.isSpecialCharacters();
    }

    @Override
    public boolean isView() {
        return this.m_file.isView();
    }

    @Override
    public boolean isDelimited() {
        return this.m_file instanceof IDelimitedExternalFile;
    }

    @Override
    public boolean isFixedWidth() {
        return this.m_file instanceof IFixedWidthExternalFile;
    }

    @Override
    public boolean isImporting() {
        return this.m_bIsImporting;
    }

    @Override
    public void setIsImporting(boolean bIsImporting) {
        this.m_bIsImporting = bIsImporting;
    }

    @Override
    public boolean isUsingUserWrittenCode() {
        return this.m_bUserWritten;
    }

    public void setUserWrittenExternalFile(boolean userWritten) {
        if (this.m_bUserWritten == userWritten) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new UserWrittenExternalFileUndoable(this.m_bUserWritten, userWritten));
        }
        this.m_bUserWritten = userWritten;
        this.fireModelChangedEvent("IExternalTable:UserWrittenExternalFileChanged", null);
    }

    @Override
    public String getInfileStatement() throws BadServerDefinitionException {
        return this.getInfileStatement(null);
    }

    @Override
    public String getInfileStatement(Object additionalData) throws BadServerDefinitionException {
        Integer IntegerVal;
        int numObs;
        int firstObs;
        String sVal;
        IFileAccessServer accessServer;
        if (!this.isStructuredExternalFile()) {
            return null;
        }
        IStructuredExternalFile structuredFile = this.m_file;
        String indent = "       ";
        StringBuffer infileString = new StringBuffer();
        String quoteValue = "'";
        if (structuredFile.isDoubleQuoteFilename()) {
            quoteValue = "\"";
        }
        if ((accessServer = this.m_file.getAccessServer()) instanceof IHTTPServer) {
            infileString.append("infile ").append(((IHTTPServer)accessServer).getServerOptions(LibraryUtil.isApplicationUsingAuthDomainForPasswords(), true, this.m_file.getFileName()));
        } else {
            StringBuffer filename = new StringBuffer();
            if (structuredFile.isNoQuoteFilename()) {
                filename.append(this.m_file.getFileName());
            } else {
                filename.append(quoteValue).append(this.m_file.getFileName()).append(quoteValue);
            }
            if (accessServer instanceof IFTPServer) {
                infileString.append("infile ").append(filename.toString()).append(" ").append(((IFTPServer)accessServer).getServerOptions(LibraryUtil.isApplicationUsingAuthDomainForPasswords(), true));
            } else if (accessServer instanceof IHadoopServer) {
                infileString.append("infile ").append(filename.toString()).append(" ").append(((IHadoopServer)accessServer).getServerOptions(LibraryUtil.isApplicationUsingAuthDomainForPasswords(), true, (String)additionalData));
                if (structuredFile.isDirectory()) {
                    infileString.append(" concat");
                }
            } else {
                infileString.append("infile ").append(filename.toString());
            }
        }
        if (structuredFile.getRecordLength() > 0) {
            infileString.append("\n").append(indent).append("lrecl = ").append(this.m_file.getRecordLength());
        }
        if (this.isDelimited()) {
            if (((IDelimitedExternalFile)this.m_file).getOverrideDelimiter().length() == 0) {
                infileString.append("\n").append(indent).append("delimiter = '").append(((IDelimitedExternalFile)this.m_file).getDelimiters()).append("'");
            } else {
                infileString.append("\n").append(indent).append("delimiter = ").append(((IDelimitedExternalFile)this.m_file).getOverrideDelimiter());
            }
            if (!((IDelimitedExternalFile)this.m_file).isConsecutiveDelimiterSkippingEnabled()) {
                infileString.append("\n").append(indent).append("dsd");
            }
            if (!((IDelimitedExternalFile)this.m_file).isRecordWrappingEnabled()) {
                infileString.append("\n").append(indent).append("missover");
            }
        } else {
            if (((IFixedWidthExternalFile)this.m_file).isPadColumnValuesEnabled()) {
                infileString.append("\n").append(indent).append("pad");
            }
            if (((IFixedWidthExternalFile)this.m_file).isTruncoverEnabled()) {
                infileString.append("\n").append(indent).append("truncover");
            }
        }
        if ((sVal = structuredFile.getStartingRecordNumber()).length() == 0) {
            firstObs = 0;
        } else {
            Integer IntegerVal2 = Integer.valueOf(structuredFile.getStartingRecordNumber());
            firstObs = IntegerVal2;
        }
        if (firstObs > 0) {
            infileString.append("\n").append(indent).append("firstobs = ").append(firstObs);
        }
        if ((sVal = structuredFile.getNumberOfRecords()).length() > 0 && (numObs = (IntegerVal = Integer.valueOf(structuredFile.getNumberOfRecords())).intValue()) > 0) {
            int lastObs = numObs + firstObs - 1;
            infileString.append("\n").append(indent).append("obs = " + lastObs);
        }
        if (structuredFile.getInfileEncodingOptions().length() > 0) {
            infileString.append("\n").append(indent).append("encoding = ").append(this.getInfileEncodingTextQuoted());
        }
        if (structuredFile.getAdditionalInfileOptions().length() > 0) {
            infileString.append("\n").append(indent).append(structuredFile.getAdditionalInfileOptions());
        }
        infileString.append("; \n");
        return infileString.toString();
    }

    private String getInfileStatement(String additionalInfileOptions, Object additionalData) throws BadServerDefinitionException {
        Integer IntegerVal;
        int numObs;
        int firstObs;
        String sVal;
        IFileAccessServer accessServer;
        if (!this.isStructuredExternalFile()) {
            return null;
        }
        IStructuredExternalFile structuredFile = this.m_file;
        String indent = "       ";
        StringBuffer infileString = new StringBuffer();
        String quoteValue = "'";
        if (structuredFile.isDoubleQuoteFilename()) {
            quoteValue = "\"";
        }
        if ((accessServer = this.m_file.getAccessServer()) instanceof IHTTPServer) {
            infileString.append("infile ").append(((IHTTPServer)accessServer).getServerOptions(LibraryUtil.isApplicationUsingAuthDomainForPasswords(), true, this.m_file.getFileName()));
        } else {
            StringBuffer filename = new StringBuffer();
            if (structuredFile.isNoQuoteFilename()) {
                filename.append(this.m_file.getFileName());
            } else {
                filename.append(quoteValue).append(this.m_file.getFileName()).append(quoteValue);
            }
            if (accessServer instanceof IFTPServer) {
                infileString.append("infile ").append(filename.toString()).append(" ").append(((IFTPServer)accessServer).getServerOptions(LibraryUtil.isApplicationUsingAuthDomainForPasswords(), true));
            }
            if (accessServer instanceof IHadoopServer) {
                infileString.append("infile ").append(filename.toString()).append(" ").append(((IHadoopServer)accessServer).getServerOptions(LibraryUtil.isApplicationUsingAuthDomainForPasswords(), true, (String)additionalData));
            } else {
                infileString.append("infile ").append(filename.toString());
            }
        }
        if (structuredFile.getRecordLength() > 0) {
            infileString.append("\n").append(indent).append("lrecl = ").append(this.m_file.getRecordLength());
        }
        if (this.isDelimited()) {
            if (((IDelimitedExternalFile)this.m_file).getOverrideDelimiter().length() == 0) {
                infileString.append("\n").append(indent).append("delimiter = '").append(((IDelimitedExternalFile)this.m_file).getDelimiters()).append("'");
            } else {
                infileString.append("\n").append(indent).append("delimiter = ").append(((IDelimitedExternalFile)this.m_file).getOverrideDelimiter());
            }
            if (!((IDelimitedExternalFile)this.m_file).isConsecutiveDelimiterSkippingEnabled()) {
                infileString.append("\n").append(indent).append("dsd");
            }
            if (!((IDelimitedExternalFile)this.m_file).isRecordWrappingEnabled()) {
                infileString.append("\n").append(indent).append("missover");
            }
        } else {
            if (((IFixedWidthExternalFile)this.m_file).isPadColumnValuesEnabled()) {
                infileString.append("\n").append(indent).append("pad");
            }
            if (((IFixedWidthExternalFile)this.m_file).isTruncoverEnabled()) {
                infileString.append("\n").append(indent).append("truncover");
            }
        }
        if ((sVal = structuredFile.getStartingRecordNumber()).length() == 0) {
            firstObs = 0;
        } else {
            Integer IntegerVal2 = Integer.valueOf(structuredFile.getStartingRecordNumber());
            firstObs = IntegerVal2;
        }
        if (firstObs > 0) {
            infileString.append("\n").append(indent).append("firstobs = ").append(firstObs);
        }
        if ((sVal = structuredFile.getNumberOfRecords()).length() > 0 && (numObs = (IntegerVal = Integer.valueOf(structuredFile.getNumberOfRecords())).intValue()) > 0) {
            int lastObs = numObs + firstObs - 1;
            infileString.append("\n").append(indent).append("obs = " + lastObs);
        }
        if (structuredFile.getInfileEncodingOptions().length() > 0) {
            infileString.append("\n").append(indent).append("encoding = ").append(this.getInfileEncodingTextQuoted());
        }
        if (structuredFile.getAdditionalInfileOptions().length() > 0) {
            infileString.append("\n").append(indent).append(structuredFile.getAdditionalInfileOptions());
        }
        if (additionalInfileOptions != null && additionalInfileOptions.trim().length() > 0) {
            infileString.append("\n").append(indent).append(additionalInfileOptions);
        }
        infileString.append("; \n");
        return infileString.toString();
    }

    @Override
    public String getInfileEncodingTextQuoted() {
        String encodingVal = "";
        encodingVal = this.m_file.getInfileEncodingOptions();
        if (encodingVal.length() == 0) {
            return encodingVal;
        }
        String doubleQuote = "\"";
        String singleQuote = "'";
        if (!encodingVal.startsWith(doubleQuote) && !encodingVal.startsWith(singleQuote)) {
            encodingVal = "\"" + encodingVal + "\"";
        }
        return encodingVal;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.m_file.saveToOMR(omr);
        ExternalTable mdoExtTable = (ExternalTable)omr.acquireOMRObject(this);
        File mdoFile = (File)omr.acquireOMRObject(this.m_file);
        AssociationList mdoFiles = mdoExtTable.getOwningFiles(false);
        mdoFiles.clear();
        mdoFiles.add((Object)mdoFile);
        IFormatFileColumnImport columnImport = this.getFormatFileColumnImport();
        if (columnImport != null) {
            columnImport.saveToOMR(omr);
            AssociationList targetTrans = mdoExtTable.getTargetTransformations(false);
            targetTrans.add(omr.acquireOMRObject(columnImport));
        }
        if (this.isUsingUserWrittenCode()) {
            this.m_userWrittenFile.setName(USERWRITTENSOURCECODE);
            this.m_userWrittenFile.saveToOMR(omr);
            AbstractTransformation userWrittenContainer = this.m_userWrittenFile.getOMRContainer(omr);
            if (userWrittenContainer != null) {
                userWrittenContainer.getTransformationSources(false).clear();
                AssociationList targetTrans = mdoExtTable.getTargetTransformations();
                int size = targetTrans.size();
                for (int i = 0; i < size; ++i) {
                    Root mdObject = (Root)targetTrans.get(i);
                    if (!(mdObject instanceof File)) continue;
                    mdObject.delete();
                    break;
                }
                if (!targetTrans.contains(userWrittenContainer)) {
                    targetTrans.add(userWrittenContainer);
                }
            }
        }
        this.setChanged(false);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_formatFileColumnImport != null) {
            this.m_formatFileColumnImport.deleteFromOMR(omr);
        }
        this.m_file.deleteFromOMR(omr);
        if (this.m_userWrittenFile != null) {
            this.m_userWrittenFile.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_file != null) {
            this.m_file.updateIDs(mapIDs);
        }
        if (this.m_formatFileColumnImport != null) {
            this.m_formatFileColumnImport.updateIDs(mapIDs);
        }
        if (this.m_userWrittenFile != null) {
            this.m_userWrittenFile.updateIds(mapIDs);
        }
    }

    protected void saveQuotationSettingsToOMR(OMRAdapter omr) throws RemoteException, MdException {
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IOMRPersistable obj;
        super.loadFromOMR(omr);
        ExternalTable mdoExternalTable = (ExternalTable)omr.acquireOMRObject(this);
        File omrFile = mdoExternalTable.getOwningFile();
        if (omrFile.getName() != null && (obj = omr.acquireObject((Root)omrFile)) instanceof IStructuredExternalFile) {
            this.setFile((IStructuredExternalFile)obj);
        }
        this.setUserWrittenExternalFile(omrFile != null && omrFile.getFileRefs().isEmpty());
        if (this.isUsingUserWrittenCode()) {
            boolean conversion = false;
            AssociationList targetTrans = mdoExternalTable.getTargetTransformations();
            int size = targetTrans.size();
            for (int i = 0; i < size; ++i) {
                Root mdObject = (Root)targetTrans.get(i);
                if (mdObject instanceof File) {
                    this.m_userWrittenFile.setUserWrittenSourceCode((ICodeSource)omr.acquireObject(mdObject));
                    conversion = true;
                    continue;
                }
                if (!(mdObject instanceof ClassifierMap) || !USERWRITTENSOURCECODE.equals(((ClassifierMap)mdObject).getTransformRole())) continue;
                this.m_userWrittenFile.setContainerId(mdObject.getFQID());
                ClassifierMap cMap = (ClassifierMap)mdObject;
                AssociationList srcCode = cMap.getTransformationSources();
                int srcSize = srcCode.size();
                if (srcSize <= 0 || !(srcCode.get(0) instanceof Text)) continue;
                Text userWritten = (Text)srcCode.get(0);
                userWritten.setTextRole("SAS code");
                this.m_userWrittenFile.setUserWrittenSourceCode((ICodeSource)omr.acquireObject((Root)userWritten));
                conversion = true;
            }
            if (!conversion) {
                this.m_userWrittenFile.loadFromOMR(omr);
                this.m_userWrittenFile.setChanged(false);
            } else {
                this.m_userWrittenFile.setChanged(true);
            }
        }
        IFormatFileColumnImport columnImport = null;
        AssociationList transList = mdoExternalTable.getTargetTransformations();
        if (!transList.isEmpty()) {
            for (int i = 0; i < transList.size(); ++i) {
                ClassifierMap mdoCM;
                String role;
                CMetadata cmd = (CMetadata)transList.get(i);
                if (!cmd.getCMetadataType().equals("ClassifierMap") || !FORMATFILE.equals(role = (mdoCM = (ClassifierMap)transList.get(i)).getTransformRole())) continue;
                columnImport = (IFormatFileColumnImport)omr.acquireObject((Root)mdoCM);
            }
        }
        this.setFormatFileColumnImport(columnImport);
        this.setChanged(false);
    }

    @Override
    protected void loadQuotationSettings(OMRAdapter omr) throws MdException, RemoteException {
        ExternalTable extTable = (ExternalTable)omr.acquireOMRObject(this);
        File omrFile = extTable.getOwningFile();
        if (omrFile != null) {
            IOMRPersistable obj;
            if ("".equals(omrFile.getName())) {
                omrFile.setName("USERWRITTEN");
            }
            if ((obj = omr.acquireObject((Root)omrFile)) instanceof IStructuredExternalFile) {
                this.setFile((IStructuredExternalFile)obj);
            }
        }
    }

    private void deleteProperty(OMRAdapter omr, PropertySet pSet, String propertyName) throws RemoteException, MdException {
        AssociationList props = pSet.getSetProperties();
        int propSize = props.size();
        for (int j = 0; j < propSize; ++j) {
            Property prop = (Property)props.get(j);
            if (!prop.getName().equals(propertyName)) continue;
            omr.deleteOMRObject(prop.getFQID(), prop.getCMetadataType());
            break;
        }
    }

    @Override
    public String getFullNameQuotedAsNeeded(ICodeSegment codeSegment) {
        return this.getFullName();
    }

    @Override
    public String getFullNameQuotedAsNeeded(ICodeSegment codeSegment, boolean passthru) {
        return this.getFullName();
    }

    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean envQuoting) {
        return this.getFullName();
    }

    @Override
    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean envQuoting, boolean passthru) {
        return this.getFullName();
    }

    @Override
    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean envQuoting, boolean passthru, boolean quotes, String prefix) {
        return this.getFullName();
    }

    @Override
    public String getFullName() {
        String location = "";
        IStructuredExternalFile file = this.getFile();
        if (file != null) {
            location = file.getFileName();
        }
        return location;
    }

    @Override
    public IUserWrittenCodeContainer getUserWrittenCode() {
        return this.m_userWrittenFile;
    }

    @Override
    public void setUserWrittenCode(ICodeSource code) {
        if (this.m_userWrittenFile != null) {
            this.m_userWrittenFile.setUserWrittenSourceCode(code);
        }
    }

    @Override
    public void setUseUserWrittenCode(boolean bUseUserWrittenCode) {
    }

    protected ICodeSegment getExternalTableSetupCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getGeneratedDefaultParameterCode(codeSegment);
    }

    @Override
    public StringBuffer getDataStepCodeToCreateFile(ICodeGenerationEnvironment environment, String sourceTableName, String sourceTableOptions, String additionalFileOptions) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        CodeSegment codeSegment = new CodeSegment(environment, this);
        this.getExternalTableSetupCode(codeSegment);
        if (this.isUsingUserWrittenCode()) {
            IUserWrittenCodeContainer userWrittenCode = this.getUserWrittenCode();
            if (userWrittenCode != null) {
                codeSegment.addSourceCode(userWrittenCode.getCode());
            }
            codeSegment.addSourceCode("\n");
        } else {
            String quoteValue = "'";
            IStructuredExternalFile targetFile = this.getFile();
            IFileAccessServer server = targetFile.getAccessServer();
            String hadoopConfigFileRef = codeSegment.getUniqueWorkTableName();
            if (targetFile.isDoubleQuoteFilename()) {
                quoteValue = "\"";
            }
            StringBuffer fname = new StringBuffer();
            if (!targetFile.isNoQuoteFilename()) {
                fname.append(quoteValue).append(targetFile.getFileName()).append(quoteValue);
            } else {
                fname.append(targetFile.getFileName());
            }
            String filename = fname.toString();
            ArrayList<IColumn> list = new ArrayList<IColumn>();
            codeSegment.addSourceCode("data _null_; \n");
            codeSegment.indent();
            if (targetFile.getNumericMissingValue().length() > 0) {
                codeSegment.addSourceCode("length missval 8.;\n");
                codeSegment.addSourceCode("missval=" + targetFile.getNumericMissingValue() + ";\n");
            }
            codeSegment.addSourceCode("set ").addSourceCode(sourceTableName);
            if (sourceTableOptions != null && sourceTableOptions.length() > 0) {
                codeSegment.addSourceCode(" (");
                codeSegment.addSourceCode(sourceTableOptions);
                codeSegment.addSourceCode(")");
            }
            codeSegment.addSourceCode("; \n").indent();
            int columnCount = this.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                IColumn column = this.getColumns()[i];
                codeSegment.addSourceCode(column.getAttribStatement(targetFile.isColumnQuotingNeeded(), true, true, false));
                list.add(column);
            }
            if (targetFile instanceof IDelimitedExternalFile && !((IDelimitedExternalFile)targetFile).isConsecutiveDelimiterSkippingEnabled()) {
                codeSegment.addSourceCode("quote='\"';\n");
            }
            if (server instanceof IFTPServer) {
                codeSegment.addSourceCode("file " + filename + " " + server.getServerOptions(LibraryUtil.isApplicationUsingAuthDomainForPasswords(), true));
            } else if (server instanceof IHadoopServer) {
                codeSegment.addSourceCode("file " + filename + " " + server.getServerOptions(LibraryUtil.isApplicationUsingAuthDomainForPasswords(), true, hadoopConfigFileRef));
            } else {
                codeSegment.addSourceCode("file " + filename);
            }
            if (additionalFileOptions != null && additionalFileOptions.length() > 0) {
                codeSegment.addSourceCode(" " + additionalFileOptions);
            }
            if (targetFile instanceof IDelimitedExternalFile) {
                if (((IDelimitedExternalFile)targetFile).getOverrideDelimiter().length() > 0) {
                    codeSegment.addSourceCode(" dlm=" + ((IDelimitedExternalFile)targetFile).getOverrideDelimiter());
                } else {
                    codeSegment.addSourceCode(" dlm='" + ((IDelimitedExternalFile)targetFile).getDelimiters() + "'");
                }
            }
            codeSegment.addSourceCode(";\n\n");
            if (columnCount > 0) {
                this.buildHeaderLine(list, codeSegment, false);
                if (targetFile instanceof IDelimitedExternalFile) {
                    if (targetFile.getNumericMissingValue().length() > 0) {
                        this.buildDelimitedPutStatementsWithNumericMissing(list, codeSegment);
                    } else {
                        this.buildDelimitedPutStatements(list, codeSegment);
                    }
                } else if (targetFile.getNumericMissingValue().length() > 0) {
                    this.buildFixedWidthPutStatementsWithNumericMissing(list, codeSegment);
                } else {
                    this.buildFixedWidthPutStatements(list, codeSegment);
                }
                codeSegment.unIndent(2);
                codeSegment.addSourceCode("\n").unIndent().addSourceCode("run; \n\n");
            }
        }
        return codeSegment.getGeneratedCode();
    }

    private void buildDelimitedPutStatements(List columnlist, ICodeSegment codeSegment) throws MdException, RemoteException {
        IStructuredExternalFile targetFile = this.getFile();
        codeSegment.indent();
        if (((IDelimitedExternalFile)targetFile).isConsecutiveDelimiterSkippingEnabled()) {
            codeSegment.addSourceCode("put \n");
            codeSegment.indent();
            for (int j = 0; j < columnlist.size(); ++j) {
                IColumn column = (IColumn)columnlist.get(j);
                String columnName = "";
                columnName = column.getColumnName(targetFile.isColumnQuotingNeeded());
                codeSegment.addSourceCode(columnName);
                codeSegment.addSourceCode("\n");
            }
            codeSegment.addSourceCode(";\n");
            codeSegment.unIndent();
        } else {
            codeSegment.addSourceCode("put \n");
            codeSegment.indent();
            for (int j = 0; j < columnlist.size(); ++j) {
                IColumn column = (IColumn)columnlist.get(j);
                String columnName = "";
                columnName = column.getColumnName(targetFile.isColumnQuotingNeeded());
                codeSegment.addSourceCode("quote +(-1) ");
                codeSegment.addSourceCode(columnName);
                codeSegment.addSourceCode(" +(-1) quote\n");
            }
            codeSegment.addSourceCode(";\n");
            codeSegment.unIndent();
        }
        codeSegment.unIndent();
    }

    private void buildFixedWidthPutStatements(List columnlist, ICodeSegment codeSegment) throws MdException, RemoteException {
        IStructuredExternalFile targetFile = this.getFile();
        codeSegment.indent(0);
        codeSegment.indent();
        for (int j = 0; j < columnlist.size(); ++j) {
            if (j == 0) {
                codeSegment.addSourceCode("put \n");
            }
            codeSegment.indent();
            IColumn column = (IColumn)columnlist.get(j);
            String columnName = "";
            columnName = column.getColumnName(targetFile.isColumnQuotingNeeded());
            codeSegment.addSourceCode(" @ " + column.getBeginPosition());
            codeSegment.addSourceCode(" " + columnName);
            codeSegment.addSourceCode(" " + column.getFormat() + " \n");
            codeSegment.unIndent();
        }
        codeSegment.addSourceCode(";\n");
    }

    private void buildDelimitedPutStatementsWithNumericMissing(List columnlist, ICodeSegment codeSegment) throws MdException, RemoteException {
        IStructuredExternalFile targetFile = this.getFile();
        codeSegment.indent(0);
        codeSegment.unIndent();
        int numberColumns = columnlist.size();
        if (((IDelimitedExternalFile)targetFile).isConsecutiveDelimiterSkippingEnabled()) {
            for (int j = 0; j < numberColumns; ++j) {
                IColumn column = (IColumn)columnlist.get(j);
                String columnName = "";
                columnName = column.getColumnName(targetFile.isColumnQuotingNeeded());
                if (column.getType() == 1) {
                    codeSegment.addSourceCode("   if (" + columnName + "=.) then\n");
                    codeSegment.addSourceCode("      put missval");
                    if (j < numberColumns - 1) {
                        codeSegment.addSourceCode(" @;\n");
                    } else {
                        codeSegment.addSourceCode(" ;\n");
                    }
                    codeSegment.addSourceCode("   else\n");
                    codeSegment.addSourceCode("      put " + columnName);
                    if (j < numberColumns - 1) {
                        codeSegment.addSourceCode(" @;\n");
                        continue;
                    }
                    codeSegment.addSourceCode(" ;\n");
                    continue;
                }
                codeSegment.addSourceCode("   put " + columnName);
                if (j < numberColumns - 1) {
                    codeSegment.addSourceCode(" @;\n");
                    continue;
                }
                codeSegment.addSourceCode(" ;\n");
            }
        } else {
            for (int j = 0; j < columnlist.size(); ++j) {
                IColumn column = (IColumn)columnlist.get(j);
                String columnName = "";
                columnName = column.getColumnName(targetFile.isColumnQuotingNeeded());
                if (column.getType() == 1) {
                    codeSegment.addSourceCode("   if (");
                    codeSegment.addSourceCode(columnName + "=.) then\n");
                    codeSegment.addSourceCode("      put quote +(-1) ");
                    codeSegment.addSourceCode(MISSING_VALUE_VARIABLE);
                    codeSegment.addSourceCode(" +(-1) quote ");
                    if (j < numberColumns - 1) {
                        codeSegment.addSourceCode(" @;\n");
                    } else {
                        codeSegment.addSourceCode(" ;\n");
                    }
                    codeSegment.addSourceCode("   else\n");
                    codeSegment.addSourceCode("      put quote +(-1) ");
                    codeSegment.addSourceCode(columnName);
                    codeSegment.addSourceCode(" +(-1) quote ");
                    if (j < numberColumns - 1) {
                        codeSegment.addSourceCode(" @;\n");
                        continue;
                    }
                    codeSegment.addSourceCode(" ;\n");
                    continue;
                }
                codeSegment.addSourceCode("   put quote  +(-1) " + columnName);
                codeSegment.addSourceCode(" +(-1) quote ");
                if (j < numberColumns - 1) {
                    codeSegment.addSourceCode(" @;\n");
                    continue;
                }
                codeSegment.addSourceCode(" ;\n");
            }
        }
    }

    private int convertStringToInt(String string, int iDefault) throws RemoteException {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iDefault;
    }

    private void buildFixedWidthPutStatementsWithNumericMissing(List columnlist, ICodeSegment codeSegment) throws MdException, RemoteException {
        IStructuredExternalFile targetFile = this.getFile();
        codeSegment.indent(0);
        codeSegment.unIndent();
        int numberColumns = columnlist.size();
        for (int j = 0; j < numberColumns; ++j) {
            IColumn column = (IColumn)columnlist.get(j);
            String columnName = "";
            columnName = column.getColumnName(targetFile.isColumnQuotingNeeded());
            if (column.getType() == 1) {
                codeSegment.addSourceCode("   if (" + columnName + "=.) then\n");
                codeSegment.addSourceCode("      put @ " + column.getBeginPosition() + " ");
                codeSegment.addSourceCode(MISSING_VALUE_VARIABLE);
                if (j < numberColumns - 1) {
                    codeSegment.addSourceCode(" @;\n");
                } else {
                    codeSegment.addSourceCode(" ;\n");
                }
                codeSegment.addSourceCode("   else\n");
                codeSegment.addSourceCode("      put @ " + column.getBeginPosition() + " ");
                codeSegment.addSourceCode(columnName + " ");
                codeSegment.addSourceCode(column.getFormat());
                if (j < numberColumns - 1) {
                    codeSegment.addSourceCode(" @;\n");
                    continue;
                }
                codeSegment.addSourceCode(" ;\n");
                continue;
            }
            codeSegment.addSourceCode("   put @ " + column.getBeginPosition());
            codeSegment.addSourceCode(" " + columnName);
            codeSegment.addSourceCode(" " + column.getFormat());
            if (j < numberColumns - 1) {
                codeSegment.addSourceCode(" @;\n");
                continue;
            }
            codeSegment.addSourceCode(" ;\n");
        }
    }

    private void buildHeaderLine(List columnlist, ICodeSegment codeSegment, boolean override) throws RemoteException {
        IStructuredExternalFile targetFile = this.getFile();
        codeSegment.indent(0);
        if (this.convertStringToInt(targetFile.getStartingRecordNumber(), 1) > 1 || override) {
            this.setOutputHeaderLine(true);
            StringBuffer headerLine = new StringBuffer();
            int clistSize = columnlist.size();
            if (this.isDelimited()) {
                String delimiter = ((IDelimitedExternalFile)targetFile).getDelimiters();
                headerLine.append("\"");
                for (int i = 0; i < clistSize; ++i) {
                    IColumn column = (IColumn)columnlist.get(i);
                    if (i < clistSize - 1) {
                        headerLine.append(column.getColumnName(false) + delimiter);
                        continue;
                    }
                    headerLine.append(column.getColumnName(false));
                }
                headerLine.append("\"");
                codeSegment.addSourceCode("if ( _n_ = 1 ) then \n");
                codeSegment.indent();
                codeSegment.addSourceCode("do;\n");
                codeSegment.indent();
                codeSegment.addSourceCode("put \n");
                codeSegment.indent();
                codeSegment.addSourceCode(headerLine.toString() + ";\n");
                codeSegment.unIndent(100);
                codeSegment.addSourceCode("end;\n");
                codeSegment.unIndent();
            } else {
                ArrayList<String> columnNamesList = new ArrayList<String>();
                for (int j = 0; j < columnlist.size(); ++j) {
                    IColumn col = (IColumn)columnlist.get(j);
                    columnNamesList.add(col.getColumnName(false));
                }
                ArrayList<String> columnPositionsList = new ArrayList<String>();
                IColumn[] columns = this.getColumns();
                for (int k = 0; k < columnlist.size(); ++k) {
                    IColumn col = columns[k];
                    String position = String.valueOf(col.getBeginPosition());
                    columnPositionsList.add(position);
                }
                codeSegment.addSourceCode("if ( _n_ = 1 ) then \n");
                codeSegment.indent();
                codeSegment.addSourceCode("do;\n");
                codeSegment.indent();
                codeSegment.addSourceCode("put \n");
                codeSegment.indent();
                for (int m = 0; m < columnNamesList.size(); ++m) {
                    IColumn columnP = (IColumn)columnlist.get(m);
                    codeSegment.addSourceCode(" @ " + columnP.getBeginPosition());
                    codeSegment.addSourceCode(" '" + (String)columnNamesList.get(m));
                    codeSegment.addSourceCode("' \n");
                }
                codeSegment.addSourceCode(headerLine.toString() + ";\n");
                codeSegment.unIndent();
                codeSegment.addSourceCode("end;\n");
                codeSegment.unIndent();
                codeSegment.unIndent();
            }
            codeSegment.unIndent();
        }
    }

    public void setOutputHeaderLine(boolean headerLine) {
        this.m_headerLineOutputFile = headerLine;
    }

    public boolean isOutputHeaderLine() {
        return this.m_headerLineOutputFile;
    }

    @Override
    public StringBuffer getDataStepCodeToCreateTable(ICodeGenerationEnvironment environment, String targetTableName, boolean targetIsView, String targetTableOptions, boolean mappingNeeded) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        CodeSegment codeSegment = new CodeSegment(environment, this);
        this.getExternalTableSetupCode(codeSegment);
        if (targetTableName == null || targetTableName.length() == 0) {
            targetTableName = "work.etls_EFITable";
        }
        if (this.isUsingUserWrittenCode()) {
            StringBuffer userCode = new StringBuffer();
            userCode.append("%let _OUTPUT = %nrquote(").append(targetTableName).append("); \n\n");
            codeSegment.addSourceCode(userCode);
            IUserWrittenCodeContainer userWrittenCode = this.getUserWrittenCode();
            if (userWrittenCode != null) {
                codeSegment.addSourceCode(userWrittenCode.getCode());
            }
            codeSegment.addSourceCode("\n");
        } else {
            IStructuredExternalFile sourceFile = this.getFile();
            String hadoopConfigFileRef = codeSegment.getUniqueWorkTableName();
            IFileAccessServer server = sourceFile.getAccessServer();
            if (this.isSpecialCharacters()) {
                codeSegment.genValidvarnameOptionAny(false);
            }
            if (sourceFile.getSpecialMissingValue().length() > 0) {
                codeSegment.addSourceCode("Missing " + sourceFile.getSpecialMissingValue() + ";\n");
            }
            codeSegment.addSourceCode("data " + targetTableName);
            if (targetIsView || mappingNeeded) {
                codeSegment.addSourceCode(" / view = " + targetTableName);
            }
            if (targetTableOptions != null && targetTableOptions.length() > 0) {
                codeSegment.indent().addSourceCode("\n(").addSourceCode(targetTableOptions).addSourceCode(")\n").unIndent();
            }
            codeSegment.addSourceCode(" ; \n").indent();
            if (sourceFile.getInfileOverrideFlag()) {
                codeSegment.addSourceCode(sourceFile.getInfileOverrideText());
            } else {
                codeSegment.addSourceCode(this.getInfileStatement(hadoopConfigFileRef));
            }
            codeSegment.addSourceCode("; \n");
            codeSegment.addSourceCode(this.getInputStatement(codeSegment));
            if (sourceFile.getNumericMissingValue().length() > 0) {
                codeSegment.addSourceCode(this.getSpecialNumericStatements(codeSegment));
            }
            codeSegment.addSourceCode("\n");
            codeSegment.unIndent();
            codeSegment.unIndent().addSourceCode("run; \n\n");
        }
        return codeSegment.getGeneratedCode();
    }

    @Override
    public String getAccessMethodNickName() {
        IFileAccessServer server;
        if (this.getFile() != null && (server = this.getFile().getAccessServer()) != null) {
            return server.getAccessMethodNickName();
        }
        return WsAppServer.FILE_ACCESS_METHOD_DEFAULT;
    }

    @Override
    public String getAccessMethodOptions(String fileRef) throws BadServerDefinitionException {
        return this.getAccessMethodOptions(fileRef, false);
    }

    @Override
    public String getAccessMethodOptions(String fileRef, boolean includeDirectoryListing) throws BadServerDefinitionException {
        IFileAccessServer server;
        if (this.getFile() != null && (server = this.getFile().getAccessServer()) != null) {
            StringBuffer opts = new StringBuffer(server.getServerOptions(LibraryUtil.isApplicationUsingAuthDomainForPasswords(), true, fileRef, false));
            if (includeDirectoryListing && server.getDirectoryListingOption() != null) {
                opts.append(" ").append(server.getDirectoryListingOption());
            }
            return opts.toString();
        }
        return "";
    }

    @Override
    public String getAccessMethodFileName(String fileName) throws BadServerDefinitionException {
        IFileAccessServer server;
        if (this.getFile() != null && (server = this.getFile().getAccessServer()) != null) {
            return server.getAccessMethodFilePath(fileName);
        }
        return fileName;
    }

    @Override
    public String getAccessMethodPreCode(String fileRef) throws ConfigurationException, CodegenException {
        if (this.getFile() != null) {
            // empty if block
        }
        return null;
    }

    @Override
    public StringBuffer getDataStepCodeToCreateTable(ICodeGenerationEnvironment environment, String targetTableName, boolean targetIsView, String targetTableOptions, boolean mappingNeeded, String additionalInfileOptions) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        CodeSegment codeSegment = new CodeSegment(environment, this);
        this.getExternalTableSetupCode(codeSegment);
        if (targetTableName == null || targetTableName.length() == 0) {
            targetTableName = "work.etls_EFITable";
        }
        if (this.isUsingUserWrittenCode()) {
            StringBuffer userCode = new StringBuffer();
            userCode.append("%let _OUTPUT = %nrquote(").append(targetTableName).append("); \n\n");
            codeSegment.addSourceCode(userCode);
            IUserWrittenCodeContainer userWrittenCode = this.getUserWrittenCode();
            if (userWrittenCode != null) {
                codeSegment.addSourceCode(userWrittenCode.getCode());
            }
            codeSegment.addSourceCode("\n");
        } else {
            IStructuredExternalFile sourceFile = this.getFile();
            String hadoopConfigFileRef = codeSegment.getUniqueWorkTableName();
            IFileAccessServer server = sourceFile.getAccessServer();
            if (this.isSpecialCharacters()) {
                codeSegment.genValidvarnameOptionAny(false);
            }
            if (sourceFile.getSpecialMissingValue().length() > 0) {
                codeSegment.addSourceCode("Missing " + sourceFile.getSpecialMissingValue() + ";\n");
            }
            codeSegment.addSourceCode("data " + targetTableName);
            if (targetIsView || mappingNeeded) {
                codeSegment.addSourceCode(" / view = " + targetTableName);
            }
            if (targetTableOptions != null && targetTableOptions.length() > 0) {
                codeSegment.indent().addSourceCode("\n(").addSourceCode(targetTableOptions).addSourceCode(")\n").unIndent();
            }
            codeSegment.addSourceCode(" ; \n").indent();
            if (sourceFile.getInfileOverrideFlag()) {
                codeSegment.addSourceCode(sourceFile.getInfileOverrideText());
            } else {
                codeSegment.addSourceCode(this.getInfileStatement(additionalInfileOptions, hadoopConfigFileRef));
            }
            codeSegment.addSourceCode("; \n");
            codeSegment.addSourceCode(this.getInputStatement(codeSegment));
            if (sourceFile.getNumericMissingValue().length() > 0) {
                codeSegment.addSourceCode(this.getSpecialNumericStatements(codeSegment));
            }
            codeSegment.addSourceCode("\n");
            codeSegment.unIndent();
            codeSegment.unIndent().addSourceCode("run; \n\n");
        }
        return codeSegment.getGeneratedCode();
    }

    public StringBuffer getInputStatement(ICodeSegment codeSegment) {
        StringBuffer code = new StringBuffer();
        boolean colsQuoted = this.isCaseSensitive() || this.isSpecialCharacters();
        int numColumns = this.getColumnCount();
        ArrayList<IColumn> list = new ArrayList<IColumn>();
        boolean needInformats = true;
        if (this.isFixedWidth()) {
            needInformats = false;
        }
        for (int i = 0; i < numColumns; ++i) {
            IColumn column = this.getColumns()[i];
            code.append(column.getAttribStatement(colsQuoted, true, true, needInformats, false));
            list.add(column);
        }
        int listSize = list.size();
        if (listSize > 0) {
            code.append("\n").append("input ");
        }
        if (this.isDelimited()) {
            String colStatement = codeSegment.makeColumnList(list, "      ", colsQuoted);
            code.append(colStatement);
            if (((IDelimitedExternalFile)this.getFile()).isMultipleRecordsPerLineEnabled()) {
                code.append("\n@@\n; \n");
            } else {
                code.append("; \n");
            }
        } else {
            for (int j = 0; j < listSize; ++j) {
                IColumn column = (IColumn)list.get(j);
                String columnName = "";
                columnName = column.getColumnName(colsQuoted);
                int iStartValue = column.getBeginPosition();
                int iEndValue = column.getEndPosition();
                String startValue = String.valueOf(iStartValue);
                String endValue = String.valueOf(iEndValue);
                String informat = column.getInformat();
                if (informat.length() > 0) {
                    code.append("@ " + startValue + " ");
                    code.append(columnName).append(" ");
                    code.append(" " + informat);
                } else if (iEndValue > 0) {
                    code.append(columnName).append(" ");
                    if (column.getType() == 0) {
                        code.append("$ ");
                    }
                    code.append(startValue + "-" + endValue);
                } else {
                    code.append("@ " + startValue + " ");
                    code.append(columnName).append(" ");
                    if (column.getType() == 0) {
                        code.append("$ ");
                    }
                }
                if (j + 1 == listSize) {
                    code.append("; \n");
                    continue;
                }
                code.append("\n       ");
            }
        }
        return code;
    }

    public String getSpecialNumericStatements(ICodeSegment codeSegment) {
        IStructuredExternalFile sourceFile = this.getFile();
        StringBuffer missingString = new StringBuffer();
        IColumn[] columnList = this.getColumns();
        int numColumns = this.getColumnCount();
        if (numColumns == 0) {
            return missingString.toString();
        }
        List missingList = sourceFile.getNumericMissingValues();
        if (!missingList.isEmpty()) {
            for (int i = 0; i < numColumns; ++i) {
                IColumn column = columnList[i];
                if (column.getType() != 1) continue;
                String columnName = "";
                columnName = column.getColumnName(sourceFile.isColumnQuotingNeeded());
                for (int j = 0; j < missingList.size(); ++j) {
                    String missingValue = (String)missingList.get(j);
                    if (j > 0) {
                        missingString.append("else if " + columnName + " = " + missingValue + " then \n");
                    } else {
                        missingString.append("if " + columnName + " = " + missingValue + " then \n");
                    }
                    missingString.append("   " + columnName + " = .;\n");
                }
            }
        }
        return missingString.toString();
    }

    private class SetFormatFileColumnUndoable
    extends AbstractUndoableEdit {
        private IFormatFileColumnImport m_oldValue;
        private IFormatFileColumnImport m_newValue;

        public SetFormatFileColumnUndoable(IFormatFileColumnImport oldValue, IFormatFileColumnImport newValue) {
            this.m_newValue = newValue;
            this.m_oldValue = oldValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseExternalTable.this.setFormatFileColumnImport(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseExternalTable.this.setFormatFileColumnImport(this.m_newValue);
        }
    }

    private class UserWrittenExternalFileUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public UserWrittenExternalFileUndoable(boolean oldValue, boolean newValue) {
            this.m_newValue = newValue;
            this.m_oldValue = oldValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseExternalTable.this.setUserWrittenExternalFile(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseExternalTable.this.setUserWrittenExternalFile(this.m_newValue);
        }
    }
}

