/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseDatabaseSchema
extends AbstractPersistableObject
implements IDatabaseSchema {
    private String m_schemaName = "";
    private ILibrary m_library;
    private IServer m_server;

    public BaseDatabaseSchema(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getSchemaName() {
        return this.m_schemaName;
    }

    @Override
    public void setSchemaName(String schemaName) {
        if (schemaName == null) {
            throw new IllegalArgumentException("null not allowed for schema name");
        }
        if (this.m_schemaName.equals(schemaName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSchemaNameUndoable(this.m_schemaName, schemaName));
        }
        this.m_schemaName = schemaName;
        this.fireModelChangedEvent("IDatabaseSchema:SchemaNameChanged", this.m_schemaName);
    }

    @Override
    public void setServer(IServer server) {
        if (this.m_server == server) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetServerUndoable(this.m_server, server));
        }
        this.m_server = server;
        this.fireModelChangedEvent("IDatabaseSchema:ServerChanged", this.m_server);
    }

    @Override
    public String getSchemaName(IServer currentServer, IPhysicalTable table, boolean quotes) throws BadLibraryDefinitionException {
        return this.getLibrary().getDBMSType().getSchemaName(currentServer, table, quotes);
    }

    @Override
    public ILibrary getLibrary() {
        return this.m_library;
    }

    @Override
    public void setLibrary(ILibrary lib) {
        if (this.m_library == lib) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetLibraryUndoable(this.m_library, lib));
            }
            this.m_library = lib;
            this.fireModelChangedEvent("IDatabaseSchema:LibraryChanged", this.m_library);
            if (this.m_library != null) {
                this.m_library.setDatabaseSchema(this);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
        }
        lAssociations.add("UsedByPackages");
        lAssociations.add("DeployedComponents");
        map.put(this.getOMRType(), lAssociations);
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "DatabaseSchema";
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        DatabaseSchema mdoSchema = (DatabaseSchema)omr.acquireOMRObject(this);
        this.setSchemaName(mdoSchema.getSchemaName());
        AssociationList servers = mdoSchema.getDeployedComponents();
        if (!servers.isEmpty()) {
            DeployedComponent comp = (DeployedComponent)servers.get(0);
            this.setServer((IServer)omr.acquireObject((Root)comp));
        }
        AssociationList lPackages = mdoSchema.getUsedByPackages();
        for (int iPackage = 0; iPackage < lPackages.size(); ++iPackage) {
            Object obj = lPackages.get(iPackage);
            if (!(obj instanceof SASLibrary)) continue;
            this.setLibrary((ILibrary)omr.acquireObject((Root)((SASLibrary)obj)));
            break;
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        DatabaseSchema mdoSchema = (DatabaseSchema)omr.acquireOMRObject(this);
        mdoSchema.setSchemaName(this.getSchemaName());
        AssociationList comps = mdoSchema.getDeployedComponents();
        comps.clear();
        IServer server = this.getServer();
        if (server != null) {
            server.saveToOMR(omr);
            comps.add(omr.acquireOMRObject(server));
        }
        AssociationList lPackages = mdoSchema.getUsedByPackages();
        lPackages.clear();
        ILibrary library = this.getLibrary();
        if (library != null) {
            lPackages.add(omr.acquireOMRObject(library));
        }
        this.setChanged(false);
    }

    @Override
    public IServer getServer() {
        return this.m_server;
    }

    private class SetSchemaNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldSchemaName;
        private String m_newSchemaName;

        public SetSchemaNameUndoable(String oldSchemaName, String newSchemaName) {
            this.m_oldSchemaName = oldSchemaName;
            this.m_newSchemaName = newSchemaName;
        }

        @Override
        public void undo() {
            super.undo();
            BaseDatabaseSchema.this.setSchemaName(this.m_oldSchemaName);
        }

        @Override
        public void redo() {
            super.redo();
            BaseDatabaseSchema.this.setSchemaName(this.m_newSchemaName);
        }
    }

    private class SetServerUndoable
    extends AbstractUndoableEdit {
        private IServer m_oldServer;
        private IServer m_newServer;

        public SetServerUndoable(IServer oldServer, IServer newServer) {
            this.m_oldServer = oldServer;
            this.m_newServer = newServer;
        }

        @Override
        public void undo() {
            super.undo();
            BaseDatabaseSchema.this.setServer(this.m_oldServer);
        }

        @Override
        public void redo() {
            super.redo();
            BaseDatabaseSchema.this.setServer(this.m_newServer);
        }

        @Override
        public void die() {
            this.m_oldServer = null;
            this.m_newServer = null;
        }
    }

    private class SetLibraryUndoable
    extends AbstractUndoableEdit {
        private ILibrary m_oldLibrary;
        private ILibrary m_newLibrary;

        public SetLibraryUndoable(ILibrary oldLibrary, ILibrary newLibrary) {
            this.m_oldLibrary = oldLibrary;
            this.m_newLibrary = newLibrary;
        }

        @Override
        public void undo() {
            super.undo();
            BaseDatabaseSchema.this.setLibrary(this.m_oldLibrary);
        }

        @Override
        public void redo() {
            super.redo();
            BaseDatabaseSchema.this.setLibrary(this.m_newLibrary);
        }
    }
}

