/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.impl.RB;
import com.sas.etl.models.impl.AbstractComplexPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodeGenerationEnvironment;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BasePromptModel;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PromptGroup;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class AbstractParametersContainer
extends AbstractComplexPersistableObject
implements IParametersContainer {
    private PromptGroupInterface m_promptGroup = PromptUtils.createPromptGroup();
    private IPromptModel m_promptModel;

    public AbstractParametersContainer(String sID, IModel model) {
        super(sID, model);
        this.updatePromptModel();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        Transformation trans;
        if (this.isNew()) {
            return;
        }
        super.deleteFromOMR(omr);
        PromptGroup pGroup = (PromptGroup)omr.acquireOMRObject(this);
        if (pGroup != null && !pGroup.isNewObject() && (trans = pGroup.getValueSource()) != null && !trans.isNewObject()) {
            omr.deleteOMRObject(trans.getFQID(), trans.getCMetadataType());
        }
    }

    @Override
    public void dispose() {
        if (this.m_promptModel != null) {
            this.m_promptModel.dispose();
        }
        super.dispose();
    }

    @Override
    public String getOMRType() {
        return "PromptGroup";
    }

    public String getPublicType() {
        return "Embedded:PromptGroup";
    }

    @Override
    public void setPromptGroup(PromptGroupInterface promptGroup) {
        if (this.m_promptGroup == promptGroup) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPromptGroupUndoable(this.m_promptGroup, promptGroup));
        }
        this.m_promptGroup = promptGroup;
        this.updatePromptModel();
        this.fireModelChangedEvent("IParametersContainer:PromptGroupChanged", this.m_promptGroup);
    }

    @Override
    public PromptGroupInterface getPromptGroup() {
        return this.m_promptGroup;
    }

    protected void updatePromptModel() {
        if (this.m_promptModel != null) {
            this.m_promptModel.dispose();
        }
        this.m_promptModel = this.getNewPromptModel();
    }

    protected IPromptModel getNewPromptModel() {
        PromptGroupInterface group = this.getPromptGroup();
        return new BasePromptModel(this.getModel(), this, group);
    }

    public IPromptModel getPromptModel() {
        return this.m_promptModel;
    }

    @Override
    public IPromptDefinitionValue[] getParameters() {
        IPromptModel model = this.getPromptModel();
        return model != null ? model.getPromptDefinitionValues() : new IPromptDefinitionValue[]{};
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("Prompts");
        return map;
    }

    @Override
    public ICodeSegment getGeneratedDefaultParameterCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IPromptModel model = this.getPromptModel();
        if (model != null) {
            List<IPromptDefinitionValue> prompts = Arrays.asList(this.getParameters());
            ICodeGenerationEnvironment environment = codeSegment.getCodeGenerationEnvironment();
            try {
                prompts = environment.getDefinitionsNotGenerated(prompts, codeSegment);
                IPromptDefinitionValue[] promptsArr = prompts.toArray(new IPromptDefinitionValue[prompts.size()]);
                codeSegment.addSourceCode(this.getDefaultParameterCode(codeSegment, promptsArr));
                codeSegment.getCodeGenerationEnvironment().addGeneratedParameters(this, codeSegment);
            }
            catch (ServiceException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)this);
            }
            catch (ServerConnectionException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)this);
            }
        }
        return codeSegment;
    }

    @Override
    public void removeGeneratedDefaultParameters(ICodeSegment codeSegment) {
        codeSegment.getCodeGenerationEnvironment().removeGeneratedParameters(this);
    }

    @Override
    public StringBuffer getDefaultParameterCode() throws BadLibraryDefinitionException, BadServerDefinitionException, MdException, RemoteException, ServerException, CodegenException {
        CodeSegment codeSegment = new CodeSegment(new CodeGenerationEnvironment(null), this);
        return this.getDefaultParameterCode(codeSegment);
    }

    @Override
    public StringBuffer getDefaultParameterCode(ICodeSegment codeSegment) throws BadLibraryDefinitionException, BadServerDefinitionException, MdException, RemoteException, ServerException, CodegenException {
        return this.getDefaultParameterCode(codeSegment, this.getParameters());
    }

    private StringBuffer getDefaultParameterCode(ICodeSegment codeSegment, IPromptDefinitionValue[] prompts) throws BadLibraryDefinitionException, BadServerDefinitionException, MdException, RemoteException, ServerException, CodegenException {
        StringBuffer code = new StringBuffer();
        IPromptModel model = this.getPromptModel();
        try {
            StringBuffer macros;
            if (model != null && (macros = model.getOptionsString(codeSegment, null, true, true, false, false, prompts)) != null && macros.length() > 0) {
                code.append(codeSegment.makeComment(MessageFormat.format(RB.getStringResource("AbstractParametersContainer.ParameterMacroCode.ParameterDefaults.txt"), this.getName())));
                code.append(macros).append("\n");
            }
        }
        catch (ServiceException e) {
            throw new CodegenException((Exception)((Object)e), (IObject)this);
        }
        catch (ServerConnectionException e) {
            throw new CodegenException((Exception)((Object)e), (IObject)this);
        }
        return code;
    }

    @Override
    public Map<String, String> getMacroNamesAndValues(ICodeSegment codeSegment) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, ServerConnectionException, ServerException {
        IPromptModel model = this.getPromptModel();
        HashMap<String, String> macros = new HashMap<String, String>();
        try {
            if (model != null) {
                macros.putAll(model.getMacroNamesAndValues(codeSegment, null, true, true, false, false));
            }
        }
        catch (ServiceException e) {
            throw new CodegenException((Exception)((Object)e), (IObject)this);
        }
        catch (ServerConnectionException e) {
            throw new CodegenException((Exception)((Object)e), (IObject)this);
        }
        return macros;
    }

    @Override
    public boolean hasParameters() {
        return this.m_promptGroup != null && !this.m_promptGroup.getPromptDefinitions(true).isEmpty();
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Root mdObject = omr.acquireOMRObject(this);
        PromptGroupInterface pGroup = PromptUtils.getPromptGroupFromMetadataObject(Workspace.getWorkspace().getUserContext(), mdObject);
        if (pGroup != null) {
            this.setPromptGroup(pGroup);
        } else {
            this.setPromptGroup(PromptUtils.createPromptGroup());
        }
        this.setChanged(false);
    }

    protected Map getConflictingMacroNames() {
        PromptGroupInterface group = this.getPromptGroup();
        PromptValues promptValues = new PromptValues(group);
        HashMap conflicts = new HashMap();
        List visibleDefinitions = PromptUtil.getVisualOrderOfDefinitions((PromptValuesInterface)promptValues, (PromptGroupInterface)group, (boolean)false);
        int size = visibleDefinitions.size();
        for (int i = 0; i < size; ++i) {
            PromptDefinitionInterface prompt = (PromptDefinitionInterface)visibleDefinitions.get(i);
            conflicts.putAll(PromptUtil.getConflictingPromptsBasedOnMacroVariableName((PromptGroupInterface)group, (PromptDefinitionInterface)prompt));
        }
        return conflicts;
    }

    @Override
    public boolean isComplete() {
        Map conflicts = this.getConflictingMacroNames();
        if (conflicts.size() > 0) {
            return false;
        }
        return super.isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        ArrayList<String> reasons = new ArrayList<String>();
        reasons.addAll(super.getReasonsIncomplete());
        Map conflicts = this.getConflictingMacroNames();
        int size = conflicts.size();
        for (int i = 0; i < size; ++i) {
            reasons.add("Macro name conflict for prompt " + conflicts.keySet().toArray()[i]);
        }
        return reasons;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Root mdObject = omr.acquireOMRObject(this);
        mdObject.getPrompts(false).clear();
        if (this.hasParameters()) {
            PromptUtils.savePromptGroupToMetadataObject(Workspace.getWorkspace().getUserContext(), this.getModel().createIDForNewObject(this.getID()), this.m_promptGroup, mdObject);
        }
        this.setChanged(false);
    }

    private class SetPromptGroupUndoable
    extends AbstractUndoableEdit {
        private PromptGroupInterface m_oldPromptGroup;
        private PromptGroupInterface m_newPromptGroup;

        public SetPromptGroupUndoable(PromptGroupInterface oldPromptGroup, PromptGroupInterface newPromptGroup) {
            this.m_oldPromptGroup = oldPromptGroup;
            this.m_newPromptGroup = newPromptGroup;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractParametersContainer.this.setPromptGroup(this.m_oldPromptGroup);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractParametersContainer.this.setPromptGroup(this.m_newPromptGroup);
        }
    }
}

