/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.externalfile.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.externalfile.IDelimitedExternalFile;
import com.sas.etl.models.data.externalfile.impl.AbstractStructuredExternalFile;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import java.rmi.RemoteException;
import javax.swing.undo.AbstractUndoableEdit;

public class DelimitedExternalFile
extends AbstractStructuredExternalFile
implements IDelimitedExternalFile {
    private String m_delimiters = "";
    private String m_overrideDelimiter = "";
    private boolean m_quotesProtectDelimiters = false;
    private boolean m_skipConsecutiveDelimiters = false;
    private boolean m_multipleRecordsPerLine = false;
    private boolean m_missover = true;
    private boolean m_recordWrapping = false;
    private String m_delimitersID = "";
    private String m_skipConsecutiveDelimitersID = "";
    private String m_multipleRecordsPerLineID = "";
    private String m_missoverID = "";
    private String m_quotesProtectDelimitersID = "";
    private String m_overrideDelimiterID = "";

    public DelimitedExternalFile(String id, IModel model) {
        super(id, model);
    }

    @Override
    public String getDelimiters() {
        return this.m_delimiters;
    }

    @Override
    public void setDelimiters(String delimiters) {
        if (this.m_delimiters.equals(delimiters)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDelimitersUndoable(this.m_delimiters, delimiters));
        }
        this.m_delimiters = delimiters;
        this.fireModelChangedEvent("ExternalTable:DelimitersChanged", null);
    }

    @Override
    public String getOverrideDelimiter() {
        return this.m_overrideDelimiter;
    }

    @Override
    public boolean isDelimiterQuotingEnabled() {
        return this.m_quotesProtectDelimiters;
    }

    @Override
    public void setDelimiterQuotingEnabled(boolean enabled) {
        if (this.m_quotesProtectDelimiters == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDelimiterQuotingEnabledUndoable(enabled));
        }
        this.m_quotesProtectDelimiters = enabled;
        this.fireModelChangedEvent("ExternalTable:DelimiterQuotingChanged", null);
    }

    @Override
    public boolean isConsecutiveDelimiterSkippingEnabled() {
        return this.m_skipConsecutiveDelimiters;
    }

    @Override
    public void setConsecutiveDelimiterSkippingEnabled(boolean enabled) {
        if (this.m_skipConsecutiveDelimiters == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetConsecutiveDelimiterSkippingEnabledUndoable(enabled));
        }
        this.m_skipConsecutiveDelimiters = enabled;
        this.fireModelChangedEvent("ExternalTable:ConsecutiveDelimiterSkippingChanged", null);
    }

    @Override
    public boolean isMultipleRecordsPerLineEnabled() {
        return this.m_multipleRecordsPerLine;
    }

    @Override
    public void setMultipleRecordsPerLineEnabled(boolean enabled) {
        if (this.m_multipleRecordsPerLine == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMultipleRecordsPerLineEnabledUndoable(enabled));
        }
        this.m_multipleRecordsPerLine = enabled;
        this.fireModelChangedEvent("ExternalTable:MultipleRecordsPerLineChanged", null);
    }

    @Override
    public boolean isRecordWrappingEnabled() {
        return this.m_recordWrapping;
    }

    @Override
    public void setRecordWrappingEnabled(boolean enabled) {
        if (this.m_recordWrapping == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRecordWrappingEnabledUndoable(enabled));
        }
        this.m_recordWrapping = enabled;
        this.m_missover = !enabled;
        this.fireModelChangedEvent("ExternalTable:RecordWrappingChanged", null);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        File mdoFile = (File)omr.acquireOMRObject(this);
        Property mdoProperty = this.findProperty(omr, (Root)mdoFile, "EFI_FILE_STRUCTURE", "DELIMTER", 32);
        this.m_delimitersID = mdoProperty.getFQID();
        AssociationList lNotes = mdoProperty.getNotes();
        if (!lNotes.isEmpty()) {
            TextStore mdoDelimiterText = (TextStore)lNotes.get(0);
            this.m_delimitersID = mdoDelimiterText.getFQID();
            String delimitersValue = mdoDelimiterText.getStoredText();
            if (delimitersValue.length() == 0) {
                delimitersValue = " ";
            }
            this.setDelimiters(delimitersValue);
        } else {
            this.setDelimiters(" ");
        }
        AssociationList mdoDelimiterProperties = mdoProperty.getProperties();
        boolean bFoundConsecutive = false;
        boolean bFoundMultiRecords = false;
        boolean bFoundMissover = false;
        boolean bFoundQuotes = false;
        if (!mdoDelimiterProperties.isEmpty()) {
            for (int i = 0; i < mdoDelimiterProperties.size(); ++i) {
                String propVal;
                Property mdoDelimiterProperty = (Property)mdoDelimiterProperties.get(i);
                String mdoPropertyName = mdoDelimiterProperty.getName();
                if (mdoPropertyName.equalsIgnoreCase("CONSECUTIVEDELIMITERS")) {
                    bFoundConsecutive = true;
                    propVal = mdoDelimiterProperty.getDefaultValue();
                    if (propVal.length() == 0) {
                        this.setConsecutiveDelimiterSkippingEnabled(true);
                    } else {
                        this.setConsecutiveDelimiterSkippingEnabled(Boolean.valueOf(propVal));
                    }
                    this.m_skipConsecutiveDelimitersID = mdoDelimiterProperty.getFQID();
                    continue;
                }
                if (mdoPropertyName.equalsIgnoreCase("MULTIRECORDSPERLINE")) {
                    bFoundMultiRecords = true;
                    propVal = mdoDelimiterProperty.getDefaultValue();
                    if (propVal.length() == 0) {
                        this.setMultipleRecordsPerLineEnabled(true);
                    } else {
                        this.setMultipleRecordsPerLineEnabled(Boolean.valueOf(propVal));
                    }
                    this.m_multipleRecordsPerLineID = mdoDelimiterProperty.getFQID();
                    continue;
                }
                if (mdoPropertyName.equalsIgnoreCase("OVERRIDEDELIMITER")) {
                    propVal = mdoDelimiterProperty.getDefaultValue();
                    this.setOverrideDelimiter(propVal);
                    this.m_overrideDelimiterID = mdoDelimiterProperty.getFQID();
                    continue;
                }
                if (mdoPropertyName.equalsIgnoreCase("MISSOVER")) {
                    bFoundMissover = true;
                    propVal = mdoDelimiterProperty.getDefaultValue();
                    if (propVal.length() == 0) {
                        this.setRecordWrappingEnabled(false);
                    } else if (Boolean.valueOf(propVal).booleanValue()) {
                        this.setRecordWrappingEnabled(false);
                    } else {
                        this.setRecordWrappingEnabled(true);
                    }
                    this.m_missoverID = mdoDelimiterProperty.getFQID();
                    continue;
                }
                if (!mdoPropertyName.equalsIgnoreCase("DELIMITERQUOTING")) continue;
                bFoundQuotes = true;
                propVal = mdoDelimiterProperty.getDefaultValue();
                if (propVal.length() == 0) {
                    this.setDelimiterQuotingEnabled(true);
                } else {
                    this.setDelimiterQuotingEnabled(Boolean.valueOf(propVal));
                }
                this.m_quotesProtectDelimitersID = mdoDelimiterProperty.getFQID();
            }
            if (!bFoundConsecutive) {
                this.setConsecutiveDelimiterSkippingEnabled(false);
            }
            if (!bFoundMultiRecords) {
                this.setMultipleRecordsPerLineEnabled(false);
            }
            if (!bFoundMissover) {
                this.setRecordWrappingEnabled(true);
            }
            if (!bFoundQuotes) {
                this.setDelimiterQuotingEnabled(false);
            }
        } else {
            this.setConsecutiveDelimiterSkippingEnabled(false);
            this.setMultipleRecordsPerLineEnabled(false);
            this.setRecordWrappingEnabled(false);
            this.setDelimiterQuotingEnabled(false);
        }
        this.setChanged(false);
    }

    @Override
    public void setOverrideDelimiter(String overrideDelimiter) {
        if (this.m_overrideDelimiter.equals(overrideDelimiter)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOverrideDelimiterUndoable(this.m_overrideDelimiter, overrideDelimiter));
        }
        this.m_overrideDelimiter = overrideDelimiter;
        this.fireModelChangedEvent("ExternalTable:OverrideDelimiterChanged", null);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        File mdoFile = (File)omr.acquireOMRObject(this);
        String sTextStoreID = this.m_delimitersID.equals("") || this.m_delimitersID.length() == 0 ? this.createIDForNewObject() : this.m_delimitersID;
        TextStore mdoTS = (TextStore)omr.acquireOMRObject(sTextStoreID, "TextStore");
        mdoTS.setName("INFILEDELIMITER");
        mdoTS.setStoredText(this.m_delimiters);
        this.saveStringOptionToOMR(omr, "EFI_FILE_STRUCTURE", "DELIMTER", "");
        Property mdoDelimiterProp = this.findProperty(omr, (Root)mdoFile, "EFI_FILE_STRUCTURE", "DELIMTER", 0);
        AssociationList mdoAList = mdoDelimiterProp.getNotes();
        mdoAList.clear();
        mdoAList.add((Object)mdoTS);
        String sConsecutivePropertyID = this.m_skipConsecutiveDelimitersID.equals("") || this.m_skipConsecutiveDelimitersID.length() == 0 ? this.createIDForNewObject() : this.m_skipConsecutiveDelimitersID;
        Property mdoConsecutiveProperty = (Property)omr.acquireOMRObject(sConsecutivePropertyID, "Property");
        mdoConsecutiveProperty.setName("CONSECUTIVEDELIMITERS");
        if (this.isConsecutiveDelimiterSkippingEnabled()) {
            mdoConsecutiveProperty.setDefaultValue("true");
        } else {
            mdoConsecutiveProperty.setDefaultValue("false");
        }
        mdoAList = mdoDelimiterProp.getProperties();
        mdoAList.clear();
        mdoAList.add((Object)mdoConsecutiveProperty);
        String sMultipleRecordsPropertyID = this.m_multipleRecordsPerLineID.equals("") || this.m_multipleRecordsPerLineID.length() == 0 ? this.createIDForNewObject() : this.m_multipleRecordsPerLineID;
        Property mdoMultipleRecordsProperty = (Property)omr.acquireOMRObject(sMultipleRecordsPropertyID, "Property");
        mdoMultipleRecordsProperty.setName("MULTIRECORDSPERLINE");
        if (this.isMultipleRecordsPerLineEnabled()) {
            mdoMultipleRecordsProperty.setDefaultValue("true");
        } else {
            mdoMultipleRecordsProperty.setDefaultValue("false");
        }
        mdoAList.add((Object)mdoMultipleRecordsProperty);
        String sMissoverID = this.m_missoverID.equals("") || this.m_missoverID.length() == 0 ? this.createIDForNewObject() : this.m_missoverID;
        Property mdoMissoverProperty = (Property)omr.acquireOMRObject(sMissoverID, "Property");
        mdoMissoverProperty.setName("MISSOVER");
        if (this.isRecordWrappingEnabled()) {
            mdoMissoverProperty.setDefaultValue("false");
        } else {
            mdoMissoverProperty.setDefaultValue("true");
        }
        mdoAList.add((Object)mdoMissoverProperty);
        String sOverrideDelimiterID = this.m_overrideDelimiterID.equals("") || this.m_overrideDelimiterID.length() == 0 ? this.createIDForNewObject() : this.m_overrideDelimiterID;
        Property mdoOverrideDelimiterProperty = (Property)omr.acquireOMRObject(sOverrideDelimiterID, "Property");
        mdoOverrideDelimiterProperty.setName("OVERRIDEDELIMITER");
        if (!this.m_overrideDelimiter.equals(null)) {
            mdoOverrideDelimiterProperty.setDefaultValue(this.m_overrideDelimiter);
        }
        mdoAList.add((Object)mdoOverrideDelimiterProperty);
        String sQuotesProtectID = this.m_quotesProtectDelimitersID.equals("") || this.m_quotesProtectDelimitersID.length() == 0 ? this.createIDForNewObject() : this.m_quotesProtectDelimitersID;
        Property mdoQuotesProtectProperty = (Property)omr.acquireOMRObject(sQuotesProtectID, "Property");
        mdoQuotesProtectProperty.setName("DELIMITERQUOTING");
        if (this.isDelimiterQuotingEnabled()) {
            mdoQuotesProtectProperty.setDefaultValue("true");
        } else {
            mdoQuotesProtectProperty.setDefaultValue("false");
        }
        mdoAList.add((Object)mdoQuotesProtectProperty);
    }

    private class SetDelimitersUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetDelimitersUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            DelimitedExternalFile.this.setDelimiters(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            DelimitedExternalFile.this.setDelimiters(this.m_newValue);
        }
    }

    private class SetDelimiterQuotingEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_enabled;

        public SetDelimiterQuotingEnabledUndoable(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public void undo() {
            super.undo();
            DelimitedExternalFile.this.setDelimiterQuotingEnabled(!this.m_enabled);
        }

        @Override
        public void redo() {
            super.redo();
            DelimitedExternalFile.this.setDelimiterQuotingEnabled(this.m_enabled);
        }
    }

    private class SetConsecutiveDelimiterSkippingEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_enabled;

        public SetConsecutiveDelimiterSkippingEnabledUndoable(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public void undo() {
            super.undo();
            DelimitedExternalFile.this.setConsecutiveDelimiterSkippingEnabled(!this.m_enabled);
        }

        @Override
        public void redo() {
            super.redo();
            DelimitedExternalFile.this.setConsecutiveDelimiterSkippingEnabled(this.m_enabled);
        }
    }

    private class SetMultipleRecordsPerLineEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_enabled;

        public SetMultipleRecordsPerLineEnabledUndoable(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public void undo() {
            super.undo();
            DelimitedExternalFile.this.setMultipleRecordsPerLineEnabled(!this.m_enabled);
        }

        @Override
        public void redo() {
            super.redo();
            DelimitedExternalFile.this.setMultipleRecordsPerLineEnabled(this.m_enabled);
        }
    }

    private class SetRecordWrappingEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_enabled;

        public SetRecordWrappingEnabledUndoable(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public void undo() {
            super.undo();
            DelimitedExternalFile.this.setRecordWrappingEnabled(!this.m_enabled);
        }

        @Override
        public void redo() {
            super.redo();
            DelimitedExternalFile.this.setRecordWrappingEnabled(this.m_enabled);
        }
    }

    private class SetOverrideDelimiterUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetOverrideDelimiterUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            DelimitedExternalFile.this.setOverrideDelimiter(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            DelimitedExternalFile.this.setOverrideDelimiter(this.m_newValue);
        }
    }
}

