/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.externalfile.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.externalfile.IStructuredExternalFile;
import com.sas.etl.models.data.impl.BaseFile;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IFileAccessServer;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASFileRef;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.rio.MVAResultSet;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class AbstractStructuredExternalFile
extends BaseFile
implements IStructuredExternalFile {
    private int m_iRecordLength = 256;
    private String m_sNumericMissingValue = "";
    private String m_sSpecialMissingValue = "";
    private boolean m_bCreateView = false;
    private String m_sStartingRecord = "1";
    private String m_sNumberOfRecords = "";
    private String m_sAdditionalInfileOptions = "";
    private boolean m_bOverrideInfile = false;
    private String m_sInfileOverrideText = "";
    private boolean m_bSpecialCharactersInColumnNames = false;
    private boolean m_bCaseSensitiveColumnNames = false;
    private String m_sInfileEncodingOptions = "";
    private boolean m_bDoubleQuoteFilename;
    private boolean m_bNoQuoteFilename;
    private String m_sNumericMissingValueID = "";
    private String m_sSpecialMissingValueID = "";
    private String m_sInfileOptionsID = "";
    private String m_sInfileEncodingID = "";
    private String m_sInfileOverrideTextID = "";
    private String m_sFileRefID = "";
    private List m_lNumericMissingValues;
    private List m_lSpecialMissingValues;
    private boolean m_bIsDirectory = false;
    private IFileAccessServer m_accessServer;
    protected String m_logicalFilename;

    public AbstractStructuredExternalFile(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getNumericMissingValue() {
        return this.m_sNumericMissingValue;
    }

    @Override
    public void setNumericMissingValue(String value) {
        if (this.m_sNumericMissingValue.equalsIgnoreCase(value)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNumericMissingValueUndoable(this.m_sNumericMissingValue, value));
        }
        this.m_sNumericMissingValue = value;
        this.m_lNumericMissingValues = this.createMissingListFromString(this.m_sNumericMissingValue);
        this.fireModelChangedEvent("ExternalTable:MissingNumericValueChanged", null);
    }

    @Override
    public List getNumericMissingValues() {
        return this.m_lNumericMissingValues;
    }

    @Override
    public List getSpecialMissingValues() {
        return this.m_lSpecialMissingValues;
    }

    private List createMissingListFromString(String missingString) {
        ArrayList<String> list = new ArrayList<String>();
        String numericText = missingString;
        if (numericText == null) {
            numericText = "";
        }
        String delimiters = String.valueOf(MISSING_VALUE_DELIMITER);
        StringTokenizer tokenizer = new StringTokenizer(numericText, delimiters);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    @Override
    public String getSpecialMissingValue() {
        return this.m_sSpecialMissingValue;
    }

    @Override
    public void setSpecialMissingValue(String value) {
        if (this.m_sSpecialMissingValue.equalsIgnoreCase(value)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSpecialMissingValueUndoable(this.m_sSpecialMissingValue, value));
        }
        this.m_sSpecialMissingValue = value;
        this.m_lSpecialMissingValues = this.createMissingListFromString(this.m_sSpecialMissingValue);
        this.fireModelChangedEvent("ExternalTable:MissingSpecialValueChanged", null);
    }

    @Override
    public boolean isView() {
        return this.m_bCreateView;
    }

    @Override
    public void setView(boolean enabled) {
        if (this.m_bCreateView == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetViewUndoable(enabled));
        }
        this.m_bCreateView = enabled;
        this.fireModelChangedEvent("BaseExternalTable:CreateViewChanged", null);
    }

    @Override
    public boolean isDoubleQuoteFilename() {
        return this.m_bDoubleQuoteFilename;
    }

    @Override
    public void setDoubleQuoteFilename(boolean enabled) {
        if (this.m_bDoubleQuoteFilename == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDoubleQuoteFilenameUndoable(enabled));
        }
        this.m_bDoubleQuoteFilename = enabled;
        this.fireModelChangedEvent("ExternalTable:DoubleQuoteFilenameChanged", null);
    }

    @Override
    public boolean isNoQuoteFilename() {
        return this.m_bNoQuoteFilename;
    }

    @Override
    public void setNoQuoteFilename(boolean enabled) {
        if (this.m_bNoQuoteFilename == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNoQuoteFilenameUndoable(enabled));
        }
        this.m_bNoQuoteFilename = enabled;
        this.fireModelChangedEvent("ExternalTable:NoQuoteFilenameChanged", null);
    }

    @Override
    public String getInfileEncodingOptions() {
        return this.m_sInfileEncodingOptions;
    }

    @Override
    public void setInfileEncodingOptions(String encoding) {
        if (this.m_sInfileEncodingOptions.equalsIgnoreCase(encoding)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetInfileEncodingUndoable(this.m_sInfileEncodingOptions, encoding));
        }
        this.m_sInfileEncodingOptions = encoding;
        this.fireModelChangedEvent("ExternalTable:InfileEncodingChanged", null);
    }

    @Override
    public int getRecordLength() {
        return this.m_iRecordLength;
    }

    @Override
    public void setRecordLength(int recordLength) {
        if (this.m_iRecordLength == recordLength) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRecordLengthUndoable(this.m_iRecordLength, recordLength));
        }
        this.m_iRecordLength = recordLength;
        this.fireModelChangedEvent("ExternalTable:RecordLengthChanged", null);
    }

    @Override
    public String getStartingRecordNumber() {
        return this.m_sStartingRecord;
    }

    @Override
    public void setStartingRecordNumber(String start) {
        if (this.m_sStartingRecord.equalsIgnoreCase(start)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetStartingRecordNumberUndoable(this.m_sStartingRecord, start));
        }
        this.m_sStartingRecord = start;
        this.fireModelChangedEvent("ExternalTable:StartingRecordChanged", null);
    }

    @Override
    public String getNumberOfRecords() {
        return this.m_sNumberOfRecords;
    }

    @Override
    public void setNumberOfRecords(String number) {
        if (this.m_sNumberOfRecords.equalsIgnoreCase(number)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNumberOfRecordsUndoable(this.m_sNumberOfRecords, number));
        }
        this.m_sNumberOfRecords = number;
        this.fireModelChangedEvent("ExternalTable:NumberOfRecordsChanged", null);
    }

    @Override
    public boolean isDirectory() {
        return this.m_bIsDirectory;
    }

    @Override
    public void setIsDirectory(boolean isDirectory) {
        if (this.m_bIsDirectory == isDirectory) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIsDirectoryUndoable());
        }
        this.m_bIsDirectory = isDirectory;
        this.fireModelChangedEvent("ExternalTable:IsDirectoryChanged", isDirectory);
    }

    @Override
    public boolean isSpecialCharacters() {
        return this.m_bSpecialCharactersInColumnNames;
    }

    @Override
    public void setSpecialCharacters(boolean enabled) {
        if (this.m_bSpecialCharactersInColumnNames == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSpecialCharactersUndoable(enabled));
        }
        this.m_bSpecialCharactersInColumnNames = enabled;
        this.fireModelChangedEvent("ExternalTable:SpecialCharactersInColumnNamesChanged", null);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.m_bCaseSensitiveColumnNames;
    }

    @Override
    public void setCaseSensitive(boolean enabled) {
        if (this.m_bCaseSensitiveColumnNames == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCaseSensitiveUndoable(enabled));
        }
        this.m_bCaseSensitiveColumnNames = enabled;
        this.fireModelChangedEvent("ExternalTable:CaseSensitiveColumnNamesChanged", null);
    }

    @Override
    public boolean isColumnQuotingNeeded() {
        return this.isCaseSensitive() || this.isSpecialCharacters();
    }

    @Override
    public String getAdditionalInfileOptions() {
        return this.m_sAdditionalInfileOptions;
    }

    @Override
    public void setAdditionalInfileOptions(String options) {
        if (this.m_sAdditionalInfileOptions.equalsIgnoreCase(options)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAdditionalInfileOptionsUndoable(this.m_sAdditionalInfileOptions, options));
        }
        this.m_sAdditionalInfileOptions = options;
        this.fireModelChangedEvent("ExternalTable:AdditionalInfileOptionsChanged", null);
    }

    @Override
    public boolean getInfileOverrideFlag() {
        return this.m_bOverrideInfile;
    }

    @Override
    public String getInfileOverrideText() {
        return this.m_sInfileOverrideText;
    }

    @Override
    public void setInfileOverrideFlag(boolean override) {
        if (this.m_bOverrideInfile == override) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetInfileOverrideFlagUndoable(this.m_bOverrideInfile, override));
        }
        this.m_bOverrideInfile = override;
        this.fireModelChangedEvent("ExternalTable:InfileOverrideChanged", null);
    }

    @Override
    public void setInfileOverrideText(String overrideText) {
        if (this.m_sInfileOverrideText.equalsIgnoreCase(overrideText)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetInfileOverrideTextUndoable(this.m_sInfileOverrideText, overrideText));
        }
        this.m_sInfileOverrideText = overrideText;
        this.fireModelChangedEvent("ExternalTable:InfileOverrideChanged", null);
    }

    @Override
    public void setAccessServer(IFileAccessServer accessServer) {
        if (this.m_accessServer == accessServer) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAccessServerUndoable(this.m_accessServer, accessServer));
        }
        this.m_accessServer = accessServer;
        this.fireModelChangedEvent("ExternalTable:AccessServerChanged", null);
    }

    @Override
    public IFileAccessServer getAccessServer() {
        return this.m_accessServer;
    }

    @Override
    public void loadServerFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        File mdoFile = (File)omr.acquireOMRObject(this);
        AssociationList filerefs = mdoFile.getFileRefs();
        IServer server = null;
        if (!filerefs.isEmpty()) {
            SASFileRef mdoFileRef = (SASFileRef)filerefs.get(0);
            this.m_sFileRefID = mdoFileRef.getFQID();
            AssociationList mdoFilerefServerList = mdoFileRef.getDeployedComponents();
            if (!mdoFilerefServerList.isEmpty()) {
                ServerComponent mdoFilerefSC = (ServerComponent)mdoFilerefServerList.get(0);
                server = (IServer)omr.acquireObject((Root)mdoFilerefSC);
            }
        }
        this.setServer(server);
        IFileAccessServer accessServer = null;
        AssociationList comps = mdoFile.getDeployedComponents();
        if (!comps.isEmpty()) {
            accessServer = (IFileAccessServer)omr.acquireObject((Root)comps.get(0));
        }
        this.setAccessServer(accessServer);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        AssociationList lNotes;
        String propertyValue;
        super.loadFromOMR(omr);
        String sLrecl = this.loadPropertyFromOMR(omr, "EFI_GENERAL", "LRECL", "256", 32);
        this.setRecordLength(this.convertStringToInt(sLrecl, 256));
        this.setStartingRecordNumber(this.loadPropertyFromOMR(omr, "EFI_GENERAL", "STARTRECORD", "1", 32));
        this.setNumberOfRecords(this.loadPropertyFromOMR(omr, "EFI_GENERAL", "OBS", "", 32));
        File mdoFile = (File)omr.acquireOMRObject(this);
        Property mdoCreateViewProperty = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "CREATEVIEW", 32);
        if (mdoCreateViewProperty == null) {
            this.setView(false);
        } else {
            propertyValue = this.loadStringOptionFromOMR(omr, "EFI_GENERAL", "CREATEVIEW", "");
            if (propertyValue.length() == 0) {
                this.setView(true);
            } else {
                this.setView(Boolean.valueOf(propertyValue));
            }
        }
        Property mdoSpecialCharactersInColumns = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "SPECIALCHARACTERSINCOLUMNS", 32);
        if (mdoSpecialCharactersInColumns == null) {
            this.setSpecialCharacters(false);
        } else {
            propertyValue = this.loadStringOptionFromOMR(omr, "EFI_GENERAL", "SPECIALCHARACTERSINCOLUMNS", "");
            if (propertyValue.length() == 0) {
                this.setSpecialCharacters(true);
            } else {
                this.setSpecialCharacters(Boolean.valueOf(propertyValue));
            }
        }
        Property mdoReadDirectory = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "READDIRECTORY", 32);
        this.setIsDirectory(mdoReadDirectory != null);
        Property mdoDoubleQuoteFilename = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "DOUBLEQUOTE", 32);
        if (mdoDoubleQuoteFilename == null) {
            this.setDoubleQuoteFilename(false);
        } else {
            propertyValue = this.loadPropertyFromOMR(omr, "EFI_GENERAL", "DOUBLEQUOTE", "", 32);
            this.setDoubleQuoteFilename(true);
        }
        Property mdoNoQuoteFilename = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "NOQUOTE", 32);
        if (mdoNoQuoteFilename == null) {
            this.setNoQuoteFilename(false);
        } else {
            propertyValue = this.loadPropertyFromOMR(omr, "EFI_GENERAL", "DOUBLEQUOTE", "", 32);
            this.setNoQuoteFilename(true);
        }
        Property mdoCaseSensitiveColumns = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "CASESENSITIVECOLUMNS", 32);
        if (mdoCaseSensitiveColumns == null) {
            this.setCaseSensitive(false);
        } else {
            propertyValue = this.loadStringOptionFromOMR(omr, "EFI_GENERAL", "CASESENSITIVECOLUMNS", "");
            if (propertyValue.length() == 0) {
                this.setCaseSensitive(true);
            } else {
                this.setCaseSensitive(Boolean.valueOf(propertyValue));
            }
        }
        Property mdoProperty = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "MISSINGVALUES_NUMBERS", 32);
        if (mdoProperty == null) {
            this.setNumericMissingValue("");
        } else {
            lNotes = mdoProperty.getNotes();
            if (!lNotes.isEmpty()) {
                TextStore mdoNumericMissingValue = (TextStore)lNotes.get(0);
                this.m_sNumericMissingValueID = mdoNumericMissingValue.getFQID();
                this.setNumericMissingValue(mdoNumericMissingValue.getStoredText());
            } else {
                this.setNumericMissingValue("");
            }
        }
        mdoProperty = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "MISSINGVALUES_SPECIAL", 32);
        if (mdoProperty == null) {
            this.setSpecialMissingValue("");
        } else {
            lNotes = mdoProperty.getNotes();
            if (!lNotes.isEmpty()) {
                TextStore mdoSpecialMissingValue = (TextStore)lNotes.get(0);
                this.m_sSpecialMissingValueID = mdoSpecialMissingValue.getFQID();
                this.setSpecialMissingValue(mdoSpecialMissingValue.getStoredText());
            } else {
                this.setSpecialMissingValue("");
            }
        }
        mdoProperty = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "INFILEOPTIONS", 32);
        if (mdoProperty == null) {
            this.setAdditionalInfileOptions("");
        } else {
            lNotes = mdoProperty.getNotes();
            if (!lNotes.isEmpty()) {
                TextStore mdoInfileOptions = (TextStore)lNotes.get(0);
                this.m_sInfileOptionsID = mdoInfileOptions.getFQID();
                this.setAdditionalInfileOptions(mdoInfileOptions.getStoredText());
            } else {
                this.setAdditionalInfileOptions("");
            }
        }
        mdoProperty = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "INFILEENCODING", 32);
        if (mdoProperty == null) {
            this.setInfileEncodingOptions("");
        } else {
            lNotes = mdoProperty.getNotes();
            if (!lNotes.isEmpty()) {
                TextStore mdoInfileEncoding = (TextStore)lNotes.get(0);
                this.m_sInfileEncodingID = mdoInfileEncoding.getFQID();
                this.setInfileEncodingOptions(mdoInfileEncoding.getStoredText());
            } else {
                this.setInfileEncodingOptions("");
            }
        }
        mdoProperty = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "INFILEOVERRIDE", 32);
        if (mdoProperty == null) {
            this.setInfileOverrideFlag(false);
            this.setInfileOverrideText("");
        } else {
            propertyValue = this.loadStringOptionFromOMR(omr, "EFI_GENERAL", "INFILEOVERRIDE", "");
            if (propertyValue.length() == 0 || "YES".equals(propertyValue)) {
                this.setInfileOverrideFlag(true);
            } else {
                this.setInfileOverrideFlag(Boolean.valueOf(propertyValue));
            }
            lNotes = mdoProperty.getNotes();
            if (!lNotes.isEmpty()) {
                TextStore mdoOverrideText = (TextStore)lNotes.get(0);
                this.m_sInfileOverrideTextID = mdoOverrideText.getFQID();
                this.setInfileOverrideText(mdoOverrideText.getStoredText());
            } else {
                this.setInfileOverrideText("");
            }
        }
        this.setChanged(false);
    }

    @Override
    protected void saveServerToOMR(OMRAdapter omr) throws MdException, RemoteException {
        File mdoFile = (File)omr.acquireOMRObject(this);
        AssociationList mdoFilerefs = mdoFile.getFileRefs();
        mdoFilerefs.clear();
        if (this.m_sFileRefID.length() > 0) {
            SASFileRef mdoFileref = (SASFileRef)omr.acquireOMRObject(this.m_sFileRefID, "SASFileRef");
            mdoFilerefs.add(mdoFileref);
            mdoFileref.setFileref("ETLFILER");
            mdoFileref.setName(this.getFileName());
            AssociationList mdoServers = mdoFileref.getDeployedComponents(false);
            mdoServers.clear();
            IServer server = this.getServer();
            if (server != null) {
                mdoServers.add(omr.acquireOMRObject(server));
            }
        }
        IFileAccessServer accessServer = this.getAccessServer();
        AssociationList comps = mdoFile.getDeployedComponents(false);
        comps.clear();
        if (accessServer != null) {
            comps.add(omr.acquireOMRObject(accessServer));
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        Property mdoProp;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        File mdoFile = (File)omr.acquireOMRObject(this);
        if (this.m_iRecordLength <= 0) {
            this.m_iRecordLength = 256;
        }
        this.savePropertyToOMR(omr, "EFI_GENERAL", "LRECL", "", "", Integer.toString(this.m_iRecordLength), 12, 32);
        this.savePropertyToOMR(omr, "EFI_GENERAL", "STARTRECORD", "", "", this.m_sStartingRecord, 12, 32);
        this.savePropertyToOMR(omr, "EFI_GENERAL", "OBS", "", "", this.m_sNumberOfRecords, 12, 32);
        this.saveBooleanOptionToOMR(omr, "EFI_GENERAL", "CASESENSITIVECOLUMNS", this.m_bCaseSensitiveColumnNames);
        this.saveBooleanOptionToOMR(omr, "EFI_GENERAL", "SPECIALCHARACTERSINCOLUMNS", this.m_bSpecialCharactersInColumnNames);
        this.saveBooleanOptionToOMR(omr, "EFI_GENERAL", "CREATEVIEW", this.m_bCreateView);
        if (this.m_bDoubleQuoteFilename) {
            this.savePropertyToOMR(omr, (Root)mdoFile, "EFI_GENERAL", "DOUBLEQUOTE", "", "", "", 12, 32);
        } else {
            mdoProp = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "DOUBLEQUOTE", 32);
            if (mdoProp != null) {
                this.deletePropertyFromOMR(omr, "EFI_GENERAL", "DOUBLEQUOTE");
            }
        }
        if (this.m_bNoQuoteFilename) {
            this.savePropertyToOMR(omr, (Root)mdoFile, "EFI_GENERAL", "NOQUOTE", "", "", "", 12, 32);
        } else {
            mdoProp = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "NOQUOTE", 32);
            if (mdoProp != null) {
                this.deletePropertyFromOMR(omr, "EFI_GENERAL", "NOQUOTE");
            }
        }
        if (this.isDirectory()) {
            this.savePropertyToOMR(omr, (Root)mdoFile, "EFI_GENERAL", "READDIRECTORY", "", "", "", 12, 32);
        } else {
            mdoProp = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "READDIRECTORY", 32);
            if (mdoProp != null) {
                this.deletePropertyFromOMR(omr, "EFI_GENERAL", "READDIRECTORY");
            }
        }
        String sTextStoreID = this.m_sInfileEncodingID.equals("") || this.m_sInfileEncodingID.length() == 0 ? this.createIDForNewObject() : this.m_sInfileEncodingID;
        TextStore mdoTS = (TextStore)omr.acquireOMRObject(sTextStoreID, "TextStore");
        mdoTS.setName("INFILEENCODING");
        mdoTS.setStoredText(this.m_sInfileEncodingOptions);
        this.saveStringOptionToOMR(omr, "EFI_GENERAL", "INFILEENCODING", "");
        Property mdoProp2 = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "INFILEENCODING", 0);
        AssociationList mdoAList = mdoProp2.getNotes();
        mdoAList.clear();
        mdoAList.add((Object)mdoTS);
        sTextStoreID = this.m_sInfileOptionsID.equalsIgnoreCase("") || this.m_sInfileOptionsID.length() == 0 ? this.createIDForNewObject() : this.m_sInfileOptionsID;
        mdoTS = (TextStore)omr.acquireOMRObject(sTextStoreID, "TextStore");
        mdoTS.setName("INFILEOPTIONS");
        mdoTS.setStoredText(this.m_sAdditionalInfileOptions);
        this.saveStringOptionToOMR(omr, "EFI_GENERAL", "INFILEOPTIONS", "");
        mdoAList = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "INFILEOPTIONS", 0).getNotes();
        mdoAList.clear();
        mdoAList.add((Object)mdoTS);
        sTextStoreID = this.m_sInfileOverrideTextID.equalsIgnoreCase("") || this.m_sInfileOverrideTextID.length() == 0 ? this.createIDForNewObject() : this.m_sInfileOverrideTextID;
        mdoTS = (TextStore)omr.acquireOMRObject(sTextStoreID, "TextStore");
        mdoTS.setName("INFILEOVERRIDE");
        mdoTS.setStoredText(this.m_sInfileOverrideText);
        this.saveStringOptionToOMR(omr, "EFI_GENERAL", "INFILEOVERRIDE", "");
        mdoAList = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "INFILEOVERRIDE", 0).getNotes();
        mdoAList.clear();
        mdoAList.add((Object)mdoTS);
        this.saveBooleanOptionToOMR(omr, "EFI_GENERAL", "INFILEOVERRIDE", this.m_bOverrideInfile);
        sTextStoreID = this.m_sNumericMissingValueID.equalsIgnoreCase("") || this.m_sNumericMissingValueID.length() == 0 ? this.createIDForNewObject() : this.m_sNumericMissingValueID;
        mdoTS = (TextStore)omr.acquireOMRObject(sTextStoreID, "TextStore");
        mdoTS.setName("MISSINGVALUES_NUMBERS");
        mdoTS.setStoredText(this.m_sNumericMissingValue);
        this.saveStringOptionToOMR(omr, "EFI_GENERAL", "MISSINGVALUES_NUMBERS", "");
        mdoAList = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "MISSINGVALUES_NUMBERS", 0).getNotes();
        mdoAList.clear();
        mdoAList.add((Object)mdoTS);
        sTextStoreID = this.m_sSpecialMissingValueID.equalsIgnoreCase("") || this.m_sSpecialMissingValueID.length() == 0 ? this.createIDForNewObject() : this.m_sSpecialMissingValueID;
        mdoTS = (TextStore)omr.acquireOMRObject(sTextStoreID, "TextStore");
        mdoTS.setName("MISSINGVALUES_SPECIAL");
        mdoTS.setStoredText(this.m_sSpecialMissingValue);
        this.saveStringOptionToOMR(omr, "EFI_GENERAL", "MISSINGVALUES_SPECIAL", "");
        mdoProp2 = this.findProperty(omr, (Root)mdoFile, "EFI_GENERAL", "MISSINGVALUES_SPECIAL", 0);
        mdoAList = mdoProp2.getNotes();
        mdoAList.clear();
        mdoAList.add((Object)mdoTS);
        this.setChanged(false);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_sInfileEncodingID != null && this.m_sInfileEncodingID.length() > 0) {
            omr.deleteOMRObject(this.m_sInfileEncodingID, "TextStore");
        }
        if (this.m_sInfileOptionsID != null && this.m_sInfileOptionsID.length() > 0) {
            omr.deleteOMRObject(this.m_sInfileOptionsID, "TextStore");
        }
        if (this.m_sInfileOverrideTextID != null && this.m_sInfileOverrideTextID.length() > 0) {
            omr.deleteOMRObject(this.m_sInfileOverrideTextID, "TextStore");
        }
        if (this.m_sNumericMissingValueID != null && this.m_sNumericMissingValue.length() > 0) {
            omr.deleteOMRObject(this.m_sNumericMissingValue, "TextStore");
        }
        if (this.m_sSpecialMissingValueID != null && this.m_sSpecialMissingValue.length() > 0) {
            omr.deleteOMRObject(this.m_sSpecialMissingValue, "TextStore");
        }
        this.deletePropertiesAndPropertySetsFromOMR(omr);
        if (this.m_sFileRefID != null && this.m_sFileRefID.length() > 0) {
            omr.deleteOMRObject(this.m_sFileRefID, "SASFileRef");
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("TransformationTargets");
            lAssociations.add("TransformationSources");
            lAssociations.add("OwningFile");
            map.put(this.getOMRType(), lAssociations);
        } else {
            lAssociations.add("TransformationTargets");
            lAssociations.add("TransformationSources");
            lAssociations.add("OwningFile");
        }
        return map;
    }

    private int convertStringToInt(String string, int iDefault) throws RemoteException, MdException {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iDefault;
    }

    @Override
    public void setLogicalFilename(String file) {
        this.m_logicalFilename = file;
    }

    @Override
    public String getLogicalFilename() {
        return this.m_logicalFilename;
    }

    @Override
    public boolean setLogicalFilename(WsAppServer appServer) {
        this.m_logicalFilename = this.getFileName();
        if (this.isDoubleQuoteFilename()) {
            if (appServer == null) {
                return false;
            }
            String tName = "";
            String dsString = " data work._ETL_Temp; \n length fname $200.; \n fname = \"" + this.getFileName() + "\"; \nrun;";
            MVAResultSet myTable = null;
            try {
                appServer.submitSASCode(dsString);
                dsString = "select fname from work._ETL_Temp";
                myTable = appServer.submitSQLStatement(dsString);
                myTable.next();
                tName = myTable.getString(1).trim();
                myTable.close();
            }
            catch (SQLException sQLException) {
            }
            catch (WsAppServerCodeException wsAppServerCodeException) {
            }
            catch (WsAppServerFailException wsAppServerFailException) {
                // empty catch block
            }
            this.setLogicalFilename(tName);
        } else if (this.isNoQuoteFilename()) {
            if (appServer == null) {
                return false;
            }
            String tName = "";
            String dsString = "";
            MVAResultSet myTable = null;
            try {
                dsString = "select xpath from DICTIONARY.EXTFILES where fileref=\"" + this.getFileName().toUpperCase() + "\"";
                myTable = appServer.submitSQLStatement(dsString);
                myTable.next();
                tName = myTable.getString(1).trim();
                myTable.close();
            }
            catch (SQLException sQLException) {
            }
            catch (WsAppServerFailException wsAppServerFailException) {
                // empty catch block
            }
            this.setLogicalFilename(tName);
        } else {
            this.setLogicalFilename(this.getFileName());
        }
        return true;
    }

    private class SetNumericMissingValueUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetNumericMissingValueUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setNumericMissingValue(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setNumericMissingValue(this.m_newValue);
        }
    }

    private class SetSpecialMissingValueUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetSpecialMissingValueUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setSpecialMissingValue(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setSpecialMissingValue(this.m_newValue);
        }
    }

    private class SetViewUndoable
    extends AbstractUndoableEdit {
        private boolean m_enabled;

        public SetViewUndoable(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setView(!this.m_enabled);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setView(this.m_enabled);
        }
    }

    private class SetDoubleQuoteFilenameUndoable
    extends AbstractUndoableEdit {
        private boolean m_enabled;

        public SetDoubleQuoteFilenameUndoable(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setDoubleQuoteFilename(!this.m_enabled);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setDoubleQuoteFilename(this.m_enabled);
        }
    }

    private class SetNoQuoteFilenameUndoable
    extends AbstractUndoableEdit {
        private boolean m_enabled;

        public SetNoQuoteFilenameUndoable(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setNoQuoteFilename(!this.m_enabled);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setNoQuoteFilename(this.m_enabled);
        }
    }

    private class SetInfileEncodingUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetInfileEncodingUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setInfileEncodingOptions(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setInfileEncodingOptions(this.m_newValue);
        }
    }

    private class SetRecordLengthUndoable
    extends AbstractUndoableEdit {
        private int m_oldLength;
        private int m_newLength;

        public SetRecordLengthUndoable(int oldLength, int newLength) {
            this.m_oldLength = oldLength;
            this.m_newLength = newLength;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setRecordLength(this.m_oldLength);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setRecordLength(this.m_newLength);
        }
    }

    private class SetStartingRecordNumberUndoable
    extends AbstractUndoableEdit {
        private String m_oldStartingRecordNumber;
        private String m_newStartingRecordNumber;

        public SetStartingRecordNumberUndoable(String oldStart, String newStart) {
            this.m_oldStartingRecordNumber = oldStart;
            this.m_newStartingRecordNumber = newStart;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setStartingRecordNumber(this.m_oldStartingRecordNumber);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setStartingRecordNumber(this.m_newStartingRecordNumber);
        }
    }

    private class SetNumberOfRecordsUndoable
    extends AbstractUndoableEdit {
        private String m_oldNumberOfRecords;
        private String m_newNumberOfRecords;

        public SetNumberOfRecordsUndoable(String oldNumber, String newNumber) {
            this.m_oldNumberOfRecords = oldNumber;
            this.m_newNumberOfRecords = newNumber;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setNumberOfRecords(this.m_oldNumberOfRecords);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setNumberOfRecords(this.m_newNumberOfRecords);
        }
    }

    private class SetIsDirectoryUndoable
    extends AbstractUndoableEdit {
        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setIsDirectory(!AbstractStructuredExternalFile.this.isDirectory());
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setIsDirectory(!AbstractStructuredExternalFile.this.isDirectory());
        }
    }

    private class SetSpecialCharactersUndoable
    extends AbstractUndoableEdit {
        private boolean m_enabled;

        public SetSpecialCharactersUndoable(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setSpecialCharacters(!this.m_enabled);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setSpecialCharacters(this.m_enabled);
        }
    }

    private class SetCaseSensitiveUndoable
    extends AbstractUndoableEdit {
        private boolean m_enabled;

        public SetCaseSensitiveUndoable(boolean enabled) {
            this.m_enabled = enabled;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setCaseSensitive(!this.m_enabled);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setCaseSensitive(this.m_enabled);
        }
    }

    private class SetAdditionalInfileOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetAdditionalInfileOptionsUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setAdditionalInfileOptions(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setAdditionalInfileOptions(this.m_newValue);
        }
    }

    private class SetInfileOverrideFlagUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetInfileOverrideFlagUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setInfileOverrideFlag(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setInfileOverrideFlag(this.m_newValue);
        }
    }

    private class SetInfileOverrideTextUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetInfileOverrideTextUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setInfileOverrideText(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setInfileOverrideText(this.m_newValue);
        }
    }

    private class SetAccessServerUndoable
    extends AbstractUndoableEdit {
        private IFileAccessServer m_oldValue;
        private IFileAccessServer m_newValue;

        public SetAccessServerUndoable(IFileAccessServer oldValue, IFileAccessServer newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractStructuredExternalFile.this.setAccessServer(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractStructuredExternalFile.this.setAccessServer(this.m_newValue);
        }
    }
}

