/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.edmflow.impl;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.edmflow.IEDMFlowColumn;
import com.sas.etl.models.data.edmflow.IEDMFlowTable;
import com.sas.etl.models.data.edmflow.impl.RB;
import com.sas.etl.models.data.impl.BaseGeneratedTableColumn;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.publicobjects.decisionlogic.DSDataType;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseEDMFlowColumn
extends BaseGeneratedTableColumn
implements IEDMFlowColumn {
    private DSDataType _type;
    private IEDMFlowTable _edmTable;
    private String _displayName;

    public BaseEDMFlowColumn(IEDMFlowTable table, String sID) {
        super(table, sID);
        this._edmTable = table;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (DSDataType.DATAGRID == this._type) {
            this.setSASLength(Short.MAX_VALUE);
        } else {
            this.setSASLength(this.getDefaultSASLength());
        }
    }

    @Override
    public DSDataType getDataType() {
        return this._type;
    }

    @Override
    public void setDataType(DSDataType type) {
        this._type = type;
        if (type == DSDataType.BOOLEAN || type == DSDataType.DATETIME || type == DSDataType.FLOAT || type == DSDataType.INTEGER) {
            this.setSASType(1);
        } else {
            this.setSASType(0);
        }
        if (DSDataType.DATETIME == this._type) {
            this.setFormat("nldatm.");
            this.setInformat("nldatm.");
        }
        if (DSDataType.DATAGRID == type) {
            this.setSASLength(Short.MAX_VALUE);
        }
    }

    private Map<String, Integer> getDefaultLengthMap() {
        if (this._edmTable != null) {
            // empty if block
        }
        return new HashMap<String, Integer>();
    }

    @Override
    public boolean isComplete(IColumn column) {
        return super.isComplete(column) && column != null && ObjectComparator.isEqual(this.getName(), column.getName(), false) && this.getSASType() == column.getType();
    }

    @Override
    public List getReasonsIncomplete(IColumn column) {
        List lst = super.getReasonsIncomplete(column);
        if (!ObjectComparator.isEqual(this.getName(), column.getName(), false)) {
            lst.add(MessageFormat.format(RB.getStringResource("BaseEDMFlowColumn.ColumnNameNoMatch.fmt"), column.getName(), this.getName()));
        }
        if (this.getSASType() != column.getType()) {
            lst.add(MessageFormat.format(RB.getStringResource("BaseEDMFlowColumn.ColumnTypeNoMatch.fmt"), column.getName()));
        }
        return lst;
    }

    public int getDefaultSASLength() {
        if (this.getTable() != null && this.getName() != null) {
            String fullCName = this.getTable().getName() + '.' + this.getName();
            Map<String, Integer> defaultMap = this.getDefaultLengthMap();
            if (defaultMap.containsKey(fullCName)) {
                return defaultMap.get(fullCName);
            }
        }
        if (0 == this.getSASType()) {
            return 250;
        }
        return 8;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public void setDisplayName(String value) {
        this._displayName = value;
        if (value != null && value.length() > 0 && (this.getName() == null || this.getName().length() == 0)) {
            this.setName(value);
        }
    }
}

