/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.dbmstypes.SASType;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.List;

public class SPDEType
extends SASType {
    public static final String ASYNC_INDEX = "ASYNCINDEX";

    public SPDEType() {
        this.setConstraintSupport(false);
    }

    @Override
    public ICodeSegment createConstraints(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        return codeSegment;
    }

    @Override
    public ICodeSegment createIndexes2(ICodeSegment codeSegment, IPhysicalTable table, List indexList, String altTableName) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (table.isView()) {
            return codeSegment;
        }
        if (indexList == null) {
            indexList = this.getIndexesToCreate(table);
        }
        if (!indexList.isEmpty()) {
            codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.CreateIndex.msg.notrans"));
            codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.CreateIndex.note.sasmacro.notrans"));
            String tabname = "";
            String tableDSOptions = "";
            if (altTableName != null && altTableName.length() > 0) {
                tabname = altTableName;
            } else {
                tabname = table.getFullNameQuotedAsNeeded(codeSegment);
                tableDSOptions = table.getReadTableOptions(false);
            }
            String libname = DBMSNamesUtil.getLibrefPart(tabname);
            String tableName = DBMSNamesUtil.getTableNamePart(tabname);
            boolean useSQL = true;
            for (int i = 0; i < indexList.size(); ++i) {
                IIndex index = (IIndex)indexList.get(i);
                if (!"Yes".equals(index.getUserProperty(ASYNC_INDEX)) && !index.isNoMissingValues()) continue;
                useSQL = false;
                break;
            }
            if (!useSQL) {
                codeSegment.addSourceCode("proc datasets lib = " + libname + " nolist; \n").indent();
            } else {
                codeSegment.addSourceCode("proc sql; \n").indent();
            }
            String indexOptions = "";
            for (int i = 0; i < indexList.size(); ++i) {
                indexOptions = tableDSOptions;
                IIndex index = (IIndex)indexList.get(i);
                if ("Yes".equals(index.getUserProperty(ASYNC_INDEX))) {
                    indexOptions = tableDSOptions + " asyncindex = yes";
                }
                if (indexOptions.length() > 0) {
                    indexOptions = "(" + indexOptions + ")";
                }
                if (!useSQL) {
                    codeSegment.addSourceCode("modify " + tableName + indexOptions + "; \n").indent();
                    this.createSingleIndex(codeSegment, table, index);
                } else {
                    this.createSingleIndexSQL(codeSegment, table, index);
                }
                if (useSQL) continue;
                codeSegment.unIndent();
                codeSegment.addSourceCode("run; \n");
            }
            codeSegment.unIndent().addSourceCode("quit; \n\n").genRCSetCall("&syserr");
            if (useSQL) {
                codeSegment.genRCSetCall("&sqlrc");
            }
        }
        return codeSegment;
    }

    public ICodeSegment createSingleIndexSQL(ICodeSegment codeSegment, IPhysicalTable table, IIndex index) throws CodegenException, BadLibraryDefinitionException {
        String indexName = this.getIndexName(codeSegment, index, false);
        List lColumns = index.getColumnsList();
        if (lColumns.size() > 0) {
            codeSegment.addSourceCode("create ");
            if (index.isUnique()) {
                codeSegment.addSourceCode("unique ");
            }
        } else {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoColumnsOnIndex.msg.txt"), null);
        }
        codeSegment.addSourceCode("index " + indexName + " on ").addSourceCode(table.getFullNameQuotedAsNeeded(codeSegment) + " ");
        String indexColumns = codeSegment.makeColumnList(lColumns, false, "                ", false, ", ", "", codeSegment.isQuoting(), "", false);
        codeSegment.addSourceCode("(" + indexColumns + ")");
        codeSegment.addSourceCode(";\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment genTableDelete(ICodeSegment codeSegment, boolean isView, String tableName, String passwordOptions) throws BadLibraryDefinitionException, CodegenException, RemoteException, ServerException, MdException, BadServerDefinitionException {
        if (this.isDeleteTableSupported()) {
            codeSegment.genSQLTableDelete(tableName, passwordOptions, isView);
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment dropIndexSQL(ICodeSegment codeSegment, IPhysicalTable table, String commandFile, String filter) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        List indexList = table.getIndexesList();
        if (indexList == null) {
            return codeSegment;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            int n = i + 1;
            codeSegment.addSourceCode("data _null_;\n").addSourceCode(" set " + commandFile);
            if (!filter.equals("")) {
                codeSegment.addSourceCode("(where=(" + filter + "))");
            }
            codeSegment.addSourceCode(" end=eof;\n");
            codeSegment.addSourceCode(" if _n_=" + n + " then \n").addSourceCode(" do;\n").addSourceCode("   if scan(command,1)='index' and scan(command,2)='delete' then\n").addSourceCode("   do;\n").addSourceCode("     call execute('proc sql;');\n").addSourceCode("     call execute('drop index '||scan(command,3)||' from '||trim(left(libname))||'.'||trim(left(member))||';');\n").addSourceCode("   end;\n").addSourceCode(" end;\n").addSourceCode("if eof then call execute('quit;');\n").addSourceCode("run; \n");
        }
        return codeSegment;
    }
}

