/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.dbmstypes.SASType;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SASSPDSType
extends SASType {
    public SASSPDSType() {
        this.setTruncateSupport(true);
        this.setPassThroughSupport(true);
        this.setPassthruUsedForDropIndexes(false);
        this.setConstraintSupport(false);
    }

    @Override
    public int getDBMSTypeID() {
        return 15;
    }

    @Override
    public String getDBMSTypeName() {
        return "SAS SPDS";
    }

    public ICodeSegment loadWithUpsert(ICodeSegment codeSegment, IPhysicalTable table, boolean genJobStatus, String tableOptions, ITransformTableOptions transformTableOptions) throws CodegenException, BadLibraryDefinitionException {
        codeSegment.addSectionComment(RB.getStringResource("SASSPDSType.Update.msg.notrans")).genPercentPutStatement(RB.getStringResource("SASSPDSType.Update.note.sasmacro.notrans")).addSourceCode("\n");
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        StringBuffer gen_opts = new StringBuffer();
        gen_opts.append(" UNIQUESAVE=REP ");
        gen_opts.append(transformTableOptions.getTableOptions(codeSegment.getCurrentServer()));
        gen_opts.append(" ");
        gen_opts.append(tableOptions);
        codeSegment.addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode(" (").addSourceCode(gen_opts.toString()).addSourceCode(" )").addSourceCode(" \n").addSourceCode("            data = &etls_lastTable (&etls_tableOptions) force; \n").addSourceCode("run; \n\n").genRCSetCall("&syserr");
        return codeSegment;
    }

    @Override
    public ICodeSegment genBeginSelectAllFromConnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        String nickName = this.getNickName(codeSegment, table);
        if (nickName == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        if (nickName.length() > 0) {
            codeSegment.addSourceCode("select * from connection to ").addSourceCode(nickName).addSourceCode("\n(\n").indent();
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genBeginSelectAllFromConnect(ICodeSegment codeSegment, IPhysicalTable table, StringBuffer columnCode) throws CodegenException {
        String nickName = this.getNickName(codeSegment, table);
        if (nickName == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        if (nickName.length() > 0) {
            codeSegment.addSourceCode("select\n").indent().addSourceCode(columnCode).unIndent().addSourceCode("\nfrom connection to ").addSourceCode(nickName).addSourceCode("\n(\n").indent();
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genEndSelectAllFromConnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        String nickName = this.getNickName(codeSegment, table);
        if (nickName == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        if (nickName.length() > 0) {
            codeSegment.addSourceCode("\n);\n").unIndent().addSourceCode("\n").genRCSetCall("&sqlrc");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genDisconnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        String nickName = this.getNickName(codeSegment, table);
        if (nickName == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        if (nickName.length() > 0) {
            codeSegment.addSourceCode("disconnect from " + nickName + "; \n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genExecuteBegin(ICodeSegment codeSegment, IPhysicalTable table, String prefix) {
        codeSegment.addSourceCode(this.getExecuteBegin(prefix).toString()).indent();
        return codeSegment;
    }

    @Override
    public StringBuffer getExecuteBegin(String prefix) {
        StringBuffer code = new StringBuffer();
        code.append(prefix + "execute \n").append(prefix + "( \n");
        return code;
    }

    @Override
    public ICodeSegment genExecuteEnd(ICodeSegment codeSegment, IPhysicalTable table, String prefix) throws CodegenException {
        if (this.getNickName(codeSegment, table) == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        codeSegment.unIndent().addSourceCode(prefix + ") by " + this.getNickName(codeSegment, table) + "; \n\n");
        codeSegment.genRCSetCall("&sqlrc");
        return codeSegment;
    }

    public ICodeSegment loadWithTruncate(ICodeSegment codeSegment, IPhysicalTable table, List matchColumnList, boolean unmappedEqMissingInUpdate, List unmappedColumnList, String additionalTableOptions, boolean inParallel, Integer parallelgroup, boolean createIndexesPriorToLoad, boolean createIndexesAfterLoad, List indexList) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String libname = table.getCodeGenLibrary(codeSegment.getCurrentServer()).getLibref();
        String tableName = table.getTableName(codeSegment.isQuoting(), false);
        codeSegment.addSectionComment(RB.getStringResource("SASSPDSType.Truncate.msg.notrans")).genPercentPutStatement(RB.getStringResource("SASSPDSType.Truncate.note.sasmacro.notrans")).addSourceCode("\n");
        codeSegment.addSourceCode("proc spdo lib=");
        codeSegment.addSourceCode(libname + ";\n");
        codeSegment.addSourceCode("   truncate " + tableName);
        codeSegment.addSourceCode(";\n");
        codeSegment.addSourceCode("quit;\n");
        codeSegment.genRCSetCall("&sqlrc");
        return codeSegment;
    }

    public void createIndexes(ICodeSegment codeSegment, boolean inParallel, Integer parallelgroup, List indexList, boolean createIndexesSelected, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        if (indexList.size() <= 0) {
            return;
        }
        if (inParallel) {
            codeSegment.addSectionComment(RB.getStringResource("SASSPDSType.CreateParallelIndex.msg.notrans"));
        } else {
            codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.CreateIndex.msg.notrans"));
        }
        if (createIndexesSelected) {
            codeSegment.addCommentLine(RB.getStringResource("SASSPDSType.RecreateIndex.msg.notrans")).addSourceCode("\n");
        }
        if (inParallel) {
            codeSegment.genPercentPutStatement(RB.getStringResource("SASSPDSType.CreateParallelIndex.note.sasmacro.notrans"));
        } else {
            codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.CreateIndex.note.sasmacro.notrans"));
        }
        String libname = table.getCodeGenLibrary(codeSegment.getCurrentServer()).getLibref();
        String tableName = table.getTableName(codeSegment.isQuoting(), false);
        String modifyLine = "";
        modifyLine = inParallel ? "modify " + tableName + " (asyncindex=YES); \n" : "modify " + tableName + " ; \n";
        codeSegment.addSourceCode("proc datasets lib = " + libname + " nolist; \n").addSourceCode(modifyLine);
        int multipleCounter = 0;
        boolean groupTogether = false;
        if (parallelgroup == 0) {
            groupTogether = true;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            if (inParallel && !groupTogether) {
                if (multipleCounter == parallelgroup) {
                    codeSegment.addSourceCode(modifyLine);
                    multipleCounter = 0;
                }
                ++multipleCounter;
            }
            IIndex i_index = (IIndex)indexList.get(i);
            String indexName = this.getIndexName(codeSegment, i_index, false);
            List lColumns = i_index.getColumnsList();
            if (lColumns.size() == 1) {
                Object obj = lColumns.get(0);
                String columnName = "";
                if (obj instanceof String) {
                    columnName = (String)obj;
                } else if (obj instanceof IColumn) {
                    IColumn column = (IColumn)obj;
                    columnName = column.getColumnName(codeSegment);
                }
                if (!columnName.equals(indexName)) {
                    throw new CodegenException(RB.getStringResource("BaseDBMSType.IndexNoMatch.msg.txt"), (IObject)i_index);
                }
                codeSegment.addSourceCode("   index create " + indexName + " ");
            } else if (lColumns.size() > 0) {
                codeSegment.addSourceCode("   index create " + indexName + " = ");
                String indexColumns = codeSegment.makeColumnList(lColumns, false, "                ", false, " ", "", codeSegment.isQuoting(), "", false);
                codeSegment.addSourceCode("(" + indexColumns + ")");
            } else {
                throw new CodegenException(RB.getStringResource("BaseDBMSType.NoColumnsOnIndex.msg.txt"), (IObject)i_index);
            }
            StringBuffer opts = new StringBuffer("");
            if (i_index.isUnique()) {
                opts.append(" unique ");
            }
            if (i_index.isNoMissingValues()) {
                opts.append(" nomiss ");
            }
            if (opts.length() > 1) {
                codeSegment.addSourceCode("/" + opts.toString());
            }
            codeSegment.addSourceCode(";\n");
        }
        codeSegment.addSourceCode("quit; \n\n").genRCSetCall("&syserr");
    }

    public ICodeSegment removeAllRows(ICodeSegment codeSegment, IPhysicalTable table, String additionalTableOptions) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        StringBuffer gen_opts = new StringBuffer();
        String label = this.getDataTableLabel(table);
        if (label.length() > 0) {
            gen_opts.append(CodeSegment.getLabelStatement(label)).append("\n         ");
        }
        gen_opts.append(table.getWriteTableOptions());
        gen_opts.append(" ");
        gen_opts.append(additionalTableOptions);
        StringBuffer table_options = new StringBuffer();
        if (gen_opts.length() > 1) {
            table_options.append("(");
            table_options.append(gen_opts);
            table_options.append(")");
        }
        codeSegment.addSourceCode("data ").addSourceCode(table.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(" ").addSourceCode(table_options.toString()).addSourceCode(";\n").indent();
        super.genscols(codeSegment, table);
        if (table.containsColumnOfType(0)) {
            codeSegment.addSourceCode("array _char{*} _character_;\n");
        }
        if (table.containsColumnOfType(1)) {
            codeSegment.addSourceCode("array _num{*} _numeric_;\n");
        }
        codeSegment.addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        return codeSegment;
    }

    @Override
    public String getSchemaName(IServer currentServer, IPhysicalTable table, boolean quotes) throws BadLibraryDefinitionException {
        ILibrary iLib = table.getCodeGenLibrary(currentServer);
        String schemaName = "";
        if (iLib != null) {
            schemaName = iLib.getLibref().trim();
        }
        return schemaName;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_SPDSTable_Template.xml")));
        optionModel.setUsePropertySet(true);
        optionModel.setSetRole("MACROOPTIONS");
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        IPromptDefinitionValue idxNdef = collection.findDefinition("IDXNAME");
        IPromptDefinitionValue idxWdef = collection.findDefinition("IDXWHERE");
        IPromptDefinitionValue bufNodef = collection.findDefinition("BUFNO");
        IPromptDefinitionValue genMaxdef = collection.findDefinition("GENMAX");
        if (idxNdef != null) {
            idxNdef.getModel().removePromptDefinition(idxNdef);
        }
        if (idxWdef != null) {
            idxWdef.getModel().removePromptDefinition(idxWdef);
        }
        if (bufNodef != null) {
            bufNodef.getModel().removePromptDefinition(bufNodef);
        }
        if (genMaxdef != null) {
            genMaxdef.getModel().removePromptDefinition(genMaxdef);
        }
        collection.insertModel(0, optionModel, "table_options_spds", RB.getStringResource("SASSPDSType.Options.title.txt"));
        return collection;
    }

    @Override
    public ICodeSegment deleteAllRows(ICodeSegment codeSegment, IPhysicalTable table, boolean useTruncate) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String libname = table.getCodeGenLibrary(codeSegment.getCurrentServer()).getLibref();
        String tableName = table.getTableName(codeSegment.isQuoting(), false);
        codeSegment.addSectionComment(RB.getStringResource("SASSPDSType.Truncate.msg.notrans")).genPercentPutStatement(RB.getStringResource("SASSPDSType.Truncate.note.sasmacro.notrans")).addSourceCode("\n");
        codeSegment.addSourceCode("proc spdo lib=");
        codeSegment.addSourceCode(libname + ";\n");
        codeSegment.addSourceCode("   truncate " + tableName);
        codeSegment.addSourceCode(";\n");
        codeSegment.addSourceCode("quit;\n");
        codeSegment.genRCSetCall("&sqlrc");
        return codeSegment;
    }
}

