/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.ODBCOTHERType;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.dbmstypes.SYBASEType;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ODBCSYBASEType
extends SYBASEType {
    @Override
    public ICodeSegment drop(ICodeSegment codeSegment, IPhysicalTable table, boolean setExistMacro) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("%macro etls_deleteTable;\n").indent();
        table.genTableExist(codeSegment, "etls_sybaseExist");
        codeSegment.addSourceCode("%if (&etls_sybaseExist ne 0) %then\n").addSourceCode("%do;\n").indent();
        codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.DropTable.msg.notrans")).genPercentPutStatement(RB.getStringResource("BaseDBMSType.DropTable.note.sasmacro.notrans"));
        codeSegment.addSourceCode("proc sql; \n").indent().addSourceCode("drop table ").addSourceCode(tableName).addSourceCode("; \n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc", false).unIndent().addSourceCode("%end;\n");
        if (setExistMacro) {
            codeSegment.addSourceCode("%let etls_tableExist = 0;\n");
        }
        codeSegment.unIndent().addSourceCode("%mend etls_deleteTable;\n").addSourceCode("%etls_deleteTable;\n\n");
        return codeSegment;
    }

    @Override
    public String getSQLInsertOptions() {
        return "";
    }

    @Override
    public String getConnectionType() {
        return "ODBC";
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        ODBCOTHERType odbc = new ODBCOTHERType();
        return odbc.getTableOptionCollection(model, table);
    }
}

