/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ODBCOTHERType
extends BaseDBMSType {
    @Override
    public int getDBMSTypeID() {
        return 14;
    }

    @Override
    public String getDBMSTypeName() {
        return "Other";
    }

    @Override
    public String getConnectionType() {
        return "ODBC";
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        boolean quoting = codeSegment.isQuoting();
        if (quoting) {
            codeSegment.addSourceCode("drop index \"%trim(%bquote(&etls_indexName))\" on \"%trim(%bquote(&etls_indexTable))\" \n");
        } else {
            codeSegment.addSourceCode("drop index &etls_indexName on &etls_indexTable \n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), true, false, "");
        String dsName = table.getSASTableName();
        String user = "";
        String schemaName = "";
        IDatabaseSchema schema = table.getDatabaseSchema();
        if (schema != null) {
            schemaName = schema.getSchemaName();
        }
        if (dsName != null && dsName.indexOf(46) > 0) {
            user = "\"" + dsName.substring(0, dsName.indexOf(46)) + "\"";
            dsName = dsName.substring(dsName.indexOf(46), dsName.indexOf(46));
        }
        codeSegment.indent().addSourceCode("from \n").addSourceCode("( \n").indent().addSourceCode("select distinct index_name as idxname, \n").addSourceCode("      \"" + tableName + "\" as tabname \n").indent().addSourceCode("from connection to " + this.getNickName(codeSegment, table) + "\n").indent();
        if (schema != null) {
            codeSegment.addSourceCode("(ODBC::SQLStatistics(,\"" + schemaName + "\",\"" + dsName + "\"))").newLine();
        } else {
            codeSegment.addSourceCode("(ODBC::SQLStatistics(,,\"" + dsName + "\"))").newLine();
        }
        codeSegment.addSourceCode("where type ne 0 \n").unIndent().unIndent().unIndent().addSourceCode("); \n").unIndent();
        return codeSegment;
    }

    protected PhysicalTablePromptModel createODBCTableOptionModel(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_ODBCTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        return optionModel;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        this.addODBCModel(collection, model, table);
        collection.setSaveValuesAsStrings(true);
        return collection;
    }

    protected void addODBCModel(PhysicalTablePromptModelCollection collection, IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        collection.addModel(this.createODBCTableOptionModel(model, table), "table_options_odbc", RB.getStringResource("ODBCType.Options.title.txt"));
    }
}

