/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MYSQLType
extends BaseDBMSType {
    private static final String IMPLICIT_UPDATE = "IMPLICIT";
    private static final String PASSTHRU_UPDATE = "PASSTHRU";
    private static final String BY_UPDATE = "BY";
    private static final String KEY_UPDATE = "KEY";

    public MYSQLType() {
        this.setAddKeyDelimiter(",");
        this.setExcludeCOwnFromIndexCreate(false);
    }

    @Override
    public int getDBMSTypeID() {
        return 5;
    }

    @Override
    public String getDBMSTypeName() {
        return "My SQL";
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = DBMSNamesUtil.getTableNamePart(table.getFullNameQuotedAsNeeded(codeSegment, true));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        boolean quoting = codeSegment.isQuoting();
        if (quoting) {
            codeSegment.addSourceCode("drop index \"%trim(%bquote(&etls_indexName))\" on ").addSourceCode(tableName).addSourceCode("\n");
        } else {
            codeSegment.addSourceCode("drop index &etls_indexName on ").addSourceCode(tableName).addSourceCode("\n");
        }
        return codeSegment;
    }

    @Override
    public StringBuffer createFKeyOptions(ICodeSegment codeSegment, StringBuffer code, IKey partnerKey) throws CodegenException, BadLibraryDefinitionException {
        String sColumns = this.makeColumnListInDBMSTypeFormat(codeSegment, partnerKey.getColumnsList());
        if (sColumns.length() > 0) {
            code.append(" (").append(sColumns).append(")");
        }
        return code;
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableNameQ = DBMSNamesUtil.getTableNamePart(table.getFullNameQuotedAsNeeded(codeSegment, true));
        if (tableNameQ == null || tableNameQ.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.indent().addSourceCode("from \n").indent().addSourceCode("( \n").addSourceCode(" select distinct index_name as idxname, \n").addSourceCode("        table_name as tabname \n").indent().addSourceCode(" from connection to ").addSourceCode(this.getNickName(codeSegment, table)).addSourceCode("\n").indent().addSourceCode(" (DBMS::Indexes (\"\", \"\", ");
        codeSegment.addSourceCode(tableNameQ);
        codeSegment.addSourceCode(")) \n").unIndent().unIndent().addSourceCode(");\n").unIndent().unIndent();
        return codeSegment;
    }

    @Override
    public ICodeSegment genMatchingRowsPrelim(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("\n").genPercentPutStatement(RB.getStringResource("BaseDBMSType.KeyNeededForMatching.note.sasmacro.notrans")).addSourceCode("\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment drop(ICodeSegment codeSegment, IPhysicalTable table, boolean setExistMacro) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("%macro etls_deleteTable;\n").indent();
        table.genTableExist(codeSegment, "etls_mySQLExist");
        codeSegment.addSourceCode("%if (&etls_mySQLExist ne 0) %then\n").addSourceCode("%do;\n").indent();
        codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.DropTable.msg.notrans")).genPercentPutStatement(RB.getStringResource("BaseDBMSType.DropTable.note.sasmacro.notrans"));
        codeSegment.addSourceCode("proc sql; \n").indent().addSourceCode("drop table ").addSourceCode(tableName).addSourceCode("; \n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc", false).unIndent().addSourceCode("%end;\n");
        if (setExistMacro) {
            codeSegment.addSourceCode("%let etls_tableExist = 0;\n");
        }
        codeSegment.unIndent().addSourceCode("%mend etls_deleteTable;\n").addSourceCode("%etls_deleteTable;\n\n");
        return codeSegment;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_MySQLTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = super.getTableOptionCollection(model, table);
        collection.addModel(optionModel, "table_options_mysql", RB.getStringResource("MYSQLType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }
}

