/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.dbmstypes.SASType;
import com.sas.etl.models.other.IServer;
import java.util.HashMap;
import java.util.Map;

public class DBMSTypeFactory {
    private static DBMSTypeFactory s_instance;
    private static final String DEFAULT_DBMS = "SAS";
    private static final IDBMSType DEFAULT_TYPE;
    private Map m_typeMap = new HashMap();

    private DBMSTypeFactory() {
        this.m_typeMap.put("DEFAULT", new BaseDBMSType());
    }

    public static DBMSTypeFactory getInstance() {
        if (s_instance == null) {
            s_instance = new DBMSTypeFactory();
        }
        return s_instance;
    }

    public static IDBMSType getDefaultType() {
        return DEFAULT_TYPE;
    }

    public IDBMSType getDBMSType(IPhysicalTable tbl) {
        return this.getDBMSType(tbl.getLibrary());
    }

    public IDBMSType getDBMSType(String sDBMSType) {
        String sDBMSTypeClass = this.getClass().getPackage().getName() + "." + sDBMSType.toUpperCase() + "Type";
        IDBMSType dbmsType = (IDBMSType)this.m_typeMap.get(sDBMSTypeClass);
        if (dbmsType != null) {
            return dbmsType;
        }
        try {
            Class<?> clsDBMSType = Class.forName(sDBMSTypeClass);
            dbmsType = (IDBMSType)clsDBMSType.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (dbmsType == null) {
            dbmsType = new BaseDBMSType();
        }
        this.m_typeMap.put(sDBMSTypeClass, dbmsType);
        return dbmsType;
    }

    public IDBMSType getDBMSType(ILibrary library) {
        return this.getDBMSType(this.getDBMSTypeName(library));
    }

    private String getDBMSTypeName(ILibrary library) {
        if (library == null) {
            return DEFAULT_DBMS;
        }
        IDatabaseSchema schema = library.getDatabaseSchema();
        String sEngine = library.getEngine();
        if ("SASIOLA".equalsIgnoreCase(sEngine)) {
            return "SASIOLA";
        }
        if ("SASHDAT".equalsIgnoreCase(sEngine)) {
            return "SASHDAT";
        }
        if ("SASIOIMP".equalsIgnoreCase(sEngine)) {
            return "SASIOIMP";
        }
        if ("SASIOPI".equalsIgnoreCase(sEngine)) {
            return "SASIOPI";
        }
        if ("SASIOHWQ".equalsIgnoreCase(sEngine)) {
            return "SASIOHWQ";
        }
        if ("CAS".equalsIgnoreCase(sEngine)) {
            return "CAS";
        }
        if ("SASIOMGO".equalsIgnoreCase(sEngine)) {
            return "SASIOMGO";
        }
        if ("SASIOSLF".equalsIgnoreCase(sEngine)) {
            return "SASIOSLF";
        }
        if ("SASIOSNF".equalsIgnoreCase(sEngine)) {
            return "SNOWFLAKE";
        }
        if ("SASIOGBQ".equalsIgnoreCase(sEngine)) {
            return "BIGQUERY";
        }
        if ("SASIOYLB".equalsIgnoreCase(sEngine)) {
            return "YELLOWBRICK";
        }
        if ("SASIOSK".equalsIgnoreCase(sEngine)) {
            return "SPARK";
        }
        if (schema == null) {
            if ("SPDE".equalsIgnoreCase(sEngine)) {
                return "SPDE";
            }
            if ("SASESOCK".equalsIgnoreCase(sEngine)) {
                return "SASESOCK";
            }
            if ("XML".equalsIgnoreCase(sEngine)) {
                return "XML";
            }
            if ("XMLV2".equalsIgnoreCase(sEngine)) {
                return "XMLV2";
            }
            if ("JSON".equalsIgnoreCase(sEngine)) {
                return "JSON";
            }
            return DEFAULT_DBMS;
        }
        IServer[] servers = library.getServers();
        for (int iComponent = 0; iComponent < servers.length; ++iComponent) {
            if (!"SHARE".equals(servers[iComponent].getClassIdentifier())) continue;
            return "REMOTE";
        }
        IServer lDeployedComponent = schema.getServer();
        if (lDeployedComponent == null) {
            return DEFAULT_DBMS;
        }
        String sProductName = lDeployedComponent.getProductName();
        if (sProductName.equals("SASSPDS")) {
            int major = lDeployedComponent.getMajor();
            int minor = lDeployedComponent.getMinor();
            if (major < 4 || major <= 4 && minor < 3) {
                return "SASSPDSPRE43";
            }
        } else if (sProductName.equals("SAS Federation Server")) {
            return "FEDERATIONSERVER";
        }
        return sProductName;
    }

    public String getDBMSProductName(ILibrary library) throws BadLibraryDefinitionException {
        if (library == null) {
            return DEFAULT_DBMS;
        }
        IDatabaseSchema schema = library.getDatabaseSchema();
        if (schema == null) {
            String sEngine = library.getEngine();
            if ("SPDE".equalsIgnoreCase(sEngine)) {
                return "SPDE";
            }
            if ("SASESOCK".equalsIgnoreCase(sEngine)) {
                return "SASESOCK";
            }
            if ("XML".equalsIgnoreCase(sEngine)) {
                return "XML";
            }
            if ("XMLV2".equalsIgnoreCase(sEngine)) {
                return "XMLV2";
            }
            if ("JSON".equalsIgnoreCase(sEngine)) {
                return "JSON";
            }
            return DEFAULT_DBMS;
        }
        IServer mdoServer = schema.getServer();
        if (mdoServer == null) {
            throw new BadLibraryDefinitionException(RB.getStringResource("DBMSTypeFactory.SchemaHasNoServer.msg.txt"));
        }
        return mdoServer.getProductName();
    }

    static {
        DEFAULT_TYPE = new SASType();
    }
}

