/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.BaseDBMSType;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CASType
extends BaseDBMSType {
    private static final Pattern TAG_PATTERN = Pattern.compile("(?i)\\b(tag)\\s*=\\s*(\\\"[^\\\"]*\\\"|[^\\s*]*)");
    private static final String LIBRARY_TAG = "TAG";

    public CASType() {
        this.setConstraintSupport(false);
        this.setIndexSupport(false);
        this.setDeleteAllRowsSupport(false);
        this.setTruncateSupport(false);
    }

    @Override
    public void updateTransformTableOptions(ITransformTableOptions options, boolean isSource) {
        try {
            options.getOptionModel().setOptionValue("Compress", (Object)"NO");
            options.getOptionModel().setOptionValue("Duplicate", (Object)"NO");
            options.getOptionModel().setOptionValue("Promote", (Object)"YES");
        }
        catch (RemoteException remoteException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (ServiceException serviceException) {
        }
        catch (ServerConnectionException serverConnectionException) {
        }
        catch (MdException mdException) {
            // empty catch block
        }
    }

    public String getTag(IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String tag = this.parseOptions(table.getReadTableOptions(false), TAG_PATTERN);
        if (tag == null || tag.trim().length() == 0) {
            IProperty libraryPath = table.getLibraryForUseInJob().findOption(LIBRARY_TAG);
            tag = libraryPath != null ? libraryPath.getDefaultValue() : table.getLibref(null);
        } else {
            String[] opt = tag.split("=");
            if (opt.length == 2) {
                tag = opt[1].replaceAll("\"", "").trim();
            }
        }
        return tag;
    }

    public String getTag(ILibrary library) {
        String tag = "";
        IProperty[] libraryOptions = library.getOptions();
        for (int i = 0; i < libraryOptions.length; ++i) {
            Matcher oMatcher;
            if (!"OPTIONSTRING".equalsIgnoreCase(libraryOptions[i].getPropertyName()) || !(oMatcher = TAG_PATTERN.matcher(libraryOptions[i].getDefaultValue())).find()) continue;
            String option = oMatcher.group(0);
            String[] nameValue = option.split("\\=");
            tag = nameValue[1].replaceAll("\"", "").trim();
            return tag;
        }
        return tag;
    }

    private String parseOptions(String sTableOptions, Pattern pattern) {
        Matcher oMatcher = pattern.matcher(sTableOptions);
        return oMatcher.find() ? oMatcher.group(0) : "";
    }

    @Override
    public String getDBNULL(ICodeSegment codeSegment, IPhysicalTable table) {
        return "";
    }

    @Override
    public int getDBMSTypeID() {
        return 33;
    }

    @Override
    public String getDBMSTypeName() {
        return "SAS Cloud Analytic Services Server";
    }

    protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
        return PromptUtils.combinePromptGroups(this.getPromptGroupGeneral(), PromptUtils.getPromptGroupFromFile(this.getClass().getResource("res/Options_CASTable_Template.xml")));
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(this.getPromptGroup());
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        PhysicalTablePromptModelCollection collection = new PhysicalTablePromptModelCollection();
        collection.addModel(optionModel, "table_options_cas", RB.getStringResource("CASType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        IPromptDefinitionValue definition = collection.findDefinition("Promote");
        if (null != definition) {
            definition.setValue("YES");
        }
        return collection;
    }

    public ICodeSegment createIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        return codeSegment;
    }

    @Override
    public ICodeSegment createIndexes2(ICodeSegment codeSegment, IPhysicalTable table, List altIndexList, String altTableName) throws CodegenException, BadLibraryDefinitionException {
        return codeSegment;
    }

    @Override
    public ICodeSegment dropIndexes(ICodeSegment codeSegment, IPhysicalTable table, IIndex keepIndex) throws CodegenException, BadLibraryDefinitionException {
        return codeSegment;
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        return codeSegment;
    }

    @Override
    public ICodeSegment createConstraints(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        return codeSegment;
    }
}

