/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.businessrule.impl;

import com.sas.etl.models.DISUsageVersion;
import com.sas.etl.models.IModel;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlow;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowVersion;
import com.sas.etl.models.data.businessrule.impl.BaseBusinessRuleFlowVersion;
import com.sas.etl.models.data.impl.AbstractDataObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.OMRProperty;
import com.sas.services.information.metadata.businessruleflow.BRMDAVUnavailableException;
import com.sas.services.information.metadata.businessruleflow.BusinessRuleFlowInterface;
import com.sas.services.information.metadata.businessruleflow.BusinessRuleFlowSmartObject;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BaseBusinessRuleFlow
extends AbstractDataObject
implements IBusinessRuleFlow {
    private UsageVersion _usageVersion;
    private Map<DISUsageVersion, IBusinessRuleFlowVersion> _versions;
    private IBusinessRuleFlowVersion _preferred;
    private Map<String, String> _properties;
    private Map<String, Integer> _columnLengths;

    public BaseBusinessRuleFlow(String id, IModel model) {
        super(id, model);
        this.setArchitectureVersionNumber(BusinessRuleFlowSmartObject.CURRENT_VERSION);
        this._versions = new TreeMap<DISUsageVersion, IBusinessRuleFlowVersion>();
        this._properties = new HashMap<String, String>();
        this._columnLengths = new HashMap<String, Integer>();
    }

    @Override
    public String getPublicType() {
        return "BusinessRuleFlow";
    }

    @Override
    public String getOMRType() {
        return "Transformation";
    }

    @Override
    public IBusinessRuleFlowVersion getDefaultVersion() {
        return this._preferred;
    }

    protected void setDefaultVersion(IBusinessRuleFlowVersion version) {
        this._preferred = version;
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return this._usageVersion;
    }

    @Override
    protected void setArchitectureVersionNumber(UsageVersion version) {
        this._usageVersion = version;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }

    @Override
    public Map<String, Integer> getDefaultColumnLengths() {
        return this._columnLengths;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        ChildServerInterface child = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            child = server.newChild(true);
            String key = this.getID() + "/" + "Transformation";
            BusinessRuleFlowInterface ruleFlow = (BusinessRuleFlowInterface)child.fetch(key, false);
            String defaultVersion = ruleFlow.defaultVersion();
            this._properties.clear();
            List objProps = ruleFlow.getObjectProperties();
            for (int i = 0; i < objProps.size(); ++i) {
                Object obj = objProps.get(i);
                if (!(obj instanceof OMRProperty)) continue;
                OMRProperty p = (OMRProperty)obj;
                this._properties.put(p.getName(), p.getValue());
            }
            this._columnLengths.clear();
            for (Map.Entry s : ruleFlow.getRulesFiredColumnLengths().entrySet()) {
                this._columnLengths.put((String)s.getKey(), (Integer)s.getValue());
            }
            List versions = ruleFlow.getVersions();
            for (String version : versions) {
                BaseBusinessRuleFlowVersion bv = new BaseBusinessRuleFlowVersion(this);
                bv.setVersion(BaseBusinessRuleFlow.convertToUsageVersion(version));
                this.addVersion(bv);
                if (!ObjectComparator.isEqual(defaultVersion, bv.getVersion().toString())) continue;
                bv.loadFromOMR();
                this.setDefaultVersion(bv);
            }
        }
        catch (BRMDAVUnavailableException e) {
            try {
                if (child != null) {
                    child.destroy();
                }
            }
            catch (ServiceException e2) {
                throw new MdException((Throwable)e2);
            }
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        finally {
            try {
                if (child != null) {
                    child.destroy();
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public IBusinessRuleFlowVersion[] getVersions() {
        ArrayList<IBusinessRuleFlowVersion> versions = new ArrayList<IBusinessRuleFlowVersion>(this._versions.values());
        Collections.reverse(versions);
        return versions.toArray(new IBusinessRuleFlowVersion[versions.size()]);
    }

    private void addVersion(IBusinessRuleFlowVersion version) {
        if (this._versions.containsKey(version.getVersion())) {
            return;
        }
        this._versions.put(version.getVersion(), version);
    }

    private void removeVersion(IBusinessRuleFlowVersion version) {
        if (!this._versions.containsKey(version.getVersion())) {
            return;
        }
        this._versions.remove(version.getVersion());
    }

    @Override
    public IBusinessRuleFlowVersion findVersion(DISUsageVersion version) {
        return this._versions.get(version);
    }

    public static DISUsageVersion convertToUsageVersion(String strVersion) {
        String[] numbers = strVersion.split("\\.");
        DISUsageVersion version = null;
        version = numbers.length == 2 ? new DISUsageVersion(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1])) : (numbers.length == 3 ? new DISUsageVersion(Integer.parseInt(numbers[0]), Integer.parseInt(numbers[1]), Integer.parseInt(numbers[2])) : new DISUsageVersion(1, 0));
        return version;
    }
}

